#pragma once

#include <fstream>
#include <string>
#include <sstream>
#include <iostream>
#include <vector>
#include "glm/glm.hpp"
#include "glm/gtc/matrix_transform.hpp"
#include "GL/glew.h" 

using namespace std;


typedef struct Point3D 
{
	// points, normals and texture coordinates
	glm::vec3 p, n;
	glm::vec2 t;

	Point3D(const glm::vec3 &p, const glm::vec3 &n, const glm::vec2 &t)
	{
		this->p = p;
		this->n = n;
		this->t = t;
	}
} Point3D;


// generic mesh with points, normals and texture coordinates
class CMesh 
{
public:
    vector <Point3D> point_list;
    vector <GLuint> index_list;

    CMesh(const vector<Point3D> &v, const vector<GLuint> &i)
    {
		point_list = v;
		index_list = i;
        toGPU();
    }

    void render() 
    {
        // render the mesh
        glBindVertexArray(VAO);
        glDrawElements(GL_TRIANGLES, index_list.size(), GL_UNSIGNED_INT, 0);
        glBindVertexArray(0);
    }

private:
    // gpu data
    GLuint VAO, VBO, EBO;

    void toGPU()
    {
		// create vao
        glGenVertexArrays(1, &VAO);
        glGenBuffers(1, &VBO);
        glGenBuffers(1, &EBO);

		// setting vao as current
        glBindVertexArray(VAO);

		// uploading vertexes
        glBindBuffer(GL_ARRAY_BUFFER, VBO);
        glBufferData(GL_ARRAY_BUFFER, point_list.size() * sizeof(Point3D), &point_list[0], GL_STATIC_DRAW);  

		// uploading indexes
		glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, EBO);
        glBufferData(GL_ELEMENT_ARRAY_BUFFER, index_list.size() * sizeof(GLuint), &index_list[0], GL_STATIC_DRAW);

		// indicate vertex
        glEnableVertexAttribArray(0);	
        glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, sizeof(Point3D), (GLvoid*)NULL);

		// indicate normals
        glEnableVertexAttribArray(1);	
        glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, sizeof(Point3D), (GLvoid*)offsetof(Point3D, n));

        // indicate texture coordinates
        glEnableVertexAttribArray(2);	
        glVertexAttribPointer(2, 2, GL_FLOAT, GL_FALSE, sizeof(Point3D), (GLvoid*)offsetof(Point3D, t));

		// un bind
        glBindVertexArray(0);
    }

};
