#version 330 core


in vec2 outTex;
in vec3 outNormal;
in vec4 outPosition;

out vec4 vFragColor;

uniform vec2  resolution;
uniform float audioSampleData[512];

void getAmplitudeForXPos(in float xPos, out float audioAmplitude)
{
	   float perfectSamplePosition = 255.0 * xPos / resolution.x;
		int leftSampleIndex = int (floor (perfectSamplePosition));
		int rightSampleIndex = int (ceil (perfectSamplePosition));
		audioAmplitude = mix (audioSampleData[leftSampleIndex], audioSampleData[rightSampleIndex], fract(perfectSamplePosition));
}

#define THICKNESS 0.02

// To know what each 'if' does, read the enum of the beginning of the main program
void main()
{
	float y = gl_FragCoord.y / resolution.y;
		float amplitude = 0.0;
		getAmplitudeForXPos (gl_FragCoord.x, amplitude);

		// Centers & Reduces Wave Amplitude
		amplitude = 0.035 + amplitude / 2.5;
			float r = abs(THICKNESS / (amplitude-y));

			if (r - abs(r * 0.2) < 0.6f) discard;

        vFragColor = vec4 (r - abs(r * 0.2), r - abs(r * 0.2), r - abs(r * 0.2), r - abs(r * 0.2));

}