/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part15rgb;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.Bob;
import abyss.lunarengine.gfx.Object2D;
import abyss.lunarengine.gfx.PolarBear;
import abyss.lunarengine.gfx.Tools2D;
import abyss.lunarengine.gfx.Triangle;
import abyss.lunarengine.sinatra.Sinatra;
import abyss.parallelmultiverse.part15rgb.SinusBobs;
import java.util.Arrays;

public class PartRGB
extends APart {
    public static final int RENDERMETHOD_NOTHING = -1;
    public static final int RENDERMETHOD_HEXAGON = 0;
    public static final int RENDERMETHOD_SINGLEBLOCKS = 1;
    public static final int RENDERMETHOD_BLOCKS = 2;
    public static final int RENDERMETHOD_BOBS = 3;
    public int bobOffset;
    public int renderMethod;
    public double hexagonMorphRadius;
    public double hexagonMorphCenterRadius;
    public double hexagonMorphAngle;
    private static final int SHIFT = 12;
    private static final int BLOCKSIZE = 32;
    private double radius;
    private double centerR;
    private double centerA;
    private static int box_x;
    private static int box_y;
    private static int box1_x;
    private static int box1_y;
    private static int box2_x;
    private static int box2_y;
    private static int box3_x;
    private static int box3_y;
    private static int blockCountX;
    private static int blockCountY;
    private static int[][] blocks;
    private static final int ANIM_SIZE = 200;
    private int animIndex;
    public final int[] colorsNormal = new int[]{986895, 986895, 0x2F0F0F, 0x3F0F0F, 0x5F0F0F, 0x7F0F0F, 0x5F0F0F, 0x2F0F0F, 986895, 986895, 0x1F1F2F, 0x3F3F3F, 0x4F4F5F, 0x6F6F7F, 0x4F4F5F, 0x2F2F2F, 986895, 3088143, 5189391, 7290639, 9391887, 6242063, 4136719, 986895, 986895, 991007, 995103, 995119, 999215, 1003327, 999215, 995103, 991007, 986895, 0x1F0F1F, 0x2F1F2F, 5189439, 6238031, 5189439, 4136751, 0x1F0F1F, 986895, 0x1F1F0F, 0x2F2F1F, 0x3F3F1F, 0x4F4F2F, 0x3F3F1F, 0x1F1F1F, 986895, 991007, 0x1F2F2F, 0x1F3F3F, 0x2F4F4F, 0x1F3F3F, 0x1F1F1F, 986895, 0x1F0F1F, 0x2F0F2F, 4132655, 5181231, 6229807, 6229807, 7278383, 8326943, 0x8F0F0F, 10428175, 11480847, 12537615, 12545807, 13598479, 14659343, 15716111, 0xFFFF0F, 15720207, 14667535, 13614863, 12562191, 12558095, 11505423, 10452751, 9400079, 8347407, 7294735, 6242063, 6242063, 5189391, 4136719, 3088143, 0x1F0F1F, 0x3F0F3F, 0x4F1F4F, 0x6F2F6F, 0x8F4F8F, 0xAF6FAF, 0xBF9FBF, 0xDFBFDF, 0xFFFFFF, 0xDFCFCF, 13610911, 11505535, 10448735, 9391935, 7290655, 6237983, 4136719, 5189391, 7290655, 8347439, 10452799, 11509583, 13614959, 0xDFDF8F, 0xFFFFAF, 14667663, 12558207, 0x9F6F6F, 9391967, 7290703, 5189439, 0x2F1F2F, 3084063, 4136751, 5185327, 6233903, 7282479, 8331055, 9383743, 10436431, 11489119, 0xBF5F5F, 13594463, 14647151, 15699839, 0xFFAF9F, 0xFFCFBF, 0xFFEFDF, 0xFFEFDF, 0xFFEFCF, 0xFFEFCF, 15720367, 0xDFDF9F, 12570495, 11517807, 9416543, 7315279, 5214015, 4161327, 0x2F6F2F, 2055983, 999215, 995119, 991007, 991007, 995119, 999231, 2047823, 2051935, 0x1F5F5F, 3104623, 4157311, 4161423, 5214111, 6262703, 7315391, 8368063, 10469327, 11522015, 12574703, 0xDFEFFF, 12570607, 0xAFAFDF, 0x9F9FDF, 9404367, 9400255, 9396143, 9392031, 9387935, 0x8F3F8F, 8335215, 7282527, 6233919, 6233903, 5181215, 0x3F0F0F};
    public int[] colorsDark;
    public int[] colors = new int[]{986895, 986895, 0x2F0F0F, 0x3F0F0F, 0x5F0F0F, 0x7F0F0F, 0x5F0F0F, 0x2F0F0F, 986895, 986895, 0x1F1F2F, 0x3F3F3F, 0x4F4F5F, 0x6F6F7F, 0x4F4F5F, 0x2F2F2F, 986895, 3088143, 5189391, 7290639, 9391887, 6242063, 4136719, 986895, 986895, 991007, 995103, 995119, 999215, 1003327, 999215, 995103, 991007, 986895, 0x1F0F1F, 0x2F1F2F, 5189439, 6238031, 5189439, 4136751, 0x1F0F1F, 986895, 0x1F1F0F, 0x2F2F1F, 0x3F3F1F, 0x4F4F2F, 0x3F3F1F, 0x1F1F1F, 986895, 991007, 0x1F2F2F, 0x1F3F3F, 0x2F4F4F, 0x1F3F3F, 0x1F1F1F, 986895, 0x1F0F1F, 0x2F0F2F, 4132655, 5181231, 6229807, 6229807, 7278383, 8326943, 0x8F0F0F, 10428175, 11480847, 12537615, 12545807, 13598479, 14659343, 15716111, 0xFFFF0F, 15720207, 14667535, 13614863, 12562191, 12558095, 11505423, 10452751, 9400079, 8347407, 7294735, 6242063, 6242063, 5189391, 4136719, 3088143, 0x1F0F1F, 0x3F0F3F, 0x4F1F4F, 0x6F2F6F, 0x8F4F8F, 0xAF6FAF, 0xBF9FBF, 0xDFBFDF, 0xFFFFFF, 0xDFCFCF, 13610911, 11505535, 10448735, 9391935, 7290655, 6237983, 4136719, 5189391, 7290655, 8347439, 10452799, 11509583, 13614959, 0xDFDF8F, 0xFFFFAF, 14667663, 12558207, 0x9F6F6F, 9391967, 7290703, 5189439, 0x2F1F2F, 3084063, 4136751, 5185327, 6233903, 7282479, 8331055, 9383743, 10436431, 11489119, 0xBF5F5F, 13594463, 14647151, 15699839, 0xFFAF9F, 0xFFCFBF, 0xFFEFDF, 0xFFEFDF, 0xFFEFCF, 0xFFEFCF, 15720367, 0xDFDF9F, 12570495, 11517807, 9416543, 7315279, 5214015, 4161327, 0x2F6F2F, 2055983, 999215, 995119, 991007, 991007, 995119, 999231, 2047823, 2051935, 0x1F5F5F, 3104623, 4157311, 4161423, 5214111, 6262703, 7315391, 8368063, 10469327, 11522015, 12574703, 0xDFEFFF, 12570607, 0xAFAFDF, 0x9F9FDF, 9404367, 9400255, 9396143, 9392031, 9387935, 0x8F3F8F, 8335215, 7282527, 6233919, 6233903, 5181215, 0x3F0F0F};
    private int colorIndex;
    private int colorIndex2;
    private int colorIndex3;
    private int colorIndex4;
    private int color1;
    private int color2;
    private int color3;
    private int color4;
    private int colorRotateSleep;
    private Tools2D tools2D;
    private Sinatra sinatraBlocksX1;
    private Sinatra sinatraBlocksX2;
    private Sinatra sinatraBlocksY1;
    private Sinatra sinatraBlocksY2;
    private Sinatra sinatraBlock1X1;
    private Sinatra sinatraBlock1X2;
    private Sinatra sinatraBlock1Y1;
    private Sinatra sinatraBlock1Y2;
    private Sinatra sinatraBlock2X1;
    private Sinatra sinatraBlock2X2;
    private Sinatra sinatraBlock2Y1;
    private Sinatra sinatraBlock2Y2;
    private Sinatra sinatraBlock3X1;
    private Sinatra sinatraBlock3X2;
    private Sinatra sinatraBlock3Y1;
    private Sinatra sinatraBlock3Y2;
    private Sinatra sinatraTurn;
    private Triangle[] hexagon;
    private SinusBobs[] sinusBobs;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartRGB partRGB = new PartRGB();
            partRGB.precalc();
            partRGB.initialize();
            LunarEngine.setActivePart(partRGB);
            partRGB.renderMethod = 3;
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public PartRGB() {
        blockCountX = Screen.screenSizeX / 32;
        blockCountY = Screen.screenSizeY / 32;
        blocks = new int[blockCountX * blockCountY * 2][200];
    }

    public void precalc() {
        this.tools2D = new Tools2D();
        this.colorsDark = new int[this.colorsNormal.length];
        int color = 0;
        for (int i = 0; i < this.colorsNormal.length; ++i) {
            color = this.colorsNormal[i];
            this.colorsDark[i] = color = (color & 0xFEFEFE) >> 1;
        }
        this.sinatraBlocksX1 = Sinatra.getInstance(new double[]{1800.0, 3.0, 175.0, 0.2, 0.0, 360.0, 200.0, 1.0, 0.0, 360.0, 190.0, 1.0, 0.0, 180.0});
        this.sinatraBlocksX2 = Sinatra.getInstance(new double[]{720.0, 2.0, 100.0, 0.5, 0.0, 360.0, 27.0, 2.0, 0.0, 360.0});
        this.sinatraBlocksY1 = Sinatra.getInstance(new double[]{1800.0, 2.0, 100.0, 0.2, 0.0, 360.0, 100.0, 1.0, 0.0, 360.0});
        this.sinatraBlocksY2 = Sinatra.getInstance(new double[]{720.0, 2.0, 100.0, 0.5, 0.0, 360.0, 100.0, 2.0, 0.0, 360.0});
        this.sinatraBlock1X1 = Sinatra.getInstance(new double[]{3600.0, 2.0, 200.0, 0.5, 0.0, 360.0, 100.0, 0.4, 0.0, 360.0});
        this.sinatraBlock1X2 = Sinatra.getInstance(new double[]{1800.0, 2.0, 150.0, 0.6, 0.0, 360.0, 50.0, 0.4, 0.0, 360.0});
        this.sinatraBlock1Y1 = Sinatra.getInstance(new double[]{1800.0, 2.0, 150.0, 0.4, 0.0, 360.0, 80.0, 0.2, 0.0, 360.0});
        this.sinatraBlock1Y2 = Sinatra.getInstance(new double[]{720.0, 2.0, 50.0, 1.0, 0.0, 360.0, 50.0, 0.5, 0.0, 360.0});
        this.sinatraBlock2X1 = Sinatra.getInstance(new double[]{1200.0, 2.0, 200.0, 0.6, 0.0, 360.0, 100.0, 0.3, 0.0, 360.0});
        this.sinatraBlock2X2 = Sinatra.getInstance(new double[]{3600.0, 2.0, 120.0, 0.3, 0.0, 360.0, 106.0, 0.5, 0.0, 360.0});
        this.sinatraBlock2Y1 = Sinatra.getInstance(new double[]{3600.0, 2.0, 150.0, 0.3, 0.0, 360.0, 116.0, 0.5, 0.0, 360.0});
        this.sinatraBlock2Y2 = Sinatra.getInstance(new double[]{1800.0, 3.0, 60.0, 0.8, 0.0, 360.0, 60.0, 0.4, 0.0, 360.0, 62.0, 0.6, 0.0, 360.0});
        this.sinatraBlock3X1 = Sinatra.getInstance(new double[]{3600.0, 3.0, 50.0, 0.4, 0.0, 360.0, 100.0, 0.3, 0.0, 360.0, 50.0, 1.0, 0.0, 360.0});
        this.sinatraBlock3X2 = Sinatra.getInstance(new double[]{1800.0, 2.0, 100.0, 0.2, 0.0, 360.0, 100.0, 0.4, 0.0, 360.0});
        this.sinatraBlock3Y1 = Sinatra.getInstance(new double[]{1800.0, 2.0, 100.0, 0.4, 0.0, 360.0, 50.0, 1.0, 0.0, 360.0});
        this.sinatraBlock3Y2 = Sinatra.getInstance(new double[]{900.0, 2.0, 50.0, 0.8, 0.0, 360.0, 30.0, 0.4, 0.0, 360.0});
        this.sinatraTurn = Sinatra.getInstance(new double[]{3600.0, 3.0, 50.0, 1.0, 0.0, 360.0, 25.0, 0.5, 0.0, 360.0, 25.0, 0.6, 0.0, 360.0});
        for (int i = 0; i < 200; ++i) {
            for (int y = 0; y < blockCountY; ++y) {
                for (int x = 0; x < blockCountX; ++x) {
                    int xm = x * 32;
                    int ym = y * 32;
                    PartRGB.blocks[(x + y * PartRGB.blockCountX) * 2][i] = xm + ym * Screen.screenSizeX;
                    double a = PolarBear.calcAlpha(xm -= Screen.screenCenterX, ym -= Screen.screenCenterY);
                    if (xm < 0) {
                        a -= 180.0;
                    }
                    double r = PolarBear.calcRadius(xm, ym);
                    r = r * 96.5 / 100.0;
                    xm = PolarBear.calcXint(r, a += 0.15 * (double)i - 20.0);
                    ym = PolarBear.calcYint(r, a);
                    if ((xm += Screen.screenCenterX) < 0 || xm > Screen.screenSizeX - 32 || (ym += Screen.screenCenterY) < 0 || ym > Screen.screenSizeY - 32) {
                        PartRGB.blocks[(x + y * PartRGB.blockCountX) * 2][i] = -1;
                        continue;
                    }
                    PartRGB.blocks[(x + y * PartRGB.blockCountX) * 2 + 1][i] = xm + ym * Screen.screenSizeX;
                }
            }
        }
        this.hexagon = this.createHexagon();
        this.sinusBobs = new SinusBobs[6];
        this.sinusBobs[0] = new SinusBobs(13598479, 0);
        this.sinusBobs[0].sinatraBobsX1 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[0].sinatraBobsX2 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[0].sinatraBobsY1 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 180.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[0].sinatraBobsY2 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 180.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[0].deltaX1 = 12;
        this.sinusBobs[0].deltaX2 = 15;
        this.sinusBobs[0].deltaY1 = 10;
        this.sinusBobs[0].deltaY2 = 14;
        this.sinusBobs[1] = new SinusBobs(9416543, 42);
        this.sinusBobs[1].sinatraBobsX1 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[1].sinatraBobsX2 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[1].sinatraBobsY1 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 180.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[1].sinatraBobsY2 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 180.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[1].deltaX1 = 10;
        this.sinusBobs[1].deltaX2 = 13;
        this.sinusBobs[1].deltaY1 = 12;
        this.sinusBobs[1].deltaY2 = 16;
        this.sinusBobs[2] = new SinusBobs(0x6F6F7F, 84);
        this.sinusBobs[2].sinatraBobsX1 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[2].sinatraBobsX2 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[2].sinatraBobsY1 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 180.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[2].sinatraBobsY2 = Sinatra.getInstance(new double[]{2048.0, 3.0, 1.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 180.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[2].deltaX1 = 14;
        this.sinusBobs[2].deltaX2 = 15;
        this.sinusBobs[2].deltaY1 = 8;
        this.sinusBobs[2].deltaY2 = 12;
        this.sinusBobs[3] = new SinusBobs(2047823, 0);
        this.sinusBobs[3].sinatraBobsX1 = Sinatra.getInstance(new double[]{2048.0, 3.0, 90.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[3].sinatraBobsX2 = Sinatra.getInstance(new double[]{2048.0, 3.0, 90.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[3].sinatraBobsY1 = Sinatra.getInstance(new double[]{2048.0, 3.0, 123.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 180.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[3].sinatraBobsY2 = Sinatra.getInstance(new double[]{2048.0, 3.0, 123.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 180.0, 0.3515625, 0.0, 360.0});
        this.sinusBobs[3].deltaX1 = 12;
        this.sinusBobs[3].deltaX2 = 15;
        this.sinusBobs[3].deltaY1 = 10;
        this.sinusBobs[3].deltaY2 = 14;
        this.sinusBobs[4] = new SinusBobs(6233903, 0);
        this.sinusBobs[4].sinatraBobsX1 = Sinatra.getInstance(new double[]{2048.0, 3.0, 90.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 180.0});
        this.sinusBobs[4].sinatraBobsX2 = Sinatra.getInstance(new double[]{2048.0, 3.0, 90.0, 0.703125, 0.0, 360.0, 160.0, 0.17578125, 0.0, 360.0, 200.0, 0.3515625, 0.0, 180.0});
        this.sinusBobs[4].sinatraBobsY1 = Sinatra.getInstance(new double[]{3600.0, 3.0, 127.0, 0.5, 0.0, 360.0, 199.0, 0.5, 180.0, 360.0, 199.0, 0.3, 0.0, 180.0});
        this.sinusBobs[4].sinatraBobsY2 = Sinatra.getInstance(new double[]{3600.0, 3.0, 127.0, 0.5, 0.0, 360.0, 199.0, 0.5, 180.0, 360.0, 199.0, 0.3, 0.0, 180.0});
        this.sinusBobs[4].deltaX1 = 10;
        this.sinusBobs[4].deltaX2 = 13;
        this.sinusBobs[4].deltaY1 = 12;
        this.sinusBobs[4].deltaY2 = 16;
        this.sinusBobs[5] = new SinusBobs(0x555555, 0);
        this.sinusBobs[5].sinatraBobsX1 = Sinatra.getInstance(new double[]{3600.0, 3.0, 199.0, 0.2, 0.0, 360.0, 128.0, 0.3, 0.0, 360.0, 22.0, 2.0, 0.0, 360.0});
        this.sinusBobs[5].sinatraBobsX2 = Sinatra.getInstance(new double[]{3600.0, 3.0, 199.0, 0.2, 0.0, 360.0, 128.0, 0.3, 0.0, 360.0, 22.0, 2.0, 0.0, 360.0});
        this.sinusBobs[5].sinatraBobsY1 = Sinatra.getInstance(new double[]{3600.0, 3.0, 61.0, 0.5, 0.0, 360.0, 112.0, 0.5, 180.0, 360.0, 199.0, 0.3, 0.0, 360.0});
        this.sinusBobs[5].sinatraBobsY2 = Sinatra.getInstance(new double[]{3600.0, 3.0, 61.0, 0.5, 0.0, 360.0, 112.0, 0.5, 180.0, 360.0, 199.0, 0.3, 0.0, 360.0});
        this.sinusBobs[5].deltaX1 = 14;
        this.sinusBobs[5].deltaX2 = 15;
        this.sinusBobs[5].deltaY1 = 8;
        this.sinusBobs[5].deltaY2 = 12;
    }

    public void initialize() {
        this.colorIndex = 0;
        this.colorIndex2 = 10;
        this.colorIndex3 = 20;
        this.colorIndex4 = 30;
        this.animIndex = 0;
        Triangle.tools2D = this.tools2D;
        this.hexagonMorphRadius = 350.0;
        this.hexagonMorphCenterRadius = 280.0;
        this.hexagonMorphAngle = 45.0;
        this.sinatraBlocksX1.setIndex(0);
        this.sinatraBlocksX2.setIndex(0);
        this.sinatraBlocksY1.setIndex(0);
        this.sinatraBlocksY2.setIndex(0);
        this.sinatraBlock1X1.setIndex(0);
        this.sinatraBlock1X2.setIndex(0);
        this.sinatraBlock1Y1.setIndex(0);
        this.sinatraBlock1Y2.setIndex(0);
        this.sinatraBlock2X1.setIndex(0);
        this.sinatraBlock2X2.setIndex(0);
        this.sinatraBlock2Y1.setIndex(0);
        this.sinatraBlock2Y2.setIndex(0);
        this.sinatraBlock3X1.setIndex(0);
        this.sinatraBlock3X2.setIndex(0);
        this.sinatraBlock3Y1.setIndex(0);
        this.sinatraBlock3Y2.setIndex(0);
        this.sinatraTurn.setIndex(0);
        this.bobOffset = 0;
    }

    public void vbi() {
        box_x = this.sinatraBlocksX1.getNextValue(1) + this.sinatraBlocksX2.getNextValue(1) + Screen.screenCenterX;
        box_y = this.sinatraBlocksY1.getNextValue(1) + this.sinatraBlocksY2.getNextValue(1) + Screen.screenCenterY;
        box1_x = this.sinatraBlock1X1.getNextValue(1) + this.sinatraBlock1X2.getNextValue(1) + Screen.screenCenterX - 100;
        box1_y = this.sinatraBlock1Y1.getNextValue(1) + this.sinatraBlock1Y2.getNextValue(1) + Screen.screenCenterY - 50;
        box2_x = this.sinatraBlock2X1.getNextValue(1) + this.sinatraBlock2X2.getNextValue(1) + Screen.screenCenterX + 100;
        box2_y = this.sinatraBlock2Y1.getNextValue(1) + this.sinatraBlock2Y2.getNextValue(1) + Screen.screenCenterY + 30;
        box3_x = this.sinatraBlock3X1.getNextValue(1) + this.sinatraBlock3X2.getNextValue(1) + Screen.screenCenterX - 200;
        box3_y = this.sinatraBlock3Y1.getNextValue(1) + this.sinatraBlock3Y2.getNextValue(1) + Screen.screenCenterY - 200;
        this.animIndex = this.sinatraTurn.getNextValue(1) + 100;
        switch (this.renderMethod) {
            case 0: {
                this.morphHexagon();
                for (int i = 0; i < this.hexagon.length; ++i) {
                    this.hexagon[i].rotateVBI();
                }
                break;
            }
            case 3: {
                for (int i = this.bobOffset; i < this.bobOffset + 3; ++i) {
                    this.sinusBobs[i].vbi();
                }
                break;
            }
        }
        if (--this.colorRotateSleep < 0) {
            this.colorRotateSleep = 3;
            this.color1 = this.colors[this.colorIndex];
            if (++this.colorIndex == this.colors.length) {
                this.colorIndex = 0;
            }
            this.color2 = this.colors[this.colorIndex2];
            if (++this.colorIndex2 == this.colors.length) {
                this.colorIndex2 = 0;
            }
            this.color3 = this.colors[this.colorIndex3];
            if (++this.colorIndex3 == this.colors.length) {
                this.colorIndex3 = 0;
            }
            this.color4 = this.colors[this.colorIndex4];
            if (++this.colorIndex4 == this.colors.length) {
                this.colorIndex4 = 0;
            }
        }
    }

    public void worker1() {
        int[] screendataRender = LunarEngine.screendataToWork2;
        int[] screendataWorking = LunarEngine.screendataToWork;
        this.tools2D.screendataWorking = screendataWorking;
        for (int i = 0; i < blocks.length; ++i) {
            int pixelIndex;
            if ((pixelIndex = blocks[i++][this.animIndex]) < 0) continue;
            for (int indexY = pixelIndex; indexY < Screen.screenSizeX * 32 + pixelIndex; indexY += Screen.screenSizeX) {
                for (int index = indexY; index < indexY + 32; ++index) {
                    int pixelOld = screendataRender[blocks[i][this.animIndex] + index - pixelIndex];
                    int pixel = screendataRender[index];
                    screendataWorking[index] = pixelOld != pixel ? (pixelOld & 0xFEFEFE) + (pixel & 0xFEFEFE) >> 1 : (pixelOld &= 0xFCFCFC) + pixelOld + pixelOld >> 2;
                }
            }
        }
        switch (this.renderMethod) {
            case 0: {
                this.drawHexagon(screendataWorking);
                break;
            }
            case 1: {
                this.drawBlocksSingle(screendataWorking);
                break;
            }
            case 2: {
                this.drawBlocks(screendataWorking);
                break;
            }
            case 3: {
                this.drawBobs(screendataWorking);
            }
        }
    }

    private void drawHexagon(int[] screendataWorking) {
        Object2D.tools2D.screendataWorking = screendataWorking;
        block5: for (int i = 0; i < this.hexagon.length; ++i) {
            this.hexagon[i].rotateCALC();
            switch (i) {
                case 0: 
                case 1: {
                    this.hexagon[i].drawFilled(Screen.screenCenterX, Screen.screenCenterY, this.color1);
                    continue block5;
                }
                case 2: 
                case 3: {
                    this.hexagon[i].drawFilled(Screen.screenCenterX, Screen.screenCenterY, this.color2);
                    continue block5;
                }
                case 4: 
                case 5: {
                    this.hexagon[i].drawFilled(Screen.screenCenterX, Screen.screenCenterY, this.color3);
                }
            }
        }
    }

    private void drawBlocksSingle(int[] screendataWorking) {
        int y;
        for (y = box1_y * Screen.screenSizeX; y < (box1_y + 100) * Screen.screenSizeX; y += Screen.screenSizeX) {
            Arrays.fill(screendataWorking, box1_x + y, box1_x + y + 100, this.color1);
        }
        for (y = box2_y * Screen.screenSizeX; y < (box2_y + 100) * Screen.screenSizeX; y += Screen.screenSizeX) {
            Arrays.fill(screendataWorking, box2_x + y, box2_x + y + 100, this.color2);
        }
        for (y = box3_y * Screen.screenSizeX; y < (box3_y + 100) * Screen.screenSizeX; y += Screen.screenSizeX) {
            Arrays.fill(screendataWorking, box3_x + y, box3_x + y + 100, this.color3);
        }
    }

    private void drawBlocks(int[] screendataWorking) {
        for (int y = box_y; y < box_y + 100; ++y) {
            int offset = y * Screen.screenSizeX + box_x;
            Arrays.fill(screendataWorking, offset, offset + 100, this.color1);
            offset = y * Screen.screenSizeX + Screen.screenSizeX - box_x;
            Arrays.fill(screendataWorking, offset, offset + 100, this.color2);
            offset = (Screen.screenSizeY - 1 - y) * Screen.screenSizeX + Screen.screenSizeX - box_x;
            Arrays.fill(screendataWorking, offset, offset + 100, this.color3);
            offset = (Screen.screenSizeY - 1 - y) * Screen.screenSizeX + box_x;
            Arrays.fill(screendataWorking, offset, offset + 100, this.color4);
        }
    }

    private void morphHexagon() {
        double angle1 = 0.0;
        double angle2 = 60.0;
        double centerAtemp = this.centerA;
        if (this.radius < this.hexagonMorphRadius) {
            this.radius += 1.0;
        } else if (this.radius > this.hexagonMorphRadius) {
            this.radius -= 1.0;
        }
        if (this.centerR < this.hexagonMorphCenterRadius) {
            this.centerR += 1.0;
        } else if (this.centerR > this.hexagonMorphCenterRadius) {
            this.centerR -= 1.0;
        }
        if (this.centerA < this.hexagonMorphAngle) {
            this.centerA += 1.0;
        } else if (this.centerA > this.hexagonMorphAngle) {
            this.centerA -= 1.0;
        }
        int centerX = 0;
        int centerY = 0;
        for (int i = 0; i < 6; ++i) {
            if ((i & 1) == 0) {
                centerX = PolarBear.calcXint(this.centerR, centerAtemp);
                centerY = PolarBear.calcYint(this.centerR, centerAtemp);
                centerAtemp += 120.0;
            }
            this.hexagon[i].vo[0][0] = centerX << 12;
            this.hexagon[i].vo[0][1] = centerY << 12;
            this.hexagon[i].vo[0][2] = 0;
            this.hexagon[i].vo[1][0] = PolarBear.calcXint(this.radius, angle1) << 12;
            this.hexagon[i].vo[1][1] = PolarBear.calcYint(this.radius, angle1) << 12;
            this.hexagon[i].vo[1][2] = 0;
            this.hexagon[i].vo[2][0] = PolarBear.calcXint(this.radius, angle2) << 12;
            this.hexagon[i].vo[2][1] = PolarBear.calcYint(this.radius, angle2) << 12;
            this.hexagon[i].vo[2][2] = 0;
            this.hexagon[i].turnAlpha = 2.0;
            angle1 += 60.0;
            angle2 += 60.0;
        }
    }

    private void drawBobs(int[] screendataWorking) {
        Bob.screendataToWork = screendataWorking;
        for (int i = this.bobOffset; i < this.bobOffset + 3; ++i) {
            this.sinusBobs[i].render();
        }
    }

    private Triangle[] createHexagon() {
        Triangle[] triangles = new Triangle[6];
        for (int i = 0; i < 6; ++i) {
            triangles[i] = new Triangle();
            triangles[i].vo = new int[3][3];
            triangles[i].to = new int[3][3];
            triangles[i].vo[0][0] = 0;
            triangles[i].vo[0][1] = 0;
            triangles[i].vo[0][2] = 0;
            triangles[i].vo[1][0] = 0;
            triangles[i].vo[1][1] = 0;
            triangles[i].vo[1][2] = 0;
            triangles[i].vo[2][0] = 0;
            triangles[i].vo[2][1] = 0;
            triangles[i].vo[2][2] = 0;
            triangles[i].turnAlpha = 1.0;
        }
        return triangles;
    }

    public void worker2() {
        Screen.screenClear(LunarEngine.screendataToReset, 0);
    }

    public void rotateBuffers() {
        this.rotateBuffers5();
    }
}

