/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part14lightningfields;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.parallelmultiverse.part14lightningfields.LightningQuad;

public class PartLightningFields
extends APart {
    public LightningQuad[] objQuad;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartLightningFields partLightningFields = new PartLightningFields();
            ((APart)partLightningFields).precalc();
            partLightningFields.initialize();
            LunarEngine.setActivePart(partLightningFields);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public void precalc() {
        this.objQuad = new LightningQuad[8];
        this.objQuad[0] = this.createLightningQuad(-1300, -100, 7, 0, 280, 1.0, 0.0, 0x777777, 0x555555, 0x494949);
        this.objQuad[1] = this.createLightningQuad(0, 800, 0, -6, 180, -1.0, -0.03, 1670552, 1203055, 1203055);
        this.objQuad[2] = this.createLightningQuad(1300, -800, -6, 4, 220, 0.4, -0.1, 7154432, 0x522000, 0x522000);
        this.objQuad[3] = this.createLightningQuad(1300, 0, -4, 0, 250, -0.4, 0.03, 0x848484, 0x626262, 0x464646);
        this.objQuad[4] = this.createLightningQuad(-1300, 300, 6, 0, 250, -0.5, -0.1, 12943616, 9330176, 5650688);
        this.objQuad[5] = this.createLightningQuad(1000, 800, -5, -4, 220, -0.8, 0.04, 8324612, 5768195, 3015199);
        this.objQuad[6] = this.createLightningQuad(-1300, -800, 6, 4, 180, 0.75, 0.05, 4398340, 4398340, 4398340);
        this.objQuad[7] = this.createLightningQuad(300, -900, -3, 5, 200, 0.6, -0.2, 2270665, 1670552, 1336442);
    }

    private LightningQuad createLightningQuad(int posX, int posY, int deltaX, int deltaY, int objSize, double alpha, double beta, int border, int fill1, int fill2) {
        LightningQuad lightningQuad = new LightningQuad(posX, posY, deltaX, deltaY);
        lightningQuad.vo = new int[4][3];
        lightningQuad.to = new int[4][3];
        lightningQuad.vo[0][0] = -objSize << 12;
        lightningQuad.vo[0][1] = -objSize << 12;
        lightningQuad.vo[0][2] = 0;
        lightningQuad.vo[1][0] = objSize << 12;
        lightningQuad.vo[1][1] = -objSize << 12;
        lightningQuad.vo[1][2] = 0;
        lightningQuad.vo[2][0] = objSize << 12;
        lightningQuad.vo[2][1] = objSize << 12;
        lightningQuad.vo[3][2] = 0;
        lightningQuad.vo[3][0] = -objSize << 12;
        lightningQuad.vo[3][1] = objSize << 12;
        lightningQuad.vo[3][2] = 0;
        lightningQuad.turnAlpha = alpha;
        lightningQuad.turnBeta = beta;
        lightningQuad.colorBorder = border;
        lightningQuad.colorFill1 = fill1;
        lightningQuad.colorFill2 = fill2;
        return lightningQuad;
    }

    public void vbi() {
        for (int i = 0; i < this.objQuad.length; ++i) {
            this.objQuad[i].vbi();
        }
    }

    public void worker2() {
        for (int i = 0; i < this.objQuad.length; ++i) {
            if (!this.objQuad[i].enabled) continue;
            this.objQuad[i].tools2D.screendataWorking = this.objQuad[i].drawToRgbBuffer ? LunarEngine.screendataToWork2 : LunarEngine.screendataToWork3;
            this.objQuad[i].rotateCALC();
            this.objQuad[i].drawFilled();
        }
    }

    public void worker3() {
        Screen.screenClear(LunarEngine.screendataToReset, 0);
    }

    public void rotateBuffers() {
        this.rotateBuffers5();
    }
}

