/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part12eyewave;

import abyss.lunarengine.APart;
import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.LunarEngineTools;
import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.Object2D;
import abyss.lunarengine.gfx.Tools2D;
import abyss.lunarengine.sinatra.Sinatra;
import abyss.parallelmultiverse.common.Quad2;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Vector;

public class PartEyeWave
extends APart {
    public int renderScreen;
    private static final int SHIFT = 12;
    private Tools2D tools2D;
    private int eyeballX;
    private int eyeballY;
    private int pointsX;
    private int pointsY;
    private BufferedImage bufferedImage;
    private int[] eyeball;
    private Vector<Quad2> vecQuads;
    private Object2D object2D;
    private Sinatra sinatraX;
    private Sinatra sinatraY;

    public static void main(String[] args) {
        try {
            LunarEngine.initializeEngine();
            PartEyeWave partEyeWave = new PartEyeWave();
            ((APart)partEyeWave).precalc();
            ((APart)partEyeWave).initialize();
            LunarEngine.setActivePart(partEyeWave);
            LunarEngine.startEngine();
        }
        catch (Throwable throwable) {
            LunarEngine.throwableHandler(throwable);
        }
    }

    public void precalc() {
        int x;
        int y;
        this.tools2D = new Tools2D();
        Image imageEyeball = LunarEngineTools.createImage((Component)jFrame, "data/Eyeball.png");
        this.eyeballX = imageEyeball.getWidth(null);
        this.eyeballY = imageEyeball.getHeight(null);
        this.bufferedImage = new BufferedImage(this.eyeballX, this.eyeballY, 1);
        this.eyeball = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        this.bufferedImage.getGraphics().drawImage(imageEyeball, 0, 0, jFrame);
        imageEyeball = null;
        this.bufferedImage = null;
        this.sinatraX = Sinatra.getInstance(new double[]{3600.0, 3.0, 40.0, 0.5, 0.0, 360.0, 15.0, 1.2, 0.0, 360.0, 20.0, 2.0, 0.0, 360.0});
        this.sinatraY = Sinatra.getInstance(new double[]{1800.0, 3.0, 40.0, 0.6, 0.0, 360.0, 20.0, 1.0, 0.0, 360.0, 15.0, 2.0, 0.0, 360.0});
        this.object2D = new Object2D();
        this.pointsX = this.eyeballX + 1;
        this.pointsY = this.eyeballY + 1;
        this.object2D.vo = new int[this.pointsX * this.pointsY][3];
        this.object2D.to = new int[this.pointsX * this.pointsY][3];
        this.object2D.alpha = 185.0;
        this.object2D.beta = 130.0;
        this.object2D.gamma = 65.0;
        this.object2D.turnAlpha = 0.08;
        this.object2D.turnGamma = -0.02;
        int size = 8;
        for (y = 0; y < this.pointsY; ++y) {
            for (x = 0; x < this.pointsX; ++x) {
                this.object2D.vo[y * this.pointsX + x][0] = x * 8 - this.eyeballX * 8 / 2 << 12;
                this.object2D.vo[y * this.pointsX + x][2] = y * 8 - this.eyeballY * 8 / 2 << 12;
            }
        }
        this.vecQuads = new Vector();
        for (y = 0; y < this.eyeballY; ++y) {
            for (x = 0; x < this.eyeballX; ++x) {
                this.vecQuads.add(new Quad2(this.object2D.to[y * this.pointsX + x], this.object2D.to[y * this.pointsX + x + 1], this.object2D.to[(y + 1) * this.pointsX + x + 1], this.object2D.to[(y + 1) * this.pointsX + x], this.eyeball[y * this.eyeballY + x]));
            }
        }
    }

    public void initialize() {
        this.sinatraX.setIndex(0);
        this.sinatraY.setIndex(0);
        Object2D.tools2D = this.tools2D;
        this.object2D.focus1 = 50;
        this.object2D.focus2 = 900;
        this.renderScreen = 2;
        Quad2.tools2D = this.tools2D;
        Quad2.steps = 30;
    }

    public void vbi() {
        if (this.object2D.focus1 < 1040) {
            this.object2D.focus1 += 5;
        }
        this.sinatraX.getNextValue(3);
        this.sinatraY.getNextValue(4);
        for (int y = 0; y < this.pointsY; ++y) {
            int sinusY = this.sinatraY.getNextDeltaValue(10);
            this.sinatraX.resetDeltaIndex();
            for (int x = 0; x < this.pointsX; ++x) {
                this.object2D.vo[y * this.pointsX + x][1] = -(this.sinatraX.getNextDeltaValue(8) + sinusY) << 12;
            }
        }
        this.object2D.rotateVBI();
    }

    public void worker1() {
        this.object2D.rotateCALC();
        this.tools2D.screendataWorking = this.renderScreen == 1 ? LunarEngine.screendataToWork : LunarEngine.screendataToWork2;
        for (int i = 0; i < this.vecQuads.size(); ++i) {
            this.vecQuads.get(i).drawFilled();
        }
    }

    public void worker3() {
        Screen.screenClear(LunarEngine.screendataToReset, 0);
    }

    public void rotateBuffers() {
        this.rotateBuffers5();
    }
}

