/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.part01textintro;

import abyss.lunarengine.LunarEngine;
import abyss.lunarengine.Screen;
import abyss.parallelmultiverse.part01textintro.FontIntro;

public class Textline {
    private FontIntro font;
    private char[] text;
    private int center;
    private int textlineYPos;
    private int[] colorTable;
    private volatile int colorIndex;
    private int colorIndexMove;
    private volatile double xFactor;
    private double xFactorMax;
    private double xFactorDelta = 0.0;
    private volatile double movePos;
    private double moveSpeed;
    private int delay1;
    private int delay2;

    public Textline(FontIntro font, String text, int textlineYPos, int textlineXPos, double moveSpeed, int delay1, int delay2) {
        this.font = font;
        this.font.useColor = true;
        this.textlineYPos = textlineYPos;
        this.xFactorMax = 1.0;
        this.moveSpeed = moveSpeed;
        this.movePos = textlineXPos;
        if (this.movePos >= 0.0) {
            this.movePos = textlineXPos + Screen.screenSizeX;
        }
        this.delay1 = delay1;
        this.delay2 = delay2;
        this.text = (text.length() & 1) == 1 ? (text + " ").toCharArray() : text.toCharArray();
        this.center = this.text.length >> 1;
        this.colorIndexMove = 1;
        this.colorTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.colorTable[i] = i + (i << 8) + (i << 16);
        }
    }

    public void vbi() {
        this.colorIndex += this.colorIndexMove;
        if (this.colorIndex == 0 || this.colorIndex == 254) {
            this.colorIndexMove = 0;
        }
        this.movePos += this.moveSpeed;
        if (--this.delay1 == 0) {
            this.xFactorDelta = 0.015;
            this.moveSpeed /= 20.0;
        }
        if (this.xFactor < this.xFactorMax) {
            this.xFactor += this.xFactorDelta;
        }
        if (--this.delay2 == 0) {
            this.colorIndexMove = -2;
            this.xFactorMax = 8.0;
            this.moveSpeed *= 40.0;
        }
    }

    public void render() {
        int pos1 = 0;
        int pos2 = 0;
        for (int i = 0; i < this.center; ++i) {
            this.font.color = this.colorTable[this.colorIndex];
            this.font.render(this.text[this.center + i], pos1 + (int)this.movePos, this.textlineYPos, LunarEngine.screendataToWork);
            this.font.render(this.text[this.center - 1 - i], -(pos2 += (int)(this.xFactor * (double)(this.font.getCharWidth(this.text[this.center - 1 - i]) + 10))) + (int)this.movePos, this.textlineYPos, LunarEngine.screendataToWork);
            pos1 += (int)(this.xFactor * (double)(this.font.getCharWidth(this.text[this.center + i]) + 10));
        }
    }
}

