/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.common;

import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.Point3D;
import abyss.lunarengine.tools.Random;

public class PointSpread
extends Point3D {
    public int deltaX;
    public int deltaY;
    public static int bobsize;

    public PointSpread(int x, int y, int z, int data) {
        super(x, y, z, data);
        this.shiftLeft();
        this.dx = this.sx >> 12;
        this.dy = this.sy >> 12;
        this.dz = this.sz >> 12;
        this.deltaX = this.getRandomDelta();
        if (this.deltaX < -8192 || this.deltaX > 8192) {
            this.deltaY = this.getRandomDelta();
        } else {
            do {
                this.deltaY = this.getRandomDelta();
            } while (this.deltaY >= -8192 && this.deltaY <= 8192);
        }
    }

    public void move() {
        this.sx += this.deltaX;
        this.sy += this.deltaY;
        this.dx = this.sx >> 12;
        this.dy = this.sy >> 12;
        if (this.sx < 0 || this.sx > Screen.screenSizeX - 32 << 12) {
            this.enabled = false;
            if (this.deltaY > 0 && this.deltaY < 180) {
                this.enabled = false;
            } else {
                this.sx -= this.deltaX;
                this.deltaX = -this.deltaX >> 1;
            }
        }
        if (this.sy < 0 && this.deltaY < 0) {
            this.enabled = false;
            this.sy -= this.deltaY;
            this.deltaY = -this.deltaY;
        } else if (this.sy > Screen.screenSizeY - bobsize << 12) {
            this.enabled = false;
            this.sy -= this.deltaY;
            this.deltaY = -this.deltaY >> 1;
        }
    }

    private int getRandomDelta() {
        return (int)(Random.random() * 106496.0 - 53248.0);
    }
}

