/*
 * Decompiled with CFR 0.152.
 */
package abyss.parallelmultiverse.common;

import abyss.lunarengine.gfx.Bob;
import abyss.lunarengine.gfx.LordFader;
import abyss.lunarengine.gfx.Point3D;
import abyss.parallelmultiverse.common.Bobs3D;

public class BobTheBuilder {
    public static final int PERSP_DELTA_Y = 400;

    public static Bobs3D createCuboid(int bobDelta, int objectSizeX, int objectSizeY, int objectSizeZ) {
        Bobs3D bobs3d = new Bobs3D();
        int step = bobDelta;
        for (int z = -(objectSizeZ * step / 2); z < objectSizeZ * step / 2; z += step) {
            int color = 0;
            for (int y = 0; y < objectSizeY * step; y += step) {
                ++color;
                for (int x = -(objectSizeX * step / 2); x < objectSizeX * step / 2; x += step) {
                    bobs3d.addBob(new Point3D(x, y + 400, z, color % 6));
                }
            }
        }
        bobs3d.createArrays();
        return bobs3d;
    }

    public static Bobs3D createObject2(int bobDelta, int objectSize) {
        Bobs3D bobs3d = new Bobs3D();
        int size = 1;
        for (int i = 0; i < objectSize; ++i) {
            BobTheBuilder.bobLine(bobs3d, bobDelta, 0, -size, -size, 0, size, -size, 0);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 1, size, -size, 0, size, size, 0);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 0, size, size, 0, -size, size, 0);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 1, -size, size, 0, -size, -size, 0);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 2, 0, -size, -size, 0, size, -size);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 3, 0, size, -size, 0, size, size);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 2, 0, size, size, 0, -size, size);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 3, 0, -size, size, 0, -size, -size);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 4, -size, 0, -size, size, 0, -size);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 5, size, 0, -size, size, 0, size);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 4, size, 0, size, -size, 0, size);
            BobTheBuilder.bobLine(bobs3d, bobDelta, 5, -size, 0, size, -size, 0, -size);
            size += bobDelta;
        }
        bobs3d.createArrays();
        return bobs3d;
    }

    public static Bobs3D createCubes(int bobDelta, int objectSize) {
        Bobs3D bobs3d = new Bobs3D();
        int color = 0;
        for (int i = objectSize - 18; i < objectSize; i += 6) {
            BobTheBuilder.createCube(bobs3d, bobDelta, i, color++ % 6);
        }
        bobs3d.createArrays();
        return bobs3d;
    }

    private static void createCube(Bobs3D bobs3d, int bobDelta, int size, int bobIndex) {
        BobTheBuilder.addSquareZ(bobs3d, bobDelta, size, -size, bobIndex);
        BobTheBuilder.addSquareZ(bobs3d, bobDelta, size, size, bobIndex);
        BobTheBuilder.addSquareX(bobs3d, bobDelta, size, -size, bobIndex);
        BobTheBuilder.addSquareX(bobs3d, bobDelta, size, size, bobIndex);
        BobTheBuilder.addSquareY(bobs3d, bobDelta, size, -size, bobIndex);
        BobTheBuilder.addSquareY(bobs3d, bobDelta, size, size, bobIndex);
    }

    private static void addSquareZ(Bobs3D bobs3d, int bobDelta, int size, int deltaZ, int bobIndex) {
        int step = bobDelta;
        for (int y = -size * step / 2; y <= size * step / 2; y += step) {
            for (int x = -size * step / 2; x <= size * step / 2; x += step) {
                bobs3d.addBob(new Point3D(x, y, deltaZ * step / 2, bobIndex));
            }
        }
    }

    private static void addSquareX(Bobs3D bobs3d, int bobDelta, int size, int deltaX, int bobIndex) {
        int step = bobDelta;
        for (int y = -size * step / 2; y <= size * step / 2; y += step) {
            for (int z = -size * step / 2; z <= size * step / 2; z += step) {
                bobs3d.addBob(new Point3D(deltaX * step / 2, y, z, bobIndex));
            }
        }
    }

    private static void addSquareY(Bobs3D bobs3d, int bobDelta, int size, int deltaY, int bobIndex) {
        int step = bobDelta;
        for (int x = -size * step / 2; x <= size * step / 2; x += step) {
            for (int z = -size * step / 2; z <= size * step / 2; z += step) {
                bobs3d.addBob(new Point3D(x, deltaY * step / 2, z, bobIndex));
            }
        }
    }

    private static void bobLine(Bobs3D bobs3d, int bobSize, int bobIndex, int x1, int y1, int z1, int x2, int y2, int z2) {
        int posX = x1 << 12;
        int posY = y1 << 12;
        int posZ = z1 << 12;
        int deltaX = x2 - x1 << 12;
        int deltaY = y2 - y1 << 12;
        int deltaZ = z2 - z1 << 12;
        int points = Math.abs(deltaX) > Math.abs(deltaY) ? (Math.abs(deltaX) > Math.abs(deltaZ) ? deltaX / bobSize >> 12 : deltaZ / bobSize >> 12) : (Math.abs(deltaY) > Math.abs(deltaZ) ? deltaY / bobSize >> 12 : deltaZ / bobSize >> 12);
        points = points == 0 ? 1 : Math.abs(points);
        deltaX /= points;
        deltaY /= points;
        deltaZ /= points;
        for (int i = 0; i < points; ++i) {
            bobs3d.addBob(new Point3D(posX >> 12, posY >> 12, posZ >> 12, bobIndex));
            posX += deltaX;
            posY += deltaY;
            posZ += deltaZ;
        }
    }

    public static void reColor(Bob bob, int bobIndex, int color) {
        int pixel = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int rn = 0;
        int gn = 0;
        int bn = 0;
        rn = color >> 16;
        gn = color >> 8 & 0xFF;
        bn = color & 0xFF;
        for (int y = 0; y < bob.bobSizeY; ++y) {
            for (int x = 0; x < bob.bobSizeX; ++x) {
                pixel = bob.bobdata[bobIndex][x + y * bob.bobSizeX];
                r = pixel >> 16 & 0xFF;
                g = pixel >> 8 & 0xFF;
                b = pixel & 0xFF;
                pixel = ((r = r * rn >> 8) << 16) + ((g = g * gn >> 8) << 8) + (b = b * bn >> 8);
                if (pixel > 0) {
                    pixel -= 0x1000000;
                }
                bob.bobdata[bobIndex][x + y * bob.bobSizeX] = pixel;
            }
        }
    }

    public static void reColorFade(Bob bob, int color) {
        int i;
        int[][] bobdata = bob.bobdata;
        bob.bobdata = new int[256][bobdata[0].length];
        for (int z = 0; z < bob.bobSizeX * bob.bobSizeY; ++z) {
            for (i = 0; i < 256; ++i) {
                bob.bobdata[i][z] = bobdata[0][z];
            }
        }
        LordFader fader = new LordFader(color, 0, 256);
        for (i = 0; i < 256; ++i) {
            BobTheBuilder.reColor(bob, i, fader.colors[i]);
        }
    }

    public static Bobs3D createLaser(int bobSize) {
        Bobs3D bobs3d = new Bobs3D();
        int deltaY = -50;
        int headLength1 = 50;
        int headLength2 = 100;
        int r = 20;
        int r2 = 7;
        for (int a = 0; a < 360; a += 20) {
            int x = (int)(Math.cos(Math.PI / 180 * (double)a) * (double)r);
            int z = (int)(Math.sin(Math.PI / 180 * (double)a) * (double)r);
            int x2 = (int)(Math.cos(Math.PI / 180 * (double)a) * (double)r2);
            int z2 = (int)(Math.sin(Math.PI / 180 * (double)a) * (double)r2);
            BobTheBuilder.bobLine(bobs3d, bobSize, 5, 0, 0 + deltaY + 400, 0, x, deltaY - headLength1 + 400, z);
            BobTheBuilder.bobLine(bobs3d, bobSize, 6, x, deltaY - headLength1 + 400, z, x2, deltaY - headLength1 - headLength2 + 400, z2);
        }
        bobs3d.createArrays();
        return bobs3d;
    }
}

