/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.spliner;

import abyss.lunarengine.gfx.Point2D;
import abyss.lunarengine.spliner.SplinerData;

public class Spliner {
    private Point2D[][] points;
    private int splineMode;
    private int size;
    private int surfIndex;
    private int surfIndexVbi;
    private int surfDeltaIndex;
    private Point2D currentPoint;
    private int waveIndex;
    private int waveIndexVbi;
    private int animFrames;
    private int moveMode = 2;

    private Spliner() {
    }

    public static Spliner getInstance(int[] parameter) {
        Spliner spliner = new Spliner();
        spliner.points = spliner.calc(parameter);
        return spliner;
    }

    private Point2D[][] calc(int[] parameter) {
        int i;
        int parameterIndex = 0;
        int wavesize = 0;
        this.splineMode = parameter[parameterIndex++];
        if (this.splineMode > 2) {
            this.splineMode = 0;
        }
        int wavecount = parameter[parameterIndex++];
        SplinerData[] splineData = new SplinerData[wavecount];
        for (i = 0; i < wavecount; ++i) {
            splineData[i] = new SplinerData();
            splineData[i].setSize(parameter[parameterIndex++]);
            splineData[i].setAx(parameter[parameterIndex++]);
            splineData[i].setAy(parameter[parameterIndex++]);
            splineData[i].setBx(parameter[parameterIndex++]);
            splineData[i].setBy(parameter[parameterIndex++]);
            splineData[i].setCx(parameter[parameterIndex++]);
            splineData[i].setCy(parameter[parameterIndex++]);
        }
        if (this.splineMode == 2) {
            wavesize = 0;
            for (i = 0; i < wavecount; ++i) {
                wavesize += splineData[i].getSize();
            }
        } else {
            wavesize = splineData[0].getSize();
        }
        this.size = wavesize;
        if (this.splineMode == 0 || this.splineMode == 2) {
            this.animFrames = 1;
        } else {
            this.animFrames = splineData[1].getSize();
            for (i = 2; i < wavecount; ++i) {
                if (this.animFrames >= splineData[i].getSize()) continue;
                this.animFrames = splineData[i].getSize();
            }
        }
        Point2D[][] wave = new Point2D[this.animFrames][wavesize];
        if (this.splineMode == 0) {
            for (int i2 = 0; i2 < wavesize; ++i2) {
                wave[0][i2] = splineData[0].getNextValue();
            }
        } else if (this.splineMode == 1) {
            for (int w = 0; w < this.animFrames; ++w) {
                Point2D pointA = splineData[1].getNextValue();
                Point2D pointB = splineData[2].getNextValue();
                Point2D pointC = splineData[3].getNextValue();
                splineData[0] = new SplinerData();
                splineData[0].setSize(wavesize);
                splineData[0].setAx(pointA.x);
                splineData[0].setAy(pointA.y);
                splineData[0].setBx(pointB.x);
                splineData[0].setBy(pointB.y);
                splineData[0].setCx(pointC.x);
                splineData[0].setCy(pointC.y);
                for (int i3 = 0; i3 < wavesize; ++i3) {
                    wave[w][i3] = splineData[0].getNextValue();
                }
            }
        } else if (this.splineMode == 2) {
            int index = 0;
            for (int i4 = 0; i4 < wavecount; ++i4) {
                for (int w = 0; w < splineData[i4].getSize(); ++w) {
                    wave[0][index++] = splineData[i4].getNextValue();
                }
            }
        } else {
            throw new RuntimeException("Illegal spline mode");
        }
        return wave;
    }

    public Point2D move(int delta) {
        this.currentPoint = this.points[this.waveIndex][this.surfIndexVbi];
        this.surfIndexVbi += delta;
        if (this.surfIndexVbi >= this.size) {
            if (this.moveMode == 1) {
                this.surfIndexVbi -= this.size;
            } else if (this.moveMode == 2) {
                this.surfIndexVbi = this.size - 1;
            }
        } else if (this.surfIndexVbi < 0) {
            if (this.moveMode == 1) {
                this.surfIndexVbi += this.size;
            } else if (this.moveMode == 2) {
                this.surfIndexVbi = 0;
            }
        }
        return this.currentPoint;
    }

    public void beginRender() {
        this.waveIndex = this.waveIndexVbi;
        this.surfIndex = this.surfIndexVbi;
    }

    public Point2D getNextValue(int delta) {
        this.currentPoint = this.points[this.waveIndex][this.surfIndex];
        this.surfIndex += delta;
        if (this.surfIndex >= this.size) {
            if (this.moveMode == 1) {
                this.surfIndex -= this.size;
            } else if (this.moveMode == 2) {
                this.surfIndex = this.size - 1;
            }
        } else if (this.surfIndex < 0) {
            if (this.moveMode == 1) {
                this.surfIndex += this.size;
            } else if (this.moveMode == 2) {
                this.surfIndex = 0;
            }
        }
        this.surfDeltaIndex = this.surfIndex;
        return this.currentPoint;
    }

    public Point2D getNextDeltaValue(int delta) {
        this.surfDeltaIndex += delta;
        if (this.surfDeltaIndex < 0) {
            this.surfDeltaIndex += this.size;
        } else if (this.surfDeltaIndex >= this.size) {
            this.surfDeltaIndex -= this.size;
        }
        return this.points[this.waveIndex][this.surfDeltaIndex];
    }

    public Point2D getNextWaveDeltaValue(int delta) {
        return this.points[(this.waveIndex + delta) % this.animFrames][this.surfIndex];
    }

    public int getWaveLen() {
        return this.size;
    }

    public void setIndex(int index) {
        this.surfIndex = index;
    }

    public void gotoFirstValue() {
        this.surfIndex = 0;
    }

    public void nextWave() {
        this.waveIndexVbi = this.waveIndexVbi + 1 == this.animFrames ? this.animFrames - 1 : ++this.waveIndexVbi;
    }
}

