/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine.gfx;

import abyss.lunarengine.Screen;
import abyss.lunarengine.gfx.FontFactory;

public class Font {
    protected String characterset;
    protected int height;
    protected int[][] index;
    public int[] fontdata;
    protected int fontWidth;
    public int space = 70;
    public int writeposX;
    public int writeposY;
    public boolean noclipping;

    public Font(String fontname) {
        FontFactory.loadFont(this, fontname);
    }

    public void prepare() {
    }

    public void render(String s, int x, int y, int[] screendataWorking) {
        this.render(s, x, y, screendataWorking, Screen.screenSizeX);
    }

    public void render(String s, int x, int y, int[] screendataWorking, int screenSizeX) {
        this.writeposX = x;
        this.writeposY = y;
        for (int i = 0; i < s.length(); ++i) {
            this.render(s.charAt(i), screendataWorking, screenSizeX);
        }
    }

    private int render(char c, int[] screendataWorking, int screenSizeX) {
        int i = this.characterset.indexOf(c);
        if (i != -1) {
            for (int y = 0; y < this.height; ++y) {
                int pixelPosY = this.writeposY + y;
                int offsetY = pixelPosY * screenSizeX;
                for (int x = 0; x < this.index[i][2]; ++x) {
                    int pixel = this.fontdata[this.index[i][0] + x + (this.index[i][1] + y) * this.fontWidth];
                    int pixelPosX = this.writeposX + x;
                    if ((pixel & 0xFFFFFF) == 0 || !this.noclipping && (pixelPosX < 0 || pixelPosX >= Screen.screenSizeX || pixelPosY < 0 || pixelPosY >= Screen.screenSizeY)) continue;
                    screendataWorking[pixelPosX + offsetY] = pixel;
                }
            }
            this.writeposX += this.index[i][2] + 10;
            return this.index[i][2] + 10;
        }
        for (int y = 0; y < this.height; ++y) {
            int offsetY = (this.writeposY + y) * screenSizeX;
            for (int x = 0; x < this.space; ++x) {
                screendataWorking[this.writeposX + x + offsetY] = 0;
            }
        }
        this.writeposX += this.space;
        return this.space;
    }

    public int render(char c, int x, int y, int[] screendataWorking) {
        this.writeposX = x;
        this.writeposY = y;
        return this.render(c, screendataWorking, Screen.screenSizeX);
    }

    public int render(char c, int x, int y, int[] screendataWorking, int screenSizeX) {
        this.writeposX = x;
        this.writeposY = y;
        return this.render(c, screendataWorking, screenSizeX);
    }

    public int getCharWidth(char c) {
        int i = this.characterset.indexOf(c);
        return i != -1 ? this.index[i][2] : this.space;
    }
}

