/*
 * Decompiled with CFR 0.152.
 */
package abyss.lunarengine;

import abyss.lunarengine.IClock;
import abyss.lunarengine.VBI;
import abyss.lunarengine.VbiThread;

public class VbiClock_Candidate7
extends Thread
implements IClock {
    private boolean enabled = true;
    private int framecount;
    private long framesizeNanos;

    public VbiClock_Candidate7() {
        super(null, null, "LunarEngineClock");
        this.setPriority(10);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long nanotime = System.nanoTime();
        while (this.enabled) {
            try {
                long nanoDelta = (nanotime += this.framesizeNanos) - System.nanoTime();
                if (nanoDelta > 0L) {
                    long sleepMilli = nanoDelta / 1000000L;
                    if (--sleepMilli > 0L) {
                        VbiClock_Candidate7.sleep(sleepMilli);
                    }
                    while (System.nanoTime() < nanotime) {
                    }
                }
                ++this.framecount;
                VbiThread vbiThread = VBI.vbiThread;
                synchronized (vbiThread) {
                    ++VBI.vbiThread.workload;
                    VBI.vbiThread.notify();
                }
                if (!VBI.pause) continue;
                while (VBI.pause) {
                    Thread.sleep(33L);
                }
                nanotime = System.nanoTime();
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Throwable throwable) {
            }
        }
    }

    public void setFrameRate(int fps) {
        this.framesizeNanos = 1000000000 / fps;
    }

    public void terminate() {
        this.interrupt();
        this.enabled = false;
    }
}

