.autoimport

.segment "ZEROPAGE"

IRQ_INIT:				.res 3
IRQ_CALL:				.res 3
IRQ_START_LINE:			.res 1
IRQ_LINE_OFF:			.res 1
IRQ_SPLIT_LIST:			.res 2
IRQ_JUMP:				.res 2
IRQ_SPLIT_SEQ:			.res 4

.segment "FIXED"

irq_handlers_list:

	.word irq_empty_init   	,irq_empty			;0
	.word irq_star_init   	,irq_star			;1
	.word irq_row_fullx_init,irq_row_fullx		;2
	.word irq_year_init     ,irq_year			;3
	.word irq_text_init     ,irq_text			;4

;------------------------------------------------------------------------------

;void __fastcall__ set_irq_handler(unsigned char id);

.export _set_irq_handler

_set_irq_handler:

	asl a
	asl a
	pha
	tax
	
	lda irq_handlers_list+0,x	;INIT
	ldy irq_handlers_list+1,x
	
	ldx #$40					;RTI
	stx <IRQ_INIT+0
	sta <IRQ_INIT+1
	sty <IRQ_INIT+2
	lda #$4c					;JMP
	sta <IRQ_INIT+0
	
	pla
	tax

	lda irq_handlers_list+2,x	;HANDLER
	ldy irq_handlers_list+3,x
	
	ldx #$40					;RTI
	stx <IRQ_CALL+0
	sta <IRQ_CALL+1
	sty <IRQ_CALL+2
	lda #$4c					;JMP
	sta <IRQ_CALL+0

	rts
	
;------------------------------------------------------------------------------
	
irq_empty_init:

	rts
	
irq_empty:

	sta MMC3_IRQ_DISABLE		;acknowledge
	rti

;------------------------------------------------------------------------------
	
irq_star_init:

	lda #0
	sta <IRQ_LINE_OFF
	
	rts
	
irq_star:

	sta MMC3_IRQ_DISABLE		;acknowledge
	
	pha
	txa
	pha
	
	lda #55+113
	
	jsr timing_delay	;25+A
	
	lda <IRQ_LINE_OFF
	beq :+
	jmp irq_star_1
:

	ldx #170
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
	
	stx <IRQ_LINE_OFF
		
	lda #0
	sta PPU_SCROLL
	sta PPU_SCROLL
	
	ldx #2						;next 4K
	lda <MMC3_CHR_SLOTS+2
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+3
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+4
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+5
	stx MMC3_CTRL
	sta MMC3_DATA

	lda <MMC3_CTRL_VAR
	sta MMC3_CTRL
	
	pla
	tax
	pla
	
	rti
	
	
	
irq_star_1:

	lda #128
	jsr timing_delay	;25+A
	
	lda _star_scroll_bottom+1
	sta PPU_SCROLL
	lda #0
	sta PPU_SCROLL
	
	ldx #2
	lda _star_small_anim+4*2+1
	and #31
	clc
	adc #CHR_STAR_SMALL
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda _star_small_anim+5*2+1
	and #31
	clc
	adc #CHR_STAR_SMALL
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda _star_small_anim+6*2+1
	and #31
	clc
	adc #CHR_STAR_SMALL
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda _star_small_anim+7*2+1
	and #31
	clc
	adc #CHR_STAR_SMALL
	stx MMC3_CTRL
	sta MMC3_DATA

	lda <MMC3_CTRL_VAR
	sta MMC3_CTRL
	
	pla
	tax
	pla
	
	rti

;------------------------------------------------------------------------------

irq_row_fullx_init:

	lda #0
	sta <IRQ_LINE_OFF
	lda #<_update_list
	sta <IRQ_SPLIT_LIST+0
	lda #>_update_list
	sta <IRQ_SPLIT_LIST+1
	
	rts
	
irq_row_fullx:

	sta MMC3_IRQ_DISABLE
	
	pha
	txa
	pha
	tya
	pha

	lda #7
	sta MMC3_IRQ_LATCH
	sta MMC3_IRQ_RELOAD
	sta MMC3_IRQ_DISABLE
	sta MMC3_IRQ_ENABLE
	
	lda #25					;2
	jsr timing_delay		;25+A

	ldy <IRQ_LINE_OFF

	lda (IRQ_SPLIT_LIST),y		;bottom byte of X coord
	iny
	tax
	lda <PPU_CTRL_VAR
	and #$fe
	ora (IRQ_SPLIT_LIST),y		;top bit of X coord
	iny
	sty <IRQ_LINE_OFF

	stx PPU_SCROLL				;this write should be done just before end of the line, but not in hblank
	stx PPU_SCROLL
	sta PPU_CTRL	

	pla
	tay
	pla
	tax
	pla
	
	rti
	
;------------------------------------------------------------------------------
	
irq_year_list:

	.word irq_year_0
	.word irq_year_1
	.word irq_year_2
	.word irq_year_3
	.word irq_year_4
	.word irq_year_5
	.word irq_year_6
	
irq_year_init:

	lda #0
	sta <IRQ_LINE_OFF
	
	rts
	
irq_year:

	sta MMC3_IRQ_DISABLE		;acknowledge
	
	pha
	txa
	pha
	
	lda #10
	jsr timing_delay	;25+A
	
	lda <IRQ_LINE_OFF
	asl a
	tax
	lda irq_year_list+0,x
	sta <IRQ_JUMP+0
	lda irq_year_list+1,x
	sta <IRQ_JUMP+1
	jmp (IRQ_JUMP)
	
irq_year_0:

	ldx #16
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
			
	inc <IRQ_LINE_OFF
	
	pla
	tax
	pla
	
	rti
	
	
	
irq_year_1:

	ldx #15
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
		
	lda _year_scroll+1+1*2
	sta PPU_SCROLL
	lda #0
	sta PPU_SCROLL
	
	inc <IRQ_LINE_OFF
	
	pla
	tax
	pla
	
	rti
	

	
irq_year_2:

	ldx #31
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
		
	lda _year_scroll+1+2*2
	sta PPU_SCROLL
	lda #0
	sta PPU_SCROLL
	
	inc <IRQ_LINE_OFF
	
	pla
	tax
	pla
	
	rti
	
	
irq_year_3:

	ldx #109
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
		
	lda #0
	sta PPU_SCROLL
	sta PPU_SCROLL
	
	ldx #2						;next 4K
	lda <MMC3_CHR_SLOTS+2
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+3
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+4
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	lda <MMC3_CHR_SLOTS+5
	stx MMC3_CTRL
	sta MMC3_DATA

	lda <MMC3_CTRL_VAR
	sta MMC3_CTRL
	
	inc <IRQ_LINE_OFF
	
	pla
	tax
	pla
	
	rti
	
	
	
irq_year_4:

	ldx #16
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
	
	lda _year_scroll+1+3*2
	sta PPU_SCROLL
	lda #0
	sta PPU_SCROLL
	
	ldx #2						;next 4K
	lda #CHR_SPRITES
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	stx MMC3_CTRL
	sta MMC3_DATA
	inx
	stx MMC3_CTRL
	sta MMC3_DATA

	lda <MMC3_CTRL_VAR
	sta MMC3_CTRL
	
	inc <IRQ_LINE_OFF
	
	pla
	tax
	pla
	
	rti

	
irq_year_5:

	ldx #15
	stx MMC3_IRQ_LATCH		;line number
	stx MMC3_IRQ_RELOAD		;line number
	stx MMC3_IRQ_DISABLE
	stx MMC3_IRQ_ENABLE	
		
	lda _year_scroll+1+4*2
	sta PPU_SCROLL
	lda #0
	sta PPU_SCROLL
	
	inc <IRQ_LINE_OFF
	
	pla
	tax
	pla
	
	rti
	
	
	
irq_year_6:

	lda _year_scroll+1+5*2
	sta PPU_SCROLL
	lda #0
	sta PPU_SCROLL
	
	pla
	tax
	pla
	
	rti
	

	
;------------------------------------------------------------------------------
	
irq_text_init:

	lda <SCROLL_Y
	and #$f8
	asl a
	asl a
	sta <IRQ_SPLIT_SEQ+3
	lda <SCROLL_X
	lsr a
	lsr a
	lsr a
	ora <IRQ_SPLIT_SEQ+3
	sta <IRQ_SPLIT_SEQ+3
	
	lda <PPU_CTRL_VAR
	asl a
	asl a
	and #$0c
	sta <IRQ_SPLIT_SEQ+0
	
	lda <SCROLL_Y
	sta <IRQ_SPLIT_SEQ+1
	
	lda <SCROLL_X
	sta <IRQ_SPLIT_SEQ+2

	rts
	
	
	
irq_text:

	sta MMC3_IRQ_DISABLE		;acknowledge
	pha
	txa
	pha
	
	lda #113+30
	jsr timing_delay	;25+A
	
	lda <IRQ_SPLIT_SEQ+0
	sta PPU_ADDR
	lda <IRQ_SPLIT_SEQ+1
	sta PPU_SCROLL
	lda <IRQ_SPLIT_SEQ+2
	ldx <IRQ_SPLIT_SEQ+3
	sta PPU_SCROLL
	stx PPU_ADDR

	pla
	tax
	pla
	rti