#include "data/text_page_1.h"
#include "data/text_page_2.h"


const unsigned char text_palette_1_spr[16]={ 0x0f,0x13,0x23,0x33,0x0f,0x15,0x25,0x35,0x0f,0x17,0x27,0x37,0x0f,0x18,0x38,0x30 };
const unsigned char text_palette_2_spr[16]={ 0x0f,0x17,0x27,0x37,0x0f,0x19,0x29,0x39,0x0f,0x1b,0x2a,0x3b,0x0f,0x1c,0x3c,0x30 };
const unsigned char text_palette_3_spr[16]={ 0x0f,0x1b,0x2b,0x3b,0x0f,0x11,0x21,0x31,0x0f,0x13,0x23,0x33,0x0f,0x14,0x34,0x30 };



const unsigned char text_sine[64]={
	0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,4,4,5,5,5,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,5,5,5,4,4,4,3,3,2,2,2,1,1,1,0,0,0,0,0,0,0,
};

const unsigned char star_tile[16]={
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
	0x47,0x46,0x45,0x44,0x43,0x42,0x41,0x40,
};

const unsigned char text_table[16*20]={
	0x00,0x00,0x01,0x02,0x03,0x04,0x01,0x05,0x06,0x07,0x03,0x08,0x03,0x08,0x01,0x09,
	0x00,0x00,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x0c,0x0d,0x0e,0x0f,0x10,0x00,0x0e,0x0d,
	0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x16,0x00,0x19,0x1a,0x1b,0x1c,0x01,0x02,
	0x10,0x1d,0x1e,0x1f,0x0e,0x20,0x21,0x22,0x0e,0x0f,0x10,0x10,0x23,0x24,0x0e,0x0d,
	0x06,0x02,0x01,0x02,0x06,0x25,0x26,0x27,0x28,0x29,0x16,0x2a,0x16,0x2a,0x2b,0x16,
	0x0a,0x2c,0x0e,0x2d,0x0a,0x22,0x2e,0x0d,0x1e,0x1f,0x0e,0x0d,0x2f,0x30,0x31,0x24,
	0x32,0x33,0x34,0x12,0x35,0x36,0x37,0x14,0x38,0x39,0x3a,0x3b,0x3c,0x16,0x03,0x3d,
	0x3e,0x3f,0x40,0x0d,0x41,0x42,0x1e,0x1f,0x43,0x0f,0x2e,0x44,0x45,0x10,0x2e,0x0d,
	0x03,0x27,0x46,0x47,0x48,0x49,0x26,0x4a,0x13,0x14,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0e,0x0d,0x4b,0x4c,0x4d,0x4e,0x4f,0x0d,0x50,0x51,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x52,0x53,0x52,0x54,0x52,0x0f,0x55,0x56,0x52,0x0f,0x52,0x0f,0x52,0x57,
	0x00,0x00,0x58,0x2d,0x59,0x5a,0x34,0x5b,0x11,0x5c,0x5d,0x5e,0x5f,0x60,0x34,0x5a,
	0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x66,0x00,0x69,0x6a,0x6b,0x6c,0x52,0x53,
	0x5f,0x6d,0x13,0x14,0x6e,0x6f,0x70,0x71,0x34,0x5b,0x5f,0x16,0x72,0x73,0x34,0x5c,
	0x55,0x53,0x52,0x53,0x55,0x74,0x52,0x75,0x76,0x77,0x66,0x78,0x66,0x78,0x66,0x66,
	0x58,0x0d,0x34,0x12,0x58,0x79,0x7a,0x7b,0x13,0x14,0x34,0x5c,0x7c,0x12,0x7d,0x73,
	0x7e,0x7f,0x61,0x80,0x81,0x82,0x83,0x64,0x84,0x85,0x2e,0x86,0x87,0x66,0x52,0x88,
	0x89,0x8a,0x8b,0x5a,0x8c,0x8d,0x13,0x14,0x8e,0x8f,0x90,0x91,0x92,0x16,0x93,0x7b,
	0x52,0x75,0x2e,0x66,0x94,0x95,0x52,0x53,0x63,0x64,0x00,0x00,0x00,0x00,0x00,0x00,
	0x5d,0x7b,0x96,0x97,0x98,0x99,0x9a,0x5a,0x9b,0x9c,0x00,0x00,0x00,0x00,0x00,0x00
};

unsigned char text_ascii[]={
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	
	 0,36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	// !"#$%&'()*+,-./
	15,27,28,29,30,31,32,33,34,35, 0, 0, 0, 0, 0, 0,	//0123456789:;<=>?
	 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,	//@ABCDEFGHIJKLMNO
	16,17,18,19,20,21,22,23,24,25,26, 0, 0, 0, 0, 0,	//PQRSTUVWXYZ[\]^_
};

#pragma bssseg (push,"SHAREDRAM4")
#pragma dataseg(push,"SHAREDRAM4")

#define STARS_ALL		64

unsigned char star_x  [STARS_ALL];
unsigned int  star_y  [STARS_ALL];
unsigned int  star_dy [STARS_ALL];
unsigned char star_cnt[STARS_ALL];
unsigned char star_pal[STARS_ALL];

unsigned char stars_xoff;

unsigned char text_buf[9*9];

unsigned char text_delay;

const char* e_text_str;
unsigned char e_text_pal;
const unsigned char* e_text_pal_spr;
unsigned char e_side;
unsigned char e_stars_dir;
unsigned char e_edge_dir;

#pragma dataseg(pop);
#pragma bssseg (pop);

#pragma bssseg (push,"UPDLST")
#pragma dataseg(push,"UPDLST")

unsigned char text_ord[9*9];

#pragma dataseg(pop);
#pragma bssseg (pop);



const char text_1[]="\n\nSHIRU\nWISHES\nYOU\nA HAPPY\nNEW YEAR!";
const char text_2[]="\n\nHAVE\nGREATEST\nTIMES\nWITH YOUR\nFRIENDS!";
const char text_3[]="\n\nALL THE\nBEST\nTO\nYOUR\nFAMILY\nMEMBERS!";
const char text_4[]="\n\n KEEP\n AMAZE\n AND\n BE\n AMAZED!";

const char text_5[]="\nGREETS\nAND BEST\nWISHES TO\nEVERYONE\nON THE\nDEMO\nSCENE!";
const char text_6[]="\nALSO\nGREETS TO\nSPECCY\nNESDEV\nAND\n1BIT\nFOLKS!";
const char text_7[]="\nKEEP UP\nMANY NEW\nGREAT\nRELEASES\nCOMING\nTHIS\nYEAR!";
const char text_8[]="\nSPECIAL\nTHANKS\nTO MY\nPATRONS\nAND\nFOLLOWERS\nTOO!";

const char text_9[]="\nNOW I\nGOT A\nFEW PAGES\nLEFT FOR\nSOME\nPERSONAL\nGREETS TO";
const char text_10[]="\nELEAZAR\nJAMES\nSERGIO\nLEHA\nSTAS\nRUSLAN\nJUSTEVGEN";
const char text_11[]="\nPINWIZZ\nMAX\nCHRV\nSHURAN\nSAVELIJ\nGIBSON\nMR287CC";
const char text_12[]="\n\n AND\n OF\n COURSE\n TO\n YOU!";



void set_text(const char* str)
{
	char c;
	unsigned char ptr,sptr;
	
	memfill(text_buf,0,sizeof(text_buf));
	
	sptr=0;
	ptr=0;
	
	while(1)
	{
		c=*str++;
		
		if(!c) break;
		
		if(c=='\n')
		{
			sptr+=9;
			ptr=sptr;
			continue;
		}
		
		text_buf[ptr++]=text_ascii[c];
	}
	
	_ptr=0;
	
	for(_i=0;_i<9;++_i)
	{
		for(_j=0;_j<9;++_j)
		{
			text_ord[_ptr++]=(_i<<4)|_j;
		}
	}
	
	while(_ptr<sizeof(text_ord)) text_ord[_ptr++]=0;
	
	for(_i=0;_i<sizeof(text_ord);++_i)
	{
		_ptr=rand8()%(9*9);
		_off=rand8()%(9*9);
		
		_tile=text_ord[_ptr];
		text_ord[_ptr]=text_ord[_off];
		text_ord[_off]=_tile;
	}
	
	text_delay=64;
}



void set_star(void)
{
	unsigned int speed;
	
	speed=256+(rand16()&1023);
	
	if(speed>312) star_x[_i]=rand8()&127; else star_x[_i]=rand8();
	
	star_cnt[_i]=rand8();
	star_pal[_i]=OAM_BEHIND+((rand8()>>2)&3);
	
	if(!e_stars_dir)
	{
		star_y [_i]=0;
		star_dy[_i]=speed;
	}
	else
	{
		star_y [_i]=239<<8;
		star_dy[_i]=-speed;
	}
}



void update_stars(void);
/*
void update_stars(void)
{
	for(_i=0;_i<STARS_ALL;++_i)
	{
		_sx=stars_xoff+star_x[_i];
		_sy=star_y[_i]>>8;
		
		if(_sy>=240) set_star();
		
		oam_spr(_sx,_sy,star_tile[(star_cnt[_i]>>2)&15],star_pal[_i],oam_off);
		
		oam_off+=4;
		
		star_y[_i]+=star_dy[_i];
		
		++star_cnt[_i];
		
		if(!(star_cnt[_i]&63)) star_pal[_i]=OAM_BEHIND+(rand8()&3);
	}
}
*/


void set_text_update(void)
{
	unsigned int adr;
	
	if(!e_side) _sx=22; else _sx=8;
	
	update_list[0]=MSB(NTADR_A(_sx,0))|NT_UPD_VERT;
	update_list[1]=LSB(NTADR_A(_sx,0));
	update_list[2]=30;
	update_list[33]=MSB(NTADR_A(_sx+1,0))|NT_UPD_VERT;
	update_list[34]=LSB(NTADR_A(_sx+1,0));
	update_list[35]=30;

	adr=NTADR_A(15,0);
	
	update_list[66]=MSB(adr)|NT_UPD_HORZ;
	update_list[67]=LSB(adr);
	update_list[68]=2;
	update_list[69]=0;
	update_list[70]=0;
	update_list[71]=MSB(adr)|NT_UPD_HORZ;
	update_list[72]=LSB(adr);
	update_list[73]=2;
	update_list[74]=0;
	update_list[75]=0;
	
	update_list[76]=NT_UPD_EOF;
}



void e_text(void)
{
	signed int ix,dx,iix;
	unsigned char side_frame,text_order,scroll_yoff,hide;
	unsigned int adr,off;
	
	bank_bg(1);
	bank_spr(0);
	
	oam_clear_fast();
	oam_size(0);
	oam_update();

	_chr=CHR_SPRITES;
	
	mmc3_chr_bank(_chr+0,0);
	mmc3_chr_bank(_chr+2,1);
	
	_chr=CHR_FONT;
	
	mmc3_chr_bank(_chr+0,2);
	mmc3_chr_bank(_chr+1,3);
	mmc3_chr_bank(_chr+2,4);
	mmc3_chr_bank(_chr+3,5);
	
	mmc3_set_mirroring(M_VERTICAL);
	
	pal_clear();
	
	pal_col(0x01,e_text_pal+0x01);
	pal_col(0x02,e_text_pal+0x21);
	pal_col(0x03,0x30);

	pal_col(0x05,e_text_pal+0x31);
	pal_col(0x06,e_text_pal+0x21);
	pal_col(0x07,0x30);
	
	pal_spr(e_text_pal_spr);

	if(!e_side)
	{
		vram_adr(NAMETABLE_A);
		vram_unrle(text_page_1);
		vram_adr(NAMETABLE_B);
		vram_fill(0xbf,1024);
	}
	else
	{
		vram_adr(NAMETABLE_A);
		vram_unrle(text_page_2);
		vram_adr(NAMETABLE_B);
		vram_fill(0xbf,1024);
	}
	
	scroll(0,0);
	
	memfill(update_list,NT_UPD_EOF,sizeof(update_list));

	for(_i=0;_i<STARS_ALL;++_i)
	{
		set_star();
		star_y[_i]=rand16();
	}
	
	ix=256<<4;
	iix=256<<4;
	dx=-2<<4;
	hide=FALSE;
	stars_xoff=!e_side?120:0;

	side_frame=0;
	text_order=0;
	
	_frame=0;
	_bright=0;
	_done=0;
	
	set_text(e_text_str);
	
	set_text_update();
		
	set_irq_handler(IRQ_TEXT);
	set_nmi_handler(NMI_NORMAL);
	mmc3_irq_enable(224-1);	
	
	pal_bright(_bright);
	ppu_on_all();
	
	ft_prev_frame=ft_current_frame;
	ft_prev_row=ft_current_row;
	
	while(!_done||_bright)
	{	
		oam_off=0;
		
		update_stars();
		
		scroll_yoff=text_sine[(_frame<<1)&63];
		
		if(!e_edge_dir)
		{
			side_frame=_frame+scroll_yoff;
		}
		else
		{
			side_frame=(_frame^255)+scroll_yoff;
		}
			
		if(!e_side)
		{
			scroll((ix>>4),scroll_yoff);
		}
		else
		{
			scroll(512-(ix>>4),scroll_yoff);
		}
		
		_chr=(!e_side?CHR_SIDE_1:CHR_SIDE_2)+((side_frame>>3)&7);
	
		mmc3_chr_bank(_chr,5);
				
		_tile=(side_frame&7)<<1;
		
		upd_off=3;
		
		for(_i=0;_i<30;++_i)
		{
			update_list[upd_off++]=(_tile&63)+0xc0;
			
			_tile+=16;
		}
				
		_tile=(side_frame&7)<<1;
		
		upd_off=36;
		
		for(_i=0;_i<30;++_i)
		{
			update_list[upd_off++]=(_tile&63)+0xc1;
			
			_tile+=16;
		}
		
		if(text_delay)
		{
			--text_delay;
		}
		else
		{
			if(text_order<sizeof(text_ord))
			{
				_ptr=text_ord[text_order];

				_sx=_ptr&15;
				_sy=_ptr>>4;
				
				if(!e_side)
				{
					adr=NTADR_A(2+_sx*2,2+_sy*3);
				}
				else
				{
					adr=NTADR_A(12+_sx*2,2+_sy*3);
				}
				
				_tile=text_buf[_sy*9+_sx];
				
				off=(_tile&7)*2+(_tile>>3)*32;
				
				if(rand8()&1) off+=16*10;
				
				update_list[66]=MSB(adr)|NT_UPD_HORZ;
				update_list[67]=LSB(adr);
				update_list[69]=text_table[off+0];
				update_list[70]=text_table[off+1];
				
				adr+=32;
				
				update_list[71]=MSB(adr)|NT_UPD_HORZ;
				update_list[72]=LSB(adr);
				update_list[74]=text_table[off+16];
				update_list[75]=text_table[off+17];

				++text_order;
			}
		}

		oam_update();
		
		set_vram_update();
		
		if(!_done)
		{
			if(!(_frame&7))
			{
				if(_bright<4)
				{
					++_bright;
					
					pal_bright(_bright);
				}
			}
		}
		else
		{
			if(!(_frame&15))
			{
				if(_bright>0)
				{
					--_bright;
					
					pal_bright(_bright);
				}
			}
		}
		
		ppu_wait_nmi();
		
		if(!hide)
		{
			ix+=dx;
			
			if(ix<0)
			{
				ix=0;
				dx=-dx>>2;
			}
			
			iix+=dx;
			
			if(iix<0) iix=0;

			if(dx>(-8<<4)) dx-=1;
		}
		else
		{
			ix+=dx;
			if(ix>256<<4) ix=256<<4;
			if(dx<(8<<4)) dx+=2;
			
			iix+=dx;
			if(iix>256<<4<<1) iix=256<<4<<1;
		}
		
		if(ft_prev_row!=ft_current_row)
		{
			ft_prev_row=ft_current_row;
			
			if(ft_prev_row==56) { dx=0; hide=TRUE; }
			if(ft_prev_row==60) _done=TRUE;
		}
		
		++_frame;
	}
	
	ppu_off();
}



void e_text_1(void)
{
	e_text_pal_spr=text_palette_1_spr;
	e_stars_dir=0;
	e_edge_dir=0;	
	e_side=0;
	e_text_str=text_1;
	e_text_pal=0;

	e_text();
	
	e_side^=1;
	e_text_str=text_2;
	e_text_pal=2;
	
	e_text();
	
	e_edge_dir^=1;
	e_side^=1;
	e_text_str=text_3;
	e_text_pal=4;
	
	e_text();
	
	e_side^=1;
	e_text_str=text_4;
	e_text_pal=6;
	
	e_text();
}

void e_text_2(void)
{
	e_text_pal_spr=text_palette_2_spr;
	e_stars_dir=1;
	e_edge_dir=1;	
	e_side=0;
	e_text_str=text_5;
	e_text_pal=7;

	e_text();
	
	e_side^=1;
	e_text_str=text_6;
	e_text_pal=10;
	
	e_text();
	
	e_edge_dir^=1;
	e_side^=1;
	e_text_str=text_7;
	e_text_pal=1;
	
	e_text();
	
	e_side^=1;
	e_text_str=text_8;
	e_text_pal=3;
	
	e_text();
}

void e_text_3(void)
{
	e_text_pal_spr=text_palette_3_spr;
	e_stars_dir=0;
	e_edge_dir=0;	
	e_side=0;
	e_text_str=text_9;
	e_text_pal=5;

	e_text();
	
	e_edge_dir^=1;
	e_stars_dir^=1;
	e_side^=1;
	e_text_str=text_10;
	e_text_pal=7;
	
	e_text();
	
	e_edge_dir^=1;
	e_stars_dir^=1;
	e_side^=1;
	e_text_str=text_11;
	e_text_pal=9;
	
	e_text();
	
	e_edge_dir^=1;
	e_stars_dir^=1;
	e_side^=1;
	e_text_str=text_12;
	e_text_pal=11;
	
	e_text();
}