var Pisteet = function(){

    PartBase.call(this);
    this.setBloom(8);
    this.setEdgeDetection();
    this.setDoF({
        focus: 0.5,
        maxblur: 1.25,
        aparture: 0.0025
    });
    

    var material = new THREE.PointsMaterial({ color: 0xFF00FF});
    var material2 = new THREE.PointsMaterial({ color: 0x00FFFF});
    var material3 = new THREE.PointsMaterial({ color: 0x0000FF});
    var geometry = new THREE.Geometry();
    var geometry2 = new THREE.Geometry();
    var geometry3 = new THREE.Geometry();
    geometry.dynamic = true;
    geometry2.dynamic = true;
    geometry3.dynamic = true;


    this.lsystem = new LSYSTEM();

    this.lsystem.interpret(6, 120, "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 4);
    this.lsystem.moveToCenter();

    for(var k = 0; k < this.lsystem.points.length; ++k){
        var point = this.lsystem.points[k];
        geometry.vertices.push(new THREE.Vector3(-point.x, -point.y, -point.z));
        geometry2.vertices.push(new THREE.Vector3(point.x, point.y, point.z));
        geometry3.vertices.push(new THREE.Vector3(-point.x*0.8, point.y*0.75, point.z*1.2));
    }
    geometry.verticesNeedUpdate = true;
    geometry2.verticesNeedUpdate = true;
    geometry3.verticesNeedUpdate = true;
    this.container = new THREE.Object3D();

    this.points = new THREE.Points(geometry, material);
    this.points2 = new THREE.Points(geometry2, material2);
    this.points3 = new THREE.Points(geometry3, material3);

    this.container.add(this.points);
    this.container.add(this.points2);
    this.container.add(this.points3);


    this.scene.add(this.container);

};

Pisteet.prototype = PartBase.prototype.inheritance();

Pisteet.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var lp = TDEMO.SYNC.getObjRotation();
    this.points.rotation.x = lp.x;
    this.points.rotation.y = lp.y;
    this.points.rotation.z = lp.z;

    this.points2.rotation.x = -lp.x;
    this.points2.rotation.y = -lp.y;
    this.points2.rotation.z = -lp.z;

    this.points3.rotation.x = lp.x;
    this.points3.rotation.y = -lp.y;
    this.points3.rotation.z = lp.z;
    
    var p = TDEMO.SYNC.getObjPosition();
    this.container.position.x = p.x;
    this.container.position.y = p.y;
    this.container.position.z = p.z;
};
