#version 430


in vec3 posV[];
in vec2 uvV[];
in vec3 velV[];
in vec3 colV[];
in float ageV[];
in float recV[];

in vec4 paramsV[]; // .x = partikle unique random number

//in vec4 posInitV[];
// in vec4 posScrV[];

out vec4 posG;
out vec2 uvG;
out vec2 uvOrig;
out vec3 colG;
out float sharpnessG;
//out vec4 posSS;
out float age;
out vec3 ageColG;
out float brightG;
out float aspectG;
out vec3 posW;

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}
vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}
vec3 rotateYZ3(vec3 p, float a) {
  return rotateYZ(vec4(p, 0.0), a).xyz;
}
vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}


layout(points) in;
layout(triangle_strip, max_vertices = 4) out;
//layout(line_strip, max_vertices = 15) out;

layout(binding=2) uniform sampler2D texAgeSwipe;


layout(binding=0, offset=0) uniform atomic_uint ac;

 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;
layout(binding=2) uniform sampler2D texEmit;

uniform float g_pikselos = 0.0;

uniform float g_partSize = 0.15;


uniform float g_agePaletteOfs = 0.0;
uniform float g_agePaletteFreq = 1.0;

uniform float g_agePaletteYOfs = 0.0;
uniform float g_agePaletteXRand = 0.25;
uniform float g_agePaletteYRand = 0.25;
uniform float g_agePaletteFreqRand = 0.25;

uniform float g_partSizeVar = 0.0;
uniform float g_partSizeVarFreq = 2.0;

uniform float g_partMotionScale = 1.0;
uniform float g_partMotionScaleMax = 1.0;

uniform float g_partSharp = 1.0;


float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

uniform float g_maxAge;

uniform vec4 g_dofFokus = vec4(1.0, 0.50, 8.0, 8.0); // .x:dofFokusPointZ, .y:dofFokusRange, .z:dofGainNear, .w:dofGainFar
uniform vec4 g_dofPart = vec4(1.0, -0.10, 0.0, 0.0); // .x:dofPartSize, .y:dofPartSharp


layout(binding=0, rgba32f) uniform image2D particleGridCounts;

//const float zFar = 1.0;
//const float zNear = 0.0;

//vec4 CalcEyeFromWindow(in vec3 windowSpace) {
//    vec3 ndcPos;
//    vec4 viewport = vec4(0.0, 0.0, g_windowWidth, g_windowHeight);
//    ndcPos.xy = ((2.0 * windowSpace.xy) - (2.0 * viewport.xy)) / (viewport.zw) - 1;
////    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
//    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
//    vec4 clipPos;
//    clipPos.w = projectionMatrix[3][2]/(ndcPos.z-(projectionMatrix[2][2]/projectionMatrix[2][3]));
//    clipPos.xyz = ndcPos * clipPos.w;
//    return projectionInvMatrix * clipPos;
//}

uniform float g_hpTexBaseDim = 8.0;
uniform float g_gridCellSize = 1.0;

ivec2 pos3DToTex2D(vec3 p3d) {
    float gridW = g_hpTexBaseDim*g_hpTexBaseDim;
    vec3 cell = (fract(p3d/(g_gridCellSize*gridW)+vec3(0.5)));
   //vec3 cell = (fract(p3d*100.0+vec3(0.0)));
   //  if (cell.x < 0.0) cell.x = 1.0-cell.x;
   //  if (cell.y < 0.0) cell.y = 1.0-cell.y;
   //  if (cell.z < 0.0) cell.z = 1.0-cell.z;
    cell = floor(cell*gridW);
    float cellzy = floor(cell.z/g_hpTexBaseDim);
    float cellzx = cell.z-cellzy*g_hpTexBaseDim;
    ivec2 cellUV = ivec2(cell.x+cellzx*gridW, cell.y+cellzy*gridW);
    return cellUV;
}


void main(void) {
    if (gl_in.length()<1) {
        return;
    }



    mat4 mvp = projectionMatrix * modelViewMatrix;
    vec4 pos = vec4(posV[0], 1.0);

    // pos.y += -g_meshControlZ;

    vec4 pW = mvp*pos;


//ivec2 ppk = ivec2(128, 100);
ivec2 ppk = pos3DToTex2D(pW.xyz);
//imageStore(particleGridCounts, ppk, vec4(0.0, 0.5, 0.0, 1.0));


    vec4 pMV = modelViewMatrix*pos;

// clip out of screen partikles
//    vec2 scrTexPos = pW.xy/pW.w*0.5+vec2(0.5, 0.5);
//    if (!(scrTexPos.x>=0.0 && scrTexPos.y>=0.0 && scrTexPos.x<1.0 && scrTexPos.y<1.0)) {
//        return;
//    }

    int primID = gl_PrimitiveIDIn;

    age = ageV[0];

    //float dofSharpArea = 0.0;
    //float dofStrength = 100.0;
    //float sharpness = 0.0+1.0*clamp(10.0-clamp(abs(pos.z*0.1*dofStrength)-dofSharpArea, 0.0, 100000.0), 0.50, 10.0);

    gl_PrimitiveID = gl_PrimitiveIDIn;

    float pSize = clamp(0.02*g_partSize+0.02*g_partSizeVar*(1.0+1.0*sin(paramsV[0].x*g_partSizeVarFreq)), 0.0, 100.0);

    float pz = -pMV.z;
    float dofNear =  g_dofPart.x*max(g_dofFokus.x-g_dofFokus.y-pz, 0.0)*g_dofFokus.z;
    float dofFar = g_dofPart.x*max(pz-(g_dofFokus.x+g_dofFokus.y), 0.0)*g_dofFokus.w;

    dofNear = clamp(dofNear, 0.0, 3.0);
    dofFar = clamp(dofFar, 0.0, 16.0);

    float dof = dofNear+dofFar;
    float dofScaler = 1.0+dof;

    pSize *= dofScaler;
    brightG = 1.0/dofScaler;

  //  brightG = -pz;

    pSize *= (3.0/(clamp(recV[0]*4.0-0.0, 1.0, 1000.0)+1.0));
    float veny = clamp(sqrt(dot(velV[0],velV[0]))*g_partMotionScale, 0.0, g_partMotionScaleMax);
    float sizeX = pSize*(1.0+veny);
    float sizeY = pSize*(1.0/(1.0+2.0*veny));

    //sharpnessG = sharpness;
    sharpnessG = clamp(g_partSharp+g_dofPart.y*dof, 0.1, 1024.0);


    float rotAngle = 0.0;
    rotAngle = atanSafe(velV[0].y,velV[0].x);

    float ar = 9.0/16.0;

    aspectG = sizeX/sizeY;

    //uint counter = atomicCounterIncrement(ac);
//frag.rgb = vec3(fract(float(counter)/(1280.0*720.0)));

    float pp = g_agePaletteOfs+paramsV[0].x*g_agePaletteXRand;
    vec3 ageCol = texture2D(texAgeSwipe, vec2((age/g_maxAge)*(g_agePaletteFreq+g_agePaletteFreqRand*paramsV[0].x)+pp, g_agePaletteYOfs+0.5+paramsV[0].x*g_agePaletteYRand)).rgb;
    ageCol *= ageCol;
    ageColG = ageCol;

    colG = colV[0];

    vec4 k;

    posW = pos.xyz;

    k = rotateXY(vec4(-sizeX, -sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    //gl_Position = mvp*pos+vec4(-sizeX*ar, -sizeY, 0.0, 0.0);
    posG = gl_Position;
   // uvG = uv[0];
    uvG = vec2(0.0, 0.0);
    uvOrig = uvV[0];
//    posSS = posInitV[0];
    EmitVertex();

    k = rotateXY(vec4(sizeX, -sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    //gl_Position = mvp*pos+vec4(sizeX*ar, -sizeY, 0.0, 0.0);
    posG = gl_Position;
   // uvG = uv[0];
    uvOrig = uvV[0];
    uvG = vec2(1.0, 0.0);
    EmitVertex();

    k = rotateXY(vec4(-sizeX, sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    //gl_Position = mvp*pos+vec4(-sizeX*ar, sizeY, 0.0, 0.0);
    posG = gl_Position;
   // uvG = uv[0];
    uvOrig = uvV[0];
    uvG = vec2(0.0, 1.0);
    EmitVertex();

    k = rotateXY(vec4(sizeX, sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    //gl_Position = mvp*pos+vec4(sizeX*ar, sizeY, 0.0, 0.0);
    posG = gl_Position;
    uvOrig = uvV[0];
    uvG = vec2(1.0, 1.0);
    EmitVertex();

    EndPrimitive();



}
