import QtQuick 2.3
import AdaptDemoSystem 1.0

// make world pos xyz locations from mainDepth rendered with currently active camera
GroupBase {
  id: worldPos
  name: "worldPos"
  effectName: "WorldPos"

  property string depthRt: "mainDepth"

  Texture { textureUnit: 0; textureRT: depthRt }
  RenderTarget {
    RenderTargetLayer {
      textureRT: "worldPos"; format: "RGBA32F";
      width: demo.windowWidth; height: demo.windowHeight
    }
    Shader { file: "worldPos" }
    DrawVB {
      type: "quad"
      depthTest: false; depthWrite: false
      blendMode: "off"
      drawBuffers: 1
    }
  }
}
