import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
  id: effect
  name: "pardex"
  effectName: "Pardex"
  pm: "Pardex"

  property bool firstFrame: false
  property int frameNumber: 0
  property int frameRot: 0 // rotate atomic counters so consequent frames use different ones
  property bool resetParticles: false
  property int resetParticlesTriggerFrame: 0

  property bool depthWrite: s("draw.depthWrite", 0.0) > 0.5

  property real timePrev: 0.0

  property int updateRounds: 0

  property real lastUpdate: 0.0
  property real lastUpdateFract: 0.0
  property bool lastUpdateSet: false

  property int updateRoundsMod: 1
  property int updateRoundsModPending: -1
  property bool bFixedRenderGoing: false


 // property real fixedTimeStep: 16.67/1000.0
  property real fixedTimeStep: s("fixedStep", 33.3333)/1000.0
 // property real fixedTimeStep: 100.0/1000.0
 // property real fixedTimeStep: 100.0/1000.0
  property real timeBase: 0.0

  property int fixedResWidth: 1280
  property int fixedResHeight: 720

  property var fixedTracks
  property bool fixedTracksAdded: false

  function addRequestedFixedValue(tn) {
    if (fixedTracksAdded) {
      return;
    }

    if (fixedTracks === undefined) {
      fixedTracks = {};
    }
    fixedTracks[tn] = 1;
  }

  //    property bool frameRenderOn: false
  property real tss: 0.0

  property real timeBaseCount: 0.0

  property var fixedValues


  property int currentFrame: 0
  property int lastUpdateFrame: 0
  property int frameBase: 0

  property int simMode:  s("sim.mode")

  function frameSync() {
    firstFrame = true;
    if (resetParticles && (frameNumber > resetParticlesTriggerFrame)) {
      resetParticles = false;
    }
    frameNumber++;


    if (frameRot > 3) {
      frameRot++;
    } else {
      frameRot = 0;
    }

    var time = rocket.time;

    var timeStep = (time-timePrev)*1000.0;

    //D2 root.setCustomText(effect.name, effect.name+": timeStep", "time step:"+timeStep);


    /*
        updateRounds = (timeStep+lastUpdateFract)/16.67;

        if (updateRounds < 0) {
            updateRounds = 0;
        }

        if (!lastUpdateSet) {
            updateRounds = 1;
            lastUpdate = time;
            lastUpdateFract = 0.0;
        }
        lastUpdateSet = true;

        if (updateRounds > 0) {
            lastUpdate = time;
            lastUpdateFract = time-Math.floor(time/16.67)*16.67; //
        }
*/
    var updateInterval = fixedTimeStep;
    //   var updateInterval = 1000.0/1000.0;


    if (lastUpdateFract < 0.0) {
      lastUpdateFract = 0.0
    }

    if (lastUpdateFract > 1.0) {
      lastUpdateFract = 1.0;
    }

    if (lastUpdate > time) {
      lastUpdate = time;
    }

    //  timeBase = Math.floor((lastUpdate+lastUpdateFract*updateInterval)/updateInterval)*updateInterval;
    var tb = Math.floor((time)/updateInterval+0.0)*updateInterval;
    currentFrame = Math.floor(time/updateInterval);


    if (lastUpdateFrame > currentFrame) {
      lastUpdateFrame = currentFrame;
      frameBase = currentFrame;
    }

    //var updateRoundsReal = Math.floor((time-lastUpdate)/updateInterval+lastUpdateFract);
    // var updateRoundsReal = Math.floor((tb-lastUpdate)/updateInterval);
    // var updateRoundsReal = Math.floor((tb-lastUpdate)/updateInterval+0.5);
    //var updateRoundsReal = Math.floor((tb)/updateInterval+0.0)-Math.floor((lastUpdate)/updateInterval+0.0);

    var updateRoundsReal = currentFrame-lastUpdateFrame;

    if (updateRoundsReal < 0) {
      updateRoundsReal = 0;
    }
    if (!lastUpdateSet) {
      updateRounds = 1;
      lastUpdate = time;
      lastUpdateFract = 0.0;
      lastUpdateFrame = currentFrame;
      frameBase = lastUpdateFrame;

      //    timeBase = Math.floor((lastUpdate+lastUpdateFract*updateInterval)/updateInterval)*updateInterval;
      tb = Math.floor((lastUpdate)/updateInterval+0.5)*updateInterval;

    }

    //   fixedValues = {};

    updateRounds = updateRoundsReal;
    if (!rocket.getIsPaused()) {
      updateRounds = Math.min(8, updateRounds);
      //   updateRoundsMod = updateRounds;
    } else {
      updateRounds = Math.min(240, updateRounds);
    }

    if (simMode === 0) {
   //   updateRounds = Math.min(1, updateRounds);
      updateRounds = 1;
    }

    if (fixedTracks !== undefined) {
      var fk = Object.keys(fixedTracks);
     // log("fixed tracks count:"+fk.length);
      for (var i=0; i<fk.length; i++) {

        //            var indStart =  Math.floor(lastUpdate/updateInterval+0.5);
        //            var indEnd = Math.floor(tb/updateInterval+0.5)+1;
        var indStart =  lastUpdateFrame;
        var indEnd = lastUpdateFrame+updateRounds;

        //                fixedValues[fk[i]] = [];
        //                for (var ind=indStart; ind<indEnd; ind++) {
        //                    var indTime = ind*updateInterval;
        //                    var val = syncTime(fk[i], indTime);
        //                    fixedValues[fk[i]].push(val);
        //                }

        for (var ind=indStart; ind<indEnd; ind++) {
          var indTime = ind*updateInterval;
          var val = syncTime(fk[i], indTime);
          effect.writeBlockFixedValue(fk[i], ind, val);
        }
        //    fixedTracksAdded = true;
      }
    }

    lastUpdateSet = true;

    if (updateRounds >= 1.0) {
      //lastUpdateFract += ((time-lastUpdate)/updateInterval)-updateRoundsReal;
      //lastUpdate = time;
      timeBase = lastUpdate;
      frameBase = lastUpdateFrame;
      lastUpdate = tb;

      lastUpdateFrame = currentFrame;

    //D1  root.setCustomText(effect.name, effect.name+": lastUpdate", "time update:"+lastUpdate); //D1
    }


    //   log("frame:"+frameNumber+" updateRounds:"+updateRounds)


    // timeBaseCount+=fixedTimeStep*2.0;
    // timeBase = timeBaseCount;
    // updateRounds = 2;

    // updateRoundsMod = Math.max(updateRoundsMod, updateRounds);

    if (bFixedRenderGoing) {
      updateRoundsModPending = updateRounds;
    } else {
      updateRoundsMod = updateRounds;
    }

    timePrev = time;

  //D1  root.setCustomText(effect.name, effect.name+": updateRounds", "updateRounds:"+updateRounds); // D1

  }



  GroupBase {
    onEffectRender: { // sync point
      frameSync();
    }
  }





  // Maximum number of particles is pardexW*pardexH
  property int pardexW: 1024*1
  property int pardexH: 512*1

//  property int pardexW: 1024*2
//  property int pardexH: 1024*1

//  property int pardexW: 1024*1
//  property int pardexH: 1024*1


  RenderTarget { RenderTargetLayer { textureRT: "pardexPos"; format: "RGBA32F"; width: pardexW*2; height: pardexH*2 } }
  RenderTarget { RenderTargetLayer { textureRT: "pardexVel"; format: "RGBA32F"; width: pardexW; height: pardexH } }


  RenderTarget { // .x seconds of age left, .y age since birth
    RenderTargetLayer {
      textureRT: "pardexAge"; format: "RGBA32F"; width: pardexW; height: pardexH
    }
  }

  RenderTarget {
    RenderTargetLayer {
      textureRT: "testFixed"; format: "R32F"; width: 256; height: 256
      //        Clear { enabled: (!firstFrame || step.resetPart); cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
    }
  }

  property bool emitCamDebug: (s("emitCam.debug") > 0.5)


  Component {
    id: fixedStepActionsComp
    GroupBase {
      id: step
      //property int index: 0
      enabled: index<updateRoundsMod || index<1

      GroupBase {
        onEffectRender: {
          bFixedRenderGoing = true;
        }
      }

      onEffectRender: {
        rocket.markUpdateFrequent();
        fixedTime = Math.floor((timeBase+index*fixedTimeStep)/fixedTimeStep+0.50)*fixedTimeStep
      }

      fixedTime: tf

      function sync(track, defaultValue) {
        if (step.enabled) {
          effect.addRequestedFixedValue(track);
          var ind = frameBase+index;
         // log("local sync "+track+" at:"+ind);
          var valuezo = effect.syncWithBlockFixed(track, ind);
          return valuezo;
        }
        return 0.0;
      }

      function s(n, d) {
        return sync(effect.name+"."+n, d);
      }

      property bool resetParticlesTrigger: syncTriggerTime(effect.name+".sim.reset", tf)
      property int resetTriggerZeroCount: 0

      onResetParticlesTriggerChanged: {
        if (resetParticlesTrigger) {
          step.resetPart = true;
          resetParticles = true;
          resetParticlesTriggerFrame = frameNumber
          resetTriggerZeroCount = 1;
        }
      }

      property bool resetPart: false

      Shader { file: "clearToValue" }
      RenderTarget {
        enabled: (updateRoundsMod>0) && step.resetPart
        RenderTargetLayer {
          textureRT: "pardexAge"; format: "RGBA32F"; width: pardexW; height: pardexH
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexAge" } // read & write
        DrawVB {
          type: "quad"
          depthTest: false; depthWrite: false; blendMode: "off"
          ShaderParam { paramName: "clearToValue"; paramValue: -1.0 }

          onEffectRender: {
            if (resetTriggerZeroCount===0) {
              step.resetPart = false;
              //   resetParticles = false;
            }
            resetTriggerZeroCount--;
            if (resetTriggerZeroCount < 0) {
              resetTriggerZeroCount = 0;
            }
          }
        }
      }

      property real tf: Math.floor((timeBase+index*fixedTimeStep)/fixedTimeStep+0.50)*fixedTimeStep

      // --- BEGIN test RT code  ---
//      Shader { file: "clearToValue" }
//      RenderTarget {
//        enabled: (updateRoundsMod>0) && step.resetPart
//       // enabled: (updateRoundsMod>0)
//        RenderTargetLayer {
//          textureRT: "testFixed"; format: "R32F"; width: 256; height: 256
//        }
//        Texture { textureUnit: 0; imageUnit: 0; textureRT: "testFixed" } //write
//        DrawVB {
//          type: "quad"
//          depthTest: false; depthWrite: false; blendMode: "off"
//          ShaderParam { paramName: "clearToValue"; paramValue: 0.0 }
//        }
//      }
//      function testF() {
//        var ind = frameBase+index;
//        return ind;
//      }
//      Shader { file: "testFixed" }
//      RenderTarget {
//        enabled: updateRoundsMod>0
//        RenderTargetLayer {
//          textureRT: "testTarget"; format: "RGBA32F"; width: 1; height: 1
//        }
//        Texture { textureUnit: 0; imageUnit: 0; textureRT: "testFixed" } // read & write
//        DrawVB {
//          type: "quad"
//          depthTest: false; depthWrite: false; blendMode: "off"
//          // ShaderParam { paramName: "framePos"; paramValue: step.testF() }
//          ShaderParam { paramName: "framePos"; syncName: ns("testFrame") }
//        }
//      }
      // --- END test RT code  ---


      // "pardexMeshDepth" has pseudo depth
      Shader { file: "clearToValueInt" }
      RenderTarget {
        enabled: (updateRoundsMod>0)
        RenderTargetLayer {
          textureRT: "pardexMeshDepth"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
       //   Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexMeshDepth" } // write
        DrawVB {
          type: "quad"
          depthTest: false; depthWrite: false; blendMode: "off"
          ShaderParam { paramName: "clearToValue"; paramValue: 256.0*65536.0 }
        }
      }

      RenderTarget {
        RenderTargetLayer {
          textureRT: "pardexMeshDepthPrev"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
      //    Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
      }

//      RenderTarget {
//        RenderTargetLayer {
//          textureRT: "pardexMeshDepthFloat"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
//      //    Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
//        }
//      }




      RenderTarget { // integer index for active particle, for all having pardexAge.x > 0.0
        RenderTargetLayer {
          textureRT: "pardexActive"; format: "R32F"; width: pardexW; height: pardexH
          Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
      }
      RenderTarget { // integer index for free particle, for all having pardexAge.x <= 0.0
        RenderTargetLayer {
          textureRT: "pardexFree"; format: "R32F"; width: pardexW; height: pardexH
        }
      }

      ShaderAtomicCounter { name: effect.name+".sacPardexActiveNum"+frameRot; clear: true; bind: 0 }
      ShaderAtomicCounter { name: effect.name+".sacPardexFreeNum"+frameRot; clear: true; bind: 1 }
      ShaderAtomicCounter { name: effect.name+".sacPardexEmitsNum"+frameRot; clear: true; bind: 2 }

      // step 1
      // -count active & free particles into the atomic counters
      // -update pardexFree & pardexActive based on the current situation
      Shader { file: "pardexState" }
      RenderTarget {
        enabled: updateRoundsMod>0
        RenderTargetLayer {
          textureRT: "pardexFree"; format: "R32F"; width: pardexW; height: pardexH
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexFree" } // write
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexActive" } // write
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexAge" } // read
        DrawVB {
          type: "quad"
          depthTest: false; depthWrite: false; blendMode: "off"
          ShaderParam { paramName: "partNum"; paramValue: partNum }
          drawBuffers: 0
        }
      }

      // step 2


      property real emitCamDist: s("emitCam.dist")

      property real emitCamPosX: s("emitCam.pos.x")
      property real emitCamPosY: s("emitCam.pos.y")
      property real emitCamPosZ: s("emitCam.pos.z")
      property real emitCamLookAtX: s("emitCam.lookAt.x")
      property real emitCamLookAtY: s("emitCam.lookAt.y")
      property real emitCamLookAtZ: s("emitCam.lookAt.z")

      Camera {
        x: (emitCamPosX-emitCamLookAtX)*step.emitCamDist+emitCamLookAtX;
        y: (emitCamPosY-emitCamLookAtY)*step.emitCamDist+emitCamLookAtY;
        z: (emitCamPosZ-emitCamLookAtZ)*step.emitCamDist+emitCamLookAtZ;
  //      x: emitCamPosX-(emitCamDist-1.0)*(lookAtX-emitCamPosX);
  //      y: emitCamPosY-(emitCamDist-1.0)*(lookAtY-emitCamPosY);
  //      z: emitCamPosZ-(emitCamDist-1.0)*(lookAtZ-emitCamPosZ);

        lookAtX: emitCamLookAtX; lookAtY: emitCamLookAtY; lookAtZ: emitCamLookAtZ
        upX: s("emitCam.up.x"); upY: s("emitCam.up.y"); upZ: s("emitCam.up.z")
        viewAngle: s("emitCam.viewAngle")
      }

      DrawVB {type: "emptyVBO"; storeView: "viewEmit_"+effect.name }

      RenderTarget {
        enabled: updateRoundsMod>0
        RenderTargetLayer {
          textureRT: "emitCamRGB"; format: "RGBA32F"; width: fixedResWidth; height: fixedResHeight
          Clear { enabled: updateRoundsMod>0; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; cD: 1.0 }
        }

        // -emit new particles straight to particle info buffers
       // Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexActive" } // write (new active emitted particle)
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "pardexFree" } // read
        Texture { textureUnit: 4; imageUnit: 4; textureRT: "pardexPos" } // write
        Texture { textureUnit: 5; imageUnit: 5; textureRT: "pardexAge" } // write
        Texture { textureUnit: 6; imageUnit: 6; textureRT: "pardexVel" } // write
        //Texture { textureUnit: 5; imageUnit: 5; textureRT: "pardexColor" } // write
        //Texture { textureUnit: 6; imageUnit: 6; textureRT: "pardexNormal" } // write

        Texture { textureUnit: 7; imageUnit: 7; textureRT: "pardexMeshDepth" } // write & read

        Shader {
          file: "pardexEmitMesher"
          ShaderParam { paramName: "emitCamDebug"; paramValue: emitCamDebug }
        }

        Mesher {
          name: "mesher1"
    //      enabledIn: (updateRoundsMod>0)
  //        enabledIn: (updateRoundsMod>0) && ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
  //        enabledIn: ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
          syncIn: sync
          syncFFTIn: syncFFT
          setShader: false
          fixedTimeStepIn: fixedTimeStep
          depthTestIn: false
          depthWriteIn: true
          drawOnly: true
        }

        Shader { file: "copyInt" }
        RenderTarget {
          enabled: (updateRoundsMod>0)
          RenderTargetLayer {
            textureRT: "pardexMeshDepth"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
         //   Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
          }
          Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexMeshDepth" } // read
          Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexMeshDepthPrev" } // write
          DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false; blendMode: "off"
          }
        }

        Shader {
          file: "pardexEmitMesher"
          ShaderParam { paramName: "emitCamDebug"; paramValue: emitCamDebug }
        }

//        Mesher {
//          name: "mesher2"
// //         enabledIn: (updateRoundsMod>0)
//  //        enabledIn: (updateRoundsMod>0) && ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
//  //        enabledIn: ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
//          syncIn: sync
//          syncFFTIn: syncFFT
//          setShader: false
//          fixedTimeStepIn: fixedTimeStep
//          depthTestIn: false
//          depthWriteIn: true
//          drawOnly: true
//        }

//        Shader { file: "copyInt" }
//        RenderTarget {
//          enabled: (updateRoundsMod>0)
//          RenderTargetLayer {
//            textureRT: "pardexMeshDepth"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
//         //   Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
//          }
//          Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexMeshDepth" } // read
//          Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexMeshDepthPrev" } // write
//          DrawVB {
//            type: "quad"
//            depthTest: false; depthWrite: false; blendMode: "off"
//          }
//        }


        Shader {
          file: "pardexEmit"
          ShaderParam { paramName: "emitCamDebug"; paramValue: emitCamDebug }
        }

        Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexMeshDepthPrev" }


        Mesh {
          name: "mesh1"
          enabledIn: (updateRoundsMod>0)
     //     enabledIn: (updateRoundsMod>0) && ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
     //     enabledIn: ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
          syncIn: sync
          syncFFTIn: syncFFT
          setShader: false
          fixedTimeStepIn: fixedTimeStep
          depthTestIn: false
          depthWriteIn: true
        }

        Shader { file: "copyInt" }
        RenderTarget {
          enabled: (updateRoundsMod>0)
          RenderTargetLayer {
            textureRT: "pardexMeshDepth"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
         //   Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
          }
          Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexMeshDepth" } // read
          Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexMeshDepthPrev" } // write
          DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false; blendMode: "off"
          }
        }

        Shader {
          file: "pardexEmit"
          ShaderParam { paramName: "emitCamDebug"; paramValue: emitCamDebug }
        }

        Texture { textureUnit: 7; imageUnit: 7; textureRT: "pardexMeshDepth" }
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexMeshDepthPrev" }

// MSK
        Mesh {
          enabledIn: (updateRoundsMod>0)
          name: "mesh2"
  //        enabledIn: (updateRoundsMod>0) && ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
    //      enabledIn: ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
          syncIn: sync
          syncFFTIn: syncFFT
          setShader: false
          fixedTimeStepIn: fixedTimeStep
          depthTestIn: false
          depthWriteIn: true
        }

//        Shader { file: "copyInt" }
//        RenderTarget {
//          enabled: (updateRoundsMod>0)
//          RenderTargetLayer {
//            textureRT: "pardexMeshDepth"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
//         //   Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
//          }
//          Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexMeshDepth" } // read
//          Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexMeshDepthPrev" } // write
//          DrawVB {
//            type: "quad"
//            depthTest: false; depthWrite: false; blendMode: "off"
//          }
//        }

//        Shader {
//          file: "pardexEmit"
//          ShaderParam { paramName: "emitCamDebug"; paramValue: emitCamDebug }
//        }

//        Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexMeshDepthPrev" }

//        Mesh {
//          name: "mesh3"
//          enabledIn: (updateRoundsMod>0)
//  //        enabledIn: (updateRoundsMod>0) && ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
//    //      enabledIn: ((syncFFT(name+".pardEmit.amount", 0.0) > 0.0001) || (syncFFT(name+".pardEmit.amount.fromBright", 0.0) > 0.0001))
//          syncIn: sync
//          syncFFTIn: syncFFT
//          setShader: false
//          fixedTimeStepIn: fixedTimeStep
//          depthTestIn: false
//          depthWriteIn: true
//        }

//        Shader { file: "copyInt" }
//        RenderTarget {
//          enabled: (updateRoundsMod>0)
//          RenderTargetLayer {
//            textureRT: "pardexMeshDepth"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
//         //   Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
//          }
//          Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexMeshDepth" } // read
//          Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexMeshDepthPrev" } // write
//          DrawVB {
//            type: "quad"
//            depthTest: false; depthWrite: false; blendMode: "off"
//          }
//        }


// MSK
//        Shader {
//          file: "pardexEmitBreakin"
//          ShaderParam { paramName: "emitCamDebug"; paramValue: emitCamDebug }
//        }
//        Texture { textureUnit: 7; imageUnit: 7; textureRT: "pardexMeshDepth" }
//        Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexMeshDepthPrev" }
//        BreakIn {
//          name: "breakin1"
//        //  enabledIn: (updateRoundsMod>0)
//          drawOnly: true
//          syncIn: sync
//          syncFFTIn: syncFFT
//          setShader: false
//          fixedTimeStepIn: fixedTimeStep
//          depthTestIn: false
//          depthWriteIn: false
//        }
//        Shader { file: "copyInt" }
//        RenderTarget {
//          enabled: (updateRoundsMod>0)
//          RenderTargetLayer {
//            textureRT: "pardexMeshDepth"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
//         //   Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
//          }
//          Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexMeshDepth" } // read
//          Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexMeshDepthPrev" } // write
//          DrawVB {
//            type: "quad"
//            depthTest: false; depthWrite: false; blendMode: "off"
//          }
//        }

//        Shader {
//          file: "pardexEmitInsta"
//          ShaderParam { paramName: "emitCamDebug"; paramValue: emitCamDebug }
//        }
//        Texture { textureUnit: 7; imageUnit: 7; textureRT: "pardexMeshDepth" }
//        Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexMeshDepthPrev" }
//        Insta {
//          name: "insta1"
//        //  enabledIn: (updateRoundsMod>0)
//          drawOnly: true
//          syncIn: sync
//          syncFFTIn: syncFFT
//          setShader: false
//          fixedTimeStepIn: fixedTimeStep
//          depthTestIn: false
//          depthWriteIn: false
//        }
//        Shader { file: "copyInt" }
//        RenderTarget {
//          enabled: (updateRoundsMod>0)
//          RenderTargetLayer {
//            textureRT: "pardexMeshDepth"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
//         //   Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
//          }
//          Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexMeshDepth" } // read
//          Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexMeshDepthPrev" } // write
//          DrawVB {
//            type: "quad"
//            depthTest: false; depthWrite: false; blendMode: "off"
//          }
//        }




//        Shader { file: "copyIntToFloat" }
//        RenderTarget {
//          enabled: (updateRoundsMod>0)
//          RenderTargetLayer {
//            textureRT: "pardexMeshDepth"; format: "R32F"; width: fixedResWidth; height: fixedResHeight
//         //   Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
//          }
//          Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexMeshDepth" } // read
//          Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexMeshDepthFloat" } // write
//          DrawVB {
//            type: "quad"
//            depthTest: false; depthWrite: false; blendMode: "off"
//          }
//        }

      }

      WorldPosSecond {
        enabled: updateRoundsMod>0
        targetTextureRT: "pardexMeshWorld"
        depthRT: "emitCamRGB"
        secondView: "viewEmit_"+effect.name
        effectWidth: fixedResWidth
        effectHeight: fixedResHeight
      }


      Camera { // back to flyCam
        property vector3d pos: flyCam.getCamPosSmooth()
        property vector3d lookAt: flyCam.getCamLookAtSmooth()
        property vector3d up: flyCam.getCamUpSmooth()

        x: pos.x; y: pos.y; z: pos.z
        lookAtX: lookAt.x; lookAtY: lookAt.y; lookAtZ: lookAt.z
        upX: up.x; upY: up.y; upZ: up.z
        viewAngle: flyCam.camViewAngle
      }

      Shader { file: "pardexSim" }
      RenderTarget {
        enabled: updateRoundsMod>0
        RenderTargetLayer {
          textureRT: "pardexAge"; format: "RGBA32F"; width: pardexW; height: pardexH
          //     Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexPos" } // read & write
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexAge" } // read & write
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexVel" } // read & write


        Texture { textureUnit: 0; textureRT: "velBufBlur" }
        Texture { textureUnit: 1; textureRT: "worldPosBlur" }

        Texture { textureUnit: 2; textureRT: "pardexMeshWorld" } // read world position for collision resolving
        Texture { textureUnit: 3; textureRT: "emitCamRGB" } // read (depths &) normal for collision resolving

        ShaderParam { paramName: "effectWidth"; paramValue: fixedResWidth }
        ShaderParam { paramName: "effectHeight"; paramValue: fixedResHeight }



        DrawVB {
          type: "quad"
          depthTest: false
          depthWrite: false
          blendMode: "off"

          drawBuffers: 0

          secondView: "viewEmit_"+effect.name

          ShaderParam { paramName: "test"; syncName: ns("disp.amp") }

          ShaderParam { paramName: "partNum"; paramValue: partNum }
          ShaderParam { paramName: "div"; paramValue: Math.sqrt(partNum) }

          ShaderParam { paramName: "dispAmp"; syncFFTName: ns("noise.amp") }
          ShaderParam { paramName: "dispExp"; syncName: ns("noise.exp") }
          ShaderParam { paramName: "noiseOfsX"; syncName: ns("noise.ofs.x") }
          ShaderParam { paramName: "noiseOfsY"; syncName: ns("noise.ofs.y") }
          ShaderParam { paramName: "noisePos"; syncName: ns("noise.pos") }
          ShaderParam { paramName: "noiseFreq"; syncName: ns("noise.freq") }
          ShaderParam { paramName: "noiseOct"; syncName: ns("noise.oct.num") }
          ShaderParam { paramName: "noiseOctMul"; syncName: ns("noise.oct.mul") }
          ShaderParam { paramName: "noiseOctAmp"; syncName: ns("noise.oct.amp") }

          ShaderParam { paramName: "dirForceAmp"; syncFFTName: ns("sim.dirForce.amp") }
          ShaderParam { paramName: "dirForceX"; syncName: ns("sim.dirForce.x") }
          ShaderParam { paramName: "dirForceY"; syncName: ns("sim.dirForce.y") }
          ShaderParam { paramName: "dirForceZ"; syncName: ns("sim.dirForce.z") }

          ShaderParam { paramName: "collElast"; syncName: ns("sim.collision.elast"); syncDefault: 0.9 }
          ShaderParam { paramName: "collFrict"; syncName: ns("sim.collision.frict"); syncDefault: 0.5 }

          ShaderParam { paramName: "scaleX"; syncName: ns("scale.x") }
          ShaderParam { paramName: "scaleY"; syncName: ns("scale.y") }
          ShaderParam { paramName: "scaleZ"; syncName: ns("scale.z") }

          ShaderParam { paramName: "simMode"; syncName: ns("sim.mode") } // 0.0 = new pos per frame, 1.0 = emit particles mode

          ShaderParam { paramName: "simDamp"; syncName: ns("sim.damp") }

          ShaderParam { paramName: "layers"; syncName: ns("draw.layers"); syncDefault: 6 }
          ShaderParam { paramName: "skroller"; syncName: ns("draw.skroller"); syncDefault: 0.0 }

          ShaderParam { paramName: "pixVelAmp"; syncName: ns("sim.pixVel.amp") }
          ShaderParam { paramName: "pixVelDistExp"; syncName: ns("sim.pixVel.distExp") }

          ShaderParam { paramName: "g_timeStep"; paramValue: fixedTimeStep }
          ShaderParam { paramName: "g_time"; paramValue: step.tf }

        }
      }


      GroupBase {
        onEffectRender: {
          bFixedRenderGoing = false;
          if (updateRoundsModPending >= 0) {
            var mp = updateRoundsModPending;
            updateRoundsModPending = -1;
            updateRoundsMod = mp;
          }
        }
      }

    }
  }


  Repeater {
    model: {
      var a = rocket.getIsPaused() && (updateRoundsMod>0) ? 120 : 8;
   //   var b = effect.effectSyncUpdate;
      var b = rocket.syncUpdate;
      return a;
    }
    delegate: fixedStepActionsComp
  }


//  //    Repeater {
//  //        // enabled: rocket.getIsPaused()
//  //        model: rocket.getIsPaused() ? 240 : 8
//  //        delegate: fixedStepActionsComp
//  //    }


//  //    Repeater {
//  //        enabled: {
//  //            var a = rocket.getIsPaused();
//  //             var b = effect.effectSyncUpdate;
//  //            return a;
//  //        }
//  //       // model: 500
//  //        model: enabled ? 500 : 0
//  //        delegate: fixedStepActionsComp
//  //    }

//  //    Repeater {
//  //        enabled: {
//  //            var a = !rocket.getIsPaused();
//  //             var b = effect.effectSyncUpdate;
//  //            return a;
//  //        }
//  //      //  model: 8
//  //        model: enabled ? 8 : 0
//  //        delegate: fixedStepActionsComp
//  //    }



  RenderTarget {
    RenderTargetLayer {
      textureRT: "pardexBucketCounts"; format: "R32F"; width: 1024; height: 1024
      Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
    }
  }
  RenderTarget {
    RenderTargetLayer {
      textureRT: "pardexBucketPrefix"; format: "R32F"; width: 1024; height: 1024
      //Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
    }
  }
  RenderTarget { RenderTargetLayer { textureRT: "pardexOfs"; format: "R32F"; width: pardexW; height: pardexH } }

  //     ShaderAtomicCounter { name: effect.name+".sacBucketHead"; clear: true; bind: 0 }


  property var lighterIndex: s("lighterIndex", 0);

  property int lightPosX: {
    if (lighterIndex>0) {
      return sync("lighter"+lighterIndex+".pos.x");
    } else {
   //   return s("light.pos.x");
    }
  }
  property int lightPosY: {
    if (lighterIndex>0) {
      return sync("lighter"+lighterIndex+".pos.y");
    } else {
    //  return s("light.pos.y");
    }
  }
  property int lightPosZ: {
    if (lighterIndex>0) {
      return sync("lighter"+lighterIndex+".pos.z");
    } else {
    //  return s("light.pos.z");
    }
  }

  property real lightDist: s("shadow.light.dist", 1.0)


  // The 3D grid edge size is transmitGridBD^2, with transmitGridBD=16 grid edge size is 256
  // Why like this? Because when presented like this,
  // the 3D grid is easy to be stored into 2D texture with edge size of transmitGridBD^3
  property int transmitGridBD: skene.pardexTransmitRes !== undefined ?  skene.pardexTransmitRes : 16


  Camera {
    x: lightPosX-(lightDist-1.0)*(lookAtX-lightPosX);
    y: lightPosY-(lightDist-1.0)*(lookAtY-lightPosY);
    z: lightPosZ-(lightDist-1.0)*(lookAtZ-lightPosZ);
    lookAtX: sync("lighter"+lighterIndex+".lookAt.x"); lookAtY: sync("lighter"+lighterIndex+".lookAt.y"); lookAtZ: sync("lighter"+lighterIndex+".lookAt.z")
    upX: sync("lighter"+lighterIndex+".up.x"); upY: sync("lighter"+lighterIndex+".up.y"); upZ: sync("lighter"+lighterIndex+".up.z")
    viewAngle: s("shadow.viewAngle")
  }

  property real shadowsOn: s("shadow.ON")

  Shader { file: "pardexGridDraw" } // draw into the pardexTransmittance "3D" texture
  RenderTarget {
    RenderTargetLayer {
      textureRT: "pardexTransmittance"; format: "R32F";
      property int baseDim: transmitGridBD
      property int bd2: baseDim*baseDim
      property int bd3: bd2*baseDim
      width: bd3; height: bd3
      Clear { enabled: true; cR: 1.0; cG: 1.0; cB: 1.0; cA: 1.0; }
    }

    Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexPos" } // read
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "pardexAge" } // read

    DrawVB {
      type: "emptyVBO"
      primType: "triangles"
      vboId: sceneName+effect.name+"pardex"
      depthTest: false; depthWrite: false
      blendMode: "mul"
      enabled: shadowsOn > 0.5

      drawNumPoints: 6*partNum

      drawBuffers: 1

      storeView: "lightPardexView"

      ShaderParam { paramName: "drawSize"; paramValue: s("draw.size") }
      ShaderParam { paramName: "baseDim"; paramValue: transmitGridBD }

      ShaderParam { paramName: "shadowZOfs"; paramValue: s("shadow.z.ofs") }
      ShaderParam { paramName: "shadowZScale"; paramValue: s("shadow.z.scale") }

      ShaderParam { paramName: "transmitAlpha"; paramValue: s("shadow.transmit.alpha") }

    }
  }

  Camera { // back to flyCam
    property vector3d pos: flyCam.getCamPosSmooth()
    property vector3d lookAt: flyCam.getCamLookAtSmooth()
    property vector3d up: flyCam.getCamUpSmooth()

    x: pos.x; y: pos.y; z: pos.z
    lookAtX: lookAt.x; lookAtY: lookAt.y; lookAtZ: lookAt.z
    upX: up.x; upY: up.y; upZ: up.z
    viewAngle: flyCam.camViewAngle
  }



  Shader { file: "pardexTransmit" } // calculate transmittance by summing the transmit-value of previous level texel to the next
  RenderTarget {
    RenderTargetLayer {
      textureRT: "pardexGridDraw"; format: "R32F"; width: transmitGridBD*transmitGridBD; height: transmitGridBD*transmitGridBD
    }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexTransmittance" } // read & write
    DrawVB {
      enabled: s("shadow.ON") > 0.5
      type: "quad"
      depthTest: false
      depthWrite: false
      blendMode: "off"
      ShaderParam { paramName: "baseDim"; paramValue: transmitGridBD }
    }
  }


  // Depth sorting of particles is handled by one dimensional bucket list
  // The depth range of particles is scaled from 0 to max and this range is adapted to
  // 0 .. 1024*1024-1 = 1048575 range
  // particles are first put into the buckets matching the depth and then counting by simple imageAtomicAdd
  // how many particles are in each bucket
  // (TBD try making this faster through additive blending of pixel sized particles?)

  Shader { file: "pardexBucketCounts" }
  RenderTarget {
    RenderTargetLayer {
      textureRT: "pardexAge"; format: "RGBA32F"; width: pardexW; height: pardexH
    }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexPos" } // read
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexBucketCounts" } // write
    //        Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexBucketCountsRGB" } // write
    DrawVB {
      type: "quad"
      depthTest: false
      depthWrite: false
      blendMode: "off"
      ShaderParam { paramName: "partNum"; paramValue: partNum }
      drawBuffers: 0
    }
  }



  // then after having bucket counts, for example like this
  // 0  0  1  2
  // 0  7  2  0
  // 0  0  0  0
  // 0  0  4  0

  // we apply a parallel prefix sum algorithm for the counts and for above example we get
  // 0  0  0  1
  // 3  0  10 12
  // 12 12 12 12
  // 12 12 12 16

  // these are indexes mapping each bucket into offset of another buffer
  // - we will use it by rendering particle points again and based on the bucket we look
  // for the offset in parallel prefix map and append the index of the particle into
  // this offset+count of particles already in the offset (tracked in pardexBucketOfs)

  GroupBase {
    // pm: "prefixSweeps"

    Shader { file: "pardexSweepUp" }
    Repeater {
      model: 20
      RenderTarget {
        id: prefixUp
        property int wkw: 1024/Math.pow(2, Math.max(0, index+1-10))
        property int wkh: 1024/Math.pow(2, Math.min(10, index+1))
        RenderTargetLayer {
          textureRT: "prefixTemp"+prefixUp.wkw+"x"+prefixUp.wkh; format: "R32F"; width: prefixUp.wkw; height: prefixUp.wkh
          //Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexBucketCounts" } // read
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexBucketPrefix" } // write
        DrawVB {
          type: "quad"
          depthTest: false
          depthWrite: false
          blendMode: "off"
          ShaderParam { paramName: "loop"; paramValue: index }
          ShaderParam { paramName: "wkw"; paramValue: prefixUp.wkw }
        }
      }
    }

    Shader { file: "pardexSweepDown" }
    Repeater {
      model: 20
      RenderTarget {
        id: prefixDown
        property int wkw: 1024/Math.pow(2, Math.max(0, 19-index+1-10))
        property int wkh: 1024/Math.pow(2, Math.min(10, 19-index+1))
        RenderTargetLayer {
          textureRT: "prefixTemp"+prefixDown.wkw+"x"+prefixDown.wkh; format: "R32F"; width: prefixDown.wkw; height: prefixDown.wkh
          //Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexBucketPrefix" } // write
        DrawVB {
          type: "quad"
          depthTest: false
          depthWrite: false
          blendMode: "off"
          ShaderParam { paramName: "loop"; paramValue: 19-index }
          ShaderParam { paramName: "wkw"; paramValue: prefixDown.wkw }
        }
      }
    }


  }



  Shader { file: "pardexPrefixPrev" }
  RenderTarget {
    RenderTargetLayer {
      textureRT: "pardexPrefixPrev"; format: "RGBA32F"; width: 1024; height: 1024
    }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "testFixed" } // read
    // Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexBucketPrefix" } // read
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexBucketCounts" } // read
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexTransmittance" } // read

    Texture { textureUnit: 3; imageUnit: 3; textureRT: "pardexFree" }
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "pardexActive" }
    Texture { textureUnit: 5; imageUnit: 5; textureRT: "pardexPos" }
    Texture { textureUnit: 6; imageUnit: 6; textureRT: "pardexAge" }

    DrawVB {
      type: "quad"
      depthTest: false
      depthWrite: false
      blendMode: "off"
    }
  }


  RenderTarget {
    RenderTargetLayer {
      textureRT: "pardexBucketCounts"; format: "R32F"; width: 1024; height: 1024
      Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
    }
  }

  Shader { file: "pardexMakeOfs" }
  RenderTarget {
    RenderTargetLayer {
      textureRT: "pardexAge"; format: "RGBA32F"; width: pardexW; height: pardexH
    }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexBucketPrefix" } // read
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexBucketCounts" } // write
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexPos" } // read
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "pardexOfs" } // write
    DrawVB {
      type: "quad"
      depthTest: false
      depthWrite: false
      blendMode: "off"
      ShaderParam { paramName: "partNum"; paramValue: partNum }
      drawBuffers: 0
    }
  }

  property int particlesNum: 0
  //    ShaderAtomicCounter {
  //        id: pardexActiveSAC
  //        enabled: updateRoundsMod > 0
  //        pm: "pardexActiveSAC"
  //        name: effect.name+".sacPardexActiveNum"+frameRot; bind: 0
  //        property int particlesCount: value
  //        onValueChanged: {
  //            //console.log("particles:"+value)
  //            var v = value;
  //            if (resetParticles) {
  //                particlesNum = v;
  //            } else {
  //                if (v !== 0) {
  //                    particlesNum = v;
  //                }
  //            }

  //            //D2 root.setCustomText(effect.name, effect.name+": particle count", "Particles:"+particlesNum);
  //        }
  //    }


  property int partNum: s("draw.num")

  Texture { textureUnit: 0; imageUnit: 0; textureRT: "pardexPos" } // read
  Texture { textureUnit: 1; imageUnit: 1; textureRT: "pardexOfs" } // read
  Texture { textureUnit: 2; imageUnit: 2; textureRT: "pardexTransmittance" } // read
  Texture { textureUnit: 3; imageUnit: 3; textureRT: "pardexAge" } // read
  Texture { textureUnit: 4; imageUnit: 4; textureRT: "pardexVel" } // read

  // light view RT's
  Texture {
    textureUnit: 3;
    textureRT: lighterIndex > 0 ? ("view"+"lighter"+lighterIndex+"_depth") : ""
  }  // rendered by LighterView, contains solid shadow casters

  TextureSel { id: tex; nameOverride: effect.name+".mat.diff.texInd"; textureUnit: 0; }
  TextureImage { textureUnit: 1;  file: "../../images/system/random16.png" }

  TextureSel { id: texAgePal1; nameOverride: effect.name+".draw.agePal1.texInd"; textureUnit: 2; }
  TextureSel { id: texAgePal2; nameOverride: effect.name+".draw.agePal2.texInd"; textureUnit: 4; }


  Shader {
    id: drawShader
    property int fileSel: s("draw.shaderIndex")
    file: {
      if (fileSel===0) return "pardexDraw";
      if (fileSel===1) return "pardexDrawG";
      return "pardexDraw";
    }
  }
  DrawVB {
    type: "emptyVBO"
    primType: drawShader.fileSel===0 ? "triangles" : "points"
    vboId: sceneName+effect.name+"pardex"
    depthTest: true; depthWrite: effect.depthWrite
    blendMode: blendSel(effect.name)

    drawNumPoints: drawShader.fileSel===0 ? 6*partNum : partNum

    secondView: "lightPardexView"
    secondView2: lighterIndex > 0 ? ("view"+"lighter"+lighterIndex) : ""

    drawBuffers: 4
    drawBufferRT3: "pardexMask"

    drawBufferRT2: "depth"

    drawBufferRT4: "emitBuf"

    Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
    Pos { x: 0.0; y: 0.0; z: 0.0}
    Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }

    ShaderParam { paramName: "drawSize"; paramValue: s("draw.size") }

    ShaderParam { paramName: "shadowZOfs"; paramValue: s("shadow.z.ofs") }
    ShaderParam { paramName: "shadowZScale"; paramValue: s("shadow.z.scale") }

    ShaderParam { paramName: "drawAlpha"; paramValue: s("draw.alpha") }
    ShaderParam { paramName: "drawAlphaZero"; paramValue: s("draw.alphaZero") }
    ShaderParam { paramName: "drawAlphaSmooth"; paramValue: s("draw.alphaSmooth") }
    ShaderParam { paramName: "bright"; paramValue: s("draw.bright") }
    ShaderParam { paramName: "colorR"; paramValue: s("draw.colorR") }
    ShaderParam { paramName: "colorG"; paramValue: s("draw.colorG") }
    ShaderParam { paramName: "colorB"; paramValue: s("draw.colorB") }
    ShaderParam { paramName: "lightExp"; paramValue: s("draw.lightExp") }

     ShaderParam { paramName: "baseDim"; paramValue: transmitGridBD }

    ShaderParam { paramName: "shadowDebug"; paramValue: s("shadow.debug") }


    ShaderParam { paramName: "agePal1Amp"; syncName: ns("draw.agePal1.amp"); syncDefault: 0.0 }
    ShaderParam { paramName: "agePal1Freq"; syncName: ns("draw.agePal1.freq"); syncDefault: 1.0 }
    ShaderParam { paramName: "agePal1Base"; syncName: ns("draw.agePal1.base"); syncDefault: 0.0 }
    ShaderParam { paramName: "agePal1Op"; syncName: ns("draw.agePal1.op"); syncDefault: 0.0 }

    ShaderParam { paramName: "agePal2Amp"; syncName: ns("draw.agePal2.amp"); syncDefault: 0.0 }
    ShaderParam { paramName: "agePal2Freq"; syncName: ns("draw.agePal2.freq"); syncDefault: 1.0 }
    ShaderParam { paramName: "agePal2Base"; syncName: ns("draw.agePal2.base"); syncDefault: 0.0 }
    ShaderParam { paramName: "agePal2Op"; syncName: ns("draw.agePal2.op"); syncDefault: 0.0 }


    ShaderParam { paramName: "puffEnabled"; paramValue: s("draw.puff.enabled") }
    ShaderParam { paramName: "puffFreq"; paramValue: s("draw.puff.freq") }
    ShaderParam { paramName: "noiseOct"; paramValue: s("draw.puff.noiseOct") }
    ShaderParam { paramName: "noiseOctMul"; paramValue: s("draw.puff.noiseOctMul") }
    ShaderParam { paramName: "noiseOctAmp"; paramValue: s("draw.puff.noiseOctAmp") }
    ShaderParam { paramName: "noiseSplineEnabled"; paramValue: s("draw.puff.noiseSpline") }

    ShaderParam { paramName: "lighterShadow"; paramValue: s("shadow.fromLighter.ON", 0.0) }
    ShaderParam { paramName: "lighterShadowAmbient"; paramValue: s("shadow.fromLighter.ambient", 0.5) }

    ShaderParam { paramName: "shadowEnabled"; paramValue: shadowsOn }

    ShaderParam { paramName: "simMode"; paramValue: s("sim.mode") } // 0.0 = new pos per frame, 1.0 = mou particles mode

    ShaderParam { paramName: "activeParticlesNum"; paramValue: particlesNum }

    ShaderParam { paramName: "g_time"; paramValue: lastUpdate }

    ShaderParam { paramName: "depthWrite"; paramValue: depthWrite }

  }

//  Blit { textureRT: "pardexMask"; blitRT: 1 }

  Shader { file: "shadowArea" }
  DrawVB {
    enabled: s("shadow.debug") > 0.5 && (shadowsOn > 0.5)

    type: "emptyVBO"
    primType: "triangles"
    vboId: sceneName+effect.name+"pardex"
    depthTest: true; depthWrite: false
    blendMode: "add"

    drawNumPoints: 6*6

    secondView: "lightPardexView"

    ShaderParam { paramName: "shadowZOfs"; paramValue: s("shadow.z.ofs") }
    ShaderParam { paramName: "shadowZScale"; paramValue: s("shadow.z.scale") }


  }
  /**/

}
