import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "emitPart"
  effectName: "EmitPart"
  property EmitPartImpl impl
  Component {
    id: ec
    EmitPartImpl {}
  }
  property int maxParticles: 1000000
  property bool clearParticleEmits: true

  enabled: syncRoot(effect.name+".ON");
  onEffectRender: {
    if (sceneName !== "") {
      if (enabled && !impl) {
        impl = ec.createObject(effect,
                               { name: effect.name,
                                 effectName: effect.effectName,
                                 maxParticles: effect.maxParticles,
                                 clearParticleEmits: effect.clearParticleEmits
                               } );
      }
      if (!enabled && impl) {
        impl.destroy();
        impl = undefined;
      }
    }
  }
}
