import QtQuick 2.4

// import AdaptDemoSystem 1.0
import "./"
import "./_SharedQML"

Item {

  Rectangle {
    anchors.fill: parent
    color: "black"
    border.width: 1
    border.color: "white"
  }
  Text {
    anchors.top: parent.top
    anchors.left: parent.left
    anchors.right: parent.right
    anchors.margins: 10
    text: "Textures"
    horizontalAlignment: Text.AlignHCenter
    color: "white"
    font.pixelSize: 12
  }
  TextureList {
    id: tl
  }

  Flickable {
    id: texViewFlick
    anchors.fill: parent
    contentHeight: texLists.height
    anchors.margins: 10
    anchors.topMargin: 32

    onContentYChanged: {
      texThumbsUpdated(contentY);
      rocket.markUpdateFrequent();
    }

    clip: true

    Column {
      id: texLists
      anchors.top: parent.top
      anchors.left: parent.left
      anchors.right: parent.right

      TexturesViewSingleList {
        title: "texInd 0-999"
        baseIndex: 0
        texList: tl.texList0
      }
      TexturesViewSingleList {
        title: "texInd 1000-1999 (rendertargets)"
        baseIndex: 1000
        texList: tl.texList1
      }
      TexturesViewSingleList {
        title: "texInd 2000-2999"
        baseIndex: 2000
        texList: tl.texList2
      }
      TexturesViewSingleList {
        title: "texInd 3000-3999"
        baseIndex: 3000
        texList: tl.texList3
      }
      TexturesViewSingleList {
        title: "texInd 4000-4999"
        baseIndex: 4000
        texList: tl.texList4
      }

    }
  }

}
