/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;

public class sketch_1dshooter
extends PApplet {
    Level level;
    ArrayList<Enemy> enemies;
    ArrayList<Bullet> bullets = new ArrayList();
    ArrayList<Splat> splats = new ArrayList();
    Gate gate;
    float transition = 1.0f;
    float flash = 0.0f;
    boolean dead = false;
    boolean showmap = false;
    float playerx = 5.0f;
    float playery = 58.0f;
    float dirx;
    float diry;
    float rot = (float)Math.PI;
    float minimapscale = 4.0f;
    float rotspeed = 1.5707964f;
    float speed = 1.5f;
    float bulletspeed = 3.0f;
    float top = 520.0f;
    float t = 0.0f;
    float lt = 0.0f;
    float delta;
    float aggro = 5.0f;
    float enyspeed = 0.25f;
    float health = 100.0f;
    float firedelay = 0.0f;
    boolean kdw;
    boolean kds;
    boolean kda;
    boolean kdd;

    public void setup() {
        this.noCursor();
        this.stroke(255);
        this.colorMode(3);
        this.loadLevel(0);
    }

    public void restart() {
        this.loadLevel(0);
        this.health = 100.0f;
        this.dead = false;
    }

    public boolean checkCollision(float px, float py) {
        int pxlx = PApplet.parseInt((float)sketch_1dshooter.floor((float)px));
        int pxly = PApplet.parseInt((float)sketch_1dshooter.floor((float)py));
        int pxl = pxly * 64 + pxlx;
        if (pxl < 0 || pxl >= this.level.map.pixels.length) {
            return true;
        }
        if (this.level.map.pixels[pxl] != this.color(0)) {
            return true;
        }
        int e = 0;
        while (e < this.enemies.size()) {
            if (this.enemies.get(e).hit(pxlx, pxly)) {
                return true;
            }
            ++e;
        }
        return false;
    }

    public void drawminimap() {
        float offx = 806.0f;
        float offy = this.top + 160.0f;
        this.image(this.level.map, offx, offy, 64.0f * this.minimapscale, 64.0f * this.minimapscale);
        this.fill(128.0f, 255.0f, 128.0f);
        this.rect(offx + this.playerx * this.minimapscale, offy + this.playery * this.minimapscale, this.minimapscale, this.minimapscale);
        this.fill(255.0f, 255.0f, 128.0f);
        for (Enemy enemy : this.enemies) {
            this.rect(offx + enemy.x * this.minimapscale, offy + enemy.y * this.minimapscale, this.minimapscale, this.minimapscale);
        }
        this.fill(200.0f, 255.0f, 128.0f);
        for (Bullet bullet : this.bullets) {
            this.rect(offx + bullet.x * this.minimapscale, offy + bullet.y * this.minimapscale, this.minimapscale, this.minimapscale);
        }
        this.fill(200.0f, 255.0f, 255.0f);
        this.rect(offx + this.level.gate.x, offy + this.level.gate.x, this.minimapscale, this.minimapscale);
        this.stroke(200.0f, 255.0f, 255.0f);
        this.line(offx + this.playerx, offy + this.playery, offx + this.playerx + this.dirx * 5.0f, offy + this.playery + this.diry * 5.0f);
        this.noStroke();
    }

    public void draw() {
        this.lt = this.t;
        this.t = (float)this.millis() / 1000.0f;
        this.delta = this.t - this.lt;
        this.firedelay -= this.delta;
        this.background(0);
        this.dirx = sketch_1dshooter.sin((float)this.rot);
        this.diry = sketch_1dshooter.cos((float)this.rot);
        if (this.kdw) {
            if (!this.checkCollision(this.playerx + this.dirx * this.speed, this.playery + this.diry * this.speed)) {
                this.playery += this.diry * this.speed * this.delta;
                this.playerx += this.dirx * this.speed * this.delta;
            }
        } else if (this.kds && !this.checkCollision(this.playerx - this.dirx * this.speed, this.playery - this.diry * this.speed)) {
            this.playery -= this.diry * this.speed * this.delta;
            this.playerx -= this.dirx * this.speed * this.delta;
        }
        if (this.kda) {
            this.rot += this.rotspeed * this.delta;
        } else if (this.kdd) {
            this.rot -= this.rotspeed * this.delta;
        }
        ArrayList<Bullet> livebullets = new ArrayList<Bullet>();
        int bl = 0;
        while (bl < this.bullets.size()) {
            Bullet b = this.bullets.get(bl);
            b.x += b.dx * this.bulletspeed * this.delta;
            b.y += b.dy * this.bulletspeed * this.delta;
            boolean hashit = false;
            if (b.enemybullet) {
                if (this.playerx < b.x + 0.2f && this.playerx > b.x - 0.2f && this.playery < b.y + 0.2f && this.playery > b.y - 0.2f) {
                    this.health -= (float)b.dmg;
                    hashit = true;
                    this.flash = 0.2f;
                }
            } else {
                int e = 0;
                while (e < this.enemies.size()) {
                    if (!b.enemybullet && this.enemies.get(e).hit(b.x, b.y)) {
                        this.enemies.get(e).damage(b.dmg);
                        hashit = true;
                        if (this.enemies.get((int)e).health <= 0) {
                            this.splats.add(new Splat(b.x, b.y, 0.4f));
                        } else {
                            this.splats.add(new Splat(b.x, b.y));
                        }
                    }
                    ++e;
                }
            }
            int pxlx = PApplet.parseInt((float)sketch_1dshooter.floor((float)b.x));
            int pxly = PApplet.parseInt((float)sketch_1dshooter.floor((float)b.y));
            int pxl = pxly * 64 + pxlx;
            if (pxl >= 0 && pxl < this.level.map.pixels.length && this.level.map.pixels[pxl] == this.color(0) && !hashit) {
                livebullets.add(b);
            }
            ++bl;
        }
        this.bullets = livebullets;
        ArrayList<Enemy> liveEnemies = new ArrayList<Enemy>();
        int e = 0;
        while (e < this.enemies.size()) {
            Enemy eny = this.enemies.get(e);
            float enyd = this.distance(this.playerx, this.playery, eny.x, eny.y);
            if (enyd < this.aggro) {
                float etx = (this.playerx - eny.x) / enyd;
                float ety = (this.playery - eny.y) / enyd;
                eny.x += etx * this.enyspeed * this.delta;
                eny.y += ety * this.enyspeed * this.delta;
                if (eny.firedelay <= 0.0f) {
                    this.bullets.add(new Bullet(eny.x, eny.y, etx, ety, 10, true));
                    eny.firedelay = 3.5f;
                }
            }
            eny.firedelay -= this.delta;
            if (eny.health > 0) {
                liveEnemies.add(this.enemies.get(e));
            }
            ++e;
        }
        this.enemies = liveEnemies;
        ArrayList<Splat> livesplats = new ArrayList<Splat>();
        int e2 = 0;
        while (e2 < this.splats.size()) {
            if (this.splats.get((int)e2).lifetime > 0.0f) {
                this.splats.get((int)e2).lifetime -= this.delta;
                livesplats.add(this.splats.get(e2));
            }
            ++e2;
        }
        float gd = this.distance(this.playerx, this.playery, this.level.gate.x, this.level.gate.y);
        if (gd < 2.0f) {
            this.transition = 1.0f;
            this.loadLevel(this.level.gate.target);
        }
        if (this.health <= 0.0f) {
            this.dead = true;
            this.transition = 1.0f;
        }
        this.splats = livesplats;
        this.dirx = sketch_1dshooter.sin((float)this.rot);
        this.diry = sketch_1dshooter.cos((float)this.rot);
        if (this.showmap) {
            this.drawminimap();
        }
        this.noStroke();
        if (this.transition > 0.0f) {
            this.transition -= this.delta;
            int i = 1;
            while (i <= 64) {
                int shading = this.color(this.dead ? 0 : 66, 255, PApplet.parseInt((float)(255.0f * this.transition)));
                this.fill(shading);
                this.rect(i * 40, this.top, 40.0f, 40.0f);
                ++i;
            }
        } else {
            int i = 1;
            while (i <= 64) {
                float cdirx = sketch_1dshooter.sin((float)(this.rot - 1.5707964f * (float)i / 64.0f + 0.7853982f - 0.2617994f));
                float cdiry = sketch_1dshooter.cos((float)(this.rot - 1.5707964f * (float)i / 64.0f + 0.7853982f - 0.2617994f));
                int shading = this.trace(this.playerx, this.playery, cdirx, cdiry);
                this.fill(shading);
                this.rect(i * 40, this.top, 40.0f, 40.0f);
                ++i;
            }
            if (this.flash > 0.0f) {
                this.flash -= this.delta;
                this.fill(this.color(0.0f, 255.0f, 255.0f, this.flash / 0.2f * 255.0f));
                this.rect(40.0f, this.top, 1940.0f, 40.0f);
            }
        }
        this.fill(0.0f, 255.0f, this.health / 100.0f * 255.0f);
        this.rect(0.0f, this.top, 40.0f, 40.0f);
    }

    public void keyPressed() {
        if (this.keyCode == 27) {
            this.exit();
        } else if (this.key == 'w' || this.key == '\uffff' && this.keyCode == 38) {
            this.kdw = true;
        } else if (this.key == 's' || this.key == '\uffff' && this.keyCode == 38) {
            this.kds = true;
        } else if (this.key == 'a' || this.key == '\uffff' && this.keyCode == 38) {
            this.kda = true;
        } else if (this.key == 'd' || this.key == '\uffff' && this.keyCode == 38) {
            this.kdd = true;
        } else if (this.key == ' ' && this.firedelay <= 0.0f) {
            this.bullets.add(new Bullet(this.playerx, this.playery, this.dirx, this.diry, 50, false));
            this.firedelay = 1.0f;
        } else if (this.key == 'l') {
            this.showmap = !this.showmap;
        } else if (this.key == 'r') {
            this.restart();
        }
    }

    public void keyReleased() {
        if (this.key == 'w' || this.key == '\uffff' && this.keyCode == 38) {
            this.kdw = false;
        } else if (this.key == 's' || this.key == '\uffff' && this.keyCode == 38) {
            this.kds = false;
        } else if (this.key == 'a' || this.key == '\uffff' && this.keyCode == 38) {
            this.kda = false;
        } else if (this.key == 'd' || this.key == '\uffff' && this.keyCode == 38) {
            this.kdd = false;
        }
    }

    public int trace(float ox, float oy, float dx, float dy) {
        int q = 0;
        int i = 0;
        while (i < 80) {
            float px = ox;
            float py = oy;
            int pxl = PApplet.parseInt((float)sketch_1dshooter.floor((float)(py += dy * (float)i * 0.2f))) * 64 + PApplet.parseInt((float)sketch_1dshooter.floor((float)(px += dx * (float)i * 0.2f)));
            if (pxl < 0 || pxl >= this.level.map.pixels.length) break;
            int bright = PApplet.parseInt((float)((80.0f - (float)i) / 80.0f * 255.0f));
            int c = this.level.map.pixels[pxl];
            q = this.color(this.hue(c), this.saturation(c), bright);
            if (this.level.map.pixels[pxl] != this.color(0)) break;
            boolean hit = false;
            int e = 0;
            while (e < this.enemies.size()) {
                if (this.enemies.get(e).hit(px, py)) {
                    q = this.color(20, 255, bright);
                    hit = true;
                }
                ++e;
            }
            e = 0;
            while (e < this.bullets.size()) {
                if (this.bullets.get(e).rayhit(px, py)) {
                    q = this.color(128, 255, bright);
                    hit = true;
                }
                ++e;
            }
            e = 0;
            while (e < this.splats.size()) {
                if (this.splats.get(e).rayhit(px, py)) {
                    q = this.color(0, 255, bright);
                    hit = true;
                }
                ++e;
            }
            if (px < this.gate.x + 0.3f && px > this.gate.x - 0.3f && py < this.gate.y + 0.3f && py > this.gate.y - 0.3f) {
                q = this.color(200, 255, bright);
                hit = true;
            }
            if (hit) {
                return q;
            }
            ++i;
        }
        return q;
    }

    public float distance(float ax, float ay, float bx, float by) {
        float a = ax - bx;
        float b = ay - by;
        return sketch_1dshooter.sqrt((float)(a * a + b * b));
    }

    public void loadLevel(int id) {
        this.level = new Level(id);
        this.enemies = this.level.enemys;
        this.bullets.clear();
        this.splats.clear();
        this.gate = this.level.gate;
        this.playerx = this.level.spawnx;
        this.playery = this.level.spawny;
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#000000", "--hide-stop", "sketch_1dshooter"};
        if (passedArgs != null) {
            PApplet.main((String[])sketch_1dshooter.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Bullet {
        float size = 0.07f;
        public float x;
        public float y;
        public float dx;
        public float dy;
        public int dmg = 50;
        public boolean enemybullet = false;

        public Bullet(float bx, float by, float bdx, float bdy, int dg, boolean eb) {
            this.x = bx;
            this.y = by;
            this.dx = bdx;
            this.dy = bdy;
            this.dmg = dg;
            this.enemybullet = eb;
        }

        public boolean rayhit(float px, float py) {
            return px < this.x + this.size && px > this.x - this.size && py < this.y + this.size && py > this.y - this.size;
        }
    }

    class Enemy {
        public float x;
        public float y;
        int health = 100;
        float size = 0.2f;
        float firedelay = 0.0f;

        public Enemy(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public boolean hit(float px, float py) {
            return px < this.x + this.size && px > this.x - this.size && py < this.y + this.size && py > this.y - this.size;
        }

        public void damage(int dmg) {
            this.health -= dmg;
        }
    }

    class Gate {
        float x;
        float y;
        int target;

        public Gate(float px, float py, int tgt) {
            this.x = px;
            this.y = py;
            this.target = tgt;
        }
    }

    class Level {
        int id;
        ArrayList<Enemy> enemys = new ArrayList();
        PImage map;
        Gate gate;
        float spawnx;
        float spawny;

        public Level(int id) {
            String[] lines;
            this.loadMap(id);
            String[] stringArray = lines = sketch_1dshooter.this.loadStrings("levels/map" + id + ".txt");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String[] pars;
                String l = stringArray[n2];
                if (l.startsWith("gate:")) {
                    pars = l.substring(5).split(":");
                    float gx = sketch_1dshooter.parseFloat((String)pars[0]);
                    float gy = sketch_1dshooter.parseFloat((String)pars[1]);
                    int tgt = sketch_1dshooter.parseInt((String)pars[2]);
                    this.gate = new Gate(gx, gy, tgt);
                } else if (l.startsWith("spwn:")) {
                    pars = l.substring(5).split(":");
                    this.spawnx = sketch_1dshooter.parseFloat((String)pars[0]);
                    this.spawny = sketch_1dshooter.parseFloat((String)pars[1]);
                } else {
                    pars = l.split(":");
                    float ex = sketch_1dshooter.parseFloat((String)pars[0]);
                    float ey = sketch_1dshooter.parseFloat((String)pars[1]);
                    this.enemys.add(new Enemy(ex, ey));
                }
                ++n2;
            }
        }

        public void loadMap(int mapid) {
            this.map = sketch_1dshooter.this.loadImage("levels/map" + mapid + ".png");
            this.map.loadPixels();
        }
    }

    class Splat {
        public float lifetime = 0.25f;
        public float x;
        public float y;
        float size = 0.1f;

        public Splat(float sx, float sy) {
            this.x = sx;
            this.y = sy;
        }

        public Splat(float sx, float sy, float sz) {
            this.x = sx;
            this.y = sy;
            this.size = sz;
        }

        public boolean rayhit(float px, float py) {
            return px < this.x + this.size && px > this.x - this.size && py < this.y + this.size && py > this.y - this.size;
        }
    }
}

