
class MenuButton: Button 
{
    Vector3 sizes = Vector3(300, 1,50);
    pFloat active = 1.1;
    pFloat pressed = 0.9; 

    weakref<Object> mObj;
    Label@ mLabel;

    MenuButton(Scene@ scene, String text, pFloat width = 300, pFloat height = 50 ) {

        sizes = Vector3(width, 1, height);

        BitmapFont@ myFont = GAME.resourcePool.getBitmapFont(GAME.assetRoot + "Fonts/blightfont.fnt");
	    //Construct a label
	 	Label@ msg = Label(myFont, text);
    		
		Object@ obj = GAME.objectFactory.createCube();

		obj.model.setColor(GRAY);
        obj.setScale(sizes);

		obj.setPosition(msg.width * 0.5, 1, -msg.height * 0.5);
		obj.combine(msg);

        scene.add(obj);
       

        @obj.userRef = this;
        @mObj = obj;
    }

    void enable() {
        auto object = mObj.get();
        if (object is null) return;

        object.model.visible = true;
        Button::enable();
    }

    void disable() {
        auto object = mObj.get();
        if (object is null) return;

        object.model.visible = false;
        Button::disable();
    }


    void set_position(Vector3 pos) {
        auto object = mObj.get();
        if (object is null) return;
        object.position = pos;
    }
    
    void hover() {
        //overload this to change the state of the button at the appropriate time
        auto object = mObj.get();
        if (object is null) return;
        object.applyScale(active);
        Button::hover();
    }

    void buttonDown() {
        auto object = mObj.get();
        if (object is null) return;
        Button::buttonDown();
        object.applyScale(pressed);
    }

    void buttonUp() {
        auto object = mObj.get();
        if (object is null) return;
      
        object.setScale(sizes);
        if (mActive)
            object.applyScale(active);
        Button::buttonUp(); 
    }

    void endHover() {
        auto object = mObj.get();
        if (object is null) return;
        object.setScale(sizes);
        Button::endHover();
    }
}
