#include "Button.as"


class GUI {
    Window@ mWindow;
    Scene@ mScene;
    
    Map<pUInt, Button@> mButtons;
    private Button@ mActivated;
    private pInt mCurrentSelection = 0;
    
    GUI(Window@ window, Scene@ scene) {
        @mScene = scene;
        GAME.control.addScene(mScene);
        @mWindow = window;
    }

    void activate() {
        GAME.control.Input.mouseMove() += MouseMoveCallback(this.onMouseMove);
        GAME.control.Input.mouseButtonDown(PMB_LEFT) += MouseButtonCallback(this.mouseButtonDown);
        GAME.control.Input.mouseButtonUp(PMB_LEFT) += MouseButtonCallback(this.mouseButtonUp);

        GAME.control.Input.key(PK_UP) += KeyCallback(this.onSelectKeyDown);
        GAME.control.Input.key(PK_DOWN) += KeyCallback(this.onSelectKeyDown);
        GAME.control.Input.key(PK_w) += KeyCallback(this.onSelectKeyDown);
        GAME.control.Input.key(PK_s) += KeyCallback(this.onSelectKeyDown);

        GAME.control.Input.keyDown(PK_RETURN) += KeyStateCallback(this.onActionKeyDown);
        GAME.control.Input.keyUp(PK_RETURN) += KeyStateCallback(this.onActionKeyUp);

        GAME.control.Input.keyDown(PK_SPACE) += KeyStateCallback(this.onActionKeyDown);
        GAME.control.Input.keyUp(PK_SPACE) += KeyStateCallback(this.onActionKeyUp);
    }

    void deactivate() {
        GAME.control.Input.mouseMove() -= MouseMoveCallback(this.onMouseMove);
        GAME.control.Input.mouseButtonDown(PMB_LEFT) -= MouseButtonCallback(this.mouseButtonDown);
        GAME.control.Input.mouseButtonUp(PMB_LEFT) -= MouseButtonCallback(this.mouseButtonUp);


        GAME.control.Input.key(PK_UP) -= KeyCallback(this.onSelectKeyDown);
        GAME.control.Input.key(PK_DOWN) -= KeyCallback(this.onSelectKeyDown);
        GAME.control.Input.key(PK_w) -= KeyCallback(this.onSelectKeyDown);
        GAME.control.Input.key(PK_s) -= KeyCallback(this.onSelectKeyDown);
        GAME.control.Input.keyDown(PK_RETURN) -= KeyStateCallback(this.onActionKeyDown);
        GAME.control.Input.keyUp(PK_RETURN) -= KeyStateCallback(this.onActionKeyUp);

        GAME.control.Input.keyDown(PK_SPACE) -= KeyStateCallback(this.onActionKeyDown);
        GAME.control.Input.keyUp(PK_SPACE) -= KeyStateCallback(this.onActionKeyUp);
    }

    void addButton(pUInt tabindex, Button@ button) {
        @mButtons[tabindex] = button;
    }

    void mouseButtonDown(pMouseButton, pInt x, pInt y) {
        mWindow.pick(x, y, PickingCallback(this.mouseButtonDownPick));
    }

    void mouseButtonDownPick(Scene@ s, Object@ obj, Vector3 pos, Vector3 normal) {
       if (s !is mScene) return; 
       if (obj is null) return;
       
       
        auto@ button = cast<Button>(obj.userRef);
        if (button !is null) {
            @mActivated = button;
            mActivated.buttonDown();
        }
    }

    
    void mouseButtonUp(pMouseButton, pInt x, pInt y) {
        mWindow.pick(x, y, PickingCallback(this.mouseButtonUpPick));
    }

    void mouseButtonUpPick(Scene@ s, Object@ obj, Vector3 pos, Vector3 normal) {
       if (s !is mScene) return; 
       if (obj is null) return;
       
       
        auto@ button = cast<Button>(obj.userRef);
        if (button !is null) {
            @mActivated = button;
            mActivated.buttonUp();
        }
    }



    void onSelectKeyDown(pKeyCode code, pByte count) 
    {
        count += 1;

        for (pByte i = 0; i < count; ++i)  {
            pInt step = (code == PK_UP || code == PK_w) ? -1 : 1;
            pInt selection = mCurrentSelection + step;

            if (selection > mButtons.size())
                selection = 1;
            else if (selection <= 0)
                selection = mButtons.size();

            for(auto it = mButtons.begin(); it++;){
                if (it.key >= pUInt(selection)) {
                    it.value.hover();

                    auto button = findSelectedButton();
                    if (button !is null)
                        button.endHover();

                    mCurrentSelection = it.key;
                    return;
                }
            }
        }
    }

    
    Button@ findSelectedButton() {
        if (mCurrentSelection == -1) return null;
        auto it = mButtons.find_iterator(mCurrentSelection);
        if (it == mButtons.end()) return null;
        return it.value;
    }

    void onActionKeyDown(pKeyCode code) 
    {
        auto button = findSelectedButton();
        if (button !is null)
            button.buttonDown();
    }

    void onActionKeyUp(pKeyCode code) 
    {
        auto button = findSelectedButton();
        if (button !is null)
            button.buttonUp();
    }


    void onMouseMove(pInt x, pInt y, pInt xRel, pInt yRel){
        mWindow.pick(x, y, PickingCallback(this.mouseMovePick));
    }

    void mouseMovePick(Scene@ s, Object@ obj, Vector3 pos, Vector3 normal) {
        if (s !is mScene) return; 
       
        if (obj is null || cast<Button>(obj.userRef) is null)  {
            if (mActivated !is null) {
                mActivated.endHover();
                @mActivated = null;
            }
            return;
        }
        

        auto@ button = cast<Button>(obj.userRef);

        if (button !is null) {
            if (mActivated is button) {
                return; //Still the same button
            }
            
            if (mActivated !is null) mActivated.endHover();
            @mActivated = button;    
            mActivated.hover();
        }
    }
}