

funcdef void ButtonCallback(Button@);


class Button : iRefObj 
{
    private pFloat border = 5;

    Action@ onButtonUp;
    Action@ onButtonDown;
    Action@ onHover;
    Action@ onEndHover;

    protected bool mActive = false;
    bool mEnabled = true;

    void disable() {
        mEnabled = false;
    }

    void enable() {
        mEnabled = true;
    }


    void hover() {
        if (!mEnabled) return;
        //overload this to change the state of the button at the appropriate time
        mActive = true;
        if (onHover !is null)  onHover();
    }

    void buttonDown() {
        if (!mEnabled) return;
        if (onButtonDown !is null) onButtonDown();
    }

    void buttonUp() {
        if (!mEnabled) return;
        if (onButtonUp !is null) onButtonUp();
    }

    void endHover() {
        if (!mEnabled) return;
        mActive = false;
        if (onEndHover !is null) onEndHover();
    }
}