


class Beacon
{
    private Object@ mObject;
    private Scene@ mScene;
    private bool mActivated = false;
    
    private PointLight@ mPointLight;
    private Surface@ mGlow;
    private Surface@ mCrystal;
    private Surface@ mLightRing;
    private Surface@ mWellGlow;
    private Surface@ mCenter;

    pFloat mTileSize;

    Action@ activated;

    Beacon() {}
    Beacon(String theme, pFloat x, pFloat y, Scene@ scene, pFloat tilesize)
    {
        mTileSize = tilesize;
        @mScene = scene; 

        Object@ obj = GAME.objectFactory.load(GAME.assetRoot + "/3D/Tiles/"+ theme + "/beacon.fbx");
        obj.setScale(mTileSize);
        obj.setPosition(x, y, 0);

        @mGlow = obj.model.getSurface("ADDITIVE_glow");
        @mCrystal = obj.model.getSurface("UNLIT_crystal");
        @mLightRing = obj.model.getSurface("UNLIT_light_ring");
        @mWellGlow = obj.model.getSurface("UNLIT_well_glow");
        @mCenter = obj.model.getSurface("well_center"); //because cisst sux...

        @mObject = obj;

        mObject.model.setColor(WHITE);

        mGlow.material.mode = DM_ADDITIVE;
        mGlow.material.color = BLACK;

        mCrystal.material.mode = DM_EMISSIVE;
        mCrystal.material.color = Color(92, 72, 17, 255);

        mLightRing.material.mode = DM_EMISSIVE;
        mLightRing.material.color = BLACK;
        
        mWellGlow.material.mode = DM_EMISSIVE;
        mWellGlow.material.color = BLACK;

        mCenter.material.mode = DM_EMISSIVE;
        mCenter.material.color = BLACK;

        mScene.add(obj);
    }

    bool opEquals(Beacon& bc) {
        return mObject is bc.mObject;
    }

    void activate() {
        if (mActivated) return;

        mGlow.material.color = WHITE;
        mCrystal.material.color = WHITE;
        mLightRing.material.color = WHITE;
        mWellGlow.material.color = WHITE;
        mCenter.material.color = WHITE;

        @mPointLight = PointLight(mTileSize * 1.2);
        mPointLight.color = Color(79, 185, 204, 255); 
        mPointLight.position = mObject.position;
        mPointLight.translate(0,0, mTileSize * 0.2);
        mScene.add(mPointLight);

        mActivated = true;
        
        if (activated !is null)
        {
            echo ("Activating beacon!");
            activated();
        }
    }

    void reset() {

        mGlow.material.color = BLACK;
        mCrystal.material.color = Color(92, 72, 17, 255);
        mLightRing.material.color = BLACK;
        mWellGlow.material.color = BLACK;
        mCenter.material.color = BLACK;

        mScene.remove(mPointLight);
        @mPointLight = null;

        mActivated = false;
    }
}