#include "../../Input/IPlayer.as"
#include "../Level/PlayField.as"



class Player : IPlayer
{
	private CharacterProxy@ mCharacter;
	private Object@ mObject;
	private Scene@ mScene;
	private SpotLight@ mSpotLight;
	private PointLight@ mPointLight;
	private PlayField@ mPlayField;
	private Animation@ mModelAnim;
	private OpenALSource@ mWalkSound;
	private OpenALSource@ mDieSound;

    private bool mOnCooldown = false;
	private Vector2 mMotion;
	private String mAssetRoot;
	private Direction mCurrentDir = Dir_N;
	private Location mLocation;
	Location get_location() { return mLocation;}
	Vector3 get_position() { return mObject.position; }
	private pInt mLightDistance = 4;
	private Timer@ mWalkTimer;

	pInt get_lightDistance() { return mLightDistance; }
	Direction get_direction() { return mCurrentDir; }

	

	Action@ tick;
	Action@ stepped;

	//Directions
	private Quaternion mWest = Quaternion(Vector3(0,0,1), 0.5*PI);
	private Quaternion mEast= Quaternion(Vector3(0,0,1), -0.5*PI);
	private Quaternion mNorth= Quaternion();
	private Quaternion mSouth= Quaternion(Vector3(0,0,1), 1*PI);



	Player(Scene@ scene, PlayField@ playField) {
		@mPlayField = playField;
		@mScene = scene;		
		

		//@mObject = GAME.objectFactory.createCapsule(0.20, 1.3);
		@mObject = GAME.objectFactory.load(GAME.assetRoot + "3D/actors/character.fbx");
		@mSpotLight = SpotLight(0.25 * PI, mLightDistance * mPlayField.tileSize); 
		mSpotLight.color = WHITE;
		mSpotLight.quaternion = Quaternion(Vector3(0,0,1), PI);
		mSpotLight.rotate(0,0,1,0.35*PI); // rotate light up/down (0.5*PI is straight ahead)
		mSpotLight.setShadowMap(TX_2048, TX_2048);

		@mPointLight = PointLight(4 * mPlayField.tileSize);
		mPointLight.color = Color(40,40,40,255);
		mPointLight.translate(0,0.5, 2.5);		
	
		scene.add(mPointLight);
		scene.add(mSpotLight);

		Locator@ loc = mObject.getLocator("light");
		loc.link.add(mSpotLight, LM_CHILD, pLinkTransformMask(LT_TRANSLATION | LT_ROTATION));
		mObject.link.add(mPointLight, LM_CHILD);

		@mObject.animator = Animator();
		// set initial pose
		@mModelAnim = GAME.resourcePool.getAnimation(GAME.assetRoot + "3D/actors/character.fbx:Take 001");
		resetPose();
		
		mObject.animator.animationEnded += AnimEndedCallback(this.animEnded);
	
		@mDieSound = GAME.audio.createFXSource();
		@mWalkSound = GAME.audio.createFXSource();
		
		mWalkSound.volume = mWalkSound.volume - 0.6;	
		
		@mWalkTimer = GAME.control.createTimer(300, true);
		mWalkTimer.elapsed += Action(this.walkTick);
		mWalkTimer.stop();
	
		mObject.link.add(GAME.audio.getListener(), LM_OVERRIDE);
		mObject.link.add(mWalkSound, LM_OVERRIDE);
			
		mObject.xForm = playField.getSpawnLocation(mLocation);
		scene.add(mObject);
	}

	~Player() {
		mScene.remove(mSpotLight);
		mScene.remove(mPointLight);
		mScene.remove(mObject);
		echo ("Player destroyed!");
	}
	
    private void walkTick() 
    {
		mWalkSound.play(GAME.resourcePool.getSound(GAME.assetRoot + "Sounds/single_step.ogg"));
		mWalkTimer.stop();
	}	

	//We set the last button to be pressed to 1/-1 to indicate it's priority over the other buttons pressed before.
	//However, when released (set to 0) we want the other buttons to still work (when still held down.).
	//An easy way to do this is to just "decay" the other a bit.
	void up(pFloat up) 				{
		if (up > 0)
			mMotion =  Vector2(mMotion.x * 0.99, -1);
		else if (mMotion.y != 1)
			mMotion =  Vector2(mMotion.x, 0);
		move();
	}

	void down(pFloat down) 			{
		if (down > 0)
			mMotion =  Vector2(mMotion.x * 0.99,  1);
		else if (mMotion.y != -1)
			mMotion =  Vector2(mMotion.x, 0);
		move();
	}

	void left(pFloat left)	 		{
		if (left > 0)
			mMotion =  Vector2(-1, mMotion.y * 0.99);
		else if (mMotion.x != 1)
			mMotion =  Vector2(0, mMotion.y);
		move();
	}
	void right(pFloat right) 		{
		if (right > 0)
			mMotion =  Vector2(1, mMotion.y * 0.99);
		else if (mMotion.x != -1)
			mMotion =  Vector2(0, mMotion.y);
		move();
	}

	void strafeUp(pFloat up)		{}
	void strafeDown(pFloat down) 	{}
	void strafeLeft(pFloat left) 	{}
	void strafeRight(pFloat right)	{}
	void jump() 					{}
	void attack1()					{}
	void attack2() 					{}

	void dead()
	{
		mDieSound.play(GAME.resourcePool.getSound(GAME.assetRoot + "Sounds/ghost_hostile.ogg"));
	}	
	
	void reset() {
		mObject.animator.stopAll();
		mObject.xForm = mPlayField.getSpawnLocation(mLocation);
		mMotion = Vector2(0,0);
		mCurrentDir = Dir_N;

		resetPose();
	}

	void resetPose() {
		SubAnimation pose(mModelAnim, 0, 1);
		mObject.animator.play(pose, false);
	}

	void animEnded(Entity@ entity, Animation@ anim) {
		if (anim.name != "Turn" && anim.name != "Move")
			return;
	
		mOnCooldown = false;
		if (stepped !is null) stepped();
		move();
	}


	void move() {
		if (mOnCooldown) return;

		//Choose direction		
		Transform newXForm;

		pInt x = 0;
		pInt y = 0;

		//Find out what direction to move in.
		//Let's also update the player direction! For now! Everything feels like a HACK.. FUCK! XD
		//We do this BEFORE we know if we can move there, so the character still rotates.
		Quaternion orn; 
		if (abs(mMotion.x) > abs(mMotion.y)) {
			x = pUInt(mMotion.x + (mMotion.x > 0 ? 0.5 : -0.5)); //Some magic to make sure +/- values get rounded to int properly.
			orn = Quaternion(Vector3(0,0,1), x * -0.5 * PI);
		} else {
			y = pUInt(mMotion.y + (mMotion.y > 0 ? 0.5 : -0.5));
			orn = Quaternion(Vector3(0,0,1), (y+1) * 0.5 * PI);
		}
		
		if (x !=0 || y !=0)	{
			//determine orientation
			Direction newDir;
			
			if (x > 0) newDir = Dir_E;
			else if (x < 0) newDir = Dir_W;
			else if (y > 0) newDir = Dir_S;
			else newDir = Dir_N;

			if (newDir != mCurrentDir) { //Turning motion
				
				ObjectAnimation@ oa = ObjectAnimation("Turn", GAME.animationSpeed);
					switch (newDir)	{
						case Dir_N:
							oa.addFrames(mObject.xForm.quaternion, mNorth);
							break;
						case Dir_E:
							oa.addFrames(mObject.xForm.quaternion, mEast);
							break;
						case Dir_S:
							oa.addFrames(mObject.xForm.quaternion, mSouth);
							break;
						case Dir_W:
							oa.addFrames(mObject.xForm.quaternion, mWest);
							break;
					}

				oa.build(IM_LINEAR);
				mObject.animator.play(oa, false);
				
				mOnCooldown = true;
				mCurrentDir = newDir;

			} else { //Linear motion
				if (mPlayField.updatePlayerLocation(mLocation.x + x, mLocation.y + y, newXForm)) {
					mLocation.x += x;
					mLocation.y += y;

					ObjectAnimation@ oa = ObjectAnimation("Move", GAME.animationSpeed);
					oa.addFrames(Vector3(0,0,0), newXForm.position - mObject.xForm.position);
					oa.build(IM_LINEAR);

					mObject.animator.play(oa, false);
					
					mObject.animator.stop(mModelAnim);
					mObject.animator.play(mModelAnim, false, GAME.animationSpeed);
					
					mWalkSound.play(GAME.resourcePool.getSound(GAME.assetRoot + "Sounds/single_step.ogg"));
					mWalkTimer.start();
							
					mOnCooldown = true;
				} else {
					echo ("Can't go there!");
					return;
				}
			}
			
			//mObject.quaternion = orn;	
			if (tick !is null)
				tick();
		} else {
			//no update
		}
	}
	

    Transform xForm {
        get const { return mObject.xForm; }
        set { mObject.xForm = value; }
    }
    

	Object@ opImplConv() const { return mObject; }

}
