' 3D.BAS
' Written by Andy Goth at MAGFest 2019
' https://facebook.com/andygoth
'
' Note: triangle fill code commented out due to poor performance

' Default all variables to integers
DEFINT A-Z

' Constants
CONST pi = 3.141592
CONST two.pi = pi * 2
CONST max.obj = 2                             ' Object count
CONST max.vert = 32                           ' Vertex count
CONST max.edge = 48                           ' Edge count
CONST max.tri = 12                            ' Triangle count

' Data structures
DIM Ox(1 TO max.vert) AS SINGLE               ' Object vertex X coordinates
DIM Oy(1 TO max.vert) AS SINGLE               ' Object vertex Y coordinates
DIM Oz(1 TO max.vert) AS SINGLE               ' Object vertex Z coordinates
DIM Oo(1 TO max.vert)                         ' Object identifiers
DIM Wx(1 TO max.vert) AS SINGLE               ' World vertex X coordinates
DIM Wy(1 TO max.vert) AS SINGLE               ' World vertex Y coordinates
DIM Wz(1 TO max.vert) AS SINGLE               ' World vertex Z coordinates
DIM Sx(1 TO max.vert), Sy(1 TO max.vert)      ' Screen coordinates
DIM Ei(1 TO max.edge, 1 TO 2)                 ' Edge endpoint indexes
DIM Ec(1 TO max.edge)                         ' Edge colors
DIM Ez(1 TO max.edge) AS SINGLE               ' Edge Z sum
DIM Es(1 TO max.edge)                         ' Edge sort indexes
DIM Ti(1 TO max.tri, 1 TO 3)                  ' Triangle endpoints indexes
DIM Tc(1 TO max.tri)                          ' Triangle colors
DIM Tz(1 TO max.tri) AS SINGLE                ' Triangle Z sum
DIM Ts(1 TO max.tri)                          ' Triangle sort indexes
DIM M(1 TO max.obj, 1 TO 4, 1 TO 4) AS SINGLE ' Matrices
DIM Hl(1), Ht(1), Hr(1), Hb(1)                ' Bounding boxes
DIM Rz(1 TO max.obj) AS SINGLE                ' Rotation about Z axis
DIM Ry(1 TO max.obj) AS SINGLE                ' Rotation about Y axis
DIM Rx(1 TO max.obj) AS SINGLE                ' Rotation about X axis

' Vertices
DATA -1.0,-1.0,-0.1, 1
DATA -1.0, 1.0,-0.1, 1
DATA -0.8, 1.0,-0.1, 1
DATA  0.0,-0.6,-0.1, 1
DATA  0.8, 1.0,-0.1, 1
DATA  1.0, 1.0,-0.1, 1
DATA  1.0,-1.0,-0.1, 1
DATA  0.8,-1.0,-0.1, 1
DATA  0.8, 0.6,-0.1, 1
DATA  0.0,-1.0,-0.1, 1
DATA -0.8, 0.6,-0.1, 1
DATA -0.8,-1.0,-0.1, 1
DATA -1.0,-1.0, 0.1, 1
DATA -1.0, 1.0, 0.1, 1
DATA -0.8, 1.0, 0.1, 1
DATA  0.0,-0.6, 0.1, 1
DATA  0.8, 1.0, 0.1, 1
DATA  1.0, 1.0, 0.1, 1
DATA  1.0,-1.0, 0.1, 1
DATA  0.8,-1.0, 0.1, 1
DATA  0.8, 0.6, 0.1, 1
DATA  0.0,-1.0, 0.1, 1
DATA -0.8, 0.6, 0.1, 1
DATA -0.8,-1.0, 0.1, 1
DATA  1.2, 1.2, 1.2, 2
DATA  1.2, 1.2,-1.2, 2
DATA  1.2,-1.2, 1.2, 2
DATA  1.2,-1.2,-1.2, 2
DATA -1.2, 1.2, 1.2, 2
DATA -1.2, 1.2,-1.2, 2
DATA -1.2,-1.2, 1.2, 2
DATA -1.2,-1.2,-1.2, 2

' Edges
DATA  1,  2, 14
DATA  2,  3, 14
DATA  3,  4, 14
DATA  4,  5, 14
DATA  5,  6, 14
DATA  6,  7, 14
DATA  7,  8, 14
DATA  8,  9, 14
DATA  9, 10, 14
DATA 10, 11, 14
DATA 11, 12, 14
DATA 12,  1, 14
DATA 13, 14,  6
DATA 14, 15,  6
DATA 15, 16,  6
DATA 16, 17,  6
DATA 17, 18,  6
DATA 18, 19,  6
DATA 19, 20,  6
DATA 20, 21,  6
DATA 21, 22,  6
DATA 22, 23,  6
DATA 23, 24,  6
DATA 24, 13,  6
DATA  1, 13, 12
DATA  2, 14, 12
DATA  3, 15, 12
DATA  4, 16, 12
DATA  5, 17, 12
DATA  6, 18, 12
DATA  7, 19, 12
DATA  8, 20, 12
DATA  9, 21, 12
DATA 10, 22, 12
DATA 11, 23, 12
DATA 12, 24, 12
DATA 25, 26, 10
DATA 25, 27, 10
DATA 26, 28, 10
DATA 27, 28, 10
DATA 25, 29, 10
DATA 26, 30, 10
DATA 27, 31, 10
DATA 28, 32, 10
DATA 29, 30, 10
DATA 29, 31, 10
DATA 30, 32, 10
DATA 31, 32, 10

' Triangles
DATA 25, 27, 26, 1
DATA 26, 27, 28, 1
DATA 25, 29, 26, 3
DATA 26, 29, 30, 3
DATA 27, 25, 29, 4
DATA 27, 29, 31, 4
DATA 27, 31, 28, 5
DATA 28, 31, 32, 5
DATA 28, 26, 30, 8
DATA 30, 32, 28, 8
DATA 31, 29, 30, 7
DATA 31, 30, 32, 7

page = 0
alt = 1
SCREEN 9, , page, alt

Ex! = 0         ' Eye X
Ey! = 0         ' Eye Y
Ez! = 3         ' Eye Z
En! = .5        ' Eye near plane
Et! = 0         ' Eye timer

' Load data into arrays
FOR i = 1 TO max.vert
 READ Ox(i), Oy(i), Oz(i), Oo(i)
NEXT
FOR i = 1 TO max.edge
 READ Ei(i, 1), Ei(i, 2), Ec(i)
NEXT
FOR i = 1 TO max.tri
 READ Ti(i, 1), Ti(i, 2), Ti(i, 3), Tc(i)
NEXT

time = 70 * 15

' Main loop
DO WHILE INKEY$ = "" AND time > 0
 time = time - 1
 ' Update rotation
 Rx(1) = Rx(1) + .005
 Ry(1) = Ry(1) + .05
 Rz(1) = Rz(1) + .025
 Ry(2) = Ry(2) - .05
 Rx(2) = Rx(2) + .025
 Rz(2) = Rz(2) + .05

 ' Update eyepoint
 Et! = Et! + .1
 Ex! = COS(Et! * 1.5)
 Ey! = SIN(Et!)
 Ez! = 3.5 + COS(Et! * 2.5)

 ' Create per-object matrices
 FOR i = 1 TO max.obj
  Cz! = COS(Rz(i))
  Sz! = SIN(Rz(i))
  Cy! = COS(Ry(i))
  Sy! = SIN(Ry(i))
  Cx! = COS(Rx(i))
  Sx! = SIN(Rx(i))
  M(i, 1, 1) = Cy! * Cz!
  M(i, 1, 2) = -Cy! * Sz!
  M(i, 1, 3) = Sy!
  M(i, 2, 1) = Sx! * Sy! * Cz! + Cx! * Sz!
  M(i, 2, 2) = -Sx! * Sy! * Sz! + Cx! * Cz!
  M(i, 2, 3) = -Sx! * Cy!
  M(i, 3, 1) = -Cx! * Sy! * Cz! + Sx! * Sz!
  M(i, 3, 2) = Cx! * Sy! * Sz! + Sx! * Cz!
  M(i, 3, 3) = Cx! * Cy!
  M(i, 1, 4) = -Ex!
  M(i, 2, 4) = -Ey!
  M(i, 3, 4) = -Ez!
 NEXT

 ' Erase old page
 LINE (Hl(page), Ht(page))-(Hr(page), Hb(page)), 0, BF

 ' Transform to world and screen coordinates, and find bounding box
 Hl(page) = 640
 Ht(page) = 350
 Hr(page) = 0
 Hb(page) = 0
 FOR i = 1 TO max.vert
  o = Oo(i)
  Wx(i) = M(o, 1, 1) * Ox(i) + M(o, 1, 2) * Oy(i) + M(o, 1, 3) * Oz(i) + M(o, 1, 4)
  Wy(i) = M(o, 2, 1) * Ox(i) + M(o, 2, 2) * Oy(i) + M(o, 2, 3) * Oz(i) + M(o, 2, 4)
  Wz(i) = M(o, 3, 1) * Ox(i) + M(o, 3, 2) * Oy(i) + M(o, 3, 3) * Oz(i) + M(o, 3, 4)
  Sx(i) = 320 - 320 * En! * Wx(i) / Wz(i)
  Sy(i) = 175 + 233 * En! * Wy(i) / Wz(i)
  IF Sx(i) < Hl(page) THEN Hl(page) = Sx(i)
  IF Sy(i) < Ht(page) THEN Ht(page) = Sy(i)
  IF Sx(i) > Hr(page) THEN Hr(page) = Sx(i)
  IF Sy(i) > Hb(page) THEN Hb(page) = Sy(i)
 NEXT

 ' Cull back-facing triangles, and find triangle depths for visible triangles
 ' TODO: Make this work correctly
 Tn = 0
'FOR i = 1 TO max.tri
' Ux! = Wx(Ti(i, 2)) - Wx(Ti(i, 1))
' Uy! = Wy(Ti(i, 2)) - Wy(Ti(i, 1))
' Vx! = Wx(Ti(i, 3)) - Wx(Ti(i, 1))
' Vy! = Wy(Ti(i, 3)) - Wy(Ti(i, 1))
' IF Ux! * Vy! > Vx! * Uy! THEN
'  Tn = Tn + 1
'  Ts(Tn) = i
'  Tz(Tn) = Wz(Ti(i, 1)) + Wz(Ti(i, 2)) + Wz(Ti(i, 3))
' END IF
'NEXT

 ' Sort triangles
 FOR i = Tn - 1 TO 2 STEP -1
  FOR j = 1 TO i
   IF Tz(j + 1) < Tz(j) THEN
    SWAP Ts(j + 1), Ts(j)
   END IF
  NEXT
 NEXT

 ' Draw triangles
 FOR i = 1 TO Tn
  ' Get sorted triangle index
  j = Ts(i)

  ' Sort vertices
  IF Sy(Ti(j, 1)) < Sy(Ti(j, 2)) AND Sy(Ti(j, 1)) < Sy(Ti(j, 3)) THEN
   Ax = Sx(Ti(j, 1))
   Ay = Sy(Ti(j, 1))
   IF Sy(Ti(j, 2)) < Sy(Ti(j, 3)) THEN
    Bx = Sx(Ti(j, 2))
    By = Sy(Ti(j, 2))
    Cx = Sx(Ti(j, 3))
    Cy = Sy(Ti(j, 3))
   ELSE
    Bx = Sx(Ti(j, 3))
    By = Sy(Ti(j, 3))
    Cx = Sx(Ti(j, 2))
    Cy = Sy(Ti(j, 2))
   END IF
  ELSEIF Sy(Ti(j, 2)) < Sy(Ti(j, 1)) AND Sy(Ti(j, 2)) < Sy(Ti(j, 3)) THEN
   Ax = Sx(Ti(j, 2))
   Ay = Sy(Ti(j, 2))
   IF Sy(Ti(j, 1)) < Sy(Ti(j, 3)) THEN
    Bx = Sx(Ti(j, 1))
    By = Sy(Ti(j, 1))
    Cx = Sx(Ti(j, 3))
    Cy = Sy(Ti(j, 3))
   ELSE
    Bx = Sx(Ti(j, 3))
    By = Sy(Ti(j, 3))
    Cx = Sx(Ti(j, 1))
    Cy = Sy(Ti(j, 1))
   END IF
  ELSE
   Ax = Sx(Ti(j, 3))
   Ay = Sy(Ti(j, 3))
   IF Sy(Ti(j, 1)) < Sy(Ti(j, 2)) THEN
    Bx = Sx(Ti(j, 1))
    By = Sy(Ti(j, 1))
    Cx = Sx(Ti(j, 2))
    Cy = Sy(Ti(j, 2))
   ELSE
    Bx = Sx(Ti(j, 2))
    By = Sy(Ti(j, 2))
    Cx = Sx(Ti(j, 1))
    Cy = Sy(Ti(j, 1))
   END IF
  END IF

  Ix! = Ax
  Jx! = Ax
  IF Cy = Ay THEN
   IF Ax < Bx AND Ax < Cx THEN
    IF Bx < Cx THEN
     LINE (Ax, Ay)-(Cx, Cy), Tc(j)
    ELSE
     LINE (Ax, Ay)-(Bx, By), Tc(j)
    END IF
   ELSEIF Bx < Ax AND Bx < Cx THEN
    IF Ax < Cx THEN
     LINE (Bx, By)-(Cx, Cy), Tc(j)
    ELSE
     LINE (Bx, By)-(Ax, Ay), Tc(j)
    END IF
   ELSE
    IF Ax < Bx THEN
     LINE (Cx, Cy)-(Bx, By), Tc(j)
    ELSE
     LINE (Cx, Cy)-(Ax, Ay), Tc(j)
    END IF
   END IF
  ELSE
   Jdx! = (Cx - Ax) / (Cy - Ay)
   IF By = Ay THEN
    LINE (Ax, Ay)-(Bx, By), Tc(j)
   ELSE
    Idx! = (Bx - Ax) / (By - Ay)
    FOR y = Ay TO By
     LINE (Ix!, y)-(Jx!, y), Tc(j)
     Ix! = Ix! + Idx!
     Jx! = Jx! + Jdx!
    NEXT
   END IF
   IF Cy = By THEN
    LINE (Bx, By)-(Cx, Cy), Tc(j)
   ELSE
    Idx! = (Cx - Bx) / (Cy - By)
    Ix! = Bx + Idx!
    FOR y = By + 1 TO Cy
     LINE (Ix!, y)-(Jx!, y), Tc(j)
     Ix! = Ix! + Idx!
     Jx! = Jx! + Jdx!
    NEXT
   END IF
  END IF
 NEXT

 ' Find edge depth values
 FOR i = 1 TO max.edge
  Ez(i) = Wz(Ei(i, 1)) + Wz(Ei(i, 2))
 NEXT

 ' Sort edges
 FOR i = 1 TO max.edge
  Es(i) = i
 NEXT
 FOR i = max.edge - 1 TO 2 STEP -1
  FOR j = 1 TO i
    IF Ez(Es(j + 1)) < Ez(Es(j)) THEN
    SWAP Es(j + 1), Es(j)
   END IF
  NEXT
 NEXT

 ' Draw edges
 FOR i = 1 TO max.edge
  j = Es(i)
  LINE (Sx(Ei(j, 1)), Sy(Ei(j, 1)))-(Sx(Ei(j, 2)), Sy(Ei(j, 2))), Ec(j)
 NEXT

 ' Flip screen
 WAIT &H3DA, 8
 SCREEN 9, , alt, page
 page = alt
 alt = page XOR 1
LOOP

CHAIN "firework.bas"

