/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import processing.core.PApplet;
import processing.core.PVector;

public class sketchyiso
extends PApplet {
    float time = 0.0f;
    int[] colourpalette = new int[8];
    Minim minim;
    AudioPlayer player;
    int grid_width = 64;
    int grid_height = 64;
    float[][] dists = new float[this.grid_width + 1][this.grid_height + 1];
    float accum_length;
    float sketch_segment_length = 10.0f;
    List<Line> lines = new ArrayList<Line>();
    Map<Integer, List<Line>> loops = new HashMap<Integer, List<Line>>();

    public void stop() {
        this.player.close();
        this.minim.stop();
        super.stop();
    }

    public void addLine(PVector v0, PVector v1) {
        Line l = new Line();
        l.v0 = v0;
        l.v1 = v1;
        this.lines.add(l);
    }

    public void setup() {
        this.noFill();
        this.frameRate(12.0f);
        this.minim = new Minim((Object)this);
        this.player = this.minim.loadFile("frogsong.wav");
        this.player.play();
    }

    public void draw() {
        float circlesAmount;
        this.background(220);
        this.pushMatrix();
        this.translate(this.width / 4, 0.0f);
        this.scale(PApplet.parseFloat((int)this.height) / PApplet.parseFloat((int)this.width), 1.0f);
        this.lines.clear();
        this.loops.clear();
        this.accum_length = 0.0f;
        this.time = (float)this.player.position() / 1000.0f;
        this.generateFieldLines(this.time);
        this.addBorder();
        float squaresAmount = sketchyiso.constrain((float)((this.time - 18.0f) / 8.0f), (float)0.0f, (float)1.0f) - sketchyiso.constrain((float)((this.time - 30.0f) / 9.0f), (float)0.0f, (float)1.0f);
        if (squaresAmount > 0.0f) {
            int i = 0;
            while (i < 10) {
                float ox = this.noise(i * 2 + 0) * 2000.0f - 1000.0f;
                float oy = this.noise(i * 2 + 1) * 2000.0f - 1000.0f;
                float t = this.time + (float)i * 10.0f;
                float s = squaresAmount * (0.5f + sketchyiso.cos((float)t)) * 2.0f;
                this.addSquare(new PVector((float)(this.width / 2) - 260.0f * s + ox, (float)(this.height / 2) - 160.0f * s + oy), new PVector((float)(this.width / 2) + 260.0f * s + ox, (float)(this.height / 2) + 160.0f * s + oy), 0.0f);
                ++i;
            }
        }
        if ((circlesAmount = sketchyiso.constrain((float)((this.time - 40.0f) / 8.0f), (float)0.0f, (float)1.0f) - sketchyiso.constrain((float)((this.time - 49.0f) / 8.0f), (float)0.0f, (float)1.0f)) > 0.0f) {
            this.randomSeed(0L);
            int i = 0;
            while (i < 10) {
                float ox = this.random(1.0f) * 2000.0f;
                float oy = this.random(1.0f) * 1400.0f;
                float t = this.time * 2.0f + (float)i * 10.0f;
                float r = (100.0f + 20.0f * circlesAmount * (0.5f + sketchyiso.cos((float)t)) * 10.0f) * circlesAmount;
                this.addCircle(new PVector(ox, oy), r, 10);
                ++i;
            }
        }
        this.detectLoops();
        this.colourpalette[0] = this.color(130, 130, 160);
        this.colourpalette[1] = this.color(150, 180, 150);
        this.colourpalette[2] = this.color(160, 140, 120);
        this.colourpalette[3] = this.color(190, 190, 120);
        this.colourpalette[4] = this.color(130, 130, 160);
        this.strokeWeight(20.0f);
        this.sketch_segment_length = 15.0f;
        this.fillShapes();
        this.stroke(30);
        this.strokeWeight(16.0f);
        this.sketch_segment_length = 5.0f;
        for (List<Line> list : this.loops.values()) {
            for (Line l : list) {
                this.sketchLine(l.v0, l.v1, this.sketch_segment_length);
            }
        }
        this.popMatrix();
    }

    public void generateFieldLines(float t) {
        int x;
        float amount = sketchyiso.constrain((float)((this.time - 9.5f) / 3.0f), (float)0.0f, (float)1.0f) - sketchyiso.constrain((float)((this.time - 59.0f) / 5.0f), (float)0.0f, (float)1.0f);
        int y = 0;
        while (y < this.grid_height + 1) {
            x = 0;
            while (x < this.grid_width + 1) {
                if (x == 0 || y == 0 || x == this.grid_width || y == this.grid_height) {
                    this.dists[x][y] = 0.0f;
                } else {
                    float u = x;
                    float v = y;
                    this.dists[x][y] = sketchyiso.sin((float)(u * 0.1f + sketchyiso.cos((float)(v * 0.12f + t)))) * sketchyiso.cos((float)(v * 0.1f + sketchyiso.sin((float)(u * 0.12f + t * 0.3f)))) - 0.2f;
                    float[] fArray = this.dists[x];
                    int n = y;
                    fArray[n] = fArray[n] + ((sketchyiso.cos((float)(u * 0.02f * 8.0f)) * sketchyiso.sin((float)(v * 0.013f * 8.0f)) - 0.4f) * 0.4f + sketchyiso.lerp((float)-1.0f, (float)0.0f, (float)amount));
                }
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.grid_height) {
            x = 0;
            while (x < this.grid_width) {
                this.drawGridCell(x, y, this.dists[x][y], this.dists[x + 1][y], this.dists[x][y + 1], this.dists[x + 1][y + 1]);
                ++x;
            }
            ++y;
        }
    }

    public void addBorder() {
        int w = this.width - 20;
        int h = this.height - 20;
        float x = sketchyiso.constrain((float)((this.time - 0.0f) / 4.9f), (float)0.0f, (float)0.5f) - sketchyiso.constrain((float)((this.time - 63.0f) / 6.0f), (float)0.0f, (float)0.5f);
        float rotAmount = sketchyiso.constrain((float)((this.time - 29.0f) / 12.0f), (float)0.0f, (float)1.0f) * (float)Math.PI;
        this.addSquare(new PVector((float)(this.width / 2) - (float)w * x, (float)(this.height / 2) - (float)h * x), new PVector((float)(this.width / 2) + (float)w * x, (float)(this.height / 2) + (float)h * x), rotAmount);
    }

    public void detectLoops() {
        int loop = -1;
        for (Line l0 : this.lines) {
            boolean found;
            if (l0.loop != -1) continue;
            l0.loop = ++loop;
            block1: do {
                found = false;
                for (Line l1 : this.lines) {
                    if (l0 == l1 || l1.loop == l0.loop || !this.pointsAreEqual(l0.v0, l1.v0) && !this.pointsAreEqual(l0.v1, l1.v0) && !this.pointsAreEqual(l0.v0, l1.v1) && !this.pointsAreEqual(l0.v1, l1.v1)) continue;
                    l1.loop = l0.loop;
                    found = true;
                    l0 = l1;
                    continue block1;
                }
            } while (found);
        }
        for (Line l : this.lines) {
            if (!this.loops.containsKey(l.loop)) {
                this.loops.put(l.loop, new ArrayList());
            }
            List<Line> list = this.loops.get(l.loop);
            list.add(l);
        }
    }

    public boolean pointsAreEqual(PVector v0, PVector v1) {
        return PVector.dist((PVector)v0, (PVector)v1) < 1.0f;
    }

    public void addCircle(PVector center, float radius, int segs) {
        float ox = center.x;
        float oy = center.y;
        int i = 0;
        while (i < segs) {
            float th0 = PApplet.parseFloat((int)(i + 0)) * ((float)Math.PI * 2) / PApplet.parseFloat((int)segs);
            float th1 = PApplet.parseFloat((int)(i + 1)) * ((float)Math.PI * 2) / PApplet.parseFloat((int)segs);
            PVector v0 = new PVector(ox + sketchyiso.cos((float)th0) * radius * 16.0f / 9.0f, oy + sketchyiso.sin((float)th0) * radius);
            PVector v1 = new PVector(ox + sketchyiso.cos((float)th1) * radius * 16.0f / 9.0f, oy + sketchyiso.sin((float)th1) * radius);
            this.addLine(v0, v1);
            ++i;
        }
    }

    public void addSquare(PVector v0, PVector v1, float rotate) {
        PVector v2 = new PVector(v0.x, v1.y);
        PVector v3 = new PVector(v1.x, v0.y);
        if (rotate != 0.0f) {
            PVector center = new PVector((v0.x + v1.x) / 2.0f, (v0.y + v1.y) / 2.0f);
            v0 = new PVector(v0.x - center.x, v0.y - center.y);
            v1 = new PVector(v1.x - center.x, v1.y - center.y);
            v2 = new PVector(v2.x - center.x, v2.y - center.y);
            v3 = new PVector(v3.x - center.x, v3.y - center.y);
            v0.rotate(rotate);
            v1.rotate(rotate);
            v2.rotate(rotate);
            v3.rotate(rotate);
            v0 = new PVector(center.x + v0.x, center.y + v0.y);
            v1 = new PVector(center.x + v1.x, center.y + v1.y);
            v2 = new PVector(center.x + v2.x, center.y + v2.y);
            v3 = new PVector(center.x + v3.x, center.y + v3.y);
        }
        this.addLine(v2, v0);
        this.addLine(v1, v2);
        this.addLine(v3, v1);
        this.addLine(v0, v3);
    }

    public void fillShapes() {
        PVector stroke_dir = new PVector(-30.0f, 2.0f);
        stroke_dir.normalize();
        PVector stroke_norm = new PVector(stroke_dir.y, -stroke_dir.x);
        float mind = 1000000.0f;
        float maxd = -1000000.0f;
        float step_size = 20.0f;
        mind = 50.0f;
        maxd = sketchyiso.lerp((float)50.0f, (float)1680.0f, (float)sketchyiso.constrain((float)((this.time - 4.9f) / 4.5f), (float)0.0f, (float)1.0f));
        float x = mind;
        while (x < maxd) {
            PVector ro = PVector.mult((PVector)stroke_norm, (float)x);
            PVector rd = stroke_dir;
            ArrayList<Pair> intersections = new ArrayList<Pair>();
            for (Line l : this.lines) {
                PVector its = this.clipRay(ro, rd, l.v0, l.v1);
                if (its == null) continue;
                float t = PVector.dot((PVector)PVector.sub((PVector)its, (PVector)ro), (PVector)rd);
                Pair pair = new Pair((Object)Float.valueOf(t), (Object)l);
                intersections.add(pair);
            }
            Collections.sort(intersections, new Comparator(){

                public int compare(Object o0, Object o1) {
                    Pair p0 = (Pair)o0;
                    Pair p1 = (Pair)o1;
                    return ((Float)p0.getKey()).floatValue() < ((Float)p1.getKey()).floatValue() ? -1 : (((Float)p0.getKey()).floatValue() > ((Float)p1.getKey()).floatValue() ? 1 : 0);
                }
            });
            boolean inside = false;
            int count = 0;
            int paletteindex = 0;
            float pf = -4000.0f;
            for (Pair p : intersections) {
                float f = ((Float)p.getKey()).floatValue();
                Line l = (Line)p.getValue();
                inside = !inside;
                float d = PVector.dot((PVector)stroke_norm, (PVector)PVector.sub((PVector)l.v1, (PVector)l.v0));
                if (paletteindex >= 0 && paletteindex < this.colourpalette.length) {
                    this.stroke(this.colourpalette[paletteindex]);
                    float t0 = pf + 20.0f;
                    float t1 = f - 20.0f;
                    if (t1 > t0 && count > 0) {
                        this.sketchLine(PVector.add((PVector)ro, (PVector)PVector.mult((PVector)rd, (float)t0)), PVector.add((PVector)ro, (PVector)PVector.mult((PVector)rd, (float)t1)), this.sketch_segment_length);
                    }
                }
                paletteindex += d > 0.0f ? 1 : -1;
                ++count;
                pf = f;
            }
            x += step_size;
        }
    }

    public PVector clipRay(PVector ro, PVector rd, PVector pa, PVector pb) {
        PVector pd = PVector.sub((PVector)pb, (PVector)pa);
        PVector pn = new PVector(pd.y, -pd.x);
        pn.normalize();
        float d = PVector.dot((PVector)rd, (PVector)pn);
        if (d == 0.0f) {
            return null;
        }
        float t = -PVector.dot((PVector)PVector.sub((PVector)ro, (PVector)pa), (PVector)pn) / d;
        PVector its = PVector.add((PVector)ro, (PVector)PVector.mult((PVector)rd, (float)t));
        float p = PVector.sub((PVector)its, (PVector)pa).dot(pd) / pd.mag();
        if (p >= 0.0f && p <= pd.mag()) {
            return its;
        }
        return null;
    }

    public void drawGridCell(int x, int y, float d00, float d10, float d01, float d11) {
        int code = 0;
        if (d00 <= 0.0f) {
            code |= 1;
        }
        if (d10 <= 0.0f) {
            code |= 2;
        }
        if (d11 <= 0.0f) {
            code |= 4;
        }
        if (d01 <= 0.0f) {
            code |= 8;
        }
        int x0 = 40 + (x + 0) * (this.width - 80) / this.grid_width;
        int y0 = 40 + (y + 0) * (this.height - 80) / this.grid_height;
        int x1 = 40 + (x + 1) * (this.width - 80) / this.grid_width;
        int y1 = 40 + (y + 1) * (this.height - 80) / this.grid_height;
        float[] ds = new float[]{d00, d10, d11, d01};
        int[][] ps = new int[][]{{x0, y0}, {x1, y0}, {x1, y1}, {x0, y1}};
        switch (code) {
            case 1: {
                this.drawGridCell_1(ds, ps, 0);
                break;
            }
            case 2: {
                this.drawGridCell_1(ds, ps, 1);
                break;
            }
            case 3: {
                this.drawGridCell_2(ds, ps, 0);
                break;
            }
            case 4: {
                this.drawGridCell_1(ds, ps, 2);
                break;
            }
            case 5: {
                this.drawGridCell_3(ds, ps, 2);
                break;
            }
            case 6: {
                this.drawGridCell_2(ds, ps, 1);
                break;
            }
            case 7: {
                this.drawGridCell_4(ds, ps, 1);
                break;
            }
            case 8: {
                this.drawGridCell_1(ds, ps, 3);
                break;
            }
            case 9: {
                this.drawGridCell_2(ds, ps, 3);
                break;
            }
            case 10: {
                this.drawGridCell_3(ds, ps, 1);
                break;
            }
            case 11: {
                this.drawGridCell_4(ds, ps, 0);
                break;
            }
            case 12: {
                this.drawGridCell_2(ds, ps, 2);
                break;
            }
            case 13: {
                this.drawGridCell_4(ds, ps, 3);
                break;
            }
            case 14: {
                this.drawGridCell_4(ds, ps, 2);
            }
        }
    }

    public void drawGridCell_1(float[] ds, int[][] ps, int rot) {
        int i0 = rot + 0 & 3;
        int i1 = rot + 1 & 3;
        int i3 = rot + 3 & 3;
        float t0 = this.isopoint(ds[i0], ds[i1]);
        float t1 = this.isopoint(ds[i0], ds[i3]);
        PVector v0 = new PVector((float)ps[i0][0] + t0 * (float)(ps[i1][0] - ps[i0][0]), (float)ps[i0][1] + t0 * (float)(ps[i1][1] - ps[i0][1]));
        PVector v1 = new PVector((float)ps[i0][0] + t1 * (float)(ps[i3][0] - ps[i0][0]), (float)ps[i0][1] + t1 * (float)(ps[i3][1] - ps[i0][1]));
        this.addLine(v0, v1);
    }

    public void drawGridCell_2(float[] ds, int[][] ps, int rot) {
        int i0 = rot + 0 & 3;
        int i1 = rot + 1 & 3;
        int i2 = rot + 2 & 3;
        int i3 = rot + 3 & 3;
        float t0 = this.isopoint(ds[i1], ds[i2]);
        float t1 = this.isopoint(ds[i0], ds[i3]);
        PVector v0 = new PVector((float)ps[i1][0] + t0 * (float)(ps[i2][0] - ps[i1][0]), (float)ps[i1][1] + t0 * (float)(ps[i2][1] - ps[i1][1]));
        PVector v1 = new PVector((float)ps[i0][0] + t1 * (float)(ps[i3][0] - ps[i0][0]), (float)ps[i0][1] + t1 * (float)(ps[i3][1] - ps[i0][1]));
        this.addLine(v0, v1);
    }

    public void drawGridCell_3(float[] ds, int[][] ps, int rot) {
        int i0 = rot + 0 & 3;
        int i1 = rot + 1 & 3;
        int i2 = rot + 2 & 3;
        int i3 = rot + 3 & 3;
        float t0 = this.isopoint(ds[i0], ds[i1]);
        float t1 = this.isopoint(ds[i1], ds[i2]);
        float t2 = this.isopoint(ds[i2], ds[i3]);
        float t3 = this.isopoint(ds[i3], ds[i0]);
        PVector v0 = new PVector((float)ps[i0][0] + t0 * (float)(ps[i1][0] - ps[i0][0]), (float)ps[i0][1] + t0 * (float)(ps[i1][1] - ps[i0][1]));
        PVector v1 = new PVector((float)ps[i3][0] + t3 * (float)(ps[i0][0] - ps[i3][0]), (float)ps[i3][1] + t3 * (float)(ps[i0][1] - ps[i3][1]));
        PVector v2 = new PVector((float)ps[i1][0] + t1 * (float)(ps[i2][0] - ps[i1][0]), (float)ps[i1][1] + t1 * (float)(ps[i2][1] - ps[i1][1]));
        PVector v3 = new PVector((float)ps[i2][0] + t2 * (float)(ps[i3][0] - ps[i2][0]), (float)ps[i2][1] + t2 * (float)(ps[i3][1] - ps[i2][1]));
        this.addLine(v0, v1);
        this.addLine(v2, v3);
    }

    public void drawGridCell_4(float[] ds, int[][] ps, int rot) {
        int i1 = rot + 1 & 3;
        int i2 = rot + 2 & 3;
        int i3 = rot + 3 & 3;
        float t0 = this.isopoint(ds[i1], ds[i2]);
        float t1 = this.isopoint(ds[i2], ds[i3]);
        PVector v0 = new PVector((float)ps[i1][0] + t0 * (float)(ps[i2][0] - ps[i1][0]), (float)ps[i1][1] + t0 * (float)(ps[i2][1] - ps[i1][1]));
        PVector v1 = new PVector((float)ps[i2][0] + t1 * (float)(ps[i3][0] - ps[i2][0]), (float)ps[i2][1] + t1 * (float)(ps[i3][1] - ps[i2][1]));
        this.addLine(v0, v1);
    }

    public float isopoint(float d0, float d1) {
        return sketchyiso.abs((float)d0) / (sketchyiso.abs((float)d0) + sketchyiso.abs((float)d1));
    }

    public void sketchLine(PVector va, PVector vb, float segment_length) {
        PVector vd = PVector.sub((PVector)vb, (PVector)va);
        PVector vt = new PVector(vd.y, -vd.x);
        vt.normalize();
        float len = vd.mag();
        int num_segments = sketchyiso.ceil((float)(len / segment_length));
        PVector pvc = null;
        int i = 0;
        while (i <= num_segments) {
            float t = this.sketchCurve((float)i / (float)num_segments, len);
            PVector vc = this.sketchPoint(t, va, vb, vt);
            if (pvc != null) {
                this.line(pvc.x, pvc.y, vc.x, vc.y);
                this.accum_length += PVector.dist((PVector)pvc, (PVector)vc);
            }
            pvc = vc;
            ++i;
        }
    }

    public float sketchCurve(float t, float len) {
        return (t * len + sketchyiso.cos((float)(t * len * 0.5f + this.accum_length)) * 20.0f) / len;
    }

    public PVector sketchPoint(float t, PVector va, PVector vb, PVector vt) {
        PVector vc = this.lerpVectors(va, vb, t);
        float f = 0.05f;
        vc = PVector.add((PVector)vc, (PVector)PVector.mult((PVector)vt, (float)((this.noise(this.accum_length * f) - 0.5f) * 9.0f + (this.noise(this.accum_length * f * 0.05f) - 0.5f) * 18.0f)));
        return vc;
    }

    public PVector lerpVectors(PVector a, PVector b, float x) {
        return PVector.add((PVector)PVector.mult((PVector)a, (float)(1.0f - x)), (PVector)PVector.mult((PVector)b, (float)x));
    }

    public void settings() {
        this.fullScreen();
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"sketchyiso"};
        if (passedArgs != null) {
            PApplet.main((String[])sketchyiso.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Line {
        public PVector v0;
        public PVector v1;
        public int loop = -1;

        Line() {
        }
    }
}

