/*

    This file was generated with gl3w_gen.py, part of gl3w
    (hosted at https://github.com/skaslev/gl3w)

    This is free and unencumbered software released into the public domain.

    Anyone is free to copy, modify, publish, use, compile, sell, or
    distribute this software, either in source code form or as a compiled
    binary, for any purpose, commercial or non-commercial, and by any
    means.

    In jurisdictions that recognize copyright laws, the author or authors
    of this software dedicate any and all copyright interest in the
    software to the public domain. We make this dedication for the benefit
    of the public at large and to the detriment of our heirs and
    successors. We intend this dedication to be an overt act of
    relinquishment in perpetuity of all present and future rights to this
    software under copyright law.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

*/

#include <GL/gl3w.h>

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN 1
#include <windows.h>

static HMODULE libgl;

static void open_libgl(void)
{
	libgl = LoadLibraryA("opengl32.dll");
}

static void close_libgl(void)
{
	FreeLibrary(libgl);
}

static GL3WglProc get_proc(const char *proc)
{
	GL3WglProc res;

	res = (GL3WglProc)wglGetProcAddress(proc);
	if (!res)
		res = (GL3WglProc)GetProcAddress(libgl, proc);
	return res;
}
#elif defined(__APPLE__) || defined(__APPLE_CC__)
#include <Carbon/Carbon.h>

CFBundleRef bundle;
CFURLRef bundleURL;

static void open_libgl(void)
{
	bundleURL = CFURLCreateWithFileSystemPath(kCFAllocatorDefault,
		CFSTR("/System/Library/Frameworks/OpenGL.framework"),
		kCFURLPOSIXPathStyle, true);

	bundle = CFBundleCreate(kCFAllocatorDefault, bundleURL);
	assert(bundle != NULL);
}

static void close_libgl(void)
{
	CFRelease(bundle);
	CFRelease(bundleURL);
}

static GL3WglProc get_proc(const char *proc)
{
	GL3WglProc res;

	CFStringRef procname = CFStringCreateWithCString(kCFAllocatorDefault, proc,
		kCFStringEncodingASCII);
	*(void **)(&res) = CFBundleGetFunctionPointerForName(bundle, procname);
	CFRelease(procname);
	return res;
}
#else
#include <dlfcn.h>
#include <GL/glx.h>

static void *libgl;
static PFNGLXGETPROCADDRESSPROC glx_get_proc_address;

static void open_libgl(void)
{
	libgl = dlopen("libGL.so.1", RTLD_LAZY | RTLD_GLOBAL);
	*(void **)(&glx_get_proc_address) = dlsym(libgl, "glXGetProcAddressARB");
}

static void close_libgl(void)
{
	dlclose(libgl);
}

static GL3WglProc get_proc(const char *proc)
{
	GL3WglProc res;

	res = glx_get_proc_address((const GLubyte *)proc);
	if (!res)
		*(void **)(&res) = dlsym(libgl, proc);
	return res;
}
#endif

static struct {
	int major, minor;
} version;

static int parse_version(void)
{
	if (!glGetIntegerv)
		return -1;

	glGetIntegerv(GL_MAJOR_VERSION, &version.major);
	glGetIntegerv(GL_MINOR_VERSION, &version.minor);

	if (version.major < 3)
		return -1;
	return 0;
}

static void load_procs(GL3WGetProcAddressProc proc);

int gl3wInit(void)
{
	open_libgl();
	load_procs(get_proc);
	close_libgl();
	return parse_version();
}

int gl3wInit2(GL3WGetProcAddressProc proc)
{
	load_procs(proc);
	return parse_version();
}

int gl3wIsSupported(int major, int minor)
{
	if (major < 3)
		return 0;
	if (version.major == major)
		return version.minor >= minor;
	return version.major >= major;
}

GL3WglProc gl3wGetProcAddress(const char *proc)
{
	return get_proc(proc);
}

PFNGLACTIVEPROGRAMEXTPROC                            gl3wActiveProgramEXT;
PFNGLACTIVESHADERPROGRAMPROC                         gl3wActiveShaderProgram;
PFNGLACTIVETEXTUREPROC                               gl3wActiveTexture;
PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC         gl3wApplyFramebufferAttachmentCMAAINTEL;
PFNGLATTACHSHADERPROC                                gl3wAttachShader;
PFNGLBEGINCONDITIONALRENDERPROC                      gl3wBeginConditionalRender;
PFNGLBEGINCONDITIONALRENDERNVPROC                    gl3wBeginConditionalRenderNV;
PFNGLBEGINPERFMONITORAMDPROC                         gl3wBeginPerfMonitorAMD;
PFNGLBEGINPERFQUERYINTELPROC                         gl3wBeginPerfQueryINTEL;
PFNGLBEGINQUERYPROC                                  gl3wBeginQuery;
PFNGLBEGINQUERYINDEXEDPROC                           gl3wBeginQueryIndexed;
PFNGLBEGINTRANSFORMFEEDBACKPROC                      gl3wBeginTransformFeedback;
PFNGLBINDATTRIBLOCATIONPROC                          gl3wBindAttribLocation;
PFNGLBINDBUFFERPROC                                  gl3wBindBuffer;
PFNGLBINDBUFFERBASEPROC                              gl3wBindBufferBase;
PFNGLBINDBUFFERRANGEPROC                             gl3wBindBufferRange;
PFNGLBINDBUFFERSBASEPROC                             gl3wBindBuffersBase;
PFNGLBINDBUFFERSRANGEPROC                            gl3wBindBuffersRange;
PFNGLBINDFRAGDATALOCATIONPROC                        gl3wBindFragDataLocation;
PFNGLBINDFRAGDATALOCATIONINDEXEDPROC                 gl3wBindFragDataLocationIndexed;
PFNGLBINDFRAMEBUFFERPROC                             gl3wBindFramebuffer;
PFNGLBINDIMAGETEXTUREPROC                            gl3wBindImageTexture;
PFNGLBINDIMAGETEXTURESPROC                           gl3wBindImageTextures;
PFNGLBINDMULTITEXTUREEXTPROC                         gl3wBindMultiTextureEXT;
PFNGLBINDPROGRAMPIPELINEPROC                         gl3wBindProgramPipeline;
PFNGLBINDRENDERBUFFERPROC                            gl3wBindRenderbuffer;
PFNGLBINDSAMPLERPROC                                 gl3wBindSampler;
PFNGLBINDSAMPLERSPROC                                gl3wBindSamplers;
PFNGLBINDTEXTUREPROC                                 gl3wBindTexture;
PFNGLBINDTEXTUREUNITPROC                             gl3wBindTextureUnit;
PFNGLBINDTEXTURESPROC                                gl3wBindTextures;
PFNGLBINDTRANSFORMFEEDBACKPROC                       gl3wBindTransformFeedback;
PFNGLBINDVERTEXARRAYPROC                             gl3wBindVertexArray;
PFNGLBINDVERTEXBUFFERPROC                            gl3wBindVertexBuffer;
PFNGLBINDVERTEXBUFFERSPROC                           gl3wBindVertexBuffers;
PFNGLBLENDBARRIERKHRPROC                             gl3wBlendBarrierKHR;
PFNGLBLENDBARRIERNVPROC                              gl3wBlendBarrierNV;
PFNGLBLENDCOLORPROC                                  gl3wBlendColor;
PFNGLBLENDEQUATIONPROC                               gl3wBlendEquation;
PFNGLBLENDEQUATIONSEPARATEPROC                       gl3wBlendEquationSeparate;
PFNGLBLENDEQUATIONSEPARATEIPROC                      gl3wBlendEquationSeparatei;
PFNGLBLENDEQUATIONSEPARATEIARBPROC                   gl3wBlendEquationSeparateiARB;
PFNGLBLENDEQUATIONIPROC                              gl3wBlendEquationi;
PFNGLBLENDEQUATIONIARBPROC                           gl3wBlendEquationiARB;
PFNGLBLENDFUNCPROC                                   gl3wBlendFunc;
PFNGLBLENDFUNCSEPARATEPROC                           gl3wBlendFuncSeparate;
PFNGLBLENDFUNCSEPARATEIPROC                          gl3wBlendFuncSeparatei;
PFNGLBLENDFUNCSEPARATEIARBPROC                       gl3wBlendFuncSeparateiARB;
PFNGLBLENDFUNCIPROC                                  gl3wBlendFunci;
PFNGLBLENDFUNCIARBPROC                               gl3wBlendFunciARB;
PFNGLBLENDPARAMETERINVPROC                           gl3wBlendParameteriNV;
PFNGLBLITFRAMEBUFFERPROC                             gl3wBlitFramebuffer;
PFNGLBLITNAMEDFRAMEBUFFERPROC                        gl3wBlitNamedFramebuffer;
PFNGLBUFFERADDRESSRANGENVPROC                        gl3wBufferAddressRangeNV;
PFNGLBUFFERDATAPROC                                  gl3wBufferData;
PFNGLBUFFERPAGECOMMITMENTARBPROC                     gl3wBufferPageCommitmentARB;
PFNGLBUFFERSTORAGEPROC                               gl3wBufferStorage;
PFNGLBUFFERSUBDATAPROC                               gl3wBufferSubData;
PFNGLCALLCOMMANDLISTNVPROC                           gl3wCallCommandListNV;
PFNGLCHECKFRAMEBUFFERSTATUSPROC                      gl3wCheckFramebufferStatus;
PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC                 gl3wCheckNamedFramebufferStatus;
PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC              gl3wCheckNamedFramebufferStatusEXT;
PFNGLCLAMPCOLORPROC                                  gl3wClampColor;
PFNGLCLEARPROC                                       gl3wClear;
PFNGLCLEARBUFFERDATAPROC                             gl3wClearBufferData;
PFNGLCLEARBUFFERSUBDATAPROC                          gl3wClearBufferSubData;
PFNGLCLEARBUFFERFIPROC                               gl3wClearBufferfi;
PFNGLCLEARBUFFERFVPROC                               gl3wClearBufferfv;
PFNGLCLEARBUFFERIVPROC                               gl3wClearBufferiv;
PFNGLCLEARBUFFERUIVPROC                              gl3wClearBufferuiv;
PFNGLCLEARCOLORPROC                                  gl3wClearColor;
PFNGLCLEARDEPTHPROC                                  gl3wClearDepth;
PFNGLCLEARDEPTHFPROC                                 gl3wClearDepthf;
PFNGLCLEARNAMEDBUFFERDATAPROC                        gl3wClearNamedBufferData;
PFNGLCLEARNAMEDBUFFERDATAEXTPROC                     gl3wClearNamedBufferDataEXT;
PFNGLCLEARNAMEDBUFFERSUBDATAPROC                     gl3wClearNamedBufferSubData;
PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC                  gl3wClearNamedBufferSubDataEXT;
PFNGLCLEARNAMEDFRAMEBUFFERFIPROC                     gl3wClearNamedFramebufferfi;
PFNGLCLEARNAMEDFRAMEBUFFERFVPROC                     gl3wClearNamedFramebufferfv;
PFNGLCLEARNAMEDFRAMEBUFFERIVPROC                     gl3wClearNamedFramebufferiv;
PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC                    gl3wClearNamedFramebufferuiv;
PFNGLCLEARSTENCILPROC                                gl3wClearStencil;
PFNGLCLEARTEXIMAGEPROC                               gl3wClearTexImage;
PFNGLCLEARTEXSUBIMAGEPROC                            gl3wClearTexSubImage;
PFNGLCLIENTATTRIBDEFAULTEXTPROC                      gl3wClientAttribDefaultEXT;
PFNGLCLIENTWAITSYNCPROC                              gl3wClientWaitSync;
PFNGLCLIPCONTROLPROC                                 gl3wClipControl;
PFNGLCOLORFORMATNVPROC                               gl3wColorFormatNV;
PFNGLCOLORMASKPROC                                   gl3wColorMask;
PFNGLCOLORMASKIPROC                                  gl3wColorMaski;
PFNGLCOMMANDLISTSEGMENTSNVPROC                       gl3wCommandListSegmentsNV;
PFNGLCOMPILECOMMANDLISTNVPROC                        gl3wCompileCommandListNV;
PFNGLCOMPILESHADERPROC                               gl3wCompileShader;
PFNGLCOMPILESHADERINCLUDEARBPROC                     gl3wCompileShaderIncludeARB;
PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC                gl3wCompressedMultiTexImage1DEXT;
PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC                gl3wCompressedMultiTexImage2DEXT;
PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC                gl3wCompressedMultiTexImage3DEXT;
PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC             gl3wCompressedMultiTexSubImage1DEXT;
PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC             gl3wCompressedMultiTexSubImage2DEXT;
PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC             gl3wCompressedMultiTexSubImage3DEXT;
PFNGLCOMPRESSEDTEXIMAGE1DPROC                        gl3wCompressedTexImage1D;
PFNGLCOMPRESSEDTEXIMAGE2DPROC                        gl3wCompressedTexImage2D;
PFNGLCOMPRESSEDTEXIMAGE3DPROC                        gl3wCompressedTexImage3D;
PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC                     gl3wCompressedTexSubImage1D;
PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC                     gl3wCompressedTexSubImage2D;
PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC                     gl3wCompressedTexSubImage3D;
PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC                 gl3wCompressedTextureImage1DEXT;
PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC                 gl3wCompressedTextureImage2DEXT;
PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC                 gl3wCompressedTextureImage3DEXT;
PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC                 gl3wCompressedTextureSubImage1D;
PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC              gl3wCompressedTextureSubImage1DEXT;
PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC                 gl3wCompressedTextureSubImage2D;
PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC              gl3wCompressedTextureSubImage2DEXT;
PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC                 gl3wCompressedTextureSubImage3D;
PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC              gl3wCompressedTextureSubImage3DEXT;
PFNGLCONSERVATIVERASTERPARAMETERFNVPROC              gl3wConservativeRasterParameterfNV;
PFNGLCONSERVATIVERASTERPARAMETERINVPROC              gl3wConservativeRasterParameteriNV;
PFNGLCOPYBUFFERSUBDATAPROC                           gl3wCopyBufferSubData;
PFNGLCOPYIMAGESUBDATAPROC                            gl3wCopyImageSubData;
PFNGLCOPYMULTITEXIMAGE1DEXTPROC                      gl3wCopyMultiTexImage1DEXT;
PFNGLCOPYMULTITEXIMAGE2DEXTPROC                      gl3wCopyMultiTexImage2DEXT;
PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC                   gl3wCopyMultiTexSubImage1DEXT;
PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC                   gl3wCopyMultiTexSubImage2DEXT;
PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC                   gl3wCopyMultiTexSubImage3DEXT;
PFNGLCOPYNAMEDBUFFERSUBDATAPROC                      gl3wCopyNamedBufferSubData;
PFNGLCOPYPATHNVPROC                                  gl3wCopyPathNV;
PFNGLCOPYTEXIMAGE1DPROC                              gl3wCopyTexImage1D;
PFNGLCOPYTEXIMAGE2DPROC                              gl3wCopyTexImage2D;
PFNGLCOPYTEXSUBIMAGE1DPROC                           gl3wCopyTexSubImage1D;
PFNGLCOPYTEXSUBIMAGE2DPROC                           gl3wCopyTexSubImage2D;
PFNGLCOPYTEXSUBIMAGE3DPROC                           gl3wCopyTexSubImage3D;
PFNGLCOPYTEXTUREIMAGE1DEXTPROC                       gl3wCopyTextureImage1DEXT;
PFNGLCOPYTEXTUREIMAGE2DEXTPROC                       gl3wCopyTextureImage2DEXT;
PFNGLCOPYTEXTURESUBIMAGE1DPROC                       gl3wCopyTextureSubImage1D;
PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC                    gl3wCopyTextureSubImage1DEXT;
PFNGLCOPYTEXTURESUBIMAGE2DPROC                       gl3wCopyTextureSubImage2D;
PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC                    gl3wCopyTextureSubImage2DEXT;
PFNGLCOPYTEXTURESUBIMAGE3DPROC                       gl3wCopyTextureSubImage3D;
PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC                    gl3wCopyTextureSubImage3DEXT;
PFNGLCOVERFILLPATHINSTANCEDNVPROC                    gl3wCoverFillPathInstancedNV;
PFNGLCOVERFILLPATHNVPROC                             gl3wCoverFillPathNV;
PFNGLCOVERSTROKEPATHINSTANCEDNVPROC                  gl3wCoverStrokePathInstancedNV;
PFNGLCOVERSTROKEPATHNVPROC                           gl3wCoverStrokePathNV;
PFNGLCOVERAGEMODULATIONNVPROC                        gl3wCoverageModulationNV;
PFNGLCOVERAGEMODULATIONTABLENVPROC                   gl3wCoverageModulationTableNV;
PFNGLCREATEBUFFERSPROC                               gl3wCreateBuffers;
PFNGLCREATECOMMANDLISTSNVPROC                        gl3wCreateCommandListsNV;
PFNGLCREATEFRAMEBUFFERSPROC                          gl3wCreateFramebuffers;
PFNGLCREATEPERFQUERYINTELPROC                        gl3wCreatePerfQueryINTEL;
PFNGLCREATEPROGRAMPROC                               gl3wCreateProgram;
PFNGLCREATEPROGRAMPIPELINESPROC                      gl3wCreateProgramPipelines;
PFNGLCREATEQUERIESPROC                               gl3wCreateQueries;
PFNGLCREATERENDERBUFFERSPROC                         gl3wCreateRenderbuffers;
PFNGLCREATESAMPLERSPROC                              gl3wCreateSamplers;
PFNGLCREATESHADERPROC                                gl3wCreateShader;
PFNGLCREATESHADERPROGRAMEXTPROC                      gl3wCreateShaderProgramEXT;
PFNGLCREATESHADERPROGRAMVPROC                        gl3wCreateShaderProgramv;
PFNGLCREATESTATESNVPROC                              gl3wCreateStatesNV;
PFNGLCREATESYNCFROMCLEVENTARBPROC                    gl3wCreateSyncFromCLeventARB;
PFNGLCREATETEXTURESPROC                              gl3wCreateTextures;
PFNGLCREATETRANSFORMFEEDBACKSPROC                    gl3wCreateTransformFeedbacks;
PFNGLCREATEVERTEXARRAYSPROC                          gl3wCreateVertexArrays;
PFNGLCULLFACEPROC                                    gl3wCullFace;
PFNGLDEBUGMESSAGECALLBACKPROC                        gl3wDebugMessageCallback;
PFNGLDEBUGMESSAGECALLBACKARBPROC                     gl3wDebugMessageCallbackARB;
PFNGLDEBUGMESSAGECONTROLPROC                         gl3wDebugMessageControl;
PFNGLDEBUGMESSAGECONTROLARBPROC                      gl3wDebugMessageControlARB;
PFNGLDEBUGMESSAGEINSERTPROC                          gl3wDebugMessageInsert;
PFNGLDEBUGMESSAGEINSERTARBPROC                       gl3wDebugMessageInsertARB;
PFNGLDELETEBUFFERSPROC                               gl3wDeleteBuffers;
PFNGLDELETECOMMANDLISTSNVPROC                        gl3wDeleteCommandListsNV;
PFNGLDELETEFRAMEBUFFERSPROC                          gl3wDeleteFramebuffers;
PFNGLDELETENAMEDSTRINGARBPROC                        gl3wDeleteNamedStringARB;
PFNGLDELETEPATHSNVPROC                               gl3wDeletePathsNV;
PFNGLDELETEPERFMONITORSAMDPROC                       gl3wDeletePerfMonitorsAMD;
PFNGLDELETEPERFQUERYINTELPROC                        gl3wDeletePerfQueryINTEL;
PFNGLDELETEPROGRAMPROC                               gl3wDeleteProgram;
PFNGLDELETEPROGRAMPIPELINESPROC                      gl3wDeleteProgramPipelines;
PFNGLDELETEQUERIESPROC                               gl3wDeleteQueries;
PFNGLDELETERENDERBUFFERSPROC                         gl3wDeleteRenderbuffers;
PFNGLDELETESAMPLERSPROC                              gl3wDeleteSamplers;
PFNGLDELETESHADERPROC                                gl3wDeleteShader;
PFNGLDELETESTATESNVPROC                              gl3wDeleteStatesNV;
PFNGLDELETESYNCPROC                                  gl3wDeleteSync;
PFNGLDELETETEXTURESPROC                              gl3wDeleteTextures;
PFNGLDELETETRANSFORMFEEDBACKSPROC                    gl3wDeleteTransformFeedbacks;
PFNGLDELETEVERTEXARRAYSPROC                          gl3wDeleteVertexArrays;
PFNGLDEPTHFUNCPROC                                   gl3wDepthFunc;
PFNGLDEPTHMASKPROC                                   gl3wDepthMask;
PFNGLDEPTHRANGEPROC                                  gl3wDepthRange;
PFNGLDEPTHRANGEARRAYVPROC                            gl3wDepthRangeArrayv;
PFNGLDEPTHRANGEINDEXEDPROC                           gl3wDepthRangeIndexed;
PFNGLDEPTHRANGEFPROC                                 gl3wDepthRangef;
PFNGLDETACHSHADERPROC                                gl3wDetachShader;
PFNGLDISABLEPROC                                     gl3wDisable;
PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC                gl3wDisableClientStateIndexedEXT;
PFNGLDISABLECLIENTSTATEIEXTPROC                      gl3wDisableClientStateiEXT;
PFNGLDISABLEINDEXEDEXTPROC                           gl3wDisableIndexedEXT;
PFNGLDISABLEVERTEXARRAYATTRIBPROC                    gl3wDisableVertexArrayAttrib;
PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC                 gl3wDisableVertexArrayAttribEXT;
PFNGLDISABLEVERTEXARRAYEXTPROC                       gl3wDisableVertexArrayEXT;
PFNGLDISABLEVERTEXATTRIBARRAYPROC                    gl3wDisableVertexAttribArray;
PFNGLDISABLEIPROC                                    gl3wDisablei;
PFNGLDISPATCHCOMPUTEPROC                             gl3wDispatchCompute;
PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC                 gl3wDispatchComputeGroupSizeARB;
PFNGLDISPATCHCOMPUTEINDIRECTPROC                     gl3wDispatchComputeIndirect;
PFNGLDRAWARRAYSPROC                                  gl3wDrawArrays;
PFNGLDRAWARRAYSINDIRECTPROC                          gl3wDrawArraysIndirect;
PFNGLDRAWARRAYSINSTANCEDPROC                         gl3wDrawArraysInstanced;
PFNGLDRAWARRAYSINSTANCEDARBPROC                      gl3wDrawArraysInstancedARB;
PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC             gl3wDrawArraysInstancedBaseInstance;
PFNGLDRAWARRAYSINSTANCEDEXTPROC                      gl3wDrawArraysInstancedEXT;
PFNGLDRAWBUFFERPROC                                  gl3wDrawBuffer;
PFNGLDRAWBUFFERSPROC                                 gl3wDrawBuffers;
PFNGLDRAWCOMMANDSADDRESSNVPROC                       gl3wDrawCommandsAddressNV;
PFNGLDRAWCOMMANDSNVPROC                              gl3wDrawCommandsNV;
PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC                 gl3wDrawCommandsStatesAddressNV;
PFNGLDRAWCOMMANDSSTATESNVPROC                        gl3wDrawCommandsStatesNV;
PFNGLDRAWELEMENTSPROC                                gl3wDrawElements;
PFNGLDRAWELEMENTSBASEVERTEXPROC                      gl3wDrawElementsBaseVertex;
PFNGLDRAWELEMENTSINDIRECTPROC                        gl3wDrawElementsIndirect;
PFNGLDRAWELEMENTSINSTANCEDPROC                       gl3wDrawElementsInstanced;
PFNGLDRAWELEMENTSINSTANCEDARBPROC                    gl3wDrawElementsInstancedARB;
PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC           gl3wDrawElementsInstancedBaseInstance;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC             gl3wDrawElementsInstancedBaseVertex;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC gl3wDrawElementsInstancedBaseVertexBaseInstance;
PFNGLDRAWELEMENTSINSTANCEDEXTPROC                    gl3wDrawElementsInstancedEXT;
PFNGLDRAWRANGEELEMENTSPROC                           gl3wDrawRangeElements;
PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC                 gl3wDrawRangeElementsBaseVertex;
PFNGLDRAWTRANSFORMFEEDBACKPROC                       gl3wDrawTransformFeedback;
PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC              gl3wDrawTransformFeedbackInstanced;
PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC                 gl3wDrawTransformFeedbackStream;
PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC        gl3wDrawTransformFeedbackStreamInstanced;
PFNGLDRAWVKIMAGENVPROC                               gl3wDrawVkImageNV;
PFNGLEDGEFLAGFORMATNVPROC                            gl3wEdgeFlagFormatNV;
PFNGLENABLEPROC                                      gl3wEnable;
PFNGLENABLECLIENTSTATEINDEXEDEXTPROC                 gl3wEnableClientStateIndexedEXT;
PFNGLENABLECLIENTSTATEIEXTPROC                       gl3wEnableClientStateiEXT;
PFNGLENABLEINDEXEDEXTPROC                            gl3wEnableIndexedEXT;
PFNGLENABLEVERTEXARRAYATTRIBPROC                     gl3wEnableVertexArrayAttrib;
PFNGLENABLEVERTEXARRAYATTRIBEXTPROC                  gl3wEnableVertexArrayAttribEXT;
PFNGLENABLEVERTEXARRAYEXTPROC                        gl3wEnableVertexArrayEXT;
PFNGLENABLEVERTEXATTRIBARRAYPROC                     gl3wEnableVertexAttribArray;
PFNGLENABLEIPROC                                     gl3wEnablei;
PFNGLENDCONDITIONALRENDERPROC                        gl3wEndConditionalRender;
PFNGLENDCONDITIONALRENDERNVPROC                      gl3wEndConditionalRenderNV;
PFNGLENDPERFMONITORAMDPROC                           gl3wEndPerfMonitorAMD;
PFNGLENDPERFQUERYINTELPROC                           gl3wEndPerfQueryINTEL;
PFNGLENDQUERYPROC                                    gl3wEndQuery;
PFNGLENDQUERYINDEXEDPROC                             gl3wEndQueryIndexed;
PFNGLENDTRANSFORMFEEDBACKPROC                        gl3wEndTransformFeedback;
PFNGLEVALUATEDEPTHVALUESARBPROC                      gl3wEvaluateDepthValuesARB;
PFNGLFENCESYNCPROC                                   gl3wFenceSync;
PFNGLFINISHPROC                                      gl3wFinish;
PFNGLFLUSHPROC                                       gl3wFlush;
PFNGLFLUSHMAPPEDBUFFERRANGEPROC                      gl3wFlushMappedBufferRange;
PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC                 gl3wFlushMappedNamedBufferRange;
PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC              gl3wFlushMappedNamedBufferRangeEXT;
PFNGLFOGCOORDFORMATNVPROC                            gl3wFogCoordFormatNV;
PFNGLFRAGMENTCOVERAGECOLORNVPROC                     gl3wFragmentCoverageColorNV;
PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC                    gl3wFramebufferDrawBufferEXT;
PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC                   gl3wFramebufferDrawBuffersEXT;
PFNGLFRAMEBUFFERPARAMETERIPROC                       gl3wFramebufferParameteri;
PFNGLFRAMEBUFFERREADBUFFEREXTPROC                    gl3wFramebufferReadBufferEXT;
PFNGLFRAMEBUFFERRENDERBUFFERPROC                     gl3wFramebufferRenderbuffer;
PFNGLFRAMEBUFFERSAMPLELOCATIONSFVARBPROC             gl3wFramebufferSampleLocationsfvARB;
PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC              gl3wFramebufferSampleLocationsfvNV;
PFNGLFRAMEBUFFERTEXTUREPROC                          gl3wFramebufferTexture;
PFNGLFRAMEBUFFERTEXTURE1DPROC                        gl3wFramebufferTexture1D;
PFNGLFRAMEBUFFERTEXTURE2DPROC                        gl3wFramebufferTexture2D;
PFNGLFRAMEBUFFERTEXTURE3DPROC                        gl3wFramebufferTexture3D;
PFNGLFRAMEBUFFERTEXTUREARBPROC                       gl3wFramebufferTextureARB;
PFNGLFRAMEBUFFERTEXTUREFACEARBPROC                   gl3wFramebufferTextureFaceARB;
PFNGLFRAMEBUFFERTEXTURELAYERPROC                     gl3wFramebufferTextureLayer;
PFNGLFRAMEBUFFERTEXTURELAYERARBPROC                  gl3wFramebufferTextureLayerARB;
PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC              gl3wFramebufferTextureMultiviewOVR;
PFNGLFRONTFACEPROC                                   gl3wFrontFace;
PFNGLGENBUFFERSPROC                                  gl3wGenBuffers;
PFNGLGENFRAMEBUFFERSPROC                             gl3wGenFramebuffers;
PFNGLGENPATHSNVPROC                                  gl3wGenPathsNV;
PFNGLGENPERFMONITORSAMDPROC                          gl3wGenPerfMonitorsAMD;
PFNGLGENPROGRAMPIPELINESPROC                         gl3wGenProgramPipelines;
PFNGLGENQUERIESPROC                                  gl3wGenQueries;
PFNGLGENRENDERBUFFERSPROC                            gl3wGenRenderbuffers;
PFNGLGENSAMPLERSPROC                                 gl3wGenSamplers;
PFNGLGENTEXTURESPROC                                 gl3wGenTextures;
PFNGLGENTRANSFORMFEEDBACKSPROC                       gl3wGenTransformFeedbacks;
PFNGLGENVERTEXARRAYSPROC                             gl3wGenVertexArrays;
PFNGLGENERATEMIPMAPPROC                              gl3wGenerateMipmap;
PFNGLGENERATEMULTITEXMIPMAPEXTPROC                   gl3wGenerateMultiTexMipmapEXT;
PFNGLGENERATETEXTUREMIPMAPPROC                       gl3wGenerateTextureMipmap;
PFNGLGENERATETEXTUREMIPMAPEXTPROC                    gl3wGenerateTextureMipmapEXT;
PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC              gl3wGetActiveAtomicCounterBufferiv;
PFNGLGETACTIVEATTRIBPROC                             gl3wGetActiveAttrib;
PFNGLGETACTIVESUBROUTINENAMEPROC                     gl3wGetActiveSubroutineName;
PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC              gl3wGetActiveSubroutineUniformName;
PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC                gl3wGetActiveSubroutineUniformiv;
PFNGLGETACTIVEUNIFORMPROC                            gl3wGetActiveUniform;
PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC                   gl3wGetActiveUniformBlockName;
PFNGLGETACTIVEUNIFORMBLOCKIVPROC                     gl3wGetActiveUniformBlockiv;
PFNGLGETACTIVEUNIFORMNAMEPROC                        gl3wGetActiveUniformName;
PFNGLGETACTIVEUNIFORMSIVPROC                         gl3wGetActiveUniformsiv;
PFNGLGETATTACHEDSHADERSPROC                          gl3wGetAttachedShaders;
PFNGLGETATTRIBLOCATIONPROC                           gl3wGetAttribLocation;
PFNGLGETBOOLEANINDEXEDVEXTPROC                       gl3wGetBooleanIndexedvEXT;
PFNGLGETBOOLEANI_VPROC                               gl3wGetBooleani_v;
PFNGLGETBOOLEANVPROC                                 gl3wGetBooleanv;
PFNGLGETBUFFERPARAMETERI64VPROC                      gl3wGetBufferParameteri64v;
PFNGLGETBUFFERPARAMETERIVPROC                        gl3wGetBufferParameteriv;
PFNGLGETBUFFERPARAMETERUI64VNVPROC                   gl3wGetBufferParameterui64vNV;
PFNGLGETBUFFERPOINTERVPROC                           gl3wGetBufferPointerv;
PFNGLGETBUFFERSUBDATAPROC                            gl3wGetBufferSubData;
PFNGLGETCOMMANDHEADERNVPROC                          gl3wGetCommandHeaderNV;
PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC               gl3wGetCompressedMultiTexImageEXT;
PFNGLGETCOMPRESSEDTEXIMAGEPROC                       gl3wGetCompressedTexImage;
PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC                   gl3wGetCompressedTextureImage;
PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC                gl3wGetCompressedTextureImageEXT;
PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC                gl3wGetCompressedTextureSubImage;
PFNGLGETCOVERAGEMODULATIONTABLENVPROC                gl3wGetCoverageModulationTableNV;
PFNGLGETDEBUGMESSAGELOGPROC                          gl3wGetDebugMessageLog;
PFNGLGETDEBUGMESSAGELOGARBPROC                       gl3wGetDebugMessageLogARB;
PFNGLGETDOUBLEINDEXEDVEXTPROC                        gl3wGetDoubleIndexedvEXT;
PFNGLGETDOUBLEI_VPROC                                gl3wGetDoublei_v;
PFNGLGETDOUBLEI_VEXTPROC                             gl3wGetDoublei_vEXT;
PFNGLGETDOUBLEVPROC                                  gl3wGetDoublev;
PFNGLGETERRORPROC                                    gl3wGetError;
PFNGLGETFIRSTPERFQUERYIDINTELPROC                    gl3wGetFirstPerfQueryIdINTEL;
PFNGLGETFLOATINDEXEDVEXTPROC                         gl3wGetFloatIndexedvEXT;
PFNGLGETFLOATI_VPROC                                 gl3wGetFloati_v;
PFNGLGETFLOATI_VEXTPROC                              gl3wGetFloati_vEXT;
PFNGLGETFLOATVPROC                                   gl3wGetFloatv;
PFNGLGETFRAGDATAINDEXPROC                            gl3wGetFragDataIndex;
PFNGLGETFRAGDATALOCATIONPROC                         gl3wGetFragDataLocation;
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC         gl3wGetFramebufferAttachmentParameteriv;
PFNGLGETFRAMEBUFFERPARAMETERIVPROC                   gl3wGetFramebufferParameteriv;
PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC                gl3wGetFramebufferParameterivEXT;
PFNGLGETGRAPHICSRESETSTATUSPROC                      gl3wGetGraphicsResetStatus;
PFNGLGETGRAPHICSRESETSTATUSARBPROC                   gl3wGetGraphicsResetStatusARB;
PFNGLGETIMAGEHANDLEARBPROC                           gl3wGetImageHandleARB;
PFNGLGETIMAGEHANDLENVPROC                            gl3wGetImageHandleNV;
PFNGLGETINTEGER64I_VPROC                             gl3wGetInteger64i_v;
PFNGLGETINTEGER64VPROC                               gl3wGetInteger64v;
PFNGLGETINTEGERINDEXEDVEXTPROC                       gl3wGetIntegerIndexedvEXT;
PFNGLGETINTEGERI_VPROC                               gl3wGetIntegeri_v;
PFNGLGETINTEGERUI64I_VNVPROC                         gl3wGetIntegerui64i_vNV;
PFNGLGETINTEGERUI64VNVPROC                           gl3wGetIntegerui64vNV;
PFNGLGETINTEGERVPROC                                 gl3wGetIntegerv;
PFNGLGETINTERNALFORMATSAMPLEIVNVPROC                 gl3wGetInternalformatSampleivNV;
PFNGLGETINTERNALFORMATI64VPROC                       gl3wGetInternalformati64v;
PFNGLGETINTERNALFORMATIVPROC                         gl3wGetInternalformativ;
PFNGLGETMULTITEXENVFVEXTPROC                         gl3wGetMultiTexEnvfvEXT;
PFNGLGETMULTITEXENVIVEXTPROC                         gl3wGetMultiTexEnvivEXT;
PFNGLGETMULTITEXGENDVEXTPROC                         gl3wGetMultiTexGendvEXT;
PFNGLGETMULTITEXGENFVEXTPROC                         gl3wGetMultiTexGenfvEXT;
PFNGLGETMULTITEXGENIVEXTPROC                         gl3wGetMultiTexGenivEXT;
PFNGLGETMULTITEXIMAGEEXTPROC                         gl3wGetMultiTexImageEXT;
PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC              gl3wGetMultiTexLevelParameterfvEXT;
PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC              gl3wGetMultiTexLevelParameterivEXT;
PFNGLGETMULTITEXPARAMETERIIVEXTPROC                  gl3wGetMultiTexParameterIivEXT;
PFNGLGETMULTITEXPARAMETERIUIVEXTPROC                 gl3wGetMultiTexParameterIuivEXT;
PFNGLGETMULTITEXPARAMETERFVEXTPROC                   gl3wGetMultiTexParameterfvEXT;
PFNGLGETMULTITEXPARAMETERIVEXTPROC                   gl3wGetMultiTexParameterivEXT;
PFNGLGETMULTISAMPLEFVPROC                            gl3wGetMultisamplefv;
PFNGLGETNAMEDBUFFERPARAMETERI64VPROC                 gl3wGetNamedBufferParameteri64v;
PFNGLGETNAMEDBUFFERPARAMETERIVPROC                   gl3wGetNamedBufferParameteriv;
PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC                gl3wGetNamedBufferParameterivEXT;
PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC              gl3wGetNamedBufferParameterui64vNV;
PFNGLGETNAMEDBUFFERPOINTERVPROC                      gl3wGetNamedBufferPointerv;
PFNGLGETNAMEDBUFFERPOINTERVEXTPROC                   gl3wGetNamedBufferPointervEXT;
PFNGLGETNAMEDBUFFERSUBDATAPROC                       gl3wGetNamedBufferSubData;
PFNGLGETNAMEDBUFFERSUBDATAEXTPROC                    gl3wGetNamedBufferSubDataEXT;
PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC    gl3wGetNamedFramebufferAttachmentParameteriv;
PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC gl3wGetNamedFramebufferAttachmentParameterivEXT;
PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC              gl3wGetNamedFramebufferParameteriv;
PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC           gl3wGetNamedFramebufferParameterivEXT;
PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC         gl3wGetNamedProgramLocalParameterIivEXT;
PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC        gl3wGetNamedProgramLocalParameterIuivEXT;
PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC          gl3wGetNamedProgramLocalParameterdvEXT;
PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC          gl3wGetNamedProgramLocalParameterfvEXT;
PFNGLGETNAMEDPROGRAMSTRINGEXTPROC                    gl3wGetNamedProgramStringEXT;
PFNGLGETNAMEDPROGRAMIVEXTPROC                        gl3wGetNamedProgramivEXT;
PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC             gl3wGetNamedRenderbufferParameteriv;
PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC          gl3wGetNamedRenderbufferParameterivEXT;
PFNGLGETNAMEDSTRINGARBPROC                           gl3wGetNamedStringARB;
PFNGLGETNAMEDSTRINGIVARBPROC                         gl3wGetNamedStringivARB;
PFNGLGETNEXTPERFQUERYIDINTELPROC                     gl3wGetNextPerfQueryIdINTEL;
PFNGLGETOBJECTLABELPROC                              gl3wGetObjectLabel;
PFNGLGETOBJECTLABELEXTPROC                           gl3wGetObjectLabelEXT;
PFNGLGETOBJECTPTRLABELPROC                           gl3wGetObjectPtrLabel;
PFNGLGETPATHCOMMANDSNVPROC                           gl3wGetPathCommandsNV;
PFNGLGETPATHCOORDSNVPROC                             gl3wGetPathCoordsNV;
PFNGLGETPATHDASHARRAYNVPROC                          gl3wGetPathDashArrayNV;
PFNGLGETPATHLENGTHNVPROC                             gl3wGetPathLengthNV;
PFNGLGETPATHMETRICRANGENVPROC                        gl3wGetPathMetricRangeNV;
PFNGLGETPATHMETRICSNVPROC                            gl3wGetPathMetricsNV;
PFNGLGETPATHPARAMETERFVNVPROC                        gl3wGetPathParameterfvNV;
PFNGLGETPATHPARAMETERIVNVPROC                        gl3wGetPathParameterivNV;
PFNGLGETPATHSPACINGNVPROC                            gl3wGetPathSpacingNV;
PFNGLGETPERFCOUNTERINFOINTELPROC                     gl3wGetPerfCounterInfoINTEL;
PFNGLGETPERFMONITORCOUNTERDATAAMDPROC                gl3wGetPerfMonitorCounterDataAMD;
PFNGLGETPERFMONITORCOUNTERINFOAMDPROC                gl3wGetPerfMonitorCounterInfoAMD;
PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC              gl3wGetPerfMonitorCounterStringAMD;
PFNGLGETPERFMONITORCOUNTERSAMDPROC                   gl3wGetPerfMonitorCountersAMD;
PFNGLGETPERFMONITORGROUPSTRINGAMDPROC                gl3wGetPerfMonitorGroupStringAMD;
PFNGLGETPERFMONITORGROUPSAMDPROC                     gl3wGetPerfMonitorGroupsAMD;
PFNGLGETPERFQUERYDATAINTELPROC                       gl3wGetPerfQueryDataINTEL;
PFNGLGETPERFQUERYIDBYNAMEINTELPROC                   gl3wGetPerfQueryIdByNameINTEL;
PFNGLGETPERFQUERYINFOINTELPROC                       gl3wGetPerfQueryInfoINTEL;
PFNGLGETPOINTERINDEXEDVEXTPROC                       gl3wGetPointerIndexedvEXT;
PFNGLGETPOINTERI_VEXTPROC                            gl3wGetPointeri_vEXT;
PFNGLGETPOINTERVPROC                                 gl3wGetPointerv;
PFNGLGETPROGRAMBINARYPROC                            gl3wGetProgramBinary;
PFNGLGETPROGRAMINFOLOGPROC                           gl3wGetProgramInfoLog;
PFNGLGETPROGRAMINTERFACEIVPROC                       gl3wGetProgramInterfaceiv;
PFNGLGETPROGRAMPIPELINEINFOLOGPROC                   gl3wGetProgramPipelineInfoLog;
PFNGLGETPROGRAMPIPELINEIVPROC                        gl3wGetProgramPipelineiv;
PFNGLGETPROGRAMRESOURCEINDEXPROC                     gl3wGetProgramResourceIndex;
PFNGLGETPROGRAMRESOURCELOCATIONPROC                  gl3wGetProgramResourceLocation;
PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC             gl3wGetProgramResourceLocationIndex;
PFNGLGETPROGRAMRESOURCENAMEPROC                      gl3wGetProgramResourceName;
PFNGLGETPROGRAMRESOURCEFVNVPROC                      gl3wGetProgramResourcefvNV;
PFNGLGETPROGRAMRESOURCEIVPROC                        gl3wGetProgramResourceiv;
PFNGLGETPROGRAMSTAGEIVPROC                           gl3wGetProgramStageiv;
PFNGLGETPROGRAMIVPROC                                gl3wGetProgramiv;
PFNGLGETQUERYBUFFEROBJECTI64VPROC                    gl3wGetQueryBufferObjecti64v;
PFNGLGETQUERYBUFFEROBJECTIVPROC                      gl3wGetQueryBufferObjectiv;
PFNGLGETQUERYBUFFEROBJECTUI64VPROC                   gl3wGetQueryBufferObjectui64v;
PFNGLGETQUERYBUFFEROBJECTUIVPROC                     gl3wGetQueryBufferObjectuiv;
PFNGLGETQUERYINDEXEDIVPROC                           gl3wGetQueryIndexediv;
PFNGLGETQUERYOBJECTI64VPROC                          gl3wGetQueryObjecti64v;
PFNGLGETQUERYOBJECTIVPROC                            gl3wGetQueryObjectiv;
PFNGLGETQUERYOBJECTUI64VPROC                         gl3wGetQueryObjectui64v;
PFNGLGETQUERYOBJECTUIVPROC                           gl3wGetQueryObjectuiv;
PFNGLGETQUERYIVPROC                                  gl3wGetQueryiv;
PFNGLGETRENDERBUFFERPARAMETERIVPROC                  gl3wGetRenderbufferParameteriv;
PFNGLGETSAMPLERPARAMETERIIVPROC                      gl3wGetSamplerParameterIiv;
PFNGLGETSAMPLERPARAMETERIUIVPROC                     gl3wGetSamplerParameterIuiv;
PFNGLGETSAMPLERPARAMETERFVPROC                       gl3wGetSamplerParameterfv;
PFNGLGETSAMPLERPARAMETERIVPROC                       gl3wGetSamplerParameteriv;
PFNGLGETSHADERINFOLOGPROC                            gl3wGetShaderInfoLog;
PFNGLGETSHADERPRECISIONFORMATPROC                    gl3wGetShaderPrecisionFormat;
PFNGLGETSHADERSOURCEPROC                             gl3wGetShaderSource;
PFNGLGETSHADERIVPROC                                 gl3wGetShaderiv;
PFNGLGETSTAGEINDEXNVPROC                             gl3wGetStageIndexNV;
PFNGLGETSTRINGPROC                                   gl3wGetString;
PFNGLGETSTRINGIPROC                                  gl3wGetStringi;
PFNGLGETSUBROUTINEINDEXPROC                          gl3wGetSubroutineIndex;
PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC                gl3wGetSubroutineUniformLocation;
PFNGLGETSYNCIVPROC                                   gl3wGetSynciv;
PFNGLGETTEXIMAGEPROC                                 gl3wGetTexImage;
PFNGLGETTEXLEVELPARAMETERFVPROC                      gl3wGetTexLevelParameterfv;
PFNGLGETTEXLEVELPARAMETERIVPROC                      gl3wGetTexLevelParameteriv;
PFNGLGETTEXPARAMETERIIVPROC                          gl3wGetTexParameterIiv;
PFNGLGETTEXPARAMETERIUIVPROC                         gl3wGetTexParameterIuiv;
PFNGLGETTEXPARAMETERFVPROC                           gl3wGetTexParameterfv;
PFNGLGETTEXPARAMETERIVPROC                           gl3wGetTexParameteriv;
PFNGLGETTEXTUREHANDLEARBPROC                         gl3wGetTextureHandleARB;
PFNGLGETTEXTUREHANDLENVPROC                          gl3wGetTextureHandleNV;
PFNGLGETTEXTUREIMAGEPROC                             gl3wGetTextureImage;
PFNGLGETTEXTUREIMAGEEXTPROC                          gl3wGetTextureImageEXT;
PFNGLGETTEXTURELEVELPARAMETERFVPROC                  gl3wGetTextureLevelParameterfv;
PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC               gl3wGetTextureLevelParameterfvEXT;
PFNGLGETTEXTURELEVELPARAMETERIVPROC                  gl3wGetTextureLevelParameteriv;
PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC               gl3wGetTextureLevelParameterivEXT;
PFNGLGETTEXTUREPARAMETERIIVPROC                      gl3wGetTextureParameterIiv;
PFNGLGETTEXTUREPARAMETERIIVEXTPROC                   gl3wGetTextureParameterIivEXT;
PFNGLGETTEXTUREPARAMETERIUIVPROC                     gl3wGetTextureParameterIuiv;
PFNGLGETTEXTUREPARAMETERIUIVEXTPROC                  gl3wGetTextureParameterIuivEXT;
PFNGLGETTEXTUREPARAMETERFVPROC                       gl3wGetTextureParameterfv;
PFNGLGETTEXTUREPARAMETERFVEXTPROC                    gl3wGetTextureParameterfvEXT;
PFNGLGETTEXTUREPARAMETERIVPROC                       gl3wGetTextureParameteriv;
PFNGLGETTEXTUREPARAMETERIVEXTPROC                    gl3wGetTextureParameterivEXT;
PFNGLGETTEXTURESAMPLERHANDLEARBPROC                  gl3wGetTextureSamplerHandleARB;
PFNGLGETTEXTURESAMPLERHANDLENVPROC                   gl3wGetTextureSamplerHandleNV;
PFNGLGETTEXTURESUBIMAGEPROC                          gl3wGetTextureSubImage;
PFNGLGETTRANSFORMFEEDBACKVARYINGPROC                 gl3wGetTransformFeedbackVarying;
PFNGLGETTRANSFORMFEEDBACKI64_VPROC                   gl3wGetTransformFeedbacki64_v;
PFNGLGETTRANSFORMFEEDBACKI_VPROC                     gl3wGetTransformFeedbacki_v;
PFNGLGETTRANSFORMFEEDBACKIVPROC                      gl3wGetTransformFeedbackiv;
PFNGLGETUNIFORMBLOCKINDEXPROC                        gl3wGetUniformBlockIndex;
PFNGLGETUNIFORMINDICESPROC                           gl3wGetUniformIndices;
PFNGLGETUNIFORMLOCATIONPROC                          gl3wGetUniformLocation;
PFNGLGETUNIFORMSUBROUTINEUIVPROC                     gl3wGetUniformSubroutineuiv;
PFNGLGETUNIFORMDVPROC                                gl3wGetUniformdv;
PFNGLGETUNIFORMFVPROC                                gl3wGetUniformfv;
PFNGLGETUNIFORMI64VARBPROC                           gl3wGetUniformi64vARB;
PFNGLGETUNIFORMI64VNVPROC                            gl3wGetUniformi64vNV;
PFNGLGETUNIFORMIVPROC                                gl3wGetUniformiv;
PFNGLGETUNIFORMUI64VARBPROC                          gl3wGetUniformui64vARB;
PFNGLGETUNIFORMUI64VNVPROC                           gl3wGetUniformui64vNV;
PFNGLGETUNIFORMUIVPROC                               gl3wGetUniformuiv;
PFNGLGETVERTEXARRAYINDEXED64IVPROC                   gl3wGetVertexArrayIndexed64iv;
PFNGLGETVERTEXARRAYINDEXEDIVPROC                     gl3wGetVertexArrayIndexediv;
PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC                 gl3wGetVertexArrayIntegeri_vEXT;
PFNGLGETVERTEXARRAYINTEGERVEXTPROC                   gl3wGetVertexArrayIntegervEXT;
PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC                 gl3wGetVertexArrayPointeri_vEXT;
PFNGLGETVERTEXARRAYPOINTERVEXTPROC                   gl3wGetVertexArrayPointervEXT;
PFNGLGETVERTEXARRAYIVPROC                            gl3wGetVertexArrayiv;
PFNGLGETVERTEXATTRIBIIVPROC                          gl3wGetVertexAttribIiv;
PFNGLGETVERTEXATTRIBIUIVPROC                         gl3wGetVertexAttribIuiv;
PFNGLGETVERTEXATTRIBLDVPROC                          gl3wGetVertexAttribLdv;
PFNGLGETVERTEXATTRIBLI64VNVPROC                      gl3wGetVertexAttribLi64vNV;
PFNGLGETVERTEXATTRIBLUI64VARBPROC                    gl3wGetVertexAttribLui64vARB;
PFNGLGETVERTEXATTRIBLUI64VNVPROC                     gl3wGetVertexAttribLui64vNV;
PFNGLGETVERTEXATTRIBPOINTERVPROC                     gl3wGetVertexAttribPointerv;
PFNGLGETVERTEXATTRIBDVPROC                           gl3wGetVertexAttribdv;
PFNGLGETVERTEXATTRIBFVPROC                           gl3wGetVertexAttribfv;
PFNGLGETVERTEXATTRIBIVPROC                           gl3wGetVertexAttribiv;
PFNGLGETVKPROCADDRNVPROC                             gl3wGetVkProcAddrNV;
PFNGLGETNCOMPRESSEDTEXIMAGEPROC                      gl3wGetnCompressedTexImage;
PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC                   gl3wGetnCompressedTexImageARB;
PFNGLGETNTEXIMAGEPROC                                gl3wGetnTexImage;
PFNGLGETNTEXIMAGEARBPROC                             gl3wGetnTexImageARB;
PFNGLGETNUNIFORMDVPROC                               gl3wGetnUniformdv;
PFNGLGETNUNIFORMDVARBPROC                            gl3wGetnUniformdvARB;
PFNGLGETNUNIFORMFVPROC                               gl3wGetnUniformfv;
PFNGLGETNUNIFORMFVARBPROC                            gl3wGetnUniformfvARB;
PFNGLGETNUNIFORMI64VARBPROC                          gl3wGetnUniformi64vARB;
PFNGLGETNUNIFORMIVPROC                               gl3wGetnUniformiv;
PFNGLGETNUNIFORMIVARBPROC                            gl3wGetnUniformivARB;
PFNGLGETNUNIFORMUI64VARBPROC                         gl3wGetnUniformui64vARB;
PFNGLGETNUNIFORMUIVPROC                              gl3wGetnUniformuiv;
PFNGLGETNUNIFORMUIVARBPROC                           gl3wGetnUniformuivARB;
PFNGLHINTPROC                                        gl3wHint;
PFNGLINDEXFORMATNVPROC                               gl3wIndexFormatNV;
PFNGLINSERTEVENTMARKEREXTPROC                        gl3wInsertEventMarkerEXT;
PFNGLINTERPOLATEPATHSNVPROC                          gl3wInterpolatePathsNV;
PFNGLINVALIDATEBUFFERDATAPROC                        gl3wInvalidateBufferData;
PFNGLINVALIDATEBUFFERSUBDATAPROC                     gl3wInvalidateBufferSubData;
PFNGLINVALIDATEFRAMEBUFFERPROC                       gl3wInvalidateFramebuffer;
PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC              gl3wInvalidateNamedFramebufferData;
PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC           gl3wInvalidateNamedFramebufferSubData;
PFNGLINVALIDATESUBFRAMEBUFFERPROC                    gl3wInvalidateSubFramebuffer;
PFNGLINVALIDATETEXIMAGEPROC                          gl3wInvalidateTexImage;
PFNGLINVALIDATETEXSUBIMAGEPROC                       gl3wInvalidateTexSubImage;
PFNGLISBUFFERPROC                                    gl3wIsBuffer;
PFNGLISBUFFERRESIDENTNVPROC                          gl3wIsBufferResidentNV;
PFNGLISCOMMANDLISTNVPROC                             gl3wIsCommandListNV;
PFNGLISENABLEDPROC                                   gl3wIsEnabled;
PFNGLISENABLEDINDEXEDEXTPROC                         gl3wIsEnabledIndexedEXT;
PFNGLISENABLEDIPROC                                  gl3wIsEnabledi;
PFNGLISFRAMEBUFFERPROC                               gl3wIsFramebuffer;
PFNGLISIMAGEHANDLERESIDENTARBPROC                    gl3wIsImageHandleResidentARB;
PFNGLISIMAGEHANDLERESIDENTNVPROC                     gl3wIsImageHandleResidentNV;
PFNGLISNAMEDBUFFERRESIDENTNVPROC                     gl3wIsNamedBufferResidentNV;
PFNGLISNAMEDSTRINGARBPROC                            gl3wIsNamedStringARB;
PFNGLISPATHNVPROC                                    gl3wIsPathNV;
PFNGLISPOINTINFILLPATHNVPROC                         gl3wIsPointInFillPathNV;
PFNGLISPOINTINSTROKEPATHNVPROC                       gl3wIsPointInStrokePathNV;
PFNGLISPROGRAMPROC                                   gl3wIsProgram;
PFNGLISPROGRAMPIPELINEPROC                           gl3wIsProgramPipeline;
PFNGLISQUERYPROC                                     gl3wIsQuery;
PFNGLISRENDERBUFFERPROC                              gl3wIsRenderbuffer;
PFNGLISSAMPLERPROC                                   gl3wIsSampler;
PFNGLISSHADERPROC                                    gl3wIsShader;
PFNGLISSTATENVPROC                                   gl3wIsStateNV;
PFNGLISSYNCPROC                                      gl3wIsSync;
PFNGLISTEXTUREPROC                                   gl3wIsTexture;
PFNGLISTEXTUREHANDLERESIDENTARBPROC                  gl3wIsTextureHandleResidentARB;
PFNGLISTEXTUREHANDLERESIDENTNVPROC                   gl3wIsTextureHandleResidentNV;
PFNGLISTRANSFORMFEEDBACKPROC                         gl3wIsTransformFeedback;
PFNGLISVERTEXARRAYPROC                               gl3wIsVertexArray;
PFNGLLABELOBJECTEXTPROC                              gl3wLabelObjectEXT;
PFNGLLINEWIDTHPROC                                   gl3wLineWidth;
PFNGLLINKPROGRAMPROC                                 gl3wLinkProgram;
PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC              gl3wListDrawCommandsStatesClientNV;
PFNGLLOGICOPPROC                                     gl3wLogicOp;
PFNGLMAKEBUFFERNONRESIDENTNVPROC                     gl3wMakeBufferNonResidentNV;
PFNGLMAKEBUFFERRESIDENTNVPROC                        gl3wMakeBufferResidentNV;
PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC               gl3wMakeImageHandleNonResidentARB;
PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC                gl3wMakeImageHandleNonResidentNV;
PFNGLMAKEIMAGEHANDLERESIDENTARBPROC                  gl3wMakeImageHandleResidentARB;
PFNGLMAKEIMAGEHANDLERESIDENTNVPROC                   gl3wMakeImageHandleResidentNV;
PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC                gl3wMakeNamedBufferNonResidentNV;
PFNGLMAKENAMEDBUFFERRESIDENTNVPROC                   gl3wMakeNamedBufferResidentNV;
PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC             gl3wMakeTextureHandleNonResidentARB;
PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC              gl3wMakeTextureHandleNonResidentNV;
PFNGLMAKETEXTUREHANDLERESIDENTARBPROC                gl3wMakeTextureHandleResidentARB;
PFNGLMAKETEXTUREHANDLERESIDENTNVPROC                 gl3wMakeTextureHandleResidentNV;
PFNGLMAPBUFFERPROC                                   gl3wMapBuffer;
PFNGLMAPBUFFERRANGEPROC                              gl3wMapBufferRange;
PFNGLMAPNAMEDBUFFERPROC                              gl3wMapNamedBuffer;
PFNGLMAPNAMEDBUFFEREXTPROC                           gl3wMapNamedBufferEXT;
PFNGLMAPNAMEDBUFFERRANGEPROC                         gl3wMapNamedBufferRange;
PFNGLMAPNAMEDBUFFERRANGEEXTPROC                      gl3wMapNamedBufferRangeEXT;
PFNGLMATRIXFRUSTUMEXTPROC                            gl3wMatrixFrustumEXT;
PFNGLMATRIXLOAD3X2FNVPROC                            gl3wMatrixLoad3x2fNV;
PFNGLMATRIXLOAD3X3FNVPROC                            gl3wMatrixLoad3x3fNV;
PFNGLMATRIXLOADIDENTITYEXTPROC                       gl3wMatrixLoadIdentityEXT;
PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC                   gl3wMatrixLoadTranspose3x3fNV;
PFNGLMATRIXLOADTRANSPOSEDEXTPROC                     gl3wMatrixLoadTransposedEXT;
PFNGLMATRIXLOADTRANSPOSEFEXTPROC                     gl3wMatrixLoadTransposefEXT;
PFNGLMATRIXLOADDEXTPROC                              gl3wMatrixLoaddEXT;
PFNGLMATRIXLOADFEXTPROC                              gl3wMatrixLoadfEXT;
PFNGLMATRIXMULT3X2FNVPROC                            gl3wMatrixMult3x2fNV;
PFNGLMATRIXMULT3X3FNVPROC                            gl3wMatrixMult3x3fNV;
PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC                   gl3wMatrixMultTranspose3x3fNV;
PFNGLMATRIXMULTTRANSPOSEDEXTPROC                     gl3wMatrixMultTransposedEXT;
PFNGLMATRIXMULTTRANSPOSEFEXTPROC                     gl3wMatrixMultTransposefEXT;
PFNGLMATRIXMULTDEXTPROC                              gl3wMatrixMultdEXT;
PFNGLMATRIXMULTFEXTPROC                              gl3wMatrixMultfEXT;
PFNGLMATRIXORTHOEXTPROC                              gl3wMatrixOrthoEXT;
PFNGLMATRIXPOPEXTPROC                                gl3wMatrixPopEXT;
PFNGLMATRIXPUSHEXTPROC                               gl3wMatrixPushEXT;
PFNGLMATRIXROTATEDEXTPROC                            gl3wMatrixRotatedEXT;
PFNGLMATRIXROTATEFEXTPROC                            gl3wMatrixRotatefEXT;
PFNGLMATRIXSCALEDEXTPROC                             gl3wMatrixScaledEXT;
PFNGLMATRIXSCALEFEXTPROC                             gl3wMatrixScalefEXT;
PFNGLMATRIXTRANSLATEDEXTPROC                         gl3wMatrixTranslatedEXT;
PFNGLMATRIXTRANSLATEFEXTPROC                         gl3wMatrixTranslatefEXT;
PFNGLMAXSHADERCOMPILERTHREADSARBPROC                 gl3wMaxShaderCompilerThreadsARB;
PFNGLMEMORYBARRIERPROC                               gl3wMemoryBarrier;
PFNGLMEMORYBARRIERBYREGIONPROC                       gl3wMemoryBarrierByRegion;
PFNGLMINSAMPLESHADINGPROC                            gl3wMinSampleShading;
PFNGLMINSAMPLESHADINGARBPROC                         gl3wMinSampleShadingARB;
PFNGLMULTIDRAWARRAYSPROC                             gl3wMultiDrawArrays;
PFNGLMULTIDRAWARRAYSINDIRECTPROC                     gl3wMultiDrawArraysIndirect;
PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC      gl3wMultiDrawArraysIndirectBindlessCountNV;
PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC           gl3wMultiDrawArraysIndirectBindlessNV;
PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC             gl3wMultiDrawArraysIndirectCountARB;
PFNGLMULTIDRAWELEMENTSPROC                           gl3wMultiDrawElements;
PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC                 gl3wMultiDrawElementsBaseVertex;
PFNGLMULTIDRAWELEMENTSINDIRECTPROC                   gl3wMultiDrawElementsIndirect;
PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC    gl3wMultiDrawElementsIndirectBindlessCountNV;
PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC         gl3wMultiDrawElementsIndirectBindlessNV;
PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC           gl3wMultiDrawElementsIndirectCountARB;
PFNGLMULTITEXBUFFEREXTPROC                           gl3wMultiTexBufferEXT;
PFNGLMULTITEXCOORDPOINTEREXTPROC                     gl3wMultiTexCoordPointerEXT;
PFNGLMULTITEXENVFEXTPROC                             gl3wMultiTexEnvfEXT;
PFNGLMULTITEXENVFVEXTPROC                            gl3wMultiTexEnvfvEXT;
PFNGLMULTITEXENVIEXTPROC                             gl3wMultiTexEnviEXT;
PFNGLMULTITEXENVIVEXTPROC                            gl3wMultiTexEnvivEXT;
PFNGLMULTITEXGENDEXTPROC                             gl3wMultiTexGendEXT;
PFNGLMULTITEXGENDVEXTPROC                            gl3wMultiTexGendvEXT;
PFNGLMULTITEXGENFEXTPROC                             gl3wMultiTexGenfEXT;
PFNGLMULTITEXGENFVEXTPROC                            gl3wMultiTexGenfvEXT;
PFNGLMULTITEXGENIEXTPROC                             gl3wMultiTexGeniEXT;
PFNGLMULTITEXGENIVEXTPROC                            gl3wMultiTexGenivEXT;
PFNGLMULTITEXIMAGE1DEXTPROC                          gl3wMultiTexImage1DEXT;
PFNGLMULTITEXIMAGE2DEXTPROC                          gl3wMultiTexImage2DEXT;
PFNGLMULTITEXIMAGE3DEXTPROC                          gl3wMultiTexImage3DEXT;
PFNGLMULTITEXPARAMETERIIVEXTPROC                     gl3wMultiTexParameterIivEXT;
PFNGLMULTITEXPARAMETERIUIVEXTPROC                    gl3wMultiTexParameterIuivEXT;
PFNGLMULTITEXPARAMETERFEXTPROC                       gl3wMultiTexParameterfEXT;
PFNGLMULTITEXPARAMETERFVEXTPROC                      gl3wMultiTexParameterfvEXT;
PFNGLMULTITEXPARAMETERIEXTPROC                       gl3wMultiTexParameteriEXT;
PFNGLMULTITEXPARAMETERIVEXTPROC                      gl3wMultiTexParameterivEXT;
PFNGLMULTITEXRENDERBUFFEREXTPROC                     gl3wMultiTexRenderbufferEXT;
PFNGLMULTITEXSUBIMAGE1DEXTPROC                       gl3wMultiTexSubImage1DEXT;
PFNGLMULTITEXSUBIMAGE2DEXTPROC                       gl3wMultiTexSubImage2DEXT;
PFNGLMULTITEXSUBIMAGE3DEXTPROC                       gl3wMultiTexSubImage3DEXT;
PFNGLNAMEDBUFFERDATAPROC                             gl3wNamedBufferData;
PFNGLNAMEDBUFFERDATAEXTPROC                          gl3wNamedBufferDataEXT;
PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC                gl3wNamedBufferPageCommitmentARB;
PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC                gl3wNamedBufferPageCommitmentEXT;
PFNGLNAMEDBUFFERSTORAGEPROC                          gl3wNamedBufferStorage;
PFNGLNAMEDBUFFERSTORAGEEXTPROC                       gl3wNamedBufferStorageEXT;
PFNGLNAMEDBUFFERSUBDATAPROC                          gl3wNamedBufferSubData;
PFNGLNAMEDBUFFERSUBDATAEXTPROC                       gl3wNamedBufferSubDataEXT;
PFNGLNAMEDCOPYBUFFERSUBDATAEXTPROC                   gl3wNamedCopyBufferSubDataEXT;
PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC                  gl3wNamedFramebufferDrawBuffer;
PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC                 gl3wNamedFramebufferDrawBuffers;
PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC                  gl3wNamedFramebufferParameteri;
PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC               gl3wNamedFramebufferParameteriEXT;
PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC                  gl3wNamedFramebufferReadBuffer;
PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC                gl3wNamedFramebufferRenderbuffer;
PFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC             gl3wNamedFramebufferRenderbufferEXT;
PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVARBPROC        gl3wNamedFramebufferSampleLocationsfvARB;
PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC         gl3wNamedFramebufferSampleLocationsfvNV;
PFNGLNAMEDFRAMEBUFFERTEXTUREPROC                     gl3wNamedFramebufferTexture;
PFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC                gl3wNamedFramebufferTexture1DEXT;
PFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC                gl3wNamedFramebufferTexture2DEXT;
PFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC                gl3wNamedFramebufferTexture3DEXT;
PFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC                  gl3wNamedFramebufferTextureEXT;
PFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC              gl3wNamedFramebufferTextureFaceEXT;
PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC                gl3wNamedFramebufferTextureLayer;
PFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC             gl3wNamedFramebufferTextureLayerEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC             gl3wNamedProgramLocalParameter4dEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC            gl3wNamedProgramLocalParameter4dvEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC             gl3wNamedProgramLocalParameter4fEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC            gl3wNamedProgramLocalParameter4fvEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC            gl3wNamedProgramLocalParameterI4iEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC           gl3wNamedProgramLocalParameterI4ivEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC           gl3wNamedProgramLocalParameterI4uiEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC          gl3wNamedProgramLocalParameterI4uivEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC           gl3wNamedProgramLocalParameters4fvEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC          gl3wNamedProgramLocalParametersI4ivEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC         gl3wNamedProgramLocalParametersI4uivEXT;
PFNGLNAMEDPROGRAMSTRINGEXTPROC                       gl3wNamedProgramStringEXT;
PFNGLNAMEDRENDERBUFFERSTORAGEPROC                    gl3wNamedRenderbufferStorage;
PFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC                 gl3wNamedRenderbufferStorageEXT;
PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC         gl3wNamedRenderbufferStorageMultisample;
PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC gl3wNamedRenderbufferStorageMultisampleCoverageEXT;
PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC      gl3wNamedRenderbufferStorageMultisampleEXT;
PFNGLNAMEDSTRINGARBPROC                              gl3wNamedStringARB;
PFNGLNORMALFORMATNVPROC                              gl3wNormalFormatNV;
PFNGLOBJECTLABELPROC                                 gl3wObjectLabel;
PFNGLOBJECTPTRLABELPROC                              gl3wObjectPtrLabel;
PFNGLPATCHPARAMETERFVPROC                            gl3wPatchParameterfv;
PFNGLPATCHPARAMETERIPROC                             gl3wPatchParameteri;
PFNGLPATHCOMMANDSNVPROC                              gl3wPathCommandsNV;
PFNGLPATHCOORDSNVPROC                                gl3wPathCoordsNV;
PFNGLPATHCOVERDEPTHFUNCNVPROC                        gl3wPathCoverDepthFuncNV;
PFNGLPATHDASHARRAYNVPROC                             gl3wPathDashArrayNV;
PFNGLPATHGLYPHINDEXARRAYNVPROC                       gl3wPathGlyphIndexArrayNV;
PFNGLPATHGLYPHINDEXRANGENVPROC                       gl3wPathGlyphIndexRangeNV;
PFNGLPATHGLYPHRANGENVPROC                            gl3wPathGlyphRangeNV;
PFNGLPATHGLYPHSNVPROC                                gl3wPathGlyphsNV;
PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC                 gl3wPathMemoryGlyphIndexArrayNV;
PFNGLPATHPARAMETERFNVPROC                            gl3wPathParameterfNV;
PFNGLPATHPARAMETERFVNVPROC                           gl3wPathParameterfvNV;
PFNGLPATHPARAMETERINVPROC                            gl3wPathParameteriNV;
PFNGLPATHPARAMETERIVNVPROC                           gl3wPathParameterivNV;
PFNGLPATHSTENCILDEPTHOFFSETNVPROC                    gl3wPathStencilDepthOffsetNV;
PFNGLPATHSTENCILFUNCNVPROC                           gl3wPathStencilFuncNV;
PFNGLPATHSTRINGNVPROC                                gl3wPathStringNV;
PFNGLPATHSUBCOMMANDSNVPROC                           gl3wPathSubCommandsNV;
PFNGLPATHSUBCOORDSNVPROC                             gl3wPathSubCoordsNV;
PFNGLPAUSETRANSFORMFEEDBACKPROC                      gl3wPauseTransformFeedback;
PFNGLPIXELSTOREFPROC                                 gl3wPixelStoref;
PFNGLPIXELSTOREIPROC                                 gl3wPixelStorei;
PFNGLPOINTALONGPATHNVPROC                            gl3wPointAlongPathNV;
PFNGLPOINTPARAMETERFPROC                             gl3wPointParameterf;
PFNGLPOINTPARAMETERFVPROC                            gl3wPointParameterfv;
PFNGLPOINTPARAMETERIPROC                             gl3wPointParameteri;
PFNGLPOINTPARAMETERIVPROC                            gl3wPointParameteriv;
PFNGLPOINTSIZEPROC                                   gl3wPointSize;
PFNGLPOLYGONMODEPROC                                 gl3wPolygonMode;
PFNGLPOLYGONOFFSETPROC                               gl3wPolygonOffset;
PFNGLPOLYGONOFFSETCLAMPEXTPROC                       gl3wPolygonOffsetClampEXT;
PFNGLPOPDEBUGGROUPPROC                               gl3wPopDebugGroup;
PFNGLPOPGROUPMARKEREXTPROC                           gl3wPopGroupMarkerEXT;
PFNGLPRIMITIVEBOUNDINGBOXARBPROC                     gl3wPrimitiveBoundingBoxARB;
PFNGLPRIMITIVERESTARTINDEXPROC                       gl3wPrimitiveRestartIndex;
PFNGLPROGRAMBINARYPROC                               gl3wProgramBinary;
PFNGLPROGRAMPARAMETERIPROC                           gl3wProgramParameteri;
PFNGLPROGRAMPARAMETERIARBPROC                        gl3wProgramParameteriARB;
PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC               gl3wProgramPathFragmentInputGenNV;
PFNGLPROGRAMUNIFORM1DPROC                            gl3wProgramUniform1d;
PFNGLPROGRAMUNIFORM1DEXTPROC                         gl3wProgramUniform1dEXT;
PFNGLPROGRAMUNIFORM1DVPROC                           gl3wProgramUniform1dv;
PFNGLPROGRAMUNIFORM1DVEXTPROC                        gl3wProgramUniform1dvEXT;
PFNGLPROGRAMUNIFORM1FPROC                            gl3wProgramUniform1f;
PFNGLPROGRAMUNIFORM1FEXTPROC                         gl3wProgramUniform1fEXT;
PFNGLPROGRAMUNIFORM1FVPROC                           gl3wProgramUniform1fv;
PFNGLPROGRAMUNIFORM1FVEXTPROC                        gl3wProgramUniform1fvEXT;
PFNGLPROGRAMUNIFORM1IPROC                            gl3wProgramUniform1i;
PFNGLPROGRAMUNIFORM1I64ARBPROC                       gl3wProgramUniform1i64ARB;
PFNGLPROGRAMUNIFORM1I64NVPROC                        gl3wProgramUniform1i64NV;
PFNGLPROGRAMUNIFORM1I64VARBPROC                      gl3wProgramUniform1i64vARB;
PFNGLPROGRAMUNIFORM1I64VNVPROC                       gl3wProgramUniform1i64vNV;
PFNGLPROGRAMUNIFORM1IEXTPROC                         gl3wProgramUniform1iEXT;
PFNGLPROGRAMUNIFORM1IVPROC                           gl3wProgramUniform1iv;
PFNGLPROGRAMUNIFORM1IVEXTPROC                        gl3wProgramUniform1ivEXT;
PFNGLPROGRAMUNIFORM1UIPROC                           gl3wProgramUniform1ui;
PFNGLPROGRAMUNIFORM1UI64ARBPROC                      gl3wProgramUniform1ui64ARB;
PFNGLPROGRAMUNIFORM1UI64NVPROC                       gl3wProgramUniform1ui64NV;
PFNGLPROGRAMUNIFORM1UI64VARBPROC                     gl3wProgramUniform1ui64vARB;
PFNGLPROGRAMUNIFORM1UI64VNVPROC                      gl3wProgramUniform1ui64vNV;
PFNGLPROGRAMUNIFORM1UIEXTPROC                        gl3wProgramUniform1uiEXT;
PFNGLPROGRAMUNIFORM1UIVPROC                          gl3wProgramUniform1uiv;
PFNGLPROGRAMUNIFORM1UIVEXTPROC                       gl3wProgramUniform1uivEXT;
PFNGLPROGRAMUNIFORM2DPROC                            gl3wProgramUniform2d;
PFNGLPROGRAMUNIFORM2DEXTPROC                         gl3wProgramUniform2dEXT;
PFNGLPROGRAMUNIFORM2DVPROC                           gl3wProgramUniform2dv;
PFNGLPROGRAMUNIFORM2DVEXTPROC                        gl3wProgramUniform2dvEXT;
PFNGLPROGRAMUNIFORM2FPROC                            gl3wProgramUniform2f;
PFNGLPROGRAMUNIFORM2FEXTPROC                         gl3wProgramUniform2fEXT;
PFNGLPROGRAMUNIFORM2FVPROC                           gl3wProgramUniform2fv;
PFNGLPROGRAMUNIFORM2FVEXTPROC                        gl3wProgramUniform2fvEXT;
PFNGLPROGRAMUNIFORM2IPROC                            gl3wProgramUniform2i;
PFNGLPROGRAMUNIFORM2I64ARBPROC                       gl3wProgramUniform2i64ARB;
PFNGLPROGRAMUNIFORM2I64NVPROC                        gl3wProgramUniform2i64NV;
PFNGLPROGRAMUNIFORM2I64VARBPROC                      gl3wProgramUniform2i64vARB;
PFNGLPROGRAMUNIFORM2I64VNVPROC                       gl3wProgramUniform2i64vNV;
PFNGLPROGRAMUNIFORM2IEXTPROC                         gl3wProgramUniform2iEXT;
PFNGLPROGRAMUNIFORM2IVPROC                           gl3wProgramUniform2iv;
PFNGLPROGRAMUNIFORM2IVEXTPROC                        gl3wProgramUniform2ivEXT;
PFNGLPROGRAMUNIFORM2UIPROC                           gl3wProgramUniform2ui;
PFNGLPROGRAMUNIFORM2UI64ARBPROC                      gl3wProgramUniform2ui64ARB;
PFNGLPROGRAMUNIFORM2UI64NVPROC                       gl3wProgramUniform2ui64NV;
PFNGLPROGRAMUNIFORM2UI64VARBPROC                     gl3wProgramUniform2ui64vARB;
PFNGLPROGRAMUNIFORM2UI64VNVPROC                      gl3wProgramUniform2ui64vNV;
PFNGLPROGRAMUNIFORM2UIEXTPROC                        gl3wProgramUniform2uiEXT;
PFNGLPROGRAMUNIFORM2UIVPROC                          gl3wProgramUniform2uiv;
PFNGLPROGRAMUNIFORM2UIVEXTPROC                       gl3wProgramUniform2uivEXT;
PFNGLPROGRAMUNIFORM3DPROC                            gl3wProgramUniform3d;
PFNGLPROGRAMUNIFORM3DEXTPROC                         gl3wProgramUniform3dEXT;
PFNGLPROGRAMUNIFORM3DVPROC                           gl3wProgramUniform3dv;
PFNGLPROGRAMUNIFORM3DVEXTPROC                        gl3wProgramUniform3dvEXT;
PFNGLPROGRAMUNIFORM3FPROC                            gl3wProgramUniform3f;
PFNGLPROGRAMUNIFORM3FEXTPROC                         gl3wProgramUniform3fEXT;
PFNGLPROGRAMUNIFORM3FVPROC                           gl3wProgramUniform3fv;
PFNGLPROGRAMUNIFORM3FVEXTPROC                        gl3wProgramUniform3fvEXT;
PFNGLPROGRAMUNIFORM3IPROC                            gl3wProgramUniform3i;
PFNGLPROGRAMUNIFORM3I64ARBPROC                       gl3wProgramUniform3i64ARB;
PFNGLPROGRAMUNIFORM3I64NVPROC                        gl3wProgramUniform3i64NV;
PFNGLPROGRAMUNIFORM3I64VARBPROC                      gl3wProgramUniform3i64vARB;
PFNGLPROGRAMUNIFORM3I64VNVPROC                       gl3wProgramUniform3i64vNV;
PFNGLPROGRAMUNIFORM3IEXTPROC                         gl3wProgramUniform3iEXT;
PFNGLPROGRAMUNIFORM3IVPROC                           gl3wProgramUniform3iv;
PFNGLPROGRAMUNIFORM3IVEXTPROC                        gl3wProgramUniform3ivEXT;
PFNGLPROGRAMUNIFORM3UIPROC                           gl3wProgramUniform3ui;
PFNGLPROGRAMUNIFORM3UI64ARBPROC                      gl3wProgramUniform3ui64ARB;
PFNGLPROGRAMUNIFORM3UI64NVPROC                       gl3wProgramUniform3ui64NV;
PFNGLPROGRAMUNIFORM3UI64VARBPROC                     gl3wProgramUniform3ui64vARB;
PFNGLPROGRAMUNIFORM3UI64VNVPROC                      gl3wProgramUniform3ui64vNV;
PFNGLPROGRAMUNIFORM3UIEXTPROC                        gl3wProgramUniform3uiEXT;
PFNGLPROGRAMUNIFORM3UIVPROC                          gl3wProgramUniform3uiv;
PFNGLPROGRAMUNIFORM3UIVEXTPROC                       gl3wProgramUniform3uivEXT;
PFNGLPROGRAMUNIFORM4DPROC                            gl3wProgramUniform4d;
PFNGLPROGRAMUNIFORM4DEXTPROC                         gl3wProgramUniform4dEXT;
PFNGLPROGRAMUNIFORM4DVPROC                           gl3wProgramUniform4dv;
PFNGLPROGRAMUNIFORM4DVEXTPROC                        gl3wProgramUniform4dvEXT;
PFNGLPROGRAMUNIFORM4FPROC                            gl3wProgramUniform4f;
PFNGLPROGRAMUNIFORM4FEXTPROC                         gl3wProgramUniform4fEXT;
PFNGLPROGRAMUNIFORM4FVPROC                           gl3wProgramUniform4fv;
PFNGLPROGRAMUNIFORM4FVEXTPROC                        gl3wProgramUniform4fvEXT;
PFNGLPROGRAMUNIFORM4IPROC                            gl3wProgramUniform4i;
PFNGLPROGRAMUNIFORM4I64ARBPROC                       gl3wProgramUniform4i64ARB;
PFNGLPROGRAMUNIFORM4I64NVPROC                        gl3wProgramUniform4i64NV;
PFNGLPROGRAMUNIFORM4I64VARBPROC                      gl3wProgramUniform4i64vARB;
PFNGLPROGRAMUNIFORM4I64VNVPROC                       gl3wProgramUniform4i64vNV;
PFNGLPROGRAMUNIFORM4IEXTPROC                         gl3wProgramUniform4iEXT;
PFNGLPROGRAMUNIFORM4IVPROC                           gl3wProgramUniform4iv;
PFNGLPROGRAMUNIFORM4IVEXTPROC                        gl3wProgramUniform4ivEXT;
PFNGLPROGRAMUNIFORM4UIPROC                           gl3wProgramUniform4ui;
PFNGLPROGRAMUNIFORM4UI64ARBPROC                      gl3wProgramUniform4ui64ARB;
PFNGLPROGRAMUNIFORM4UI64NVPROC                       gl3wProgramUniform4ui64NV;
PFNGLPROGRAMUNIFORM4UI64VARBPROC                     gl3wProgramUniform4ui64vARB;
PFNGLPROGRAMUNIFORM4UI64VNVPROC                      gl3wProgramUniform4ui64vNV;
PFNGLPROGRAMUNIFORM4UIEXTPROC                        gl3wProgramUniform4uiEXT;
PFNGLPROGRAMUNIFORM4UIVPROC                          gl3wProgramUniform4uiv;
PFNGLPROGRAMUNIFORM4UIVEXTPROC                       gl3wProgramUniform4uivEXT;
PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC                 gl3wProgramUniformHandleui64ARB;
PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC                  gl3wProgramUniformHandleui64NV;
PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC                gl3wProgramUniformHandleui64vARB;
PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC                 gl3wProgramUniformHandleui64vNV;
PFNGLPROGRAMUNIFORMMATRIX2DVPROC                     gl3wProgramUniformMatrix2dv;
PFNGLPROGRAMUNIFORMMATRIX2DVEXTPROC                  gl3wProgramUniformMatrix2dvEXT;
PFNGLPROGRAMUNIFORMMATRIX2FVPROC                     gl3wProgramUniformMatrix2fv;
PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC                  gl3wProgramUniformMatrix2fvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC                   gl3wProgramUniformMatrix2x3dv;
PFNGLPROGRAMUNIFORMMATRIX2X3DVEXTPROC                gl3wProgramUniformMatrix2x3dvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC                   gl3wProgramUniformMatrix2x3fv;
PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC                gl3wProgramUniformMatrix2x3fvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC                   gl3wProgramUniformMatrix2x4dv;
PFNGLPROGRAMUNIFORMMATRIX2X4DVEXTPROC                gl3wProgramUniformMatrix2x4dvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC                   gl3wProgramUniformMatrix2x4fv;
PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC                gl3wProgramUniformMatrix2x4fvEXT;
PFNGLPROGRAMUNIFORMMATRIX3DVPROC                     gl3wProgramUniformMatrix3dv;
PFNGLPROGRAMUNIFORMMATRIX3DVEXTPROC                  gl3wProgramUniformMatrix3dvEXT;
PFNGLPROGRAMUNIFORMMATRIX3FVPROC                     gl3wProgramUniformMatrix3fv;
PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC                  gl3wProgramUniformMatrix3fvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC                   gl3wProgramUniformMatrix3x2dv;
PFNGLPROGRAMUNIFORMMATRIX3X2DVEXTPROC                gl3wProgramUniformMatrix3x2dvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC                   gl3wProgramUniformMatrix3x2fv;
PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC                gl3wProgramUniformMatrix3x2fvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC                   gl3wProgramUniformMatrix3x4dv;
PFNGLPROGRAMUNIFORMMATRIX3X4DVEXTPROC                gl3wProgramUniformMatrix3x4dvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC                   gl3wProgramUniformMatrix3x4fv;
PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC                gl3wProgramUniformMatrix3x4fvEXT;
PFNGLPROGRAMUNIFORMMATRIX4DVPROC                     gl3wProgramUniformMatrix4dv;
PFNGLPROGRAMUNIFORMMATRIX4DVEXTPROC                  gl3wProgramUniformMatrix4dvEXT;
PFNGLPROGRAMUNIFORMMATRIX4FVPROC                     gl3wProgramUniformMatrix4fv;
PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC                  gl3wProgramUniformMatrix4fvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC                   gl3wProgramUniformMatrix4x2dv;
PFNGLPROGRAMUNIFORMMATRIX4X2DVEXTPROC                gl3wProgramUniformMatrix4x2dvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC                   gl3wProgramUniformMatrix4x2fv;
PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC                gl3wProgramUniformMatrix4x2fvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC                   gl3wProgramUniformMatrix4x3dv;
PFNGLPROGRAMUNIFORMMATRIX4X3DVEXTPROC                gl3wProgramUniformMatrix4x3dvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC                   gl3wProgramUniformMatrix4x3fv;
PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC                gl3wProgramUniformMatrix4x3fvEXT;
PFNGLPROGRAMUNIFORMUI64NVPROC                        gl3wProgramUniformui64NV;
PFNGLPROGRAMUNIFORMUI64VNVPROC                       gl3wProgramUniformui64vNV;
PFNGLPROVOKINGVERTEXPROC                             gl3wProvokingVertex;
PFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC                  gl3wPushClientAttribDefaultEXT;
PFNGLPUSHDEBUGGROUPPROC                              gl3wPushDebugGroup;
PFNGLPUSHGROUPMARKEREXTPROC                          gl3wPushGroupMarkerEXT;
PFNGLQUERYCOUNTERPROC                                gl3wQueryCounter;
PFNGLRASTERSAMPLESEXTPROC                            gl3wRasterSamplesEXT;
PFNGLREADBUFFERPROC                                  gl3wReadBuffer;
PFNGLREADPIXELSPROC                                  gl3wReadPixels;
PFNGLREADNPIXELSPROC                                 gl3wReadnPixels;
PFNGLREADNPIXELSARBPROC                              gl3wReadnPixelsARB;
PFNGLRELEASESHADERCOMPILERPROC                       gl3wReleaseShaderCompiler;
PFNGLRENDERBUFFERSTORAGEPROC                         gl3wRenderbufferStorage;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC              gl3wRenderbufferStorageMultisample;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC    gl3wRenderbufferStorageMultisampleCoverageNV;
PFNGLRESOLVEDEPTHVALUESNVPROC                        gl3wResolveDepthValuesNV;
PFNGLRESUMETRANSFORMFEEDBACKPROC                     gl3wResumeTransformFeedback;
PFNGLSAMPLECOVERAGEPROC                              gl3wSampleCoverage;
PFNGLSAMPLEMASKIPROC                                 gl3wSampleMaski;
PFNGLSAMPLERPARAMETERIIVPROC                         gl3wSamplerParameterIiv;
PFNGLSAMPLERPARAMETERIUIVPROC                        gl3wSamplerParameterIuiv;
PFNGLSAMPLERPARAMETERFPROC                           gl3wSamplerParameterf;
PFNGLSAMPLERPARAMETERFVPROC                          gl3wSamplerParameterfv;
PFNGLSAMPLERPARAMETERIPROC                           gl3wSamplerParameteri;
PFNGLSAMPLERPARAMETERIVPROC                          gl3wSamplerParameteriv;
PFNGLSCISSORPROC                                     gl3wScissor;
PFNGLSCISSORARRAYVPROC                               gl3wScissorArrayv;
PFNGLSCISSORINDEXEDPROC                              gl3wScissorIndexed;
PFNGLSCISSORINDEXEDVPROC                             gl3wScissorIndexedv;
PFNGLSECONDARYCOLORFORMATNVPROC                      gl3wSecondaryColorFormatNV;
PFNGLSELECTPERFMONITORCOUNTERSAMDPROC                gl3wSelectPerfMonitorCountersAMD;
PFNGLSHADERBINARYPROC                                gl3wShaderBinary;
PFNGLSHADERSOURCEPROC                                gl3wShaderSource;
PFNGLSHADERSTORAGEBLOCKBINDINGPROC                   gl3wShaderStorageBlockBinding;
PFNGLSIGNALVKFENCENVPROC                             gl3wSignalVkFenceNV;
PFNGLSIGNALVKSEMAPHORENVPROC                         gl3wSignalVkSemaphoreNV;
PFNGLSPECIALIZESHADERARBPROC                         gl3wSpecializeShaderARB;
PFNGLSTATECAPTURENVPROC                              gl3wStateCaptureNV;
PFNGLSTENCILFILLPATHINSTANCEDNVPROC                  gl3wStencilFillPathInstancedNV;
PFNGLSTENCILFILLPATHNVPROC                           gl3wStencilFillPathNV;
PFNGLSTENCILFUNCPROC                                 gl3wStencilFunc;
PFNGLSTENCILFUNCSEPARATEPROC                         gl3wStencilFuncSeparate;
PFNGLSTENCILMASKPROC                                 gl3wStencilMask;
PFNGLSTENCILMASKSEPARATEPROC                         gl3wStencilMaskSeparate;
PFNGLSTENCILOPPROC                                   gl3wStencilOp;
PFNGLSTENCILOPSEPARATEPROC                           gl3wStencilOpSeparate;
PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC                gl3wStencilStrokePathInstancedNV;
PFNGLSTENCILSTROKEPATHNVPROC                         gl3wStencilStrokePathNV;
PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC         gl3wStencilThenCoverFillPathInstancedNV;
PFNGLSTENCILTHENCOVERFILLPATHNVPROC                  gl3wStencilThenCoverFillPathNV;
PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC       gl3wStencilThenCoverStrokePathInstancedNV;
PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC                gl3wStencilThenCoverStrokePathNV;
PFNGLSUBPIXELPRECISIONBIASNVPROC                     gl3wSubpixelPrecisionBiasNV;
PFNGLTEXBUFFERPROC                                   gl3wTexBuffer;
PFNGLTEXBUFFERARBPROC                                gl3wTexBufferARB;
PFNGLTEXBUFFERRANGEPROC                              gl3wTexBufferRange;
PFNGLTEXCOORDFORMATNVPROC                            gl3wTexCoordFormatNV;
PFNGLTEXIMAGE1DPROC                                  gl3wTexImage1D;
PFNGLTEXIMAGE2DPROC                                  gl3wTexImage2D;
PFNGLTEXIMAGE2DMULTISAMPLEPROC                       gl3wTexImage2DMultisample;
PFNGLTEXIMAGE3DPROC                                  gl3wTexImage3D;
PFNGLTEXIMAGE3DMULTISAMPLEPROC                       gl3wTexImage3DMultisample;
PFNGLTEXPAGECOMMITMENTARBPROC                        gl3wTexPageCommitmentARB;
PFNGLTEXPARAMETERIIVPROC                             gl3wTexParameterIiv;
PFNGLTEXPARAMETERIUIVPROC                            gl3wTexParameterIuiv;
PFNGLTEXPARAMETERFPROC                               gl3wTexParameterf;
PFNGLTEXPARAMETERFVPROC                              gl3wTexParameterfv;
PFNGLTEXPARAMETERIPROC                               gl3wTexParameteri;
PFNGLTEXPARAMETERIVPROC                              gl3wTexParameteriv;
PFNGLTEXSTORAGE1DPROC                                gl3wTexStorage1D;
PFNGLTEXSTORAGE2DPROC                                gl3wTexStorage2D;
PFNGLTEXSTORAGE2DMULTISAMPLEPROC                     gl3wTexStorage2DMultisample;
PFNGLTEXSTORAGE3DPROC                                gl3wTexStorage3D;
PFNGLTEXSTORAGE3DMULTISAMPLEPROC                     gl3wTexStorage3DMultisample;
PFNGLTEXSUBIMAGE1DPROC                               gl3wTexSubImage1D;
PFNGLTEXSUBIMAGE2DPROC                               gl3wTexSubImage2D;
PFNGLTEXSUBIMAGE3DPROC                               gl3wTexSubImage3D;
PFNGLTEXTUREBARRIERPROC                              gl3wTextureBarrier;
PFNGLTEXTUREBARRIERNVPROC                            gl3wTextureBarrierNV;
PFNGLTEXTUREBUFFERPROC                               gl3wTextureBuffer;
PFNGLTEXTUREBUFFEREXTPROC                            gl3wTextureBufferEXT;
PFNGLTEXTUREBUFFERRANGEPROC                          gl3wTextureBufferRange;
PFNGLTEXTUREBUFFERRANGEEXTPROC                       gl3wTextureBufferRangeEXT;
PFNGLTEXTUREIMAGE1DEXTPROC                           gl3wTextureImage1DEXT;
PFNGLTEXTUREIMAGE2DEXTPROC                           gl3wTextureImage2DEXT;
PFNGLTEXTUREIMAGE3DEXTPROC                           gl3wTextureImage3DEXT;
PFNGLTEXTUREPAGECOMMITMENTEXTPROC                    gl3wTexturePageCommitmentEXT;
PFNGLTEXTUREPARAMETERIIVPROC                         gl3wTextureParameterIiv;
PFNGLTEXTUREPARAMETERIIVEXTPROC                      gl3wTextureParameterIivEXT;
PFNGLTEXTUREPARAMETERIUIVPROC                        gl3wTextureParameterIuiv;
PFNGLTEXTUREPARAMETERIUIVEXTPROC                     gl3wTextureParameterIuivEXT;
PFNGLTEXTUREPARAMETERFPROC                           gl3wTextureParameterf;
PFNGLTEXTUREPARAMETERFEXTPROC                        gl3wTextureParameterfEXT;
PFNGLTEXTUREPARAMETERFVPROC                          gl3wTextureParameterfv;
PFNGLTEXTUREPARAMETERFVEXTPROC                       gl3wTextureParameterfvEXT;
PFNGLTEXTUREPARAMETERIPROC                           gl3wTextureParameteri;
PFNGLTEXTUREPARAMETERIEXTPROC                        gl3wTextureParameteriEXT;
PFNGLTEXTUREPARAMETERIVPROC                          gl3wTextureParameteriv;
PFNGLTEXTUREPARAMETERIVEXTPROC                       gl3wTextureParameterivEXT;
PFNGLTEXTURERENDERBUFFEREXTPROC                      gl3wTextureRenderbufferEXT;
PFNGLTEXTURESTORAGE1DPROC                            gl3wTextureStorage1D;
PFNGLTEXTURESTORAGE1DEXTPROC                         gl3wTextureStorage1DEXT;
PFNGLTEXTURESTORAGE2DPROC                            gl3wTextureStorage2D;
PFNGLTEXTURESTORAGE2DEXTPROC                         gl3wTextureStorage2DEXT;
PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC                 gl3wTextureStorage2DMultisample;
PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC              gl3wTextureStorage2DMultisampleEXT;
PFNGLTEXTURESTORAGE3DPROC                            gl3wTextureStorage3D;
PFNGLTEXTURESTORAGE3DEXTPROC                         gl3wTextureStorage3DEXT;
PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC                 gl3wTextureStorage3DMultisample;
PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC              gl3wTextureStorage3DMultisampleEXT;
PFNGLTEXTURESUBIMAGE1DPROC                           gl3wTextureSubImage1D;
PFNGLTEXTURESUBIMAGE1DEXTPROC                        gl3wTextureSubImage1DEXT;
PFNGLTEXTURESUBIMAGE2DPROC                           gl3wTextureSubImage2D;
PFNGLTEXTURESUBIMAGE2DEXTPROC                        gl3wTextureSubImage2DEXT;
PFNGLTEXTURESUBIMAGE3DPROC                           gl3wTextureSubImage3D;
PFNGLTEXTURESUBIMAGE3DEXTPROC                        gl3wTextureSubImage3DEXT;
PFNGLTEXTUREVIEWPROC                                 gl3wTextureView;
PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC                 gl3wTransformFeedbackBufferBase;
PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC                gl3wTransformFeedbackBufferRange;
PFNGLTRANSFORMFEEDBACKVARYINGSPROC                   gl3wTransformFeedbackVaryings;
PFNGLTRANSFORMPATHNVPROC                             gl3wTransformPathNV;
PFNGLUNIFORM1DPROC                                   gl3wUniform1d;
PFNGLUNIFORM1DVPROC                                  gl3wUniform1dv;
PFNGLUNIFORM1FPROC                                   gl3wUniform1f;
PFNGLUNIFORM1FVPROC                                  gl3wUniform1fv;
PFNGLUNIFORM1IPROC                                   gl3wUniform1i;
PFNGLUNIFORM1I64ARBPROC                              gl3wUniform1i64ARB;
PFNGLUNIFORM1I64NVPROC                               gl3wUniform1i64NV;
PFNGLUNIFORM1I64VARBPROC                             gl3wUniform1i64vARB;
PFNGLUNIFORM1I64VNVPROC                              gl3wUniform1i64vNV;
PFNGLUNIFORM1IVPROC                                  gl3wUniform1iv;
PFNGLUNIFORM1UIPROC                                  gl3wUniform1ui;
PFNGLUNIFORM1UI64ARBPROC                             gl3wUniform1ui64ARB;
PFNGLUNIFORM1UI64NVPROC                              gl3wUniform1ui64NV;
PFNGLUNIFORM1UI64VARBPROC                            gl3wUniform1ui64vARB;
PFNGLUNIFORM1UI64VNVPROC                             gl3wUniform1ui64vNV;
PFNGLUNIFORM1UIVPROC                                 gl3wUniform1uiv;
PFNGLUNIFORM2DPROC                                   gl3wUniform2d;
PFNGLUNIFORM2DVPROC                                  gl3wUniform2dv;
PFNGLUNIFORM2FPROC                                   gl3wUniform2f;
PFNGLUNIFORM2FVPROC                                  gl3wUniform2fv;
PFNGLUNIFORM2IPROC                                   gl3wUniform2i;
PFNGLUNIFORM2I64ARBPROC                              gl3wUniform2i64ARB;
PFNGLUNIFORM2I64NVPROC                               gl3wUniform2i64NV;
PFNGLUNIFORM2I64VARBPROC                             gl3wUniform2i64vARB;
PFNGLUNIFORM2I64VNVPROC                              gl3wUniform2i64vNV;
PFNGLUNIFORM2IVPROC                                  gl3wUniform2iv;
PFNGLUNIFORM2UIPROC                                  gl3wUniform2ui;
PFNGLUNIFORM2UI64ARBPROC                             gl3wUniform2ui64ARB;
PFNGLUNIFORM2UI64NVPROC                              gl3wUniform2ui64NV;
PFNGLUNIFORM2UI64VARBPROC                            gl3wUniform2ui64vARB;
PFNGLUNIFORM2UI64VNVPROC                             gl3wUniform2ui64vNV;
PFNGLUNIFORM2UIVPROC                                 gl3wUniform2uiv;
PFNGLUNIFORM3DPROC                                   gl3wUniform3d;
PFNGLUNIFORM3DVPROC                                  gl3wUniform3dv;
PFNGLUNIFORM3FPROC                                   gl3wUniform3f;
PFNGLUNIFORM3FVPROC                                  gl3wUniform3fv;
PFNGLUNIFORM3IPROC                                   gl3wUniform3i;
PFNGLUNIFORM3I64ARBPROC                              gl3wUniform3i64ARB;
PFNGLUNIFORM3I64NVPROC                               gl3wUniform3i64NV;
PFNGLUNIFORM3I64VARBPROC                             gl3wUniform3i64vARB;
PFNGLUNIFORM3I64VNVPROC                              gl3wUniform3i64vNV;
PFNGLUNIFORM3IVPROC                                  gl3wUniform3iv;
PFNGLUNIFORM3UIPROC                                  gl3wUniform3ui;
PFNGLUNIFORM3UI64ARBPROC                             gl3wUniform3ui64ARB;
PFNGLUNIFORM3UI64NVPROC                              gl3wUniform3ui64NV;
PFNGLUNIFORM3UI64VARBPROC                            gl3wUniform3ui64vARB;
PFNGLUNIFORM3UI64VNVPROC                             gl3wUniform3ui64vNV;
PFNGLUNIFORM3UIVPROC                                 gl3wUniform3uiv;
PFNGLUNIFORM4DPROC                                   gl3wUniform4d;
PFNGLUNIFORM4DVPROC                                  gl3wUniform4dv;
PFNGLUNIFORM4FPROC                                   gl3wUniform4f;
PFNGLUNIFORM4FVPROC                                  gl3wUniform4fv;
PFNGLUNIFORM4IPROC                                   gl3wUniform4i;
PFNGLUNIFORM4I64ARBPROC                              gl3wUniform4i64ARB;
PFNGLUNIFORM4I64NVPROC                               gl3wUniform4i64NV;
PFNGLUNIFORM4I64VARBPROC                             gl3wUniform4i64vARB;
PFNGLUNIFORM4I64VNVPROC                              gl3wUniform4i64vNV;
PFNGLUNIFORM4IVPROC                                  gl3wUniform4iv;
PFNGLUNIFORM4UIPROC                                  gl3wUniform4ui;
PFNGLUNIFORM4UI64ARBPROC                             gl3wUniform4ui64ARB;
PFNGLUNIFORM4UI64NVPROC                              gl3wUniform4ui64NV;
PFNGLUNIFORM4UI64VARBPROC                            gl3wUniform4ui64vARB;
PFNGLUNIFORM4UI64VNVPROC                             gl3wUniform4ui64vNV;
PFNGLUNIFORM4UIVPROC                                 gl3wUniform4uiv;
PFNGLUNIFORMBLOCKBINDINGPROC                         gl3wUniformBlockBinding;
PFNGLUNIFORMHANDLEUI64ARBPROC                        gl3wUniformHandleui64ARB;
PFNGLUNIFORMHANDLEUI64NVPROC                         gl3wUniformHandleui64NV;
PFNGLUNIFORMHANDLEUI64VARBPROC                       gl3wUniformHandleui64vARB;
PFNGLUNIFORMHANDLEUI64VNVPROC                        gl3wUniformHandleui64vNV;
PFNGLUNIFORMMATRIX2DVPROC                            gl3wUniformMatrix2dv;
PFNGLUNIFORMMATRIX2FVPROC                            gl3wUniformMatrix2fv;
PFNGLUNIFORMMATRIX2X3DVPROC                          gl3wUniformMatrix2x3dv;
PFNGLUNIFORMMATRIX2X3FVPROC                          gl3wUniformMatrix2x3fv;
PFNGLUNIFORMMATRIX2X4DVPROC                          gl3wUniformMatrix2x4dv;
PFNGLUNIFORMMATRIX2X4FVPROC                          gl3wUniformMatrix2x4fv;
PFNGLUNIFORMMATRIX3DVPROC                            gl3wUniformMatrix3dv;
PFNGLUNIFORMMATRIX3FVPROC                            gl3wUniformMatrix3fv;
PFNGLUNIFORMMATRIX3X2DVPROC                          gl3wUniformMatrix3x2dv;
PFNGLUNIFORMMATRIX3X2FVPROC                          gl3wUniformMatrix3x2fv;
PFNGLUNIFORMMATRIX3X4DVPROC                          gl3wUniformMatrix3x4dv;
PFNGLUNIFORMMATRIX3X4FVPROC                          gl3wUniformMatrix3x4fv;
PFNGLUNIFORMMATRIX4DVPROC                            gl3wUniformMatrix4dv;
PFNGLUNIFORMMATRIX4FVPROC                            gl3wUniformMatrix4fv;
PFNGLUNIFORMMATRIX4X2DVPROC                          gl3wUniformMatrix4x2dv;
PFNGLUNIFORMMATRIX4X2FVPROC                          gl3wUniformMatrix4x2fv;
PFNGLUNIFORMMATRIX4X3DVPROC                          gl3wUniformMatrix4x3dv;
PFNGLUNIFORMMATRIX4X3FVPROC                          gl3wUniformMatrix4x3fv;
PFNGLUNIFORMSUBROUTINESUIVPROC                       gl3wUniformSubroutinesuiv;
PFNGLUNIFORMUI64NVPROC                               gl3wUniformui64NV;
PFNGLUNIFORMUI64VNVPROC                              gl3wUniformui64vNV;
PFNGLUNMAPBUFFERPROC                                 gl3wUnmapBuffer;
PFNGLUNMAPNAMEDBUFFERPROC                            gl3wUnmapNamedBuffer;
PFNGLUNMAPNAMEDBUFFEREXTPROC                         gl3wUnmapNamedBufferEXT;
PFNGLUSEPROGRAMPROC                                  gl3wUseProgram;
PFNGLUSEPROGRAMSTAGESPROC                            gl3wUseProgramStages;
PFNGLUSESHADERPROGRAMEXTPROC                         gl3wUseShaderProgramEXT;
PFNGLVALIDATEPROGRAMPROC                             gl3wValidateProgram;
PFNGLVALIDATEPROGRAMPIPELINEPROC                     gl3wValidateProgramPipeline;
PFNGLVERTEXARRAYATTRIBBINDINGPROC                    gl3wVertexArrayAttribBinding;
PFNGLVERTEXARRAYATTRIBFORMATPROC                     gl3wVertexArrayAttribFormat;
PFNGLVERTEXARRAYATTRIBIFORMATPROC                    gl3wVertexArrayAttribIFormat;
PFNGLVERTEXARRAYATTRIBLFORMATPROC                    gl3wVertexArrayAttribLFormat;
PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC              gl3wVertexArrayBindVertexBufferEXT;
PFNGLVERTEXARRAYBINDINGDIVISORPROC                   gl3wVertexArrayBindingDivisor;
PFNGLVERTEXARRAYCOLOROFFSETEXTPROC                   gl3wVertexArrayColorOffsetEXT;
PFNGLVERTEXARRAYEDGEFLAGOFFSETEXTPROC                gl3wVertexArrayEdgeFlagOffsetEXT;
PFNGLVERTEXARRAYELEMENTBUFFERPROC                    gl3wVertexArrayElementBuffer;
PFNGLVERTEXARRAYFOGCOORDOFFSETEXTPROC                gl3wVertexArrayFogCoordOffsetEXT;
PFNGLVERTEXARRAYINDEXOFFSETEXTPROC                   gl3wVertexArrayIndexOffsetEXT;
PFNGLVERTEXARRAYMULTITEXCOORDOFFSETEXTPROC           gl3wVertexArrayMultiTexCoordOffsetEXT;
PFNGLVERTEXARRAYNORMALOFFSETEXTPROC                  gl3wVertexArrayNormalOffsetEXT;
PFNGLVERTEXARRAYSECONDARYCOLOROFFSETEXTPROC          gl3wVertexArraySecondaryColorOffsetEXT;
PFNGLVERTEXARRAYTEXCOORDOFFSETEXTPROC                gl3wVertexArrayTexCoordOffsetEXT;
PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC           gl3wVertexArrayVertexAttribBindingEXT;
PFNGLVERTEXARRAYVERTEXATTRIBDIVISOREXTPROC           gl3wVertexArrayVertexAttribDivisorEXT;
PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC            gl3wVertexArrayVertexAttribFormatEXT;
PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC           gl3wVertexArrayVertexAttribIFormatEXT;
PFNGLVERTEXARRAYVERTEXATTRIBIOFFSETEXTPROC           gl3wVertexArrayVertexAttribIOffsetEXT;
PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC           gl3wVertexArrayVertexAttribLFormatEXT;
PFNGLVERTEXARRAYVERTEXATTRIBLOFFSETEXTPROC           gl3wVertexArrayVertexAttribLOffsetEXT;
PFNGLVERTEXARRAYVERTEXATTRIBOFFSETEXTPROC            gl3wVertexArrayVertexAttribOffsetEXT;
PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC          gl3wVertexArrayVertexBindingDivisorEXT;
PFNGLVERTEXARRAYVERTEXBUFFERPROC                     gl3wVertexArrayVertexBuffer;
PFNGLVERTEXARRAYVERTEXBUFFERSPROC                    gl3wVertexArrayVertexBuffers;
PFNGLVERTEXARRAYVERTEXOFFSETEXTPROC                  gl3wVertexArrayVertexOffsetEXT;
PFNGLVERTEXATTRIB1DPROC                              gl3wVertexAttrib1d;
PFNGLVERTEXATTRIB1DVPROC                             gl3wVertexAttrib1dv;
PFNGLVERTEXATTRIB1FPROC                              gl3wVertexAttrib1f;
PFNGLVERTEXATTRIB1FVPROC                             gl3wVertexAttrib1fv;
PFNGLVERTEXATTRIB1SPROC                              gl3wVertexAttrib1s;
PFNGLVERTEXATTRIB1SVPROC                             gl3wVertexAttrib1sv;
PFNGLVERTEXATTRIB2DPROC                              gl3wVertexAttrib2d;
PFNGLVERTEXATTRIB2DVPROC                             gl3wVertexAttrib2dv;
PFNGLVERTEXATTRIB2FPROC                              gl3wVertexAttrib2f;
PFNGLVERTEXATTRIB2FVPROC                             gl3wVertexAttrib2fv;
PFNGLVERTEXATTRIB2SPROC                              gl3wVertexAttrib2s;
PFNGLVERTEXATTRIB2SVPROC                             gl3wVertexAttrib2sv;
PFNGLVERTEXATTRIB3DPROC                              gl3wVertexAttrib3d;
PFNGLVERTEXATTRIB3DVPROC                             gl3wVertexAttrib3dv;
PFNGLVERTEXATTRIB3FPROC                              gl3wVertexAttrib3f;
PFNGLVERTEXATTRIB3FVPROC                             gl3wVertexAttrib3fv;
PFNGLVERTEXATTRIB3SPROC                              gl3wVertexAttrib3s;
PFNGLVERTEXATTRIB3SVPROC                             gl3wVertexAttrib3sv;
PFNGLVERTEXATTRIB4NBVPROC                            gl3wVertexAttrib4Nbv;
PFNGLVERTEXATTRIB4NIVPROC                            gl3wVertexAttrib4Niv;
PFNGLVERTEXATTRIB4NSVPROC                            gl3wVertexAttrib4Nsv;
PFNGLVERTEXATTRIB4NUBPROC                            gl3wVertexAttrib4Nub;
PFNGLVERTEXATTRIB4NUBVPROC                           gl3wVertexAttrib4Nubv;
PFNGLVERTEXATTRIB4NUIVPROC                           gl3wVertexAttrib4Nuiv;
PFNGLVERTEXATTRIB4NUSVPROC                           gl3wVertexAttrib4Nusv;
PFNGLVERTEXATTRIB4BVPROC                             gl3wVertexAttrib4bv;
PFNGLVERTEXATTRIB4DPROC                              gl3wVertexAttrib4d;
PFNGLVERTEXATTRIB4DVPROC                             gl3wVertexAttrib4dv;
PFNGLVERTEXATTRIB4FPROC                              gl3wVertexAttrib4f;
PFNGLVERTEXATTRIB4FVPROC                             gl3wVertexAttrib4fv;
PFNGLVERTEXATTRIB4IVPROC                             gl3wVertexAttrib4iv;
PFNGLVERTEXATTRIB4SPROC                              gl3wVertexAttrib4s;
PFNGLVERTEXATTRIB4SVPROC                             gl3wVertexAttrib4sv;
PFNGLVERTEXATTRIB4UBVPROC                            gl3wVertexAttrib4ubv;
PFNGLVERTEXATTRIB4UIVPROC                            gl3wVertexAttrib4uiv;
PFNGLVERTEXATTRIB4USVPROC                            gl3wVertexAttrib4usv;
PFNGLVERTEXATTRIBBINDINGPROC                         gl3wVertexAttribBinding;
PFNGLVERTEXATTRIBDIVISORPROC                         gl3wVertexAttribDivisor;
PFNGLVERTEXATTRIBDIVISORARBPROC                      gl3wVertexAttribDivisorARB;
PFNGLVERTEXATTRIBFORMATPROC                          gl3wVertexAttribFormat;
PFNGLVERTEXATTRIBFORMATNVPROC                        gl3wVertexAttribFormatNV;
PFNGLVERTEXATTRIBI1IPROC                             gl3wVertexAttribI1i;
PFNGLVERTEXATTRIBI1IVPROC                            gl3wVertexAttribI1iv;
PFNGLVERTEXATTRIBI1UIPROC                            gl3wVertexAttribI1ui;
PFNGLVERTEXATTRIBI1UIVPROC                           gl3wVertexAttribI1uiv;
PFNGLVERTEXATTRIBI2IPROC                             gl3wVertexAttribI2i;
PFNGLVERTEXATTRIBI2IVPROC                            gl3wVertexAttribI2iv;
PFNGLVERTEXATTRIBI2UIPROC                            gl3wVertexAttribI2ui;
PFNGLVERTEXATTRIBI2UIVPROC                           gl3wVertexAttribI2uiv;
PFNGLVERTEXATTRIBI3IPROC                             gl3wVertexAttribI3i;
PFNGLVERTEXATTRIBI3IVPROC                            gl3wVertexAttribI3iv;
PFNGLVERTEXATTRIBI3UIPROC                            gl3wVertexAttribI3ui;
PFNGLVERTEXATTRIBI3UIVPROC                           gl3wVertexAttribI3uiv;
PFNGLVERTEXATTRIBI4BVPROC                            gl3wVertexAttribI4bv;
PFNGLVERTEXATTRIBI4IPROC                             gl3wVertexAttribI4i;
PFNGLVERTEXATTRIBI4IVPROC                            gl3wVertexAttribI4iv;
PFNGLVERTEXATTRIBI4SVPROC                            gl3wVertexAttribI4sv;
PFNGLVERTEXATTRIBI4UBVPROC                           gl3wVertexAttribI4ubv;
PFNGLVERTEXATTRIBI4UIPROC                            gl3wVertexAttribI4ui;
PFNGLVERTEXATTRIBI4UIVPROC                           gl3wVertexAttribI4uiv;
PFNGLVERTEXATTRIBI4USVPROC                           gl3wVertexAttribI4usv;
PFNGLVERTEXATTRIBIFORMATPROC                         gl3wVertexAttribIFormat;
PFNGLVERTEXATTRIBIFORMATNVPROC                       gl3wVertexAttribIFormatNV;
PFNGLVERTEXATTRIBIPOINTERPROC                        gl3wVertexAttribIPointer;
PFNGLVERTEXATTRIBL1DPROC                             gl3wVertexAttribL1d;
PFNGLVERTEXATTRIBL1DVPROC                            gl3wVertexAttribL1dv;
PFNGLVERTEXATTRIBL1I64NVPROC                         gl3wVertexAttribL1i64NV;
PFNGLVERTEXATTRIBL1I64VNVPROC                        gl3wVertexAttribL1i64vNV;
PFNGLVERTEXATTRIBL1UI64ARBPROC                       gl3wVertexAttribL1ui64ARB;
PFNGLVERTEXATTRIBL1UI64NVPROC                        gl3wVertexAttribL1ui64NV;
PFNGLVERTEXATTRIBL1UI64VARBPROC                      gl3wVertexAttribL1ui64vARB;
PFNGLVERTEXATTRIBL1UI64VNVPROC                       gl3wVertexAttribL1ui64vNV;
PFNGLVERTEXATTRIBL2DPROC                             gl3wVertexAttribL2d;
PFNGLVERTEXATTRIBL2DVPROC                            gl3wVertexAttribL2dv;
PFNGLVERTEXATTRIBL2I64NVPROC                         gl3wVertexAttribL2i64NV;
PFNGLVERTEXATTRIBL2I64VNVPROC                        gl3wVertexAttribL2i64vNV;
PFNGLVERTEXATTRIBL2UI64NVPROC                        gl3wVertexAttribL2ui64NV;
PFNGLVERTEXATTRIBL2UI64VNVPROC                       gl3wVertexAttribL2ui64vNV;
PFNGLVERTEXATTRIBL3DPROC                             gl3wVertexAttribL3d;
PFNGLVERTEXATTRIBL3DVPROC                            gl3wVertexAttribL3dv;
PFNGLVERTEXATTRIBL3I64NVPROC                         gl3wVertexAttribL3i64NV;
PFNGLVERTEXATTRIBL3I64VNVPROC                        gl3wVertexAttribL3i64vNV;
PFNGLVERTEXATTRIBL3UI64NVPROC                        gl3wVertexAttribL3ui64NV;
PFNGLVERTEXATTRIBL3UI64VNVPROC                       gl3wVertexAttribL3ui64vNV;
PFNGLVERTEXATTRIBL4DPROC                             gl3wVertexAttribL4d;
PFNGLVERTEXATTRIBL4DVPROC                            gl3wVertexAttribL4dv;
PFNGLVERTEXATTRIBL4I64NVPROC                         gl3wVertexAttribL4i64NV;
PFNGLVERTEXATTRIBL4I64VNVPROC                        gl3wVertexAttribL4i64vNV;
PFNGLVERTEXATTRIBL4UI64NVPROC                        gl3wVertexAttribL4ui64NV;
PFNGLVERTEXATTRIBL4UI64VNVPROC                       gl3wVertexAttribL4ui64vNV;
PFNGLVERTEXATTRIBLFORMATPROC                         gl3wVertexAttribLFormat;
PFNGLVERTEXATTRIBLFORMATNVPROC                       gl3wVertexAttribLFormatNV;
PFNGLVERTEXATTRIBLPOINTERPROC                        gl3wVertexAttribLPointer;
PFNGLVERTEXATTRIBP1UIPROC                            gl3wVertexAttribP1ui;
PFNGLVERTEXATTRIBP1UIVPROC                           gl3wVertexAttribP1uiv;
PFNGLVERTEXATTRIBP2UIPROC                            gl3wVertexAttribP2ui;
PFNGLVERTEXATTRIBP2UIVPROC                           gl3wVertexAttribP2uiv;
PFNGLVERTEXATTRIBP3UIPROC                            gl3wVertexAttribP3ui;
PFNGLVERTEXATTRIBP3UIVPROC                           gl3wVertexAttribP3uiv;
PFNGLVERTEXATTRIBP4UIPROC                            gl3wVertexAttribP4ui;
PFNGLVERTEXATTRIBP4UIVPROC                           gl3wVertexAttribP4uiv;
PFNGLVERTEXATTRIBPOINTERPROC                         gl3wVertexAttribPointer;
PFNGLVERTEXBINDINGDIVISORPROC                        gl3wVertexBindingDivisor;
PFNGLVERTEXFORMATNVPROC                              gl3wVertexFormatNV;
PFNGLVIEWPORTPROC                                    gl3wViewport;
PFNGLVIEWPORTARRAYVPROC                              gl3wViewportArrayv;
PFNGLVIEWPORTINDEXEDFPROC                            gl3wViewportIndexedf;
PFNGLVIEWPORTINDEXEDFVPROC                           gl3wViewportIndexedfv;
PFNGLVIEWPORTPOSITIONWSCALENVPROC                    gl3wViewportPositionWScaleNV;
PFNGLVIEWPORTSWIZZLENVPROC                           gl3wViewportSwizzleNV;
PFNGLWAITSYNCPROC                                    gl3wWaitSync;
PFNGLWAITVKSEMAPHORENVPROC                           gl3wWaitVkSemaphoreNV;
PFNGLWEIGHTPATHSNVPROC                               gl3wWeightPathsNV;
PFNGLWINDOWRECTANGLESEXTPROC                         gl3wWindowRectanglesEXT;

static void load_procs(GL3WGetProcAddressProc proc)
{
	gl3wActiveProgramEXT = (PFNGLACTIVEPROGRAMEXTPROC)proc("glActiveProgramEXT");
	gl3wActiveShaderProgram = (PFNGLACTIVESHADERPROGRAMPROC)proc("glActiveShaderProgram");
	gl3wActiveTexture = (PFNGLACTIVETEXTUREPROC)proc("glActiveTexture");
	gl3wApplyFramebufferAttachmentCMAAINTEL = (PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC)proc("glApplyFramebufferAttachmentCMAAINTEL");
	gl3wAttachShader = (PFNGLATTACHSHADERPROC)proc("glAttachShader");
	gl3wBeginConditionalRender = (PFNGLBEGINCONDITIONALRENDERPROC)proc("glBeginConditionalRender");
	gl3wBeginConditionalRenderNV = (PFNGLBEGINCONDITIONALRENDERNVPROC)proc("glBeginConditionalRenderNV");
	gl3wBeginPerfMonitorAMD = (PFNGLBEGINPERFMONITORAMDPROC)proc("glBeginPerfMonitorAMD");
	gl3wBeginPerfQueryINTEL = (PFNGLBEGINPERFQUERYINTELPROC)proc("glBeginPerfQueryINTEL");
	gl3wBeginQuery = (PFNGLBEGINQUERYPROC)proc("glBeginQuery");
	gl3wBeginQueryIndexed = (PFNGLBEGINQUERYINDEXEDPROC)proc("glBeginQueryIndexed");
	gl3wBeginTransformFeedback = (PFNGLBEGINTRANSFORMFEEDBACKPROC)proc("glBeginTransformFeedback");
	gl3wBindAttribLocation = (PFNGLBINDATTRIBLOCATIONPROC)proc("glBindAttribLocation");
	gl3wBindBuffer = (PFNGLBINDBUFFERPROC)proc("glBindBuffer");
	gl3wBindBufferBase = (PFNGLBINDBUFFERBASEPROC)proc("glBindBufferBase");
	gl3wBindBufferRange = (PFNGLBINDBUFFERRANGEPROC)proc("glBindBufferRange");
	gl3wBindBuffersBase = (PFNGLBINDBUFFERSBASEPROC)proc("glBindBuffersBase");
	gl3wBindBuffersRange = (PFNGLBINDBUFFERSRANGEPROC)proc("glBindBuffersRange");
	gl3wBindFragDataLocation = (PFNGLBINDFRAGDATALOCATIONPROC)proc("glBindFragDataLocation");
	gl3wBindFragDataLocationIndexed = (PFNGLBINDFRAGDATALOCATIONINDEXEDPROC)proc("glBindFragDataLocationIndexed");
	gl3wBindFramebuffer = (PFNGLBINDFRAMEBUFFERPROC)proc("glBindFramebuffer");
	gl3wBindImageTexture = (PFNGLBINDIMAGETEXTUREPROC)proc("glBindImageTexture");
	gl3wBindImageTextures = (PFNGLBINDIMAGETEXTURESPROC)proc("glBindImageTextures");
	gl3wBindMultiTextureEXT = (PFNGLBINDMULTITEXTUREEXTPROC)proc("glBindMultiTextureEXT");
	gl3wBindProgramPipeline = (PFNGLBINDPROGRAMPIPELINEPROC)proc("glBindProgramPipeline");
	gl3wBindRenderbuffer = (PFNGLBINDRENDERBUFFERPROC)proc("glBindRenderbuffer");
	gl3wBindSampler = (PFNGLBINDSAMPLERPROC)proc("glBindSampler");
	gl3wBindSamplers = (PFNGLBINDSAMPLERSPROC)proc("glBindSamplers");
	gl3wBindTexture = (PFNGLBINDTEXTUREPROC)proc("glBindTexture");
	gl3wBindTextureUnit = (PFNGLBINDTEXTUREUNITPROC)proc("glBindTextureUnit");
	gl3wBindTextures = (PFNGLBINDTEXTURESPROC)proc("glBindTextures");
	gl3wBindTransformFeedback = (PFNGLBINDTRANSFORMFEEDBACKPROC)proc("glBindTransformFeedback");
	gl3wBindVertexArray = (PFNGLBINDVERTEXARRAYPROC)proc("glBindVertexArray");
	gl3wBindVertexBuffer = (PFNGLBINDVERTEXBUFFERPROC)proc("glBindVertexBuffer");
	gl3wBindVertexBuffers = (PFNGLBINDVERTEXBUFFERSPROC)proc("glBindVertexBuffers");
	gl3wBlendBarrierKHR = (PFNGLBLENDBARRIERKHRPROC)proc("glBlendBarrierKHR");
	gl3wBlendBarrierNV = (PFNGLBLENDBARRIERNVPROC)proc("glBlendBarrierNV");
	gl3wBlendColor = (PFNGLBLENDCOLORPROC)proc("glBlendColor");
	gl3wBlendEquation = (PFNGLBLENDEQUATIONPROC)proc("glBlendEquation");
	gl3wBlendEquationSeparate = (PFNGLBLENDEQUATIONSEPARATEPROC)proc("glBlendEquationSeparate");
	gl3wBlendEquationSeparatei = (PFNGLBLENDEQUATIONSEPARATEIPROC)proc("glBlendEquationSeparatei");
	gl3wBlendEquationSeparateiARB = (PFNGLBLENDEQUATIONSEPARATEIARBPROC)proc("glBlendEquationSeparateiARB");
	gl3wBlendEquationi = (PFNGLBLENDEQUATIONIPROC)proc("glBlendEquationi");
	gl3wBlendEquationiARB = (PFNGLBLENDEQUATIONIARBPROC)proc("glBlendEquationiARB");
	gl3wBlendFunc = (PFNGLBLENDFUNCPROC)proc("glBlendFunc");
	gl3wBlendFuncSeparate = (PFNGLBLENDFUNCSEPARATEPROC)proc("glBlendFuncSeparate");
	gl3wBlendFuncSeparatei = (PFNGLBLENDFUNCSEPARATEIPROC)proc("glBlendFuncSeparatei");
	gl3wBlendFuncSeparateiARB = (PFNGLBLENDFUNCSEPARATEIARBPROC)proc("glBlendFuncSeparateiARB");
	gl3wBlendFunci = (PFNGLBLENDFUNCIPROC)proc("glBlendFunci");
	gl3wBlendFunciARB = (PFNGLBLENDFUNCIARBPROC)proc("glBlendFunciARB");
	gl3wBlendParameteriNV = (PFNGLBLENDPARAMETERINVPROC)proc("glBlendParameteriNV");
	gl3wBlitFramebuffer = (PFNGLBLITFRAMEBUFFERPROC)proc("glBlitFramebuffer");
	gl3wBlitNamedFramebuffer = (PFNGLBLITNAMEDFRAMEBUFFERPROC)proc("glBlitNamedFramebuffer");
	gl3wBufferAddressRangeNV = (PFNGLBUFFERADDRESSRANGENVPROC)proc("glBufferAddressRangeNV");
	gl3wBufferData = (PFNGLBUFFERDATAPROC)proc("glBufferData");
	gl3wBufferPageCommitmentARB = (PFNGLBUFFERPAGECOMMITMENTARBPROC)proc("glBufferPageCommitmentARB");
	gl3wBufferStorage = (PFNGLBUFFERSTORAGEPROC)proc("glBufferStorage");
	gl3wBufferSubData = (PFNGLBUFFERSUBDATAPROC)proc("glBufferSubData");
	gl3wCallCommandListNV = (PFNGLCALLCOMMANDLISTNVPROC)proc("glCallCommandListNV");
	gl3wCheckFramebufferStatus = (PFNGLCHECKFRAMEBUFFERSTATUSPROC)proc("glCheckFramebufferStatus");
	gl3wCheckNamedFramebufferStatus = (PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC)proc("glCheckNamedFramebufferStatus");
	gl3wCheckNamedFramebufferStatusEXT = (PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC)proc("glCheckNamedFramebufferStatusEXT");
	gl3wClampColor = (PFNGLCLAMPCOLORPROC)proc("glClampColor");
	gl3wClear = (PFNGLCLEARPROC)proc("glClear");
	gl3wClearBufferData = (PFNGLCLEARBUFFERDATAPROC)proc("glClearBufferData");
	gl3wClearBufferSubData = (PFNGLCLEARBUFFERSUBDATAPROC)proc("glClearBufferSubData");
	gl3wClearBufferfi = (PFNGLCLEARBUFFERFIPROC)proc("glClearBufferfi");
	gl3wClearBufferfv = (PFNGLCLEARBUFFERFVPROC)proc("glClearBufferfv");
	gl3wClearBufferiv = (PFNGLCLEARBUFFERIVPROC)proc("glClearBufferiv");
	gl3wClearBufferuiv = (PFNGLCLEARBUFFERUIVPROC)proc("glClearBufferuiv");
	gl3wClearColor = (PFNGLCLEARCOLORPROC)proc("glClearColor");
	gl3wClearDepth = (PFNGLCLEARDEPTHPROC)proc("glClearDepth");
	gl3wClearDepthf = (PFNGLCLEARDEPTHFPROC)proc("glClearDepthf");
	gl3wClearNamedBufferData = (PFNGLCLEARNAMEDBUFFERDATAPROC)proc("glClearNamedBufferData");
	gl3wClearNamedBufferDataEXT = (PFNGLCLEARNAMEDBUFFERDATAEXTPROC)proc("glClearNamedBufferDataEXT");
	gl3wClearNamedBufferSubData = (PFNGLCLEARNAMEDBUFFERSUBDATAPROC)proc("glClearNamedBufferSubData");
	gl3wClearNamedBufferSubDataEXT = (PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC)proc("glClearNamedBufferSubDataEXT");
	gl3wClearNamedFramebufferfi = (PFNGLCLEARNAMEDFRAMEBUFFERFIPROC)proc("glClearNamedFramebufferfi");
	gl3wClearNamedFramebufferfv = (PFNGLCLEARNAMEDFRAMEBUFFERFVPROC)proc("glClearNamedFramebufferfv");
	gl3wClearNamedFramebufferiv = (PFNGLCLEARNAMEDFRAMEBUFFERIVPROC)proc("glClearNamedFramebufferiv");
	gl3wClearNamedFramebufferuiv = (PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC)proc("glClearNamedFramebufferuiv");
	gl3wClearStencil = (PFNGLCLEARSTENCILPROC)proc("glClearStencil");
	gl3wClearTexImage = (PFNGLCLEARTEXIMAGEPROC)proc("glClearTexImage");
	gl3wClearTexSubImage = (PFNGLCLEARTEXSUBIMAGEPROC)proc("glClearTexSubImage");
	gl3wClientAttribDefaultEXT = (PFNGLCLIENTATTRIBDEFAULTEXTPROC)proc("glClientAttribDefaultEXT");
	gl3wClientWaitSync = (PFNGLCLIENTWAITSYNCPROC)proc("glClientWaitSync");
	gl3wClipControl = (PFNGLCLIPCONTROLPROC)proc("glClipControl");
	gl3wColorFormatNV = (PFNGLCOLORFORMATNVPROC)proc("glColorFormatNV");
	gl3wColorMask = (PFNGLCOLORMASKPROC)proc("glColorMask");
	gl3wColorMaski = (PFNGLCOLORMASKIPROC)proc("glColorMaski");
	gl3wCommandListSegmentsNV = (PFNGLCOMMANDLISTSEGMENTSNVPROC)proc("glCommandListSegmentsNV");
	gl3wCompileCommandListNV = (PFNGLCOMPILECOMMANDLISTNVPROC)proc("glCompileCommandListNV");
	gl3wCompileShader = (PFNGLCOMPILESHADERPROC)proc("glCompileShader");
	gl3wCompileShaderIncludeARB = (PFNGLCOMPILESHADERINCLUDEARBPROC)proc("glCompileShaderIncludeARB");
	gl3wCompressedMultiTexImage1DEXT = (PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC)proc("glCompressedMultiTexImage1DEXT");
	gl3wCompressedMultiTexImage2DEXT = (PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC)proc("glCompressedMultiTexImage2DEXT");
	gl3wCompressedMultiTexImage3DEXT = (PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC)proc("glCompressedMultiTexImage3DEXT");
	gl3wCompressedMultiTexSubImage1DEXT = (PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC)proc("glCompressedMultiTexSubImage1DEXT");
	gl3wCompressedMultiTexSubImage2DEXT = (PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC)proc("glCompressedMultiTexSubImage2DEXT");
	gl3wCompressedMultiTexSubImage3DEXT = (PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC)proc("glCompressedMultiTexSubImage3DEXT");
	gl3wCompressedTexImage1D = (PFNGLCOMPRESSEDTEXIMAGE1DPROC)proc("glCompressedTexImage1D");
	gl3wCompressedTexImage2D = (PFNGLCOMPRESSEDTEXIMAGE2DPROC)proc("glCompressedTexImage2D");
	gl3wCompressedTexImage3D = (PFNGLCOMPRESSEDTEXIMAGE3DPROC)proc("glCompressedTexImage3D");
	gl3wCompressedTexSubImage1D = (PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC)proc("glCompressedTexSubImage1D");
	gl3wCompressedTexSubImage2D = (PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC)proc("glCompressedTexSubImage2D");
	gl3wCompressedTexSubImage3D = (PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC)proc("glCompressedTexSubImage3D");
	gl3wCompressedTextureImage1DEXT = (PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC)proc("glCompressedTextureImage1DEXT");
	gl3wCompressedTextureImage2DEXT = (PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC)proc("glCompressedTextureImage2DEXT");
	gl3wCompressedTextureImage3DEXT = (PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC)proc("glCompressedTextureImage3DEXT");
	gl3wCompressedTextureSubImage1D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC)proc("glCompressedTextureSubImage1D");
	gl3wCompressedTextureSubImage1DEXT = (PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC)proc("glCompressedTextureSubImage1DEXT");
	gl3wCompressedTextureSubImage2D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC)proc("glCompressedTextureSubImage2D");
	gl3wCompressedTextureSubImage2DEXT = (PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC)proc("glCompressedTextureSubImage2DEXT");
	gl3wCompressedTextureSubImage3D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC)proc("glCompressedTextureSubImage3D");
	gl3wCompressedTextureSubImage3DEXT = (PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC)proc("glCompressedTextureSubImage3DEXT");
	gl3wConservativeRasterParameterfNV = (PFNGLCONSERVATIVERASTERPARAMETERFNVPROC)proc("glConservativeRasterParameterfNV");
	gl3wConservativeRasterParameteriNV = (PFNGLCONSERVATIVERASTERPARAMETERINVPROC)proc("glConservativeRasterParameteriNV");
	gl3wCopyBufferSubData = (PFNGLCOPYBUFFERSUBDATAPROC)proc("glCopyBufferSubData");
	gl3wCopyImageSubData = (PFNGLCOPYIMAGESUBDATAPROC)proc("glCopyImageSubData");
	gl3wCopyMultiTexImage1DEXT = (PFNGLCOPYMULTITEXIMAGE1DEXTPROC)proc("glCopyMultiTexImage1DEXT");
	gl3wCopyMultiTexImage2DEXT = (PFNGLCOPYMULTITEXIMAGE2DEXTPROC)proc("glCopyMultiTexImage2DEXT");
	gl3wCopyMultiTexSubImage1DEXT = (PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC)proc("glCopyMultiTexSubImage1DEXT");
	gl3wCopyMultiTexSubImage2DEXT = (PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC)proc("glCopyMultiTexSubImage2DEXT");
	gl3wCopyMultiTexSubImage3DEXT = (PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC)proc("glCopyMultiTexSubImage3DEXT");
	gl3wCopyNamedBufferSubData = (PFNGLCOPYNAMEDBUFFERSUBDATAPROC)proc("glCopyNamedBufferSubData");
	gl3wCopyPathNV = (PFNGLCOPYPATHNVPROC)proc("glCopyPathNV");
	gl3wCopyTexImage1D = (PFNGLCOPYTEXIMAGE1DPROC)proc("glCopyTexImage1D");
	gl3wCopyTexImage2D = (PFNGLCOPYTEXIMAGE2DPROC)proc("glCopyTexImage2D");
	gl3wCopyTexSubImage1D = (PFNGLCOPYTEXSUBIMAGE1DPROC)proc("glCopyTexSubImage1D");
	gl3wCopyTexSubImage2D = (PFNGLCOPYTEXSUBIMAGE2DPROC)proc("glCopyTexSubImage2D");
	gl3wCopyTexSubImage3D = (PFNGLCOPYTEXSUBIMAGE3DPROC)proc("glCopyTexSubImage3D");
	gl3wCopyTextureImage1DEXT = (PFNGLCOPYTEXTUREIMAGE1DEXTPROC)proc("glCopyTextureImage1DEXT");
	gl3wCopyTextureImage2DEXT = (PFNGLCOPYTEXTUREIMAGE2DEXTPROC)proc("glCopyTextureImage2DEXT");
	gl3wCopyTextureSubImage1D = (PFNGLCOPYTEXTURESUBIMAGE1DPROC)proc("glCopyTextureSubImage1D");
	gl3wCopyTextureSubImage1DEXT = (PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC)proc("glCopyTextureSubImage1DEXT");
	gl3wCopyTextureSubImage2D = (PFNGLCOPYTEXTURESUBIMAGE2DPROC)proc("glCopyTextureSubImage2D");
	gl3wCopyTextureSubImage2DEXT = (PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC)proc("glCopyTextureSubImage2DEXT");
	gl3wCopyTextureSubImage3D = (PFNGLCOPYTEXTURESUBIMAGE3DPROC)proc("glCopyTextureSubImage3D");
	gl3wCopyTextureSubImage3DEXT = (PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC)proc("glCopyTextureSubImage3DEXT");
	gl3wCoverFillPathInstancedNV = (PFNGLCOVERFILLPATHINSTANCEDNVPROC)proc("glCoverFillPathInstancedNV");
	gl3wCoverFillPathNV = (PFNGLCOVERFILLPATHNVPROC)proc("glCoverFillPathNV");
	gl3wCoverStrokePathInstancedNV = (PFNGLCOVERSTROKEPATHINSTANCEDNVPROC)proc("glCoverStrokePathInstancedNV");
	gl3wCoverStrokePathNV = (PFNGLCOVERSTROKEPATHNVPROC)proc("glCoverStrokePathNV");
	gl3wCoverageModulationNV = (PFNGLCOVERAGEMODULATIONNVPROC)proc("glCoverageModulationNV");
	gl3wCoverageModulationTableNV = (PFNGLCOVERAGEMODULATIONTABLENVPROC)proc("glCoverageModulationTableNV");
	gl3wCreateBuffers = (PFNGLCREATEBUFFERSPROC)proc("glCreateBuffers");
	gl3wCreateCommandListsNV = (PFNGLCREATECOMMANDLISTSNVPROC)proc("glCreateCommandListsNV");
	gl3wCreateFramebuffers = (PFNGLCREATEFRAMEBUFFERSPROC)proc("glCreateFramebuffers");
	gl3wCreatePerfQueryINTEL = (PFNGLCREATEPERFQUERYINTELPROC)proc("glCreatePerfQueryINTEL");
	gl3wCreateProgram = (PFNGLCREATEPROGRAMPROC)proc("glCreateProgram");
	gl3wCreateProgramPipelines = (PFNGLCREATEPROGRAMPIPELINESPROC)proc("glCreateProgramPipelines");
	gl3wCreateQueries = (PFNGLCREATEQUERIESPROC)proc("glCreateQueries");
	gl3wCreateRenderbuffers = (PFNGLCREATERENDERBUFFERSPROC)proc("glCreateRenderbuffers");
	gl3wCreateSamplers = (PFNGLCREATESAMPLERSPROC)proc("glCreateSamplers");
	gl3wCreateShader = (PFNGLCREATESHADERPROC)proc("glCreateShader");
	gl3wCreateShaderProgramEXT = (PFNGLCREATESHADERPROGRAMEXTPROC)proc("glCreateShaderProgramEXT");
	gl3wCreateShaderProgramv = (PFNGLCREATESHADERPROGRAMVPROC)proc("glCreateShaderProgramv");
	gl3wCreateStatesNV = (PFNGLCREATESTATESNVPROC)proc("glCreateStatesNV");
	gl3wCreateSyncFromCLeventARB = (PFNGLCREATESYNCFROMCLEVENTARBPROC)proc("glCreateSyncFromCLeventARB");
	gl3wCreateTextures = (PFNGLCREATETEXTURESPROC)proc("glCreateTextures");
	gl3wCreateTransformFeedbacks = (PFNGLCREATETRANSFORMFEEDBACKSPROC)proc("glCreateTransformFeedbacks");
	gl3wCreateVertexArrays = (PFNGLCREATEVERTEXARRAYSPROC)proc("glCreateVertexArrays");
	gl3wCullFace = (PFNGLCULLFACEPROC)proc("glCullFace");
	gl3wDebugMessageCallback = (PFNGLDEBUGMESSAGECALLBACKPROC)proc("glDebugMessageCallback");
	gl3wDebugMessageCallbackARB = (PFNGLDEBUGMESSAGECALLBACKARBPROC)proc("glDebugMessageCallbackARB");
	gl3wDebugMessageControl = (PFNGLDEBUGMESSAGECONTROLPROC)proc("glDebugMessageControl");
	gl3wDebugMessageControlARB = (PFNGLDEBUGMESSAGECONTROLARBPROC)proc("glDebugMessageControlARB");
	gl3wDebugMessageInsert = (PFNGLDEBUGMESSAGEINSERTPROC)proc("glDebugMessageInsert");
	gl3wDebugMessageInsertARB = (PFNGLDEBUGMESSAGEINSERTARBPROC)proc("glDebugMessageInsertARB");
	gl3wDeleteBuffers = (PFNGLDELETEBUFFERSPROC)proc("glDeleteBuffers");
	gl3wDeleteCommandListsNV = (PFNGLDELETECOMMANDLISTSNVPROC)proc("glDeleteCommandListsNV");
	gl3wDeleteFramebuffers = (PFNGLDELETEFRAMEBUFFERSPROC)proc("glDeleteFramebuffers");
	gl3wDeleteNamedStringARB = (PFNGLDELETENAMEDSTRINGARBPROC)proc("glDeleteNamedStringARB");
	gl3wDeletePathsNV = (PFNGLDELETEPATHSNVPROC)proc("glDeletePathsNV");
	gl3wDeletePerfMonitorsAMD = (PFNGLDELETEPERFMONITORSAMDPROC)proc("glDeletePerfMonitorsAMD");
	gl3wDeletePerfQueryINTEL = (PFNGLDELETEPERFQUERYINTELPROC)proc("glDeletePerfQueryINTEL");
	gl3wDeleteProgram = (PFNGLDELETEPROGRAMPROC)proc("glDeleteProgram");
	gl3wDeleteProgramPipelines = (PFNGLDELETEPROGRAMPIPELINESPROC)proc("glDeleteProgramPipelines");
	gl3wDeleteQueries = (PFNGLDELETEQUERIESPROC)proc("glDeleteQueries");
	gl3wDeleteRenderbuffers = (PFNGLDELETERENDERBUFFERSPROC)proc("glDeleteRenderbuffers");
	gl3wDeleteSamplers = (PFNGLDELETESAMPLERSPROC)proc("glDeleteSamplers");
	gl3wDeleteShader = (PFNGLDELETESHADERPROC)proc("glDeleteShader");
	gl3wDeleteStatesNV = (PFNGLDELETESTATESNVPROC)proc("glDeleteStatesNV");
	gl3wDeleteSync = (PFNGLDELETESYNCPROC)proc("glDeleteSync");
	gl3wDeleteTextures = (PFNGLDELETETEXTURESPROC)proc("glDeleteTextures");
	gl3wDeleteTransformFeedbacks = (PFNGLDELETETRANSFORMFEEDBACKSPROC)proc("glDeleteTransformFeedbacks");
	gl3wDeleteVertexArrays = (PFNGLDELETEVERTEXARRAYSPROC)proc("glDeleteVertexArrays");
	gl3wDepthFunc = (PFNGLDEPTHFUNCPROC)proc("glDepthFunc");
	gl3wDepthMask = (PFNGLDEPTHMASKPROC)proc("glDepthMask");
	gl3wDepthRange = (PFNGLDEPTHRANGEPROC)proc("glDepthRange");
	gl3wDepthRangeArrayv = (PFNGLDEPTHRANGEARRAYVPROC)proc("glDepthRangeArrayv");
	gl3wDepthRangeIndexed = (PFNGLDEPTHRANGEINDEXEDPROC)proc("glDepthRangeIndexed");
	gl3wDepthRangef = (PFNGLDEPTHRANGEFPROC)proc("glDepthRangef");
	gl3wDetachShader = (PFNGLDETACHSHADERPROC)proc("glDetachShader");
	gl3wDisable = (PFNGLDISABLEPROC)proc("glDisable");
	gl3wDisableClientStateIndexedEXT = (PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC)proc("glDisableClientStateIndexedEXT");
	gl3wDisableClientStateiEXT = (PFNGLDISABLECLIENTSTATEIEXTPROC)proc("glDisableClientStateiEXT");
	gl3wDisableIndexedEXT = (PFNGLDISABLEINDEXEDEXTPROC)proc("glDisableIndexedEXT");
	gl3wDisableVertexArrayAttrib = (PFNGLDISABLEVERTEXARRAYATTRIBPROC)proc("glDisableVertexArrayAttrib");
	gl3wDisableVertexArrayAttribEXT = (PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC)proc("glDisableVertexArrayAttribEXT");
	gl3wDisableVertexArrayEXT = (PFNGLDISABLEVERTEXARRAYEXTPROC)proc("glDisableVertexArrayEXT");
	gl3wDisableVertexAttribArray = (PFNGLDISABLEVERTEXATTRIBARRAYPROC)proc("glDisableVertexAttribArray");
	gl3wDisablei = (PFNGLDISABLEIPROC)proc("glDisablei");
	gl3wDispatchCompute = (PFNGLDISPATCHCOMPUTEPROC)proc("glDispatchCompute");
	gl3wDispatchComputeGroupSizeARB = (PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC)proc("glDispatchComputeGroupSizeARB");
	gl3wDispatchComputeIndirect = (PFNGLDISPATCHCOMPUTEINDIRECTPROC)proc("glDispatchComputeIndirect");
	gl3wDrawArrays = (PFNGLDRAWARRAYSPROC)proc("glDrawArrays");
	gl3wDrawArraysIndirect = (PFNGLDRAWARRAYSINDIRECTPROC)proc("glDrawArraysIndirect");
	gl3wDrawArraysInstanced = (PFNGLDRAWARRAYSINSTANCEDPROC)proc("glDrawArraysInstanced");
	gl3wDrawArraysInstancedARB = (PFNGLDRAWARRAYSINSTANCEDARBPROC)proc("glDrawArraysInstancedARB");
	gl3wDrawArraysInstancedBaseInstance = (PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC)proc("glDrawArraysInstancedBaseInstance");
	gl3wDrawArraysInstancedEXT = (PFNGLDRAWARRAYSINSTANCEDEXTPROC)proc("glDrawArraysInstancedEXT");
	gl3wDrawBuffer = (PFNGLDRAWBUFFERPROC)proc("glDrawBuffer");
	gl3wDrawBuffers = (PFNGLDRAWBUFFERSPROC)proc("glDrawBuffers");
	gl3wDrawCommandsAddressNV = (PFNGLDRAWCOMMANDSADDRESSNVPROC)proc("glDrawCommandsAddressNV");
	gl3wDrawCommandsNV = (PFNGLDRAWCOMMANDSNVPROC)proc("glDrawCommandsNV");
	gl3wDrawCommandsStatesAddressNV = (PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC)proc("glDrawCommandsStatesAddressNV");
	gl3wDrawCommandsStatesNV = (PFNGLDRAWCOMMANDSSTATESNVPROC)proc("glDrawCommandsStatesNV");
	gl3wDrawElements = (PFNGLDRAWELEMENTSPROC)proc("glDrawElements");
	gl3wDrawElementsBaseVertex = (PFNGLDRAWELEMENTSBASEVERTEXPROC)proc("glDrawElementsBaseVertex");
	gl3wDrawElementsIndirect = (PFNGLDRAWELEMENTSINDIRECTPROC)proc("glDrawElementsIndirect");
	gl3wDrawElementsInstanced = (PFNGLDRAWELEMENTSINSTANCEDPROC)proc("glDrawElementsInstanced");
	gl3wDrawElementsInstancedARB = (PFNGLDRAWELEMENTSINSTANCEDARBPROC)proc("glDrawElementsInstancedARB");
	gl3wDrawElementsInstancedBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC)proc("glDrawElementsInstancedBaseInstance");
	gl3wDrawElementsInstancedBaseVertex = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC)proc("glDrawElementsInstancedBaseVertex");
	gl3wDrawElementsInstancedBaseVertexBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC)proc("glDrawElementsInstancedBaseVertexBaseInstance");
	gl3wDrawElementsInstancedEXT = (PFNGLDRAWELEMENTSINSTANCEDEXTPROC)proc("glDrawElementsInstancedEXT");
	gl3wDrawRangeElements = (PFNGLDRAWRANGEELEMENTSPROC)proc("glDrawRangeElements");
	gl3wDrawRangeElementsBaseVertex = (PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC)proc("glDrawRangeElementsBaseVertex");
	gl3wDrawTransformFeedback = (PFNGLDRAWTRANSFORMFEEDBACKPROC)proc("glDrawTransformFeedback");
	gl3wDrawTransformFeedbackInstanced = (PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC)proc("glDrawTransformFeedbackInstanced");
	gl3wDrawTransformFeedbackStream = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC)proc("glDrawTransformFeedbackStream");
	gl3wDrawTransformFeedbackStreamInstanced = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC)proc("glDrawTransformFeedbackStreamInstanced");
	gl3wDrawVkImageNV = (PFNGLDRAWVKIMAGENVPROC)proc("glDrawVkImageNV");
	gl3wEdgeFlagFormatNV = (PFNGLEDGEFLAGFORMATNVPROC)proc("glEdgeFlagFormatNV");
	gl3wEnable = (PFNGLENABLEPROC)proc("glEnable");
	gl3wEnableClientStateIndexedEXT = (PFNGLENABLECLIENTSTATEINDEXEDEXTPROC)proc("glEnableClientStateIndexedEXT");
	gl3wEnableClientStateiEXT = (PFNGLENABLECLIENTSTATEIEXTPROC)proc("glEnableClientStateiEXT");
	gl3wEnableIndexedEXT = (PFNGLENABLEINDEXEDEXTPROC)proc("glEnableIndexedEXT");
	gl3wEnableVertexArrayAttrib = (PFNGLENABLEVERTEXARRAYATTRIBPROC)proc("glEnableVertexArrayAttrib");
	gl3wEnableVertexArrayAttribEXT = (PFNGLENABLEVERTEXARRAYATTRIBEXTPROC)proc("glEnableVertexArrayAttribEXT");
	gl3wEnableVertexArrayEXT = (PFNGLENABLEVERTEXARRAYEXTPROC)proc("glEnableVertexArrayEXT");
	gl3wEnableVertexAttribArray = (PFNGLENABLEVERTEXATTRIBARRAYPROC)proc("glEnableVertexAttribArray");
	gl3wEnablei = (PFNGLENABLEIPROC)proc("glEnablei");
	gl3wEndConditionalRender = (PFNGLENDCONDITIONALRENDERPROC)proc("glEndConditionalRender");
	gl3wEndConditionalRenderNV = (PFNGLENDCONDITIONALRENDERNVPROC)proc("glEndConditionalRenderNV");
	gl3wEndPerfMonitorAMD = (PFNGLENDPERFMONITORAMDPROC)proc("glEndPerfMonitorAMD");
	gl3wEndPerfQueryINTEL = (PFNGLENDPERFQUERYINTELPROC)proc("glEndPerfQueryINTEL");
	gl3wEndQuery = (PFNGLENDQUERYPROC)proc("glEndQuery");
	gl3wEndQueryIndexed = (PFNGLENDQUERYINDEXEDPROC)proc("glEndQueryIndexed");
	gl3wEndTransformFeedback = (PFNGLENDTRANSFORMFEEDBACKPROC)proc("glEndTransformFeedback");
	gl3wEvaluateDepthValuesARB = (PFNGLEVALUATEDEPTHVALUESARBPROC)proc("glEvaluateDepthValuesARB");
	gl3wFenceSync = (PFNGLFENCESYNCPROC)proc("glFenceSync");
	gl3wFinish = (PFNGLFINISHPROC)proc("glFinish");
	gl3wFlush = (PFNGLFLUSHPROC)proc("glFlush");
	gl3wFlushMappedBufferRange = (PFNGLFLUSHMAPPEDBUFFERRANGEPROC)proc("glFlushMappedBufferRange");
	gl3wFlushMappedNamedBufferRange = (PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC)proc("glFlushMappedNamedBufferRange");
	gl3wFlushMappedNamedBufferRangeEXT = (PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC)proc("glFlushMappedNamedBufferRangeEXT");
	gl3wFogCoordFormatNV = (PFNGLFOGCOORDFORMATNVPROC)proc("glFogCoordFormatNV");
	gl3wFragmentCoverageColorNV = (PFNGLFRAGMENTCOVERAGECOLORNVPROC)proc("glFragmentCoverageColorNV");
	gl3wFramebufferDrawBufferEXT = (PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC)proc("glFramebufferDrawBufferEXT");
	gl3wFramebufferDrawBuffersEXT = (PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC)proc("glFramebufferDrawBuffersEXT");
	gl3wFramebufferParameteri = (PFNGLFRAMEBUFFERPARAMETERIPROC)proc("glFramebufferParameteri");
	gl3wFramebufferReadBufferEXT = (PFNGLFRAMEBUFFERREADBUFFEREXTPROC)proc("glFramebufferReadBufferEXT");
	gl3wFramebufferRenderbuffer = (PFNGLFRAMEBUFFERRENDERBUFFERPROC)proc("glFramebufferRenderbuffer");
	gl3wFramebufferSampleLocationsfvARB = (PFNGLFRAMEBUFFERSAMPLELOCATIONSFVARBPROC)proc("glFramebufferSampleLocationsfvARB");
	gl3wFramebufferSampleLocationsfvNV = (PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC)proc("glFramebufferSampleLocationsfvNV");
	gl3wFramebufferTexture = (PFNGLFRAMEBUFFERTEXTUREPROC)proc("glFramebufferTexture");
	gl3wFramebufferTexture1D = (PFNGLFRAMEBUFFERTEXTURE1DPROC)proc("glFramebufferTexture1D");
	gl3wFramebufferTexture2D = (PFNGLFRAMEBUFFERTEXTURE2DPROC)proc("glFramebufferTexture2D");
	gl3wFramebufferTexture3D = (PFNGLFRAMEBUFFERTEXTURE3DPROC)proc("glFramebufferTexture3D");
	gl3wFramebufferTextureARB = (PFNGLFRAMEBUFFERTEXTUREARBPROC)proc("glFramebufferTextureARB");
	gl3wFramebufferTextureFaceARB = (PFNGLFRAMEBUFFERTEXTUREFACEARBPROC)proc("glFramebufferTextureFaceARB");
	gl3wFramebufferTextureLayer = (PFNGLFRAMEBUFFERTEXTURELAYERPROC)proc("glFramebufferTextureLayer");
	gl3wFramebufferTextureLayerARB = (PFNGLFRAMEBUFFERTEXTURELAYERARBPROC)proc("glFramebufferTextureLayerARB");
	gl3wFramebufferTextureMultiviewOVR = (PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC)proc("glFramebufferTextureMultiviewOVR");
	gl3wFrontFace = (PFNGLFRONTFACEPROC)proc("glFrontFace");
	gl3wGenBuffers = (PFNGLGENBUFFERSPROC)proc("glGenBuffers");
	gl3wGenFramebuffers = (PFNGLGENFRAMEBUFFERSPROC)proc("glGenFramebuffers");
	gl3wGenPathsNV = (PFNGLGENPATHSNVPROC)proc("glGenPathsNV");
	gl3wGenPerfMonitorsAMD = (PFNGLGENPERFMONITORSAMDPROC)proc("glGenPerfMonitorsAMD");
	gl3wGenProgramPipelines = (PFNGLGENPROGRAMPIPELINESPROC)proc("glGenProgramPipelines");
	gl3wGenQueries = (PFNGLGENQUERIESPROC)proc("glGenQueries");
	gl3wGenRenderbuffers = (PFNGLGENRENDERBUFFERSPROC)proc("glGenRenderbuffers");
	gl3wGenSamplers = (PFNGLGENSAMPLERSPROC)proc("glGenSamplers");
	gl3wGenTextures = (PFNGLGENTEXTURESPROC)proc("glGenTextures");
	gl3wGenTransformFeedbacks = (PFNGLGENTRANSFORMFEEDBACKSPROC)proc("glGenTransformFeedbacks");
	gl3wGenVertexArrays = (PFNGLGENVERTEXARRAYSPROC)proc("glGenVertexArrays");
	gl3wGenerateMipmap = (PFNGLGENERATEMIPMAPPROC)proc("glGenerateMipmap");
	gl3wGenerateMultiTexMipmapEXT = (PFNGLGENERATEMULTITEXMIPMAPEXTPROC)proc("glGenerateMultiTexMipmapEXT");
	gl3wGenerateTextureMipmap = (PFNGLGENERATETEXTUREMIPMAPPROC)proc("glGenerateTextureMipmap");
	gl3wGenerateTextureMipmapEXT = (PFNGLGENERATETEXTUREMIPMAPEXTPROC)proc("glGenerateTextureMipmapEXT");
	gl3wGetActiveAtomicCounterBufferiv = (PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC)proc("glGetActiveAtomicCounterBufferiv");
	gl3wGetActiveAttrib = (PFNGLGETACTIVEATTRIBPROC)proc("glGetActiveAttrib");
	gl3wGetActiveSubroutineName = (PFNGLGETACTIVESUBROUTINENAMEPROC)proc("glGetActiveSubroutineName");
	gl3wGetActiveSubroutineUniformName = (PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC)proc("glGetActiveSubroutineUniformName");
	gl3wGetActiveSubroutineUniformiv = (PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC)proc("glGetActiveSubroutineUniformiv");
	gl3wGetActiveUniform = (PFNGLGETACTIVEUNIFORMPROC)proc("glGetActiveUniform");
	gl3wGetActiveUniformBlockName = (PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC)proc("glGetActiveUniformBlockName");
	gl3wGetActiveUniformBlockiv = (PFNGLGETACTIVEUNIFORMBLOCKIVPROC)proc("glGetActiveUniformBlockiv");
	gl3wGetActiveUniformName = (PFNGLGETACTIVEUNIFORMNAMEPROC)proc("glGetActiveUniformName");
	gl3wGetActiveUniformsiv = (PFNGLGETACTIVEUNIFORMSIVPROC)proc("glGetActiveUniformsiv");
	gl3wGetAttachedShaders = (PFNGLGETATTACHEDSHADERSPROC)proc("glGetAttachedShaders");
	gl3wGetAttribLocation = (PFNGLGETATTRIBLOCATIONPROC)proc("glGetAttribLocation");
	gl3wGetBooleanIndexedvEXT = (PFNGLGETBOOLEANINDEXEDVEXTPROC)proc("glGetBooleanIndexedvEXT");
	gl3wGetBooleani_v = (PFNGLGETBOOLEANI_VPROC)proc("glGetBooleani_v");
	gl3wGetBooleanv = (PFNGLGETBOOLEANVPROC)proc("glGetBooleanv");
	gl3wGetBufferParameteri64v = (PFNGLGETBUFFERPARAMETERI64VPROC)proc("glGetBufferParameteri64v");
	gl3wGetBufferParameteriv = (PFNGLGETBUFFERPARAMETERIVPROC)proc("glGetBufferParameteriv");
	gl3wGetBufferParameterui64vNV = (PFNGLGETBUFFERPARAMETERUI64VNVPROC)proc("glGetBufferParameterui64vNV");
	gl3wGetBufferPointerv = (PFNGLGETBUFFERPOINTERVPROC)proc("glGetBufferPointerv");
	gl3wGetBufferSubData = (PFNGLGETBUFFERSUBDATAPROC)proc("glGetBufferSubData");
	gl3wGetCommandHeaderNV = (PFNGLGETCOMMANDHEADERNVPROC)proc("glGetCommandHeaderNV");
	gl3wGetCompressedMultiTexImageEXT = (PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC)proc("glGetCompressedMultiTexImageEXT");
	gl3wGetCompressedTexImage = (PFNGLGETCOMPRESSEDTEXIMAGEPROC)proc("glGetCompressedTexImage");
	gl3wGetCompressedTextureImage = (PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC)proc("glGetCompressedTextureImage");
	gl3wGetCompressedTextureImageEXT = (PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC)proc("glGetCompressedTextureImageEXT");
	gl3wGetCompressedTextureSubImage = (PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC)proc("glGetCompressedTextureSubImage");
	gl3wGetCoverageModulationTableNV = (PFNGLGETCOVERAGEMODULATIONTABLENVPROC)proc("glGetCoverageModulationTableNV");
	gl3wGetDebugMessageLog = (PFNGLGETDEBUGMESSAGELOGPROC)proc("glGetDebugMessageLog");
	gl3wGetDebugMessageLogARB = (PFNGLGETDEBUGMESSAGELOGARBPROC)proc("glGetDebugMessageLogARB");
	gl3wGetDoubleIndexedvEXT = (PFNGLGETDOUBLEINDEXEDVEXTPROC)proc("glGetDoubleIndexedvEXT");
	gl3wGetDoublei_v = (PFNGLGETDOUBLEI_VPROC)proc("glGetDoublei_v");
	gl3wGetDoublei_vEXT = (PFNGLGETDOUBLEI_VEXTPROC)proc("glGetDoublei_vEXT");
	gl3wGetDoublev = (PFNGLGETDOUBLEVPROC)proc("glGetDoublev");
	gl3wGetError = (PFNGLGETERRORPROC)proc("glGetError");
	gl3wGetFirstPerfQueryIdINTEL = (PFNGLGETFIRSTPERFQUERYIDINTELPROC)proc("glGetFirstPerfQueryIdINTEL");
	gl3wGetFloatIndexedvEXT = (PFNGLGETFLOATINDEXEDVEXTPROC)proc("glGetFloatIndexedvEXT");
	gl3wGetFloati_v = (PFNGLGETFLOATI_VPROC)proc("glGetFloati_v");
	gl3wGetFloati_vEXT = (PFNGLGETFLOATI_VEXTPROC)proc("glGetFloati_vEXT");
	gl3wGetFloatv = (PFNGLGETFLOATVPROC)proc("glGetFloatv");
	gl3wGetFragDataIndex = (PFNGLGETFRAGDATAINDEXPROC)proc("glGetFragDataIndex");
	gl3wGetFragDataLocation = (PFNGLGETFRAGDATALOCATIONPROC)proc("glGetFragDataLocation");
	gl3wGetFramebufferAttachmentParameteriv = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC)proc("glGetFramebufferAttachmentParameteriv");
	gl3wGetFramebufferParameteriv = (PFNGLGETFRAMEBUFFERPARAMETERIVPROC)proc("glGetFramebufferParameteriv");
	gl3wGetFramebufferParameterivEXT = (PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC)proc("glGetFramebufferParameterivEXT");
	gl3wGetGraphicsResetStatus = (PFNGLGETGRAPHICSRESETSTATUSPROC)proc("glGetGraphicsResetStatus");
	gl3wGetGraphicsResetStatusARB = (PFNGLGETGRAPHICSRESETSTATUSARBPROC)proc("glGetGraphicsResetStatusARB");
	gl3wGetImageHandleARB = (PFNGLGETIMAGEHANDLEARBPROC)proc("glGetImageHandleARB");
	gl3wGetImageHandleNV = (PFNGLGETIMAGEHANDLENVPROC)proc("glGetImageHandleNV");
	gl3wGetInteger64i_v = (PFNGLGETINTEGER64I_VPROC)proc("glGetInteger64i_v");
	gl3wGetInteger64v = (PFNGLGETINTEGER64VPROC)proc("glGetInteger64v");
	gl3wGetIntegerIndexedvEXT = (PFNGLGETINTEGERINDEXEDVEXTPROC)proc("glGetIntegerIndexedvEXT");
	gl3wGetIntegeri_v = (PFNGLGETINTEGERI_VPROC)proc("glGetIntegeri_v");
	gl3wGetIntegerui64i_vNV = (PFNGLGETINTEGERUI64I_VNVPROC)proc("glGetIntegerui64i_vNV");
	gl3wGetIntegerui64vNV = (PFNGLGETINTEGERUI64VNVPROC)proc("glGetIntegerui64vNV");
	gl3wGetIntegerv = (PFNGLGETINTEGERVPROC)proc("glGetIntegerv");
	gl3wGetInternalformatSampleivNV = (PFNGLGETINTERNALFORMATSAMPLEIVNVPROC)proc("glGetInternalformatSampleivNV");
	gl3wGetInternalformati64v = (PFNGLGETINTERNALFORMATI64VPROC)proc("glGetInternalformati64v");
	gl3wGetInternalformativ = (PFNGLGETINTERNALFORMATIVPROC)proc("glGetInternalformativ");
	gl3wGetMultiTexEnvfvEXT = (PFNGLGETMULTITEXENVFVEXTPROC)proc("glGetMultiTexEnvfvEXT");
	gl3wGetMultiTexEnvivEXT = (PFNGLGETMULTITEXENVIVEXTPROC)proc("glGetMultiTexEnvivEXT");
	gl3wGetMultiTexGendvEXT = (PFNGLGETMULTITEXGENDVEXTPROC)proc("glGetMultiTexGendvEXT");
	gl3wGetMultiTexGenfvEXT = (PFNGLGETMULTITEXGENFVEXTPROC)proc("glGetMultiTexGenfvEXT");
	gl3wGetMultiTexGenivEXT = (PFNGLGETMULTITEXGENIVEXTPROC)proc("glGetMultiTexGenivEXT");
	gl3wGetMultiTexImageEXT = (PFNGLGETMULTITEXIMAGEEXTPROC)proc("glGetMultiTexImageEXT");
	gl3wGetMultiTexLevelParameterfvEXT = (PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC)proc("glGetMultiTexLevelParameterfvEXT");
	gl3wGetMultiTexLevelParameterivEXT = (PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC)proc("glGetMultiTexLevelParameterivEXT");
	gl3wGetMultiTexParameterIivEXT = (PFNGLGETMULTITEXPARAMETERIIVEXTPROC)proc("glGetMultiTexParameterIivEXT");
	gl3wGetMultiTexParameterIuivEXT = (PFNGLGETMULTITEXPARAMETERIUIVEXTPROC)proc("glGetMultiTexParameterIuivEXT");
	gl3wGetMultiTexParameterfvEXT = (PFNGLGETMULTITEXPARAMETERFVEXTPROC)proc("glGetMultiTexParameterfvEXT");
	gl3wGetMultiTexParameterivEXT = (PFNGLGETMULTITEXPARAMETERIVEXTPROC)proc("glGetMultiTexParameterivEXT");
	gl3wGetMultisamplefv = (PFNGLGETMULTISAMPLEFVPROC)proc("glGetMultisamplefv");
	gl3wGetNamedBufferParameteri64v = (PFNGLGETNAMEDBUFFERPARAMETERI64VPROC)proc("glGetNamedBufferParameteri64v");
	gl3wGetNamedBufferParameteriv = (PFNGLGETNAMEDBUFFERPARAMETERIVPROC)proc("glGetNamedBufferParameteriv");
	gl3wGetNamedBufferParameterivEXT = (PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC)proc("glGetNamedBufferParameterivEXT");
	gl3wGetNamedBufferParameterui64vNV = (PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC)proc("glGetNamedBufferParameterui64vNV");
	gl3wGetNamedBufferPointerv = (PFNGLGETNAMEDBUFFERPOINTERVPROC)proc("glGetNamedBufferPointerv");
	gl3wGetNamedBufferPointervEXT = (PFNGLGETNAMEDBUFFERPOINTERVEXTPROC)proc("glGetNamedBufferPointervEXT");
	gl3wGetNamedBufferSubData = (PFNGLGETNAMEDBUFFERSUBDATAPROC)proc("glGetNamedBufferSubData");
	gl3wGetNamedBufferSubDataEXT = (PFNGLGETNAMEDBUFFERSUBDATAEXTPROC)proc("glGetNamedBufferSubDataEXT");
	gl3wGetNamedFramebufferAttachmentParameteriv = (PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC)proc("glGetNamedFramebufferAttachmentParameteriv");
	gl3wGetNamedFramebufferAttachmentParameterivEXT = (PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC)proc("glGetNamedFramebufferAttachmentParameterivEXT");
	gl3wGetNamedFramebufferParameteriv = (PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC)proc("glGetNamedFramebufferParameteriv");
	gl3wGetNamedFramebufferParameterivEXT = (PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC)proc("glGetNamedFramebufferParameterivEXT");
	gl3wGetNamedProgramLocalParameterIivEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC)proc("glGetNamedProgramLocalParameterIivEXT");
	gl3wGetNamedProgramLocalParameterIuivEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC)proc("glGetNamedProgramLocalParameterIuivEXT");
	gl3wGetNamedProgramLocalParameterdvEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC)proc("glGetNamedProgramLocalParameterdvEXT");
	gl3wGetNamedProgramLocalParameterfvEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC)proc("glGetNamedProgramLocalParameterfvEXT");
	gl3wGetNamedProgramStringEXT = (PFNGLGETNAMEDPROGRAMSTRINGEXTPROC)proc("glGetNamedProgramStringEXT");
	gl3wGetNamedProgramivEXT = (PFNGLGETNAMEDPROGRAMIVEXTPROC)proc("glGetNamedProgramivEXT");
	gl3wGetNamedRenderbufferParameteriv = (PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC)proc("glGetNamedRenderbufferParameteriv");
	gl3wGetNamedRenderbufferParameterivEXT = (PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC)proc("glGetNamedRenderbufferParameterivEXT");
	gl3wGetNamedStringARB = (PFNGLGETNAMEDSTRINGARBPROC)proc("glGetNamedStringARB");
	gl3wGetNamedStringivARB = (PFNGLGETNAMEDSTRINGIVARBPROC)proc("glGetNamedStringivARB");
	gl3wGetNextPerfQueryIdINTEL = (PFNGLGETNEXTPERFQUERYIDINTELPROC)proc("glGetNextPerfQueryIdINTEL");
	gl3wGetObjectLabel = (PFNGLGETOBJECTLABELPROC)proc("glGetObjectLabel");
	gl3wGetObjectLabelEXT = (PFNGLGETOBJECTLABELEXTPROC)proc("glGetObjectLabelEXT");
	gl3wGetObjectPtrLabel = (PFNGLGETOBJECTPTRLABELPROC)proc("glGetObjectPtrLabel");
	gl3wGetPathCommandsNV = (PFNGLGETPATHCOMMANDSNVPROC)proc("glGetPathCommandsNV");
	gl3wGetPathCoordsNV = (PFNGLGETPATHCOORDSNVPROC)proc("glGetPathCoordsNV");
	gl3wGetPathDashArrayNV = (PFNGLGETPATHDASHARRAYNVPROC)proc("glGetPathDashArrayNV");
	gl3wGetPathLengthNV = (PFNGLGETPATHLENGTHNVPROC)proc("glGetPathLengthNV");
	gl3wGetPathMetricRangeNV = (PFNGLGETPATHMETRICRANGENVPROC)proc("glGetPathMetricRangeNV");
	gl3wGetPathMetricsNV = (PFNGLGETPATHMETRICSNVPROC)proc("glGetPathMetricsNV");
	gl3wGetPathParameterfvNV = (PFNGLGETPATHPARAMETERFVNVPROC)proc("glGetPathParameterfvNV");
	gl3wGetPathParameterivNV = (PFNGLGETPATHPARAMETERIVNVPROC)proc("glGetPathParameterivNV");
	gl3wGetPathSpacingNV = (PFNGLGETPATHSPACINGNVPROC)proc("glGetPathSpacingNV");
	gl3wGetPerfCounterInfoINTEL = (PFNGLGETPERFCOUNTERINFOINTELPROC)proc("glGetPerfCounterInfoINTEL");
	gl3wGetPerfMonitorCounterDataAMD = (PFNGLGETPERFMONITORCOUNTERDATAAMDPROC)proc("glGetPerfMonitorCounterDataAMD");
	gl3wGetPerfMonitorCounterInfoAMD = (PFNGLGETPERFMONITORCOUNTERINFOAMDPROC)proc("glGetPerfMonitorCounterInfoAMD");
	gl3wGetPerfMonitorCounterStringAMD = (PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC)proc("glGetPerfMonitorCounterStringAMD");
	gl3wGetPerfMonitorCountersAMD = (PFNGLGETPERFMONITORCOUNTERSAMDPROC)proc("glGetPerfMonitorCountersAMD");
	gl3wGetPerfMonitorGroupStringAMD = (PFNGLGETPERFMONITORGROUPSTRINGAMDPROC)proc("glGetPerfMonitorGroupStringAMD");
	gl3wGetPerfMonitorGroupsAMD = (PFNGLGETPERFMONITORGROUPSAMDPROC)proc("glGetPerfMonitorGroupsAMD");
	gl3wGetPerfQueryDataINTEL = (PFNGLGETPERFQUERYDATAINTELPROC)proc("glGetPerfQueryDataINTEL");
	gl3wGetPerfQueryIdByNameINTEL = (PFNGLGETPERFQUERYIDBYNAMEINTELPROC)proc("glGetPerfQueryIdByNameINTEL");
	gl3wGetPerfQueryInfoINTEL = (PFNGLGETPERFQUERYINFOINTELPROC)proc("glGetPerfQueryInfoINTEL");
	gl3wGetPointerIndexedvEXT = (PFNGLGETPOINTERINDEXEDVEXTPROC)proc("glGetPointerIndexedvEXT");
	gl3wGetPointeri_vEXT = (PFNGLGETPOINTERI_VEXTPROC)proc("glGetPointeri_vEXT");
	gl3wGetPointerv = (PFNGLGETPOINTERVPROC)proc("glGetPointerv");
	gl3wGetProgramBinary = (PFNGLGETPROGRAMBINARYPROC)proc("glGetProgramBinary");
	gl3wGetProgramInfoLog = (PFNGLGETPROGRAMINFOLOGPROC)proc("glGetProgramInfoLog");
	gl3wGetProgramInterfaceiv = (PFNGLGETPROGRAMINTERFACEIVPROC)proc("glGetProgramInterfaceiv");
	gl3wGetProgramPipelineInfoLog = (PFNGLGETPROGRAMPIPELINEINFOLOGPROC)proc("glGetProgramPipelineInfoLog");
	gl3wGetProgramPipelineiv = (PFNGLGETPROGRAMPIPELINEIVPROC)proc("glGetProgramPipelineiv");
	gl3wGetProgramResourceIndex = (PFNGLGETPROGRAMRESOURCEINDEXPROC)proc("glGetProgramResourceIndex");
	gl3wGetProgramResourceLocation = (PFNGLGETPROGRAMRESOURCELOCATIONPROC)proc("glGetProgramResourceLocation");
	gl3wGetProgramResourceLocationIndex = (PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC)proc("glGetProgramResourceLocationIndex");
	gl3wGetProgramResourceName = (PFNGLGETPROGRAMRESOURCENAMEPROC)proc("glGetProgramResourceName");
	gl3wGetProgramResourcefvNV = (PFNGLGETPROGRAMRESOURCEFVNVPROC)proc("glGetProgramResourcefvNV");
	gl3wGetProgramResourceiv = (PFNGLGETPROGRAMRESOURCEIVPROC)proc("glGetProgramResourceiv");
	gl3wGetProgramStageiv = (PFNGLGETPROGRAMSTAGEIVPROC)proc("glGetProgramStageiv");
	gl3wGetProgramiv = (PFNGLGETPROGRAMIVPROC)proc("glGetProgramiv");
	gl3wGetQueryBufferObjecti64v = (PFNGLGETQUERYBUFFEROBJECTI64VPROC)proc("glGetQueryBufferObjecti64v");
	gl3wGetQueryBufferObjectiv = (PFNGLGETQUERYBUFFEROBJECTIVPROC)proc("glGetQueryBufferObjectiv");
	gl3wGetQueryBufferObjectui64v = (PFNGLGETQUERYBUFFEROBJECTUI64VPROC)proc("glGetQueryBufferObjectui64v");
	gl3wGetQueryBufferObjectuiv = (PFNGLGETQUERYBUFFEROBJECTUIVPROC)proc("glGetQueryBufferObjectuiv");
	gl3wGetQueryIndexediv = (PFNGLGETQUERYINDEXEDIVPROC)proc("glGetQueryIndexediv");
	gl3wGetQueryObjecti64v = (PFNGLGETQUERYOBJECTI64VPROC)proc("glGetQueryObjecti64v");
	gl3wGetQueryObjectiv = (PFNGLGETQUERYOBJECTIVPROC)proc("glGetQueryObjectiv");
	gl3wGetQueryObjectui64v = (PFNGLGETQUERYOBJECTUI64VPROC)proc("glGetQueryObjectui64v");
	gl3wGetQueryObjectuiv = (PFNGLGETQUERYOBJECTUIVPROC)proc("glGetQueryObjectuiv");
	gl3wGetQueryiv = (PFNGLGETQUERYIVPROC)proc("glGetQueryiv");
	gl3wGetRenderbufferParameteriv = (PFNGLGETRENDERBUFFERPARAMETERIVPROC)proc("glGetRenderbufferParameteriv");
	gl3wGetSamplerParameterIiv = (PFNGLGETSAMPLERPARAMETERIIVPROC)proc("glGetSamplerParameterIiv");
	gl3wGetSamplerParameterIuiv = (PFNGLGETSAMPLERPARAMETERIUIVPROC)proc("glGetSamplerParameterIuiv");
	gl3wGetSamplerParameterfv = (PFNGLGETSAMPLERPARAMETERFVPROC)proc("glGetSamplerParameterfv");
	gl3wGetSamplerParameteriv = (PFNGLGETSAMPLERPARAMETERIVPROC)proc("glGetSamplerParameteriv");
	gl3wGetShaderInfoLog = (PFNGLGETSHADERINFOLOGPROC)proc("glGetShaderInfoLog");
	gl3wGetShaderPrecisionFormat = (PFNGLGETSHADERPRECISIONFORMATPROC)proc("glGetShaderPrecisionFormat");
	gl3wGetShaderSource = (PFNGLGETSHADERSOURCEPROC)proc("glGetShaderSource");
	gl3wGetShaderiv = (PFNGLGETSHADERIVPROC)proc("glGetShaderiv");
	gl3wGetStageIndexNV = (PFNGLGETSTAGEINDEXNVPROC)proc("glGetStageIndexNV");
	gl3wGetString = (PFNGLGETSTRINGPROC)proc("glGetString");
	gl3wGetStringi = (PFNGLGETSTRINGIPROC)proc("glGetStringi");
	gl3wGetSubroutineIndex = (PFNGLGETSUBROUTINEINDEXPROC)proc("glGetSubroutineIndex");
	gl3wGetSubroutineUniformLocation = (PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC)proc("glGetSubroutineUniformLocation");
	gl3wGetSynciv = (PFNGLGETSYNCIVPROC)proc("glGetSynciv");
	gl3wGetTexImage = (PFNGLGETTEXIMAGEPROC)proc("glGetTexImage");
	gl3wGetTexLevelParameterfv = (PFNGLGETTEXLEVELPARAMETERFVPROC)proc("glGetTexLevelParameterfv");
	gl3wGetTexLevelParameteriv = (PFNGLGETTEXLEVELPARAMETERIVPROC)proc("glGetTexLevelParameteriv");
	gl3wGetTexParameterIiv = (PFNGLGETTEXPARAMETERIIVPROC)proc("glGetTexParameterIiv");
	gl3wGetTexParameterIuiv = (PFNGLGETTEXPARAMETERIUIVPROC)proc("glGetTexParameterIuiv");
	gl3wGetTexParameterfv = (PFNGLGETTEXPARAMETERFVPROC)proc("glGetTexParameterfv");
	gl3wGetTexParameteriv = (PFNGLGETTEXPARAMETERIVPROC)proc("glGetTexParameteriv");
	gl3wGetTextureHandleARB = (PFNGLGETTEXTUREHANDLEARBPROC)proc("glGetTextureHandleARB");
	gl3wGetTextureHandleNV = (PFNGLGETTEXTUREHANDLENVPROC)proc("glGetTextureHandleNV");
	gl3wGetTextureImage = (PFNGLGETTEXTUREIMAGEPROC)proc("glGetTextureImage");
	gl3wGetTextureImageEXT = (PFNGLGETTEXTUREIMAGEEXTPROC)proc("glGetTextureImageEXT");
	gl3wGetTextureLevelParameterfv = (PFNGLGETTEXTURELEVELPARAMETERFVPROC)proc("glGetTextureLevelParameterfv");
	gl3wGetTextureLevelParameterfvEXT = (PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC)proc("glGetTextureLevelParameterfvEXT");
	gl3wGetTextureLevelParameteriv = (PFNGLGETTEXTURELEVELPARAMETERIVPROC)proc("glGetTextureLevelParameteriv");
	gl3wGetTextureLevelParameterivEXT = (PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC)proc("glGetTextureLevelParameterivEXT");
	gl3wGetTextureParameterIiv = (PFNGLGETTEXTUREPARAMETERIIVPROC)proc("glGetTextureParameterIiv");
	gl3wGetTextureParameterIivEXT = (PFNGLGETTEXTUREPARAMETERIIVEXTPROC)proc("glGetTextureParameterIivEXT");
	gl3wGetTextureParameterIuiv = (PFNGLGETTEXTUREPARAMETERIUIVPROC)proc("glGetTextureParameterIuiv");
	gl3wGetTextureParameterIuivEXT = (PFNGLGETTEXTUREPARAMETERIUIVEXTPROC)proc("glGetTextureParameterIuivEXT");
	gl3wGetTextureParameterfv = (PFNGLGETTEXTUREPARAMETERFVPROC)proc("glGetTextureParameterfv");
	gl3wGetTextureParameterfvEXT = (PFNGLGETTEXTUREPARAMETERFVEXTPROC)proc("glGetTextureParameterfvEXT");
	gl3wGetTextureParameteriv = (PFNGLGETTEXTUREPARAMETERIVPROC)proc("glGetTextureParameteriv");
	gl3wGetTextureParameterivEXT = (PFNGLGETTEXTUREPARAMETERIVEXTPROC)proc("glGetTextureParameterivEXT");
	gl3wGetTextureSamplerHandleARB = (PFNGLGETTEXTURESAMPLERHANDLEARBPROC)proc("glGetTextureSamplerHandleARB");
	gl3wGetTextureSamplerHandleNV = (PFNGLGETTEXTURESAMPLERHANDLENVPROC)proc("glGetTextureSamplerHandleNV");
	gl3wGetTextureSubImage = (PFNGLGETTEXTURESUBIMAGEPROC)proc("glGetTextureSubImage");
	gl3wGetTransformFeedbackVarying = (PFNGLGETTRANSFORMFEEDBACKVARYINGPROC)proc("glGetTransformFeedbackVarying");
	gl3wGetTransformFeedbacki64_v = (PFNGLGETTRANSFORMFEEDBACKI64_VPROC)proc("glGetTransformFeedbacki64_v");
	gl3wGetTransformFeedbacki_v = (PFNGLGETTRANSFORMFEEDBACKI_VPROC)proc("glGetTransformFeedbacki_v");
	gl3wGetTransformFeedbackiv = (PFNGLGETTRANSFORMFEEDBACKIVPROC)proc("glGetTransformFeedbackiv");
	gl3wGetUniformBlockIndex = (PFNGLGETUNIFORMBLOCKINDEXPROC)proc("glGetUniformBlockIndex");
	gl3wGetUniformIndices = (PFNGLGETUNIFORMINDICESPROC)proc("glGetUniformIndices");
	gl3wGetUniformLocation = (PFNGLGETUNIFORMLOCATIONPROC)proc("glGetUniformLocation");
	gl3wGetUniformSubroutineuiv = (PFNGLGETUNIFORMSUBROUTINEUIVPROC)proc("glGetUniformSubroutineuiv");
	gl3wGetUniformdv = (PFNGLGETUNIFORMDVPROC)proc("glGetUniformdv");
	gl3wGetUniformfv = (PFNGLGETUNIFORMFVPROC)proc("glGetUniformfv");
	gl3wGetUniformi64vARB = (PFNGLGETUNIFORMI64VARBPROC)proc("glGetUniformi64vARB");
	gl3wGetUniformi64vNV = (PFNGLGETUNIFORMI64VNVPROC)proc("glGetUniformi64vNV");
	gl3wGetUniformiv = (PFNGLGETUNIFORMIVPROC)proc("glGetUniformiv");
	gl3wGetUniformui64vARB = (PFNGLGETUNIFORMUI64VARBPROC)proc("glGetUniformui64vARB");
	gl3wGetUniformui64vNV = (PFNGLGETUNIFORMUI64VNVPROC)proc("glGetUniformui64vNV");
	gl3wGetUniformuiv = (PFNGLGETUNIFORMUIVPROC)proc("glGetUniformuiv");
	gl3wGetVertexArrayIndexed64iv = (PFNGLGETVERTEXARRAYINDEXED64IVPROC)proc("glGetVertexArrayIndexed64iv");
	gl3wGetVertexArrayIndexediv = (PFNGLGETVERTEXARRAYINDEXEDIVPROC)proc("glGetVertexArrayIndexediv");
	gl3wGetVertexArrayIntegeri_vEXT = (PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC)proc("glGetVertexArrayIntegeri_vEXT");
	gl3wGetVertexArrayIntegervEXT = (PFNGLGETVERTEXARRAYINTEGERVEXTPROC)proc("glGetVertexArrayIntegervEXT");
	gl3wGetVertexArrayPointeri_vEXT = (PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC)proc("glGetVertexArrayPointeri_vEXT");
	gl3wGetVertexArrayPointervEXT = (PFNGLGETVERTEXARRAYPOINTERVEXTPROC)proc("glGetVertexArrayPointervEXT");
	gl3wGetVertexArrayiv = (PFNGLGETVERTEXARRAYIVPROC)proc("glGetVertexArrayiv");
	gl3wGetVertexAttribIiv = (PFNGLGETVERTEXATTRIBIIVPROC)proc("glGetVertexAttribIiv");
	gl3wGetVertexAttribIuiv = (PFNGLGETVERTEXATTRIBIUIVPROC)proc("glGetVertexAttribIuiv");
	gl3wGetVertexAttribLdv = (PFNGLGETVERTEXATTRIBLDVPROC)proc("glGetVertexAttribLdv");
	gl3wGetVertexAttribLi64vNV = (PFNGLGETVERTEXATTRIBLI64VNVPROC)proc("glGetVertexAttribLi64vNV");
	gl3wGetVertexAttribLui64vARB = (PFNGLGETVERTEXATTRIBLUI64VARBPROC)proc("glGetVertexAttribLui64vARB");
	gl3wGetVertexAttribLui64vNV = (PFNGLGETVERTEXATTRIBLUI64VNVPROC)proc("glGetVertexAttribLui64vNV");
	gl3wGetVertexAttribPointerv = (PFNGLGETVERTEXATTRIBPOINTERVPROC)proc("glGetVertexAttribPointerv");
	gl3wGetVertexAttribdv = (PFNGLGETVERTEXATTRIBDVPROC)proc("glGetVertexAttribdv");
	gl3wGetVertexAttribfv = (PFNGLGETVERTEXATTRIBFVPROC)proc("glGetVertexAttribfv");
	gl3wGetVertexAttribiv = (PFNGLGETVERTEXATTRIBIVPROC)proc("glGetVertexAttribiv");
	gl3wGetVkProcAddrNV = (PFNGLGETVKPROCADDRNVPROC)proc("glGetVkProcAddrNV");
	gl3wGetnCompressedTexImage = (PFNGLGETNCOMPRESSEDTEXIMAGEPROC)proc("glGetnCompressedTexImage");
	gl3wGetnCompressedTexImageARB = (PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC)proc("glGetnCompressedTexImageARB");
	gl3wGetnTexImage = (PFNGLGETNTEXIMAGEPROC)proc("glGetnTexImage");
	gl3wGetnTexImageARB = (PFNGLGETNTEXIMAGEARBPROC)proc("glGetnTexImageARB");
	gl3wGetnUniformdv = (PFNGLGETNUNIFORMDVPROC)proc("glGetnUniformdv");
	gl3wGetnUniformdvARB = (PFNGLGETNUNIFORMDVARBPROC)proc("glGetnUniformdvARB");
	gl3wGetnUniformfv = (PFNGLGETNUNIFORMFVPROC)proc("glGetnUniformfv");
	gl3wGetnUniformfvARB = (PFNGLGETNUNIFORMFVARBPROC)proc("glGetnUniformfvARB");
	gl3wGetnUniformi64vARB = (PFNGLGETNUNIFORMI64VARBPROC)proc("glGetnUniformi64vARB");
	gl3wGetnUniformiv = (PFNGLGETNUNIFORMIVPROC)proc("glGetnUniformiv");
	gl3wGetnUniformivARB = (PFNGLGETNUNIFORMIVARBPROC)proc("glGetnUniformivARB");
	gl3wGetnUniformui64vARB = (PFNGLGETNUNIFORMUI64VARBPROC)proc("glGetnUniformui64vARB");
	gl3wGetnUniformuiv = (PFNGLGETNUNIFORMUIVPROC)proc("glGetnUniformuiv");
	gl3wGetnUniformuivARB = (PFNGLGETNUNIFORMUIVARBPROC)proc("glGetnUniformuivARB");
	gl3wHint = (PFNGLHINTPROC)proc("glHint");
	gl3wIndexFormatNV = (PFNGLINDEXFORMATNVPROC)proc("glIndexFormatNV");
	gl3wInsertEventMarkerEXT = (PFNGLINSERTEVENTMARKEREXTPROC)proc("glInsertEventMarkerEXT");
	gl3wInterpolatePathsNV = (PFNGLINTERPOLATEPATHSNVPROC)proc("glInterpolatePathsNV");
	gl3wInvalidateBufferData = (PFNGLINVALIDATEBUFFERDATAPROC)proc("glInvalidateBufferData");
	gl3wInvalidateBufferSubData = (PFNGLINVALIDATEBUFFERSUBDATAPROC)proc("glInvalidateBufferSubData");
	gl3wInvalidateFramebuffer = (PFNGLINVALIDATEFRAMEBUFFERPROC)proc("glInvalidateFramebuffer");
	gl3wInvalidateNamedFramebufferData = (PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC)proc("glInvalidateNamedFramebufferData");
	gl3wInvalidateNamedFramebufferSubData = (PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC)proc("glInvalidateNamedFramebufferSubData");
	gl3wInvalidateSubFramebuffer = (PFNGLINVALIDATESUBFRAMEBUFFERPROC)proc("glInvalidateSubFramebuffer");
	gl3wInvalidateTexImage = (PFNGLINVALIDATETEXIMAGEPROC)proc("glInvalidateTexImage");
	gl3wInvalidateTexSubImage = (PFNGLINVALIDATETEXSUBIMAGEPROC)proc("glInvalidateTexSubImage");
	gl3wIsBuffer = (PFNGLISBUFFERPROC)proc("glIsBuffer");
	gl3wIsBufferResidentNV = (PFNGLISBUFFERRESIDENTNVPROC)proc("glIsBufferResidentNV");
	gl3wIsCommandListNV = (PFNGLISCOMMANDLISTNVPROC)proc("glIsCommandListNV");
	gl3wIsEnabled = (PFNGLISENABLEDPROC)proc("glIsEnabled");
	gl3wIsEnabledIndexedEXT = (PFNGLISENABLEDINDEXEDEXTPROC)proc("glIsEnabledIndexedEXT");
	gl3wIsEnabledi = (PFNGLISENABLEDIPROC)proc("glIsEnabledi");
	gl3wIsFramebuffer = (PFNGLISFRAMEBUFFERPROC)proc("glIsFramebuffer");
	gl3wIsImageHandleResidentARB = (PFNGLISIMAGEHANDLERESIDENTARBPROC)proc("glIsImageHandleResidentARB");
	gl3wIsImageHandleResidentNV = (PFNGLISIMAGEHANDLERESIDENTNVPROC)proc("glIsImageHandleResidentNV");
	gl3wIsNamedBufferResidentNV = (PFNGLISNAMEDBUFFERRESIDENTNVPROC)proc("glIsNamedBufferResidentNV");
	gl3wIsNamedStringARB = (PFNGLISNAMEDSTRINGARBPROC)proc("glIsNamedStringARB");
	gl3wIsPathNV = (PFNGLISPATHNVPROC)proc("glIsPathNV");
	gl3wIsPointInFillPathNV = (PFNGLISPOINTINFILLPATHNVPROC)proc("glIsPointInFillPathNV");
	gl3wIsPointInStrokePathNV = (PFNGLISPOINTINSTROKEPATHNVPROC)proc("glIsPointInStrokePathNV");
	gl3wIsProgram = (PFNGLISPROGRAMPROC)proc("glIsProgram");
	gl3wIsProgramPipeline = (PFNGLISPROGRAMPIPELINEPROC)proc("glIsProgramPipeline");
	gl3wIsQuery = (PFNGLISQUERYPROC)proc("glIsQuery");
	gl3wIsRenderbuffer = (PFNGLISRENDERBUFFERPROC)proc("glIsRenderbuffer");
	gl3wIsSampler = (PFNGLISSAMPLERPROC)proc("glIsSampler");
	gl3wIsShader = (PFNGLISSHADERPROC)proc("glIsShader");
	gl3wIsStateNV = (PFNGLISSTATENVPROC)proc("glIsStateNV");
	gl3wIsSync = (PFNGLISSYNCPROC)proc("glIsSync");
	gl3wIsTexture = (PFNGLISTEXTUREPROC)proc("glIsTexture");
	gl3wIsTextureHandleResidentARB = (PFNGLISTEXTUREHANDLERESIDENTARBPROC)proc("glIsTextureHandleResidentARB");
	gl3wIsTextureHandleResidentNV = (PFNGLISTEXTUREHANDLERESIDENTNVPROC)proc("glIsTextureHandleResidentNV");
	gl3wIsTransformFeedback = (PFNGLISTRANSFORMFEEDBACKPROC)proc("glIsTransformFeedback");
	gl3wIsVertexArray = (PFNGLISVERTEXARRAYPROC)proc("glIsVertexArray");
	gl3wLabelObjectEXT = (PFNGLLABELOBJECTEXTPROC)proc("glLabelObjectEXT");
	gl3wLineWidth = (PFNGLLINEWIDTHPROC)proc("glLineWidth");
	gl3wLinkProgram = (PFNGLLINKPROGRAMPROC)proc("glLinkProgram");
	gl3wListDrawCommandsStatesClientNV = (PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC)proc("glListDrawCommandsStatesClientNV");
	gl3wLogicOp = (PFNGLLOGICOPPROC)proc("glLogicOp");
	gl3wMakeBufferNonResidentNV = (PFNGLMAKEBUFFERNONRESIDENTNVPROC)proc("glMakeBufferNonResidentNV");
	gl3wMakeBufferResidentNV = (PFNGLMAKEBUFFERRESIDENTNVPROC)proc("glMakeBufferResidentNV");
	gl3wMakeImageHandleNonResidentARB = (PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC)proc("glMakeImageHandleNonResidentARB");
	gl3wMakeImageHandleNonResidentNV = (PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC)proc("glMakeImageHandleNonResidentNV");
	gl3wMakeImageHandleResidentARB = (PFNGLMAKEIMAGEHANDLERESIDENTARBPROC)proc("glMakeImageHandleResidentARB");
	gl3wMakeImageHandleResidentNV = (PFNGLMAKEIMAGEHANDLERESIDENTNVPROC)proc("glMakeImageHandleResidentNV");
	gl3wMakeNamedBufferNonResidentNV = (PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC)proc("glMakeNamedBufferNonResidentNV");
	gl3wMakeNamedBufferResidentNV = (PFNGLMAKENAMEDBUFFERRESIDENTNVPROC)proc("glMakeNamedBufferResidentNV");
	gl3wMakeTextureHandleNonResidentARB = (PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC)proc("glMakeTextureHandleNonResidentARB");
	gl3wMakeTextureHandleNonResidentNV = (PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC)proc("glMakeTextureHandleNonResidentNV");
	gl3wMakeTextureHandleResidentARB = (PFNGLMAKETEXTUREHANDLERESIDENTARBPROC)proc("glMakeTextureHandleResidentARB");
	gl3wMakeTextureHandleResidentNV = (PFNGLMAKETEXTUREHANDLERESIDENTNVPROC)proc("glMakeTextureHandleResidentNV");
	gl3wMapBuffer = (PFNGLMAPBUFFERPROC)proc("glMapBuffer");
	gl3wMapBufferRange = (PFNGLMAPBUFFERRANGEPROC)proc("glMapBufferRange");
	gl3wMapNamedBuffer = (PFNGLMAPNAMEDBUFFERPROC)proc("glMapNamedBuffer");
	gl3wMapNamedBufferEXT = (PFNGLMAPNAMEDBUFFEREXTPROC)proc("glMapNamedBufferEXT");
	gl3wMapNamedBufferRange = (PFNGLMAPNAMEDBUFFERRANGEPROC)proc("glMapNamedBufferRange");
	gl3wMapNamedBufferRangeEXT = (PFNGLMAPNAMEDBUFFERRANGEEXTPROC)proc("glMapNamedBufferRangeEXT");
	gl3wMatrixFrustumEXT = (PFNGLMATRIXFRUSTUMEXTPROC)proc("glMatrixFrustumEXT");
	gl3wMatrixLoad3x2fNV = (PFNGLMATRIXLOAD3X2FNVPROC)proc("glMatrixLoad3x2fNV");
	gl3wMatrixLoad3x3fNV = (PFNGLMATRIXLOAD3X3FNVPROC)proc("glMatrixLoad3x3fNV");
	gl3wMatrixLoadIdentityEXT = (PFNGLMATRIXLOADIDENTITYEXTPROC)proc("glMatrixLoadIdentityEXT");
	gl3wMatrixLoadTranspose3x3fNV = (PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC)proc("glMatrixLoadTranspose3x3fNV");
	gl3wMatrixLoadTransposedEXT = (PFNGLMATRIXLOADTRANSPOSEDEXTPROC)proc("glMatrixLoadTransposedEXT");
	gl3wMatrixLoadTransposefEXT = (PFNGLMATRIXLOADTRANSPOSEFEXTPROC)proc("glMatrixLoadTransposefEXT");
	gl3wMatrixLoaddEXT = (PFNGLMATRIXLOADDEXTPROC)proc("glMatrixLoaddEXT");
	gl3wMatrixLoadfEXT = (PFNGLMATRIXLOADFEXTPROC)proc("glMatrixLoadfEXT");
	gl3wMatrixMult3x2fNV = (PFNGLMATRIXMULT3X2FNVPROC)proc("glMatrixMult3x2fNV");
	gl3wMatrixMult3x3fNV = (PFNGLMATRIXMULT3X3FNVPROC)proc("glMatrixMult3x3fNV");
	gl3wMatrixMultTranspose3x3fNV = (PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC)proc("glMatrixMultTranspose3x3fNV");
	gl3wMatrixMultTransposedEXT = (PFNGLMATRIXMULTTRANSPOSEDEXTPROC)proc("glMatrixMultTransposedEXT");
	gl3wMatrixMultTransposefEXT = (PFNGLMATRIXMULTTRANSPOSEFEXTPROC)proc("glMatrixMultTransposefEXT");
	gl3wMatrixMultdEXT = (PFNGLMATRIXMULTDEXTPROC)proc("glMatrixMultdEXT");
	gl3wMatrixMultfEXT = (PFNGLMATRIXMULTFEXTPROC)proc("glMatrixMultfEXT");
	gl3wMatrixOrthoEXT = (PFNGLMATRIXORTHOEXTPROC)proc("glMatrixOrthoEXT");
	gl3wMatrixPopEXT = (PFNGLMATRIXPOPEXTPROC)proc("glMatrixPopEXT");
	gl3wMatrixPushEXT = (PFNGLMATRIXPUSHEXTPROC)proc("glMatrixPushEXT");
	gl3wMatrixRotatedEXT = (PFNGLMATRIXROTATEDEXTPROC)proc("glMatrixRotatedEXT");
	gl3wMatrixRotatefEXT = (PFNGLMATRIXROTATEFEXTPROC)proc("glMatrixRotatefEXT");
	gl3wMatrixScaledEXT = (PFNGLMATRIXSCALEDEXTPROC)proc("glMatrixScaledEXT");
	gl3wMatrixScalefEXT = (PFNGLMATRIXSCALEFEXTPROC)proc("glMatrixScalefEXT");
	gl3wMatrixTranslatedEXT = (PFNGLMATRIXTRANSLATEDEXTPROC)proc("glMatrixTranslatedEXT");
	gl3wMatrixTranslatefEXT = (PFNGLMATRIXTRANSLATEFEXTPROC)proc("glMatrixTranslatefEXT");
	gl3wMaxShaderCompilerThreadsARB = (PFNGLMAXSHADERCOMPILERTHREADSARBPROC)proc("glMaxShaderCompilerThreadsARB");
	gl3wMemoryBarrier = (PFNGLMEMORYBARRIERPROC)proc("glMemoryBarrier");
	gl3wMemoryBarrierByRegion = (PFNGLMEMORYBARRIERBYREGIONPROC)proc("glMemoryBarrierByRegion");
	gl3wMinSampleShading = (PFNGLMINSAMPLESHADINGPROC)proc("glMinSampleShading");
	gl3wMinSampleShadingARB = (PFNGLMINSAMPLESHADINGARBPROC)proc("glMinSampleShadingARB");
	gl3wMultiDrawArrays = (PFNGLMULTIDRAWARRAYSPROC)proc("glMultiDrawArrays");
	gl3wMultiDrawArraysIndirect = (PFNGLMULTIDRAWARRAYSINDIRECTPROC)proc("glMultiDrawArraysIndirect");
	gl3wMultiDrawArraysIndirectBindlessCountNV = (PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC)proc("glMultiDrawArraysIndirectBindlessCountNV");
	gl3wMultiDrawArraysIndirectBindlessNV = (PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC)proc("glMultiDrawArraysIndirectBindlessNV");
	gl3wMultiDrawArraysIndirectCountARB = (PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC)proc("glMultiDrawArraysIndirectCountARB");
	gl3wMultiDrawElements = (PFNGLMULTIDRAWELEMENTSPROC)proc("glMultiDrawElements");
	gl3wMultiDrawElementsBaseVertex = (PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC)proc("glMultiDrawElementsBaseVertex");
	gl3wMultiDrawElementsIndirect = (PFNGLMULTIDRAWELEMENTSINDIRECTPROC)proc("glMultiDrawElementsIndirect");
	gl3wMultiDrawElementsIndirectBindlessCountNV = (PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC)proc("glMultiDrawElementsIndirectBindlessCountNV");
	gl3wMultiDrawElementsIndirectBindlessNV = (PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC)proc("glMultiDrawElementsIndirectBindlessNV");
	gl3wMultiDrawElementsIndirectCountARB = (PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC)proc("glMultiDrawElementsIndirectCountARB");
	gl3wMultiTexBufferEXT = (PFNGLMULTITEXBUFFEREXTPROC)proc("glMultiTexBufferEXT");
	gl3wMultiTexCoordPointerEXT = (PFNGLMULTITEXCOORDPOINTEREXTPROC)proc("glMultiTexCoordPointerEXT");
	gl3wMultiTexEnvfEXT = (PFNGLMULTITEXENVFEXTPROC)proc("glMultiTexEnvfEXT");
	gl3wMultiTexEnvfvEXT = (PFNGLMULTITEXENVFVEXTPROC)proc("glMultiTexEnvfvEXT");
	gl3wMultiTexEnviEXT = (PFNGLMULTITEXENVIEXTPROC)proc("glMultiTexEnviEXT");
	gl3wMultiTexEnvivEXT = (PFNGLMULTITEXENVIVEXTPROC)proc("glMultiTexEnvivEXT");
	gl3wMultiTexGendEXT = (PFNGLMULTITEXGENDEXTPROC)proc("glMultiTexGendEXT");
	gl3wMultiTexGendvEXT = (PFNGLMULTITEXGENDVEXTPROC)proc("glMultiTexGendvEXT");
	gl3wMultiTexGenfEXT = (PFNGLMULTITEXGENFEXTPROC)proc("glMultiTexGenfEXT");
	gl3wMultiTexGenfvEXT = (PFNGLMULTITEXGENFVEXTPROC)proc("glMultiTexGenfvEXT");
	gl3wMultiTexGeniEXT = (PFNGLMULTITEXGENIEXTPROC)proc("glMultiTexGeniEXT");
	gl3wMultiTexGenivEXT = (PFNGLMULTITEXGENIVEXTPROC)proc("glMultiTexGenivEXT");
	gl3wMultiTexImage1DEXT = (PFNGLMULTITEXIMAGE1DEXTPROC)proc("glMultiTexImage1DEXT");
	gl3wMultiTexImage2DEXT = (PFNGLMULTITEXIMAGE2DEXTPROC)proc("glMultiTexImage2DEXT");
	gl3wMultiTexImage3DEXT = (PFNGLMULTITEXIMAGE3DEXTPROC)proc("glMultiTexImage3DEXT");
	gl3wMultiTexParameterIivEXT = (PFNGLMULTITEXPARAMETERIIVEXTPROC)proc("glMultiTexParameterIivEXT");
	gl3wMultiTexParameterIuivEXT = (PFNGLMULTITEXPARAMETERIUIVEXTPROC)proc("glMultiTexParameterIuivEXT");
	gl3wMultiTexParameterfEXT = (PFNGLMULTITEXPARAMETERFEXTPROC)proc("glMultiTexParameterfEXT");
	gl3wMultiTexParameterfvEXT = (PFNGLMULTITEXPARAMETERFVEXTPROC)proc("glMultiTexParameterfvEXT");
	gl3wMultiTexParameteriEXT = (PFNGLMULTITEXPARAMETERIEXTPROC)proc("glMultiTexParameteriEXT");
	gl3wMultiTexParameterivEXT = (PFNGLMULTITEXPARAMETERIVEXTPROC)proc("glMultiTexParameterivEXT");
	gl3wMultiTexRenderbufferEXT = (PFNGLMULTITEXRENDERBUFFEREXTPROC)proc("glMultiTexRenderbufferEXT");
	gl3wMultiTexSubImage1DEXT = (PFNGLMULTITEXSUBIMAGE1DEXTPROC)proc("glMultiTexSubImage1DEXT");
	gl3wMultiTexSubImage2DEXT = (PFNGLMULTITEXSUBIMAGE2DEXTPROC)proc("glMultiTexSubImage2DEXT");
	gl3wMultiTexSubImage3DEXT = (PFNGLMULTITEXSUBIMAGE3DEXTPROC)proc("glMultiTexSubImage3DEXT");
	gl3wNamedBufferData = (PFNGLNAMEDBUFFERDATAPROC)proc("glNamedBufferData");
	gl3wNamedBufferDataEXT = (PFNGLNAMEDBUFFERDATAEXTPROC)proc("glNamedBufferDataEXT");
	gl3wNamedBufferPageCommitmentARB = (PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC)proc("glNamedBufferPageCommitmentARB");
	gl3wNamedBufferPageCommitmentEXT = (PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC)proc("glNamedBufferPageCommitmentEXT");
	gl3wNamedBufferStorage = (PFNGLNAMEDBUFFERSTORAGEPROC)proc("glNamedBufferStorage");
	gl3wNamedBufferStorageEXT = (PFNGLNAMEDBUFFERSTORAGEEXTPROC)proc("glNamedBufferStorageEXT");
	gl3wNamedBufferSubData = (PFNGLNAMEDBUFFERSUBDATAPROC)proc("glNamedBufferSubData");
	gl3wNamedBufferSubDataEXT = (PFNGLNAMEDBUFFERSUBDATAEXTPROC)proc("glNamedBufferSubDataEXT");
	gl3wNamedCopyBufferSubDataEXT = (PFNGLNAMEDCOPYBUFFERSUBDATAEXTPROC)proc("glNamedCopyBufferSubDataEXT");
	gl3wNamedFramebufferDrawBuffer = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC)proc("glNamedFramebufferDrawBuffer");
	gl3wNamedFramebufferDrawBuffers = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC)proc("glNamedFramebufferDrawBuffers");
	gl3wNamedFramebufferParameteri = (PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC)proc("glNamedFramebufferParameteri");
	gl3wNamedFramebufferParameteriEXT = (PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC)proc("glNamedFramebufferParameteriEXT");
	gl3wNamedFramebufferReadBuffer = (PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC)proc("glNamedFramebufferReadBuffer");
	gl3wNamedFramebufferRenderbuffer = (PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC)proc("glNamedFramebufferRenderbuffer");
	gl3wNamedFramebufferRenderbufferEXT = (PFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC)proc("glNamedFramebufferRenderbufferEXT");
	gl3wNamedFramebufferSampleLocationsfvARB = (PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVARBPROC)proc("glNamedFramebufferSampleLocationsfvARB");
	gl3wNamedFramebufferSampleLocationsfvNV = (PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC)proc("glNamedFramebufferSampleLocationsfvNV");
	gl3wNamedFramebufferTexture = (PFNGLNAMEDFRAMEBUFFERTEXTUREPROC)proc("glNamedFramebufferTexture");
	gl3wNamedFramebufferTexture1DEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC)proc("glNamedFramebufferTexture1DEXT");
	gl3wNamedFramebufferTexture2DEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC)proc("glNamedFramebufferTexture2DEXT");
	gl3wNamedFramebufferTexture3DEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC)proc("glNamedFramebufferTexture3DEXT");
	gl3wNamedFramebufferTextureEXT = (PFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC)proc("glNamedFramebufferTextureEXT");
	gl3wNamedFramebufferTextureFaceEXT = (PFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC)proc("glNamedFramebufferTextureFaceEXT");
	gl3wNamedFramebufferTextureLayer = (PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC)proc("glNamedFramebufferTextureLayer");
	gl3wNamedFramebufferTextureLayerEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC)proc("glNamedFramebufferTextureLayerEXT");
	gl3wNamedProgramLocalParameter4dEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC)proc("glNamedProgramLocalParameter4dEXT");
	gl3wNamedProgramLocalParameter4dvEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC)proc("glNamedProgramLocalParameter4dvEXT");
	gl3wNamedProgramLocalParameter4fEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC)proc("glNamedProgramLocalParameter4fEXT");
	gl3wNamedProgramLocalParameter4fvEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC)proc("glNamedProgramLocalParameter4fvEXT");
	gl3wNamedProgramLocalParameterI4iEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC)proc("glNamedProgramLocalParameterI4iEXT");
	gl3wNamedProgramLocalParameterI4ivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC)proc("glNamedProgramLocalParameterI4ivEXT");
	gl3wNamedProgramLocalParameterI4uiEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC)proc("glNamedProgramLocalParameterI4uiEXT");
	gl3wNamedProgramLocalParameterI4uivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC)proc("glNamedProgramLocalParameterI4uivEXT");
	gl3wNamedProgramLocalParameters4fvEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC)proc("glNamedProgramLocalParameters4fvEXT");
	gl3wNamedProgramLocalParametersI4ivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC)proc("glNamedProgramLocalParametersI4ivEXT");
	gl3wNamedProgramLocalParametersI4uivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC)proc("glNamedProgramLocalParametersI4uivEXT");
	gl3wNamedProgramStringEXT = (PFNGLNAMEDPROGRAMSTRINGEXTPROC)proc("glNamedProgramStringEXT");
	gl3wNamedRenderbufferStorage = (PFNGLNAMEDRENDERBUFFERSTORAGEPROC)proc("glNamedRenderbufferStorage");
	gl3wNamedRenderbufferStorageEXT = (PFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC)proc("glNamedRenderbufferStorageEXT");
	gl3wNamedRenderbufferStorageMultisample = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC)proc("glNamedRenderbufferStorageMultisample");
	gl3wNamedRenderbufferStorageMultisampleCoverageEXT = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC)proc("glNamedRenderbufferStorageMultisampleCoverageEXT");
	gl3wNamedRenderbufferStorageMultisampleEXT = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC)proc("glNamedRenderbufferStorageMultisampleEXT");
	gl3wNamedStringARB = (PFNGLNAMEDSTRINGARBPROC)proc("glNamedStringARB");
	gl3wNormalFormatNV = (PFNGLNORMALFORMATNVPROC)proc("glNormalFormatNV");
	gl3wObjectLabel = (PFNGLOBJECTLABELPROC)proc("glObjectLabel");
	gl3wObjectPtrLabel = (PFNGLOBJECTPTRLABELPROC)proc("glObjectPtrLabel");
	gl3wPatchParameterfv = (PFNGLPATCHPARAMETERFVPROC)proc("glPatchParameterfv");
	gl3wPatchParameteri = (PFNGLPATCHPARAMETERIPROC)proc("glPatchParameteri");
	gl3wPathCommandsNV = (PFNGLPATHCOMMANDSNVPROC)proc("glPathCommandsNV");
	gl3wPathCoordsNV = (PFNGLPATHCOORDSNVPROC)proc("glPathCoordsNV");
	gl3wPathCoverDepthFuncNV = (PFNGLPATHCOVERDEPTHFUNCNVPROC)proc("glPathCoverDepthFuncNV");
	gl3wPathDashArrayNV = (PFNGLPATHDASHARRAYNVPROC)proc("glPathDashArrayNV");
	gl3wPathGlyphIndexArrayNV = (PFNGLPATHGLYPHINDEXARRAYNVPROC)proc("glPathGlyphIndexArrayNV");
	gl3wPathGlyphIndexRangeNV = (PFNGLPATHGLYPHINDEXRANGENVPROC)proc("glPathGlyphIndexRangeNV");
	gl3wPathGlyphRangeNV = (PFNGLPATHGLYPHRANGENVPROC)proc("glPathGlyphRangeNV");
	gl3wPathGlyphsNV = (PFNGLPATHGLYPHSNVPROC)proc("glPathGlyphsNV");
	gl3wPathMemoryGlyphIndexArrayNV = (PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC)proc("glPathMemoryGlyphIndexArrayNV");
	gl3wPathParameterfNV = (PFNGLPATHPARAMETERFNVPROC)proc("glPathParameterfNV");
	gl3wPathParameterfvNV = (PFNGLPATHPARAMETERFVNVPROC)proc("glPathParameterfvNV");
	gl3wPathParameteriNV = (PFNGLPATHPARAMETERINVPROC)proc("glPathParameteriNV");
	gl3wPathParameterivNV = (PFNGLPATHPARAMETERIVNVPROC)proc("glPathParameterivNV");
	gl3wPathStencilDepthOffsetNV = (PFNGLPATHSTENCILDEPTHOFFSETNVPROC)proc("glPathStencilDepthOffsetNV");
	gl3wPathStencilFuncNV = (PFNGLPATHSTENCILFUNCNVPROC)proc("glPathStencilFuncNV");
	gl3wPathStringNV = (PFNGLPATHSTRINGNVPROC)proc("glPathStringNV");
	gl3wPathSubCommandsNV = (PFNGLPATHSUBCOMMANDSNVPROC)proc("glPathSubCommandsNV");
	gl3wPathSubCoordsNV = (PFNGLPATHSUBCOORDSNVPROC)proc("glPathSubCoordsNV");
	gl3wPauseTransformFeedback = (PFNGLPAUSETRANSFORMFEEDBACKPROC)proc("glPauseTransformFeedback");
	gl3wPixelStoref = (PFNGLPIXELSTOREFPROC)proc("glPixelStoref");
	gl3wPixelStorei = (PFNGLPIXELSTOREIPROC)proc("glPixelStorei");
	gl3wPointAlongPathNV = (PFNGLPOINTALONGPATHNVPROC)proc("glPointAlongPathNV");
	gl3wPointParameterf = (PFNGLPOINTPARAMETERFPROC)proc("glPointParameterf");
	gl3wPointParameterfv = (PFNGLPOINTPARAMETERFVPROC)proc("glPointParameterfv");
	gl3wPointParameteri = (PFNGLPOINTPARAMETERIPROC)proc("glPointParameteri");
	gl3wPointParameteriv = (PFNGLPOINTPARAMETERIVPROC)proc("glPointParameteriv");
	gl3wPointSize = (PFNGLPOINTSIZEPROC)proc("glPointSize");
	gl3wPolygonMode = (PFNGLPOLYGONMODEPROC)proc("glPolygonMode");
	gl3wPolygonOffset = (PFNGLPOLYGONOFFSETPROC)proc("glPolygonOffset");
	gl3wPolygonOffsetClampEXT = (PFNGLPOLYGONOFFSETCLAMPEXTPROC)proc("glPolygonOffsetClampEXT");
	gl3wPopDebugGroup = (PFNGLPOPDEBUGGROUPPROC)proc("glPopDebugGroup");
	gl3wPopGroupMarkerEXT = (PFNGLPOPGROUPMARKEREXTPROC)proc("glPopGroupMarkerEXT");
	gl3wPrimitiveBoundingBoxARB = (PFNGLPRIMITIVEBOUNDINGBOXARBPROC)proc("glPrimitiveBoundingBoxARB");
	gl3wPrimitiveRestartIndex = (PFNGLPRIMITIVERESTARTINDEXPROC)proc("glPrimitiveRestartIndex");
	gl3wProgramBinary = (PFNGLPROGRAMBINARYPROC)proc("glProgramBinary");
	gl3wProgramParameteri = (PFNGLPROGRAMPARAMETERIPROC)proc("glProgramParameteri");
	gl3wProgramParameteriARB = (PFNGLPROGRAMPARAMETERIARBPROC)proc("glProgramParameteriARB");
	gl3wProgramPathFragmentInputGenNV = (PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC)proc("glProgramPathFragmentInputGenNV");
	gl3wProgramUniform1d = (PFNGLPROGRAMUNIFORM1DPROC)proc("glProgramUniform1d");
	gl3wProgramUniform1dEXT = (PFNGLPROGRAMUNIFORM1DEXTPROC)proc("glProgramUniform1dEXT");
	gl3wProgramUniform1dv = (PFNGLPROGRAMUNIFORM1DVPROC)proc("glProgramUniform1dv");
	gl3wProgramUniform1dvEXT = (PFNGLPROGRAMUNIFORM1DVEXTPROC)proc("glProgramUniform1dvEXT");
	gl3wProgramUniform1f = (PFNGLPROGRAMUNIFORM1FPROC)proc("glProgramUniform1f");
	gl3wProgramUniform1fEXT = (PFNGLPROGRAMUNIFORM1FEXTPROC)proc("glProgramUniform1fEXT");
	gl3wProgramUniform1fv = (PFNGLPROGRAMUNIFORM1FVPROC)proc("glProgramUniform1fv");
	gl3wProgramUniform1fvEXT = (PFNGLPROGRAMUNIFORM1FVEXTPROC)proc("glProgramUniform1fvEXT");
	gl3wProgramUniform1i = (PFNGLPROGRAMUNIFORM1IPROC)proc("glProgramUniform1i");
	gl3wProgramUniform1i64ARB = (PFNGLPROGRAMUNIFORM1I64ARBPROC)proc("glProgramUniform1i64ARB");
	gl3wProgramUniform1i64NV = (PFNGLPROGRAMUNIFORM1I64NVPROC)proc("glProgramUniform1i64NV");
	gl3wProgramUniform1i64vARB = (PFNGLPROGRAMUNIFORM1I64VARBPROC)proc("glProgramUniform1i64vARB");
	gl3wProgramUniform1i64vNV = (PFNGLPROGRAMUNIFORM1I64VNVPROC)proc("glProgramUniform1i64vNV");
	gl3wProgramUniform1iEXT = (PFNGLPROGRAMUNIFORM1IEXTPROC)proc("glProgramUniform1iEXT");
	gl3wProgramUniform1iv = (PFNGLPROGRAMUNIFORM1IVPROC)proc("glProgramUniform1iv");
	gl3wProgramUniform1ivEXT = (PFNGLPROGRAMUNIFORM1IVEXTPROC)proc("glProgramUniform1ivEXT");
	gl3wProgramUniform1ui = (PFNGLPROGRAMUNIFORM1UIPROC)proc("glProgramUniform1ui");
	gl3wProgramUniform1ui64ARB = (PFNGLPROGRAMUNIFORM1UI64ARBPROC)proc("glProgramUniform1ui64ARB");
	gl3wProgramUniform1ui64NV = (PFNGLPROGRAMUNIFORM1UI64NVPROC)proc("glProgramUniform1ui64NV");
	gl3wProgramUniform1ui64vARB = (PFNGLPROGRAMUNIFORM1UI64VARBPROC)proc("glProgramUniform1ui64vARB");
	gl3wProgramUniform1ui64vNV = (PFNGLPROGRAMUNIFORM1UI64VNVPROC)proc("glProgramUniform1ui64vNV");
	gl3wProgramUniform1uiEXT = (PFNGLPROGRAMUNIFORM1UIEXTPROC)proc("glProgramUniform1uiEXT");
	gl3wProgramUniform1uiv = (PFNGLPROGRAMUNIFORM1UIVPROC)proc("glProgramUniform1uiv");
	gl3wProgramUniform1uivEXT = (PFNGLPROGRAMUNIFORM1UIVEXTPROC)proc("glProgramUniform1uivEXT");
	gl3wProgramUniform2d = (PFNGLPROGRAMUNIFORM2DPROC)proc("glProgramUniform2d");
	gl3wProgramUniform2dEXT = (PFNGLPROGRAMUNIFORM2DEXTPROC)proc("glProgramUniform2dEXT");
	gl3wProgramUniform2dv = (PFNGLPROGRAMUNIFORM2DVPROC)proc("glProgramUniform2dv");
	gl3wProgramUniform2dvEXT = (PFNGLPROGRAMUNIFORM2DVEXTPROC)proc("glProgramUniform2dvEXT");
	gl3wProgramUniform2f = (PFNGLPROGRAMUNIFORM2FPROC)proc("glProgramUniform2f");
	gl3wProgramUniform2fEXT = (PFNGLPROGRAMUNIFORM2FEXTPROC)proc("glProgramUniform2fEXT");
	gl3wProgramUniform2fv = (PFNGLPROGRAMUNIFORM2FVPROC)proc("glProgramUniform2fv");
	gl3wProgramUniform2fvEXT = (PFNGLPROGRAMUNIFORM2FVEXTPROC)proc("glProgramUniform2fvEXT");
	gl3wProgramUniform2i = (PFNGLPROGRAMUNIFORM2IPROC)proc("glProgramUniform2i");
	gl3wProgramUniform2i64ARB = (PFNGLPROGRAMUNIFORM2I64ARBPROC)proc("glProgramUniform2i64ARB");
	gl3wProgramUniform2i64NV = (PFNGLPROGRAMUNIFORM2I64NVPROC)proc("glProgramUniform2i64NV");
	gl3wProgramUniform2i64vARB = (PFNGLPROGRAMUNIFORM2I64VARBPROC)proc("glProgramUniform2i64vARB");
	gl3wProgramUniform2i64vNV = (PFNGLPROGRAMUNIFORM2I64VNVPROC)proc("glProgramUniform2i64vNV");
	gl3wProgramUniform2iEXT = (PFNGLPROGRAMUNIFORM2IEXTPROC)proc("glProgramUniform2iEXT");
	gl3wProgramUniform2iv = (PFNGLPROGRAMUNIFORM2IVPROC)proc("glProgramUniform2iv");
	gl3wProgramUniform2ivEXT = (PFNGLPROGRAMUNIFORM2IVEXTPROC)proc("glProgramUniform2ivEXT");
	gl3wProgramUniform2ui = (PFNGLPROGRAMUNIFORM2UIPROC)proc("glProgramUniform2ui");
	gl3wProgramUniform2ui64ARB = (PFNGLPROGRAMUNIFORM2UI64ARBPROC)proc("glProgramUniform2ui64ARB");
	gl3wProgramUniform2ui64NV = (PFNGLPROGRAMUNIFORM2UI64NVPROC)proc("glProgramUniform2ui64NV");
	gl3wProgramUniform2ui64vARB = (PFNGLPROGRAMUNIFORM2UI64VARBPROC)proc("glProgramUniform2ui64vARB");
	gl3wProgramUniform2ui64vNV = (PFNGLPROGRAMUNIFORM2UI64VNVPROC)proc("glProgramUniform2ui64vNV");
	gl3wProgramUniform2uiEXT = (PFNGLPROGRAMUNIFORM2UIEXTPROC)proc("glProgramUniform2uiEXT");
	gl3wProgramUniform2uiv = (PFNGLPROGRAMUNIFORM2UIVPROC)proc("glProgramUniform2uiv");
	gl3wProgramUniform2uivEXT = (PFNGLPROGRAMUNIFORM2UIVEXTPROC)proc("glProgramUniform2uivEXT");
	gl3wProgramUniform3d = (PFNGLPROGRAMUNIFORM3DPROC)proc("glProgramUniform3d");
	gl3wProgramUniform3dEXT = (PFNGLPROGRAMUNIFORM3DEXTPROC)proc("glProgramUniform3dEXT");
	gl3wProgramUniform3dv = (PFNGLPROGRAMUNIFORM3DVPROC)proc("glProgramUniform3dv");
	gl3wProgramUniform3dvEXT = (PFNGLPROGRAMUNIFORM3DVEXTPROC)proc("glProgramUniform3dvEXT");
	gl3wProgramUniform3f = (PFNGLPROGRAMUNIFORM3FPROC)proc("glProgramUniform3f");
	gl3wProgramUniform3fEXT = (PFNGLPROGRAMUNIFORM3FEXTPROC)proc("glProgramUniform3fEXT");
	gl3wProgramUniform3fv = (PFNGLPROGRAMUNIFORM3FVPROC)proc("glProgramUniform3fv");
	gl3wProgramUniform3fvEXT = (PFNGLPROGRAMUNIFORM3FVEXTPROC)proc("glProgramUniform3fvEXT");
	gl3wProgramUniform3i = (PFNGLPROGRAMUNIFORM3IPROC)proc("glProgramUniform3i");
	gl3wProgramUniform3i64ARB = (PFNGLPROGRAMUNIFORM3I64ARBPROC)proc("glProgramUniform3i64ARB");
	gl3wProgramUniform3i64NV = (PFNGLPROGRAMUNIFORM3I64NVPROC)proc("glProgramUniform3i64NV");
	gl3wProgramUniform3i64vARB = (PFNGLPROGRAMUNIFORM3I64VARBPROC)proc("glProgramUniform3i64vARB");
	gl3wProgramUniform3i64vNV = (PFNGLPROGRAMUNIFORM3I64VNVPROC)proc("glProgramUniform3i64vNV");
	gl3wProgramUniform3iEXT = (PFNGLPROGRAMUNIFORM3IEXTPROC)proc("glProgramUniform3iEXT");
	gl3wProgramUniform3iv = (PFNGLPROGRAMUNIFORM3IVPROC)proc("glProgramUniform3iv");
	gl3wProgramUniform3ivEXT = (PFNGLPROGRAMUNIFORM3IVEXTPROC)proc("glProgramUniform3ivEXT");
	gl3wProgramUniform3ui = (PFNGLPROGRAMUNIFORM3UIPROC)proc("glProgramUniform3ui");
	gl3wProgramUniform3ui64ARB = (PFNGLPROGRAMUNIFORM3UI64ARBPROC)proc("glProgramUniform3ui64ARB");
	gl3wProgramUniform3ui64NV = (PFNGLPROGRAMUNIFORM3UI64NVPROC)proc("glProgramUniform3ui64NV");
	gl3wProgramUniform3ui64vARB = (PFNGLPROGRAMUNIFORM3UI64VARBPROC)proc("glProgramUniform3ui64vARB");
	gl3wProgramUniform3ui64vNV = (PFNGLPROGRAMUNIFORM3UI64VNVPROC)proc("glProgramUniform3ui64vNV");
	gl3wProgramUniform3uiEXT = (PFNGLPROGRAMUNIFORM3UIEXTPROC)proc("glProgramUniform3uiEXT");
	gl3wProgramUniform3uiv = (PFNGLPROGRAMUNIFORM3UIVPROC)proc("glProgramUniform3uiv");
	gl3wProgramUniform3uivEXT = (PFNGLPROGRAMUNIFORM3UIVEXTPROC)proc("glProgramUniform3uivEXT");
	gl3wProgramUniform4d = (PFNGLPROGRAMUNIFORM4DPROC)proc("glProgramUniform4d");
	gl3wProgramUniform4dEXT = (PFNGLPROGRAMUNIFORM4DEXTPROC)proc("glProgramUniform4dEXT");
	gl3wProgramUniform4dv = (PFNGLPROGRAMUNIFORM4DVPROC)proc("glProgramUniform4dv");
	gl3wProgramUniform4dvEXT = (PFNGLPROGRAMUNIFORM4DVEXTPROC)proc("glProgramUniform4dvEXT");
	gl3wProgramUniform4f = (PFNGLPROGRAMUNIFORM4FPROC)proc("glProgramUniform4f");
	gl3wProgramUniform4fEXT = (PFNGLPROGRAMUNIFORM4FEXTPROC)proc("glProgramUniform4fEXT");
	gl3wProgramUniform4fv = (PFNGLPROGRAMUNIFORM4FVPROC)proc("glProgramUniform4fv");
	gl3wProgramUniform4fvEXT = (PFNGLPROGRAMUNIFORM4FVEXTPROC)proc("glProgramUniform4fvEXT");
	gl3wProgramUniform4i = (PFNGLPROGRAMUNIFORM4IPROC)proc("glProgramUniform4i");
	gl3wProgramUniform4i64ARB = (PFNGLPROGRAMUNIFORM4I64ARBPROC)proc("glProgramUniform4i64ARB");
	gl3wProgramUniform4i64NV = (PFNGLPROGRAMUNIFORM4I64NVPROC)proc("glProgramUniform4i64NV");
	gl3wProgramUniform4i64vARB = (PFNGLPROGRAMUNIFORM4I64VARBPROC)proc("glProgramUniform4i64vARB");
	gl3wProgramUniform4i64vNV = (PFNGLPROGRAMUNIFORM4I64VNVPROC)proc("glProgramUniform4i64vNV");
	gl3wProgramUniform4iEXT = (PFNGLPROGRAMUNIFORM4IEXTPROC)proc("glProgramUniform4iEXT");
	gl3wProgramUniform4iv = (PFNGLPROGRAMUNIFORM4IVPROC)proc("glProgramUniform4iv");
	gl3wProgramUniform4ivEXT = (PFNGLPROGRAMUNIFORM4IVEXTPROC)proc("glProgramUniform4ivEXT");
	gl3wProgramUniform4ui = (PFNGLPROGRAMUNIFORM4UIPROC)proc("glProgramUniform4ui");
	gl3wProgramUniform4ui64ARB = (PFNGLPROGRAMUNIFORM4UI64ARBPROC)proc("glProgramUniform4ui64ARB");
	gl3wProgramUniform4ui64NV = (PFNGLPROGRAMUNIFORM4UI64NVPROC)proc("glProgramUniform4ui64NV");
	gl3wProgramUniform4ui64vARB = (PFNGLPROGRAMUNIFORM4UI64VARBPROC)proc("glProgramUniform4ui64vARB");
	gl3wProgramUniform4ui64vNV = (PFNGLPROGRAMUNIFORM4UI64VNVPROC)proc("glProgramUniform4ui64vNV");
	gl3wProgramUniform4uiEXT = (PFNGLPROGRAMUNIFORM4UIEXTPROC)proc("glProgramUniform4uiEXT");
	gl3wProgramUniform4uiv = (PFNGLPROGRAMUNIFORM4UIVPROC)proc("glProgramUniform4uiv");
	gl3wProgramUniform4uivEXT = (PFNGLPROGRAMUNIFORM4UIVEXTPROC)proc("glProgramUniform4uivEXT");
	gl3wProgramUniformHandleui64ARB = (PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC)proc("glProgramUniformHandleui64ARB");
	gl3wProgramUniformHandleui64NV = (PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC)proc("glProgramUniformHandleui64NV");
	gl3wProgramUniformHandleui64vARB = (PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC)proc("glProgramUniformHandleui64vARB");
	gl3wProgramUniformHandleui64vNV = (PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC)proc("glProgramUniformHandleui64vNV");
	gl3wProgramUniformMatrix2dv = (PFNGLPROGRAMUNIFORMMATRIX2DVPROC)proc("glProgramUniformMatrix2dv");
	gl3wProgramUniformMatrix2dvEXT = (PFNGLPROGRAMUNIFORMMATRIX2DVEXTPROC)proc("glProgramUniformMatrix2dvEXT");
	gl3wProgramUniformMatrix2fv = (PFNGLPROGRAMUNIFORMMATRIX2FVPROC)proc("glProgramUniformMatrix2fv");
	gl3wProgramUniformMatrix2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC)proc("glProgramUniformMatrix2fvEXT");
	gl3wProgramUniformMatrix2x3dv = (PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC)proc("glProgramUniformMatrix2x3dv");
	gl3wProgramUniformMatrix2x3dvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X3DVEXTPROC)proc("glProgramUniformMatrix2x3dvEXT");
	gl3wProgramUniformMatrix2x3fv = (PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC)proc("glProgramUniformMatrix2x3fv");
	gl3wProgramUniformMatrix2x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC)proc("glProgramUniformMatrix2x3fvEXT");
	gl3wProgramUniformMatrix2x4dv = (PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC)proc("glProgramUniformMatrix2x4dv");
	gl3wProgramUniformMatrix2x4dvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X4DVEXTPROC)proc("glProgramUniformMatrix2x4dvEXT");
	gl3wProgramUniformMatrix2x4fv = (PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC)proc("glProgramUniformMatrix2x4fv");
	gl3wProgramUniformMatrix2x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC)proc("glProgramUniformMatrix2x4fvEXT");
	gl3wProgramUniformMatrix3dv = (PFNGLPROGRAMUNIFORMMATRIX3DVPROC)proc("glProgramUniformMatrix3dv");
	gl3wProgramUniformMatrix3dvEXT = (PFNGLPROGRAMUNIFORMMATRIX3DVEXTPROC)proc("glProgramUniformMatrix3dvEXT");
	gl3wProgramUniformMatrix3fv = (PFNGLPROGRAMUNIFORMMATRIX3FVPROC)proc("glProgramUniformMatrix3fv");
	gl3wProgramUniformMatrix3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC)proc("glProgramUniformMatrix3fvEXT");
	gl3wProgramUniformMatrix3x2dv = (PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC)proc("glProgramUniformMatrix3x2dv");
	gl3wProgramUniformMatrix3x2dvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X2DVEXTPROC)proc("glProgramUniformMatrix3x2dvEXT");
	gl3wProgramUniformMatrix3x2fv = (PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC)proc("glProgramUniformMatrix3x2fv");
	gl3wProgramUniformMatrix3x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC)proc("glProgramUniformMatrix3x2fvEXT");
	gl3wProgramUniformMatrix3x4dv = (PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC)proc("glProgramUniformMatrix3x4dv");
	gl3wProgramUniformMatrix3x4dvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X4DVEXTPROC)proc("glProgramUniformMatrix3x4dvEXT");
	gl3wProgramUniformMatrix3x4fv = (PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC)proc("glProgramUniformMatrix3x4fv");
	gl3wProgramUniformMatrix3x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC)proc("glProgramUniformMatrix3x4fvEXT");
	gl3wProgramUniformMatrix4dv = (PFNGLPROGRAMUNIFORMMATRIX4DVPROC)proc("glProgramUniformMatrix4dv");
	gl3wProgramUniformMatrix4dvEXT = (PFNGLPROGRAMUNIFORMMATRIX4DVEXTPROC)proc("glProgramUniformMatrix4dvEXT");
	gl3wProgramUniformMatrix4fv = (PFNGLPROGRAMUNIFORMMATRIX4FVPROC)proc("glProgramUniformMatrix4fv");
	gl3wProgramUniformMatrix4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC)proc("glProgramUniformMatrix4fvEXT");
	gl3wProgramUniformMatrix4x2dv = (PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC)proc("glProgramUniformMatrix4x2dv");
	gl3wProgramUniformMatrix4x2dvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X2DVEXTPROC)proc("glProgramUniformMatrix4x2dvEXT");
	gl3wProgramUniformMatrix4x2fv = (PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC)proc("glProgramUniformMatrix4x2fv");
	gl3wProgramUniformMatrix4x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC)proc("glProgramUniformMatrix4x2fvEXT");
	gl3wProgramUniformMatrix4x3dv = (PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC)proc("glProgramUniformMatrix4x3dv");
	gl3wProgramUniformMatrix4x3dvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X3DVEXTPROC)proc("glProgramUniformMatrix4x3dvEXT");
	gl3wProgramUniformMatrix4x3fv = (PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC)proc("glProgramUniformMatrix4x3fv");
	gl3wProgramUniformMatrix4x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC)proc("glProgramUniformMatrix4x3fvEXT");
	gl3wProgramUniformui64NV = (PFNGLPROGRAMUNIFORMUI64NVPROC)proc("glProgramUniformui64NV");
	gl3wProgramUniformui64vNV = (PFNGLPROGRAMUNIFORMUI64VNVPROC)proc("glProgramUniformui64vNV");
	gl3wProvokingVertex = (PFNGLPROVOKINGVERTEXPROC)proc("glProvokingVertex");
	gl3wPushClientAttribDefaultEXT = (PFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC)proc("glPushClientAttribDefaultEXT");
	gl3wPushDebugGroup = (PFNGLPUSHDEBUGGROUPPROC)proc("glPushDebugGroup");
	gl3wPushGroupMarkerEXT = (PFNGLPUSHGROUPMARKEREXTPROC)proc("glPushGroupMarkerEXT");
	gl3wQueryCounter = (PFNGLQUERYCOUNTERPROC)proc("glQueryCounter");
	gl3wRasterSamplesEXT = (PFNGLRASTERSAMPLESEXTPROC)proc("glRasterSamplesEXT");
	gl3wReadBuffer = (PFNGLREADBUFFERPROC)proc("glReadBuffer");
	gl3wReadPixels = (PFNGLREADPIXELSPROC)proc("glReadPixels");
	gl3wReadnPixels = (PFNGLREADNPIXELSPROC)proc("glReadnPixels");
	gl3wReadnPixelsARB = (PFNGLREADNPIXELSARBPROC)proc("glReadnPixelsARB");
	gl3wReleaseShaderCompiler = (PFNGLRELEASESHADERCOMPILERPROC)proc("glReleaseShaderCompiler");
	gl3wRenderbufferStorage = (PFNGLRENDERBUFFERSTORAGEPROC)proc("glRenderbufferStorage");
	gl3wRenderbufferStorageMultisample = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC)proc("glRenderbufferStorageMultisample");
	gl3wRenderbufferStorageMultisampleCoverageNV = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC)proc("glRenderbufferStorageMultisampleCoverageNV");
	gl3wResolveDepthValuesNV = (PFNGLRESOLVEDEPTHVALUESNVPROC)proc("glResolveDepthValuesNV");
	gl3wResumeTransformFeedback = (PFNGLRESUMETRANSFORMFEEDBACKPROC)proc("glResumeTransformFeedback");
	gl3wSampleCoverage = (PFNGLSAMPLECOVERAGEPROC)proc("glSampleCoverage");
	gl3wSampleMaski = (PFNGLSAMPLEMASKIPROC)proc("glSampleMaski");
	gl3wSamplerParameterIiv = (PFNGLSAMPLERPARAMETERIIVPROC)proc("glSamplerParameterIiv");
	gl3wSamplerParameterIuiv = (PFNGLSAMPLERPARAMETERIUIVPROC)proc("glSamplerParameterIuiv");
	gl3wSamplerParameterf = (PFNGLSAMPLERPARAMETERFPROC)proc("glSamplerParameterf");
	gl3wSamplerParameterfv = (PFNGLSAMPLERPARAMETERFVPROC)proc("glSamplerParameterfv");
	gl3wSamplerParameteri = (PFNGLSAMPLERPARAMETERIPROC)proc("glSamplerParameteri");
	gl3wSamplerParameteriv = (PFNGLSAMPLERPARAMETERIVPROC)proc("glSamplerParameteriv");
	gl3wScissor = (PFNGLSCISSORPROC)proc("glScissor");
	gl3wScissorArrayv = (PFNGLSCISSORARRAYVPROC)proc("glScissorArrayv");
	gl3wScissorIndexed = (PFNGLSCISSORINDEXEDPROC)proc("glScissorIndexed");
	gl3wScissorIndexedv = (PFNGLSCISSORINDEXEDVPROC)proc("glScissorIndexedv");
	gl3wSecondaryColorFormatNV = (PFNGLSECONDARYCOLORFORMATNVPROC)proc("glSecondaryColorFormatNV");
	gl3wSelectPerfMonitorCountersAMD = (PFNGLSELECTPERFMONITORCOUNTERSAMDPROC)proc("glSelectPerfMonitorCountersAMD");
	gl3wShaderBinary = (PFNGLSHADERBINARYPROC)proc("glShaderBinary");
	gl3wShaderSource = (PFNGLSHADERSOURCEPROC)proc("glShaderSource");
	gl3wShaderStorageBlockBinding = (PFNGLSHADERSTORAGEBLOCKBINDINGPROC)proc("glShaderStorageBlockBinding");
	gl3wSignalVkFenceNV = (PFNGLSIGNALVKFENCENVPROC)proc("glSignalVkFenceNV");
	gl3wSignalVkSemaphoreNV = (PFNGLSIGNALVKSEMAPHORENVPROC)proc("glSignalVkSemaphoreNV");
	gl3wSpecializeShaderARB = (PFNGLSPECIALIZESHADERARBPROC)proc("glSpecializeShaderARB");
	gl3wStateCaptureNV = (PFNGLSTATECAPTURENVPROC)proc("glStateCaptureNV");
	gl3wStencilFillPathInstancedNV = (PFNGLSTENCILFILLPATHINSTANCEDNVPROC)proc("glStencilFillPathInstancedNV");
	gl3wStencilFillPathNV = (PFNGLSTENCILFILLPATHNVPROC)proc("glStencilFillPathNV");
	gl3wStencilFunc = (PFNGLSTENCILFUNCPROC)proc("glStencilFunc");
	gl3wStencilFuncSeparate = (PFNGLSTENCILFUNCSEPARATEPROC)proc("glStencilFuncSeparate");
	gl3wStencilMask = (PFNGLSTENCILMASKPROC)proc("glStencilMask");
	gl3wStencilMaskSeparate = (PFNGLSTENCILMASKSEPARATEPROC)proc("glStencilMaskSeparate");
	gl3wStencilOp = (PFNGLSTENCILOPPROC)proc("glStencilOp");
	gl3wStencilOpSeparate = (PFNGLSTENCILOPSEPARATEPROC)proc("glStencilOpSeparate");
	gl3wStencilStrokePathInstancedNV = (PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC)proc("glStencilStrokePathInstancedNV");
	gl3wStencilStrokePathNV = (PFNGLSTENCILSTROKEPATHNVPROC)proc("glStencilStrokePathNV");
	gl3wStencilThenCoverFillPathInstancedNV = (PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC)proc("glStencilThenCoverFillPathInstancedNV");
	gl3wStencilThenCoverFillPathNV = (PFNGLSTENCILTHENCOVERFILLPATHNVPROC)proc("glStencilThenCoverFillPathNV");
	gl3wStencilThenCoverStrokePathInstancedNV = (PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC)proc("glStencilThenCoverStrokePathInstancedNV");
	gl3wStencilThenCoverStrokePathNV = (PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC)proc("glStencilThenCoverStrokePathNV");
	gl3wSubpixelPrecisionBiasNV = (PFNGLSUBPIXELPRECISIONBIASNVPROC)proc("glSubpixelPrecisionBiasNV");
	gl3wTexBuffer = (PFNGLTEXBUFFERPROC)proc("glTexBuffer");
	gl3wTexBufferARB = (PFNGLTEXBUFFERARBPROC)proc("glTexBufferARB");
	gl3wTexBufferRange = (PFNGLTEXBUFFERRANGEPROC)proc("glTexBufferRange");
	gl3wTexCoordFormatNV = (PFNGLTEXCOORDFORMATNVPROC)proc("glTexCoordFormatNV");
	gl3wTexImage1D = (PFNGLTEXIMAGE1DPROC)proc("glTexImage1D");
	gl3wTexImage2D = (PFNGLTEXIMAGE2DPROC)proc("glTexImage2D");
	gl3wTexImage2DMultisample = (PFNGLTEXIMAGE2DMULTISAMPLEPROC)proc("glTexImage2DMultisample");
	gl3wTexImage3D = (PFNGLTEXIMAGE3DPROC)proc("glTexImage3D");
	gl3wTexImage3DMultisample = (PFNGLTEXIMAGE3DMULTISAMPLEPROC)proc("glTexImage3DMultisample");
	gl3wTexPageCommitmentARB = (PFNGLTEXPAGECOMMITMENTARBPROC)proc("glTexPageCommitmentARB");
	gl3wTexParameterIiv = (PFNGLTEXPARAMETERIIVPROC)proc("glTexParameterIiv");
	gl3wTexParameterIuiv = (PFNGLTEXPARAMETERIUIVPROC)proc("glTexParameterIuiv");
	gl3wTexParameterf = (PFNGLTEXPARAMETERFPROC)proc("glTexParameterf");
	gl3wTexParameterfv = (PFNGLTEXPARAMETERFVPROC)proc("glTexParameterfv");
	gl3wTexParameteri = (PFNGLTEXPARAMETERIPROC)proc("glTexParameteri");
	gl3wTexParameteriv = (PFNGLTEXPARAMETERIVPROC)proc("glTexParameteriv");
	gl3wTexStorage1D = (PFNGLTEXSTORAGE1DPROC)proc("glTexStorage1D");
	gl3wTexStorage2D = (PFNGLTEXSTORAGE2DPROC)proc("glTexStorage2D");
	gl3wTexStorage2DMultisample = (PFNGLTEXSTORAGE2DMULTISAMPLEPROC)proc("glTexStorage2DMultisample");
	gl3wTexStorage3D = (PFNGLTEXSTORAGE3DPROC)proc("glTexStorage3D");
	gl3wTexStorage3DMultisample = (PFNGLTEXSTORAGE3DMULTISAMPLEPROC)proc("glTexStorage3DMultisample");
	gl3wTexSubImage1D = (PFNGLTEXSUBIMAGE1DPROC)proc("glTexSubImage1D");
	gl3wTexSubImage2D = (PFNGLTEXSUBIMAGE2DPROC)proc("glTexSubImage2D");
	gl3wTexSubImage3D = (PFNGLTEXSUBIMAGE3DPROC)proc("glTexSubImage3D");
	gl3wTextureBarrier = (PFNGLTEXTUREBARRIERPROC)proc("glTextureBarrier");
	gl3wTextureBarrierNV = (PFNGLTEXTUREBARRIERNVPROC)proc("glTextureBarrierNV");
	gl3wTextureBuffer = (PFNGLTEXTUREBUFFERPROC)proc("glTextureBuffer");
	gl3wTextureBufferEXT = (PFNGLTEXTUREBUFFEREXTPROC)proc("glTextureBufferEXT");
	gl3wTextureBufferRange = (PFNGLTEXTUREBUFFERRANGEPROC)proc("glTextureBufferRange");
	gl3wTextureBufferRangeEXT = (PFNGLTEXTUREBUFFERRANGEEXTPROC)proc("glTextureBufferRangeEXT");
	gl3wTextureImage1DEXT = (PFNGLTEXTUREIMAGE1DEXTPROC)proc("glTextureImage1DEXT");
	gl3wTextureImage2DEXT = (PFNGLTEXTUREIMAGE2DEXTPROC)proc("glTextureImage2DEXT");
	gl3wTextureImage3DEXT = (PFNGLTEXTUREIMAGE3DEXTPROC)proc("glTextureImage3DEXT");
	gl3wTexturePageCommitmentEXT = (PFNGLTEXTUREPAGECOMMITMENTEXTPROC)proc("glTexturePageCommitmentEXT");
	gl3wTextureParameterIiv = (PFNGLTEXTUREPARAMETERIIVPROC)proc("glTextureParameterIiv");
	gl3wTextureParameterIivEXT = (PFNGLTEXTUREPARAMETERIIVEXTPROC)proc("glTextureParameterIivEXT");
	gl3wTextureParameterIuiv = (PFNGLTEXTUREPARAMETERIUIVPROC)proc("glTextureParameterIuiv");
	gl3wTextureParameterIuivEXT = (PFNGLTEXTUREPARAMETERIUIVEXTPROC)proc("glTextureParameterIuivEXT");
	gl3wTextureParameterf = (PFNGLTEXTUREPARAMETERFPROC)proc("glTextureParameterf");
	gl3wTextureParameterfEXT = (PFNGLTEXTUREPARAMETERFEXTPROC)proc("glTextureParameterfEXT");
	gl3wTextureParameterfv = (PFNGLTEXTUREPARAMETERFVPROC)proc("glTextureParameterfv");
	gl3wTextureParameterfvEXT = (PFNGLTEXTUREPARAMETERFVEXTPROC)proc("glTextureParameterfvEXT");
	gl3wTextureParameteri = (PFNGLTEXTUREPARAMETERIPROC)proc("glTextureParameteri");
	gl3wTextureParameteriEXT = (PFNGLTEXTUREPARAMETERIEXTPROC)proc("glTextureParameteriEXT");
	gl3wTextureParameteriv = (PFNGLTEXTUREPARAMETERIVPROC)proc("glTextureParameteriv");
	gl3wTextureParameterivEXT = (PFNGLTEXTUREPARAMETERIVEXTPROC)proc("glTextureParameterivEXT");
	gl3wTextureRenderbufferEXT = (PFNGLTEXTURERENDERBUFFEREXTPROC)proc("glTextureRenderbufferEXT");
	gl3wTextureStorage1D = (PFNGLTEXTURESTORAGE1DPROC)proc("glTextureStorage1D");
	gl3wTextureStorage1DEXT = (PFNGLTEXTURESTORAGE1DEXTPROC)proc("glTextureStorage1DEXT");
	gl3wTextureStorage2D = (PFNGLTEXTURESTORAGE2DPROC)proc("glTextureStorage2D");
	gl3wTextureStorage2DEXT = (PFNGLTEXTURESTORAGE2DEXTPROC)proc("glTextureStorage2DEXT");
	gl3wTextureStorage2DMultisample = (PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC)proc("glTextureStorage2DMultisample");
	gl3wTextureStorage2DMultisampleEXT = (PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC)proc("glTextureStorage2DMultisampleEXT");
	gl3wTextureStorage3D = (PFNGLTEXTURESTORAGE3DPROC)proc("glTextureStorage3D");
	gl3wTextureStorage3DEXT = (PFNGLTEXTURESTORAGE3DEXTPROC)proc("glTextureStorage3DEXT");
	gl3wTextureStorage3DMultisample = (PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC)proc("glTextureStorage3DMultisample");
	gl3wTextureStorage3DMultisampleEXT = (PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC)proc("glTextureStorage3DMultisampleEXT");
	gl3wTextureSubImage1D = (PFNGLTEXTURESUBIMAGE1DPROC)proc("glTextureSubImage1D");
	gl3wTextureSubImage1DEXT = (PFNGLTEXTURESUBIMAGE1DEXTPROC)proc("glTextureSubImage1DEXT");
	gl3wTextureSubImage2D = (PFNGLTEXTURESUBIMAGE2DPROC)proc("glTextureSubImage2D");
	gl3wTextureSubImage2DEXT = (PFNGLTEXTURESUBIMAGE2DEXTPROC)proc("glTextureSubImage2DEXT");
	gl3wTextureSubImage3D = (PFNGLTEXTURESUBIMAGE3DPROC)proc("glTextureSubImage3D");
	gl3wTextureSubImage3DEXT = (PFNGLTEXTURESUBIMAGE3DEXTPROC)proc("glTextureSubImage3DEXT");
	gl3wTextureView = (PFNGLTEXTUREVIEWPROC)proc("glTextureView");
	gl3wTransformFeedbackBufferBase = (PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC)proc("glTransformFeedbackBufferBase");
	gl3wTransformFeedbackBufferRange = (PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC)proc("glTransformFeedbackBufferRange");
	gl3wTransformFeedbackVaryings = (PFNGLTRANSFORMFEEDBACKVARYINGSPROC)proc("glTransformFeedbackVaryings");
	gl3wTransformPathNV = (PFNGLTRANSFORMPATHNVPROC)proc("glTransformPathNV");
	gl3wUniform1d = (PFNGLUNIFORM1DPROC)proc("glUniform1d");
	gl3wUniform1dv = (PFNGLUNIFORM1DVPROC)proc("glUniform1dv");
	gl3wUniform1f = (PFNGLUNIFORM1FPROC)proc("glUniform1f");
	gl3wUniform1fv = (PFNGLUNIFORM1FVPROC)proc("glUniform1fv");
	gl3wUniform1i = (PFNGLUNIFORM1IPROC)proc("glUniform1i");
	gl3wUniform1i64ARB = (PFNGLUNIFORM1I64ARBPROC)proc("glUniform1i64ARB");
	gl3wUniform1i64NV = (PFNGLUNIFORM1I64NVPROC)proc("glUniform1i64NV");
	gl3wUniform1i64vARB = (PFNGLUNIFORM1I64VARBPROC)proc("glUniform1i64vARB");
	gl3wUniform1i64vNV = (PFNGLUNIFORM1I64VNVPROC)proc("glUniform1i64vNV");
	gl3wUniform1iv = (PFNGLUNIFORM1IVPROC)proc("glUniform1iv");
	gl3wUniform1ui = (PFNGLUNIFORM1UIPROC)proc("glUniform1ui");
	gl3wUniform1ui64ARB = (PFNGLUNIFORM1UI64ARBPROC)proc("glUniform1ui64ARB");
	gl3wUniform1ui64NV = (PFNGLUNIFORM1UI64NVPROC)proc("glUniform1ui64NV");
	gl3wUniform1ui64vARB = (PFNGLUNIFORM1UI64VARBPROC)proc("glUniform1ui64vARB");
	gl3wUniform1ui64vNV = (PFNGLUNIFORM1UI64VNVPROC)proc("glUniform1ui64vNV");
	gl3wUniform1uiv = (PFNGLUNIFORM1UIVPROC)proc("glUniform1uiv");
	gl3wUniform2d = (PFNGLUNIFORM2DPROC)proc("glUniform2d");
	gl3wUniform2dv = (PFNGLUNIFORM2DVPROC)proc("glUniform2dv");
	gl3wUniform2f = (PFNGLUNIFORM2FPROC)proc("glUniform2f");
	gl3wUniform2fv = (PFNGLUNIFORM2FVPROC)proc("glUniform2fv");
	gl3wUniform2i = (PFNGLUNIFORM2IPROC)proc("glUniform2i");
	gl3wUniform2i64ARB = (PFNGLUNIFORM2I64ARBPROC)proc("glUniform2i64ARB");
	gl3wUniform2i64NV = (PFNGLUNIFORM2I64NVPROC)proc("glUniform2i64NV");
	gl3wUniform2i64vARB = (PFNGLUNIFORM2I64VARBPROC)proc("glUniform2i64vARB");
	gl3wUniform2i64vNV = (PFNGLUNIFORM2I64VNVPROC)proc("glUniform2i64vNV");
	gl3wUniform2iv = (PFNGLUNIFORM2IVPROC)proc("glUniform2iv");
	gl3wUniform2ui = (PFNGLUNIFORM2UIPROC)proc("glUniform2ui");
	gl3wUniform2ui64ARB = (PFNGLUNIFORM2UI64ARBPROC)proc("glUniform2ui64ARB");
	gl3wUniform2ui64NV = (PFNGLUNIFORM2UI64NVPROC)proc("glUniform2ui64NV");
	gl3wUniform2ui64vARB = (PFNGLUNIFORM2UI64VARBPROC)proc("glUniform2ui64vARB");
	gl3wUniform2ui64vNV = (PFNGLUNIFORM2UI64VNVPROC)proc("glUniform2ui64vNV");
	gl3wUniform2uiv = (PFNGLUNIFORM2UIVPROC)proc("glUniform2uiv");
	gl3wUniform3d = (PFNGLUNIFORM3DPROC)proc("glUniform3d");
	gl3wUniform3dv = (PFNGLUNIFORM3DVPROC)proc("glUniform3dv");
	gl3wUniform3f = (PFNGLUNIFORM3FPROC)proc("glUniform3f");
	gl3wUniform3fv = (PFNGLUNIFORM3FVPROC)proc("glUniform3fv");
	gl3wUniform3i = (PFNGLUNIFORM3IPROC)proc("glUniform3i");
	gl3wUniform3i64ARB = (PFNGLUNIFORM3I64ARBPROC)proc("glUniform3i64ARB");
	gl3wUniform3i64NV = (PFNGLUNIFORM3I64NVPROC)proc("glUniform3i64NV");
	gl3wUniform3i64vARB = (PFNGLUNIFORM3I64VARBPROC)proc("glUniform3i64vARB");
	gl3wUniform3i64vNV = (PFNGLUNIFORM3I64VNVPROC)proc("glUniform3i64vNV");
	gl3wUniform3iv = (PFNGLUNIFORM3IVPROC)proc("glUniform3iv");
	gl3wUniform3ui = (PFNGLUNIFORM3UIPROC)proc("glUniform3ui");
	gl3wUniform3ui64ARB = (PFNGLUNIFORM3UI64ARBPROC)proc("glUniform3ui64ARB");
	gl3wUniform3ui64NV = (PFNGLUNIFORM3UI64NVPROC)proc("glUniform3ui64NV");
	gl3wUniform3ui64vARB = (PFNGLUNIFORM3UI64VARBPROC)proc("glUniform3ui64vARB");
	gl3wUniform3ui64vNV = (PFNGLUNIFORM3UI64VNVPROC)proc("glUniform3ui64vNV");
	gl3wUniform3uiv = (PFNGLUNIFORM3UIVPROC)proc("glUniform3uiv");
	gl3wUniform4d = (PFNGLUNIFORM4DPROC)proc("glUniform4d");
	gl3wUniform4dv = (PFNGLUNIFORM4DVPROC)proc("glUniform4dv");
	gl3wUniform4f = (PFNGLUNIFORM4FPROC)proc("glUniform4f");
	gl3wUniform4fv = (PFNGLUNIFORM4FVPROC)proc("glUniform4fv");
	gl3wUniform4i = (PFNGLUNIFORM4IPROC)proc("glUniform4i");
	gl3wUniform4i64ARB = (PFNGLUNIFORM4I64ARBPROC)proc("glUniform4i64ARB");
	gl3wUniform4i64NV = (PFNGLUNIFORM4I64NVPROC)proc("glUniform4i64NV");
	gl3wUniform4i64vARB = (PFNGLUNIFORM4I64VARBPROC)proc("glUniform4i64vARB");
	gl3wUniform4i64vNV = (PFNGLUNIFORM4I64VNVPROC)proc("glUniform4i64vNV");
	gl3wUniform4iv = (PFNGLUNIFORM4IVPROC)proc("glUniform4iv");
	gl3wUniform4ui = (PFNGLUNIFORM4UIPROC)proc("glUniform4ui");
	gl3wUniform4ui64ARB = (PFNGLUNIFORM4UI64ARBPROC)proc("glUniform4ui64ARB");
	gl3wUniform4ui64NV = (PFNGLUNIFORM4UI64NVPROC)proc("glUniform4ui64NV");
	gl3wUniform4ui64vARB = (PFNGLUNIFORM4UI64VARBPROC)proc("glUniform4ui64vARB");
	gl3wUniform4ui64vNV = (PFNGLUNIFORM4UI64VNVPROC)proc("glUniform4ui64vNV");
	gl3wUniform4uiv = (PFNGLUNIFORM4UIVPROC)proc("glUniform4uiv");
	gl3wUniformBlockBinding = (PFNGLUNIFORMBLOCKBINDINGPROC)proc("glUniformBlockBinding");
	gl3wUniformHandleui64ARB = (PFNGLUNIFORMHANDLEUI64ARBPROC)proc("glUniformHandleui64ARB");
	gl3wUniformHandleui64NV = (PFNGLUNIFORMHANDLEUI64NVPROC)proc("glUniformHandleui64NV");
	gl3wUniformHandleui64vARB = (PFNGLUNIFORMHANDLEUI64VARBPROC)proc("glUniformHandleui64vARB");
	gl3wUniformHandleui64vNV = (PFNGLUNIFORMHANDLEUI64VNVPROC)proc("glUniformHandleui64vNV");
	gl3wUniformMatrix2dv = (PFNGLUNIFORMMATRIX2DVPROC)proc("glUniformMatrix2dv");
	gl3wUniformMatrix2fv = (PFNGLUNIFORMMATRIX2FVPROC)proc("glUniformMatrix2fv");
	gl3wUniformMatrix2x3dv = (PFNGLUNIFORMMATRIX2X3DVPROC)proc("glUniformMatrix2x3dv");
	gl3wUniformMatrix2x3fv = (PFNGLUNIFORMMATRIX2X3FVPROC)proc("glUniformMatrix2x3fv");
	gl3wUniformMatrix2x4dv = (PFNGLUNIFORMMATRIX2X4DVPROC)proc("glUniformMatrix2x4dv");
	gl3wUniformMatrix2x4fv = (PFNGLUNIFORMMATRIX2X4FVPROC)proc("glUniformMatrix2x4fv");
	gl3wUniformMatrix3dv = (PFNGLUNIFORMMATRIX3DVPROC)proc("glUniformMatrix3dv");
	gl3wUniformMatrix3fv = (PFNGLUNIFORMMATRIX3FVPROC)proc("glUniformMatrix3fv");
	gl3wUniformMatrix3x2dv = (PFNGLUNIFORMMATRIX3X2DVPROC)proc("glUniformMatrix3x2dv");
	gl3wUniformMatrix3x2fv = (PFNGLUNIFORMMATRIX3X2FVPROC)proc("glUniformMatrix3x2fv");
	gl3wUniformMatrix3x4dv = (PFNGLUNIFORMMATRIX3X4DVPROC)proc("glUniformMatrix3x4dv");
	gl3wUniformMatrix3x4fv = (PFNGLUNIFORMMATRIX3X4FVPROC)proc("glUniformMatrix3x4fv");
	gl3wUniformMatrix4dv = (PFNGLUNIFORMMATRIX4DVPROC)proc("glUniformMatrix4dv");
	gl3wUniformMatrix4fv = (PFNGLUNIFORMMATRIX4FVPROC)proc("glUniformMatrix4fv");
	gl3wUniformMatrix4x2dv = (PFNGLUNIFORMMATRIX4X2DVPROC)proc("glUniformMatrix4x2dv");
	gl3wUniformMatrix4x2fv = (PFNGLUNIFORMMATRIX4X2FVPROC)proc("glUniformMatrix4x2fv");
	gl3wUniformMatrix4x3dv = (PFNGLUNIFORMMATRIX4X3DVPROC)proc("glUniformMatrix4x3dv");
	gl3wUniformMatrix4x3fv = (PFNGLUNIFORMMATRIX4X3FVPROC)proc("glUniformMatrix4x3fv");
	gl3wUniformSubroutinesuiv = (PFNGLUNIFORMSUBROUTINESUIVPROC)proc("glUniformSubroutinesuiv");
	gl3wUniformui64NV = (PFNGLUNIFORMUI64NVPROC)proc("glUniformui64NV");
	gl3wUniformui64vNV = (PFNGLUNIFORMUI64VNVPROC)proc("glUniformui64vNV");
	gl3wUnmapBuffer = (PFNGLUNMAPBUFFERPROC)proc("glUnmapBuffer");
	gl3wUnmapNamedBuffer = (PFNGLUNMAPNAMEDBUFFERPROC)proc("glUnmapNamedBuffer");
	gl3wUnmapNamedBufferEXT = (PFNGLUNMAPNAMEDBUFFEREXTPROC)proc("glUnmapNamedBufferEXT");
	gl3wUseProgram = (PFNGLUSEPROGRAMPROC)proc("glUseProgram");
	gl3wUseProgramStages = (PFNGLUSEPROGRAMSTAGESPROC)proc("glUseProgramStages");
	gl3wUseShaderProgramEXT = (PFNGLUSESHADERPROGRAMEXTPROC)proc("glUseShaderProgramEXT");
	gl3wValidateProgram = (PFNGLVALIDATEPROGRAMPROC)proc("glValidateProgram");
	gl3wValidateProgramPipeline = (PFNGLVALIDATEPROGRAMPIPELINEPROC)proc("glValidateProgramPipeline");
	gl3wVertexArrayAttribBinding = (PFNGLVERTEXARRAYATTRIBBINDINGPROC)proc("glVertexArrayAttribBinding");
	gl3wVertexArrayAttribFormat = (PFNGLVERTEXARRAYATTRIBFORMATPROC)proc("glVertexArrayAttribFormat");
	gl3wVertexArrayAttribIFormat = (PFNGLVERTEXARRAYATTRIBIFORMATPROC)proc("glVertexArrayAttribIFormat");
	gl3wVertexArrayAttribLFormat = (PFNGLVERTEXARRAYATTRIBLFORMATPROC)proc("glVertexArrayAttribLFormat");
	gl3wVertexArrayBindVertexBufferEXT = (PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC)proc("glVertexArrayBindVertexBufferEXT");
	gl3wVertexArrayBindingDivisor = (PFNGLVERTEXARRAYBINDINGDIVISORPROC)proc("glVertexArrayBindingDivisor");
	gl3wVertexArrayColorOffsetEXT = (PFNGLVERTEXARRAYCOLOROFFSETEXTPROC)proc("glVertexArrayColorOffsetEXT");
	gl3wVertexArrayEdgeFlagOffsetEXT = (PFNGLVERTEXARRAYEDGEFLAGOFFSETEXTPROC)proc("glVertexArrayEdgeFlagOffsetEXT");
	gl3wVertexArrayElementBuffer = (PFNGLVERTEXARRAYELEMENTBUFFERPROC)proc("glVertexArrayElementBuffer");
	gl3wVertexArrayFogCoordOffsetEXT = (PFNGLVERTEXARRAYFOGCOORDOFFSETEXTPROC)proc("glVertexArrayFogCoordOffsetEXT");
	gl3wVertexArrayIndexOffsetEXT = (PFNGLVERTEXARRAYINDEXOFFSETEXTPROC)proc("glVertexArrayIndexOffsetEXT");
	gl3wVertexArrayMultiTexCoordOffsetEXT = (PFNGLVERTEXARRAYMULTITEXCOORDOFFSETEXTPROC)proc("glVertexArrayMultiTexCoordOffsetEXT");
	gl3wVertexArrayNormalOffsetEXT = (PFNGLVERTEXARRAYNORMALOFFSETEXTPROC)proc("glVertexArrayNormalOffsetEXT");
	gl3wVertexArraySecondaryColorOffsetEXT = (PFNGLVERTEXARRAYSECONDARYCOLOROFFSETEXTPROC)proc("glVertexArraySecondaryColorOffsetEXT");
	gl3wVertexArrayTexCoordOffsetEXT = (PFNGLVERTEXARRAYTEXCOORDOFFSETEXTPROC)proc("glVertexArrayTexCoordOffsetEXT");
	gl3wVertexArrayVertexAttribBindingEXT = (PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC)proc("glVertexArrayVertexAttribBindingEXT");
	gl3wVertexArrayVertexAttribDivisorEXT = (PFNGLVERTEXARRAYVERTEXATTRIBDIVISOREXTPROC)proc("glVertexArrayVertexAttribDivisorEXT");
	gl3wVertexArrayVertexAttribFormatEXT = (PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC)proc("glVertexArrayVertexAttribFormatEXT");
	gl3wVertexArrayVertexAttribIFormatEXT = (PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC)proc("glVertexArrayVertexAttribIFormatEXT");
	gl3wVertexArrayVertexAttribIOffsetEXT = (PFNGLVERTEXARRAYVERTEXATTRIBIOFFSETEXTPROC)proc("glVertexArrayVertexAttribIOffsetEXT");
	gl3wVertexArrayVertexAttribLFormatEXT = (PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC)proc("glVertexArrayVertexAttribLFormatEXT");
	gl3wVertexArrayVertexAttribLOffsetEXT = (PFNGLVERTEXARRAYVERTEXATTRIBLOFFSETEXTPROC)proc("glVertexArrayVertexAttribLOffsetEXT");
	gl3wVertexArrayVertexAttribOffsetEXT = (PFNGLVERTEXARRAYVERTEXATTRIBOFFSETEXTPROC)proc("glVertexArrayVertexAttribOffsetEXT");
	gl3wVertexArrayVertexBindingDivisorEXT = (PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC)proc("glVertexArrayVertexBindingDivisorEXT");
	gl3wVertexArrayVertexBuffer = (PFNGLVERTEXARRAYVERTEXBUFFERPROC)proc("glVertexArrayVertexBuffer");
	gl3wVertexArrayVertexBuffers = (PFNGLVERTEXARRAYVERTEXBUFFERSPROC)proc("glVertexArrayVertexBuffers");
	gl3wVertexArrayVertexOffsetEXT = (PFNGLVERTEXARRAYVERTEXOFFSETEXTPROC)proc("glVertexArrayVertexOffsetEXT");
	gl3wVertexAttrib1d = (PFNGLVERTEXATTRIB1DPROC)proc("glVertexAttrib1d");
	gl3wVertexAttrib1dv = (PFNGLVERTEXATTRIB1DVPROC)proc("glVertexAttrib1dv");
	gl3wVertexAttrib1f = (PFNGLVERTEXATTRIB1FPROC)proc("glVertexAttrib1f");
	gl3wVertexAttrib1fv = (PFNGLVERTEXATTRIB1FVPROC)proc("glVertexAttrib1fv");
	gl3wVertexAttrib1s = (PFNGLVERTEXATTRIB1SPROC)proc("glVertexAttrib1s");
	gl3wVertexAttrib1sv = (PFNGLVERTEXATTRIB1SVPROC)proc("glVertexAttrib1sv");
	gl3wVertexAttrib2d = (PFNGLVERTEXATTRIB2DPROC)proc("glVertexAttrib2d");
	gl3wVertexAttrib2dv = (PFNGLVERTEXATTRIB2DVPROC)proc("glVertexAttrib2dv");
	gl3wVertexAttrib2f = (PFNGLVERTEXATTRIB2FPROC)proc("glVertexAttrib2f");
	gl3wVertexAttrib2fv = (PFNGLVERTEXATTRIB2FVPROC)proc("glVertexAttrib2fv");
	gl3wVertexAttrib2s = (PFNGLVERTEXATTRIB2SPROC)proc("glVertexAttrib2s");
	gl3wVertexAttrib2sv = (PFNGLVERTEXATTRIB2SVPROC)proc("glVertexAttrib2sv");
	gl3wVertexAttrib3d = (PFNGLVERTEXATTRIB3DPROC)proc("glVertexAttrib3d");
	gl3wVertexAttrib3dv = (PFNGLVERTEXATTRIB3DVPROC)proc("glVertexAttrib3dv");
	gl3wVertexAttrib3f = (PFNGLVERTEXATTRIB3FPROC)proc("glVertexAttrib3f");
	gl3wVertexAttrib3fv = (PFNGLVERTEXATTRIB3FVPROC)proc("glVertexAttrib3fv");
	gl3wVertexAttrib3s = (PFNGLVERTEXATTRIB3SPROC)proc("glVertexAttrib3s");
	gl3wVertexAttrib3sv = (PFNGLVERTEXATTRIB3SVPROC)proc("glVertexAttrib3sv");
	gl3wVertexAttrib4Nbv = (PFNGLVERTEXATTRIB4NBVPROC)proc("glVertexAttrib4Nbv");
	gl3wVertexAttrib4Niv = (PFNGLVERTEXATTRIB4NIVPROC)proc("glVertexAttrib4Niv");
	gl3wVertexAttrib4Nsv = (PFNGLVERTEXATTRIB4NSVPROC)proc("glVertexAttrib4Nsv");
	gl3wVertexAttrib4Nub = (PFNGLVERTEXATTRIB4NUBPROC)proc("glVertexAttrib4Nub");
	gl3wVertexAttrib4Nubv = (PFNGLVERTEXATTRIB4NUBVPROC)proc("glVertexAttrib4Nubv");
	gl3wVertexAttrib4Nuiv = (PFNGLVERTEXATTRIB4NUIVPROC)proc("glVertexAttrib4Nuiv");
	gl3wVertexAttrib4Nusv = (PFNGLVERTEXATTRIB4NUSVPROC)proc("glVertexAttrib4Nusv");
	gl3wVertexAttrib4bv = (PFNGLVERTEXATTRIB4BVPROC)proc("glVertexAttrib4bv");
	gl3wVertexAttrib4d = (PFNGLVERTEXATTRIB4DPROC)proc("glVertexAttrib4d");
	gl3wVertexAttrib4dv = (PFNGLVERTEXATTRIB4DVPROC)proc("glVertexAttrib4dv");
	gl3wVertexAttrib4f = (PFNGLVERTEXATTRIB4FPROC)proc("glVertexAttrib4f");
	gl3wVertexAttrib4fv = (PFNGLVERTEXATTRIB4FVPROC)proc("glVertexAttrib4fv");
	gl3wVertexAttrib4iv = (PFNGLVERTEXATTRIB4IVPROC)proc("glVertexAttrib4iv");
	gl3wVertexAttrib4s = (PFNGLVERTEXATTRIB4SPROC)proc("glVertexAttrib4s");
	gl3wVertexAttrib4sv = (PFNGLVERTEXATTRIB4SVPROC)proc("glVertexAttrib4sv");
	gl3wVertexAttrib4ubv = (PFNGLVERTEXATTRIB4UBVPROC)proc("glVertexAttrib4ubv");
	gl3wVertexAttrib4uiv = (PFNGLVERTEXATTRIB4UIVPROC)proc("glVertexAttrib4uiv");
	gl3wVertexAttrib4usv = (PFNGLVERTEXATTRIB4USVPROC)proc("glVertexAttrib4usv");
	gl3wVertexAttribBinding = (PFNGLVERTEXATTRIBBINDINGPROC)proc("glVertexAttribBinding");
	gl3wVertexAttribDivisor = (PFNGLVERTEXATTRIBDIVISORPROC)proc("glVertexAttribDivisor");
	gl3wVertexAttribDivisorARB = (PFNGLVERTEXATTRIBDIVISORARBPROC)proc("glVertexAttribDivisorARB");
	gl3wVertexAttribFormat = (PFNGLVERTEXATTRIBFORMATPROC)proc("glVertexAttribFormat");
	gl3wVertexAttribFormatNV = (PFNGLVERTEXATTRIBFORMATNVPROC)proc("glVertexAttribFormatNV");
	gl3wVertexAttribI1i = (PFNGLVERTEXATTRIBI1IPROC)proc("glVertexAttribI1i");
	gl3wVertexAttribI1iv = (PFNGLVERTEXATTRIBI1IVPROC)proc("glVertexAttribI1iv");
	gl3wVertexAttribI1ui = (PFNGLVERTEXATTRIBI1UIPROC)proc("glVertexAttribI1ui");
	gl3wVertexAttribI1uiv = (PFNGLVERTEXATTRIBI1UIVPROC)proc("glVertexAttribI1uiv");
	gl3wVertexAttribI2i = (PFNGLVERTEXATTRIBI2IPROC)proc("glVertexAttribI2i");
	gl3wVertexAttribI2iv = (PFNGLVERTEXATTRIBI2IVPROC)proc("glVertexAttribI2iv");
	gl3wVertexAttribI2ui = (PFNGLVERTEXATTRIBI2UIPROC)proc("glVertexAttribI2ui");
	gl3wVertexAttribI2uiv = (PFNGLVERTEXATTRIBI2UIVPROC)proc("glVertexAttribI2uiv");
	gl3wVertexAttribI3i = (PFNGLVERTEXATTRIBI3IPROC)proc("glVertexAttribI3i");
	gl3wVertexAttribI3iv = (PFNGLVERTEXATTRIBI3IVPROC)proc("glVertexAttribI3iv");
	gl3wVertexAttribI3ui = (PFNGLVERTEXATTRIBI3UIPROC)proc("glVertexAttribI3ui");
	gl3wVertexAttribI3uiv = (PFNGLVERTEXATTRIBI3UIVPROC)proc("glVertexAttribI3uiv");
	gl3wVertexAttribI4bv = (PFNGLVERTEXATTRIBI4BVPROC)proc("glVertexAttribI4bv");
	gl3wVertexAttribI4i = (PFNGLVERTEXATTRIBI4IPROC)proc("glVertexAttribI4i");
	gl3wVertexAttribI4iv = (PFNGLVERTEXATTRIBI4IVPROC)proc("glVertexAttribI4iv");
	gl3wVertexAttribI4sv = (PFNGLVERTEXATTRIBI4SVPROC)proc("glVertexAttribI4sv");
	gl3wVertexAttribI4ubv = (PFNGLVERTEXATTRIBI4UBVPROC)proc("glVertexAttribI4ubv");
	gl3wVertexAttribI4ui = (PFNGLVERTEXATTRIBI4UIPROC)proc("glVertexAttribI4ui");
	gl3wVertexAttribI4uiv = (PFNGLVERTEXATTRIBI4UIVPROC)proc("glVertexAttribI4uiv");
	gl3wVertexAttribI4usv = (PFNGLVERTEXATTRIBI4USVPROC)proc("glVertexAttribI4usv");
	gl3wVertexAttribIFormat = (PFNGLVERTEXATTRIBIFORMATPROC)proc("glVertexAttribIFormat");
	gl3wVertexAttribIFormatNV = (PFNGLVERTEXATTRIBIFORMATNVPROC)proc("glVertexAttribIFormatNV");
	gl3wVertexAttribIPointer = (PFNGLVERTEXATTRIBIPOINTERPROC)proc("glVertexAttribIPointer");
	gl3wVertexAttribL1d = (PFNGLVERTEXATTRIBL1DPROC)proc("glVertexAttribL1d");
	gl3wVertexAttribL1dv = (PFNGLVERTEXATTRIBL1DVPROC)proc("glVertexAttribL1dv");
	gl3wVertexAttribL1i64NV = (PFNGLVERTEXATTRIBL1I64NVPROC)proc("glVertexAttribL1i64NV");
	gl3wVertexAttribL1i64vNV = (PFNGLVERTEXATTRIBL1I64VNVPROC)proc("glVertexAttribL1i64vNV");
	gl3wVertexAttribL1ui64ARB = (PFNGLVERTEXATTRIBL1UI64ARBPROC)proc("glVertexAttribL1ui64ARB");
	gl3wVertexAttribL1ui64NV = (PFNGLVERTEXATTRIBL1UI64NVPROC)proc("glVertexAttribL1ui64NV");
	gl3wVertexAttribL1ui64vARB = (PFNGLVERTEXATTRIBL1UI64VARBPROC)proc("glVertexAttribL1ui64vARB");
	gl3wVertexAttribL1ui64vNV = (PFNGLVERTEXATTRIBL1UI64VNVPROC)proc("glVertexAttribL1ui64vNV");
	gl3wVertexAttribL2d = (PFNGLVERTEXATTRIBL2DPROC)proc("glVertexAttribL2d");
	gl3wVertexAttribL2dv = (PFNGLVERTEXATTRIBL2DVPROC)proc("glVertexAttribL2dv");
	gl3wVertexAttribL2i64NV = (PFNGLVERTEXATTRIBL2I64NVPROC)proc("glVertexAttribL2i64NV");
	gl3wVertexAttribL2i64vNV = (PFNGLVERTEXATTRIBL2I64VNVPROC)proc("glVertexAttribL2i64vNV");
	gl3wVertexAttribL2ui64NV = (PFNGLVERTEXATTRIBL2UI64NVPROC)proc("glVertexAttribL2ui64NV");
	gl3wVertexAttribL2ui64vNV = (PFNGLVERTEXATTRIBL2UI64VNVPROC)proc("glVertexAttribL2ui64vNV");
	gl3wVertexAttribL3d = (PFNGLVERTEXATTRIBL3DPROC)proc("glVertexAttribL3d");
	gl3wVertexAttribL3dv = (PFNGLVERTEXATTRIBL3DVPROC)proc("glVertexAttribL3dv");
	gl3wVertexAttribL3i64NV = (PFNGLVERTEXATTRIBL3I64NVPROC)proc("glVertexAttribL3i64NV");
	gl3wVertexAttribL3i64vNV = (PFNGLVERTEXATTRIBL3I64VNVPROC)proc("glVertexAttribL3i64vNV");
	gl3wVertexAttribL3ui64NV = (PFNGLVERTEXATTRIBL3UI64NVPROC)proc("glVertexAttribL3ui64NV");
	gl3wVertexAttribL3ui64vNV = (PFNGLVERTEXATTRIBL3UI64VNVPROC)proc("glVertexAttribL3ui64vNV");
	gl3wVertexAttribL4d = (PFNGLVERTEXATTRIBL4DPROC)proc("glVertexAttribL4d");
	gl3wVertexAttribL4dv = (PFNGLVERTEXATTRIBL4DVPROC)proc("glVertexAttribL4dv");
	gl3wVertexAttribL4i64NV = (PFNGLVERTEXATTRIBL4I64NVPROC)proc("glVertexAttribL4i64NV");
	gl3wVertexAttribL4i64vNV = (PFNGLVERTEXATTRIBL4I64VNVPROC)proc("glVertexAttribL4i64vNV");
	gl3wVertexAttribL4ui64NV = (PFNGLVERTEXATTRIBL4UI64NVPROC)proc("glVertexAttribL4ui64NV");
	gl3wVertexAttribL4ui64vNV = (PFNGLVERTEXATTRIBL4UI64VNVPROC)proc("glVertexAttribL4ui64vNV");
	gl3wVertexAttribLFormat = (PFNGLVERTEXATTRIBLFORMATPROC)proc("glVertexAttribLFormat");
	gl3wVertexAttribLFormatNV = (PFNGLVERTEXATTRIBLFORMATNVPROC)proc("glVertexAttribLFormatNV");
	gl3wVertexAttribLPointer = (PFNGLVERTEXATTRIBLPOINTERPROC)proc("glVertexAttribLPointer");
	gl3wVertexAttribP1ui = (PFNGLVERTEXATTRIBP1UIPROC)proc("glVertexAttribP1ui");
	gl3wVertexAttribP1uiv = (PFNGLVERTEXATTRIBP1UIVPROC)proc("glVertexAttribP1uiv");
	gl3wVertexAttribP2ui = (PFNGLVERTEXATTRIBP2UIPROC)proc("glVertexAttribP2ui");
	gl3wVertexAttribP2uiv = (PFNGLVERTEXATTRIBP2UIVPROC)proc("glVertexAttribP2uiv");
	gl3wVertexAttribP3ui = (PFNGLVERTEXATTRIBP3UIPROC)proc("glVertexAttribP3ui");
	gl3wVertexAttribP3uiv = (PFNGLVERTEXATTRIBP3UIVPROC)proc("glVertexAttribP3uiv");
	gl3wVertexAttribP4ui = (PFNGLVERTEXATTRIBP4UIPROC)proc("glVertexAttribP4ui");
	gl3wVertexAttribP4uiv = (PFNGLVERTEXATTRIBP4UIVPROC)proc("glVertexAttribP4uiv");
	gl3wVertexAttribPointer = (PFNGLVERTEXATTRIBPOINTERPROC)proc("glVertexAttribPointer");
	gl3wVertexBindingDivisor = (PFNGLVERTEXBINDINGDIVISORPROC)proc("glVertexBindingDivisor");
	gl3wVertexFormatNV = (PFNGLVERTEXFORMATNVPROC)proc("glVertexFormatNV");
	gl3wViewport = (PFNGLVIEWPORTPROC)proc("glViewport");
	gl3wViewportArrayv = (PFNGLVIEWPORTARRAYVPROC)proc("glViewportArrayv");
	gl3wViewportIndexedf = (PFNGLVIEWPORTINDEXEDFPROC)proc("glViewportIndexedf");
	gl3wViewportIndexedfv = (PFNGLVIEWPORTINDEXEDFVPROC)proc("glViewportIndexedfv");
	gl3wViewportPositionWScaleNV = (PFNGLVIEWPORTPOSITIONWSCALENVPROC)proc("glViewportPositionWScaleNV");
	gl3wViewportSwizzleNV = (PFNGLVIEWPORTSWIZZLENVPROC)proc("glViewportSwizzleNV");
	gl3wWaitSync = (PFNGLWAITSYNCPROC)proc("glWaitSync");
	gl3wWaitVkSemaphoreNV = (PFNGLWAITVKSEMAPHORENVPROC)proc("glWaitVkSemaphoreNV");
	gl3wWeightPathsNV = (PFNGLWEIGHTPATHSNVPROC)proc("glWeightPathsNV");
	gl3wWindowRectanglesEXT = (PFNGLWINDOWRECTANGLESEXTPROC)proc("glWindowRectanglesEXT");
}
