;-------------------------------------------------------------------------------
; ZX X-MAS '19 - STARTUP EFFECTS - HIHG MEMORY / OVERWRITTEN
;
;       (/&&&/\&\  /%/  \&\  /%/   /%)(#)(&\ /%###&\ /###)  ()/%|  /&&&\
;         /%/  \&\/%/    \&\/%/,--,|#||#||#| |#| |#| |&&\     |#| (&___&)
;        /%/   /%/\&\    /%/\&\'--'|#||#||#| |###|#|  \&&|    |#|    (&&)
;       /&&&/)/%/  \&\  /%/  \&\   |#||#||#| |#| |#| (###/    |#| (&&&&/
;
; Copyright AbaddoN (C)2018-2019
; Code and gfx by: G.o.D. / AbaddoN
; Mzx by: ern0 / AbaddoN
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
; Vaporize out loading screen title & ribbon.
; in:  DE: startup phase
; out: -
; mod: AF,BC,DE,HL
; Areas: $0D10-$0412 / $1158-$0703 / $1340-$080D / $1380-$080D
DO_VAPORIZE_OUT:
	ld	a,e
	and	$07
	jr	nz,DVO_P1
	; title .1 / ~18700T
	ld	hl,$0D10					; H:X (chr) / L:Y (px) top left
	ld	bc,$0212					; B: height (chr) / c: width (chr)
	jp	DVO_VaporizeOutArea
DVO_P1:
	dec	a
	jr	nz,DVO_P2
	; title .2 / ~17100T
	ld	hl,$0D20					; H:X (chr) / L:Y (px) top left
	ld	bc,$0212					; B: height (chr) / c: width (chr)
	jp	DVO_VaporizeOutArea
DVO_P2:
	dec	a
	jr	nz,DVO_P3
	; ribbon .1 / ~15500T
	ld	hl,$1440					; H:X (chr) / L:Y (px) top left
	ld	bc,$030B					; B: height (chr) / c: width (chr)
	jp	DVO_VaporizeOutArea
DVO_P3:
	dec	a
	jr	nz,DVO_P4
	; ribbon .3 / ~13700T
	ld	hl,$1160					; H:X (chr) / L:Y (px) top left
	ld	bc,$020F					; B: height (chr) / c: width (chr)
	jp	DVO_VaporizeOutArea
DVO_P4:
	dec	a
	jr	nz,DVO_P5
	; ribbon .4 / ~12600T
	ld	hl,$1270					; H:X (chr) / L:Y (px) top left
	ld	bc,$020E					; B: height (chr) / c: width (chr)
	jp	DVO_VaporizeOutArea
DVO_P5:
	dec	a
	jr	nz,DVO_P6
	; ribbon .5 / ~12600T
	ld	hl,$1280					; H:X (chr) / L:Y (px) top left
	ld	bc,$020E					; B: height (chr) / c: width (chr)
	jp	DVO_VaporizeOutArea
DVO_P6:
	dec	a
	jr	nz,DVO_P7
	; ribbon .2
	ld	hl,$1558					; H:X (chr) / L:Y (px) top left
	ld	bc,$010A					; B: height (chr) / c: width (chr)
	call	DVO_VaporizeOutArea
	; ribbon .6 / ~17500T
	ld	hl,$1390					; H:X (chr) / L:Y (px) top left
	ld	bc,$020D					; B: height (chr) / c: width (chr)
	jp	DVO_VaporizeOutArea
DVO_P7:
	; ribbon .7 / ~17200T
	ld	hl,$14A0					; H:X (chr) / L:Y (px) top left
	ld	bc,$020C					; B: height (chr) / c: width (chr)
	call	DVO_VaporizeOutArea
	; ribbon .8
	ld	hl,$1258					; H:X (chr) / L:Y (px) top left
	ld	bc,$0103					; B: height (chr) / c: width (chr)
	call	DVO_VaporizeOutArea
	; www.sinclair.hu
	ld	hl,$14B8					; H:X (chr) / L:Y (px) top left
	ld	bc,$0108					; B: height (chr) / c: width (chr)
	call	DVO_VaporizeOutArea

	ld	hl,(VAPORIZE_OUT_CURR_MASK+1)	; next vaporize phase
	ld	de,8
	add	hl,de
	ld	(VAPORIZE_OUT_CURR_MASK+1),hl
	ret


; Vaporize out screen area.
; in:  L: top left Y pos px / H: top left X pos chr - L must be divided by 8
;      C: width chr / B: height chr
; out: -
; mod: AF,B,DE,HL

DVO_VaporizeOutArea:
	ld	a,h
	ld	h,SCRLINE_LOOKUP>>8
	ld	e,(hl)
	inc	h
	ld	h,(hl)
	add	a,e
	ld	l,a					; HL=area screen addr

VOA_VertLoop:
	push	bc
	push	hl
VOA_HorzLoop:
VAPORIZE_OUT_CURR_MASK:
	ld	de,VAPORIZE_MASK
	ld	b,8
VOA_CharLoop:
	ld	a,(de)
	inc	de
	and	(hl)
	ld	(hl),a
	inc	h
	djnz	VOA_CharLoop

	ld	a,h
	sub	8
	ld	h,a
	inc	l
	dec	c
	jr	nz,VOA_HorzLoop

	pop	hl
	pop	bc
	
	ld	a,$20
	add	a,l
	ld	l,a
	
	djnz	VOA_VertLoop
	ret


;-------------------------------------------------------------------------------
; Set paper to background.
; in:  -
; out: -
; mod: AF,BC,DE,HL
SET_PAPER_TO_BACKGROUND:
	ld	a,(SPB_CheckRow+1)
	inc	a
	ld	(SPB_CheckRow+1),a

	; title
	ld	hl,$5800+($03*$20)+$0D
	ld	de,$20-$12
	ld	bc,$1203
	ld	a,$03
	call	SPB_EraseArea

	; ribbon .1
	ld	hl,$5800+($08*$20)+$11
	ld	de,$20-$0F
	ld	bc,$0F06
	ld	a,$08
	call	SPB_EraseArea
	
	; ribbon .2
	ld	hl,$5800+($0E*$20)+$12
	ld	de,$20-$0E
	ld	bc,$0E04
	ld	a,$0E
	call	SPB_EraseArea
	
	; ribbon .3
	ld	hl,$5800+($12*$20)+$13
	ld	de,$20-$0D
	ld	bc,$0D02
	ld	a,$12
	call	SPB_EraseArea
	
	; ribbon .4
	ld	hl,$5800+($14*$20)+$14
	ld	de,$20-$0B
	ld	bc,$0B02
	ld	a,$14
	; call	SPB_EraseArea
	
SPB_EraseArea:
SPB_VertLoop:
SPB_CheckRow:
	cp	-1					; #selfmod: put until this attribute row
	jr	z,SPB_NoSkipLine
	push	de
	ld	de,$20
	add	hl,de
	pop	de
	jr	SPB_SkipLine
SPB_NoSkipLine:
	push	af
	push	bc
SPB_HorzLoop:
	ld	a,(hl)
	and	%11000111
SET_PAPER_BKG_COLOR:
	or	0					; #selfmod: background color
	ld	(hl),a
	inc	l
	djnz	SPB_HorzLoop
	dec	l
	inc	hl
	add	hl,de
	pop	bc
	pop	af
SPB_SkipLine:
	inc	a
	dec	c
	jr	nz,SPB_VertLoop
	ret


;-------------------------------------------------------------------------------
; Move out X-Mas tree
; in:  -
; out: -
; mod: AF,BC,DE,HL,AF'
MOVE_OUT_TREE:
MOT_Jp2ndEntry:
	jp	MOT_Phase
MOT_Phase:
	ld	a,-21
	inc	a
	ld	(MOT_Phase+1),a

	ld	l,a
	cp	$7F
	jr	c,MOT_NotNegativeRow
	ld	l,0					; L=Max(0,Phase)
MOT_NotNegativeRow:
	add	a,21
	cp	24
	jr	c,MOT_NotOver24Row
	ld	a,24					; A=Max(24,Phase+21)
MOT_NotOver24Row:
	sub	l					; A=character rows to move left
	ld	h,0

	ld	de,MOVE_OUT_TREE_2ND_ENTRY
	ld	(MOT_Jp2ndEntry+1),de
	ld	(MOT_2ndStoredA+1),a

MOT_SplitEntryPoint:
	cp	7
	jr	c,MOT_Max7RowsPerFrame
	ld	a,7
MOT_Max7RowsPerFrame:

MOT_ChrRowsLoop:
	ex	de,hl				; set LDI skip
	ld	hl,MOT_JrTable
	add	hl,de
	ld	c,(hl)
	ld	hl,MOT_BIT_LDI_SKIP_JR+1
	ld	(hl),c
	ld	hl,MOT_ATTR_LDI_SKIP_JR+1
	ld	(hl),c
	ex	de,hl

	ex	af,af'
	push	hl
	call	MOT_MoveChrRow
	pop	hl
	inc	l
	ex	af,af'
	dec	a
	jr	nz,MOT_ChrRowsLoop
	ld	(MOT_2ndStoredHL+1),hl	; current row for splitting
	ld	(MOT_3rdStoredHL+1),hl
	ret

MOVE_OUT_TREE_2ND_ENTRY:
	ld	hl,MOVE_OUT_TREE_3RD_ENTRY
	ld	(MOT_Jp2ndEntry+1),hl
MOT_2ndStoredHL:
	ld	hl,$1313
MOT_2ndStoredA:
	ld	a,$13
	sub	7
	ld	(MOT_3rdStoredA+1),a
	ret	z
	ret	c
	jr	MOT_SplitEntryPoint

MOVE_OUT_TREE_3RD_ENTRY:
	ld	hl,MOT_Phase
	ld	(MOT_Jp2ndEntry+1),hl
MOT_3rdStoredHL:
	ld	hl,$1313
MOT_3rdStoredA:
	ld	a,$13
	sub	7
	ret	z
	ret	c
	cp	8
	ret	nc
	jr	MOT_ChrRowsLoop


; Move one character row left.
; in:  HL: row number (0-23)
; out: -
; mod: AF,BC,DE,HL
MOT_MoveChrRow:

	add	hl,hl
	add	hl,hl
	add	hl,hl

	push	hl
	add	hl,hl
	add	hl,hl
	ld	a,$58
	add	a,h
	ld	h,a
	ld	d,h
	ld	e,l
	inc	l
MOT_ATTR_LDI_SKIP_JR:
	jr	MOT_ATTR_LDI_12x
MOT_ATTR_LDI_20x:
	ldi
MOT_ATTR_LDI_19x:
	ldi
MOT_ATTR_LDI_18x:
	ldi
MOT_ATTR_LDI_17x:
	ldi
MOT_ATTR_LDI_16x:
	ldi
	ldi
	ldi
	ldi
MOT_ATTR_LDI_12x:
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	dec	l
MOVE_OUT_EMPTY_ATTR:
	ld	(hl),1				; #selfmod: right column empty attribute
	pop	hl

	ld	h,SCRLINE_LOOKUP>>8
	ld	a,(hl)
	inc	h
	ld	h,(hl)
	ld	l,a

	ld	a,8
MOT_LineLoop:
	push	hl

	ld	d,h
	ld	e,l
	inc	l
MOT_BIT_LDI_SKIP_JR:
	jr	MOT_BIT_LDI_12x

MOT_BIT_LDI_20x:
	ldi
MOT_BIT_LDI_19x:
	ldi
MOT_BIT_LDI_18x:
	ldi
MOT_BIT_LDI_17x:
	ldi
MOT_BIT_LDI_16x:
	ldi
	ldi
	ldi
	ldi
MOT_BIT_LDI_12x:
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	dec	l
	ld	(hl),0				; erase right column
	pop	hl
	inc	h					; next line
	
	dec	a					; until 8 pixels height
	jr	nz,MOT_LineLoop
	ret

MOT_JrTable:
	defb	$10, $10, $10, $10, $10, $10				;   0- 47px:13 chr width
	defb	$08, $08, $08, $08, $08, $08, $08, $08		;  48-111px:17 chr width
	defb	$06, $06, $06, $06						; 112-143px:18 chr width
	defb	$04, $04								; 144-159px:19 chr width
	defb	$00, $00, $00							; 160-183px:21 chr width
	defb	$02									; 184-192px:20 chr width

;-------------------------------------------------------------------------------
; Move in X-Mas tree
; in:  -
; out: -
; mod: AF,BC,DE,HL,IX,AF'

MOVE_IN_TREE:
MIT_Jp2ndEntry:
	jp	MIT_Phase
MIT_Phase:
	ld	a,-MIT_BKG_TREE_WIDTH
	inc	a
	ld	(MIT_Phase+1),a

	ld	l,a
	cp	$7F
	jr	c,MIT_NotNegativeRow
	ld	l,0					; L=Max(0,Phase)
MIT_NotNegativeRow:
	add	a,MIT_BKG_TREE_WIDTH
	cp	24
	jr	c,MIT_NotOver24Row
	ld	a,24					; A=Max(24,Phase+MIT_BKG_TREE_WIDTH)
MIT_NotOver24Row:
	sub	l					; A=character rows to move left
	ld	h,0

	ld	de,MOVE_IN_TREE_2ND_ENTRY
	ld	(MIT_Jp2ndEntry+1),de
	ld	(MIT_2ndStoredA+1),a

MIT_SplitEntryPoint:
	cp	7					; at most 7 rows / frame enabled
	jr	c,MIT_Max7RowsPerFrame
	ld	a,7
MIT_Max7RowsPerFrame:

MIT_ChrRowsLoop:
	ex	af,af'
	push	hl
	call	MIT_MoveChrRow
	pop	hl
	inc	l
	ex	af,af'
	dec	a
	jr	nz,MIT_ChrRowsLoop
	ld	(MIT_2ndStoredHL+1),hl	; current row for splitting
	ld	(MIT_3rdStoredHL+1),hl
	ret

MOVE_IN_TREE_2ND_ENTRY:
	ld	hl,MOVE_IN_TREE_3RD_ENTRY
	ld	(MIT_Jp2ndEntry+1),hl
MIT_2ndStoredHL:
	ld	hl,$1313
MIT_2ndStoredA:
	ld	a,$13
	sub	7
	ld	(MIT_3rdStoredA+1),a
	ret	z
	ret	c
	jr	MIT_SplitEntryPoint

MOVE_IN_TREE_3RD_ENTRY:
	ld	hl,MIT_Phase
	ld	(MIT_Jp2ndEntry+1),hl
MIT_3rdStoredHL:
	ld	hl,$1313
MIT_3rdStoredA:
	ld	a,$13
	sub	7
	ret	z
	ret	c
	cp	8
	ret	nc
	jr	MIT_ChrRowsLoop


; Move one character row right and fill left column with IX based gfx
; in:  HL: row number (0-23)
; out: -
; mod: AF,BC,DE,HL,IX
MIT_MoveChrRow:
	add	hl,hl

	ex	de,hl				; IX=scrolled row's incoming character addr.
	ld	hl,MIT_TreeImgRowPtr
	add	hl,de
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	ld	ix,-9
	add	ix,bc
	push	ix
	pop	bc
	ld	(hl),b
	dec	hl
	ld	(hl),c
	ex	de,hl
	
	add	hl,hl
	add	hl,hl

	push	hl					; attribute scroll and set incoming attr.
	add	hl,hl
	add	hl,hl
	ld	a,MIT_BKG_TREE_WIDTH-1
	add	a,l
	ld	l,a
	ld	a,$58
	add	a,h
	ld	h,a
	ld	d,h
	ld	e,l
	dec	l

	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd

	ld	a,(ix+8)				; set left column attribute
	ld	(de),a
	pop	hl

	ld	h,SCRLINE_LOOKUP>>8		; bitmap scroll and set incoming pixels
	ld	a,(hl)
	inc	h
	ld	h,(hl)
	add	a,MIT_BKG_TREE_WIDTH-1
	ld	l,a

	ld	bc,$08FF
	ld	a,8
MIT_LineLoop:
	push	hl
	ld	d,h
	ld	e,l
	dec	l

	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd
	ldd

	ld	a,(ix+0)				; set left column bitmap
	inc	ix
	ld	(de),a
	pop	hl
	inc	h					; next line
	
	djnz	MIT_LineLoop			; until 8 pixels height
	ret

MIT_BKG_TREE_WIDTH		EQU	15
MIT_BKG_TREE_ROW_LEN	EQU	MIT_BKG_TREE_WIDTH*9
MIT_TreeImgRowPtr:
	defw	BKG_TREE_IMAGE+( 1*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+( 2*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+( 3*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+( 4*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+( 5*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+( 6*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+( 7*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+( 8*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+( 9*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(10*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(11*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(12*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(13*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(14*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(15*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(16*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(17*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(18*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(19*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(20*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(21*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(22*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(23*MIT_BKG_TREE_ROW_LEN)
	defw	BKG_TREE_IMAGE+(24*MIT_BKG_TREE_ROW_LEN)

;-------------------------------------------------------------------------------
; Put background right attributes.
; in:  -
; out: -
; mod: AF,BC,DE,HL
PUT_BKG_ATTR:
	; right 22*24 attribute area
RIGHT_BKG_ATTR:
	ld	hl,$1313				; #selfmod: normal colors / ULA Plus
	ld	de,$5800+$0A
	ld	a,24
PBA_RowLoop:
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ex	de,hl
	ld	bc,$20-$16
	add	hl,bc
	ex	de,hl
	dec	a
	jr	nz,PBA_RowLoop

	; left bottom 10*4 attribute area
	ld	hl,$5800+(20*$20)
	ld	de,$20-10
	ld	a,(COLOR_LEFTBOTTOM_ATTR)
	ld	c,4
PBA_LeftBottomRowLoop:
	ld	b,10
PBA_LeftBottomAttrLoop:
	ld	(hl),a
	inc	l
	djnz	PBA_LeftBottomAttrLoop
	add	hl,de
	dec	c
	jr	nz,PBA_LeftBottomRowLoop

	ret
