"use strict";

var CABLES=CABLES||{};
CABLES.OPS=CABLES.OPS||{};

var Ops=Ops || {};
Ops.Gl=Ops.Gl || {};
Ops.Ui=Ops.Ui || {};
Ops.Anim=Ops.Anim || {};
Ops.Vars=Ops.Vars || {};
Ops.User=Ops.User || {};
Ops.Math=Ops.Math || {};
Ops.Audio=Ops.Audio || {};
Ops.Patch=Ops.Patch || {};
Ops.Array=Ops.Array || {};
Ops.String=Ops.String || {};
Ops.Json3d=Ops.Json3d || {};
Ops.Trigger=Ops.Trigger || {};
Ops.Boolean=Ops.Boolean || {};
Ops.WebAudio=Ops.WebAudio || {};
Ops.Gl.Phong=Ops.Gl.Phong || {};
Ops.Gl.Shader=Ops.Gl.Shader || {};
Ops.Gl.Meshes=Ops.Gl.Meshes || {};
Ops.Gl.Matrix=Ops.Gl.Matrix || {};
Ops.Gl.Textures=Ops.Gl.Textures || {};
Ops.Math.Compare=Ops.Math.Compare || {};
Ops.Gl.ShaderEffects=Ops.Gl.ShaderEffects || {};
Ops.User.adambazaroff=Ops.User.adambazaroff || {};
Ops.Gl.TextureEffects=Ops.Gl.TextureEffects || {};
Ops.Gl.TextureEffects.Noise=Ops.Gl.TextureEffects.Noise || {};



// **************************************************************
// 
// Ops.Gl.Matrix.Transform
// 
// **************************************************************

Ops.Gl.Matrix.Transform = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    render=op.inTrigger("render"),
    posX=op.inValue("posX",0),
    posY=op.inValue("posY",0),
    posZ=op.inValue("posZ",0),
    scale=op.inValue("scale",1),
    rotX=op.inValue("rotX",0),
    rotY=op.inValue("rotY",0),
    rotZ=op.inValue("rotZ",0),
    trigger=op.outTrigger("trigger");

op.setPortGroup('Rotation',[rotX,rotY,rotZ]);
op.setPortGroup('Position',[posX,posY,posZ]);
op.setPortGroup('Scale',[scale]);

const cgl=op.patch.cgl;
var vPos=vec3.create();
var vScale=vec3.create();
var transMatrix = mat4.create();
mat4.identity(transMatrix);

var
    doScale=false,
    doTranslate=false,
    translationChanged=true,
    scaleChanged=true,
    rotChanged=true;

// scale.setUiAttribs({"divider":true});

rotX.onChange=rotY.onChange=rotZ.onChange=setRotChanged;
posX.onChange=posY.onChange=posZ.onChange=setTranslateChanged;
scale.onChange=setScaleChanged;


render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpNotInTextureEffect(op)) return;

    var updateMatrix=false;
    if(translationChanged)
    {
        updateTranslation();
        updateMatrix=true;
    }
    if(scaleChanged)
    {
        updateScale();
        updateMatrix=true;
    }
    if(rotChanged) updateMatrix=true;

    if(updateMatrix) doUpdateMatrix();

    cgl.pushModelMatrix();
    mat4.multiply(cgl.mMatrix,cgl.mMatrix,transMatrix);

    trigger.trigger();
    cgl.popModelMatrix();

    if(CABLES.UI && gui.patch().isCurrentOp(op))
        gui.setTransformGizmo(
            {
                posX:posX,
                posY:posY,
                posZ:posZ,
            });
};

op.transform3d=function()
{
    return { pos:[posX,posY,posZ] };
};

function doUpdateMatrix()
{
    mat4.identity(transMatrix);
    if(doTranslate)mat4.translate(transMatrix,transMatrix, vPos);

    if(rotX.get()!==0)mat4.rotateX(transMatrix,transMatrix, rotX.get()*CGL.DEG2RAD);
    if(rotY.get()!==0)mat4.rotateY(transMatrix,transMatrix, rotY.get()*CGL.DEG2RAD);
    if(rotZ.get()!==0)mat4.rotateZ(transMatrix,transMatrix, rotZ.get()*CGL.DEG2RAD);

    if(doScale)mat4.scale(transMatrix,transMatrix, vScale);
    rotChanged=false;
}

function updateTranslation()
{
    doTranslate=false;
    if(posX.get()!==0.0 || posY.get()!==0.0 || posZ.get()!==0.0) doTranslate=true;
    vec3.set(vPos, posX.get(),posY.get(),posZ.get());
    translationChanged=false;
}

function updateScale()
{
    doScale=false;
    if(scale.get()!==0.0)doScale=true;
    vec3.set(vScale, scale.get(),scale.get(),scale.get());
    scaleChanged=false;
}

function setTranslateChanged()
{
    translationChanged=true;
}

function setScaleChanged()
{
    scaleChanged=true;
}

function setRotChanged()
{
    rotChanged=true;
}

doUpdateMatrix();




};

Ops.Gl.Matrix.Transform.prototype = new CABLES.Op();
CABLES.OPS["650baeb1-db2d-4781-9af6-ab4e9d4277be"]={f:Ops.Gl.Matrix.Transform,objName:"Ops.Gl.Matrix.Transform"};




// **************************************************************
// 
// Ops.Gl.Meshes.Cube
// 
// **************************************************************

Ops.Gl.Meshes.Cube = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var render=op.inTrigger('render');
var width=op.inValue('width');
var height=op.inValue('height');
var lengt=op.inValue('length');
var center=op.inValueBool('center');

var active=op.inValueBool('Active',true);

var trigger=op.outTrigger('trigger');
var geomOut=op.outObject("geometry");

var cgl=op.patch.cgl;
var geom=null;
var mesh=null;
width.set(1.0);
height.set(1.0);
lengt.set(1.0);
center.set(true);

render.onTriggered=function()
{
    if(active.get() && mesh) mesh.render(cgl.getShader());
    trigger.trigger();
};

op.preRender=function()
{
    buildMesh();
    mesh.render(cgl.getShader());
};

function buildMesh()
{
    if(!geom)geom=new CGL.Geometry("cubemesh");
    geom.clear();

    var x=width.get();
    var nx=-1*width.get();
    var y=lengt.get();
    var ny=-1*lengt.get();
    var z=height.get();
    var nz=-1*height.get();

    if(!center.get())
    {
        nx=0;
        ny=0;
        nz=0;
    }
    else
    {
        x*=0.5;
        nx*=0.5;
        y*=0.5;
        ny*=0.5;
        z*=0.5;
        nz*=0.5;
    }

    geom.vertices = [
        // Front face
        nx, ny,  z,
        x, ny,  z,
        x,  y,  z,
        nx,  y,  z,
        // Back face
        nx, ny, nz,
        nx,  y, nz,
        x,  y, nz,
        x, ny, nz,
        // Top face
        nx,  y, nz,
        nx,  y,  z,
        x,  y,  z,
        x,  y, nz,
        // Bottom face
        nx, ny, nz,
        x, ny, nz,
        x, ny,  z,
        nx, ny,  z,
        // Right face
        x, ny, nz,
        x,  y, nz,
        x,  y,  z,
        x, ny,  z,
        // zeft face
        nx, ny, nz,
        nx, ny,  z,
        nx,  y,  z,
        nx,  y, nz
        ];

    geom.setTexCoords( [
          // Front face
          0.0, 1.0,
          1.0, 1.0,
          1.0, 0.0,
          0.0, 0.0,
          // Back face
          1.0, 1.0,
          1.0, 0.0,
          0.0, 0.0,
          0.0, 1.0,
          // Top face
          0.0, 0.0,
          0.0, 1.0,
          1.0, 1.0,
          1.0, 0.0,
          // Bottom face
          1.0, 0.0,
          0.0, 0.0,
          0.0, 1.0,
          1.0, 1.0,
          // Right face
          1.0, 1.0,
          1.0, 0.0,
          0.0, 0.0,
          0.0, 1.0,
          // Left face
          0.0, 1.0,
          1.0, 1.0,
          1.0, 0.0,
          0.0, 0.0,
        ]);

    geom.vertexNormals = [
        // Front face
         0.0,  0.0,  1.0,
         0.0,  0.0,  1.0,
         0.0,  0.0,  1.0,
         0.0,  0.0,  1.0,

        // Back face
         0.0,  0.0, -1.0,
         0.0,  0.0, -1.0,
         0.0,  0.0, -1.0,
         0.0,  0.0, -1.0,

        // Top face
         0.0,  1.0,  0.0,
         0.0,  1.0,  0.0,
         0.0,  1.0,  0.0,
         0.0,  1.0,  0.0,

        // Bottom face
         0.0, -1.0,  0.0,
         0.0, -1.0,  0.0,
         0.0, -1.0,  0.0,
         0.0, -1.0,  0.0,

        // Right face
         1.0,  0.0,  0.0,
         1.0,  0.0,  0.0,
         1.0,  0.0,  0.0,
         1.0,  0.0,  0.0,

        // Left face
        -1.0,  0.0,  0.0,
        -1.0,  0.0,  0.0,
        -1.0,  0.0,  0.0,
        -1.0,  0.0,  0.0
    ];
    geom.tangents = [
        // front face
        -1,0,0, -1,0,0, -1,0,0, -1,0,0,
        // back face
        1,0,0, 1,0,0, 1,0,0, 1,0,0,
        // top face
        1,0,0, 1,0,0, 1,0,0, 1,0,0,
        // bottom face
        -1,0,0, -1,0,0, -1,0,0, -1,0,0,
        // right face
        0,0,-1, 0,0,-1, 0,0,-1, 0,0,-1,
        // left face
        0,0,1, 0,0,1, 0,0,1, 0,0,1
    ];
    geom.biTangents = [
      // front face
      0,-1,0, 0,-1,0, 0,-1,0, 0,-1,0,
      // back face
      0,1,0, 0,1,0, 0,1,0, 0,1,0,
      // top face
      0,0,-1, 0,0,-1, 0,0,-1, 0,0,-1,
      // bottom face
      0,0,1, 0,0,1, 0,0,1, 0,0,1,
      // right face
      0,1,0, 0,1,0, 0,1,0, 0,1,0,
      // left face
      0,1,0, 0,1,0, 0,1,0, 0,1,0
    ];

    geom.verticesIndices = [
        0, 1, 2,      0, 2, 3,    // Front face
        4, 5, 6,      4, 6, 7,    // Back face
        8, 9, 10,     8, 10, 11,  // Top face
        12, 13, 14,   12, 14, 15, // Bottom face
        16, 17, 18,   16, 18, 19, // Right face
        20, 21, 22,   20, 22, 23  // Left face
    ];

    if(mesh)mesh.dispose();
    mesh=new CGL.Mesh(cgl,geom);
    geomOut.set(null);
    geomOut.set(geom);
}

width.onChange=buildMesh;
height.onChange=buildMesh;
lengt.onChange=buildMesh;
center.onChange=buildMesh;

buildMesh();

op.onDelete=function()
{
    if(mesh)mesh.dispose();
}

};

Ops.Gl.Meshes.Cube.prototype = new CABLES.Op();
CABLES.OPS["ff0535e2-603a-4c07-9ce6-e9e0db857dfe"]={f:Ops.Gl.Meshes.Cube,objName:"Ops.Gl.Meshes.Cube"};




// **************************************************************
// 
// Ops.Trigger.Repeat
// 
// **************************************************************

Ops.Trigger.Repeat = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const exe=op.inTrigger("exe");
const num=op.inValueInt("num",5);

const trigger=op.outTrigger("trigger")
const idx=op.addOutPort(new CABLES.Port(op,"index"));

exe.onTriggered=function()
{
    for(var i=Math.round(num.get())-1;i>-1;i--)
    {
        idx.set(i);
        trigger.trigger();
    }
};



};

Ops.Trigger.Repeat.prototype = new CABLES.Op();
CABLES.OPS["0f4d6489-ea7a-436b-b1b3-25a739e150c6"]={f:Ops.Trigger.Repeat,objName:"Ops.Trigger.Repeat"};




// **************************************************************
// 
// Ops.Gl.Texture
// 
// **************************************************************

Ops.Gl.Texture = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var filename=op.inFile("file");
var tfilter=op.inValueSelect("filter",['nearest','linear','mipmap']);
var wrap=op.inValueSelect("wrap",['repeat','mirrored repeat','clamp to edge'],"clamp to edge");
var flip=op.inValueBool("flip",false);
var unpackAlpha=op.inValueBool("unpackPreMultipliedAlpha",false);

var textureOut=op.outTexture("texture");
var width=op.outValue("width");
var height=op.outValue("height");
var loading=op.outValue("loading");
var ratio=op.outValue("Aspect Ratio");

unpackAlpha.hidePort();

const cgl=op.patch.cgl;
var cgl_filter=0;
var cgl_wrap=0;

flip.onChange=function(){reloadSoon();};
filename.onChange=reloadSoon;

tfilter.onChange=onFilterChange;
wrap.onChange=onWrapChange;
unpackAlpha.onChange=function(){ reloadSoon(); };

var timedLoader=0;

tfilter.set('mipmap');
wrap.set('repeat');

textureOut.set(CGL.Texture.getEmptyTexture(cgl));

var setTempTexture=function()
{
    var t=CGL.Texture.getTempTexture(cgl);
    textureOut.set(t);
};

var loadingId=null;
var tex=null;
function reloadSoon(nocache)
{
    // if(!loadingId)loadingId=cgl.patch.loading.start('textureOp',filename.get());

    // if(timedLoader!=0)
    // {
    //     console.log('tex load canceled...');
    // }
    clearTimeout(timedLoader);
    timedLoader=setTimeout(function()
    {
        // console.log('tex load yay...');
        realReload(nocache);
    },30);
}

function realReload(nocache)
{
    if(!loadingId)loadingId=cgl.patch.loading.start('textureOp',filename.get());

    var url=op.patch.getFilePath(String(filename.get()));
    if(nocache)url+='?rnd='+CABLES.generateUUID();

    if((filename.get() && filename.get().length>1))
    {
        loading.set(true);

        if(tex)tex.delete();
        tex=CGL.Texture.load(cgl,url,
            function(err)
            {
                if(err)
                {
                    setTempTexture();
                    op.uiAttr({'error':'could not load texture "'+filename.get()+'"'});
                    cgl.patch.loading.finished(loadingId);
                    return;
                }
                else op.uiAttr({'error':null});
                textureOut.set(tex);
                width.set(tex.width);
                height.set(tex.height);
                ratio.set(tex.width/tex.height);

                if(!tex.isPowerOfTwo()) op.uiAttr(
                    {
                        hint:'texture dimensions not power of two! - texture filtering will not work.',
                        warning:null
                    });
                    else op.uiAttr(
                        {
                            hint:null,
                            warning:null
                        });

                textureOut.set(null);
                textureOut.set(tex);
                // tex.printInfo();

            },{
                wrap:cgl_wrap,
                flip:flip.get(),
                unpackAlpha:unpackAlpha.get(),
                filter:cgl_filter
            });

        textureOut.set(null);
        textureOut.set(tex);

        if(!textureOut.get() && nocache)
        {
        }

        cgl.patch.loading.finished(loadingId);
    }
    else
    {
        cgl.patch.loading.finished(loadingId);
        setTempTexture();
    }
}


function onFilterChange()
{
    if(tfilter.get()=='nearest') cgl_filter=CGL.Texture.FILTER_NEAREST;
    if(tfilter.get()=='linear') cgl_filter=CGL.Texture.FILTER_LINEAR;
    if(tfilter.get()=='mipmap') cgl_filter=CGL.Texture.FILTER_MIPMAP;

    reloadSoon();
}

function onWrapChange()
{
    if(wrap.get()=='repeat') cgl_wrap=CGL.Texture.WRAP_REPEAT;
    if(wrap.get()=='mirrored repeat') cgl_wrap=CGL.Texture.WRAP_MIRRORED_REPEAT;
    if(wrap.get()=='clamp to edge') cgl_wrap=CGL.Texture.WRAP_CLAMP_TO_EDGE;

    reloadSoon();
}

op.onFileChanged=function(fn)
{
    if(filename.get() && filename.get().indexOf(fn)>-1)
    {
        textureOut.set(null);
        textureOut.set(CGL.Texture.getTempTexture(cgl));

        realReload(true);
    }
};







};

Ops.Gl.Texture.prototype = new CABLES.Op();
CABLES.OPS["466394d4-6c1a-4e5d-a057-0063ab0f096a"]={f:Ops.Gl.Texture,objName:"Ops.Gl.Texture"};




// **************************************************************
// 
// Ops.Anim.Timer
// 
// **************************************************************

Ops.Anim.Timer = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var playPause=op.inValueBool("Play",true);
var reset=op.inTriggerButton("Reset");
var outTime=op.outValue("Time");
var inSpeed=op.inValue("Speed",1);

var timer=new CABLES.Timer();

playPause.onChange=setState;
setState();

function setState()
{
    if(playPause.get())
    {
        timer.play();
        op.patch.addOnAnimFrame(op);
    }
    else
    {
        timer.pause();
        op.patch.removeOnAnimFrame(op);
    }
}

reset.onTriggered=function()
{
    timer.setTime(0);
    outTime.set(0);
};

op.onAnimFrame=function()
{
    timer.update();
    outTime.set(timer.get()*inSpeed.get());

};


};

Ops.Anim.Timer.prototype = new CABLES.Op();
CABLES.OPS["65ae3c2e-90d7-48fe-93df-30245f0bcf34"]={f:Ops.Anim.Timer,objName:"Ops.Anim.Timer"};




// **************************************************************
// 
// Ops.Math.Sine
// 
// **************************************************************

Ops.Math.Sine = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
// input
var value = op.inValue('value');

var phase = op.inValue('phase', 0.0);
var mul = op.inValue('frequency', 1.0);
var amplitude = op.inValue('amplitude', 1.0);
var invert = op.inValueBool("asine", false);

// output
var result = op.outValue('result');

var calculate = Math.sin;

phase.onChange = 
value.onChange = function()
{
    result.set(
        amplitude.get() * calculate( ( value.get()*mul.get() ) + phase.get() )
    );
};

invert.onChange = function()
{
    if(invert.get()) calculate = Math.asin;
    else calculate = Math.sin;
}


};

Ops.Math.Sine.prototype = new CABLES.Op();
CABLES.OPS["d24da018-9f3d-428b-85c9-6ff14d77548b"]={f:Ops.Math.Sine,objName:"Ops.Math.Sine"};




// **************************************************************
// 
// Ops.Math.Multiply
// 
// **************************************************************

Ops.Math.Multiply = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const number1=op.addInPort(new CABLES.Port(op,"number1"));
const number2=op.addInPort(new CABLES.Port(op,"number2"));
const result=op.addOutPort(new CABLES.Port(op,"result"));

function update()
{
    const n1=number1.get();
    const n2=number2.get();

    if(isNaN(n1))n1=0;
    if(isNaN(n2))n2=0;

    result.set( n1*n2 );
}

number1.onChange=update;
number2.onChange=update;

number1.set(1);
number2.set(2);


};

Ops.Math.Multiply.prototype = new CABLES.Op();
CABLES.OPS["1bbdae06-fbb2-489b-9bcc-36c9d65bd441"]={f:Ops.Math.Multiply,objName:"Ops.Math.Multiply"};




// **************************************************************
// 
// Ops.Sequence
// 
// **************************************************************

Ops.Sequence = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const exe=op.inTrigger("exe");
const exes=[];
const triggers=[];
const num=16;
exe.onTriggered=triggerAll;

function triggerAll()
{
    for(var i=0;i<triggers.length;i++) triggers[i].trigger();
}

for(var i=0;i<num;i++)
{
    triggers.push( op.addOutPort(new CABLES.Port(op,"trigger "+i,CABLES.OP_PORT_TYPE_FUNCTION)) );
    
    if(i<num-1)
    {
        var newExe=op.addInPort(new CABLES.Port(op,"exe "+i,CABLES.OP_PORT_TYPE_FUNCTION));
        newExe.onTriggered=triggerAll;
        exes.push( newExe );
    }
}


};

Ops.Sequence.prototype = new CABLES.Op();
CABLES.OPS["a466bc1f-06e9-4595-8849-bffb9fe22f99"]={f:Ops.Sequence,objName:"Ops.Sequence"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.ImageCompose
// 
// **************************************************************

Ops.Gl.TextureEffects.ImageCompose = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const render=op.inTrigger("render");
const useVPSize=op.addInPort(new CABLES.Port(op,"use viewport size",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));
const width=op.inValueInt("width");
const height=op.inValueInt("height");

const tfilter=op.inValueSelect("filter",['nearest','linear','mipmap'],"linear");
const twrap=op.inValueSelect("wrap",['clamp to edge','repeat','mirrored repeat']);
const bgAlpha=op.inValueSlider("Background Alpha",1);
const fpTexture=op.inValueBool("HDR");

const trigger=op.outTrigger("trigger")
const texOut=op.outTexture("texture_out");

const outRatio=op.outValue("Aspect Ratio");

texOut.set(null);
var cgl=op.patch.cgl;
var effect=null;
var tex=null;

var w=8,h=8;
var prevViewPort=[0,0,0,0];
var reInitEffect=true;

var bgFrag=''
    .endl()+'uniform float a;'
    .endl()+'void main()'
    .endl()+'{'
    .endl()+'   outColor= vec4(0.0,0.0,0.0,a);'
    .endl()+'}';
var bgShader=new CGL.Shader(cgl,'imgcompose bg');
bgShader.setSource(bgShader.getDefaultVertexShader(),bgFrag);
var uniBgAlpha=new CGL.Uniform(bgShader,'f','a',bgAlpha);

var selectedFilter=CGL.Texture.FILTER_LINEAR;
var selectedWrap=CGL.Texture.WRAP_CLAMP_TO_EDGE;

function initEffect()
{
    if(effect)effect.delete();
    if(tex)tex.delete();

    effect=new CGL.TextureEffect(cgl,{"isFloatingPointTexture":fpTexture.get()});

    tex=new CGL.Texture(cgl,
        {
            "name":"image compose",
            "isFloatingPointTexture":fpTexture.get(),
            "filter":selectedFilter,
            "wrap":selectedWrap,
            "width": Math.ceil(width.get()),
            "height": Math.ceil(height.get()),
        });

    effect.setSourceTexture(tex);
    texOut.set(null);
    // texOut.set(effect.getCurrentSourceTexture());

    reInitEffect=false;

    // op.log("reinit effect");
    // tex.printInfo();
}

fpTexture.onChange=function()
{
    reInitEffect=true;
};

function updateResolution()
{
    if(!effect)initEffect();

    if(useVPSize.get())
    {
        w=cgl.getViewPort()[2];
        h=cgl.getViewPort()[3];
    }
    else
    {
        w=Math.ceil(width.get());
        h=Math.ceil(height.get());
    }

    if((w!=tex.width || h!= tex.height) && (w!==0 && h!==0))
    {
        height.set(h);
        width.set(w);
        tex.setSize(w,h);
        outRatio.set(w/h);
        effect.setSourceTexture(tex);
    }

    if(texOut.get())
        if(!texOut.get().isPowerOfTwo() )
        {
            if(!op.uiAttribs.hint)
                op.uiAttr(
                    {
                        hint:'texture dimensions not power of two! - texture filtering will not work.',
                        warning:null
                    });
        }
        else
        if(op.uiAttribs.hint)
        {
            op.uiAttr({hint:null,warning:null}); //todo only when needed...
        }

}


function updateSizePorts()
{
    if(useVPSize.get())
    {
        width.setUiAttribs({greyout:true});
        height.setUiAttribs({greyout:true});
    }
    else
    {
        width.setUiAttribs({greyout:false});
        height.setUiAttribs({greyout:false});
    }
}


useVPSize.onChange=function()
{
    updateSizePorts();
    if(useVPSize.get())
    {
        width.onChange=null;
        height.onChange=null;
    }
    else
    {
        width.onChange=updateResolution;
        height.onChange=updateResolution;
    }
    updateResolution();

};


op.preRender=function()
{
    doRender();
    bgShader.bind();
};


var doRender=function()
{
    if(!effect || reInitEffect)
    {
        initEffect();
    }
    var vp=cgl.getViewPort();
    prevViewPort[0]=vp[0];
    prevViewPort[1]=vp[1];
    prevViewPort[2]=vp[2];
    prevViewPort[3]=vp[3];


    cgl.gl.blendFunc(cgl.gl.SRC_ALPHA, cgl.gl.ONE_MINUS_SRC_ALPHA);
    // cgl.gl.blendFunc(cgl.gl.SRC_ALPHA,cgl.gl.ONE_MINUS_SRC_ALPHA);



    updateResolution();

    cgl.currentTextureEffect=effect;
    effect.setSourceTexture(tex);

    effect.startEffect();

    // render background color...
    cgl.setShader(bgShader);
    cgl.currentTextureEffect.bind();
    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();

    texOut.set(effect.getCurrentSourceTexture());
    // texOut.set(effect.getCurrentTargetTexture());


    // if(effect.getCurrentSourceTexture.filter==CGL.Texture.FILTER_MIPMAP)
    // {
    //         this._cgl.gl.bindTexture(this._cgl.gl.TEXTURE_2D, effect.getCurrentSourceTexture.tex);
    //         effect.getCurrentSourceTexture.updateMipMap();
    //     // else
    //     // {
    //     //     this._cgl.gl.bindTexture(this._cgl.gl.TEXTURE_2D, this._textureSource.tex);;
    //     //     this._textureSource.updateMipMap();
    //     // }

    //     this._cgl.gl.bindTexture(this._cgl.gl.TEXTURE_2D, null);
    // }

    effect.endEffect();

    cgl.setViewPort(prevViewPort[0],prevViewPort[1],prevViewPort[2],prevViewPort[3]);


    cgl.gl.blendFunc(cgl.gl.SRC_ALPHA,cgl.gl.ONE_MINUS_SRC_ALPHA);

    cgl.currentTextureEffect=null;
};


function onWrapChange()
{
    if(twrap.get()=='repeat') selectedWrap=CGL.Texture.WRAP_REPEAT;
    if(twrap.get()=='mirrored repeat') selectedWrap=CGL.Texture.WRAP_MIRRORED_REPEAT;
    if(twrap.get()=='clamp to edge') selectedWrap=CGL.Texture.WRAP_CLAMP_TO_EDGE;

    reInitEffect=true;
    updateResolution();
}

twrap.set('clamp to edge');
twrap.onChange=onWrapChange;

function onFilterChange()
{
    if(tfilter.get()=='nearest') selectedFilter=CGL.Texture.FILTER_NEAREST;
    if(tfilter.get()=='linear')  selectedFilter=CGL.Texture.FILTER_LINEAR;
    if(tfilter.get()=='mipmap')  selectedFilter=CGL.Texture.FILTER_MIPMAP;

    reInitEffect=true;
    updateResolution();
    // effect.setSourceTexture(tex);
    // updateResolution();
}

tfilter.set('linear');
tfilter.onChange=onFilterChange;

useVPSize.set(true);
render.onTriggered=doRender;

width.set(640);
height.set(360);
updateSizePorts();

};

Ops.Gl.TextureEffects.ImageCompose.prototype = new CABLES.Op();
CABLES.OPS["5c04608d-1e42-4e36-be00-1be4a81fc309"]={f:Ops.Gl.TextureEffects.ImageCompose,objName:"Ops.Gl.TextureEffects.ImageCompose"};




// **************************************************************
// 
// Ops.Gl.Render2Texture
// 
// **************************************************************

Ops.Gl.Render2Texture = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var cgl=op.patch.cgl;

var render=op.inTrigger('render');
var useVPSize=op.addInPort(new CABLES.Port(op,"use viewport size",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));

var width=op.inValueInt("texture width");
var height=op.inValueInt("texture height");
var tfilter=op.addInPort(new CABLES.Port(op,"filter",CABLES.OP_PORT_TYPE_VALUE,{display:'dropdown',values:['nearest','linear','mipmap']}));

var msaa=op.inValueSelect("MSAA",["none","2x","4x","8x"],"none");
var trigger=op.outTrigger('trigger');
// var tex=op.addOutPort(new CABLES.Port(op,"texture",CABLES.OP_PORT_TYPE_TEXTURE,{preview:true}));
// var texDepth=op.addOutPort(new CABLES.Port(op,"textureDepth",CABLES.OP_PORT_TYPE_TEXTURE));

var tex=op.outTexture("texture");
var texDepth=op.outTexture("textureDepth");

var fpTexture=op.inValueBool("HDR");
var depth=op.inValueBool("Depth",true);
var clear=op.inValueBool("Clear",true);

var fb=null;

width.set(512);
height.set(512);
useVPSize.set(true);
tfilter.set('linear');
var reInitFb=true;

op.setPortGroup('Alignment',[useVPSize,width,height,tfilter]);


// todo why does it only work when we render a mesh before>?>?????
// only happens with matcap material with normal map....

useVPSize.onChange=updateVpSize;
function updateVpSize()
{
    if(useVPSize.get())
    {
        width.setUiAttribs({hidePort:true,greyout:true});
        height.setUiAttribs({hidePort:true,greyout:true});
    }
    else
    {
        width.setUiAttribs({hidePort:false,greyout:false});
        height.setUiAttribs({hidePort:false,greyout:false});
    }
}

fpTexture.onChange=function()
{
    reInitFb=true;
};

depth.onChange=function()
{
    reInitFb=true;
};

clear.onChange=function()
{
    reInitFb=true;
};

var onFilterChange=function()
{
    reInitFb=true;
};

msaa.onChange=function()
{
    reInitFb=true;
};

function doRender()
{
    if(!fb || reInitFb)
    {
        if(fb) fb.delete();
        if(cgl.glVersion>=2)
        {
            var ms=true;
            var msSamples=4;

            if(msaa.get()=="none")
            {
                msSamples=0;
                ms=false;
            }
            if(msaa.get()=="2x")msSamples=2;
            if(msaa.get()=="4x")msSamples=4;
            if(msaa.get()=="8x")msSamples=8;

            fb=new CGL.Framebuffer2(cgl,8,8,
            {
                isFloatingPointTexture:fpTexture.get(),
                multisampling:ms,
                depth:depth.get(),
                multisamplingSamples:msSamples,
                clear:clear.get()
            });
        }
        else
        {
            fb=new CGL.Framebuffer(cgl,8,8,{isFloatingPointTexture:fpTexture.get()});
        }

        if(tfilter.get()=='nearest') fb.setFilter(CGL.Texture.FILTER_NEAREST);
            else if(tfilter.get()=='linear') fb.setFilter(CGL.Texture.FILTER_LINEAR);
            else if(tfilter.get()=='mipmap') fb.setFilter(CGL.Texture.FILTER_MIPMAP);




        texDepth.set( fb.getTextureDepth() );
        reInitFb=false;
    }

    if(useVPSize.val)
    {
        width.set( cgl.getViewPort()[2] );
        height.set( cgl.getViewPort()[3] );
    }

    if(fb.getWidth()!=Math.ceil(width.get()) || fb.getHeight()!=Math.ceil(height.get()) )
    {
        fb.setSize(
            Math.max(1,Math.ceil(width.get())),
            Math.max(1,Math.ceil(height.get())) );
    }

    fb.renderStart(cgl);

    trigger.trigger();
    fb.renderEnd(cgl);

    cgl.resetViewPort();

    tex.set( fb.getTextureColor() );
}


render.onTriggered=doRender;


tfilter.onValueChange(onFilterChange);
updateVpSize();

};

Ops.Gl.Render2Texture.prototype = new CABLES.Op();
CABLES.OPS["d01fa820-396c-4cb5-9d78-6b14762852af"]={f:Ops.Gl.Render2Texture,objName:"Ops.Gl.Render2Texture"};




// **************************************************************
// 
// Ops.Gl.Matrix.OrbitControls
// 
// **************************************************************

Ops.Gl.Matrix.OrbitControls = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const render=op.inTrigger("render");
const minDist=op.addInPort(new CABLES.Port(op,"min distance",CABLES.OP_PORT_TYPE_VALUE));
const maxDist=op.addInPort(new CABLES.Port(op,"max distance",CABLES.OP_PORT_TYPE_VALUE));

const minRotY=op.inValue("min rot y",0);
const maxRotY=op.inValue("max rot y",0);

const initialAxis=op.addInPort(new CABLES.Port(op,"initial axis y",CABLES.OP_PORT_TYPE_VALUE,{display:'range'}));
const initialX=op.addInPort(new CABLES.Port(op,"initial axis x",CABLES.OP_PORT_TYPE_VALUE,{display:'range'}));
const initialRadius=op.inValue("initial radius",0);



const mul=op.addInPort(new CABLES.Port(op,"mul",CABLES.OP_PORT_TYPE_VALUE));

const smoothness=op.inValueSlider("Smoothness",1.0);
const restricted=op.addInPort(new CABLES.Port(op,"restricted",CABLES.OP_PORT_TYPE_VALUE,{display:'bool'}));

const active=op.inValueBool("Active",true);

const inReset=op.inTriggerButton("Reset");

const allowPanning=op.inValueBool("Allow Panning",true);
const allowZooming=op.inValueBool("Allow Zooming",true);
const allowRotation=op.inValueBool("Allow Rotation",true);
const pointerLock=op.inValueBool("Pointerlock",false);

const speedX=op.inValue("Speed X",1);
const speedY=op.inValue("Speed Y",1);

const trigger=op.outTrigger("trigger")
const outRadius=op.addOutPort(new CABLES.Port(op,"radius",CABLES.OP_PORT_TYPE_VALUE));
const outYDeg=op.addOutPort(new CABLES.Port(op,"Rot Y",CABLES.OP_PORT_TYPE_VALUE));
const outXDeg=op.addOutPort(new CABLES.Port(op,"Rot X",CABLES.OP_PORT_TYPE_VALUE));

restricted.set(true);
mul.set(1);
minDist.set(0.05);
maxDist.set(99999);

inReset.onTriggered=reset;

const cgl=op.patch.cgl;
var eye=vec3.create();
var vUp=vec3.create();
var vCenter=vec3.create();
var viewMatrix=mat4.create();
var vOffset=vec3.create();

initialAxis.set(0.5);


var mouseDown=false;
var radius=5;
outRadius.set(radius);

var lastMouseX=0,lastMouseY=0;
var percX=0,percY=0;


vec3.set(vCenter, 0,0,0);
vec3.set(vUp, 0,1,0);

var tempEye=vec3.create();
var finalEye=vec3.create();
var tempCenter=vec3.create();
var finalCenter=vec3.create();

var px=0;
var py=0;

var divisor=1;
var element=null;
updateSmoothness();

op.onDelete=unbind;

var doLockPointer=false;

pointerLock.onChange=function()
{
    doLockPointer=pointerLock.get();
    console.log("doLockPointer",doLockPointer);
};

function reset()
{
    px=px%(Math.PI*2);
    py=py%(Math.PI*2);

    percX=(initialX.get()*Math.PI*2);
    percY=(initialAxis.get()-0.5);
    radius=initialRadius.get();
    eye=circlePos( percY );
}

function updateSmoothness()
{
    divisor=smoothness.get()*10+1.0;
}

smoothness.onChange=updateSmoothness;

var initializing=true;

function ip(val,goal)
{
    if(initializing)return goal;
    return val+(goal-val)/divisor;
}

var lastPy=0;

render.onTriggered=function()
{
    cgl.pushViewMatrix();

    px=ip(px,percX);
    py=ip(py,percY);

    var degY=(py+0.5)*180;


    if(minRotY.get()!==0 && degY<minRotY.get())
    {
        degY=minRotY.get();
        py=lastPy;
    }
    else if(maxRotY.get()!==0 && degY>maxRotY.get())
    {
        degY=maxRotY.get();
        py=lastPy;
    }
    else
    {
        lastPy=py;
    }

    outYDeg.set( degY );
    // outXDeg.set( (px)*180 );
    outXDeg.set( (px)*CGL.RAD2DEG );


    circlePosi(eye, py );

    vec3.add(tempEye, eye, vOffset);
    vec3.add(tempCenter, vCenter, vOffset);

    finalEye[0]=ip(finalEye[0],tempEye[0]);
    finalEye[1]=ip(finalEye[1],tempEye[1]);
    finalEye[2]=ip(finalEye[2],tempEye[2]);

    finalCenter[0]=ip(finalCenter[0],tempCenter[0]);
    finalCenter[1]=ip(finalCenter[1],tempCenter[1]);
    finalCenter[2]=ip(finalCenter[2],tempCenter[2]);

    mat4.lookAt(viewMatrix, finalEye, finalCenter, vUp);
    mat4.rotate(viewMatrix, viewMatrix, px, vUp);
    mat4.multiply(cgl.vMatrix,cgl.vMatrix,viewMatrix);

    trigger.trigger();
    cgl.popViewMatrix();
    initializing=false;
};

function circlePosi(vec,perc)
{
    const mmul=mul.get();
    if(radius<minDist.get()*mmul)radius=minDist.get()*mmul;
    if(radius>maxDist.get()*mmul)radius=maxDist.get()*mmul;

    outRadius.set(radius*mmul);

    var i=0,degInRad=0;
    // var vec=vec3.create();
    degInRad = 360*perc/2*CGL.DEG2RAD;
    vec3.set(vec,
        Math.cos(degInRad)*radius*mmul,
        Math.sin(degInRad)*radius*mmul,
        0);
    return vec;
}


function circlePos(perc)
{
    const mmul=mul.get();
    if(radius<minDist.get()*mmul)radius=minDist.get()*mmul;
    if(radius>maxDist.get()*mmul)radius=maxDist.get()*mmul;

    outRadius.set(radius*mmul);

    var i=0,degInRad=0;
    var vec=vec3.create();
    degInRad = 360*perc/2*CGL.DEG2RAD;
    vec3.set(vec,
        Math.cos(degInRad)*radius*mmul,
        Math.sin(degInRad)*radius*mmul,
        0);
    return vec;
}

function onmousemove(event)
{
    if(!mouseDown) return;

    var x = event.clientX;
    var y = event.clientY;

    var movementX=(x-lastMouseX)*speedX.get();
    var movementY=(y-lastMouseY)*speedY.get();

    if(doLockPointer)
    {
        movementX=event.movementX*mul.get();
        movementY=event.movementY*mul.get();
    }

    if(event.which==3 && allowPanning.get())
    {
        vOffset[2]+=movementX*0.01*mul.get();
        vOffset[1]+=movementY*0.01*mul.get();
    }
    else
    if(event.which==2 && allowZooming.get())
    {
        radius+=movementY*0.05;
        eye=circlePos(percY);
    }
    else
    {
        if(allowRotation.get())
        {
            percX+=movementX*0.003;
            percY+=movementY*0.002;

            if(restricted.get())
            {
                if(percY>0.5)percY=0.5;
                if(percY<-0.5)percY=-0.5;
            }
        }
    }

    lastMouseX=x;
    lastMouseY=y;
}

function onMouseDown(event)
{
    lastMouseX = event.clientX;
    lastMouseY = event.clientY;
    mouseDown=true;

    if(doLockPointer)
    {
        var el=op.patch.cgl.canvas;
        el.requestPointerLock = el.requestPointerLock || el.mozRequestPointerLock || el.webkitRequestPointerLock;
        if(el.requestPointerLock) el.requestPointerLock();
        else console.log("no t found");
        // document.addEventListener("mousemove", onmousemove, false);

        document.addEventListener('pointerlockchange', lockChange, false);
        document.addEventListener('mozpointerlockchange', lockChange, false);
        document.addEventListener('webkitpointerlockchange', lockChange, false);
    }
}

function onMouseUp()
{
    mouseDown=false;
    // cgl.canvas.style.cursor='url(/ui/img/rotate.png),pointer';

    if(doLockPointer)
    {
        document.removeEventListener('pointerlockchange', lockChange, false);
        document.removeEventListener('mozpointerlockchange', lockChange, false);
        document.removeEventListener('webkitpointerlockchange', lockChange, false);

        if(document.exitPointerLock) document.exitPointerLock();
        document.removeEventListener("mousemove", onmousemove, false);
    }
}

function lockChange()
{
    var el=op.patch.cgl.canvas;

    if (document.pointerLockElement === el || document.mozPointerLockElement === el || document.webkitPointerLockElement === el)
    {
        document.addEventListener("mousemove", onmousemove, false);
        console.log("listening...");
    }
}

function onMouseEnter(e)
{
    // cgl.canvas.style.cursor='url(/ui/img/rotate.png),pointer';
}

initialRadius.onValueChange(function()
{
    radius=initialRadius.get();
    reset();
});

initialX.onValueChange(function()
{
    px=percX=(initialX.get()*Math.PI*2);
});

initialAxis.onValueChange(function()
{
    py=percY=(initialAxis.get()-0.5);
    eye=circlePos(percY);
});

var onMouseWheel=function(event)
{
    if(allowZooming.get())
    {
        var delta=CGL.getWheelSpeed(event)*0.06;
        radius+=(parseFloat(delta))*1.2;

        eye=circlePos(percY);
        event.preventDefault();
    }
};

var ontouchstart=function(event)
{
    doLockPointer=false;
    if(event.touches && event.touches.length>0) onMouseDown(event.touches[0]);
};

var ontouchend=function(event)
{
    doLockPointer=false;
    onMouseUp();
};

var ontouchmove=function(event)
{
    doLockPointer=false;
    if(event.touches && event.touches.length>0) onmousemove(event.touches[0]);
};

active.onChange=function()
{
    if(active.get())bind();
        else unbind();
}


this.setElement=function(ele)
{
    unbind();
    element=ele;
    bind();
}

function bind()
{
    element.addEventListener('mousemove', onmousemove);
    element.addEventListener('mousedown', onMouseDown);
    element.addEventListener('mouseup', onMouseUp);
    element.addEventListener('mouseleave', onMouseUp);
    element.addEventListener('mouseenter', onMouseEnter);
    element.addEventListener('contextmenu', function(e){e.preventDefault();});
    element.addEventListener('wheel', onMouseWheel);

    element.addEventListener('touchmove', ontouchmove);
    element.addEventListener('touchstart', ontouchstart);
    element.addEventListener('touchend', ontouchend);
}

function unbind()
{
    if(!element)return;

    element.removeEventListener('mousemove', onmousemove);
    element.removeEventListener('mousedown', onMouseDown);
    element.removeEventListener('mouseup', onMouseUp);
    element.removeEventListener('mouseleave', onMouseUp);
    element.removeEventListener('mouseenter', onMouseUp);
    element.removeEventListener('wheel', onMouseWheel);

    element.removeEventListener('touchmove', ontouchmove);
    element.removeEventListener('touchstart', ontouchstart);
    element.removeEventListener('touchend', ontouchend);
}

eye=circlePos(0);
this.setElement(cgl.canvas);


bind();

initialX.set(0.25);
initialRadius.set(0.05);


};

Ops.Gl.Matrix.OrbitControls.prototype = new CABLES.Op();
CABLES.OPS["eaf4f7ce-08a3-4d1b-b9f4-ebc0b7b1cde1"]={f:Ops.Gl.Matrix.OrbitControls,objName:"Ops.Gl.Matrix.OrbitControls"};




// **************************************************************
// 
// Ops.Gl.Shader.MatCapMaterialNew
// 
// **************************************************************

Ops.Gl.Shader.MatCapMaterialNew = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={matcap_frag:"\n{{MODULES_HEAD}}\n\nIN vec3 norm;\nIN vec2 texCoord;\nUNI sampler2D tex;\nIN vec2 vNorm;\nUNI mat4 viewMatrix;\n\nUNI float repeatX;\nUNI float repeatY;\nUNI float opacity;\n\nUNI float r;\nUNI float g;\nUNI float b;\n\nIN vec3 e;\n\n\n\n#ifdef HAS_DIFFUSE_TEXTURE\n   UNI sampler2D texDiffuse;\n#endif\n\n#ifdef USE_SPECULAR_TEXTURE\n   UNI sampler2D texSpec;\n   UNI sampler2D texSpecMatCap;\n#endif\n\n#ifdef HAS_AO_TEXTURE\n    UNI sampler2D texAo;\n    UNI float aoIntensity;\n#endif\n\n#ifdef HAS_NORMAL_TEXTURE\n   IN vec3 vBiTangent;\n   IN vec3 vTangent;\n\n   UNI sampler2D texNormal;\n   UNI mat4 normalMatrix;\n   \n   vec2 vNormt;\n#endif\n\n#ifdef CALC_SSNORMALS\n    // from https://www.enkisoftware.com/devlogpost-20150131-1-Normal_generation_in_the_pixel_shader\n    IN vec3 eye_relative_pos;\n#endif\n\n\nconst float normalScale=0.4;\n\nconst vec2 invAtan = vec2(0.1591, 0.3183);\nvec2 sampleSphericalMap(vec3 direction)\n{\n    vec2 uv = vec2(atan(direction.z, direction.x), asin(direction.y));\n    uv *= invAtan;\n    uv += 0.5;\n    return uv;\n}\n\n\nvoid main()\n{\n    vec2 vnOrig=vNorm;\n    vec2 vn=vNorm;\n\n\n\n    #ifdef HAS_TEXTURES\n        vec2 texCoords=texCoord;\n        {{MODULE_BEGIN_FRAG}}\n    #endif\n\n    #ifdef CALC_SSNORMALS\n    \tvec3 dFdxPos = dFdx( eye_relative_pos );\n    \tvec3 dFdyPos = dFdy( eye_relative_pos );\n    \tvec3 ssn = normalize( cross(dFdxPos,dFdyPos ));\n    \t\n        vec3 rr = reflect( e, ssn );\n        float ssm = 2. * sqrt( \n            pow(rr.x, 2.0)+\n            pow(rr.y, 2.0)+\n            pow(rr.z + 1.0, 2.0)\n        );\n\n\n        vn = (rr.xy / ssm + 0.5);\n        \n        vn.t=clamp(vn.t, 0.0, 1.0);\n        vn.s=clamp(vn.s, 0.0, 1.0);\n        \n        // float dst = dot(abs(coord-center), vec2(1.0));\n        // float aaf = fwidth(dst);\n        // float alpha = smoothstep(radius - aaf, radius, dst);\n\n    #endif\n\n   #ifdef HAS_NORMAL_TEXTURE\n        vec3 tnorm=texture( texNormal, vec2(texCoord.x*repeatX,texCoord.y*repeatY) ).xyz * 2.0 - 1.0;\n        \n        tnorm = normalize(tnorm*normalScale);\n        \n        vec3 tangent;\n        vec3 binormal;\n        \n        #ifdef CALC_TANGENT\n            vec3 c1 = cross(norm, vec3(0.0, 0.0, 1.0));\n//            vec3 c2 = cross(norm, vec3(0.0, 1.0, 0.0));\n//            if(length(c1)>length(c2)) tangent = c2;\n//                else tangent = c1;\n            tangent = c1;\n            tangent = normalize(tangent);\n            binormal = cross(norm, tangent);\n            binormal = normalize(binormal);\n        #endif\n\n        #ifndef CALC_TANGENT\n            tangent=normalize(vTangent);\n//            tangent.y*=-13.0;\n//            binormal=vBiTangent*norm;\n//            binormal.z*=-1.0;\n//            binormal=normalize(binormal);\n            binormal=normalize( cross( normalize(norm), normalize(vBiTangent) ));\n        // vBinormal = normalize( cross( vNormal, vTangent ) * tangent.w );\n\n        #endif\n\n        tnorm=normalize(tangent*tnorm.x + binormal*tnorm.y + norm*tnorm.z);\n\n        // vec3 n = normalize( mat3(normalMatrix) * (norm+tnorm*normalScale) );\n        vec3 n = normalize( mat3(normalMatrix) * (norm+tnorm*normalScale) );\n\n        vec3 re = reflect( e, n );\n        float m = 2. * sqrt( \n            pow(re.x, 2.0)+\n            pow(re.y, 2.0)+\n            pow(re.z + 1.0, 2.0)\n        );\n        \n        vn = (re.xy / m + 0.5);\n        \n    #endif\n\n    vn.t=clamp(vn.t, 0.0, 1.0);\n    vn.s=clamp(vn.s, 0.0, 1.0);\n    \n    \n    vec4 col = texture( tex, vn );\n\n    #ifdef HAS_DIFFUSE_TEXTURE\n        col = col*texture( texDiffuse, vec2(texCoords.x*repeatX,texCoords.y*repeatY));\n    #endif\n\n    col.r*=r;\n    col.g*=g;\n    col.b*=b;\n\n\n    #ifdef HAS_AO_TEXTURE\n        col = col*\n            mix(\n                vec4(1.0,1.0,1.0,1.0),\n                texture( texAo, vec2(texCoords.x*repeatX,texCoords.y*repeatY)),\n                aoIntensity\n                );\n    #endif\n\n    #ifdef USE_SPECULAR_TEXTURE\n        vec4 spec = texture( texSpecMatCap, vn );\n        spec*= texture( texSpec, vec2(texCoords.x*repeatX,texCoords.y*repeatY) );\n        col+=spec;\n    #endif\n\n    col.a*=opacity;\n\n    {{MODULE_COLOR}}\n\n    outColor = col;\n\n}",matcap_vert:"\nIN vec3 vPosition;\nIN vec2 attrTexCoord;\nIN vec3 attrVertNormal;\nIN float attrVertIndex;\n\n#ifdef HAS_NORMAL_TEXTURE\n   IN vec3 attrTangent;\n   IN vec3 attrBiTangent;\n\n   OUT vec3 vBiTangent;\n   OUT vec3 vTangent;\n#endif\n\nOUT vec2 texCoord;\nOUT vec3 norm;\nUNI mat4 projMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\n\nOUT vec2 vNorm;\nOUT vec3 e;\n\n#ifndef INSTANCING\n    UNI mat4 normalMatrix;\n#endif\n\n\n{{MODULES_HEAD}}\n\n#ifdef CALC_SSNORMALS\n    // from https://www.enkisoftware.com/devlogpost-20150131-1-Normal_generation_in_the_pixel_shader\n    OUT vec3 eye_relative_pos;\n    UNI vec3 camPos;\n#endif\n\n\n\nvoid main()\n{\n    texCoord=attrTexCoord;\n    norm=attrVertNormal;\n    mat4 mMatrix=modelMatrix;\n    mat4 mvMatrix;\n    \n    #ifdef HAS_NORMAL_TEXTURE\n        vTangent=attrTangent;\n        vBiTangent=attrBiTangent;\n    #endif\n\n    vec4 pos = vec4( vPosition, 1. );\n\n    {{MODULE_VERTEX_POSITION}}\n\n\n    mvMatrix= viewMatrix * mMatrix;\n\n    #ifdef INSTANCING\n        mat4 normalMatrix=inverse(transpose(mvMatrix));\n    #endif\n    \n    e = normalize( vec3( mvMatrix * pos ) );\n    vec3 n = normalize( mat3(normalMatrix) * norm );\n    \n\n    // mat3 nMatrix = transpose(inverse(mat3(mMatrix)));\n    // vec3 n = normalize( mat3(nMatrix) * norm );\n    // norm=n;\n\n    vec3 r = reflect( e, n );\n    \n    \n    \n    \n    float m = 2. * sqrt(\n        pow(r.x, 2.0)+\n        pow(r.y, 2.0)+\n        pow(r.z + 1.0, 2.0)\n    );\n    vNorm = r.xy / m + 0.5;\n\n    #ifdef DO_PROJECT_COORDS_XY\n       texCoord=(projMatrix * mvMatrix*pos).xy*0.1;\n    #endif\n\n    #ifdef DO_PROJECT_COORDS_YZ\n       texCoord=(projMatrix * mvMatrix*pos).yz*0.1;\n    #endif\n\n    #ifdef DO_PROJECT_COORDS_XZ\n        texCoord=(projMatrix * mvMatrix*pos).xz*0.1;\n    #endif\n\n    #ifdef CALC_SSNORMALS\n        eye_relative_pos = (mvMatrix * pos ).xyz - camPos;\n    #endif\n\n\n\n   gl_Position = projMatrix * mvMatrix * pos;\n\n}",};
const render=op.inTrigger("render");
const textureMatcap=op.inTexture('MatCap');
const textureDiffuse=op.inTexture('Diffuse');
const textureNormal=op.inTexture('Normal');
const textureSpec=op.inTexture('Specular');
const textureSpecMatCap=op.inTexture('Specular MatCap');
const textureAo=op.inTexture('AO Texture');
const r=op.inValueSlider('r',1);
const g=op.inValueSlider('g',1);
const b=op.inValueSlider('b',1);
const pOpacity=op.inValueSlider("Opacity",1);
const aoIntensity=op.inValueSlider("AO Intensity",1.0);
const repeatX=op.inValue("Repeat X",1);
const repeatY=op.inValue("Repeat Y",1);
const calcTangents = op.inValueBool("calc normal tangents",true);
const projectCoords=op.inValueSelect('projectCoords',['no','xy','yz','xz'],'no');
const ssNormals=op.inValueBool("Screen Space Normals");
const next=op.outTrigger("trigger");
const shaderOut=op.outObject("Shader");

r.setUiAttribs({colorPick:true});
op.setPortGroup("Texture maps",[textureDiffuse,textureNormal,textureSpec,textureSpecMatCap,textureAo,]);
op.setPortGroup("Color",[r,g,b,pOpacity]);

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl,'MatCapMaterialNew');
var uniOpacity=new CGL.Uniform(shader,'f','opacity',pOpacity);

shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);
shader.bindTextures=bindTextures;
shader.setSource(attachments.matcap_vert,attachments.matcap_frag);
shaderOut.set(shader);

var textureMatcapUniform=null;
var textureDiffuseUniform=null;
var textureNormalUniform=null;
var textureSpecUniform=null;
var textureSpecMatCapUniform=null;
var textureAoUniform=null;
var repeatXUniform=new CGL.Uniform(shader,'f','repeatX',repeatX);
var repeatYUniform=new CGL.Uniform(shader,'f','repeatY',repeatY);
var aoIntensityUniform=new CGL.Uniform(shader,'f','aoIntensity',aoIntensity);
b.uniform=new CGL.Uniform(shader,'f','b',b);
g.uniform=new CGL.Uniform(shader,'f','g',g);
r.uniform=new CGL.Uniform(shader,'f','r',r);


calcTangents.onChange=updateDefines;
updateDefines();
updateMatcap();

function updateDefines()
{
    if(calcTangents.get()) shader.define('CALC_TANGENT');
        else shader.removeDefine('CALC_TANGENT');

}

ssNormals.onChange=function()
{
    if(ssNormals.get())
    {
        if(cgl.glVersion<2)
        {
            cgl.gl.getExtension('OES_standard_derivatives');
            shader.enableExtension('GL_OES_standard_derivatives');
        }

        shader.define('CALC_SSNORMALS');
    }
    else shader.removeDefine('CALC_SSNORMALS');
};

projectCoords.onChange=function()
{
    shader.removeDefine('DO_PROJECT_COORDS_XY');
    shader.removeDefine('DO_PROJECT_COORDS_YZ');
    shader.removeDefine('DO_PROJECT_COORDS_XZ');

    if(projectCoords.get()=='xy') shader.define('DO_PROJECT_COORDS_XY');
    else if(projectCoords.get()=='yz') shader.define('DO_PROJECT_COORDS_YZ');
    else if(projectCoords.get()=='xz') shader.define('DO_PROJECT_COORDS_XZ');
};

textureMatcap.onChange=updateMatcap;

function updateMatcap()
{
    if(textureMatcap.get())
    {
        if(textureMatcapUniform!==null)return;
        shader.removeUniform('tex');
        textureMatcapUniform=new CGL.Uniform(shader,'t','tex',0);
    }
    else
    {
        if(!CGL.defaultTextureMap)
        {
            var pixels=new Uint8Array(256*4);
            for(var x=0;x<16;x++)
            {
                for(var y=0;y<16;y++)
                {
                    var c=y*16;
                    c*=Math.min(1,(x+y/3)/8);
                    pixels[(x+y*16)*4+0]=pixels[(x+y*16)*4+1]=pixels[(x+y*16)*4+2]=c;
                    pixels[(x+y*16)*4+3]=255;
                }
            }

            CGL.defaultTextureMap=new CGL.Texture(cgl);
            CGL.defaultTextureMap.initFromData(pixels,16,16);
        }
        textureMatcap.set(CGL.defaultTextureMap);

        shader.removeUniform('tex');
        textureMatcapUniform=new CGL.Uniform(shader,'t','tex',0);
    }
}

textureDiffuse.onChange=function()
{
    if(textureDiffuse.get())
    {
        if(textureDiffuseUniform!==null)return;
        shader.define('HAS_DIFFUSE_TEXTURE');
        shader.removeUniform('texDiffuse');
        textureDiffuseUniform=new CGL.Uniform(shader,'t','texDiffuse',1);
    }
    else
    {
        shader.removeDefine('HAS_DIFFUSE_TEXTURE');
        shader.removeUniform('texDiffuse');
        textureDiffuseUniform=null;
    }
};

textureNormal.onChange=function()
{
    if(textureNormal.get())
    {
        if(textureNormalUniform!==null)return;
        shader.define('HAS_NORMAL_TEXTURE');
        shader.removeUniform('texNormal');
        textureNormalUniform=new CGL.Uniform(shader,'t','texNormal',2);
    }
    else
    {
        shader.removeDefine('HAS_NORMAL_TEXTURE');
        shader.removeUniform('texNormal');
        textureNormalUniform=null;
    }
};

textureAo.onChange=function()
{
    if(textureAo.get())
    {
        if(textureAoUniform!==null)return;
        shader.define('HAS_AO_TEXTURE');
        shader.removeUniform('texAo');
        textureAoUniform=new CGL.Uniform(shader,'t','texAo',5);
    }
    else
    {
        shader.removeDefine('HAS_AO_TEXTURE');
        shader.removeUniform('texAo');
        textureAoUniform=null;
    }
};

textureSpec.onChange=textureSpecMatCap.onChange=function()
{
    if(textureSpec.get() && textureSpecMatCap.get())
    {
        if(textureSpecUniform!==null)return;
        shader.define('USE_SPECULAR_TEXTURE');
        shader.removeUniform('texSpec');
        shader.removeUniform('texSpecMatCap');
        textureSpecUniform=new CGL.Uniform(shader,'t','texSpec',3);
        textureSpecMatCapUniform=new CGL.Uniform(shader,'t','texSpecMatCap',4);
    }
    else
    {
        shader.removeDefine('USE_SPECULAR_TEXTURE');
        shader.removeUniform('texSpec');
        shader.removeUniform('texSpecMatCap');
        textureSpecUniform=null;
        textureSpecMatCapUniform=null;
    }
};

function bindTextures()
{
    if(textureMatcap.get())     cgl.setTexture(0,textureMatcap.get().tex);
    if(textureDiffuse.get())    cgl.setTexture(1,textureDiffuse.get().tex);
    if(textureNormal.get())     cgl.setTexture(2,textureNormal.get().tex);
    if(textureSpec.get())       cgl.setTexture(3,textureSpec.get().tex);
    if(textureSpecMatCap.get()) cgl.setTexture(4,textureSpecMatCap.get().tex);
    if(textureAo.get())         cgl.setTexture(5,textureAo.get().tex);
};

op.onDelete=function()
{
    if(CGL.defaultTextureMap)
    {
        CGL.defaultTextureMap.delete();
        CGL.defaultTextureMap=null;
    }
};

op.preRender=function()
{
    shader.bind();
};

render.onTriggered=function()
{
    shader.bindTextures=bindTextures;
    cgl.setShader(shader);
    next.trigger();
    cgl.setPreviousShader();
};



};

Ops.Gl.Shader.MatCapMaterialNew.prototype = new CABLES.Op();
CABLES.OPS["7857ee9e-6d60-4c30-9bc0-dfdddf2b47ad"]={f:Ops.Gl.Shader.MatCapMaterialNew,objName:"Ops.Gl.Shader.MatCapMaterialNew"};




// **************************************************************
// 
// Ops.WebAudio.Output
// 
// **************************************************************

Ops.WebAudio.Output = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
op.name='audioOutput';
op.requirements=[CABLES.Requirements.WEBAUDIO];

var audioCtx = CABLES.WEBAUDIO.createAudioContext(op);

// constants
var VOLUME_DEFAULT = 1;
var VOLUME_MIN = 0;
var VOLUME_MAX = 1;

// vars
var gainNode = audioCtx.createGain();
var destinationNode = audioCtx.destination;
gainNode.connect(destinationNode);
var masterVolume = 1;

// inputs
var audioInPort = CABLES.WEBAUDIO.createAudioInPort(op, "Audio In", gainNode);
var volumePort = op.inValueSlider("Volume", VOLUME_DEFAULT);
var mutePort = op.inValueBool("Mute", false);

// functions
// sets the volume, multiplied by master volume
function setVolume() {
    var volume = volumePort.get() * masterVolume;
    if(volume >= VOLUME_MIN && volume <= VOLUME_MAX) {
        // gainNode.gain.value = volume;
        gainNode.gain.setValueAtTime(volume, audioCtx.currentTime);
    } else {
        // gainNode.gain.value = VOLUME_DEFAULT * masterVolume;
        gainNode.gain.setValueAtTime(VOLUME_DEFAULT * masterVolume, audioCtx.currentTime);
    }
}

function mute(b) {
    if(b) {
        // gainNode.gain.value = 0;
        gainNode.gain.setValueAtTime(0, audioCtx.currentTime);
    } else {
        setVolume();
    }
}

// change listeners
mutePort.onChange = function() {
    mute(mutePort.get());
};

volumePort.onChange = function() {
    if(mutePort.get()) {
        return;
    }
    setVolume();
};

op.onMasterVolumeChanged = function(v) {
    masterVolume = v;
    setVolume();
};




};

Ops.WebAudio.Output.prototype = new CABLES.Op();
CABLES.OPS["53fdbf4a-bc8d-4c5d-a698-f34fdeb53827"]={f:Ops.WebAudio.Output,objName:"Ops.WebAudio.Output"};




// **************************************************************
// 
// Ops.WebAudio.AudioBufferPlayer
// 
// **************************************************************

Ops.WebAudio.AudioBufferPlayer = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var audioCtx = CABLES.WEBAUDIO.createAudioContext(op);

// input ports
var audioBufferPort = op.inObject("Audio Buffer");
var playPort = op.inValueBool("Start / Stop", false);
var startTimePort = op.inValue("Start Time", 0);
var stopTimePort = op.inValue("Stop Time", 0);
var offsetPort = op.inValue("Offset", 0);
var autoPlayPort = op.inValueBool("Autoplay", false);
var loopPort = op.inValueBool("Loop", false);
var detunePort = op.inValue("Detune", 0);
var playbackRatePort = op.inValue("Playback Rate", 1);

// output ports
var audioOutPort = op.outObject("Audio Out");

// vars
var source = null;

// change listeners
audioBufferPort.onChange = function() {
    createAudioBufferSource();
    if(
        (autoPlayPort.get() && audioBufferPort.get()) ||
    (playPort.get() && audioBufferPort.get())
    ) {
        start(startTimePort.get());
    }
};
playPort.onChange = function() {
    if(source) {
        if(playPort.get()) {
            var startTime = startTimePort.get() || 0;
            start(startTime);    
        } else {
            var stopTime = stopTimePort.get() || 0;
            stop(stopTime);    
        } 
    }
};
loopPort.onChange = function() {
    if(source) {
        source.loop = loopPort.get() ? true : false;
    }
};

detunePort.onChange = setDetune;

function setDetune() {
    if(source) {
        var detune = detunePort.get() || 0;
        if(source.detune) {
            source.detune.setValueAtTime(
                detune,
                audioCtx.currentTime    
            );
        }
    }
}

playbackRatePort.onChange = setPlaybackRate;

function setPlaybackRate() {
    if(source) {
        var playbackRate = playbackRatePort.get() || 0;
        if(playbackRate >= source.playbackRate.minValue && playbackRate <= source.playbackRate.maxValue) {
            source.playbackRate.setValueAtTime(
                playbackRate,
                audioCtx.currentTime    
            );    
        }
    }
}

// functions
function createAudioBufferSource() {
    if(source)stop(0);
    source = audioCtx.createBufferSource();
    var buffer = audioBufferPort.get();
    if(buffer) {
        source.buffer = buffer;
    }
    source.onended = onPlaybackEnded;
    source.loop = loopPort.get();
    setPlaybackRate();
    setDetune();
    audioOutPort.set(source);
}

function start(time) {
    try {
        source.start(time,offsetPort.get()); // 0 = now
    } catch(e){
        // console.log(e);
    } // already playing!?
}

function stop(time) {
    try {
        source.stop(time); // 0 = now
    } catch(e) 
    {
        // console.log(e);
    } // not playing!?
}

function onPlaybackEnded() {
    createAudioBufferSource(); // we can only play back once, so we need to create a new one
}

};

Ops.WebAudio.AudioBufferPlayer.prototype = new CABLES.Op();
CABLES.OPS["05385277-92fc-4d49-b730-11f9ed5e5c0d"]={f:Ops.WebAudio.AudioBufferPlayer,objName:"Ops.WebAudio.AudioBufferPlayer"};




// **************************************************************
// 
// Ops.WebAudio.AudioBuffer
// 
// **************************************************************

Ops.WebAudio.AudioBuffer = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const audioCtx = CABLES.WEBAUDIO.createAudioContext(op);
const inUrlPort = op.addInPort( new CABLES.Port( op, "URL", CABLES.OP_PORT_TYPE_VALUE, { display: 'file', type: 'string', filter: 'audio'  } ));
const audioBufferPort = op.outObject("Audio Buffer");
const finishedLoadingPort = op.outValue("Finished Loading", false);
const sampleRatePort = op.outValue("Sample Rate", 0);
const lengthPort = op.outValue("Length", 0);
const durationPort = op.outValue("Duration", 0);
const numberOfChannelsPort = op.outValue("Number of Channels", 0);

// change listeners
inUrlPort.onChange = function() {
    var url=op.patch.getFilePath(inUrlPort.get());
    if(typeof url === 'string' && url.length > 1) {
        CABLES.WEBAUDIO.loadAudioFile(op.patch, url, onLoadFinished, onLoadFailed);
    }
};

function onLoadFinished(buffer) {
    lengthPort.set(buffer.length);
    durationPort.set(buffer.duration);
    numberOfChannelsPort.set(buffer.numberOfChannels);
    sampleRatePort.set(buffer.sampleRate);
    audioBufferPort.set(buffer);
    finishedLoadingPort.set(true);
    op.log("AudioBuffer loaded: ", buffer);
}

function onLoadFailed(e) {
    console.error("Error: Loading audio file failed: ", e);
    invalidateOutPorts();
}

function invalidateOutPorts() {
    lengthPort.set(0);
    durationPort.set(0);
    numberOfChannelsPort.set(0);
    sampleRatePort.set(0);
    audioBufferPort.set(0);
    finishedLoadingPort.set(false);
}

};

Ops.WebAudio.AudioBuffer.prototype = new CABLES.Op();
CABLES.OPS["2cf4b0a1-b657-405b-8bf9-8555dbd5c231"]={f:Ops.WebAudio.AudioBuffer,objName:"Ops.WebAudio.AudioBuffer"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Dither
// 
// **************************************************************

Ops.Gl.TextureEffects.Dither = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={dither_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float strength;\nUNI float amount;\nUNI float width;\nUNI float height;\nUNI float threshold;\n\nfloat lumi( vec4 col ) {\n    return (0.2126*col.r + 0.7152*col.g + 0.0722*col.b);\n}\n\n{{BLENDCODE}}\n\nfloat adjustFrag( mat4 adjustments,float val, vec2 coord )\n{\n    vec2 coordMod = mod(vec2(coord.x*width,coord.y*height), 4.0);\n    int xMod = int(coordMod.x);\n    int yMod = int(coordMod.y);\n\n    vec4 col;\n    if (xMod == 0) col = adjustments[0];\n        else if (xMod == 1) col = adjustments[1];\n        else if (xMod == 2) col = adjustments[2];\n        else if (xMod == 3) col = adjustments[3];\n\n    float adjustment;\n    if (yMod == 0) adjustment = col.x;\n        else if (yMod == 1) adjustment = col.y;\n        else if (yMod == 2) adjustment = col.z;\n        else if (yMod == 3) adjustment = col.w;\n\n    return val + (val * adjustment);\n}\n\nvoid main()\n{\n    mat4 adjustments = ((mat4(\n        1, 13, 4, 16,\n        9, 5, 12, 8,\n        3, 15, 2, 14,\n        11, 7, 10, 6\n    ) - 8.) *  1.0 / strength);\n\n    vec4 base=texture(tex,texCoord);\n    vec4 color;\n\n    float lum = lumi(base);\n    lum = adjustFrag(adjustments,lum, texCoord.xy);\n\n    if (lum > threshold) color = vec4(1, 1, 1, 1);\n        else color = vec4(0, 0, 0, 1);\n\n    vec4 col=vec4( _blend(base.rgb,color.rgb) ,1.0);\n    col=vec4( mix( col.rgb, base.rgb ,1.0-base.a*amount),1.0);\n  \toutColor= col;\n}",};
const
    render=op.inTrigger("Render"),
    blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal"),
    amount=op.inValueSlider("Amount",1),
    trigger=op.outTrigger("Trigger"),
    strength=op.inValue("strength",2),
    threshold=op.inValueSlider("threshold",0.35);

const
    cgl=op.patch.cgl,
    shader=new CGL.Shader(cgl),
    srcFrag=(attachments.dither_frag||'').replace("{{BLENDCODE}}",CGL.TextureEffect.getBlendCode());

shader.setSource(shader.getDefaultVertexShader(),srcFrag);

const textureUniform=new CGL.Uniform(shader,'t','tex',0),
    amountUniform=new CGL.Uniform(shader,'f','amount',amount),
    strengthUniform=new CGL.Uniform(shader,'f','strength',strength),
    uniWidth=new CGL.Uniform(shader,'f','width',0),
    uniHeight=new CGL.Uniform(shader,'f','height',0),
    unithreshold=new CGL.Uniform(shader,'f','threshold',threshold);

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    uniWidth.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().width);
    uniHeight.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().height);

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Dither.prototype = new CABLES.Op();
CABLES.OPS["4fb6167d-a9b0-4604-84c4-755b09fd8dd7"]={f:Ops.Gl.TextureEffects.Dither,objName:"Ops.Gl.TextureEffects.Dither"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.DrawImage
// 
// **************************************************************

Ops.Gl.TextureEffects.DrawImage = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={drawimage_frag:"#ifdef HAS_TEXTURES\n  IN vec2 texCoord;\n  UNI sampler2D tex;\n  UNI sampler2D image;\n#endif\n\nIN mat3 transform;\nUNI float rotate;\n{{BLENDCODE}}\n\n#ifdef HAS_TEXTUREALPHA\n   UNI sampler2D imageAlpha;\n#endif\n\nUNI float amount;\n\nvoid main()\n{\n   vec4 blendRGBA=vec4(0.0,0.0,0.0,1.0);\n   #ifdef HAS_TEXTURES\n       vec2 tc=texCoord;\n\n       #ifdef TEX_FLIP_X\n           tc.x=1.0-tc.x;\n       #endif\n       #ifdef TEX_FLIP_Y\n           tc.y=1.0-tc.y;\n       #endif\n\n       #ifdef TEX_TRANSFORM\n           vec3 coordinates=vec3(tc.x, tc.y,1.0);\n           tc=(transform * coordinates ).xy;\n       #endif\n\n       blendRGBA=texture(image,tc);\n\n       vec3 blend=blendRGBA.rgb;\n       vec4 baseRGBA=texture(tex,texCoord);\n       vec3 base=baseRGBA.rgb;\n\n       vec3 colNew=_blend(base,blend);\n\n       #ifdef REMOVE_ALPHA_SRC\n           blendRGBA.a=1.0;\n       #endif\n\n       #ifdef HAS_TEXTUREALPHA\n           vec4 colImgAlpha=texture(imageAlpha,texCoord);\n           float colImgAlphaAlpha=colImgAlpha.a;\n\n           #ifdef ALPHA_FROM_LUMINANCE\n               vec3 gray = vec3(dot(vec3(0.2126,0.7152,0.0722), colImgAlpha.rgb ));\n               colImgAlphaAlpha=(gray.r+gray.g+gray.b)/3.0;\n           #endif\n\n           blendRGBA.a=colImgAlphaAlpha*blendRGBA.a;\n           \n           #ifdef INVERT_ALPHA\n           blendRGBA.a=1.0-blendRGBA.a;\n           #endif\n       #endif\n\n\n   #endif\n\n   blendRGBA.rgb=mix( colNew, base ,1.0-blendRGBA.a*amount);\n   blendRGBA.a=1.0;\n\n\n   outColor= blendRGBA;\n}",drawimage_vert:"IN vec3 vPosition;\nIN vec2 attrTexCoord;\nIN vec3 attrVertNormal;\nOUT vec2 texCoord;\nOUT vec3 norm;\nUNI mat4 projMatrix;\nUNI mat4 mvMatrix;\n\nUNI float posX;\nUNI float posY;\nUNI float scale;\nUNI float rotate;\n\nOUT mat3 transform;\n\nvoid main()\n{\n    texCoord=attrTexCoord;\n    norm=attrVertNormal;\n\n    #ifdef TEX_TRANSFORM\n    vec3 coordinates=vec3(attrTexCoord.x, attrTexCoord.y,1.0);\n    float angle = radians( rotate );\n    vec2 scale= vec2(scale,scale);\n    vec2 translate= vec2(posX,posY);\n\n    transform = mat3(   scale.x * cos( angle ), scale.x * sin( angle ), 0.0,\n                        - scale.y * sin( angle ), scale.y * cos( angle ), 0.0,\n                        - 0.5 * scale.x * cos( angle ) + 0.5 * scale.y * sin( angle ) - 0.5 * translate.x*2.0 + 0.5,  - 0.5 * scale.x * sin( angle ) - 0.5 * scale.y * cos( angle ) - 0.5 * translate.y*2.0 + 0.5, 1.0);\n    #endif\n\n    gl_Position = projMatrix * mvMatrix * vec4(vPosition,  1.0);\n}",};
var render=op.inTrigger('render');
var amount=op.addInPort(new CABLES.Port(op,"amount",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));

var image=op.addInPort(new CABLES.Port(op,"image",CABLES.OP_PORT_TYPE_TEXTURE,{preview:true }));
var blendMode=CGL.TextureEffect.AddBlendSelect(op,"blendMode");

var imageAlpha=op.addInPort(new CABLES.Port(op,"imageAlpha",CABLES.OP_PORT_TYPE_TEXTURE,{preview:true }));
var alphaSrc=op.inValueSelect("alphaSrc",['alpha channel','luminance']);
var removeAlphaSrc=op.addInPort(new CABLES.Port(op,"removeAlphaSrc",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));

var invAlphaChannel=op.addInPort(new CABLES.Port(op,"invert alpha channel",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));


var trigger=op.outTrigger('trigger');

blendMode.set('normal');
var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl,'drawimage');

amount.set(1.0);

render.onTriggered=doRender;

var srcFrag=attachments.drawimage_frag.replace('{{BLENDCODE}}',CGL.TextureEffect.getBlendCode());

shader.setSource(attachments.drawimage_vert,srcFrag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var textureDisplaceUniform=new CGL.Uniform(shader,'t','image',1);
var textureAlpha=new CGL.Uniform(shader,'t','imageAlpha',2);

invAlphaChannel.onChange=function()
{
    if(invAlphaChannel.get()) shader.define('INVERT_ALPHA');
        else shader.removeDefine('INVERT_ALPHA');
};

removeAlphaSrc.onChange=function()
{
    if(removeAlphaSrc.get()) shader.define('REMOVE_ALPHA_SRC');
        else shader.removeDefine('REMOVE_ALPHA_SRC');
};
removeAlphaSrc.set(true);

alphaSrc.onChange=function()
{
    if(alphaSrc.get()=='luminance') shader.define('ALPHA_FROM_LUMINANCE');
        else shader.removeDefine('ALPHA_FROM_LUMINANCE');
};

alphaSrc.set("alpha channel");


{
    //
    // texture flip
    //
    var flipX=op.addInPort(new CABLES.Port(op,"flip x",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));
    var flipY=op.addInPort(new CABLES.Port(op,"flip y",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));

    flipX.onChange=function()
    {
        if(flipX.get()) shader.define('TEX_FLIP_X');
            else shader.removeDefine('TEX_FLIP_X');
    };

    flipY.onChange=function()
    {
        if(flipY.get()) shader.define('TEX_FLIP_Y');
            else shader.removeDefine('TEX_FLIP_Y');
    };
}

{
    //
    // texture transform
    //
    var scale=op.addInPort(new CABLES.Port(op,"scale",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
    var posX=op.addInPort(new CABLES.Port(op,"pos x",CABLES.OP_PORT_TYPE_VALUE, {}));
    var posY=op.addInPort(new CABLES.Port(op,"pos y",CABLES.OP_PORT_TYPE_VALUE, {}));
    var rotate=op.addInPort(new CABLES.Port(op,"rotate",CABLES.OP_PORT_TYPE_VALUE, {}));

    scale.set(1.0);

    var uniScale=new CGL.Uniform(shader,'f','scale',scale.get());
    var uniPosX=new CGL.Uniform(shader,'f','posX',posX.get());
    var uniPosY=new CGL.Uniform(shader,'f','posY',posY.get());
    var uniRotate=new CGL.Uniform(shader,'f','rotate',rotate.get());

    function updateTransform()
    {
        if(scale.get()!=1.0 || posX.get()!=0.0 || posY.get()!=0.0 || rotate.get()!=0.0 )
        {
            if(!shader.hasDefine('TEX_TRANSFORM')) shader.define('TEX_TRANSFORM');
            uniScale.setValue( parseFloat(scale.get()) );
            uniPosX.setValue( posX.get() );
            uniPosY.setValue( posY.get() );
            uniRotate.setValue( rotate.get() );
        }
        else
        {
            // shader.removeDefine('TEX_TRANSFORM');
        }
    }

    scale.onChange=updateTransform;
    posX.onChange=updateTransform;
    posY.onChange=updateTransform;
    rotate.onChange=updateTransform;
}

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);


var amountUniform=new CGL.Uniform(shader,'f','amount',amount);
var oldHadImageAlpha=false;

function doRender()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    if(imageAlpha.get() && !oldHadImageAlpha || !imageAlpha.get() && oldHadImageAlpha)
    {
        if(imageAlpha.get() && imageAlpha.get().tex)
        {
            shader.define('HAS_TEXTUREALPHA');
            oldHadImageAlpha=true;
        }
        else
        {
            shader.removeDefine('HAS_TEXTUREALPHA');
            oldHadImageAlpha=false;
        }
    }

    if(image.get() && image.get().tex && amount.get()>0.0)
    {
        cgl.setShader(shader);
        cgl.currentTextureEffect.bind();

        cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

        if(image.get() && image.get().tex) cgl.setTexture(1, image.get().tex );
            else cgl.setTexture(1, null);

        if(imageAlpha.get() && imageAlpha.get().tex) cgl.setTexture(2, imageAlpha.get().tex );
            else cgl.setTexture(2,null);

        cgl.currentTextureEffect.finish();
        cgl.setPreviousShader();
    }

    trigger.trigger();
}



};

Ops.Gl.TextureEffects.DrawImage.prototype = new CABLES.Op();
CABLES.OPS["8248b866-9492-48c8-897d-3097c6fe6fe8"]={f:Ops.Gl.TextureEffects.DrawImage,objName:"Ops.Gl.TextureEffects.DrawImage"};




// **************************************************************
// 
// Ops.Gl.Matrix.Camera
// 
// **************************************************************

Ops.Gl.Matrix.Camera = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var render=op.inTrigger('render');
var trigger=op.outTrigger('trigger');

/* Inputs */
// projection | prespective & ortogonal
var projectionMode=op.addInPort(new CABLES.Port(op,"projection mode",CABLES.OP_PORT_TYPE_VALUE,{display:'dropdown',values:['prespective','ortogonal']}));
var zNear=op.addInPort(new CABLES.Port(op,"frustum near",CABLES.OP_PORT_TYPE_VALUE ));
var zFar=op.addInPort(new CABLES.Port(op,"frustum far",CABLES.OP_PORT_TYPE_VALUE ));

var fov=op.addInPort(new CABLES.Port(op,"fov",CABLES.OP_PORT_TYPE_VALUE ));

var autoAspect=op.inValueBool("Auto Aspect Ratio",true);
var aspect=op.inValue("Aspect Ratio");

// look at camera
var eyeX=op.addInPort(new CABLES.Port(op,"eye X"));
var eyeY=op.addInPort(new CABLES.Port(op,"eye Y"));
var eyeZ=op.addInPort(new CABLES.Port(op,"eye Z"));

var centerX=op.addInPort(new CABLES.Port(op,"center X"));
var centerY=op.addInPort(new CABLES.Port(op,"center Y"));
var centerZ=op.addInPort(new CABLES.Port(op,"center Z"));

// camera transform and movements
var posX=op.addInPort(new CABLES.Port(op,"truck"),0);
var posY=op.addInPort(new CABLES.Port(op,"boom"),0);
var posZ=op.addInPort(new CABLES.Port(op,"dolly"),0);

var rotX=op.addInPort(new CABLES.Port(op,"tilt"),0);
var rotY=op.addInPort(new CABLES.Port(op,"pan"),0);
var rotZ=op.addInPort(new CABLES.Port(op,"roll"),0);


/* Outputs */
var outAsp=op.addOutPort(new CABLES.Port(op,"Aspect",CABLES.OP_PORT_TYPE_VALUE));
var outArr=op.outArray("Look At Array");


/* logic */
var cgl=op.patch.cgl;

// prespective
projectionMode.set('prespective');
zNear.set(0.01);
zFar.set(500.0);
fov.set(45);
aspect.set(1);

var asp=0;

// look at camera
centerX.set(0);
centerY.set(0);
centerZ.set(0);

eyeX.set(0);
eyeY.set(0);
eyeZ.set(5);

var vUp=vec3.create();
var vEye=vec3.create();
var vCenter=vec3.create();
var transMatrix=mat4.create();
mat4.identity(transMatrix);

var arr=[];

// Transform and move
var vPos=vec3.create();
var transMatrixMove=mat4.create();
mat4.identity(transMatrixMove);

var updateCameraMovementMatrix=true;

render.onTriggered=function() {
    // Aspect ration
    if(!autoAspect.get()) asp=aspect.get();
    else asp=cgl.getViewPort()[2]/cgl.getViewPort()[3];
    outAsp.set(asp);
    
    // translation (truck, boom, dolly)
    cgl.pushViewMatrix();
    
    if (updateCameraMovementMatrix) {
        mat4.identity(transMatrixMove);
        
        vec3.set(vPos, posX.get(),posY.get(),posZ.get());
        if(posX.get()!==0.0 || posY.get()!==0.0 || posZ.get()!==0.0)
            mat4.translate(transMatrixMove,transMatrixMove, vPos);
        
        if(rotX.get()!==0)
            mat4.rotateX(transMatrixMove,transMatrixMove, rotX.get()*CGL.DEG2RAD);
        if(rotY.get()!==0)
            mat4.rotateY(transMatrixMove,transMatrixMove, rotY.get()*CGL.DEG2RAD);
        if(rotZ.get()!==0)
            mat4.rotateZ(transMatrixMove,transMatrixMove, rotZ.get()*CGL.DEG2RAD);
        
        updateCameraMovementMatrix = false;
    }
    
    mat4.multiply(cgl.vMatrix,cgl.vMatrix,transMatrixMove);
    
    // projection (prespective / ortogonal)
    cgl.pushPMatrix();
    
    // look at
    cgl.pushViewMatrix();
 
    if (projectionMode.get()=='prespective') {
        mat4.perspective(
            cgl.pMatrix,
            fov.get()*0.0174533,
            asp, 
            zNear.get(), 
            zFar.get()
        );
    } else if (projectionMode.get()=='ortogonal') {
        mat4.ortho(
            cgl.pMatrix,
            -1 * (fov.get() / 14),
             1 * (fov.get() / 14),
            -1 * (fov.get() / 14) / asp,
             1 * (fov.get() / 14) / asp,
            zNear.get(), 
            zFar.get()
        );
    }
    
    
	arr[0]=eyeX.get();
	arr[1]=eyeY.get();
	arr[2]=eyeZ.get();

	arr[3]=centerX.get();
	arr[4]=centerY.get();
	arr[5]=centerZ.get();

	arr[6]=0;
	arr[7]=1;
	arr[8]=0;

	outArr.set(arr);

	vec3.set(vUp, 0, 1, 0);
	vec3.set(vEye, eyeX.get(),eyeY.get(),eyeZ.get());
	vec3.set(vCenter, centerX.get(),centerY.get(),centerZ.get());

	mat4.lookAt(transMatrix, vEye, vCenter, vUp);

	mat4.multiply(cgl.vMatrix,cgl.vMatrix,transMatrix);

	trigger.trigger();

	cgl.popViewMatrix();
	cgl.popPMatrix();

	cgl.popViewMatrix();
    
    
	// GUI for dolly, boom and truck
	if(CABLES.UI && gui.patch().isCurrentOp(op)) 
		gui.setTransformGizmo({
			posX:posX,
			posY:posY,
			posZ:posZ
		});
};

var updateUI=function() {
	if(!autoAspect.get()) {
		aspect.setUiAttribs({hidePort:false,greyout:false});
	} else {
		aspect.setUiAttribs({hidePort:true,greyout:true});
	}
};

var cameraMovementChanged=function() {
	updateCameraMovementMatrix = true;
};

// listeners
posX.onChange=cameraMovementChanged;
posY.onChange=cameraMovementChanged;
posZ.onChange=cameraMovementChanged;

rotX.onChange=cameraMovementChanged;
rotY.onChange=cameraMovementChanged;
rotZ.onChange=cameraMovementChanged;

autoAspect.onChange=updateUI;
updateUI();




};

Ops.Gl.Matrix.Camera.prototype = new CABLES.Op();
CABLES.OPS["b24dbfdc-485c-49d2-92a1-7258efd9239a"]={f:Ops.Gl.Matrix.Camera,objName:"Ops.Gl.Matrix.Camera"};




// **************************************************************
// 
// Ops.Gl.Phong.PhongMaterial
// 
// **************************************************************

Ops.Gl.Phong.PhongMaterial = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={phong_frag:"// #extension GL_OES_standard_derivatives : enable\n\n{{MODULES_HEAD}}\n\n\n//some settings for the look and feel of the material\nconst float specularScale = 0.65;\nconst float roughness = 1110.0;\nconst float albedo = 0.9;\n\nUNI float shininess;\nUNI float specularStrength;\nUNI float fresnel;\n\n#ifdef HAS_TEXTURE_DIFFUSE\n    UNI sampler2D texDiffuse;\n#endif\n#ifdef HAS_TEXTURE_SPECULAR\n    UNI sampler2D texSpecular;\n#endif\n\n#ifdef HAS_TEXTURE_NORMAL\n    UNI sampler2D texNormal;\n#endif\n\nUNI float r,g,b,a;\n\nUNI float diffuseRepeatX;\nUNI float diffuseRepeatY;\n\nUNI int flatShading;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\nIN  vec2 texCoord;\n\nstruct Light {\n  vec3 pos;\n  vec3 color;\n  vec3 ambient;\n  vec3 specular;\n  float falloff;\n  float radius;\n  float mul;\n};\n\nIN mat3 normalMatrix;\n\n\nUNI Light lights[4];\n\nIN vec3 vViewPosition;\nIN vec3 vNormal;\n\n//import some common functions\n// vec3 normals_4_0(vec3 pos) {\n//   vec3 fdx = dFdx(pos);\n//   vec3 fdy = dFdy(pos);\n//   return normalize(cross(fdx, fdy));\n// }\n\n\n// http://www.thetenthplanet.de/archives/1180\n// mat3 cotangentFrame_8_1(vec3 N, vec3 p, vec2 uv) {\n//   // get edge vectors of the pixel triangle\n//   vec3 dp1 = dFdx(p);\n//   vec3 dp2 = dFdy(p);\n//   vec2 duv1 = dFdx(uv);\n//   vec2 duv2 = dFdy(uv);\n\n//   // solve the linear system\n//   vec3 dp2perp = cross(dp2, N);\n//   vec3 dp1perp = cross(N, dp1);\n//   vec3 T = dp2perp * duv1.x + dp1perp * duv2.x;\n//   vec3 B = dp2perp * duv1.y + dp1perp * duv2.y;\n\n//   // construct a scale-invariant frame\n//   float invmax = 1.0 / sqrt(max(dot(T,T), dot(B,B)));\n//   return mat3(T * invmax, B * invmax, N);\n// }\n\n\n\n// vec3 perturb_6_2(vec3 map, vec3 N, vec3 V, vec2 texcoord) {\n//   mat3 TBN = cotangentFrame_8_1(N, -V, texcoord);\n//   return normalize(TBN * map);\n// }\n\n\nfloat orenNayarDiffuse_5_3(\n  vec3 lightDirection,\n  vec3 viewDirection,\n  vec3 surfaceNormal,\n  float roughness,\n  float albedo) {\n\n  float LdotV = dot(lightDirection, viewDirection);\n  float NdotL = dot(lightDirection, surfaceNormal);\n  float NdotV = dot(surfaceNormal, viewDirection);\n\n  float s = LdotV - NdotL * NdotV;\n  float t = mix(1.0, max(NdotL, NdotV), step(0.0, s));\n\n  float sigma2 = roughness * roughness;\n  float A = 1.0 + sigma2 * (albedo / (sigma2 + 0.13) + 0.5 / (sigma2 + 0.33));\n  float B = 0.45 * sigma2 / (sigma2 + 0.09);\n\n  return albedo * max(0.0, NdotL) * (A + B * s / t) / 3.14159265;\n}\n\n\nfloat phongSpecular_7_4(\n  vec3 lightDirection,\n  vec3 viewDirection,\n  vec3 surfaceNormal,\n  float shininess) {\n\n  //Calculate Phong power\n  vec3 R = -reflect(lightDirection, surfaceNormal);\n  return pow(max(0.0, dot(viewDirection, R)), shininess);\n}\n\n\n// by Tom Madams\n// Simple:\n// https://imdoingitwrong.wordpress.com/2011/01/31/light-attenuation/\n//\n// Improved\n// https://imdoingitwrong.wordpress.com/2011/02/10/improved-light-attenuation/\nfloat attenuation_1_5(float r, float f, float d) {\n  float denom = d / r + 1.0;\n  float attenuation = 1.0 / (denom*denom);\n  float t = (attenuation - f) / (1.0 - f);\n  return max(t, 0.0);\n}\n\n\nconst float gamma_2_6 = 2.2;\n\nfloat toLinear_2_7(float v) {\n  return pow(v, gamma_2_6);\n}\n\nvec2 toLinear_2_7(vec2 v) {\n  return pow(v, vec2(gamma_2_6));\n}\n\nvec3 toLinear_2_7(vec3 v) {\n  return pow(v, vec3(gamma_2_6));\n}\n\nvec4 toLinear_2_7(vec4 v) {\n  return vec4(toLinear_2_7(v.rgb), v.a);\n}\n\n\n\nconst float gamma_3_8 = 2.2;\n\nfloat toGamma_3_9(float v) {\n  return pow(v, 1.0 / gamma_3_8);\n}\n\nvec2 toGamma_3_9(vec2 v) {\n  return pow(v, vec2(1.0 / gamma_3_8));\n}\n\nvec3 toGamma_3_9(vec3 v) {\n  return pow(v, vec3(1.0 / gamma_3_8));\n}\n\nvec4 toGamma_3_9(vec4 v) {\n  return vec4(toGamma_3_9(v.rgb), v.a);\n}\n\n//account for gamma-corrected images\nvec4 textureLinear(sampler2D uTex, vec2 uv) {\n  return toLinear_2_7(texture(uTex, uv));\n}\n\n\nfloat calcFresnel(vec3 direction, vec3 normal)\n{\n    vec3 nDirection = normalize( direction );\n    vec3 nNormal = normalize( normal );\n    vec3 halfDirection = normalize( nNormal + nDirection );\n\n    float cosine = dot( halfDirection, nDirection );\n    float product = max( cosine, 0.0 );\n    float factor = pow( product, 5.0 );\n\n    return factor;\n}\n\nvoid main()\n{\n    vec2 UV_SCALE = vec2(diffuseRepeatX,diffuseRepeatY);\n\n    vec3 color = vec3(0.0);\n    vec2 uv = texCoord * UV_SCALE;\n\n    #ifdef HAS_TEXTURE_DIFFUSE\n        vec3 diffuseColor = texture(texDiffuse, uv).rgb;\n    #endif\n    #ifndef HAS_TEXTURE_DIFFUSE\n        vec3 diffuseColor = vec3(r,g,b);\n    #endif\n\n    #ifdef HAS_TEXTURE_NORMAL\n        vec3 normalMap = texture(texNormal, uv).rgb * 2.0 - 1.0;\n        normalMap=normalize(normalMatrix * normalMap);\n    #endif\n\n    float specStrength = specularStrength;\n    #ifdef HAS_TEXTURE_SPECULAR\n        specStrength = specularStrength*texture(texSpecular, uv).r;\n    #endif\n\n    vec3 specular=vec3(0.0);\n\n    for(int l=0;l<NUM_LIGHTS;l++)\n    {\n        Light light=lights[l];\n\n        //determine the type of normals for lighting\n        vec3 normal = vec3(0.0);\n        //   if (flatShading == 1) {\n        //     normal = normals_4_0(vViewPosition);\n        //   } else {\n        normal = vNormal;\n        //   }\n\n        // if(!gl_FrontFacing) normal*=vec3(-1);\n\n        //determine surface to light direction\n        vec4 lightPosition = viewMatrix * vec4(light.pos, 1.0);\n        vec3 lightVector = lightPosition.xyz - vViewPosition;\n\n        //calculate attenuation\n        float lightDistance = length(lightVector);\n        float falloff = attenuation_1_5(light.radius, light.falloff, lightDistance);\n\n        //now sample from our repeating brick texture\n        //assume its in sRGB, so we need to correct for gamma\n        //our normal map has an inverted green channel\n\n        vec3 L = normalize(lightVector);              //light direction\n        vec3 V = normalize(vViewPosition);            //eye direction\n\n        vec3 N = normal;//perturb_6_2(normalMap, normal, -V, vUv); //surface normal\n\n        #ifdef HAS_TEXTURE_NORMAL\n            N = normalize( (normalMap+normal) );\n        #endif\n\n        //compute our diffuse & specular terms\n        specular += specStrength * phongSpecular_7_4(L, -V, N, shininess) * specularScale * falloff * light.specular;\n        vec3 diffuse = light.color * orenNayarDiffuse_5_3(L, V, N, roughness, albedo) * falloff * light.mul;\n        vec3 ambient = light.ambient;\n\n        //add the lighting\n        color += (diffuse + ambient);\n\n        if(fresnel!=0.0) color+=calcFresnel(V,normal)*fresnel*5.0;\n    }\n\n    color*=diffuseColor;\n    color+=specular;\n    // color=toGamma_3_9(color);\n    vec4 col=vec4(color,a);\n    {{MODULE_COLOR}}\n\n\n    outColor= col;\n    // gl_FragColor.a =a;\n}\n\n",phong_vert:"\n{{MODULES_HEAD}}\n\nIN vec3 vPosition;\nUNI mat4 projMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\nIN vec3 attrVertNormal;\nIN vec2 attrTexCoord;\n\n// IN vec3 attrTangent;\n// IN vec3 attrBiTangent;\nOUT vec3 vTangent;\nOUT vec3 vBiTangent;\n\n\nOUT mediump vec3 norm;\nOUT mediump vec3 vert;\nOUT mat4 mvMatrix;\n// UNI mat4 normalMatrix;\n\nOUT vec3 vViewPosition;\nOUT vec3 vNormal;\n\n\n#ifdef HAS_TEXTURES\n    OUT  vec2 texCoord;\n#endif\n\nOUT mat3 normalMatrix;\nOUT vec4 modelPos;\n\n\n// import some common functions not supported by GLSL ES\nfloat transpose_1_0(float m) {\n  return m;\n}\n\nmat2 transpose_1_0(mat2 m) {\n  return mat2(m[0][0], m[1][0],\n              m[0][1], m[1][1]);\n}\n\nmat3 transpose_1_0(mat3 m) {\n  return mat3(m[0][0], m[1][0], m[2][0],\n              m[0][1], m[1][1], m[2][1],\n              m[0][2], m[1][2], m[2][2]);\n}\n\nmat4 transpose_1_0(mat4 m) {\n  return mat4(m[0][0], m[1][0], m[2][0], m[3][0],\n              m[0][1], m[1][1], m[2][1], m[3][1],\n              m[0][2], m[1][2], m[2][2], m[3][2],\n              m[0][3], m[1][3], m[2][3], m[3][3]);\n}\n\n\nmat3 inverse_2_1(mat3 m) {\n  float a00 = m[0][0], a01 = m[0][1], a02 = m[0][2];\n  float a10 = m[1][0], a11 = m[1][1], a12 = m[1][2];\n  float a20 = m[2][0], a21 = m[2][1], a22 = m[2][2];\n\n  float b01 = a22 * a11 - a12 * a21;\n  float b11 = -a22 * a10 + a12 * a20;\n  float b21 = a21 * a10 - a11 * a20;\n\n  float det = a00 * b01 + a01 * b11 + a02 * b21;\n\n  return mat3(b01, (-a22 * a01 + a02 * a21), (a12 * a01 - a02 * a11),\n              b11, (a22 * a00 - a02 * a20), (-a12 * a00 + a02 * a10),\n              b21, (-a21 * a00 + a01 * a20), (a11 * a00 - a01 * a10)) / det;\n}\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nvoid main()\n{\n    norm=attrVertNormal;\n    vert=vPosition;\n\n    // vTangent=attrTangent;\n    // vBiTangent=attrBiTangent;\n\n    #ifdef HAS_TEXTURES\n        texCoord=attrTexCoord;\n    #endif\n\n    mat4 mMatrix=modelMatrix;\n    vec4 pos = vec4( vPosition, 1. );\n    modelPos=modelMatrix*pos;\n\n\n\n    {{MODULE_VERTEX_POSITION}}\n    \n    mvMatrix=viewMatrix * mMatrix;\n\n\n    vec4 viewModelPosition = mvMatrix * pos;\n    vViewPosition = viewModelPosition.xyz;\n\n    // Rotate the object normals by a 3x3 normal matrix.\n    // We could also do this CPU-side to avoid doing it per-vertex\n    normalMatrix = transpose_1_0(inverse_2_1(mat3(mvMatrix)));\n    vNormal = normalize(normalMatrix * norm);\n\n    gl_Position = projMatrix * mvMatrix * pos;\n}\n\n\n\n\n// float inverse_2_1(float m) {\n//   return 1.0 / m;\n// }\n\n// mat2 inverse_2_1(mat2 m) {\n//   return mat2(m[1][1],-m[0][1],\n//              -m[1][0], m[0][0]) / (m[0][0]*m[1][1] - m[0][1]*m[1][0]);\n// }\n\n\n// mat4 inverse_2_1(mat4 m) {\n//   float\n//       a00 = m[0][0], a01 = m[0][1], a02 = m[0][2], a03 = m[0][3],\n//       a10 = m[1][0], a11 = m[1][1], a12 = m[1][2], a13 = m[1][3],\n//       a20 = m[2][0], a21 = m[2][1], a22 = m[2][2], a23 = m[2][3],\n//       a30 = m[3][0], a31 = m[3][1], a32 = m[3][2], a33 = m[3][3],\n\n//       b00 = a00 * a11 - a01 * a10,\n//       b01 = a00 * a12 - a02 * a10,\n//       b02 = a00 * a13 - a03 * a10,\n//       b03 = a01 * a12 - a02 * a11,\n//       b04 = a01 * a13 - a03 * a11,\n//       b05 = a02 * a13 - a03 * a12,\n//       b06 = a20 * a31 - a21 * a30,\n//       b07 = a20 * a32 - a22 * a30,\n//       b08 = a20 * a33 - a23 * a30,\n//       b09 = a21 * a32 - a22 * a31,\n//       b10 = a21 * a33 - a23 * a31,\n//       b11 = a22 * a33 - a23 * a32,\n\n//       det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;\n\n//   return mat4(\n//       a11 * b11 - a12 * b10 + a13 * b09,\n//       a02 * b10 - a01 * b11 - a03 * b09,\n//       a31 * b05 - a32 * b04 + a33 * b03,\n//       a22 * b04 - a21 * b05 - a23 * b03,\n//       a12 * b08 - a10 * b11 - a13 * b07,\n//       a00 * b11 - a02 * b08 + a03 * b07,\n//       a32 * b02 - a30 * b05 - a33 * b01,\n//       a20 * b05 - a22 * b02 + a23 * b01,\n//       a10 * b10 - a11 * b08 + a13 * b06,\n//       a01 * b08 - a00 * b10 - a03 * b06,\n//       a30 * b04 - a31 * b02 + a33 * b00,\n//       a21 * b02 - a20 * b04 - a23 * b00,\n//       a11 * b07 - a10 * b09 - a12 * b06,\n//       a00 * b09 - a01 * b07 + a02 * b06,\n//       a31 * b01 - a30 * b03 - a32 * b00,\n//       a20 * b03 - a21 * b01 + a22 * b00) / det;\n// }\n",};
var cgl=this.patch.cgl;

// adapted from:
// http://www.tomdalling.com/blog/modern-opengl/07-more-lighting-ambient-specular-attenuation-gamma/

var render=this.addInPort(new CABLES.Port(this,"render",CABLES.OP_PORT_TYPE_FUNCTION) );

const trigger=op.outTrigger("trigger");
var shaderOut=this.addOutPort(new CABLES.Port(this,"shader",CABLES.OP_PORT_TYPE_OBJECT));

var specularStrength=op.inValue("Specular Strength",1);
var shininess=op.inValue("Shininess",20);
var fresnel=op.inValueSlider("Fresnel",0);




shaderOut.ignoreValueSerialize=true;
var MAX_LIGHTS=16;




var shader=new CGL.Shader(cgl,'PhongMaterial');
shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_NORMAL','MODULE_BEGIN_FRAG']);

shader.setSource(attachments.phong_vert,attachments.phong_frag);
shaderOut.set(shader);

var uniSpecStrngth=new CGL.Uniform(shader,'f','specularStrength',specularStrength);
var uniShininess=new CGL.Uniform(shader,'f','shininess',shininess);
var uniFresnel=new CGL.Uniform(shader,'f','fresnel',fresnel);



var lights=[];

var depthTex=new CGL.Uniform(shader,'t','depthTex',5);

var uniShadowPass=new CGL.Uniform(shader,'f','shadowPass',0);

for(var i=0;i<MAX_LIGHTS;i++)
{
    var count=i;
    lights[count]={};
    lights[count].pos=new CGL.Uniform(shader,'3f','lights['+count+'].pos',[0,11,0]);
    lights[count].target=new CGL.Uniform(shader,'3f','lights['+count+'].target',[0,0,0]);
    lights[count].color=new CGL.Uniform(shader,'3f','lights['+count+'].color',[1,1,1]);
    lights[count].attenuation=new CGL.Uniform(shader,'f','lights['+count+'].attenuation',0.1);
    lights[count].type=new CGL.Uniform(shader,'f','lights['+count+'].type',0);
    lights[count].cone=new CGL.Uniform(shader,'f','lights['+count+'].cone',0.8);
    lights[count].mul=new CGL.Uniform(shader,'f','lights['+count+'].mul',1);
    
    lights[count].ambient=new CGL.Uniform(shader,'3f','lights['+count+'].ambient',1);
    lights[count].specular=new CGL.Uniform(shader,'3f','lights['+count+'].specular',1);
    
    lights[count].fallOff=new CGL.Uniform(shader,'f','lights['+count+'].falloff',0);
    lights[count].radius=new CGL.Uniform(shader,'f','lights['+count+'].radius',10);
    
//   vec3 pos;
//   vec3 color;
//   vec3 ambient;
//   float falloff;
//   float radius;

    // lights[count].depthMVP=new CGL.Uniform(shader,'m4','lights['+count+'].depthMVP',mat4.create());
}

var normIntensity=op.inValue("Normal Texture Intensity",1);
var uniNormIntensity=new CGL.Uniform(shader,'f','normalTexIntensity',normIntensity);




{
    // diffuse color

    var r=this.addInPort(new CABLES.Port(this,"diffuse r",CABLES.OP_PORT_TYPE_VALUE,{ display:'range', colorPick:'true' }));
    r.onChange=function()
    {
        if(!r.uniform) r.uniform=new CGL.Uniform(shader,'f','r',r.get());
        else r.uniform.setValue(r.get());
    };

    var g=this.addInPort(new CABLES.Port(this,"diffuse g",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
    g.onChange=function()
    {
        if(!g.uniform) g.uniform=new CGL.Uniform(shader,'f','g',g.get());
        else g.uniform.setValue(g.get());
    };

    var b=this.addInPort(new CABLES.Port(this,"diffuse b",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
    b.onChange=function()
    {
        if(!b.uniform) b.uniform=new CGL.Uniform(shader,'f','b',b.get());
        else b.uniform.setValue(b.get());
    };

    var a=this.addInPort(new CABLES.Port(this,"diffuse a",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
    a.onChange=function()
    {
        if(!a.uniform) a.uniform=new CGL.Uniform(shader,'f','a',a.get());
        else a.uniform.setValue(a.get());
    };

    r.set(Math.random());
    g.set(Math.random());
    b.set(Math.random());
    a.set(1.0);
}



{
    var colorizeTex=this.addInPort(new CABLES.Port(this,"colorize texture",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));
    colorizeTex.onChange=function()
    {
        if(colorizeTex.get()) shader.define('COLORIZE_TEXTURE');
            else shader.removeDefine('COLORIZE_TEXTURE');
    };
}

{
    // diffuse texture

    var diffuseTexture=this.addInPort(new CABLES.Port(this,"texture",CABLES.OP_PORT_TYPE_TEXTURE,{preview:true,display:'createOpHelper'}));
    var diffuseTextureUniform=null;
    shader.bindTextures=bindTextures;

    diffuseTexture.onChange=function()
    {
        if(diffuseTexture.get())
        {
            if(diffuseTextureUniform!==null)return;
            shader.removeUniform('texDiffuse');
            shader.define('HAS_TEXTURE_DIFFUSE');
            diffuseTextureUniform=new CGL.Uniform(shader,'t','texDiffuse',0);
        }
        else
        {
            shader.removeUniform('texDiffuse');
            shader.removeDefine('HAS_TEXTURE_DIFFUSE');
            diffuseTextureUniform=null;
        }
    };

    var aoTexture=this.addInPort(new CABLES.Port(this,"AO Texture",CABLES.OP_PORT_TYPE_TEXTURE,{preview:true,display:'createOpHelper'}));
    var aoTextureUniform=null;
    aoTexture.ignoreValueSerialize=true;
    shader.bindTextures=bindTextures;

    aoTexture.onChange=function()
    {
        if(aoTexture.get())
        {
            if(aoTextureUniform!==null)return;
            shader.removeUniform('texAo');
            shader.define('HAS_TEXTURE_AO');
            aoTextureUniform=new CGL.Uniform(shader,'t','texAo',1);
        }
        else
        {
            shader.removeUniform('texAo');
            shader.removeDefine('HAS_TEXTURE_AO');
            aoTextureUniform=null;
        }
    };


    var specTexture=this.addInPort(new CABLES.Port(this,"Specular Texture",CABLES.OP_PORT_TYPE_TEXTURE,{preview:true,display:'createOpHelper'}));
    var specTextureUniform=null;

    specTexture.onChange=function()
    {
        if(specTexture.get())
        {
            if(specTextureUniform!==null)return;
            shader.removeUniform('texSpecular');
            shader.define('HAS_TEXTURE_SPECULAR');
            specTextureUniform=new CGL.Uniform(shader,'t','texSpecular',2);
        }
        else
        {
            shader.removeUniform('texSpecular');
            shader.removeDefine('HAS_TEXTURE_SPECULAR');
            specTextureUniform=null;
        }
    };


    var normalTexture=this.addInPort(new CABLES.Port(this,"Normal Texture",CABLES.OP_PORT_TYPE_TEXTURE,{preview:true,display:'createOpHelper'}));
    var normalTextureUniform=null;

    normalTexture.onChange=function()
    {
        if(normalTexture.get())
        {
            if(normalTextureUniform!==null)return;
            shader.removeUniform('texNormal');
            shader.define('HAS_TEXTURE_NORMAL');
            normalTextureUniform=new CGL.Uniform(shader,'t','texNormal',3);
        }
        else
        {
            shader.removeUniform('texNormal');
            shader.removeDefine('HAS_TEXTURE_NORMAL');
            normalTextureUniform=null;
        }
    };



    var diffuseRepeatX=this.addInPort(new CABLES.Port(this,"diffuseRepeatX",CABLES.OP_PORT_TYPE_VALUE));
    var diffuseRepeatY=this.addInPort(new CABLES.Port(this,"diffuseRepeatY",CABLES.OP_PORT_TYPE_VALUE));
    diffuseRepeatX.set(1);
    diffuseRepeatY.set(1);

    diffuseRepeatX.onChange=function()
    {
        diffuseRepeatXUniform.setValue(diffuseRepeatX.get());
    };

    diffuseRepeatY.onChange=function()
    {
        diffuseRepeatYUniform.setValue(diffuseRepeatY.get());
    };

    var diffuseRepeatXUniform=new CGL.Uniform(shader,'f','diffuseRepeatX',diffuseRepeatX.get());
    var diffuseRepeatYUniform=new CGL.Uniform(shader,'f','diffuseRepeatY',diffuseRepeatY.get());
}



{
    //lights
    var numLights=-1;

    var updateLights=function()
    {
        var count=0;
        var i=0;
        var num=0;
        if(!cgl.frameStore.phong || !cgl.frameStore.phong.lights)
        {
            num=0;
        }
        else
        {
            for(i in cgl.frameStore.phong.lights)
            {
                num++;
            }
        }
        if(num!=numLights)
        {
            numLights=num;
            shader.define('NUM_LIGHTS',''+Math.max(numLights,1));
        }

        if(!cgl.frameStore.phong || !cgl.frameStore.phong.lights)
        {
            // numLights=1;
            // lights[0].pos.setValue([1,2,0]);
            // lights[0].target.setValue([0,0,0]);
            // lights[0].color.setValue([1,1,1]);
            // lights[0].attenuation.setValue(0);
            // lights[0].type.setValue(0);
            // lights[0].cone.setValue(0.8);
        }
        else
        {
            count=0;
            if(shader)
                for(i in cgl.frameStore.phong.lights)
                {
                    lights[count].pos.setValue(cgl.frameStore.phong.lights[i].pos);
                    // if(cgl.frameStore.phong.lights[i].changed)
                    {
                        cgl.frameStore.phong.lights[i].changed=false;
                        if(cgl.frameStore.phong.lights[i].target) lights[count].target.setValue(cgl.frameStore.phong.lights[i].target);

                        lights[count].fallOff.setValue(cgl.frameStore.phong.lights[i].fallOff);
                        lights[count].radius.setValue(cgl.frameStore.phong.lights[i].radius);

                        lights[count].color.setValue(cgl.frameStore.phong.lights[i].color);
                        lights[count].ambient.setValue(cgl.frameStore.phong.lights[i].ambient);
                        lights[count].specular.setValue(cgl.frameStore.phong.lights[i].specular);
                        lights[count].attenuation.setValue(cgl.frameStore.phong.lights[i].attenuation);
                        lights[count].type.setValue(cgl.frameStore.phong.lights[i].type);
                        if(cgl.frameStore.phong.lights[i].cone) lights[count].cone.setValue(cgl.frameStore.phong.lights[i].cone);
                        // if(cgl.frameStore.phong.lights[i].depthMVP) lights[count].depthMVP.setValue(cgl.frameStore.phong.lights[i].depthMVP);
                        if(cgl.frameStore.phong.lights[i].depthTex) lights[count].texDepthTex=cgl.frameStore.phong.lights[i].depthTex;

                        lights[count].mul.setValue(cgl.frameStore.phong.lights[i].mul||1);
                    }

                    count++;
                }
        }
    }

}

var bindTextures=function()
{
    if(diffuseTexture.get())
    {
        cgl.setTexture(0,diffuseTexture.get().tex);
        // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, diffuseTexture.get().tex);
    }

    if(aoTexture.get())
    {
        cgl.setTexture(1,aoTexture.get().tex);
        // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, aoTexture.get().tex);
    }

    if(specTexture.get())
    {
        cgl.setTexture(2, specTexture.get().tex);
        // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, specTexture.get().tex);
    }

    if(normalTexture.get())
    {
        cgl.setTexture(3, normalTexture.get().tex);
        // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, normalTexture.get().tex);
    }

    uniShadowPass.setValue(0);
    if(cgl.frameStore.phong && cgl.frameStore.phong.lights)
        for(i in cgl.frameStore.phong.lights)
        {
            if(cgl.frameStore.phong.lights[i].shadowPass==1.0)uniShadowPass.setValue(1);
        }
}

var doRender=function()
{
    if(!shader)return;

    cgl.setShader(shader);
    updateLights();
    shader.bindTextures();
    trigger.trigger();
    cgl.setPreviousShader();
};

shader.bindTextures=bindTextures;
shader.define('NUM_LIGHTS','1');

// this.onLoaded=shader.compile;

render.onTriggered=doRender;

doRender();


};

Ops.Gl.Phong.PhongMaterial.prototype = new CABLES.Op();
CABLES.OPS["0d951d8a-5a69-45b4-876a-92aa1139ed5a"]={f:Ops.Gl.Phong.PhongMaterial,objName:"Ops.Gl.Phong.PhongMaterial"};




// **************************************************************
// 
// Ops.Gl.Phong.PointLight
// 
// **************************************************************

Ops.Gl.Phong.PointLight = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};


const exe=op.inTrigger("exe");
var trigger=op.outTrigger('trigger');

var attachment=op.addOutPort(new CABLES.Port(op,"attachment",CABLES.OP_PORT_TYPE_FUNCTION));


var radius=op.inValue("Radius",100);
var fallOff=op.inValueSlider("Fall Off",0.1);
var intensity=op.inValue("Intensity",1);

var x=op.addInPort(new CABLES.Port(op,"x",CABLES.OP_PORT_TYPE_VALUE));
var y=op.addInPort(new CABLES.Port(op,"y",CABLES.OP_PORT_TYPE_VALUE));
var z=op.addInPort(new CABLES.Port(op,"z",CABLES.OP_PORT_TYPE_VALUE));

var r=op.addInPort(new CABLES.Port(op,"r",CABLES.OP_PORT_TYPE_VALUE,{ display:'range', colorPick:'true' }));
var g=op.addInPort(new CABLES.Port(op,"g",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
var b=op.addInPort(new CABLES.Port(op,"b",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));

var ambientR=op.inValue("Ambient R",0.1);
var ambientG=op.inValue("Ambient G",0.1);
var ambientB=op.inValue("Ambient B",0.1);

var specularR=op.addInPort(new CABLES.Port(op,"Specular R",CABLES.OP_PORT_TYPE_VALUE,{ display:'range', colorPick:'true' }));
var specularG=op.addInPort(new CABLES.Port(op,"Specular G",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
var specularB=op.addInPort(new CABLES.Port(op,"Specular B",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));


ambientR.set(0);
ambientG.set(0);
ambientB.set(0);

specularR.set(1);
specularG.set(1);
specularB.set(1);

r.set(1);
g.set(1);
b.set(1);


var cgl=op.patch.cgl;


radius.onChange=updateAll;
fallOff.onChange=updateAll;
intensity.onChange=updateAll;
r.onChange=updateAll;
g.onChange=updateAll;
b.onChange=updateAll;
x.onChange=updateAll;
y.onChange=updateAll;
z.onChange=updateAll;

ambientR.onChange=updateAll;
ambientG.onChange=updateAll;
ambientB.onChange=updateAll;
specularR.onChange=updateAll;
specularG.onChange=updateAll;
specularB.onChange=updateAll;




var id=CABLES.generateUUID();
var light={};

var posVec=vec3.create();
var mpos=vec3.create();
var needsUpdate=true;

updateAll();


function updateColor()
{
    light.color=light.color||[];
    light.color[0]=r.get();
    light.color[1]=g.get();
    light.color[2]=b.get();

    light.ambient=light.ambient||[];
    light.ambient[0]=ambientR.get();
    light.ambient[1]=ambientG.get();
    light.ambient[2]=ambientB.get();
    
    light.specular=light.specular||[];
    light.specular[0]=specularR.get();
    light.specular[1]=specularG.get();
    light.specular[2]=specularB.get();
    
    light.changed=true;
}


function updatePos()
{
}

function updateAll()
{
    needsUpdate=true;
}

var transVec=vec3.create();

exe.onTriggered=function()
{
    if(needsUpdate)
    {
        if(!cgl.frameStore.phong)cgl.frameStore.phong={};
        if(!cgl.frameStore.phong.lights)cgl.frameStore.phong.lights=[];
        light=light||{};
        light.id=id;
        light.type=0;
        light.changed=true;
        light.radius=radius.get();
        light.fallOff=fallOff.get();
        light.mul=intensity.get();
    
        updatePos();
        updateColor();
        needsUpdate=false;
    }
    
    
    
    cgl.frameStore.phong.lights=cgl.frameStore.phong.lights||[];

    vec3.set(transVec,x.get(),y.get(),z.get());
    vec3.transformMat4(mpos, transVec, cgl.mvMatrix);
    light=light||{};
    
    light.pos=mpos;
    light.type=0;


    if(CABLES.UI && CABLES.UI.renderHelper)
    {
        cgl.pushModelMatrix();
        mat4.translate(cgl.mvMatrix,cgl.mvMatrix,transVec);
        CABLES.GL_MARKER.drawSphere(op,radius.get()*2);
        cgl.popModelMatrix();
    }

    if(attachment.isLinked())
    {
        cgl.pushModelMatrix();
        mat4.translate(cgl.mvMatrix,cgl.mvMatrix,transVec);
        attachment.trigger();
        cgl.popModelMatrix();
    }

    cgl.frameStore.phong.lights.push(light);
    trigger.trigger();
    cgl.frameStore.phong.lights.pop();
    
    if(CABLES.UI && gui.patch().isCurrentOp(op)) 
        gui.setTransformGizmo(
            {
                posX:x,
                posY:y,
                posZ:z
            });
};



};

Ops.Gl.Phong.PointLight.prototype = new CABLES.Op();
CABLES.OPS["1d2cf105-f66d-4a31-949e-b1887d582080"]={f:Ops.Gl.Phong.PointLight,objName:"Ops.Gl.Phong.PointLight"};




// **************************************************************
// 
// Ops.Json3d.Json3dMesh
// 
// **************************************************************

Ops.Json3d.Json3dMesh = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const cgl=op.patch.cgl;

var scene=new CABLES.Variable();

cgl.frameStore.currentScene=null;

var exe=op.inTrigger("Render");
var filename=op.addInPort(new CABLES.Port(op,"file",CABLES.OP_PORT_TYPE_VALUE,{ display:'file',type:'string',filter:'3d json' } ));
var meshIndex=op.inValueInt("Mesh Index",0);


var draw=op.inValueBool("Draw",true);
var centerPivot=op.inValueBool("Center Mesh",true);


var inSize=op.inValue("Size",1);

var next=op.outTrigger("trigger");
var geometryOut=op.outObject("Geometry");

var merge=op.inValueBool("Merge",false);

var inNormals=op.inValueSelect("Calculate Normals",["no","smooth","flat"],"no");
var outScale=op.outValue("Scaling",1.0);

var geom=null;
var data=null;
var mesh=null;
var meshes=[];
var currentIndex=-1;
var transMatrix=mat4.create();
var bounds={};
var vScale=vec3.fromValues(1,1,1);

exe.onTriggered=render;
filename.onChange=reload;
centerPivot.onChange=setMeshLater;
meshIndex.onChange=setMeshLater;
inNormals.onChange=setMeshLater;
merge.onChange=setMeshLater;

inSize.onChange=updateScale;
var needSetMesh=true;


function calcNormals()
{
    if(!geom)
    {
        console.log('calc normals: no geom!');
        return;
    }

    if(inNormals.get()=='no')return;
    if(inNormals.get()=='smooth')geom.calculateNormals();
    if(inNormals.get()=='flat')
    {
        geom.unIndex();
        geom.calculateNormals();
    }
}

function render()
{
    if(needSetMesh) setMesh();

    if(draw.get())
    {
        cgl.pushModelMatrix();
        mat4.multiply(cgl.mvMatrix,cgl.mvMatrix,transMatrix);

        if(mesh) mesh.render(cgl.getShader());

        cgl.popModelMatrix();
        next.trigger();
    }
}

function setMeshLater()
{
    needSetMesh=true;
}


function updateScale()
{
    if(inSize.get()!==0)
    {
        var scale=inSize.get()/bounds.maxAxis;
        vec3.set(vScale,scale,scale,scale);
        outScale.set(scale);
    }
    else
    {
        vec3.set(vScale,1,1,1);
    }

    mat4.identity(transMatrix);
    mat4.scale(transMatrix,transMatrix, vScale);
}

function updateInfo(geom)
{
    if(!CABLES.UI)return;

    var nfo='<div class="panel">';

    if(data)
    {
        nfo += 'Mesh '+(currentIndex+1)+' of '+data.meshes.length+'<br/>';
        nfo += '<br/>';
    }

    if(geom)
    {
        nfo += (geom.verticesIndices||[]).length/3+' faces <br/>';
        nfo += (geom.vertices||[]).length/3+' vertices <br/>';
        nfo += (geom.texCoords||[]).length/2+' texturecoords <br/>';
        nfo += (geom.vertexNormals||[]).length/3+' normals <br/>';
        nfo += (geom.tangents||[]).length/3+' tangents <br/>';
        nfo += (geom.biTangents||[]).length/3+' bitangents <br/>';
    }

    nfo+="</div>";

    op.uiAttr({info:nfo});
}


function setMesh()
{
    if(mesh)
    {
        mesh.dispose();
        mesh=null;
    }
    var index=Math.floor(meshIndex.get());

    if(!data || index!=index || !CABLES.UTILS.isNumeric(index) || index<0 || index>=data.meshes.length)
    {
        op.uiAttr({warning:'mesh not found - index out of range '});
        return;
    }

    currentIndex=index;

    geom=new CGL.Geometry();

    if(merge.get())
    {
        for(var i=0;i<data.meshes.length;i++)
        {
            var jsonGeom=data.meshes[i];
            if(jsonGeom)
            {
                var geomNew=CGL.Geometry.json2geom(jsonGeom);
                geom.merge(geomNew);
            }
        }

        var bnd=geom.getBounds();

        for(var i=0;i<geom.vertices.length;i++)
        {
            geom.vertices[i]/=bnd.maxAxis;
        }


    }
    else
    {
        var jsonGeom=data.meshes[index];

        if(!jsonGeom)
        {
            mesh=null;
            op.uiAttr({warning:'mesh not found'});
            return;
        }

        var i=0;
        geom=CGL.Geometry.json2geom(jsonGeom);


    }

    if(centerPivot.get())geom.center();

    bounds=geom.getBounds();
    updateScale();
    updateInfo(geom);

    calcNormals();
    geometryOut.set(geom);

    if(mesh)mesh.dispose();

    mesh=new CGL.Mesh(cgl,geom);
    needSetMesh=false;
    meshes[index]=mesh;

    // console.log("set mesh done");
    // console.log(geom);

    op.uiAttr({'warning':null});
}

function reload()
{
    if(!filename.get())return;
    currentIndex=-1;

    function doLoad()
    {
        CABLES.ajax(
            op.patch.getFilePath(filename.get()),
            function(err,_data,xhr)
            {
                if(err)
                {
                    if(CABLES.UI)op.uiAttr({'error':'could not load file...'});

                    console.error('ajax error:',err);
                    op.patch.loading.finished(loadingId);
                    return;
                }
                else
                {
                    if(CABLES.UI)op.uiAttr({'error':null});
                }

                try
                {
                    data=JSON.parse(_data);
                }
                catch(ex)
                {
                    if(CABLES.UI)op.uiAttr({'error':'could not load file...'});
                    op.patch.loading.finished(loadingId);
                    return;
                }

                needSetMesh=true;
                op.patch.loading.finished(loadingId);
                if(CABLES.UI) gui.jobs().finish('loading3d'+loadingId);

            });
        // setMesh();
    }

    var loadingId=op.patch.loading.start('json3dMesh',filename.get());

    if(CABLES.UI) gui.jobs().start({id:'loading3d'+loadingId,title:'loading 3d data'},doLoad);
        else doLoad();
}

};

Ops.Json3d.Json3dMesh.prototype = new CABLES.Op();
CABLES.OPS["29bf91a9-504d-4de7-bba6-bae67ee76c77"]={f:Ops.Json3d.Json3dMesh,objName:"Ops.Json3d.Json3dMesh"};




// **************************************************************
// 
// Ops.Gl.ShaderEffects.GrassWobble
// 
// **************************************************************

Ops.Gl.ShaderEffects.GrassWobble = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};


var render=op.inTrigger('render');
var trigger=op.outTrigger('trigger');


var frequency=op.inValue("frequency",1);
var mul=op.inValue("mul",0.1);


var cgl=op.patch.cgl;

var uniFrequency=null;
var shader=null;
var module=null;
var uniTime;


var srcHeadVert=''
    .endl()+'UNI float MOD_time;'
    .endl()+'UNI float MOD_frequency;'
    .endl()+'UNI float MOD_mul;'

    .endl();

var srcBodyVert=''

    .endl()+'vec3 MOD_pos=(pos).xyz;'
    .endl()+'float rndSrc=mMatrix[3].z+mMatrix[3].x;'
    
    .endl()+'#ifdef INSTANCING'
    .endl()+'   rndSrc=instMat[3].z+instMat[3].x;'
    .endl()+'#endif'

    .endl()+'float MOD_v=abs(pos.y*MOD_mul)*sin( ((MOD_time*MOD_frequency)+rndSrc) ) ;'

    .endl()+'pos.x+=MOD_v;'
    .endl()+'pos.z+=MOD_v;'


    .endl();




var startTime=CABLES.now()/1000.0;

function removeModule()
{
    if(shader && module)
    {
        shader.removeModule(module);
        shader=null;
    }
}

render.onLinkChanged=removeModule;
render.onTriggered=function()
{
    if(cgl.getShader()!=shader)
    {
        if(shader) removeModule();
        shader=cgl.getShader();
        module=shader.addModule(
            {
                title:op.objName,
                name:'MODULE_VERTEX_POSITION',
                srcHeadVert:srcHeadVert,
                srcBodyVert:srcBodyVert
            });

        uniTime=new CGL.Uniform(shader,'f',module.prefix+'time',0);
        uniFrequency=new CGL.Uniform(shader,'f',module.prefix+'frequency',frequency);
        mul.uniform=new CGL.Uniform(shader,'f',module.prefix+'mul',mul);
    }

    uniTime.setValue(CABLES.now()/1000.0-startTime);
    trigger.trigger();
};


};

Ops.Gl.ShaderEffects.GrassWobble.prototype = new CABLES.Op();
CABLES.OPS["a590b203-2b56-4e25-8f49-12c0f6549972"]={f:Ops.Gl.ShaderEffects.GrassWobble,objName:"Ops.Gl.ShaderEffects.GrassWobble"};




// **************************************************************
// 
// Ops.Gl.BlendMode
// 
// **************************************************************

Ops.Gl.BlendMode = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exec=op.inTrigger("Render"),
    inBlend=op.inValueSelect("Blendmode",['None','Normal','Add','Subtract','Multiply'],'Normal'),
    inPremul=op.inValueBool("Premultiplied"),
    next=op.outTrigger("Next");

const cgl=op.patch.cgl;
var blendMode=0;
inBlend.onChange=update;
update();

function update()
{
    if(inBlend.get()=="Normal")blendMode=CGL.BLEND_NORMAL;
    else if(inBlend.get()=="Add")blendMode=CGL.BLEND_ADD;
    else if(inBlend.get()=="Subtract")blendMode=CGL.BLEND_SUB;
    else if(inBlend.get()=="Multiply")blendMode=CGL.BLEND_MUL;
    else blendMode=CGL.BLEND_NONE;
}

exec.onTriggered=function()
{
    cgl.pushBlendMode(blendMode,inPremul.get());
    next.trigger();
    cgl.popBlendMode();
	cgl.gl.blendEquationSeparate( cgl.gl.FUNC_ADD, cgl.gl.FUNC_ADD );
	cgl.gl.blendFuncSeparate( cgl.gl.SRC_ALPHA, cgl.gl.ONE_MINUS_SRC_ALPHA, cgl.gl.ONE, cgl.gl.ONE_MINUS_SRC_ALPHA );
};


};

Ops.Gl.BlendMode.prototype = new CABLES.Op();
CABLES.OPS["ce0fff72-1438-4373-924f-e1d0f78b053f"]={f:Ops.Gl.BlendMode,objName:"Ops.Gl.BlendMode"};




// **************************************************************
// 
// Ops.Gl.Shader.BasicMaterial
// 
// **************************************************************

Ops.Gl.Shader.BasicMaterial = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={shader_frag:"{{MODULES_HEAD}}\n\nIN vec2 texCoord;\n#ifdef HAS_TEXTURES\n    IN vec2 texCoordOrig;\n    #ifdef HAS_TEXTURE_DIFFUSE\n        UNI sampler2D tex;\n    #endif\n    #ifdef HAS_TEXTURE_OPACITY\n        UNI sampler2D texOpacity;\n   #endif\n#endif\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float a;\n\nvoid main()\n{\n    {{MODULE_BEGIN_FRAG}}\n    vec4 col=vec4(r,g,b,a);\n\n    #ifdef HAS_TEXTURES\n        #ifdef HAS_TEXTURE_DIFFUSE\n\n           col=texture(tex,vec2(texCoord.x,(1.0-texCoord.y)));\n\n           #ifdef COLORIZE_TEXTURE\n               col.r*=r;\n               col.g*=g;\n               col.b*=b;\n           #endif\n        #endif\n\n        col.a*=a;\n        #ifdef HAS_TEXTURE_OPACITY\n            #ifdef TRANSFORMALPHATEXCOORDS\n                col.a*=texture(texOpacity,vec2(texCoordOrig.s,1.0-texCoordOrig.t)).g;\n            #endif\n            #ifndef TRANSFORMALPHATEXCOORDS\n                col.a*=texture(texOpacity,vec2(texCoord.s,1.0-texCoord.t)).g;\n            #endif\n       #endif\n\n    #endif\n\n    {{MODULE_COLOR}}\n\n    outColor = col;\n\n\n}\n",shader_vert:"{{MODULES_HEAD}}\n\nIN vec3 vPosition;\nIN vec3 attrVertNormal;\nIN vec2 attrTexCoord;\n\nOUT vec3 norm;\nOUT vec2 texCoord;\nOUT vec2 texCoordOrig;\n\nUNI mat4 projMatrix;\nUNI mat4 modelMatrix;\nUNI mat4 viewMatrix;\n\n#ifdef HAS_TEXTURES\n    #ifdef TEXTURE_REPEAT\n        UNI float diffuseRepeatX;\n        UNI float diffuseRepeatY;\n        UNI float texOffsetX;\n        UNI float texOffsetY;\n    #endif\n#endif\n\n\nvoid main()\n{\n    mat4 mMatrix=modelMatrix;\n    mat4 mvMatrix;\n    \n    texCoordOrig=attrTexCoord;\n    texCoord=attrTexCoord;\n    #ifdef HAS_TEXTURES\n        #ifdef TEXTURE_REPEAT\n            texCoord.x=texCoord.x*diffuseRepeatX+texOffsetX;\n            texCoord.y=texCoord.y*diffuseRepeatY+texOffsetY;\n        #endif\n    #endif\n\n    vec4 pos = vec4( vPosition, 1. );\n\n\n    #ifdef BILLBOARD\n       vec3 position=vPosition;\n       mvMatrix=viewMatrix*modelMatrix;\n\n       gl_Position = projMatrix * mvMatrix * vec4((\n           position.x * vec3(\n               mvMatrix[0][0],\n               mvMatrix[1][0],\n               mvMatrix[2][0] ) +\n           position.y * vec3(\n               mvMatrix[0][1],\n               mvMatrix[1][1],\n               mvMatrix[2][1]) ), 1.0);\n    #endif\n\n    {{MODULE_VERTEX_POSITION}}\n\n    #ifndef BILLBOARD\n        mvMatrix=viewMatrix * mMatrix;\n    #endif\n\n\n    #ifndef BILLBOARD\n        // gl_Position = projMatrix * viewMatrix * modelMatrix * pos;\n        gl_Position = projMatrix * mvMatrix * pos;\n    #endif\n}\n",};
const render=op.inTrigger("render");
const trigger=op.outTrigger("trigger");
const shaderOut=op.addOutPort(new CABLES.Port(op,"shader",CABLES.OP_PORT_TYPE_OBJECT));

shaderOut.ignoreValueSerialize=true;
const cgl=op.patch.cgl;


var shader=new CGL.Shader(cgl,'BasicMaterial');
shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);
shader.bindTextures=bindTextures;
shader.setSource(attachments.shader_vert,attachments.shader_frag);
shaderOut.set(shader);

render.onTriggered=doRender;

var textureOpacity=null;
var textureOpacityUniform=null;


function bindTextures()
{
    if(diffuseTexture.get()) cgl.setTexture(0, diffuseTexture.get().tex);
    if(textureOpacity.get()) cgl.setTexture(1, textureOpacity.get().tex);
}

op.preRender=function()
{
    shader.bind();
    doRender();
};

function doRender()
{
    if(!shader)return;

    cgl.setShader(shader);
    shader.bindTextures();

    trigger.trigger();

    cgl.setPreviousShader();
}


{
    // rgba colors
    var r=op.addInPort(new CABLES.Port(op,"r",CABLES.OP_PORT_TYPE_VALUE,{ display:'range',colorPick:'true' }));
    var g=op.addInPort(new CABLES.Port(op,"g",CABLES.OP_PORT_TYPE_VALUE,{ display:'range'}));
    var b=op.addInPort(new CABLES.Port(op,"b",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
    var a=op.addInPort(new CABLES.Port(op,"a",CABLES.OP_PORT_TYPE_VALUE,{ display:'range'}));

    a.uniform=new CGL.Uniform(shader,'f','a',a);
    b.uniform=new CGL.Uniform(shader,'f','b',b);
    r.uniform=new CGL.Uniform(shader,'f','r',r);
    g.uniform=new CGL.Uniform(shader,'f','g',g);


    r.set(Math.random());
    g.set(Math.random());
    b.set(Math.random());
    a.set(1.0);

    op.setPortGroup('Color',[r,g,b,a]);

}

{
    // diffuse outTexture


    var diffuseTexture=op.inTexture("texture");
    var diffuseTextureUniform=null;
    shader.bindTextures=bindTextures;

    diffuseTexture.onChange=function()
    {
        if(diffuseTexture.get())
        {
            // if(diffuseTextureUniform!==null)return;
            // shader.addveUniform('texDiffuse');
            if(!shader.hasDefine('HAS_TEXTURE_DIFFUSE'))shader.define('HAS_TEXTURE_DIFFUSE');
            if(!diffuseTextureUniform)diffuseTextureUniform=new CGL.Uniform(shader,'t','texDiffuse',0);
            updateTexRepeat();
        }
        else
        {
            shader.removeUniform('texDiffuse');
            shader.removeDefine('HAS_TEXTURE_DIFFUSE');
            diffuseTextureUniform=null;
        }
    };



}

{
    // opacity texture
    textureOpacity=op.inTexture("textureOpacity");

    textureOpacity.onChange=function()
    {
        if(textureOpacity.get())
        {
            if(textureOpacityUniform!==null)return;
            shader.removeUniform('texOpacity');
            shader.define('HAS_TEXTURE_OPACITY');
            if(!textureOpacityUniform)textureOpacityUniform=new CGL.Uniform(shader,'t','texOpacity',1);
        }
        else
        {
            shader.removeUniform('texOpacity');
            shader.removeDefine('HAS_TEXTURE_OPACITY');
            textureOpacityUniform=null;
        }
    };

}

op.colorizeTexture=op.addInPort(new CABLES.Port(op,"colorizeTexture",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));
op.colorizeTexture.set(false);
op.colorizeTexture.onChange=function()
{
    if(op.colorizeTexture.get()) shader.define('COLORIZE_TEXTURE');
        else shader.removeDefine('COLORIZE_TEXTURE');
};


op.doBillboard=op.addInPort(new CABLES.Port(op,"billboard",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));
op.doBillboard.set(false);
op.doBillboard.onChange=function()
{
    if(op.doBillboard.get()) shader.define('BILLBOARD');
        else shader.removeDefine('BILLBOARD');
};

var texCoordAlpha=op.inValueBool("Opacity TexCoords Transform",false);

texCoordAlpha.onChange=function()
{
    if(texCoordAlpha.get()) shader.define('TRANSFORMALPHATEXCOORDS');
        else shader.removeDefine('TRANSFORMALPHATEXCOORDS');

};

var preMultipliedAlpha=op.addInPort(new CABLES.Port(op,"preMultiplied alpha",CABLES.OP_PORT_TYPE_VALUE,{ display:'bool' }));

function updateTexRepeat()
{
    if(!diffuseRepeatXUniform)
    {
        diffuseRepeatXUniform=new CGL.Uniform(shader,'f','diffuseRepeatX',diffuseRepeatX);
        diffuseRepeatYUniform=new CGL.Uniform(shader,'f','diffuseRepeatY',diffuseRepeatY);
        diffuseOffsetXUniform=new CGL.Uniform(shader,'f','texOffsetX',diffuseOffsetX);
        diffuseOffsetYUniform=new CGL.Uniform(shader,'f','texOffsetY',diffuseOffsetY);
    }

    diffuseRepeatXUniform.setValue(diffuseRepeatX.get());
    diffuseRepeatYUniform.setValue(diffuseRepeatY.get());
    diffuseOffsetXUniform.setValue(diffuseOffsetX.get());
    diffuseOffsetYUniform.setValue(diffuseOffsetY.get());
}


{
    // texture coords

    var diffuseRepeatX=op.addInPort(new CABLES.Port(op,"diffuseRepeatX",CABLES.OP_PORT_TYPE_VALUE));
    var diffuseRepeatY=op.addInPort(new CABLES.Port(op,"diffuseRepeatY",CABLES.OP_PORT_TYPE_VALUE));
    var diffuseOffsetX=op.addInPort(new CABLES.Port(op,"Tex Offset X",CABLES.OP_PORT_TYPE_VALUE));
    var diffuseOffsetY=op.addInPort(new CABLES.Port(op,"Tex Offset Y",CABLES.OP_PORT_TYPE_VALUE));

    op.setPortGroup('Transform Texture',[diffuseRepeatX,diffuseRepeatY,diffuseOffsetX,diffuseOffsetY]);

    diffuseRepeatX.onChange=updateTexRepeat;
    diffuseRepeatY.onChange=updateTexRepeat;
    diffuseOffsetY.onChange=updateTexRepeat;
    diffuseOffsetX.onChange=updateTexRepeat;

    var diffuseRepeatXUniform=null;
    var diffuseRepeatYUniform=null;
    var diffuseOffsetXUniform=null;
    var diffuseOffsetYUniform=null;

    shader.define('TEXTURE_REPEAT');


    diffuseOffsetX.set(0);
    diffuseOffsetY.set(0);
    diffuseRepeatX.set(1);
    diffuseRepeatY.set(1);
}


};

Ops.Gl.Shader.BasicMaterial.prototype = new CABLES.Op();
CABLES.OPS["85ae5cfa-5eca-4dd8-8b30-850ac34f7cd5"]={f:Ops.Gl.Shader.BasicMaterial,objName:"Ops.Gl.Shader.BasicMaterial"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.ChromaticAberration
// 
// **************************************************************

Ops.Gl.TextureEffects.ChromaticAberration = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={chromatic_frag:"\nIN vec2 texCoord;\nUNI sampler2D tex;\nUNI float pixel;\nUNI float onePixel;\nUNI float amount;\nUNI float lensDistort;\n\n#ifdef MASK\nUNI sampler2D texMask;\n#endif\n\nvoid main()\n{\n\n   vec4 col=texture(tex,texCoord);\n\n   vec2 tc=texCoord;;\n   float pix = pixel;\n   if(lensDistort>0.0)\n   {\n       float dist = distance(texCoord, vec2(0.5,0.5));\n       tc-=0.5;\n       tc *=smoothstep(-0.9,1.0*lensDistort,1.0-dist);\n       tc+=0.5;\n   }\n\n    #ifdef MASK\n        vec4 m=texture(texMask,texCoord);\n        pix*=m.r*m.a;\n    #endif\n\n    #ifdef SMOOTH\n        float samples=round(pix/onePixel/4.0+1.0);\n        col.r=0.0;\n        col.b=0.0;\n        // float b=0.0;\n        for(float off=0.0;off<samples;off++)\n        {\n            float diff=(pix/samples)*off;\n            col.r+=texture(tex,vec2(tc.x+diff,tc.y)).r/samples;\n            col.b+=texture(tex,vec2(tc.x-diff,tc.y)).b/samples;\n        }\n    #endif\n\n    #ifndef SMOOTH\n        col.r=texture(tex,vec2(tc.x+pix,tc.y)).r;\n        col.b=texture(tex,vec2(tc.x-pix,tc.y)).b;\n    #endif\n\n   outColor = col;\n\n}\n",};
const render=op.inTrigger('render');
const pixel=op.inValue("Pixel",5);
const lensDistort=op.inValueSlider("Lens Distort",0);
const textureMask=op.inTexture("Mask");
const doSmooth=op.inValueBool("Smooth",false);
const trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

doSmooth.onChange=function()
{
    if(doSmooth.get())shader.define("SMOOTH");
        else shader.removeDefine("SMOOTH");
};

textureMask.onChange=function()
{
    if(textureMask.get())shader.define("MASK");
        else shader.removeDefine("MASK");
};

shader.setSource(shader.getDefaultVertexShader(),attachments.chromatic_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var uniPixel=new CGL.Uniform(shader,'f','pixel',0);
var uniOnePixel=new CGL.Uniform(shader,'f','onePixel',0);
var unitexMask=new CGL.Uniform(shader,'t','texMask',1);
var unilensDistort=new CGL.Uniform(shader,'f','lensDistort',lensDistort);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    var texture=cgl.currentTextureEffect.getCurrentSourceTexture();

    uniPixel.setValue(pixel.get()*(1/texture.width));
    uniOnePixel.setValue(1/texture.width);

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, texture.tex );

    if(textureMask.get()) cgl.setTexture(1, textureMask.get().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.ChromaticAberration.prototype = new CABLES.Op();
CABLES.OPS["38ac43a1-1757-48f4-9450-29f07ac0d376"]={f:Ops.Gl.TextureEffects.ChromaticAberration,objName:"Ops.Gl.TextureEffects.ChromaticAberration"};




// **************************************************************
// 
// Ops.Math.Compare.Equals
// 
// **************************************************************

Ops.Math.Compare.Equals = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const number1 = op.inValue("number1",1);
const number2 = op.inValue("number2",1);
const result = op.outValue("result");


number1.onChange=exec;
number2.onChange=exec;
exec();

function exec()
{
    result.set( number1.get() == number2.get() );
}



};

Ops.Math.Compare.Equals.prototype = new CABLES.Op();
CABLES.OPS["4dd3cc55-eebc-4187-9d4e-2e053a956fab"]={f:Ops.Math.Compare.Equals,objName:"Ops.Math.Compare.Equals"};




// **************************************************************
// 
// Ops.Boolean.IfTrueThen
// 
// **************************************************************

Ops.Boolean.IfTrueThen = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    boolean=op.inValueBool("boolean",false),
    triggerThen=op.outTrigger("then"),
    triggerElse=op.outTrigger("else");

boolean.onChange=execBool;
exe.onTriggered=exec;

function execBool()
{
    if(exe.isLinked())return;
    exec();
}

function exec()
{
    if(boolean.get() || boolean.get()>=1 ) triggerThen.trigger();
        else triggerElse.trigger();
}



};

Ops.Boolean.IfTrueThen.prototype = new CABLES.Op();
CABLES.OPS["99892fda-8821-4660-ac57-3103d1546924"]={f:Ops.Boolean.IfTrueThen,objName:"Ops.Boolean.IfTrueThen"};




// **************************************************************
// 
// Ops.Math.AddUp
// 
// **************************************************************

Ops.Math.AddUp = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var number=op.inValue("Number");
var doAdd=op.inTriggerButton("Add");
var doReset=op.inTriggerButton("Reset");

var result=op.outValue("Result");

var value=0;

doAdd.onTriggered=function()
{
    value+=number.get();
    result.set(value);
};

doReset.onTriggered=function()
{
    value=0;
    result.set(value);
};

};

Ops.Math.AddUp.prototype = new CABLES.Op();
CABLES.OPS["f1c76976-4c8f-43a5-a9c7-6e4c7d21c749"]={f:Ops.Math.AddUp,objName:"Ops.Math.AddUp"};




// **************************************************************
// 
// Ops.Gl.LineFont
// 
// **************************************************************

Ops.Gl.LineFont = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var render=op.inTrigger('render');
var string=op.inValueString('Text','cables');

var letterSpacing=op.inValue('Letter Spacing',1);
var lineWidth=op.inValue('Line Width',2);
var align=op.inValueSelect('align',['left','center','right']);

var stringWidth=0;
var meshes=[];
var vec=vec3.create();
var cgl=op.patch.cgl;
var characters=
    [
        {
            // a
            l:[
                [182.667,349.057,164.167,349.057],
                [160.333,360.557,171.333,326.89,175.333,326.89,186,360.557],
            ]
        },
        {
            // b
            l:
            [
                [174.333,343.057,160.255,343.057],
                [160.333,326.89,175.5,326.89,178.333,330.724,178.333,340.724,174.333,343.057,180.5,346.807,180.5,357.474,176,360.557,160.167,360.557,160.333,326.89]
            ]
        },
        {
            // c
            l:
            [
                [180.583,331.307,175.917,326.807,166,326.807,160.083,332.557,160.083,354.557,165.833,360.474,175.917,360.474,180.5,355.807],
            ]
        },
        {
            // d
            l:
            [
                [160.083,327.057,160.083,360.557,175.417,360.557,180.708,355.265,180.708,332.974,175.104,327.057,160.083,327.057],
            ]
        },
        {
            // e
            l:
            [
                [175.167,343.932,160.436,343.932],
                [177.917,326.807,164.5,326.807,160.436,330.872,160.436,356.845,164.014,360.422,177.917,360.422]
            ]
        },
        {
            // f
            l:
            [
                [176.792,326.932,164.125,326.932,160.167,330.891,160.167,360.683],
                [173.458,345.599,160.167,345.599],
            ]
        },
        {
            // g
            l:
            [
                [180.455,332.395,175.391,328.33,166.194,328.33,160.167,334.357,160.167,355.933,165.792,360.557,176.038,360.557,181.62,354.976,181.62,344.811,173.122,344.811 	],
            ]
        },
        {
            //h
            l:
            [
                [160.167,326.89,160.167,360.557],
                [160.5,343.723,182.333,343.723],
                [182.333,326.89,182.333,360.974]
            ]
        },
        {
            // i
            l:
            [
                [160.167,326.807,160.167,360.641]
            ]
        },
        {
            // j
            l:
            [
                [159.833,326.89,166.833,326.89,166.833,362.057,163.962,364.928,159.833,364.928],
            ]
        },
        {
            // k
            l:
            [
                [160.167,326.807,160.167,360.974],
                [178.917,326.807,160.167,348.474],
                [164.905,342.998,180.333,360.64]
            ]
        },
        {
            //l
            l:
            [
                [160.167,326.974,160.167,360.558,176.083,360.558],
            ]
        },
        {
            l:
            [
                [160.167,360.557,160.247,326.89,164.997,326.89,175.5,360.557,178,360.557,188.58,326.89,193.33,326.89,193.25,360.557],
            ]
        },
        {
            // n
            l:
            [
                [160.167,360.599,160.167,326.933,164.629,326.933,178.333,360.599,182.083,360.599,182.083,326.933],
            ]
        },
        {
            l:
            [
                [160.283,332.448,165.764,326.967,178.405,326.967,183.668,332.23,183.668,354.365,177.434,360.599,166.367,360.599,160.167,354.399,160.283,332.448],
            ]
        },

        {
            //p
            l:
            [
                [160.167,360.432,160.167,327.015,175.955,327.015,179.667,330.728,179.667,341.015,175.602,345.08,160.167,345.08],
            ]
        },

        {
            // q
            l:
            [
                [184.504,361.693,180.517,357.706],
                [160.283,332.413,165.764,326.932,178.405,326.932,183.668,332.195,183.668,354.33,177.434,360.564,166.367,360.564,160.167,354.364,160.283,332.413],
            ]
        },
        {
            // r
            l:
            [
                [179.667,360.307,173.5,344.955],
                [160.167,360.307,160.167,326.89,175.955,326.89,179.667,330.603,179.667,340.89,175.602,344.955,160.167,344.955],
            ]
        },
        {
            // s
            l:
            [
                [179.979,326.87,165.895,326.87,160.167,332.598,160.167,338.307,179.292,349.057,179.292,355.223,173.917,360.598,160.167,360.598],
            ]
        },
        {
            // t
            l:
            [
                [170.417,326.89,170.417,360.974],
                [180.5,326.89,160.167,326.89]
            ]
        },
        {
            // u
            l:
            [
                [160.167,327.14,160.167,356.845,164.108,360.786,178.125,360.786,182.012,356.899,181.958,327.14],
            ]
        },
        {
            // v
            l:
            [
                [160.167,326.901,170.167,360.797,174.417,360.797,184.667,326.734],
            ]
        },
        {
            // w
            l:
            [
                [203.5,326.89,195.208,360.557,191.458,360.557,184,326.89,179.758,326.89,172.208,360.557,168.458,360.557,160.167,326.89],
            ]
        },
        {
            // x
            l:
            [
                [181.333,360.64,159.667,326.807],
                [159.667,360.557,181.75,326.807]
            ]
        },
        {
            // y
            l:
            [
                [160.167,326.891,168.508,347.224,173.992,347.224,182.917,326.891],
                [171.333,347.224,171.333,360.641]
            ]
        },
        {
            // z
            l:
            [
                [161.167,326.807,180.5,326.807,180.5,332.473,161.167,355.223,161.167,360.557,180.5,360.557],
            ]
        },


        {
            // 0
            l:
            [
                [167.591,326.89,173.076,326.89,180.5,334.315,180.5,353.132,173.076,360.557,167.591,360.557,160.167,353.132,160.167,334.315,167.591,326.89],
            ]
        },
        {
            // 1
            l:
            [
                [160.167,334.315,167.549,326.932,170.333,326.89,170.417,360.557],
            ]
        },
        {
            // 2
            l:
            [
                [164.066,330.415,167.591,326.89,180.5,326.89,180.5,330.603,160.167,351.224,160.167,360.557,180.5,360.599],
            ]
        },
        {
            // 3
            l:
            [
                [169.583,342.932,180.5,342.932],
                [163.129,331.353,167.591,326.89,180.5,326.89,180.5,360.557,167.591,360.557,162.837,355.803],
            ]
        },
        {
            // 4
            l:
            [
                [178.076,326.89,178.076,360.599],
                [160.167,326.89,160.167,338.474,165.104,343.412,178.5,343.412],
            ]
        },
        {
            // 5
            l:
            [
                [180.5,326.89,160.098,326.958,160.167,342.932,180.5,342.932,180.5,353.132,173.076,360.557,160.167,360.557],
            ]
        },
        {
            // 6
            l:
            [
                [173.076,326.89,167.591,326.89,160.167,333.89,160.167,353.132,167.591,360.557,173.417,360.557,180.671,353.303,180.671,342.932,160.167,342.932],
            ]
        },
        {
            // 7
            l:
            [
                [163.591,326.89,180.5,326.89,170.417,360.557],
            ]
        },
        {
            // 8
            l:
            [
                [180.5,334.315,173.076,326.89,167.591,326.89,160.167,334.315,180.5,353.132,173.076,360.557,167.591,360.557,160.167,353.132,180.5,334.315],
            ]
        },
        {
            // 9
            l:
            [
                [167.591,360.557,173.076,360.557,180.5,353.132,180.5,334.315,173.076,326.89,167.591,326.89,160.167,334.315,160.167,342.932,180.5,342.932]
            ]
        },

        {
            // &
            l:
            [
                [182.496,351.137,173.076,360.557,167.591,360.557,160.167,353.132,160.167,348.087,173.922,339.533,172.229,326.89,165.167,326.89,165.052,339.515,184.292,359.432],
            ]
        },
        {
            // '
            l:
            [
        		[160.167,326.932,160.167,333.557],
        		[162.879,326.932,162.879,333.557]

            ]
        },
        {
            // ;
            l:
            [
        		[160.167,342.932,160.167,346.224],
        		[160.167,354.224,160.167,360.557]
            ]
        },
        {
            // :
            l:
            [
        		[160.167,342.932,160.167,346.224],
        		[160.167,354.224,160.167,357.974]
            ]
        },
        {
            // _
            l:
            [
        		[160.167,360.557,170.417,360.557]
            ]
        },
        {
            // +
            l:
            [
        		[160.167,342.932,170,342.932],
                [164.833,347.849,164.833,338.015]
            ]
        },
        {
            // -
            l:
            [
        		[160.167,342.932,170,342.932],
            ]
        },
        {
            // /
            l:
            [
        		[180.5,326.89,160.167,360.557],
            ]
        },
        {
            // .
            l:
            [
        		[160.167,360.599,163.417,360.599],
            ]
        },
        {
            // ,
            l:
            [
        		[165.163,360.557,160.167,365.553],
            ]
        },
        {
            // )
            l:
            [
        		[160.167,360.557,167.591,353.132,167.591,334.315,160.167,326.89],
            ]
        },
        {
            // (
            l:
            [
        		[167.591,326.89,160.167,334.315,160.167,353.132,167.591,360.557],
            ]
        },
        {
            // ?
            l:
            [
        		[170.333,363.481,170.333,368.966],
        		[160.167,334.315,167.591,326.89,173.076,326.89,180.5,334.315,180.5,342.932,170.333,353.132,170.333,360.557]
            ]
        },
        {
            // !
            l:
            [
                [160.167,353.557,160.167,326.89],
                [160.167,357.64,160.167,360.557]
            ]
        },

    ];


function translateX(w)
{
    vec3.set(vec, w,0,0);
    mat4.translate(cgl.mMatrix,cgl.mMatrix, vec);
}

var alignMode=0;
align.onChange=function()
{
    if(align.get()=="left")alignMode=0;
    if(align.get()=="center")alignMode=1;
    if(align.get()=="right")alignMode=2;
};

var oldPrim=0;
var shader=null;
function renderChar(charIndex,simulate)
{
    shader=cgl.getShader();
    if(!shader)return;
    oldPrim=shader.glPrimitive;

    shader.glPrimitive=cgl.gl.LINE_STRIP;

    if(charIndex>=characters.length)charIndex=0;

    if(!simulate)
    {
        for(var m=0;m<characters[charIndex].m.length;m++)
        {
            characters[charIndex].m[m].render(op.patch.cgl.getShader());
        }
        translateX(characters[charIndex].w*letterSpacing.get());
    }
    else
    {
        stringWidth+=characters[charIndex].w*letterSpacing.get();
    }
    shader.glPrimitive=oldPrim;
}


render.onTriggered=function()
{
    stringWidth=0;
    if(!string.get())return;
    var spaceWidth=0.15;
    vec3.set(vec, 0.3,0,0);
    cgl.pushModelMatrix();

    var startCharacters=97;
    var startNumbers=48;

    var str=string.get()+'';

    cgl.gl.lineWidth(lineWidth.get());

    for(var sim=0;sim<2;sim++)
    {
        var simulate=sim===0;

        if(!simulate)
        {
            if(alignMode==1) translateX(-stringWidth/2+0.04*letterSpacing.get());
            if(alignMode==2) translateX(-stringWidth+0.08*letterSpacing.get());
        }

        for(var i=0;i<str.length;i++)
        {
            var w=0;
            var charIndex=str.toLowerCase().charCodeAt(i);

            if(charIndex==38) renderChar(36,simulate); // &
            else if(charIndex==39) renderChar(37,simulate); // '
            else if(charIndex==34) renderChar(37,simulate); // '
            else if(charIndex==59) renderChar(38,simulate); // ;
            else if(charIndex==58) renderChar(39,simulate); // :
            else if(charIndex==95) renderChar(40,simulate); // _
            else if(charIndex==43) renderChar(41,simulate); // +
            else if(charIndex==45) renderChar(42,simulate); // -
            else if(charIndex==47) renderChar(43,simulate); // /
            else if(charIndex==46) renderChar(44,simulate); // .
            else if(charIndex==44) renderChar(45,simulate); // ,
            else if(charIndex==41) renderChar(46,simulate); // )
            else if(charIndex==40) renderChar(47,simulate); // ()
            else if(charIndex==63) renderChar(48,simulate); // ?
            else if(charIndex==33) renderChar(49,simulate); // !
            else
            if(charIndex>=startNumbers && charIndex<=startNumbers+10)
            {
                renderChar(charIndex-startNumbers+26,simulate);
            }
            else
            if(charIndex>=startCharacters && charIndex-startCharacters<characters.length)
            {
                renderChar(charIndex-startCharacters,simulate);
            }
            else
            if(charIndex==32)
            {
                if(simulate)stringWidth+=spaceWidth;
                else translateX(spaceWidth);
            }
            else
            {
                renderChar(48,simulate);
            }
        }
    }

    cgl.popModelMatrix();
};

function avg(which)
{
    var avgX=0,avgY=0;
    var count=0;
    for(var l=0;l<characters[which].l.length;l++)
    {
        for(var j=0;j<characters[which].l[l].length;j+=2)
        {
            avgX+=characters[which].l[l][j];
            avgY+=characters[which].l[l][j+1];
            count++;
        }
    }
    avgX/=count;
    avgY/=count;
    return [avgX,avgY];
}

function min(which)
{
    var min=9999999;

    for(var l=0;l<characters[which].l.length;l++)
    {
        for(var j=0;j<characters[which].l[l].length;j+=2)
        {
            min=Math.min(min,characters[which].l[l][j]);
        }
    }
    return min;
}

function width(which)
{
    var min=9999999;
    var max=-9999999;

    for(var l=0;l<characters[which].l.length;l++)
    {
        for(var j=0;j<characters[which].l[l].length;j+=2)
        {
            min=Math.min(min,characters[which].l[l][j]);
            max=Math.max(max,characters[which].l[l][j]);
        }
    }
    return ((max-min));
}

meshes.length=0;

var avgXY=[];
var avg1=avg(0);
var avg2=avg(1);

avgXY=[ (avg1[0]+avg2[0])/2, (avg1[1]+avg2[1])/2 ];

for(var i=0;i<characters.length;i++)
{
    characters[i].w=width(i)*(0.002);
    characters[i].m=[];
    for(var l=0;l<characters[i].l.length;l++)
    {
        var count=0;
        var indices=[];
        var vertices=[];

        for(var j=0;j<characters[i].l[l].length;j+=2)
        {
            vertices.push( (characters[i].l[l][j]-min(i))*0.005 );
            vertices.push( (characters[i].l[l][j+1]-avgXY[1])*-0.005 );
            vertices.push( 0 );

            indices.push(count);
            count++;
        }

        var geom=new CGL.Geometry();
        geom.vertices=vertices;
        geom.verticesIndices=indices;
        var mesh=new CGL.Mesh(op.patch.cgl,geom);
        characters[i].m.push(mesh);
    }

    characters[i].w+=0.1;
}


};

Ops.Gl.LineFont.prototype = new CABLES.Op();
CABLES.OPS["580146e1-eb24-451f-b05d-0c7cfec8d8e6"]={f:Ops.Gl.LineFont,objName:"Ops.Gl.LineFont"};




// **************************************************************
// 
// Ops.Gl.Spray
// 
// **************************************************************

Ops.Gl.Spray = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const exe=op.inTrigger("exe");
const timer=op.inValue("time");
const num=op.inValue("num",100);
const sizeX=op.inValue("Size X");
const sizeY=op.inValue("Size Y");
const sizeZ=op.inValue("Size Z");
const movementX=op.inValue("movement x",1);
const movementY=op.inValue("movement y",1);
const movementZ=op.inValue("movement z",1);
const inReset=op.inTriggerButton("Reset");
const lifetime=op.inValue("lifetime",10);
const lifetimeMin=op.inValue("Lifetime Minimum",5);

const trigger=op.outTrigger("trigger") ;
const idx=op.outValue("index");
const lifeTimePercent=op.outValue("lifeTimePercent");
const outRandom1=op.outValue("Random 1");
const outRandom2=op.outValue("Random 2");
const outRandom3=op.outValue("Random 3");

inReset.onTriggered=reset;
const cgl=op.patch.cgl;

var particles=[];
var transVec=vec3.create();

num.onChange=
    sizeX.onChange=
    sizeY.onChange=
    sizeZ.onChange=
    lifetime.onChange=
    lifetimeMin.onChange=reset;

reset();

function Particle()
{
    this.pos=null;
    this.startPos=null;
    this.startTime=0;
    this.lifeTime=0;
    this.lifeTimePercent=0;
    this.endTime=0;

    this.pos=[0,0,0];
    this.moveVec=[0,0,0];
    this.idDead=false;

    this.random1=Math.random();
    this.random2=Math.random();
    this.random3=Math.random();

    this.update=function(time)
    {
        var timeRunning=time-this.startTime;
        if(time>this.endTime)this.isDead=true;
        this.lifeTimePercent=timeRunning/ ( this.lifeTime );

        this.pos=vec3.fromValues(
            this.startPos[0]+timeRunning*this.moveVec[0],
            this.startPos[1]+timeRunning*this.moveVec[1],
            this.startPos[2]+timeRunning*this.moveVec[2]
            );
    };

    this.reAnimate=function(time)
    {
        this.isDead=false;
        this.lifeTime = Math.random() * ( lifetime.get() - lifetimeMin.get() ) + lifetimeMin.get();
        this.startTime=time;

        this.endTime=time+this.lifeTime;
        this.startPos=vec3.fromValues(
            Math.random()*sizeX.get(),
            Math.random()*sizeY.get(),
            Math.random()*sizeZ.get());

        this.moveVec=[
            Math.random()*movementX.get(),
            Math.random()*movementY.get(),
            Math.random()*movementZ.get()
            ];
    };
    this.reAnimate(0);
}

exe.onTriggered=function()
{
    var time=timer.get();
    for(var i=0;i<particles.length;i++)
    {
        if(particles[i].isDead)particles[i].reAnimate(time);

        particles[i].update(time);

        cgl.pushModelMatrix();

        mat4.translate(cgl.mMatrix,cgl.mMatrix, particles[i].pos);

        idx.set(i);
        lifeTimePercent.set(particles[i].lifeTimePercent);

        outRandom1.set(particles[i].random1);
        outRandom2.set(particles[i].random2);
        outRandom3.set(particles[i].random3);

        trigger.trigger();

        cgl.popModelMatrix();
    }
};

function reset()
{
    particles.length=0;

    for(var i=0;i<num.get();i++)
    {
        var p=new Particle();
        p.reAnimate(0);
        particles.push(p);
    }
}


};

Ops.Gl.Spray.prototype = new CABLES.Op();
CABLES.OPS["80ca4cc5-d6ba-4fbf-a629-de04df600060"]={f:Ops.Gl.Spray,objName:"Ops.Gl.Spray"};




// **************************************************************
// 
// Ops.Math.Random2
// 
// **************************************************************

Ops.Math.Random2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var exe=op.inTriggerButton('Generate');
var min=op.inValue("min",0);
var max=op.inValue("max",1);
var result=op.outValue("result");
var inInteger=op.inValueBool("Integer",false);

exe.onTriggered=genRandom;
max.onChange=genRandom;
min.onChange=genRandom;
inInteger.onChange=genRandom;

genRandom();

function genRandom()
{
    var r=(Math.random()*(max.get()-min.get()))+min.get();
    if(inInteger.get())r=Math.round(r);
    result.set(r);
}


};

Ops.Math.Random2.prototype = new CABLES.Op();
CABLES.OPS["8cb69d73-3e0e-4785-b4cc-499c8372d03c"]={f:Ops.Math.Random2,objName:"Ops.Math.Random2"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Interlace
// 
// **************************************************************

Ops.Gl.TextureEffects.Interlace = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={interlace_frag:"\n#ifdef HAS_TEXTURES\n  IN vec2 texCoord;\n  UNI sampler2D tex;\n#endif\nUNI float amount;\nUNI float lum;\nUNI float add;\nUNI float lineSize;\nUNI float scroll;\nUNI float displace;\n\n\nvoid main()\n{\n   vec4 col=vec4(1.0,0.0,0.0,1.0);\n\n   col=texture(tex,texCoord);\n    // .endl()+'   col=clamp(col,0.0,1.0);'\n   if( mod(gl_FragCoord.y+scroll,lineSize)>=lineSize*0.5)\n   {\n       col=texture(tex,vec2(texCoord.x+displace*0.05,texCoord.y));\n       float gray = vec3(dot(vec3(0.2126,0.7152,0.0722), col.rgb)).r;\n       col.rgb=col.rgb*(1.0-amount) + (col.rgb*gray*gray*lum)*amount;\n   }\n   else col+=add;\n\n\n   outColor= col;\n}",};
var render=op.inTrigger('render');
var amount=op.inValueSlider("amount",0.5);
var lum=op.inValueSlider("Lumi Scale",0.9);
var lineSize=op.inValue("Line Size",4);
var displace=op.inValueSlider("Displacement",0);

var add=op.inValue("Add",0.02);
var inScroll=op.inValue("scroll",0);

var trigger=op.outTrigger('trigger');

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);




shader.setSource(shader.getDefaultVertexShader(),attachments.interlace_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var uniAmount=new CGL.Uniform(shader,'f','amount',amount);

var uniLum=new CGL.Uniform(shader,'f','lum',lum);
var uniLineSize=new CGL.Uniform(shader,'f','lineSize',lineSize);
var uniAdd=new CGL.Uniform(shader,'f','add',add);
var uniDisplace=new CGL.Uniform(shader,'f','displace',displace);
var uniScroll=new CGL.Uniform(shader,'f','scroll',inScroll);


render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );


    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Interlace.prototype = new CABLES.Op();
CABLES.OPS["3cd69d5b-6c05-4522-9551-52458f99421a"]={f:Ops.Gl.TextureEffects.Interlace,objName:"Ops.Gl.TextureEffects.Interlace"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Border
// 
// **************************************************************

Ops.Gl.TextureEffects.Border = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={border_frag:"IN vec2 texCoord;\nUNI float width;\nUNI sampler2D tex;\nUNI float amount;\nUNI float r;\nUNI float g;\nUNI float b;\nUNI float aspect;\nUNI bool smoothed;\n\n{{BLENDCODE}}\n\nvoid main()\n{\n   vec4 col= texture(tex,texCoord);\n\n    if(!smoothed)\n    {\n       if( texCoord.x>1.0-width/3.0 || texCoord.y>1.0-width/aspect/3.0 || texCoord.y<width/aspect/3.0 || texCoord.x<width/3.0 )\n            col = vec4(r,g,b, 1.0);\n    }\n    else\n    {\n       float f=smoothstep(0.0,width,texCoord.x)-smoothstep(1.0-width,1.0,texCoord.x);\n       f*=smoothstep(0.0,width/aspect,texCoord.y);\n       f*=smoothstep(1.0,1.0-width/aspect,texCoord.y);\n       col= mix(col,vec4(r,g,b, 1.0),1.0-f);\n    }\n\n\n    vec4 base=texture(tex,texCoord);\n\n    col=vec4( _blend(base.rgb,col.rgb) ,1.0);\n    col=vec4( mix( col.rgb, base.rgb ,1.0-base.a*amount),1.0);\n\n    outColor= col;\n}",};
const render=op.inTrigger('render');
const blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
const amount=op.inValueSlider("Amount",1);
const trigger=op.outTrigger('trigger');
const smooth=op.inValueBool("Smooth",false);

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

const srcFrag=(attachments.border_frag||'').replace("{{BLENDCODE}}",CGL.TextureEffect.getBlendCode());
shader.setSource(shader.getDefaultVertexShader(),srcFrag);

const textureUniform=new CGL.Uniform(shader,'t','tex',0);
const amountUniform=new CGL.Uniform(shader,'f','amount',amount);
const aspectUniform=new CGL.Uniform(shader,'f','aspect',0);
const uniSmooth=new CGL.Uniform(shader,'b','smoothed',smooth);

{
    const width=op.inValue("width",0.1);

    const uniWidth=new CGL.Uniform(shader,'f','width',width.get());

    width.onValueChange(function()
    {
        uniWidth.setValue(width.get()/2 );
    });
}

const r = op.inValueSlider("r", Math.random());
const g = op.inValueSlider("g", Math.random());
const b = op.inValueSlider("b", Math.random());
r.setUiAttribs({ colorPick: true });

const unir=new CGL.Uniform(shader,'f','r',r);
const unig=new CGL.Uniform(shader,'f','g',g);
const unib=new CGL.Uniform(shader,'f','b',b);

// {
//     var r=op.addInPort(new CABLES.Port(op,"diffuse r",CABLES.OP_PORT_TYPE_VALUE,{ display:'range', colorPick:'true' }));
//     r.onChange=function()
//     {
//         if(!r.uniform) r.uniform=new CGL.Uniform(shader,'f','r',r.get());
//             else r.uniform.setValue(r.get());
//     };

//     var g=op.addInPort(new CABLES.Port(op,"diffuse g",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
//     g.onChange=function()
//     {
//         if(!g.uniform) g.uniform=new CGL.Uniform(shader,'f','g',g.get());
//             else g.uniform.setValue(g.get());
//     };

//     var b=op.addInPort(new CABLES.Port(op,"diffuse b",CABLES.OP_PORT_TYPE_VALUE,{ display:'range' }));
//     b.onChange=function()
//     {
//         if(!b.uniform) b.uniform=new CGL.Uniform(shader,'f','b',b.get());
//             else b.uniform.setValue(b.get());
//     };

//     r.set(Math.random());
//     g.set(Math.random());
//     b.set(Math.random());
// }

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    var texture=cgl.currentTextureEffect.getCurrentSourceTexture();
    aspectUniform.set(texture.height/texture.width);

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, texture.tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Border.prototype = new CABLES.Op();
CABLES.OPS["e6aae62c-1620-465d-94de-049148b530e6"]={f:Ops.Gl.TextureEffects.Border,objName:"Ops.Gl.TextureEffects.Border"};




// **************************************************************
// 
// Ops.Audio.Bang
// 
// **************************************************************

Ops.Audio.Bang = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var exe=this.addInPort(new CABLES.Port(this,"exe",CABLES.OP_PORT_TYPE_FUNCTION));
var beat=op.inTriggerButton("beat");
var bang=this.addOutPort(new CABLES.Port(this,"bang"));

var startValue=this.addInPort(new CABLES.Port(this,"startValue"));
var endValue=this.addInPort(new CABLES.Port(this,"endValue"));
var duration = 0;
var bpm=this.addInPort(new CABLES.Port(this,"bpm"));

var anim=new CABLES.Anim();

var easing=this.addInPort(new CABLES.Port(this,"easing",CABLES.OP_PORT_TYPE_VALUE,{display:'dropdown',values:["linear","smoothstep","smootherstep"]} ));
easing.set('linear');


function init()
{
    if(easing.get()=='linear') anim.defaultEasing=CABLES.TL.EASING_LINEAR;
    if(easing.get()=='smoothstep') anim.defaultEasing=CABLES.TL.EASING_SMOOTHSTEP;
    if(easing.get()=='smootherstep') anim.defaultEasing=CABLES.TL.EASING_SMOOTHERSTEP;

    anim.clear();

    if(bpm === 0){
        anim.setValue(parseFloat(1000 + op.patch.freeTimer.get()), endValue.get());
    }else {
        duration = 4 / (bpm.get()/60); // duration of one beat in seconds
        anim.setValue(op.patch.freeTimer.get(), startValue.get());
        anim.setValue(parseFloat(duration + op.patch.freeTimer.get()), endValue.get());
    }
}

beat.onTriggered = function(){
    var t=op.patch.freeTimer.get();
    var v=anim.getValue(t);
    init();
};

var redoAnimtion = true;

exe.onTriggered=function()
{
    // if there is no beat, don't bang
    if(bpm.get() === 0) {
        bang.set(endValue.get());
    }

    var t=op.patch.freeTimer.get();
    var v=anim.getValue(t);

    bang.set(v);
};

startValue.set(1.0);
endValue.set(0.0);
bpm.set(0);
init();

startValue.onValueChange(init);
endValue.onValueChange(init);
bpm.onValueChange(init);
easing.onValueChange(init);


};

Ops.Audio.Bang.prototype = new CABLES.Op();
CABLES.OPS["a745f54c-d85e-4ddf-b6db-c3cbc9c4330d"]={f:Ops.Audio.Bang,objName:"Ops.Audio.Bang"};




// **************************************************************
// 
// Ops.Trigger.IfEqualsThen
// 
// **************************************************************

Ops.Trigger.IfEqualsThen = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const exe=op.inTrigger("exe");
var value1=op.inValue("Value 1",0);
var value2=op.inValue("Value 2",0);

var triggerThen=op.addOutPort(new CABLES.Port(op,"then",CABLES.OP_PORT_TYPE_FUNCTION));
var triggerElse=op.addOutPort(new CABLES.Port(op,"else",CABLES.OP_PORT_TYPE_FUNCTION));

function exec()
{
    if(value1.get()==value2.get() )
    {
        triggerThen.trigger();
    }
    else
    {
        triggerElse.trigger();
    }
}

exe.onTriggered=exec;


};

Ops.Trigger.IfEqualsThen.prototype = new CABLES.Op();
CABLES.OPS["e8196d70-d0a6-470a-9448-a7ac0c0e956e"]={f:Ops.Trigger.IfEqualsThen,objName:"Ops.Trigger.IfEqualsThen"};




// **************************************************************
// 
// Ops.Trigger.TriggerOnce
// 
// **************************************************************

Ops.Trigger.TriggerOnce = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var exe=op.inTriggerButton("Exec");
var reset=op.inTriggerButton("Reset");
var next=op.outTrigger("Next");
var outTriggered=op.outValue("Was Triggered");
var triggered=false;

reset.onTriggered=function()
{
    triggered=false;
    outTriggered.set(triggered);
};

exe.onTriggered=function()
{
    if(triggered)return;

    triggered=true;
    next.trigger();
    outTriggered.set(triggered);

};

};

Ops.Trigger.TriggerOnce.prototype = new CABLES.Op();
CABLES.OPS["cf3544e4-e392-432b-89fd-fcfb5c974388"]={f:Ops.Trigger.TriggerOnce,objName:"Ops.Trigger.TriggerOnce"};




// **************************************************************
// 
// Ops.Anim.SineAnim
// 
// **************************************************************

Ops.Anim.SineAnim = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    exe=op.inTrigger("exe"),
    result=op.outValue("result"),
    phase=op.inValueFloat("phase",0),
    mul=op.inValueFloat("frequency",1),
    amplitude=op.inValueFloat("amplitude",1);

exe.onTriggered=exec;
exec();

function exec()
{
    result.set( amplitude.get() * Math.sin( (op.patch.freeTimer.get()*mul.get()) + phase.get() ));
}



};

Ops.Anim.SineAnim.prototype = new CABLES.Op();
CABLES.OPS["736d3d0e-c920-449e-ade0-f5ca6018fb5c"]={f:Ops.Anim.SineAnim,objName:"Ops.Anim.SineAnim"};




// **************************************************************
// 
// Ops.Math.Divide
// 
// **************************************************************

Ops.Math.Divide = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const number1 = op.addInPort(new CABLES.Port(op, "number1"));
const number2 = op.addInPort(new CABLES.Port(op, "number2"));
const result = op.addOutPort(new CABLES.Port(op, "result"));

const exec = function() {
    result.set( number1.get() / number2.get() );
};

number1.set(1);
number2.set(1);

number1.onChange=exec;
number2.onChange=exec;
exec();


};

Ops.Math.Divide.prototype = new CABLES.Op();
CABLES.OPS["86fcfd8c-038d-4b91-9820-a08114f6b7eb"]={f:Ops.Math.Divide,objName:"Ops.Math.Divide"};




// **************************************************************
// 
// Ops.Gl.Meshes.Rectangle
// 
// **************************************************************

Ops.Gl.Meshes.Rectangle = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var render=op.inTrigger("render");
var trigger=op.outTrigger('trigger');

var width=op.inValue("width",1);
var height=op.inValue("height",1);

var pivotX=op.inValueSelect("pivot x",["center","left","right"]);
var pivotY=op.inValueSelect("pivot y",["center","top","bottom"]);

var nColumns=op.inValueInt("num columns",1);
var nRows=op.inValueInt("num rows",1);
var axis=op.inValueSelect("axis",["xy","xz"],"xy");

var active=op.inValueBool('Active',true);

var geomOut=op.outObject("geometry");
geomOut.ignoreValueSerialize=true;

var cgl=op.patch.cgl;
axis.set('xy');
pivotX.set('center');
pivotY.set('center');

op.setPortGroup('Pivot',[pivotX,pivotY]);
op.setPortGroup('Size',[width,height]);
op.setPortGroup('Structure',[nColumns,nRows]);

var geom=new CGL.Geometry('rectangle');
var mesh=null;

axis.onChange=rebuild;
pivotX.onChange=rebuild;
pivotY.onChange=rebuild;
width.onChange=rebuild;
height.onChange=rebuild;
nRows.onChange=rebuild;
nColumns.onChange=rebuild;
rebuild();

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpNotInTextureEffect(op)) return;


    if(active.get() && mesh) mesh.render(cgl.getShader());
    trigger.trigger();
};

function rebuild()
{
    var w=width.get();
    var h=height.get();
    var x=0;
    var y=0;

    if(typeof w=='string')w=parseFloat(w);
    if(typeof h=='string')h=parseFloat(h);

    if(pivotX.get()=='center') x=0;
    else if(pivotX.get()=='right') x=-w/2;
    else if(pivotX.get()=='left') x=+w/2;

    if(pivotY.get()=='center') y=0;
    else if(pivotY.get()=='top') y=-h/2;
    else if(pivotY.get()=='bottom') y=+h/2;

    var verts=[];
    var tc=[];
    var norms=[];
    var tangents=[];
    var biTangents=[];
    var indices=[];

    var numRows=Math.round(nRows.get());
    var numColumns=Math.round(nColumns.get());

    var stepColumn=w/numColumns;
    var stepRow=h/numRows;

    var c,r,a;
    a=axis.get();
    for(r=0;r<=numRows;r++)
    {
        for(c=0;c<=numColumns;c++)
        {
            verts.push( c*stepColumn - width.get()/2+x );
            if(a=='xz') verts.push( 0.0 );
            verts.push( r*stepRow - height.get()/2+y );
            if(a=='xy') verts.push( 0.0 );

            tc.push( c/numColumns );
            tc.push( 1.0-r/numRows );

            if(a=='xz')
            {
                norms.push(0,1,0);
                tangents.push(1,0,0);
                biTangents.push(0,0,1);
            }
            else if(a=='xy')
            {
                norms.push(0,0,1);
                tangents.push(-1,0,0);
                biTangents.push(0,-1,0);
            }
        }
    }

    for(c=0;c<numColumns;c++)
    {
        for(r=0;r<numRows;r++)
        {
            var ind = c+(numColumns+1)*r;
            var v1=ind;
            var v2=ind+1;
            var v3=ind+numColumns+1;
            var v4=ind+1+numColumns+1;

            indices.push(v1);
            indices.push(v3);
            indices.push(v2);

            indices.push(v2);
            indices.push(v3);
            indices.push(v4);
        }
    }

    geom.clear();
    geom.vertices=verts;
    geom.texCoords=tc;
    geom.verticesIndices=indices;
    geom.vertexNormals=norms;
    geom.tangents=tangents;
    geom.biTangents=biTangents;

    if(numColumns*numRows>64000)geom.unIndex();

    if(!mesh) mesh=new CGL.Mesh(cgl,geom);
        else mesh.setGeom(geom);

    geomOut.set(null);
    geomOut.set(geom);

}

op.onDelete=function()
{
    if(mesh)mesh.dispose();
}

};

Ops.Gl.Meshes.Rectangle.prototype = new CABLES.Op();
CABLES.OPS["20f3c4e7-04d1-44e0-b868-05756d1c66c6"]={f:Ops.Gl.Meshes.Rectangle,objName:"Ops.Gl.Meshes.Rectangle"};




// **************************************************************
// 
// Ops.Anim.StringTypeAnimation
// 
// **************************************************************

Ops.Anim.StringTypeAnimation = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var text=op.addInPort(new CABLES.Port(op,"text",CABLES.OP_PORT_TYPE_VALUE,{type:'string',display:'editor'}));
var inRestart=op.inTriggerButton("Restart");
var speed=op.inValue("Speed",500);
var speedVariation=op.inValueSlider("Speed Variation");

var outText=op.outValueString("Result");
var outChanged=op.outTrigger("Changed");
var outFinished=op.outTrigger("Finished");

outText.set('  \n  ');
var pos=0;
var updateInterval=0;
var cursorblink=true;
var finished=false;

function setNewTimeout()
{
    clearTimeout(updateInterval);
    var ms=speed.get()*(Math.random()*(speedVariation.get()*2-1));
    if(pos>text.get().length)ms=speed.get();
    updateInterval=setTimeout(update,speed.get()+ms);
}

inRestart.onTriggered=function()
{
    finished=false;
    pos=0;
    setNewTimeout();
};

function update()
{
    if(!text.get() || text.get()==='' || text.get()==='0' ||text.get()=='0' )
    {
        outText.set(' ');
        return;
    }

    var t=text.get().substring(0,pos);
    cursorblink=!cursorblink;

    if(pos>text.get().length && cursorblink)
    {
        if(!finished)
        {
            outFinished.trigger();
            finished=true;
        }
    }
    else
    {
        finished=false;
        t+='_';
        pos++;
    }

    outText.set( t );
    outChanged.trigger();
    setNewTimeout();
}

text.onChange=function()
{
    finished=false;
    pos=0;
    setNewTimeout();
};


};

Ops.Anim.StringTypeAnimation.prototype = new CABLES.Op();
CABLES.OPS["61b0db65-814c-403f-b4d1-2b58e6311454"]={f:Ops.Anim.StringTypeAnimation,objName:"Ops.Anim.StringTypeAnimation"};




// **************************************************************
// 
// Ops.Array.ParseArray
// 
// **************************************************************

Ops.Array.ParseArray = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var text=op.addInPort(new CABLES.Port(op,"text",CABLES.OP_PORT_TYPE_VALUE,{type:'string',display:'editor'}));
var separator=op.inValueString("separator",",");

var toNumber=op.inValueBool("Numbers",false);

var parsed=op.outTrigger("Parsed");
var arr=op.addOutPort(new CABLES.Port(op,"array",CABLES.OP_PORT_TYPE_ARRAY));
var len=op.addOutPort(new CABLES.Port(op,"length",CABLES.OP_PORT_TYPE_VALUE));

separator.set(',');
text.set('1,2,3');

text.onChange=parse;
separator.onChange=parse;
toNumber.onChange=parse;

parse();

function parse()
{
    if(!text.get())return;
    
    var r=text.get().split(separator.get());
    len.set(r.length);

    if(toNumber.get())
    {
        for(var i=0;i<r.length;i++)
        {
            r[i]=Number(r[i]);
        }
    }
    
    arr.set(null);
    arr.set(r);
    parsed.trigger();
}


};

Ops.Array.ParseArray.prototype = new CABLES.Op();
CABLES.OPS["6d6bd309-fb4b-4eed-9a05-5a1cd93f2a05"]={f:Ops.Array.ParseArray,objName:"Ops.Array.ParseArray"};




// **************************************************************
// 
// Ops.Array.ArrayGetString
// 
// **************************************************************

Ops.Array.ArrayGetString = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var array=op.inArray("array");
var index=op.inValueInt("index");
var result=op.outString("result");
array.ignoreValueSerialize=true;

index.onChange=update;
var arr=null;

function update()
{
    if(arr) result.set( arr[index.get()]);
}


array.onChange=function()
{
    arr=array.get();
    update();
};


};

Ops.Array.ArrayGetString.prototype = new CABLES.Op();
CABLES.OPS["be8f16c0-0c8a-48a2-a92b-45dbf88c76c1"]={f:Ops.Array.ArrayGetString,objName:"Ops.Array.ArrayGetString"};




// **************************************************************
// 
// Ops.String.StringCompose2
// 
// **************************************************************

Ops.String.StringCompose2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const
    format=op.inString('Format',"hello $a, $b $c und $d"),
    a=op.inString('String A','world'),
    b=op.inString('String B',1),
    c=op.inString('String C',2),
    d=op.inString('String D',3),
    e=op.inString('String E'),
    f=op.inString('String F'),
    result=op.outValue("Result");

format.onChange=
    a.onChange=
    b.onChange=
    c.onChange=
    d.onChange=
    e.onChange=
    f.onChange=update;

update();

function update()
{
    var str=format.get()||'';
    if(typeof str!='string')
        str='';

    str = str.replace(/\$a/g, a.get());
    str = str.replace(/\$b/g, b.get());
    str = str.replace(/\$c/g, c.get());
    str = str.replace(/\$d/g, d.get());
    str = str.replace(/\$e/g, e.get());
    str = str.replace(/\$f/g, f.get());

    result.set(str);
}

};

Ops.String.StringCompose2.prototype = new CABLES.Op();
CABLES.OPS["1ff330ef-0a23-4d49-b45b-129e17786641"]={f:Ops.String.StringCompose2,objName:"Ops.String.StringCompose2"};




// **************************************************************
// 
// Ops.Gl.Meshes.FullscreenRectangle
// 
// **************************************************************

Ops.Gl.Meshes.FullscreenRectangle = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={shader_frag:"\nUNI sampler2D tex;\nIN vec2 texCoord;\n\nvoid main()\n{\n   outColor= texture(tex,vec2(texCoord.x,(1.0-texCoord.y)));\n}\n",shader_vert:"{{MODULES_HEAD}}\n\nIN vec3 vPosition;\nUNI mat4 projMatrix;\nUNI mat4 mvMatrix;\n\nOUT vec2 texCoord;\nIN vec2 attrTexCoord;\n\nvoid main()\n{\n   vec4 pos=vec4(vPosition,  1.0);\n\n   texCoord=attrTexCoord;\n\n\n   gl_Position = projMatrix * mvMatrix * pos;\n}\n",};
const
    render=op.inTrigger('render'),
    centerInCanvas=op.inValueBool("Center in Canvas"),
    flipY=op.inValueBool("Flip Y"),
    inTexture=op.inTexture("Texture"),
    trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
var mesh=null;
var geom=new CGL.Geometry("fullscreen rectangle");
var x=0,y=0,z=0,w=0,h=0;

centerInCanvas.onChange=rebuild;
flipY.onChange=rebuild;

var shader=null;
render.onTriggered=doRender;

inTexture.onChange=function()
{
    var tex=inTexture.get();
    // shader=null;
    if(tex && !shader)
    {
        shader=new CGL.Shader(cgl,'fullscreenrectangle');
        shader.setModules(['MODULE_VERTEX_POSITION','MODULE_COLOR','MODULE_BEGIN_FRAG']);

        shader.setSource(attachments.shader_vert,attachments.shader_frag);
        shader.fullscreenRectUniform=new CGL.Uniform(shader,'t','tex',0);
    }

    if(!tex)
    {
        shader=null;
    }
};

op.preRender=function()
{
    if(shader)shader.bind();
    if(mesh)mesh.render(shader);
    doRender();
};

function doRender()
{
    if( cgl.getViewPort()[2]!=w || cgl.getViewPort()[3]!=h ) rebuild();

    cgl.pushPMatrix();
    mat4.identity(cgl.pMatrix);
    mat4.ortho(cgl.pMatrix, 0, w,h, 0, -10.0, 1000);

    cgl.pushModelMatrix();
    mat4.identity(cgl.mMatrix);

    cgl.pushViewMatrix();
    mat4.identity(cgl.vMatrix);

    if(centerInCanvas.get())
    {
        var x=0;
        var y=0;
        if(w<cgl.canvasWidth) x=(cgl.canvasWidth-w)/2;
        if(h<cgl.canvasHeight) y=(cgl.canvasHeight-h)/2;

        cgl.setViewPort(x,y,w,h);
    }

    if(shader)
    {
        if(inTexture.get())
        {
            cgl.setTexture(0,inTexture.get().tex);
            // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, inTexture.get().tex);
        }

        mesh.render(shader);
    }
    else
    {
        mesh.render(cgl.getShader());
    }

    cgl.gl.clear(cgl.gl.DEPTH_BUFFER_BIT);

    cgl.popPMatrix();
    cgl.popModelMatrix();
    cgl.popViewMatrix();

    trigger.trigger();
}


function rebuild()
{
    const currentViewPort=cgl.getViewPort();
    if(currentViewPort[2]==w && currentViewPort[3]==h)return;

    var xx=0,xy=0;

    w=currentViewPort[2];
    h=currentViewPort[3];

    geom.vertices = new Float32Array([
         xx+w, xy+h,  0.0,
         xx,   xy+h,  0.0,
         xx+w, xy,    0.0,
         xx,   xy,    0.0
    ]);

    if(flipY.get())
        geom.setTexCoords( new Float32Array([
             1.0, 0.0,
             0.0, 0.0,
             1.0, 1.0,
             0.0, 1.0
        ]));
    else
        geom.setTexCoords(new Float32Array([
             1.0, 1.0,
             0.0, 1.0,
             1.0, 0.0,
             0.0, 0.0
        ]));

    geom.verticesIndices = new Float32Array([
        0, 1, 2,
        3, 1, 2
    ]);


    if(!mesh) mesh=new CGL.Mesh(cgl,geom);
        else mesh.setGeom(geom);
}


};

Ops.Gl.Meshes.FullscreenRectangle.prototype = new CABLES.Op();
CABLES.OPS["255bd15b-cc91-4a12-9b4e-53c710cbb282"]={f:Ops.Gl.Meshes.FullscreenRectangle,objName:"Ops.Gl.Meshes.FullscreenRectangle"};




// **************************************************************
// 
// Ops.Gl.Textures.Text
// 
// **************************************************************

Ops.Gl.Textures.Text = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var text=op.addInPort(new CABLES.Port(op,"text",CABLES.OP_PORT_TYPE_VALUE,{type:'string',display:'editor'}));
var inFontSize=op.addInPort(new CABLES.Port(op,"fontSize"));
var maximize=op.addInPort(new CABLES.Port(op,"Maximize Size",CABLES.OP_PORT_TYPE_VALUE,{display:'bool'}));
var texWidth=op.addInPort(new CABLES.Port(op,"texture width"));
var texHeight=op.addInPort(new CABLES.Port(op,"texture height"));
var align=op.addInPort(new CABLES.Port(op,"align",CABLES.OP_PORT_TYPE_VALUE,{display:'dropdown',values:['left','center','right']}));
var valign=op.addInPort(new CABLES.Port(op,"vertical align",CABLES.OP_PORT_TYPE_VALUE,{display:'dropdown',values:['top','center','bottom']}));
var font=op.addInPort(new CABLES.Port(op,"font",CABLES.OP_PORT_TYPE_VALUE,{type:'string'}));
var lineDistance=op.addInPort(new CABLES.Port(op,"line distance"));
var border=op.addInPort(new CABLES.Port(op,"border"));
var doRefresh=op.inTriggerButton("Refresh");

var cachetexture=op.inValueBool("Reuse Texture",true);

// var textureOut=op.addOutPort(new CABLES.Port(op,"texture",CABLES.OP_PORT_TYPE_TEXTURE));
var textureOut=op.outTexture("texture");
var outRatio=op.addOutPort(new CABLES.Port(op,"Ratio",CABLES.OP_PORT_TYPE_VALUE));
textureOut.ignoreValueSerialize=true;

var cgl=op.patch.cgl;

doRefresh.onTriggered=refresh;

border.set(0);
texWidth.set(512);
texHeight.set(512);
lineDistance.set(1);
inFontSize.set(30);
font.set('Arial');
align.set('center');
valign.set('center');

var fontImage = document.createElement('canvas');
fontImage.id = "texturetext_"+CABLES.generateUUID();
fontImage.style.display = "none";
var body = document.getElementsByTagName("body")[0];
body.appendChild(fontImage);



var ctx = fontImage.getContext('2d');


function reSize()
{
    textureOut.get().setSize(texWidth.get(),texHeight.get());

    ctx.canvas.width=fontImage.width=texWidth.get();
    ctx.canvas.height=fontImage.height=texHeight.get();
    refresh();
}

function refresh()
{
    ctx.clearRect(0,0,fontImage.width,fontImage.height);
    ctx.fillStyle = 'white';
    var fontSize=parseFloat(inFontSize.get());
    var fontname=font.get();
    if(fontname.indexOf(" ")>-1)fontname='"'+fontname+'"';
    ctx.font = fontSize+'px '+fontname+'';
    ctx.textAlign = align.get();

    if(border.get()>0)
    {
        ctx.beginPath();
        ctx.lineWidth=""+border.get();
        ctx.strokeStyle="white";
        ctx.rect(
            0,
            0,
            texWidth.get(),
            texHeight.get()
            );
        ctx.stroke();
    }

    var i=0;

    // if(text.get())
    {
        var txt=(text.get()+'').replace(/<br\/>/g, '\n');
        var txt=(text.get()+'').replace(/<br>/g, '\n');

        var strings = txt.split("\n");


        var posy=0,i=0;

        if(maximize.get())
        {
            fontSize=texWidth.get();
            var count=0;
            var maxWidth=0;
            var maxHeight=0;

            do
            {
                count++;
                if(count>300)break;
                fontSize-=10;
                ctx.font = fontSize+'px "'+font.get()+'"';
                maxWidth=0;
                maxHeight=strings.length*fontSize*1.1;
                for(i=0;i<strings.length;i++)
                {
                    maxWidth=Math.max(maxWidth,ctx.measureText(strings[i]).width);
                }
            }
            while(maxWidth>ctx.canvas.width || maxHeight>ctx.canvas.height);
        }

        if(valign.get()=='center')
        {
            var maxy=(strings.length-1.5)*fontSize+parseFloat(lineDistance.get());
            posy=ctx.canvas.height / 2-maxy/2;
        }
        else if(valign.get()=='top') posy=fontSize;
        else if(valign.get()=='bottom')  posy=ctx.canvas.height -(strings.length)*(parseFloat(inFontSize.get())+parseFloat(lineDistance.get()));

        for(i=0;i<strings.length;i++)
        {
            if(align.get()=='center') ctx.fillText(strings[i], ctx.canvas.width / 2, posy);
            if(align.get()=='left') ctx.fillText(strings[i], 0, posy);
            if(align.get()=='right') ctx.fillText(strings[i], ctx.canvas.width, posy);
            posy+=fontSize+parseFloat(lineDistance.get());
        }
    }

    ctx.restore();
    outRatio.set(ctx.canvas.height/ctx.canvas.width);


    if(!cachetexture.get() || !textureOut.get()) textureOut.set(new CGL.Texture.createFromImage( cgl, fontImage, { filter:CGL.Texture.FILTER_MIPMAP } ));
        else textureOut.get().initTexture(fontImage,CGL.Texture.FILTER_MIPMAP);

    textureOut.get().unpackAlpha=true;
}

align.onChange=refresh;
valign.onChange=refresh;
text.onChange=refresh;
inFontSize.onChange=refresh;
font.onChange=refresh;
lineDistance.onChange=refresh;
maximize.onChange=refresh;

texWidth.onChange=reSize;
texHeight.onChange=reSize;

border.onChange=refresh;

text.set('cables');
reSize();

};

Ops.Gl.Textures.Text.prototype = new CABLES.Op();
CABLES.OPS["84a1d08e-c0c7-4f73-9e15-06dd86e854d3"]={f:Ops.Gl.Textures.Text,objName:"Ops.Gl.Textures.Text"};




// **************************************************************
// 
// Ops.Anim.Timer2
// 
// **************************************************************

Ops.Anim.Timer2 = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const playPause=op.inValueBool("Play",true);
const reset=op.inTriggerButton("Reset");
const outTime=op.outValue("Time");
const inSpeed=op.inValue("Speed",1);

var timer=new CABLES.Timer();
var lastTime=0;
var time=0;

playPause.onChange=setState;
setState();

function setState()
{
    if(playPause.get())
    {
        timer.play();
        op.patch.addOnAnimFrame(op);
    }
    else
    {
        timer.pause();
        op.patch.removeOnAnimFrame(op);
    }
}

reset.onTriggered=function()
{
    time=0;
    lastTime=0;
    timer.setTime(0);
    outTime.set(0);
};

op.onAnimFrame=function()
{
    if(timer.isPlaying())
    {
        timer.update();
        if(lastTime===0)
        {
            lastTime=timer.get();
            return;
        }

        const t=timer.get()-lastTime;
        lastTime=timer.get();
        time+=t*inSpeed.get();
        if(time!=time)time=0;
        outTime.set(time);
    }
};


};

Ops.Anim.Timer2.prototype = new CABLES.Op();
CABLES.OPS["aac7f721-208f-411a-adb3-79adae2e471a"]={f:Ops.Anim.Timer2,objName:"Ops.Anim.Timer2"};




// **************************************************************
// 
// Ops.Math.Compare.Greater
// 
// **************************************************************

Ops.Math.Compare.Greater = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const result=op.outValue("result");
var number1=op.addInPort(new CABLES.Port(op,"number1"));
var number2=op.addInPort(new CABLES.Port(op,"number2"));

number1.onChange=exec;
number2.onChange=exec;

function exec()
{
    result.set(number1.get()>number2.get());
}



};

Ops.Math.Compare.Greater.prototype = new CABLES.Op();
CABLES.OPS["b250d606-f7f8-44d3-b099-c29efff2608a"]={f:Ops.Math.Compare.Greater,objName:"Ops.Math.Compare.Greater"};




// **************************************************************
// 
// Ops.Boolean.TriggerChangedTrue
// 
// **************************************************************

Ops.Boolean.TriggerChangedTrue = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var val=op.inValueBool("Value",false);

var next=op.outTrigger("Next");

var oldVal=0;

val.onChange=function()
{
    var newVal=val.get();
    if(!oldVal && newVal)
    {
        oldVal=true;
        next.trigger();
    }
    else
    {
        oldVal=false;
    }
};

};

Ops.Boolean.TriggerChangedTrue.prototype = new CABLES.Op();
CABLES.OPS["385197e1-8b34-4d1c-897f-d1386d99e3b3"]={f:Ops.Boolean.TriggerChangedTrue,objName:"Ops.Boolean.TriggerChangedTrue"};




// **************************************************************
// 
// Ops.Math.Incrementor
// 
// **************************************************************

Ops.Math.Incrementor = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var increment = op.inTriggerButton("Increment");
var decrement = op.inTriggerButton("Decrement");
var inLength=op.addInPort(new CABLES.Port(op,"Length",CABLES.OP_PORT_TYPE_VALUE));
// var reset=op.addInPort(new CABLES.Port(op,"Reset",CABLES.OP_PORT_TYPE_FUNCTION));
var reset=op.inTriggerButton("Reset");


var inMode=op.inValueSelect("Mode",["Rewind","Stop at Max"]);

var value=op.addOutPort(new CABLES.Port(op,"Value",CABLES.OP_PORT_TYPE_VALUE));

var outRestarted=op.outTrigger("Restarted");

value.ignoreValueSerialize=true;
inLength.set(10);
var val=0;
value.set(0);

inLength.onTriggered=reset;
reset.onTriggered=doReset;

var MODE_REWIND=0;
var MODE_STOP=1;

var mode=MODE_REWIND;

inMode.onChange=function()
{
    if(inMode.get()=="Rewind")
    {
        mode=MODE_REWIND;
    }
    if(inMode.get()=="Stop at Max")
    {
        mode=MODE_STOP;
    }

    
};

function doReset()
{
    value.set(null);
    val=0;
    value.set(val);
    outRestarted.trigger();
}

decrement.onTriggered=function()
{
    val--;
    if(mode==MODE_REWIND && val<0)val=inLength.get()-1;
    if(mode==MODE_STOP && val<0)val=0;

    value.set(val);
};

increment.onTriggered=function()
{
    val++;
    if(mode==MODE_REWIND && val>=inLength.get())
    {
        val=0;
        outRestarted.trigger();
    }
    if(mode==MODE_STOP && val>=inLength.get())val=inLength.get()-1;
    
    value.set(val);
};


};

Ops.Math.Incrementor.prototype = new CABLES.Op();
CABLES.OPS["45cc0011-ada8-4423-8f5b-39a3810b8389"]={f:Ops.Math.Incrementor,objName:"Ops.Math.Incrementor"};




// **************************************************************
// 
// Ops.Vars.Variable
// 
// **************************************************************

Ops.Vars.Variable = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
op.varName=op.inValueSelect("Variable");
var val=op.outValue("Value");

var variable=null;
op.patch.addVariableListener(init);
init();

updateVarNamesDropdown();

function updateVarNamesDropdown()
{
    if(CABLES.UI)
    {
        var varnames=[];
        var vars=op.patch.getVars();

        for(var i in vars) varnames.push(i);

        varnames.push('+ create new one');
        op.varName.uiAttribs.values=varnames;
    }
}

op.varName.onChange=function()
{
    init();
};

function init()
{
    updateVarNamesDropdown();

    if(CABLES.UI)
    {
        if(op.varName.get()=='+ create new one')
        {
            CABLES.CMD.PATCH.createVariable(op);
            return;
        }
    }

    if(variable)
    {
        variable.removeListener(onChange);
    }

    variable=op.patch.getVar(op.varName.get());

    if(variable)
    {
        variable.addListener(onChange);
        op.uiAttr({error:null,});
        op.setTitle('#'+op.varName.get());
        onChange(variable.getValue());
        // console.log("var value ",variable.getName(),variable.getValue());
    }
    else
    {
        op.uiAttr({error:"unknown variable! - there is no setVariable with this name"});
        op.setTitle('#invalid');
    }
}


function onChange(v)
{
    updateVarNamesDropdown();
    val.set(v);
}

op.onDelete=function()
{
    if(variable)
        variable.removeListener(onChange);
};


};

Ops.Vars.Variable.prototype = new CABLES.Op();





// **************************************************************
// 
// Ops.Vars.SetVariableString
// 
// **************************************************************

Ops.Vars.SetVariableString = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var val=op.inValueString("Value");
op.varName=op.inValueSelect("Variable");

op.varName.onChange=updateName;
val.onChange=update;

op.patch.addVariableListener(updateVarNamesDropdown);

updateVarNamesDropdown();

function updateVarNamesDropdown()
{
    if(CABLES.UI)
    {
        var varnames=[];
        var vars=op.patch.getVars();

        for(var i in vars) varnames.push(i);

        varnames.push('+ create new one');
        op.varName.uiAttribs.values=varnames;
    }
}

function updateName()
{
    if(CABLES.UI)
    {
        if(op.varName.get()=='+ create new one')
        {
            CABLES.CMD.PATCH.createVariable(op);
            return;
        }

        op.setTitle('#'+op.varName.get());
    }
    update();
}

function update()
{
    op.patch.setVarValue(op.varName.get(),val.get());
}


};

Ops.Vars.SetVariableString.prototype = new CABLES.Op();
CABLES.OPS["10abadc9-adb7-400e-872a-40c6e0763c61"]={f:Ops.Vars.SetVariableString,objName:"Ops.Vars.SetVariableString"};




// **************************************************************
// 
// Ops.Vars.SetVariable
// 
// **************************************************************

Ops.Vars.SetVariable = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var val=op.inValue("Value");
op.varName=op.inValueSelect("Variable");

op.varName.onChange=updateName;
val.onChange=update;
val.changeAlways=true;
val.set(false);

op.patch.addVariableListener(updateVarNamesDropdown);

updateVarNamesDropdown();

function updateVarNamesDropdown()
{
    if(CABLES.UI)
    {
        var varnames=[];
        var vars=op.patch.getVars();
        varnames.push('+ create new one');
        for(var i in vars) varnames.push(i);
        op.varName.uiAttribs.values=varnames;
    }
}

function updateName()
{
    if(CABLES.UI)
    {
        if(op.varName.get()=='+ create new one')
        {
            CABLES.CMD.PATCH.createVariable(op);
            return;
        }

        op.setTitle('#' + op.varName.get());
    }
    update();
}

function update()
{
    op.patch.setVarValue(op.varName.get(),val.get());
}


};

Ops.Vars.SetVariable.prototype = new CABLES.Op();
CABLES.OPS["b0190d08-82f6-45b2-bc0c-b70a3257ea92"]={f:Ops.Vars.SetVariable,objName:"Ops.Vars.SetVariable"};




// **************************************************************
// 
// Ops.Ui.Comment
// 
// **************************************************************

Ops.Ui.Comment = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
op.inTitle=op.inValueString("title",' ');
op.text=op.inValueText("text");

op.text.set(' ');
op.name=' ';

op.inTitle.set('new comment');

op.inTitle.onChange=update;
op.text.onChange=update;
op.onLoaded=update;


update();

function updateUI()
{
    if(CABLES.UI)
    {
        var uiOp=gui.patch().getUiOp(op);
        if(!uiOp)return;

        setTimeout(function()
        {
            op.name=op.inTitle.get();
            uiOp.oprect.updateComment();
        },30);

    }
}


function update()
{
    if(CABLES.UI)
    {

        op.uiAttr('title',op.inTitle.get());
        op.name=op.inTitle.get();

        updateUI();
    }
}




};

Ops.Ui.Comment.prototype = new CABLES.Op();
CABLES.OPS["9de0c04f-666b-47cd-9722-a8cf36ab4720"]={f:Ops.Ui.Comment,objName:"Ops.Ui.Comment"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.BrightnessContrast
// 
// **************************************************************

Ops.Gl.TextureEffects.BrightnessContrast = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={brightness_contrast_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float amountbright;\n\nvoid main()\n{\n    vec4 col=vec4(1.0,0.0,0.0,1.0);\n    col=texture(tex,texCoord);\n\n    // apply contrast\n    col.rgb = ((col.rgb - 0.5) * max(amount*2.0, 0.0))+0.5;\n\n    // apply brightness\n    col.rgb *= amountbright*2.0;\n\n    outColor = col;\n}",};
var render=op.inTrigger("render");
var amount=op.inValueSlider('contrast',0.5);
var amountBright=op.inValueSlider('brightness',0.5);

var trigger=op.outTrigger('trigger');
var cgl=op.patch.cgl;

var shader=new CGL.Shader(cgl);
shader.setSource(shader.getDefaultVertexShader(),attachments.brightness_contrast_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var amountUniform=new CGL.Uniform(shader,'f','amount',amount);
var amountBrightUniform=new CGL.Uniform(shader,'f','amountbright',amountBright);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    if(!cgl.currentTextureEffect.getCurrentSourceTexture()) return;
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;
    
    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};

};

Ops.Gl.TextureEffects.BrightnessContrast.prototype = new CABLES.Op();
CABLES.OPS["54b89199-c594-4dff-bc48-82d6c7a55e8a"]={f:Ops.Gl.TextureEffects.BrightnessContrast,objName:"Ops.Gl.TextureEffects.BrightnessContrast"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.PixelNoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.PixelNoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={pixelnoise_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\nUNI float numX;\nUNI float numY;\nUNI float addX;\nUNI float addY;\nUNI float addZ;\n\nfloat random(vec2 co)\n{\n   return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * (437511.5453+addZ));\n}\n\n{{BLENDCODE}}\n\nvoid main()\n{\n    vec2 seed=vec2(floor( texCoord.x*numX+addX),floor( texCoord.y*numY+addY));\n    float r,g,b;\n\n    #ifndef RGB\n        r=g=b=random( seed );\n    #endif\n\n    #ifdef RGB\n        r=random( seed+0.5711 );\n        g=random( seed+0.5712 );\n        b=random( seed+0.5713 );\n    #endif\n\n    vec4 rnd=vec4( r,g,b,1.0 );\n    vec4 base=texture(tex,texCoord);\n\n    vec4 col=vec4( _blend(base.rgb,rnd.rgb) ,1.0);\n    col=vec4( mix( col.rgb, base.rgb ,1.0-base.a*amount),1.0);\n\n    outColor= col;\n}",};
const render=op.addInPort(new CABLES.Port(op,"Render",CABLES.OP_PORT_TYPE_FUNCTION));
const blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
const amount=op.inValueSlider("Amount",1);
const numX=op.inValue("Num X",10);
const numY=op.inValue("Num Y",10);
const addX=op.inValue("X",0);
const addY=op.inValue("Y",0);
const addZ=op.inValue("Z",0);
const inRGB=op.inValueBool("RGB",false);

const trigger=op.addOutPort(new CABLES.Port(op,"Next",CABLES.OP_PORT_TYPE_FUNCTION));

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

const amountUniform=new CGL.Uniform(shader,'f','amount',amount);
const timeUniform=new CGL.Uniform(shader,'f','time',1.0);
const textureUniform=new CGL.Uniform(shader,'t','tex',0);

const srcFrag=attachments.pixelnoise_frag.replace('{{BLENDCODE}}',CGL.TextureEffect.getBlendCode());
shader.setSource(shader.getDefaultVertexShader(),srcFrag);

numX.uniform==new CGL.Uniform(shader,'f','numX',numX);
numY.uniform==new CGL.Uniform(shader,'f','numY',numY);
addX.uniform==new CGL.Uniform(shader,'f','addX',addX);
addY.uniform==new CGL.Uniform(shader,'f','addY',addY);
addZ.uniform==new CGL.Uniform(shader,'f','addZ',addZ);

inRGB.onChange=function()
{
    if(inRGB.get())shader.define("RGB");
    else shader.removeDefine("RGB");
};

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};



};

Ops.Gl.TextureEffects.Noise.PixelNoise.prototype = new CABLES.Op();
CABLES.OPS["7fa95a3b-9ba2-4b5b-aee9-819bbde70bab"]={f:Ops.Gl.TextureEffects.Noise.PixelNoise,objName:"Ops.Gl.TextureEffects.Noise.PixelNoise"};




// **************************************************************
// 
// Ops.Trigger.SwitchTrigger
// 
// **************************************************************

Ops.Trigger.SwitchTrigger = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
// constants
var NUM_PORTS = 10;

// inputs
var exePort = op.inTriggerButton('Execute');
var switchPort = op.inValue('Switch Value');

// outputs
var nextTriggerPort = op.outTrigger('Next Trigger');
var valueOutPort = op.outValue('Switched Value');
var triggerPorts = [];
for(var j=0; j<NUM_PORTS; j++) {
    triggerPorts[j] = op.outTrigger('Trigger ' + j);
}
var defaultTriggerPort = op.outTrigger('Default Trigger');

// functions

/**
 * Performs the switch case
 */
function update() {
    var index = Math.round(switchPort.get());
    if(index >= 0 && index < NUM_PORTS) {
        valueOutPort.set(index);    
        triggerPorts[index].trigger();
    } else {
        valueOutPort.set(-1);    
        defaultTriggerPort.trigger();   
    }
    nextTriggerPort.trigger();
}

// change listeners / trigger events
exePort.onTriggered = update;

};

Ops.Trigger.SwitchTrigger.prototype = new CABLES.Op();
CABLES.OPS["44ceb5d8-b040-4722-b189-a6fb8172517d"]={f:Ops.Trigger.SwitchTrigger,objName:"Ops.Trigger.SwitchTrigger"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Plasma
// 
// **************************************************************

Ops.Gl.TextureEffects.Plasma = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={plasma_frag:"#define PI 3.1415926535897932384626433832795\n\nUNI float time;\nUNI float w;\nUNI float h;\nUNI float mul;\nUNI float amount;\nUNI sampler2D tex;\n\nIN vec2 texCoord;\n\n{{BLENDCODE}}\n\nvoid main() {\n   vec2 size=vec2(w,h);\n    float v = 0.0;\n    vec2 c = texCoord * size - size/2.0;\n    v += sin((c.x+time));\n    v += sin((c.y+time)/2.0);\n    v += sin((c.x+c.y+time)/2.0);\n    c += size/2.0 * vec2(sin(time/3.0), cos(time/2.0));\n    v += sin(sqrt(c.x*c.x+c.y*c.y+1.0)+time);\n    v = v/2.0;\n    vec3 newColor = vec3(sin(PI*v*mul/4.0), sin(PI*v*mul), cos(PI*v*mul))*.5 + .5;\n\n   vec4 base=texture(tex,texCoord);\n\n   #ifndef GREY\n       vec4 col=vec4( _blend(base.rgb,newColor) ,1.0);\n   #endif\n   #ifdef GREY\n    // .endl()+'       vec4 col=vec4( _blend(base.rgb,vec3((newColor.r+newColor.g+newColor.b)/3.0)) ,1.0);'\n           vec4 col=vec4( _blend(base.rgb,vec3(newColor.g)) ,1.0);\n   #endif\n\n   col=vec4( mix( col.rgb, base.rgb ,1.0-base.a*amount),1.0);\n\n    outColor= col;\n}",};
const render=op.inTrigger('render');
const blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
const amount=op.inValueSlider("Amount",1);
const x=op.inValue("Width",20);
const y=op.inValue("Height",20);
const mul=op.inValue("Mul",1);
const time=op.inValue("Time",1);
const greyscale=op.inValueBool("Greyscale",true);
const trigger=op.outTrigger('trigger');

const srcFrag=attachments.plasma_frag.replace('{{BLENDCODE}}',CGL.TextureEffect.getBlendCode());

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);

shader.setSource(shader.getDefaultVertexShader(),srcFrag);
shader.define('GREY');

const uniX=new CGL.Uniform(shader,'f','w',x);
const uniY=new CGL.Uniform(shader,'f','h',y);
const uniTime=new CGL.Uniform(shader,'f','time',time);
const uniMul=new CGL.Uniform(shader,'f','mul',mul);

const textureUniform=new CGL.Uniform(shader,'t','tex',0);
const amountUniform=new CGL.Uniform(shader,'f','amount',amount);

greyscale.onChange=function()
{
    if(greyscale.get())shader.define('GREY');
        else shader.removeDefine('GREY');
};

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Plasma.prototype = new CABLES.Op();
CABLES.OPS["6c82c11d-1931-43b1-8e6c-5d20cb1a0d87"]={f:Ops.Gl.TextureEffects.Plasma,objName:"Ops.Gl.TextureEffects.Plasma"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Gradient
// 
// **************************************************************

Ops.Gl.TextureEffects.Gradient = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={gradient_frag:"IN vec2 texCoord;\nUNI float amount;\nUNI float pos;\nUNI float width;\n\nUNI vec3 colA;\nUNI vec3 colB;\nUNI vec3 colC;\nUNI sampler2D tex;\n\n{{BLENDCODE}}\n\nvoid main()\n{\n    vec4 base=texture(tex,texCoord);\n    vec4 col;\n    float ax=texCoord.x;\n\n    #ifdef GRAD_Y\n        ax=texCoord.y;\n    #endif\n    #ifdef GRAD_XY\n        ax=(texCoord.x+texCoord.y)/2.0;\n    #endif\n    #ifdef GRAD_RADIAL\n        ax=distance(texCoord,vec2(0.5,0.5))*2.0;\n    #endif\n\n    ax=((ax-0.5)*width)+0.5;\n\n    #ifndef GRAD_SMOOTHSTEP\n        if(ax<=pos) col = vec4(mix(colA, colB, ax*1.0/pos),1.0);\n            else col = vec4(mix(colB, colC, min(1.0,(ax-pos)*1.0/(1.0-pos))),1.0);\n    #endif\n\n    #ifdef GRAD_SMOOTHSTEP\n        if(ax<=pos) col = vec4(mix(colA, colB, smoothstep(0.0,1.0,ax*1.0/pos)),1.0);\n            else col = vec4(mix(colB, colC, smoothstep(0.0,1.0,min(1.0,(ax-pos)*1.0/(1.0-pos)))),1.0);\n    #endif\n\n   col=vec4( _blend(base.rgb,col.rgb) ,1.0);\n   col=vec4( mix( col.rgb, base.rgb ,1.0-base.a*amount),1.0);\n\n   outColor=col;\n}",};
const render=op.inTrigger("Render");
const blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
const amount=op.inValueSlider("Amount",1);
const width=op.inValue("Width",1);
const gType=op.inValueSelect("Type",['X','Y','XY','Radial'],"X");
const pos1=op.inValueSlider("Pos",0.5);
const smoothStep=op.inValueBool("Smoothstep",true);

const r = op.inValueSlider("r", Math.random());
const g = op.inValueSlider("g", Math.random());
const b = op.inValueSlider("b", Math.random());
r.setUiAttribs({ colorPick: true });

const r2 = op.inValueSlider("r2", Math.random());
const g2 = op.inValueSlider("g2", Math.random());
const b2 = op.inValueSlider("b2", Math.random());
r2.setUiAttribs({ colorPick: true });

const r3 = op.inValueSlider("r3", Math.random());
const g3 = op.inValueSlider("g3", Math.random());
const b3 = op.inValueSlider("b3", Math.random());
r3.setUiAttribs({ colorPick: true });

smoothStep.onChange=updateSmoothstep;

op.setPortGroup('Blending',[blendMode,amount]);
op.setPortGroup('Color A',[r,g,b]);
op.setPortGroup('Color B',[r2,g2,b2]);
op.setPortGroup('Color C',[r3,g3,b3]);

const randomize=op.inTriggerButton("Randomize");
var next=op.outTrigger("Next");

var cgl=op.patch.cgl;
var shader=new CGL.Shader(cgl);
var srcFrag=attachments.gradient_frag.replace('{{BLENDCODE}}',CGL.TextureEffect.getBlendCode());
shader.setSource(shader.getDefaultVertexShader(),srcFrag );
var amountUniform=new CGL.Uniform(shader,'f','amount',amount);
var uniPos=new CGL.Uniform(shader,'f','pos',pos1);
var uniWidth=new CGL.Uniform(shader,'f','width',width);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);
var r3uniform,r2uniform,runiform;

r2.onChange=g2.onChange=b2.onChange=updateCol2;
r3.onChange=g3.onChange=b3.onChange=updateCol3;
r.onChange=g.onChange=b.onChange=updateCol;

updateCol();
updateCol2();
updateCol3();
updateSmoothstep();

function updateSmoothstep()
{
    if(smoothStep.get()) shader.define('GRAD_SMOOTHSTEP');
        else shader.removeDefine('GRAD_SMOOTHSTEP');
}

gType.onChange=function()
{
    shader.removeDefine('GRAD_X');
    shader.removeDefine('GRAD_Y');
    shader.removeDefine('GRAD_XY');
    shader.removeDefine('GRAD_RADIAL');

    if(gType.get()=='XY') shader.define('GRAD_XY');
    if(gType.get()=='X') shader.define('GRAD_X');
    if(gType.get()=='Y') shader.define('GRAD_Y');
    if(gType.get()=='Radial')shader.define('GRAD_RADIAL');
};

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

randomize.onTriggered=function()
{
    r.set(Math.random());
    g.set(Math.random());
    b.set(Math.random());

    r2.set(Math.random());
    g2.set(Math.random());
    b2.set(Math.random());

    r3.set(Math.random());
    g3.set(Math.random());
    b3.set(Math.random());
};

function updateCol()
{
    var colA=[r.get(),g.get(),b.get()];
    if(!runiform) runiform=new CGL.Uniform(shader,'3f','colA',colA);
        else runiform.setValue(colA);
}

function updateCol2()
{
    var colB=[r2.get(),g2.get(),b2.get()];
    if(!r2uniform) r2uniform=new CGL.Uniform(shader,'3f','colB',colB);
        else r2uniform.setValue(colB);
}

function updateCol3()
{
    var colC=[r3.get(),g3.get(),b3.get()];
    if(!r3uniform) r3uniform=new CGL.Uniform(shader,'3f','colC',colC);
        else r3uniform.setValue(colC);
}

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();
    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );
    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    next.trigger();
};


};

Ops.Gl.TextureEffects.Gradient.prototype = new CABLES.Op();
CABLES.OPS["5ada9bd8-227a-4a1f-87ad-0f879c7aa84d"]={f:Ops.Gl.TextureEffects.Gradient,objName:"Ops.Gl.TextureEffects.Gradient"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Waveform
// 
// **************************************************************

Ops.Gl.TextureEffects.Waveform = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={wave_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI sampler2D tex1;\nUNI float amount;\n\nUNI float r;\nUNI float g;\nUNI float b;\n\nUNI float uAmp;\nUNI float uFreq;\nUNI float uWidth;\nUNI float uGlow;\nUNI float uWaveSelect;\nUNI bool uInvert;\nUNI bool uSolid;\n\nUNI float uOffSetX;\nUNI float uOffSetY;\nUNI float uRotate;\n\n\n{{BLENDCODE}}\n\n#define PI 3.14159265359\n#define TAU (2.0*PI)\n\nfloat vmax(vec2 v)\n{\n\treturn max(v.x, v.y);\n}\n\nvoid pR(inout vec2 p, float a)\n{\n    float s = sin(a),c=cos(a); p *= mat2(c,s,-s,c);\n}\n\nfloat pMod1(inout float p, float size)\n{\n\tfloat halfsize = size * 0.5;\n\tfloat c = floor((p + halfsize) / size);\n\tp = mod(p + halfsize, size) - halfsize;\n\treturn c;\n}\n\nfloat pModMirror1(inout float p, float size)\n{\n\tfloat halfsize = size * 0.5;\n\tfloat c = floor((p + halfsize) / size);\n\tp = mod(p + halfsize,size) - halfsize;\n\tp *= mod(c, 2.0) * 2.0 - 1.0;\n\treturn c;\n}\n\nfloat fCapsule2D(vec2 p, float r, float c)\n{\n\treturn mix(abs(p.x) - r, length(vec2(p.x, abs(p.y) - c)) - r, step(c, abs(p.y)));\n}\n\nfloat SineWave(vec2 p, float amplitude, float frequency, float line_width, float line_glow, bool solid)\n{\n    float v = sin(p.x * frequency * PI);\n    v *= amplitude;\n\n    float d = 0.0;\n\n    if (solid == false)\n    {\n        d = abs(v * amplitude - p.y * 0.5);\n        d -= line_width;\n        return smoothstep(0.0, line_glow, d);\n    }\n    else\n    {\n        d = v * amplitude - p.y * 0.5;\n        d -= -line_width;\n        return smoothstep(0.0, line_glow, -d);\n    }\n}\n\nfloat SawWave(vec2 p, float amplitude, float frequency, float line_width, float line_glow, bool solid)\n{\n    float inverse_frequency = 2.0 / frequency;\n    vec2 p1 = p;\n    pMod1(p1.x, inverse_frequency);\n\n    float d1 = fCapsule2D(p1, 0.0, amplitude);\n    p.x += inverse_frequency * 0.5;\n    pMod1(p.x, inverse_frequency);\n    pR(p, atan(inverse_frequency, amplitude * 2.0));\n\n    float d = fCapsule2D(p, 0.0, 0.5 * length(vec2(inverse_frequency, 2.0 * amplitude)));\n\td = min(d, d1);\n    d -= line_width;\n\n    if(solid == false)\n    {\n        return smoothstep(0.0, line_glow, d);\n    }\n    else\n        return smoothstep(0.0, line_glow, min(d,p.x));\n}\n\nfloat TriangleWave(vec2 p, float amplitude, float frequency, float line_width, float line_glow, bool solid)\n{\n    float inverse_frequency = 1.0 / frequency;\n    p.x -= inverse_frequency;\n    pModMirror1(p.x, inverse_frequency);\n    pR(p, atan(inverse_frequency, amplitude * 2.0));\n\n    float d = fCapsule2D(p, 0.0, 0.5 * length(vec2(inverse_frequency, 2.0 * amplitude)));\n    d -= line_width;\n\n    if (solid == false)\n    {\n        return smoothstep(0.0, line_glow, d);\n    }\n    else\n        return smoothstep(0.0, line_glow, min(d,p.x));\n}\n\nfloat SquareWave(vec2 p, float amplitude, float frequency, float line_width, float line_glow, bool solid)\n{\n    float inverse_frequency = 0.5 / frequency;\n    vec2 p1 = p;\n    pMod1(p1.x, 2.0 * inverse_frequency);\n\n    float d1 = fCapsule2D(p1, 0.0, abs(amplitude));\n    p.x -= inverse_frequency * 0.5;\n    float cell = pMod1(p.x, inverse_frequency);\n\n    if(cell < 0.0) cell = -cell + 1.0;\n    if(int(cell * 0.5) % 2 == 1) p.y -= amplitude;\n        else p.y += amplitude;\n\n    float d = fCapsule2D(p.yx, 0.0, abs(inverse_frequency));\n    d = min(d, d1);\n    d -= line_width;\n\n    if (solid == false)\n    {\n        return smoothstep(0.0, line_glow, d);\n    }\n    else\n        return smoothstep(0.0, line_glow, p.y);\n}\n\nvoid main()\n{\n    vec4 rgb = vec4(r,g,b,1.0);\n\tvec2 uv = texCoord;\n\n    uv -= 0.5;\n    pR(uv.xy,uRotate * TAU);\n    uv += 0.5;\n\n    // uv.y=0.0;\n\n    float wave = 0.0;\n    if      (uWaveSelect == 0.0)\n    {\n        wave = SineWave     (uv - vec2(uOffSetX,uOffSetY), uAmp,  uFreq , uWidth, uGlow, uSolid);\n    }\n    else if (uWaveSelect == 1.0)\n    {\n        wave = SawWave      (uv - vec2(uOffSetX,uOffSetY), uAmp,  uFreq, uWidth, uGlow, uSolid);\n    }\n    else if (uWaveSelect == 2.0)\n    {\n        wave = TriangleWave (uv - vec2(uOffSetX,uOffSetY), uAmp,  uFreq, uWidth, uGlow, uSolid);\n    }\n    else\n    {\n        wave = SquareWave   (uv - vec2(uOffSetX,uOffSetY), uAmp,  uFreq, uWidth, uGlow, uSolid);\n    }\n    vec4 col = vec4(0.0);\n    if (uInvert )\n    {\n        col = vec4(vec3(wave),1.0);\n    }\n    else\n    {\n        col = vec4(vec3(1.0 - wave),1.0);\n    }\n    col *= rgb;\n\n    vec4 base=texture(tex,texCoord);\n    col=vec4( _blend(base.rgb,col.rgb) ,1.0);\n    col=vec4( mix( col.rgb, base.rgb ,1.0-base.a * amount),1.0);\n    outColor= col;\n}\n",};
const render = op.inTrigger('render');
const blendMode = CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
const amount = op.inValueSlider("Amount",1);
const waveSelect = op.inValueSelect("Waveform",["Sine","Sawtooth","Triangle","Square"],"Sine");

const amplitude = op.inValueSlider("Amplitude",0.5);
const frequency = op.inValue("Frequency",2.0);
const lineWidth = op.inValueSlider("Line Width",0.1);
const lineGlow = op.inValueSlider("Line Glow",0.1);
const invertCol = op.inValueBool("invert color",false);
const solidFill = op.inValueBool("Solid fill",false);
const offsetX = op.inValueSlider("Offset X",0.0);
const offsetY = op.inValueSlider("Offset Y",0.5);
const rotate = op.inValueSlider("Rotate",0.0);

const r = op.inValueSlider("r",1.0);
const g = op.inValueSlider("g",1.0);
const b = op.inValueSlider("b",1.0);

const trigger = op.outTrigger('trigger');

r.setUiAttribs({colorPick:true});


const cgl = op.patch.cgl;
const shader = new CGL.Shader(cgl);

const srcFrag = (attachments.wave_frag||'').replace("{{BLENDCODE}}",CGL.TextureEffect.getBlendCode());
shader.setSource(shader.getDefaultVertexShader(),srcFrag);

const textureUniform = new CGL.Uniform(shader,'t','tex',0);
const amountUniform = new CGL.Uniform(shader,'f','amount',amount);
const uniformR = new CGL.Uniform(shader,'f','r',r);
const uniformG = new CGL.Uniform(shader,'f','g',g);
const uniformB = new CGL.Uniform(shader,'f','b',b);

const amplitudeUniform = new CGL.Uniform(shader,'f','uAmp',amplitude);
const frequencyUniform = new CGL.Uniform(shader,'f','uFreq',frequency);
const lineWidthUniform = new CGL.Uniform(shader,'f','uWidth',lineWidth);
const lineGlowUniform = new CGL.Uniform(shader,'f','uGlow',lineGlow);
const waveSelectUniform = new CGL.Uniform(shader,'f','uWaveSelect',1);
const invertUniform = new CGL.Uniform(shader,'b','uInvert',invertCol);
const solidFillUniform = new CGL.Uniform(shader,'b','uSolid',solidFill);
const offSetXUniform = new CGL.Uniform(shader,'f','uOffSetX',offsetX);
const offSetYUniform = new CGL.Uniform(shader,'f','uOffSetY',offsetY);
const rotateUniform = new CGL.Uniform(shader,'f','uRotate',rotate);

waveSelect.onChange = updateWaveForm;
updateWaveForm();

function updateWaveForm()
{
    if(waveSelect.get() == "Sine") waveSelectUniform.setValue(0);
    else if(waveSelect.get() == "Sawtooth") waveSelectUniform.setValue(1);
    else if(waveSelect.get() == "Triangle") waveSelectUniform.setValue(2);
    else waveSelectUniform.setValue(3);
}

blendMode.onChange = function()
{
    CGL.TextureEffect.onChangeBlendSelect(shader,blendMode.get());
};

render.onTriggered = function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );

    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Waveform.prototype = new CABLES.Op();
CABLES.OPS["1ceabad7-1188-4a8f-b412-ff05adbb1576"]={f:Ops.Gl.TextureEffects.Waveform,objName:"Ops.Gl.TextureEffects.Waveform"};




// **************************************************************
// 
// Ops.Gl.TextureEffects.Noise.CellularNoise
// 
// **************************************************************

Ops.Gl.TextureEffects.Noise.CellularNoise = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={cellularnoise3d_frag:"UNI float z;\nUNI float x;\nUNI float y;\nUNI float scale;\nIN vec2 texCoord;\nUNI sampler2D tex;\nUNI float amount;\n\n{{BLENDCODE}}\n\nvoid FAST32_hash_3D( \tvec3 gridcell,\n                        out vec4 lowz_hash_0,\n                        out vec4 lowz_hash_1,\n                        out vec4 lowz_hash_2,\n                        out vec4 highz_hash_0,\n                        out vec4 highz_hash_1,\n                        out vec4 highz_hash_2\t)\t\t//\tgenerates 3 random numbers for each of the 8 cell corners\n{\n    //    gridcell is assumed to be an integer coordinate\n\n    //\tTODO: \tthese constants need tweaked to find the best possible noise.\n    //\t\t\tprobably requires some kind of brute force computational searching or something....\n    const vec2 OFFSET = vec2( 50.0, 161.0 );\n    const float DOMAIN = 69.0;\n    const vec3 SOMELARGEFLOATS = vec3( 635.298681, 682.357502, 668.926525 );\n    const vec3 ZINC = vec3( 48.500388, 65.294118, 63.934599 );\n\n    //\ttruncate the domain\n    gridcell.xyz = gridcell.xyz - floor(gridcell.xyz * ( 1.0 / DOMAIN )) * DOMAIN;\n    vec3 gridcell_inc1 = step( gridcell, vec3( DOMAIN - 1.5 ) ) * ( gridcell + 1.0 );\n\n    //\tcalculate the noise\n    vec4 P = vec4( gridcell.xy, gridcell_inc1.xy ) + OFFSET.xyxy;\n    P *= P;\n    P = P.xzxz * P.yyww;\n    vec3 lowz_mod = vec3( 1.0 / ( SOMELARGEFLOATS.xyz + gridcell.zzz * ZINC.xyz ) );\n    vec3 highz_mod = vec3( 1.0 / ( SOMELARGEFLOATS.xyz + gridcell_inc1.zzz * ZINC.xyz ) );\n    lowz_hash_0 = fract( P * lowz_mod.xxxx );\n    highz_hash_0 = fract( P * highz_mod.xxxx );\n    lowz_hash_1 = fract( P * lowz_mod.yyyy );\n    highz_hash_1 = fract( P * highz_mod.yyyy );\n    lowz_hash_2 = fract( P * lowz_mod.zzzz );\n    highz_hash_2 = fract( P * highz_mod.zzzz );\n}\n\n\n\n\nvec4 Cellular_weight_samples( vec4 samples )\n{\n    samples = samples * 2.0 - 1.0;\n    //return (1.0 - samples * samples) * sign(samples);\t// square\n    return (samples * samples * samples) - sign(samples);\t// cubic (even more variance)\n}\n\n\n//\n//\tCellular Noise 3D\n//\tBased off Stefan Gustavson's work at http://www.itn.liu.se/~stegu/GLSL-cellular\n//\thttp://briansharpe.files.wordpress.com/2011/12/cellularsample.jpg\n//\n//\tSpeed up by using 2x2x2 search window instead of 3x3x3\n//\tproduces range of 0.0->1.0\n//\nfloat Cellular3D(vec3 P)\n{\n    //\testablish our grid cell and unit position\n    vec3 Pi = floor(P);\n    vec3 Pf = P - Pi;\n\n    //\tcalculate the hash.\n    //\t( various hashing methods listed in order of speed )\n    vec4 hash_x0, hash_y0, hash_z0, hash_x1, hash_y1, hash_z1;\n    FAST32_hash_3D( Pi, hash_x0, hash_y0, hash_z0, hash_x1, hash_y1, hash_z1 );\n    //SGPP_hash_3D( Pi, hash_x0, hash_y0, hash_z0, hash_x1, hash_y1, hash_z1 );\n\n    //\tgenerate the 8 random points\n#if 1\n    //\trestrict the random point offset to eliminate artifacts\n    //\twe'll improve the variance of the noise by pushing the points to the extremes of the jitter window\n    const float JITTER_WINDOW = 0.166666666;\t// 0.166666666 will guarentee no artifacts. It is the intersection on x of graphs f(x)=( (0.5 + (0.5-x))^2 + 2*((0.5-x)^2) ) and f(x)=( 2 * (( 0.5 + x )^2) + x * x )\n    hash_x0 = Cellular_weight_samples( hash_x0 ) * JITTER_WINDOW + vec4(0.0, 1.0, 0.0, 1.0);\n    hash_y0 = Cellular_weight_samples( hash_y0 ) * JITTER_WINDOW + vec4(0.0, 0.0, 1.0, 1.0);\n    hash_x1 = Cellular_weight_samples( hash_x1 ) * JITTER_WINDOW + vec4(0.0, 1.0, 0.0, 1.0);\n    hash_y1 = Cellular_weight_samples( hash_y1 ) * JITTER_WINDOW + vec4(0.0, 0.0, 1.0, 1.0);\n    hash_z0 = Cellular_weight_samples( hash_z0 ) * JITTER_WINDOW + vec4(0.0, 0.0, 0.0, 0.0);\n    hash_z1 = Cellular_weight_samples( hash_z1 ) * JITTER_WINDOW + vec4(1.0, 1.0, 1.0, 1.0);\n#else\n    //\tnon-weighted jitter window.  jitter window of 0.4 will give results similar to Stefans original implementation\n    //\tnicer looking, faster, but has minor artifacts.  ( discontinuities in signal )\n    const float JITTER_WINDOW = 0.4;\n    hash_x0 = hash_x0 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, 1.0-JITTER_WINDOW, -JITTER_WINDOW, 1.0-JITTER_WINDOW);\n    hash_y0 = hash_y0 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, -JITTER_WINDOW, 1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW);\n    hash_x1 = hash_x1 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, 1.0-JITTER_WINDOW, -JITTER_WINDOW, 1.0-JITTER_WINDOW);\n    hash_y1 = hash_y1 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, -JITTER_WINDOW, 1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW);\n    hash_z0 = hash_z0 * JITTER_WINDOW * 2.0 + vec4(-JITTER_WINDOW, -JITTER_WINDOW, -JITTER_WINDOW, -JITTER_WINDOW);\n    hash_z1 = hash_z1 * JITTER_WINDOW * 2.0 + vec4(1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW, 1.0-JITTER_WINDOW);\n#endif\n\n    //\treturn the closest squared distance\n    vec4 dx1 = Pf.xxxx - hash_x0;\n    vec4 dy1 = Pf.yyyy - hash_y0;\n    vec4 dz1 = Pf.zzzz - hash_z0;\n    vec4 dx2 = Pf.xxxx - hash_x1;\n    vec4 dy2 = Pf.yyyy - hash_y1;\n    vec4 dz2 = Pf.zzzz - hash_z1;\n    vec4 d1 = dx1 * dx1 + dy1 * dy1 + dz1 * dz1;\n    vec4 d2 = dx2 * dx2 + dy2 * dy2 + dz2 * dz2;\n    d1 = min(d1, d2);\n    d1.xy = min(d1.xy, d1.wz);\n    return min(d1.x, d1.y) * ( 9.0 / 12.0 );\t//\tscale return value from 0.0->1.333333 to 0.0->1.0  \t(2/3)^2 * 3  == (12/9) == 1.333333\n}\n\n\nvoid main()\n{\n\n\n    vec2 p=vec2(texCoord.x-0.5,texCoord.y-0.5);\n\n    #ifdef DO_TILEABLE\n        p=abs(texCoord-0.5);\n    #endif\n\n    p=p*scale;\n\n    p=vec2(p.x+0.5-x,p.y+0.5-y);\n\n    float v=Cellular3D(vec3(p.x,p.y,z));\n\n       //blend section\n    vec4 col=vec4(v,v,v,1.0);\n    //original texture\n    vec4 base=texture(tex,texCoord);\n    //blend stuff\n    col=vec4( _blend(base.rgb,col.rgb) ,1.0);\n    col=vec4( mix( col.rgb, base.rgb ,1.0-base.a*amount),1.0);\n    outColor= col;\n}\n",};
const render=op.inTrigger('render');
const blendMode=CGL.TextureEffect.AddBlendSelect(op,"Blend Mode","normal");
const amount=op.inValueSlider("Amount",1);
const x=op.inValue("X",0);
const y=op.inValue("Y",0);
const z=op.inValue("Z",0);
const scale=op.inValue("Scale",3);
const trigger=op.outTrigger('trigger');

const cgl=op.patch.cgl;
const shader=new CGL.Shader(cgl);


const srcFrag=(attachments.cellularnoise3d_frag||'').replace("{{BLENDCODE}}",CGL.TextureEffect.getBlendCode());
shader.setSource(shader.getDefaultVertexShader(),srcFrag);

const textureUniform=new CGL.Uniform(shader,'t','tex',0);
const amountUniform=new CGL.Uniform(shader,'f','amount',amount);

const uniZ=new CGL.Uniform(shader,'f','z',z);
const uniX=new CGL.Uniform(shader,'f','x',x);
const uniY=new CGL.Uniform(shader,'f','y',y);
const uniScale=new CGL.Uniform(shader,'f','scale',scale);

const tile=op.inValueBool("Tileable",false);
tile.onChange=updateTileable;
function updateTileable()
{
    if(tile.get())shader.define("DO_TILEABLE");
        else shader.removeDefine("DO_TILEABLE");
}

CGL.TextureEffect.setupBlending(op,shader,blendMode,amount);

render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);
    cgl.currentTextureEffect.bind();

    cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );


    cgl.currentTextureEffect.finish();
    cgl.setPreviousShader();

    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Noise.CellularNoise.prototype = new CABLES.Op();
CABLES.OPS["62fa72eb-a607-4397-8b44-f8fd2a6cbe34"]={f:Ops.Gl.TextureEffects.Noise.CellularNoise,objName:"Ops.Gl.TextureEffects.Noise.CellularNoise"};




// **************************************************************
// 
// Ops.Anim.InOutInAnim
// 
// **************************************************************

Ops.Anim.InOutInAnim = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

var anim=new CABLES.Anim();

var update=op.inTrigger("Update");

var duration1=op.inValue("Duration Out",0.25);
var easing1=anim.createPort(op,"Easing Out");
var value1=op.inValue("Value Out",0);

var duration2=op.inValue("Duration In",0.25);
var easing2=anim.createPort(op,"Easing In");
var value2=op.inValue("Value In",1);

var trigger=op.inTriggerButton("Start");
var next=op.outTrigger("Next");

var outVal=op.outValue("Result",0);

var middle=op.outTrigger("Middle");

trigger.onTriggered=setupAnim;


// outVal.set(1);


update.onTriggered=function()
{
    var time=CABLES.now()/1000.0;
    if(anim.isStarted(time)) outVal.set(anim.getValue(time));
        else outVal.set(value2.get());
};

value2.onChange=function()
{
    outVal.set(value2.get());
};

function setupAnim()
{
    anim.clear();
    anim.setValue(CABLES.now()/1000.0, value2.get());
    
    anim.setValue(CABLES.now()/1000.0+
                        duration1.get(), value1.get(),function()
                        {
                            middle.trigger();
                        });

    anim.setValue(CABLES.now()/1000.0+
                        duration1.get()+
                        duration2.get(), value2.get());

    anim.keys[0].setEasing(
        anim.easingFromString( easing1.get()) );

    anim.keys[1].setEasing(
        anim.easingFromString( easing2.get()) );

}

};

Ops.Anim.InOutInAnim.prototype = new CABLES.Op();
CABLES.OPS["ae46d30d-9ea6-417b-968b-e7b5726afdde"]={f:Ops.Anim.InOutInAnim,objName:"Ops.Anim.InOutInAnim"};




// **************************************************************
// 
// Ops.Gl.Matrix.Translate
// 
// **************************************************************

Ops.Gl.Matrix.Translate = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const render=op.inTrigger("render");
const trigger=op.outTrigger("trigger")
const x=op.inValue("x");
const y=op.inValue("y");
const z=op.inValue("z");

const cgl=op.patch.cgl;

var vec=vec3.create();

render.onTriggered=function()
{
    vec3.set(vec, x.get(),y.get(),z.get());
    cgl.pushModelMatrix();
    mat4.translate(cgl.mMatrix,cgl.mMatrix, vec);
    trigger.trigger();
    cgl.popModelMatrix();
};


};

Ops.Gl.Matrix.Translate.prototype = new CABLES.Op();
CABLES.OPS["1f89ba0e-e7eb-46d7-8c66-7814b7c528b9"]={f:Ops.Gl.Matrix.Translate,objName:"Ops.Gl.Matrix.Translate"};




// **************************************************************
// 
// Ops.Gl.MainLoop
// 
// **************************************************************

Ops.Gl.MainLoop = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
const fpsLimit=op.inValue("FPS Limit",0);
const trigger=op.outTrigger("trigger");
const width=op.outValue("width");
const height=op.outValue("height");
const reduceLoadingFPS=op.inValueBool("Reduce FPS loading");
const clear=op.inValueBool("Clear",true);
const fullscreen=op.inValueBool("Fullscreen Button",false);
const active=op.inValueBool("Active",true);
const hdpi=op.inValueBool("Hires Displays",false);

hdpi.onChange=function()
{
    if(hdpi.get()) op.patch.cgl.pixelDensity=window.devicePixelRatio;
        else op.patch.cgl.pixelDensity=1;
        
    op.patch.cgl.updateSize();
    if(CABLES.UI) gui.setLayout();
};


var cgl=op.patch.cgl;
var rframes=0;
var rframeStart=0;

if(!op.patch.cgl) op.uiAttr( { 'error': 'No webgl cgl context' } );

var identTranslate=vec3.create();
vec3.set(identTranslate, 0,0,0);
var identTranslateView=vec3.create();
vec3.set(identTranslateView, 0,0,-2);

fullscreen.onChange=updateFullscreenButton;
setTimeout(updateFullscreenButton,100);
var fsElement=null;

function updateFullscreenButton()
{
    function onMouseEnter()
    {
        if(fsElement)fsElement.style.display="block";
    }

    function onMouseLeave()
    {
        if(fsElement)fsElement.style.display="none";
    }
    
    op.patch.cgl.canvas.addEventListener('mouseleave', onMouseLeave);
    op.patch.cgl.canvas.addEventListener('mouseenter', onMouseEnter);

    if(fullscreen.get())
    {
        if(!fsElement) 
        {
            fsElement = document.createElement('div');

            var container = op.patch.cgl.canvas.parentElement;
            if(container)container.appendChild(fsElement);
    
            fsElement.addEventListener('mouseenter', onMouseEnter);
            fsElement.addEventListener('click', function(e)
            {
                if(CABLES.UI && !e.shiftKey) gui.cycleRendererSize();
                    else
                    {
                        cgl.fullScreen();
                    }
            });
        }

        fsElement.style.padding="10px";
        fsElement.style.position="absolute";
        fsElement.style.right="5px";
        fsElement.style.top="5px";
        fsElement.style.width="20px";
        fsElement.style.height="20px";
        // fsElement.style.opacity="1.0";
        fsElement.style.cursor="pointer";
        fsElement.style['border-radius']="40px";
        fsElement.style.background="#444";
        fsElement.style["z-index"]="9999";
        fsElement.style.display="none";
        fsElement.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 490 490" style="width:20px;height:20px;" xml:space="preserve" width="512px" height="512px"><g><path d="M173.792,301.792L21.333,454.251v-80.917c0-5.891-4.776-10.667-10.667-10.667C4.776,362.667,0,367.442,0,373.333V480     c0,5.891,4.776,10.667,10.667,10.667h106.667c5.891,0,10.667-4.776,10.667-10.667s-4.776-10.667-10.667-10.667H36.416     l152.459-152.459c4.093-4.237,3.975-10.99-0.262-15.083C184.479,297.799,177.926,297.799,173.792,301.792z" fill="#FFFFFF"/><path d="M480,0H373.333c-5.891,0-10.667,4.776-10.667,10.667c0,5.891,4.776,10.667,10.667,10.667h80.917L301.792,173.792     c-4.237,4.093-4.354,10.845-0.262,15.083c4.093,4.237,10.845,4.354,15.083,0.262c0.089-0.086,0.176-0.173,0.262-0.262     L469.333,36.416v80.917c0,5.891,4.776,10.667,10.667,10.667s10.667-4.776,10.667-10.667V10.667C490.667,4.776,485.891,0,480,0z" fill="#FFFFFF"/><path d="M36.416,21.333h80.917c5.891,0,10.667-4.776,10.667-10.667C128,4.776,123.224,0,117.333,0H10.667     C4.776,0,0,4.776,0,10.667v106.667C0,123.224,4.776,128,10.667,128c5.891,0,10.667-4.776,10.667-10.667V36.416l152.459,152.459     c4.237,4.093,10.99,3.975,15.083-0.262c3.992-4.134,3.992-10.687,0-14.82L36.416,21.333z" fill="#FFFFFF"/><path d="M480,362.667c-5.891,0-10.667,4.776-10.667,10.667v80.917L316.875,301.792c-4.237-4.093-10.99-3.976-15.083,0.261     c-3.993,4.134-3.993,10.688,0,14.821l152.459,152.459h-80.917c-5.891,0-10.667,4.776-10.667,10.667s4.776,10.667,10.667,10.667     H480c5.891,0,10.667-4.776,10.667-10.667V373.333C490.667,367.442,485.891,362.667,480,362.667z" fill="#FFFFFF"/></g></svg>';
    }
    else
    {
        if(fsElement)
        {
            fsElement.style.display="none";
            fsElement.remove();
            fsElement=null;
        }
    }
}


fpsLimit.onChange=function()
{
    op.patch.config.fpsLimit=fpsLimit.get()||0;
};

op.onDelete=function()
{
    cgl.gl.clearColor(0,0,0,0);
    cgl.gl.clear(cgl.gl.COLOR_BUFFER_BIT | cgl.gl.DEPTH_BUFFER_BIT);

    op.patch.removeOnAnimFrame(op);
};


op.patch.loading.setOnFinishedLoading(function(cb)
{
    op.patch.config.fpsLimit=fpsLimit.get();
});



op.onAnimFrame=function(time)
{
    if(!active.get())return;
    if(cgl.aborted || cgl.canvas.clientWidth===0 || cgl.canvas.clientHeight===0)return;

    if(op.patch.loading.getProgress()<1.0 && reduceLoadingFPS.get())
    {
        op.patch.config.fpsLimit=5;
    }

    if(cgl.canvasWidth==-1)
    {
        cgl.setCanvas(op.patch.config.glCanvasId);
        return;
    }

    if(cgl.canvasWidth!=width.get() || cgl.canvasHeight!=height.get())
    {
        // cgl.canvasWidth=cgl.canvas.clientWidth;
        width.set(cgl.canvasWidth);
        // cgl.canvasHeight=cgl.canvas.clientHeight;
        height.set(cgl.canvasHeight);
    }

    if(CABLES.now()-rframeStart>1000)
    {
        CGL.fpsReport=CGL.fpsReport||[];
        if(op.patch.loading.getProgress()>=1.0 && rframeStart!==0)CGL.fpsReport.push(rframes);
        rframes=0;
        rframeStart=CABLES.now();
    }
    CGL.MESH.lastShader=null;
    CGL.MESH.lastMesh=null;

    cgl.renderStart(cgl,identTranslate,identTranslateView);

    if(clear.get())
    {
        cgl.gl.clearColor(0,0,0,1);
        cgl.gl.clear(cgl.gl.COLOR_BUFFER_BIT | cgl.gl.DEPTH_BUFFER_BIT);
    }

    trigger.trigger();


    if(CGL.MESH.lastMesh)CGL.MESH.lastMesh.unBind();


    if(CGL.Texture.previewTexture)
    {
        if(!CGL.Texture.texturePreviewer) CGL.Texture.texturePreviewer=new CGL.Texture.texturePreview(cgl);
        CGL.Texture.texturePreviewer.render(CGL.Texture.previewTexture);
    }
    cgl.renderEnd(cgl);
    
    
    // cgl.printError('mainloop end');
    
    

    if(!cgl.frameStore.phong)cgl.frameStore.phong={};
    rframes++;
};


};

Ops.Gl.MainLoop.prototype = new CABLES.Op();
CABLES.OPS["b0472a1d-db16-4ba6-8787-f300fbdc77bb"]={f:Ops.Gl.MainLoop,objName:"Ops.Gl.MainLoop"};




// **************************************************************
// 
// Ops.Patch.PlayButton
// 
// **************************************************************

Ops.Patch.PlayButton = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};

const
    inExec=op.inTrigger("Trigger"),
    outNext=op.outTrigger("Next"),
    outClicked=op.outValueBool("Clicked");

var wasClicked=false;
const ele=document.createElement("div");
const elePlay=document.createElement("div");
const canvas = op.patch.cgl.canvas.parentElement;

ele.style.width="200px";
ele.style.height="200px";
ele.style.left="50%";
ele.style.top="50%";
ele.style['border-radius']="50px";
ele.style['margin-left']="-100px";
ele.style['margin-top']="-100px";
ele.style.position="absolute";
ele.style.cursor="pointer";
ele.style.opacity=1;
ele.style['z-index']=999999;
ele.style['background-color']="rgba(0,85,85)";


elePlay.style["border-style"]="solid";
elePlay.style["border-color"]="transparent transparent transparent #cc0";
elePlay.style["box-sizing"]="border-box";
elePlay.style.width="170px";
elePlay.style.height="170px";
elePlay.style['margin-top']="10px";
elePlay.style['margin-left']="40px";
elePlay.style["border-width"]="90px 0px 90px 140px";
elePlay.style['pointer-events']="none";

canvas.appendChild(ele);
ele.appendChild(elePlay);
ele.addEventListener('mouseenter', hover);
ele.addEventListener('mouseleave', hoverOut);
ele.addEventListener('click', clicked);
ele.addEventListener('touchStart', clicked);
op.onDelete=removeElements;

inExec.onTriggered=function()
{
    if(wasClicked) outNext.trigger();
};

function clicked()
{
    removeElements();
    wasClicked=true;
    outClicked.set(wasClicked);
}

function removeElements()
{
    if(elePlay) elePlay.remove();
    if(ele) ele.remove();
}

function hoverOut()
{
    ele.style.opacity=0.7;
}

function hover()
{
    ele.style.opacity=1.0;
}

};

Ops.Patch.PlayButton.prototype = new CABLES.Op();
CABLES.OPS["32e53fa2-4545-4c53-a94d-2204aa079246"]={f:Ops.Patch.PlayButton,objName:"Ops.Patch.PlayButton"};




// **************************************************************
// 
// Ops.User.adambazaroff.BpmTapLowBeat
// 
// **************************************************************

Ops.User.adambazaroff.BpmTapLowBeat = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={};
var exe=this.addInPort(new CABLES.Port(this,"exe",CABLES.OP_PORT_TYPE_FUNCTION));
var tap=this.addInPort(new CABLES.Port(this,"tap",CABLES.OP_PORT_TYPE_FUNCTION,{"display":"button"}));
var sync=this.addInPort(new CABLES.Port(this,"sync",CABLES.OP_PORT_TYPE_FUNCTION,{"display":"button"}));
var nudgeLeft=this.addInPort(new CABLES.Port(this,"nudgeLeft",CABLES.OP_PORT_TYPE_FUNCTION,{"display":"button"}));
var nudgeRight=this.addInPort(new CABLES.Port(this,"nudgeRight",CABLES.OP_PORT_TYPE_FUNCTION,{"display":"button"}));

var beat=this.addOutPort(new CABLES.Port(this,"beat",CABLES.OP_PORT_TYPE_FUNCTION));
var bpm=this.addOutPort(new CABLES.Port(this,"Bpm",CABLES.OP_PORT_TYPE_VALUE,{display:'editor'}));
var outStates=this.addOutPort(new CABLES.Port(this,"States",CABLES.OP_PORT_TYPE_ARRAY));

var beatNum=this.addOutPort(new CABLES.Port(this,"Beat Index",CABLES.OP_PORT_TYPE_VALUE));

var DEFAULT_BPM = 101.64; // 102.86;
var DEFAULT_MILLIS = bpmToMillis(DEFAULT_BPM);
var NUDGE_VALUE = 0.1; // to add / substract from avg bpm

var lastFlash = -1;
var lastTap = -1;

var taps=[];

var avgBpm = DEFAULT_BPM;
var avgMillis = getAvgMillis();

var beatCounter = 1; // [1, 2, 3, 4]
var states=[1,0,0,0];

exe.onTriggered=function()
{
    if(op.patch.freeTimer.get()*1000<lastFlash)
    {
        lastFlash=op.patch.freeTimer.get()*1000;
    }

    if(op.patch.freeTimer.get()*1000 > lastFlash + avgMillis){
        beat.trigger();
        incrementState();
        outStates.set(null);
        outStates.set(states);

        bpm.set(millisToBpm(avgMillis));
        lastFlash = op.patch.freeTimer.get()*1000;
        //console.log("Date.now: " + Date.now());
    }
};

function incrementState(){
    beatCounter++;
    if(beatCounter > 4){
        beatCounter = 1;
    }
    for(var i=0;i<4;i++){
        states[i]=0;
    }
    states[beatCounter-1] = 1;

beatNum.set(beatCounter-1);

}

function tapPressed() {
    // start new tap session
    if(op.patch.freeTimer.get()*1000 - lastTap > 1000) {
        taps.length=0;
        beatCounter = 0;
    }
    else {
        taps.push(op.patch.freeTimer.get()*1000 - lastTap);
    }
    lastTap = op.patch.freeTimer.get()*1000;
    avgMillis = getAvgMillis();
}

function millisToBpm(millis){
    return Number(60*1000/millis).toFixed(2);
}

function bpmToMillis(bpm){
    return 60*1000/bpm;
}

function getAvgMillis() {
    if(taps.length >= 1) {
        var sum = 0.0;
        for(var i=0; i<taps.length; i++) {
            sum += taps[i];
        }
        return sum/taps.length;
    }
    else {
        return DEFAULT_MILLIS;
    }
}

function syncPressed(){
    // on next execute everything will be reset to first beat
    lastFlash = -1;
    beatCounter = 0;
}

function nudgeLeftPressed() {
    avgBpm += NUDGE_VALUE;
    avgMillis = bpmToMillis(avgBpm);
}

function nudgeRightPressed() {
    avgBpm -= NUDGE_VALUE;
    avgMillis = bpmToMillis(avgBpm);
}

tap.onTriggered = tapPressed;
sync.onTriggered = syncPressed;
nudgeLeft.onTriggered = nudgeLeftPressed;
nudgeRight.onTriggered = nudgeRightPressed;


};

Ops.User.adambazaroff.BpmTapLowBeat.prototype = new CABLES.Op();





// **************************************************************
// 
// Ops.Gl.TextureEffects.Blur
// 
// **************************************************************

Ops.Gl.TextureEffects.Blur = function()
{
CABLES.Op.apply(this,arguments);
const op=this;
const attachments={blur_frag:"IN vec2 texCoord;\nUNI sampler2D tex;\nUNI float dirX;\nUNI float dirY;\nUNI float amount;\n\n#ifdef HAS_MASK\n    UNI sampler2D imageMask;\n#endif\n\nfloat random(vec3 scale, float seed)\n{\n    return fract(sin(dot(gl_FragCoord.xyz + seed, scale)) * 43758.5453 + seed);\n}\n\nvoid main()\n{\n    vec4 color = vec4(0.0);\n    float total = 0.0;\n\n    float am=amount;\n    #ifdef HAS_MASK\n        am=amount*texture(imageMask,texCoord).r;\n        if(am<=0.02)\n        {\n            outColor=texture(tex, texCoord);\n            return;\n        }\n    #endif\n\n   vec2 delta=vec2(dirX*am*0.01,dirY*am*0.01);\n\n\n\n    float offset = random(vec3(12.9898, 78.233, 151.7182), 0.0);\n\n\n    #ifndef FASTBLUR\n    const float range=20.0;\n    #endif\n    #ifdef FASTBLUR\n    const float range=5.0;\n    #endif\n\n    for (float t = -range; t <= range; t++)\n    {\n        float percent = (t + offset - 0.5) / range;\n        float weight = 1.0 - abs(percent);\n        vec4 smpl = texture(tex, texCoord + delta * percent);\n\n        smpl.rgb *= smpl.a;\n\n        color += smpl * weight;\n        total += weight;\n    }\n\n    outColor= color / total;\n\n    outColor.rgb /= outColor.a + 0.00001;\n}",};
const render=op.inTrigger('render');
const trigger=op.outTrigger('trigger');
const fast=op.inValueBool("Fast",true);

const cgl=op.patch.cgl;

const amount=op.addInPort(new CABLES.Port(op,"amount",CABLES.OP_PORT_TYPE_VALUE));
amount.set(10);

var shader=new CGL.Shader(cgl);

shader.define("FASTBLUR");

fast.onChange=function()
{
    if(fast.get()) shader.define("FASTBLUR");
        else shader.removeDefine("FASTBLUR");
};

shader.setSource(shader.getDefaultVertexShader(),attachments.blur_frag);
var textureUniform=new CGL.Uniform(shader,'t','tex',0);

var uniDirX=new CGL.Uniform(shader,'f','dirX',0);
var uniDirY=new CGL.Uniform(shader,'f','dirY',0);

var uniWidth=new CGL.Uniform(shader,'f','width',0);
var uniHeight=new CGL.Uniform(shader,'f','height',0);

var uniAmount=new CGL.Uniform(shader,'f','amount',amount.get());
amount.onValueChange(function(){ uniAmount.setValue(amount.get()); });

var textureAlpha=new CGL.Uniform(shader,'t','imageMask',1);


var direction=op.addInPort(new CABLES.Port(op,"direction",CABLES.OP_PORT_TYPE_VALUE,{display:'dropdown',values:['both','vertical','horizontal']}));
var dir=0;
direction.set('both');
direction.onValueChange(function()
{
    if(direction.get()=='both')dir=0;
    if(direction.get()=='horizontal')dir=1;
    if(direction.get()=='vertical')dir=2;
});

var mask=op.inTexture("mask");

mask.onChange=function()
{
    if(mask.get() && mask.get().tex) shader.define('HAS_MASK');
        else shader.removeDefine('HAS_MASK');
};



render.onTriggered=function()
{
    if(!CGL.TextureEffect.checkOpInEffect(op)) return;

    cgl.setShader(shader);

    uniWidth.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().width);
    uniHeight.setValue(cgl.currentTextureEffect.getCurrentSourceTexture().height);

    // first pass
    if(dir===0 || dir==2)
    {

        cgl.currentTextureEffect.bind();
        cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );


        if(mask.get() && mask.get().tex)
        {
            cgl.setTexture(1, mask.get().tex );
            // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, mask.get().tex );
        }


        uniDirX.setValue(0.0);
        uniDirY.setValue(1.0);

        cgl.currentTextureEffect.finish();
    }

    // second pass
    if(dir===0 || dir==1)
    {

        cgl.currentTextureEffect.bind();
        cgl.setTexture(0, cgl.currentTextureEffect.getCurrentSourceTexture().tex );


        if(mask.get() && mask.get().tex)
        {
            cgl.setTexture(1, mask.get().tex );
            // cgl.gl.bindTexture(cgl.gl.TEXTURE_2D, mask.get().tex );
        }

        uniDirX.setValue(1.0);
        uniDirY.setValue(0.0);

        cgl.currentTextureEffect.finish();
    }

    cgl.setPreviousShader();
    trigger.trigger();
};


};

Ops.Gl.TextureEffects.Blur.prototype = new CABLES.Op();
CABLES.OPS["54f26f53-f637-44c1-9bfb-a2f2b722e998"]={f:Ops.Gl.TextureEffects.Blur,objName:"Ops.Gl.TextureEffects.Blur"};


