var Points = function(){

    var size = TDEMO.MAIN.getRendererSize();
    PartBase.call(this,
        {camera : new THREE.OrthographicCamera( -size[0]/2, size[0]/2, size[1]/2, -size[1]/2, 0.1, 2000 )});
    this.camera.position.z = 1;

    this.mainScene = new THREE.Scene();
    var aspect = this.width/this.height;
    this.mainCamera = new THREE.PerspectiveCamera(50, aspect, this.near, this.far);

    this.mainScene.add(this.mainCamera);
    this.rtt = new THREE.WebGLRenderTarget(1024, 1024);
    this.rtt.texture.wrapS = THREE.MirroredRepeatWrapping;
    this.rtt.texture.wrapT = THREE.MirroredRepeatWrapping;
    this.rtt.texture.offset.x = -0.5;

    console.log(this.rtt);
    console.log(this.rtt.texture);

    //POSTPROCESSING
    //this.setHorizontalBlur(10);
    //this.setVerticalBlur(10);
    this.setEdgeDetection();
    this.setDoF({
        focus : 0.8,
        maxblur: 8.0,
        aperture: 0.03,
        width: 1024,
        height: 1024,
        camera : this.mainCamera
    });
    this.setBloom(3);
    //this.setBloom(6);


    var pg = new THREE.PlaneBufferGeometry(this.width, this.height);
    var pm = new THREE.MeshBasicMaterial({map: this.rtt.texture});
    this.plane = new THREE.Mesh(pg, pm);
    this.scene.add(this.plane);

    var material = new THREE.PointsMaterial({ color: /*0xDD475A*/ 0xFF5555});
    var geometry = new THREE.Geometry();
    geometry.dynamic = true;
    this.lsystem = new LSYSTEM();

    this.lsystem.interpret(6, 60, "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 4);
    this.lsystem.moveToCenter();

    for(var k = 0; k < this.lsystem.points.length; ++k){
        var point = this.lsystem.points[k];
        /*geometry.vertices.push(new THREE.Vector3(point.x/2, point.y, -point.z/2));
        geometry.vertices.push(new THREE.Vector3(-point.x, -point.y/2, point.z));

        geometry.vertices.push(new THREE.Vector3(-point.x/2, point.y/2, point.z/2));
        geometry.vertices.push(new THREE.Vector3(point.x, -point.y, -point.z));

        geometry.vertices.push(new THREE.Vector3(point.x/3, point.y/6, point.z));
        geometry.vertices.push(new THREE.Vector3(-point.x/3, -point.y/6, point.z/2));
        

        geometry.vertices.push(new THREE.Vector3(-point.x/6, point.y/5, point.z));
        geometry.vertices.push(new THREE.Vector3(point.x/6, -point.y/5, point.z));*/

        geometry.vertices.push(new THREE.Vector3(point.x/2, point.y/2, point.z));
        geometry.vertices.push(new THREE.Vector3(-point.x/2, -point.y/2, point.z));

        geometry.vertices.push(new THREE.Vector3(-point.x, -point.y, point.z));
        geometry.vertices.push(new THREE.Vector3(point.x, point.y, point.z));

        geometry.vertices.push(new THREE.Vector3(point.x/4, point.y/4, point.z));
        geometry.vertices.push(new THREE.Vector3(-point.x/4, -point.y/4, point.z));
        

        geometry.vertices.push(new THREE.Vector3(-point.x/3, point.y/3, point.z));
        geometry.vertices.push(new THREE.Vector3(point.x/3, -point.y/3, point.z));
        
    }
    geometry.verticesNeedUpdate = true;
    this.points = new THREE.Points(geometry, material);

    this.mainScene.add(this.points);
    this.createSurroundings();
    this.showText = false;

};

Points.prototype = PartBase.prototype.inheritance();

Points.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, false);

    this.near = TDEMO.SYNC.getNear();
    this.far = TDEMO.SYNC.getFar();


    this.mainCamera.near = this.near;
    this.mainCamera.far = this.far;
    this.lens = TDEMO.SYNC.getLens();
    this.mainCamera.filmGauge = this.lens.fg;
    this.mainCamera.setFocalLength(this.lens.fl);
    this.mainCamera.updateProjectionMatrix();
    
    var camp = TDEMO.SYNC.getCameraPosition();
    this.mainCamera.position.x = camp.x;
    this.mainCamera.position.y = camp.y;
    this.mainCamera.position.z = camp.z;

    var camr = TDEMO.SYNC.getCameraRotation();
    this.mainCamera.rotation.x = camr.x;
    this.mainCamera.rotation.y = camr.y;
    this.mainCamera.rotation.z = camr.z;

    var lp = TDEMO.SYNC.getObjRotation();
    this.points.rotation.x = lp.x;
    this.points.rotation.y = lp.y;
    this.points.rotation.z = lp.z;
    
    var p = TDEMO.SYNC.getObjPosition();
    this.points.position.x = p.x;
    this.points.position.y = p.y;
    this.points.position.z = p.z;

    var text = document.getElementById("credits");
    var hb = TDEMO.SYNC.getHeartBeat();
    if(hb > 0){
        if(this.showText === false){
            text.style.display = "block";
            this.showText = true;
        }
        text.style.opacity = hb;
    }
    else if( hb <= 0 && this.showText === true){
        text.style.display = "none";
        this.showText = false;
  }

  TDEMO.MAIN.getRenderer().render(this.mainScene, this.mainCamera, this.rtt, true);
};

Points.prototype.createSurroundings = function(){

    this.mainScene.fog = new THREE.Fog(/*0x200504*/0x200302, 100, 600);
    var material = new THREE.MeshStandardMaterial({
        color : 0x000000,
        side : THREE.BackSide
    });
    this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(1000, 64, 64), material);
    this.mainScene.add(this.skySphere);
}
