; FASM source code
; http://flatassembler.net/
;
; GreyCity 256b intro
; (c) SysTools 2019
; http://systools.losthost.org/
;
; tribute to
; Pink Floyd - What Shall We Do Now?
; song from "The Wall" music video
;
; this is first ever and very simple prod by SysTools
; created for CAFe 2019
; https://events.retroscene.org/cafe2019
;
; greetings for inspiration to
; sensenstahl with "where did all the giants go?"
; https://www.pouet.net/prod.php?which=78491

use16
org 100h
  ; go to 320x200 8BPP mode
  mov  ax, 13h
  int  10h
  ; back buffer segment
  mov  ax, ds
  add  ax, _scr / 16
  mov  ds, ax ; ds:si
  mov  es, ax ; es:di
  ; clear back buffer
  xor  ax, ax
  mov  di, ax
  mov  cx, (320 * 200) / 2
  cld
  repe stosw
  ; pixel
  xor  bx, bx
  @mainloop:
    ; step - pixel color
    ; index from range 10h..1Fh 
    ; are colors of grey from dark to bright
    ; in default 13h mode palette
    ; these colors will be used to made
    ; a shaded side wall of the buildings
    ; to give them a bit of depth
    ; extend to 00h..3Fh to make room for front wall too
    inc  bx
    and  bx, 3Fh
    ; colsloop args
    xor  dx, dx
    mov  si, dx
    mov  di, dx
    ; draw frame in back buffer
    @colsloop:
      push si
      push di
      ; shift image to right
      mov  cx, 319
      add  si, cx
      dec  si
      add  di, cx
      ; ds:si -> es:di
      std
      repe movsb
      ; default pixel color 1Fh for front wall (bright one)
      mov  al, 1Fh
      ; if it less than 10h - use to draw side wall
      cmp  bl, 10h
      jae  @f
        mov  al, bl
        or   al, 10h
      @@:
      ; draw windows
      ; this need to draw a gap between them
      test dl, 3
      jz   @f
        test  bl, 3
        jz    @f
          mov  al, 10h
      @@:
      ; put pixel to back buffer
      mov  [es:di], al
      ; go to next row
      pop  di
      pop  si
      mov  ax, 320
      add  di, ax
      add  si, ax
      ; check if whole image updated
      inc  dx
      cmp  dx, 200
      jnz  @colsloop
    ; shift image down
    ; only if side wall (diagonal) drawn now
    cmp  bl, 10h
    jae  @f
      mov  cx, 320 * 199
      mov  si, cx
      dec  si
      mov  di, cx
      add  di, 320
      dec  di
      repe movsb
      ; clear top row
      ; required to hide glitches after shift down
      mov  cx, 319
      xor  ax, ax
      repe stosb
      @@:
    ; copy to screen
    call @flip
    ; check keypress
    mov  ah, 01h
    int  16h
    jz   @mainloop
  ; some waste of space here but want to
  ; cleanup properly for real DOS machines
  ; read pressed key (clear keyboard buffer)
  xor  ax, ax
  int  16h
  ; return to 80x25 text mode
  ; (may not be original mode, but at least leave graphics)
  mov  ax, 03h
  int  10h
  ; exit to DOS
  mov  ax, 04C00h
  int  21h
  ; flip screen image with back buffer content
@flip:
  push es
  mov  ax, 0A000h
  mov  es, ax
  ; note that only half of the back buffer
  ; will be copied to the screen
  mov  cx, (320 * 100) / 2
  mov  di, (320 * 100)
  xor  si, si
  ; wait for vertical retrace
  ; (this demo FPS locked instead of timer)
  mov  dx, 03DAh
  @@:
    in   al, dx
    test al, 08h
    jnz  @b
  @@:
    in   al, dx
    test al, 08h
    jz   @b
  ; copy back buffer to screen
  ; ds:si -> es:di
  cld
  repe movsw
  pop  es
  ; add text to the actual screen
  ; via DOS and BIOS FN
  push bx
  push ds
  push cs
  pop  ds
  ; initial text offs (end, will go back)
  mov  si, LEN
  ; initial text coord (bottom, will go up)
  mov  dx, 0070Dh
  @@:
    ; move cursor
    mov  ah, 002h
    sub  dh, ah
    push dx
    xor  bh, bh
    int  010h
    ; draw text
    sub  si, 23
    lea  dx, [_txt + si]
    mov  ah, 009h
    int  021h
    pop  dx
    ; next line
    test  si, si
    jnz   @b
  pop  ds
  pop  bx
  retn
; text string must have the same length
; for dynamic indexing in loop above
_txt:
db '  what shall we use to$',\
   'fill the empty spaces?$'
LEN = $ - _txt
; 16 byte align needed to use segment
; instead of offset for offscreen buffer
align 16
; offscreen back buffer
_scr rb (320 * 200)
