const unsigned char vaders_palette[16*4]={
	0x0f,0x1c,0x2c,0x3c,0x0f,0x1c,0x2c,0x3b,0x0f,0x1c,0x2c,0x31,0x0f,0x1c,0x21,0x32,
	0x0f,0x18,0x28,0x38,0x0f,0x18,0x28,0x39,0x0f,0x18,0x28,0x37,0x0f,0x18,0x27,0x36,
	0x0f,0x15,0x25,0x35,0x0f,0x15,0x25,0x36,0x0f,0x15,0x25,0x34,0x0f,0x15,0x24,0x34,
	0x0f,0x19,0x29,0x39,0x0f,0x19,0x29,0x3a,0x0f,0x19,0x2a,0x3a,0x0f,0x1a,0x2b,0x3b
};




const unsigned char vaders_shape[12*12*4]={
/*
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xdd,0xdd,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xdd,0xdd,0xdd,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,
	0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0x00,0x00,0x00,
	0x00,0x00,0xdd,0x00,0xdd,0x00,0x00,0xdd,0x00,0xdd,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0x00,
	0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,
	0x00,0xdd,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0xdd,0x00,
	0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xdd,0xdd,0xdd,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,
	0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,
	0x00,0xdd,0xdd,0x00,0x00,0xdd,0xdd,0x00,0x00,0xdd,0xdd,0x00,
	0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,
	0x00,0x00,0x00,0xdd,0xdd,0x00,0x00,0xdd,0xdd,0x00,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0x00,
	0x00,0x00,0x00,0xdd,0xdd,0x00,0x00,0xdd,0xdd,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,
	0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,
	0x00,0xdd,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0xdd,0x00,
	0x00,0xdd,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0xdd,0x00,
	0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,
	0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,
	0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
*/

	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0x00,
	0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,
	0x00,0xdd,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0xdd,0x00,
	0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xdd,0xdd,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xdd,0xdd,0xdd,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0x00,0x00,0x00,
	0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,
	0x00,0x00,0x00,0xdd,0xdd,0x00,0x00,0xdd,0xdd,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xdd,0xdd,0xdd,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,
	0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,
	0x00,0xdd,0xdd,0x00,0x00,0xdd,0xdd,0x00,0x00,0xdd,0xdd,0x00,
	0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,
	0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,
	0x00,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,
	0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,0x00,0xdd,0x00,
	0x00,0xdd,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0xdd,0x00,
	0x00,0xdd,0xdd,0xdd,0x00,0xdd,0xdd,0x00,0xdd,0xdd,0xdd,0x00,
	0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,
	0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0x00,0x00,
	0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,
	0x00,0x00,0xdd,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00

};



const signed char vaders_sin[128]={
	0,0,1,2,3,3,4,5,6,6,7,8,8,9,10,10,
	11,11,12,12,13,13,14,14,14,15,15,15,15,15,15,15,
	16,15,15,15,15,15,15,15,14,14,14,13,13,12,12,11,
	11,10,10,9,8,8,7,6,6,5,4,3,3,2,1,0,
	0,0,-1,-2,-3,-3,-4,-5,-6,-6,-7,-8,-8,-9,-10,-10,
	-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,
	-16,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,
	-11,-10,-10,-9,-8,-8,-7,-6,-6,-5,-4,-3,-3,-2,-1,0,
};


const unsigned char vader_tile_transitions[8*10]={	//first four 0-to-1, next four 1-to-0
	0x00,0x02,0x04,0x06,0x08,0x0a,0x0c,0x0e,0x20,0x22,	
	0x44,0x42,0x40,0x2e,0x2c,0x2a,0x28,0x26,0x24,0x22,
	0x60,0x62,0x64,0x66,0x68,0x6a,0x6c,0x6e,0x80,0x82,
	0xa4,0xa2,0xa0,0x8e,0x8c,0x8a,0x88,0x86,0x84,0x82,

	0x22,0x20,0x0e,0x0c,0x0a,0x08,0x06,0x04,0x02,0x00,
	0x22,0x24,0x26,0x28,0x2a,0x2c,0x2e,0x40,0x42,0x44,
	0x82,0x80,0x6e,0x6c,0x6a,0x68,0x66,0x64,0x62,0x60,
	0x82,0x84,0x86,0x88,0x8a,0x8c,0x8e,0xa0,0xa2,0xa4,
};

//one pattern of music is 384 frames here

#define EV_SHOW_TIME		(60*5)
#define EV_HIDE_TIME		(384-60*5)

#define EV_SLOTS_ALL		4

#pragma bssseg (push,"SHAREDRAM5")
#pragma dataseg(push,"SHAREDRAM5")

unsigned int  ev_nt_adr    [EV_SLOTS_ALL];
unsigned char ev_anim_type [EV_SLOTS_ALL];
unsigned char ev_anim_cnt  [EV_SLOTS_ALL];
unsigned char ev_anim_speed[EV_SLOTS_ALL];

unsigned char ev_shape;
unsigned int  ev_shape_off;
unsigned char ev_list_ptr;
unsigned char ev_list_len;
unsigned char ev_speed_min;
unsigned char ev_speed_mask;

unsigned char ev_stars[64*3];

#pragma dataseg(pop);
#pragma bssseg (pop);



void vaders_toss_pixels(void)
{
	ev_list_ptr=0;
	ev_list_len=0;

	for(_id=0;_id<12*12;++_id)
	{
		if(vaders_shape[ev_shape_off+_id]) split_list[ev_list_len++]=_id;
	}
	
	for(_id=0;_id<ev_list_len;++_id)
	{
		_i=rand8()%ev_list_len;
		_j=rand8()%ev_list_len;
		_tile=split_list[_i];
		split_list[_i]=split_list[_j];
		split_list[_j]=_tile;
	}
	
	pal_bg (&vaders_palette[(ev_shape>>1)<<4]);
	pal_spr(&vaders_palette[(ev_shape>>1)<<4]);
}



void e_vaders(void)
{
	unsigned char chr,frame,bright_bg,bright_spr,attr_off,done;
	unsigned int adr,delay1;
	signed int sinex,siney,sinedx,sinedy,sinescale;
	
	oam_clear_fast();
	oam_size(0);

	chr=CHR_VADERS;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	mmc3_chr_bank(chr+0,2);
	mmc3_chr_bank(chr+1,3);
	mmc3_chr_bank(chr+2,4);
	mmc3_chr_bank(chr+3,5);
	
	mmc3_set_mirroring(M_HORIZONTAL);
	
	set_irq_handler(IRQ_EMPTY);
	set_nmi_handler(NMI_NORMAL);
	
	memfill(update_list,NT_UPD_EOF,sizeof(update_list));
	memfill(split_list,0,sizeof(split_list));
	
	pal_bg (vaders_palette);
	pal_spr(vaders_palette);
	pal_bright(4);
	
	vram_adr(NAMETABLE_A);
	vram_fill(0,1024);
	vram_adr(NAMETABLE_C);
	vram_fill(0,1024);
	
	scroll(0,0);
	
	ev_shape=0;
	ev_shape_off=0;
	ev_speed_min=2;
	ev_speed_mask=3;
	
	frame=0;
	bright_bg=4;
	bright_spr=0;
	sinex=0;
	siney=0;
	sinedx=16;
	sinedy=12;
	sinescale=64;
	attr_off=0;
	delay1=0;
	done=FALSE;
	
	for(_id=0;_id<EV_SLOTS_ALL;++_id) ev_nt_adr[_id]=0;
	
	set_rand(0xfdfd);
	
	vaders_toss_pixels();
	
	_ptr=0;
	
	for(_id=0;_id<64;++_id)
	{
		ev_stars[_ptr++]=rand8();
		ev_stars[_ptr++]=rand8()%240;
		ev_stars[_ptr++]=0xc0+(rand8()%3);
	}
		
	ppu_on_all();
	
	while(1)
	{
		oam_off=0;
		_ptr=0;
		
		if(!(frame&7)&&!done)
		{
			if(ev_shape&1)
			{
				if(bright_spr) --bright_spr;
			}
			else
			{
				if(bright_spr<4) ++bright_spr;
			}
		}
		
		switch(ev_shape/2)
		{
			case 1:
			{
				for(_id=0;_id<8;++_id)
				{
					oam_spr(ev_stars[_ptr+0],ev_stars[_ptr+1],ev_stars[_ptr+2],OAM_BEHIND,oam_off);
					
					++ev_stars[_ptr+0];
					
					_ptr+=3;
					
					oam_off+=4;
				}
			}
			break;
			
			case 2:
			{
				for(_id=0;_id<16;++_id)
				{
					oam_spr(ev_stars[_ptr+0],ev_stars[_ptr+1],ev_stars[_ptr+2],OAM_BEHIND,oam_off);
					
					ev_stars[_ptr+0]-=2;
					
					_ptr+=3;
					
					oam_off+=4;
				}
			}
			break;
			
			case 3:
			{
				for(_id=0;_id<48;++_id)
				{
					oam_spr(ev_stars[_ptr+0],ev_stars[_ptr+1],ev_stars[_ptr+2],OAM_BEHIND,oam_off);
					
					ev_stars[_ptr+1]+=4;
					
					_ptr+=3;
					
					oam_off+=4;
				}
			}
			break;
		}
	
		upd_off=0;
		
		adr=NAMETABLE_A+960+16+attr_off;
		
		update_list[upd_off++]=MSB(adr)|NT_UPD_HORZ;
		update_list[upd_off++]=LSB(adr);
		update_list[upd_off++]=10;
		
		for(_id=0;_id<10;++_id) update_list[upd_off++]=rand8();
		
		attr_off+=10;
		
		if(attr_off>=40) attr_off=0;
		
		for(_id=0;_id<EV_SLOTS_ALL;++_id)
		{
			adr=ev_nt_adr[_id];
			
			if(!adr)
			{
				if(ev_list_ptr<ev_list_len)
				{
					_tile=split_list[ev_list_ptr++];	//pick new pixel
					
					ev_nt_adr    [_id]=NTADR_A(6+(_tile%12)*2,6+(_tile/12)*2);
					ev_anim_type [_id]=(rand8()&3)*10;
					ev_anim_cnt  [_id]=0;
					ev_anim_speed[_id]=ev_speed_min+(rand8()&ev_speed_mask);
					
					if(ev_shape&1)	//clearing picture
					{
						ev_anim_type [_id]+=4*10;
						ev_anim_speed[_id]*=3;
					}
				}
				
				continue;
			}
			
			_ptr=ev_anim_type[_id]+(ev_anim_cnt[_id]>>3);
			
			_tile=vader_tile_transitions[_ptr];
			
			update_list[upd_off++]=MSB(adr)|NT_UPD_HORZ;
			update_list[upd_off++]=LSB(adr);
			update_list[upd_off++]=2;
			update_list[upd_off++]=_tile+0x00;
			update_list[upd_off++]=_tile+0x01;
			
			adr+=32;
			
			update_list[upd_off++]=MSB(adr)|NT_UPD_HORZ;
			update_list[upd_off++]=LSB(adr);
			update_list[upd_off++]=2;
			update_list[upd_off++]=_tile+0x10;
			update_list[upd_off++]=_tile+0x11;
			
			if(ev_anim_cnt[_id]>=(9<<3)) ev_nt_adr[_id]=0;
				
			ev_anim_cnt[_id]+=ev_anim_speed[_id];
			
			if(ev_anim_cnt[_id]>=(9<<3)) ev_anim_cnt[_id]=(9<<3);	//make sure last tile will be printed regardless of the speed
		}

		update_list[upd_off]=NT_UPD_EOF;
		
		set_vram_update();
		
		oam_update();
		
		_sx=16+vaders_sin[(sinex>>4)&127]*sinescale/64;
		_sy=16+vaders_sin[(siney>>4)&127]*sinescale/64;
		
		scroll(_sx,_sy);
		
		if(playdump_sync)
		{
			playdump_sync=0;
			pal_bright(6);
		}
		else
		{
			pal_bg_bright (bright_bg);
			pal_spr_bright(bright_spr);
		}
		
		ppu_wait_nmi();
		
		sinex+=sinedx;
		siney+=sinedy;

		if(!done)
		{	
			++delay1;

			if(!(ev_shape&1))
			{
				if(delay1>=EV_SHOW_TIME)
				{
					if(ev_shape<3*2)
					{
						delay1=0;
						ev_list_ptr=0;
						++ev_shape;
					}
					else
					{
						done=TRUE;
					}
				}
			}
			else
			{
				if(delay1>=EV_HIDE_TIME)
				{
					delay1=0;
					
					++ev_shape;
					++ev_speed_min;
					ev_speed_mask=7;
					
					ev_shape_off+=12*12;
					
					vaders_toss_pixels();
				}
			}
		}
		
		if(done)
		{
			if(sinescale)
			{
				--sinescale; 
			}
			else
			{
				if(!(frame&7))
				{
					if(bright_bg)  --bright_bg; else break;
					if(bright_spr) --bright_spr; else break;
				}
			}
		}
		
		++frame;
	}
	
	ppu_off();
}