;   starburst by unlord / xylem
;         256b intro for
;       @party 2019 Party
;
; nasm starbrst.asm -o starbrst.com

  BITS 16

%define DEGS (1024)
%define WIDTH (320)
%define HEIGHT (200)

struc stack
  .di: resw 1
  .si: resw 1
  .bp: resw 1
  .sp: resw 1
  .bx: resw 1
  .dx: resw 1
  .cx: resw 1
  .ax: resw 1
  .size:
endstruc

%define SP_OFFSET (-2)

  org 0x100
start:
  mov si, degs
  mov bp, DEGS - 1
.trig:
  pusha
  add bp, bp
  fild word [bx + SP_OFFSET - stack.size + stack.bp]
  fldpi
  fmulp
  fidiv word [si]
  ; s = i*pi/1023
  fld st0
  fadd st1
  fld st0
  ; 2*s, 2*s, s
  fcos
  fmul dword [si + 2]
  fimul word [si]
  ; store 0.3*cos(2*pi*i/1023)
  fistp word [trig_3cos + bp]
  fsin
  fimul word [si]
  ; store sin(2*pi*i/1023)
  fistp word [si + 8 + bp]
  fsin
  fmul st0
  fimul word [si]
  ; store sin(pi*i/1023)^2
  fistp word [trig_sin2 + bp]
  popa
  dec bp
  jns .trig

  push 0x6000
  pop fs
  push 0x8000
  pop gs

  mov cx, HEIGHT
.row:
  mov dx, WIDTH/2
.col:
  pusha
  sub cx, HEIGHT/2
  pusha

  fild word [SP_OFFSET - 2*stack.size + stack.dx]
  fild word [SP_OFFSET - 2*stack.size + stack.cx]
  ; sp = y, x
  fldln2
  fld st2
  fmul st3
  fld st2
  fmul st3
  faddp
  fsqrt
  fidiv word [si + 6]
  fyl2x
  ; store ln(x*x + y*y)
  fimul word [si]
  fistp word [fs:bx]
  fpatan
  ; sp = atan2(y, x), y, x
  fldpi
  fdivp
  fimul word [si]
  ; store atan2(y, x)*DEGS/PI
  fistp word [gs:bx]

  popa
  popa
  inc bx
  inc bx
  dec dx
  jnz .col
  loop .row

  mov al, 0x13
  int 0x10

.pal:
  mov ax, cx
  mov dx, 0x3C8
  out dx, al
  inc dx
  shr al, 3
  out dx, al
  out dx, al
  add ax, ax
  out dx, al
  loop .pal

  push 0xa000
  pop es

  ; si = time
  xor si, si
.main:
  xor di, di
  mov cl, 200
.draw:
  mov dx, 160
.pixel:
  pusha
  mov dx, 0x7ff
  ; bp = theta
  mov bp, word [gs:di]
  add bp, bp
  lea bx, [bp + si]
  and bx, dx
  mov ax, word [trig_sin + bx]
  add bp, bp
  lea bx, [bp + si]
  and bx, dx
  add ax, word [trig_sin + bx]
  shl bp, 2
  lea bx, [bp + si]
  and bx, dx
  add ax, word [trig_3cos + bx]
  add ax, word [fs:di]
.add:
  add ax, DEGS
  js .add
  add ax, ax
  and ax, dx
  mov bx, ax
  mov ax, word [trig_sin2 + bx]
  shr ax, 2
  mov word [SP_OFFSET - stack.size + stack.ax], ax
  popa
  stosb
  stosb
  dec dx
  jnz .pixel
  loop .draw

  add si, 6

  mov ah, 1
  int 0x16
  jz .main

  mov ax, 0x3
  int 0x10

  ret

segment .data align=1

degs: dw DEGS-1
_3: dd 0.3
_27: dw 27

segment .bss align=1

trig_sin: resw(DEGS)
trig_2sin10: resw(DEGS)
trig_3cos: resw(DEGS)
trig_sin2: resw(DEGS)
