#Niklas Dillen & Anton Schwarz
#Snowman and -ball tool
#For TG (Norway) Useless Utility competition

#Imports
from tkinter import *
import csv
import math
from random import randint
from tkinter import font as tkfont
import matplotlib.pyplot as plt

#Declaring Variables
fromCSV = {}

#Defining functions
def getSnowCoef(temp, grain): #Get snow coef
    snow_coef = float((grain - temp)/2)
    return snow_coef

def calcVolumeBall(diameter): #Calculate Volume
    volume = (4/3)*math.pi*((diameter/2)**3)
    return volume

def calcVolSmolSno(height):
    volume = (4/3)*math.pi*(((0.2*height)**3)+((0.3*height)**3))
    return volume

def calcVolBigSno(height):
    volume = (4/3)*math.pi*(((0.12*height)**3)+((0.16*height)**3)+((0.215*height)**3))
    return volume

def calcMass(diameter, density): #Calculate Mass
    volume = calcVolumeBall(diameter)
    mass = volume*density
    return mass

def takeUsiFloat(question): #Take input from user, reject if not float
    check = True
    while check == True:
        try:
            uzer = float(input(str(question)))
            check = False
            return uzer
        except ValueError:
            print('Bad input')

def getIballSize(): #Get size of initially formed snow ball, in terms of hand strength and the snow coefs
    strength = fromCSV['handstrength_coef']
    diameter = 0.03*math.log((strength/600)+4)*getSnowCoef(fromCSV['temp_coef'], fromCSV['grain_coef'])
    return diameter

def getSheetSize(uzer): #Get sheet size to add to Iball, necessary for distance to roll
    IballSize = float(getIballSize())
    SheetSize = (uzer - IballSize)/2
    return SheetSize

def getRodistSize(diameter, inidiam, density): #Get Rolling Distance
    mass = calcMass(diameter, density) - calcMass(inidiam, density)
    RodistSize = float(2*math.sqrt(mass)/math.sqrt(getSnowCoef(fromCSV['temp_coef'], fromCSV['grain_coef'])))
    return RodistSize

with open('DataDump.csv', newline='') as csvfile: #Importing from csv into dictionary
    reader = csv.DictReader(csvfile)
    for row in reader:
        fromCSV[str(row['Name'])] = float(row['Value'])

def calcTime(inp, force):
    distance = getRodistSize(inp, getIballSize(), fromCSV['density_const'])
    time = (distance*20 - force/15)*3
    return time

def calcEnergy(time):
    efficiency = runtimeF1.moveOption.get()
    return time*0.08333*efficiency

def runSim(inp, meltBool): #Run the tool
    inp = float(inp) #User input (diameter)
    outString = [] #Create list to outpus

    outString.append('Your snowman has volume (m^3)')
    outString.append('Your snowman has mass (kg)')
    outString.append('Diameter of initial snowball (m)')
    outString.append('Sheet thickness to add to snowball (m)')
    outString.append('Distance rolled (m)')

    if meltBool:
        outString.append('Melting time at 10°C (in days)')

    outString.append(str(calcVolumeBall(inp)) +' m^3')
    outString.append(str(calcMass(inp, fromCSV['density_const'])) +' kg')
    outString.append(str(getIballSize()) +' m')
    outString.append(str(getSheetSize(inp)) +' m')
    outString.append(str(getRodistSize(inp, getIballSize(), fromCSV['density_const'])) +' m')

    if meltBool:
        outString.append(str(calcMelt(calcVolumeBall(inp), runtimeF1.slide2.get())))

    return outString

def runSimSmolSno(inp, meltBool):
    inp = float(inp)
    outString = []

    outString.append('Your snowman has volume (m^3)')
    outString.append('Your snowman has mass (kg)')
    outString.append('Diameter of largest initial snowball (m)')
    outString.append('Sheet thickness to add to largest snowball (m)')
    outString.append('Cumulative distance to snowballs (m)')

    if meltBool:
        outString.append('Melting time at 10°C (in days)')

    outString.append(str(calcVolSmolSno(inp)) +' m^3')
    outString.append(str(calcVolSmolSno(inp)*fromCSV['density_const']) +' kg')
    outString.append(str(getIballSize()) +' m')
    outString.append(str(getSheetSize(inp)) +' m')
    outString.append(str(getRodistSize(inp, getIballSize(), fromCSV['density_const'])) +' m')

    if meltBool:
        outString.append(str(calcMelt(calcVolSmolSno(inp), runtimeF1.slide2.get())))

    return outString

def runSimBigSno(inp, meltBool):
    inp = float(inp)
    outString = []

    outString.append('Your snowman has volume (m^3)')
    outString.append('Your snowman has mass (kg)')
    outString.append('Diameter of largest initial snowball (m)')
    outString.append('Sheet thickness to add to largest snowball (m)')
    outString.append('Cumulative distance to snowballs (m)')

    if meltBool:
        outString.append('Melting time at 10°C (in days)')

    outString.append(str(calcVolBigSno(inp)))
    outString.append(str(calcVolBigSno(inp)*fromCSV['density_const']))
    outString.append(str(getIballSize()))
    outString.append(str(getSheetSize(inp)))
    outString.append(str(getRodistSize(inp, getIballSize(), fromCSV['density_const'])))

    if meltBool:
        outString.append(str(calcMelt(calcVolBigSno(inp), runtimeF1.slide2.get())))

    return outString

def raise_frame(frame): #Raising a frame so it can be seen
    frame.tkraise()

def Humourtexts():  #Import tips from file, store in list
    tips = []
    with open('tips.txt', 'r') as tipsfile:
        for line in tipsfile:
            tips.append(line)
    randnum = randint(0, int(len(tips)-1))
    return str(tips[randnum])

def calcMelt(volume, temp):
    aSum = runtimeF1.c4Record.get() + runtimeF1.c5Record.get() + runtimeF1.c6Record.get() + runtimeF1.c7Record.get() + runtimeF1.c8Record.get()
    aSum += runtimeF1.c9Record.get()
    aSum = (aSum+1)/3
    melttime = (volume - temp*20)*aSum/180
    return melttime

def calcPolse(energy):
    return energy/156

#Defining classes (OOP)
class entriesF1(object): #For the interactivity in Frame 1 (Home)
    """For the interactivity in Frame 1 (Home)"""
    def __init__(self):
        label1 = Label(f1, text='Wanted height of snowman/-ball: (m)') #Diameter
        label1.grid(row=3, column=0, columnspan=2, sticky=E)
        self.slide1 = Scale(f1, from_=1, to=15, orient=HORIZONTAL)
        self.slide1.grid(row=3, column=2)
        label2 = Label(f1, text='Temperature of snow: (°C)') #Temperature
        label2.grid(row=4, column=0, columnspan=2, sticky=E)
        self.slide2 = Scale(f1, from_=-1, to=-30, orient=HORIZONTAL)
        self.slide2.grid(row=4, column=2)
        label2 = Label(f1, text='Max. force exerted (hands): (N)') #Strength of your hands
        label2.grid(row=5, column=0, columnspan=2, sticky=E)
        self.slide3 = Scale(f1, from_=10, to=400, orient=HORIZONTAL)
        self.slide3.grid(row=5, column=2)
        label2 = Label(f1, text='Max. force exerted (body): (N)') #Strength of your body
        label2.grid(row=6, column=0, columnspan=2, sticky=E)
        self.slide4 = Scale(f1, from_=100, to=1500, orient=HORIZONTAL)
        self.slide4.grid(row=6, column=2)
        execute1 = Button(f1, text='Execute', command = self.propagateMessage, width = 16) #Execute all
        execute1.grid(row=7, column=2)
        label3 = Label(f1, text=Humourtexts(), font=tkfont.Font(slant='italic', size=10)) #Strength of your body
        label3.grid(row=21, column=0, columnspan=3)

        self.wannaPhysiology = IntVar()
        c1 = Checkbutton(f1,text='Show energy and time', variable=self.wannaPhysiology, command=self.ifPolse)
        c1.grid(row=7, column=0)

        #For Frame 3, check if you want to record
        self.wannaRecord = IntVar() #Int replacement for boolean of Checkbutton
        c2 = Checkbutton(f3, text='Store data on snowmen built', variable=self.wannaRecord) #Checkbutton
        c2.grid(row=3, column=1)

        #For Frame 3, check which snowman type
        label10 = Label(f3, text='Shape of construction (affects volume)') #Strength of your body
        label10.grid(row=4, column=0, columnspan=2, sticky=E)
        self.snowOption = IntVar() #Int replacement: find out radio button Value
        radio1 = Radiobutton(f3, text='Standard ball', variable=self.snowOption, value=1)
        radio1.grid(row=4, column=2, sticky=W)
        radio2 = Radiobutton(f3, text='Small snowman (2 balls)', variable=self.snowOption, value=2)
        radio2.grid(row=5, column=2, sticky=W)
        radio3 = Radiobutton(f3, text='Large snowman (3 balls)', variable=self.snowOption, value=3)
        radio3.grid(row=6, column=2, sticky=W)
        radio1.select()

        #Check energy use efficiency
        self.moveOption = IntVar()
        label11 = Label(f3, text='Efficiency of movement (affects energy use)') #Strength of your body
        label11.grid(row=7, column=0, columnspan=2, sticky=E)
        radio4 = Radiobutton(f3, text='Very Efficient', variable=self.moveOption, value=1)
        radio4.grid(row=7, column=2, sticky=W)
        radio5 = Radiobutton(f3, text='Efficient', variable=self.moveOption, value=2)
        radio5.grid(row=8, column=2, sticky=W)
        radio6 = Radiobutton(f3, text='Average', variable=self.moveOption, value=3)
        radio6.grid(row=9, column=2, sticky=W)
        radio7 = Radiobutton(f3, text='Below Average', variable=self.moveOption, value=4)
        radio7.grid(row=10, column=2, sticky=W)
        radio6.select()

        #For Frame 3, check if you want extra melt options
        self.boolMeltos = False
        c3 = Button(f3, text='Enable melting calculations', command=self.extramelt) #Checkbutton
        c3.grid(row=11, column=0, columnspan=3)

    def ifPolse(self):
        if self.wannaPhysiology.get(): #If user wants to have Pølse
            self.wannaPolse = IntVar()
            self.c4 = Checkbutton(f1,text='Show in terms of Pølse', variable=self.wannaPolse)
            self.c4.grid(row=7, column=1)
        else: #Or remove
            self.c4.grid_remove()
            self.label9.grid_remove()
            self.label10.grid_remove()


    def extramelt(self):
        if self.boolMeltos == False: #Show if not shown yet
            self.c4Record = IntVar()
            self.c4 = Checkbutton(f3, text='Is in shade', var=self.c4Record) #Checkbutton
            self.c4.grid(row=12, column=0, sticky=W)
            self.c5Record = IntVar()
            self.c5 = Checkbutton(f3, text='On a slope', var=self.c5Record) #Checkbutton
            self.c5.grid(row=12, column=1, sticky=W)
            self.c6Record = IntVar()
            self.c6 = Checkbutton(f3, text='Away from houses', var=self.c6Record) #Checkbutton
            self.c6.grid(row=12, column=2, sticky=W)
            self.c7Record = IntVar()
            self.c7 = Checkbutton(f3, text='Close to forest', var=self.c7Record) #Checkbutton
            self.c7.grid(row=13, column=0, sticky=W)
            self.c8Record = IntVar()
            self.c8 = Checkbutton(f3, text='Windy area', var=self.c8Record) #Checkbutton
            self.c8.grid(row=13, column=1, sticky=W)
            self.c9Record = IntVar()
            self.c9 = Checkbutton(f3, text='Cool sunglasses', var=self.c9Record) #Checkbutton
            self.c9.grid(row=13, column=2, sticky=W)

            self.boolMeltos = True
        else: #If already shown, remove
            for row in range(12,14):
                for widget in f3.grid_slaves(row=row):
                    widget.grid_remove()
            self.boolMeltos = False

    def propagateMessage(self):
        if self.snowOption.get() == 1: #Check which snowman type
            self.showRmessage()
        elif self.snowOption.get() == 2:
            self.showRmessageSmolSno()
        elif self.snowOption.get() == 3:
            self.showRmessageBigSno()

        if self.wannaPhysiology.get():
            label5 = Label(f1, text='Estimated time to push balls (s)') #Strength of your body
            label5.grid(row=18, column=0, columnspan=2, sticky=W)
            label6 = Label(f1, text=str(calcTime(float(self.slide1.get()), float(self.slide4.get())))[0:6]) #Strength of your body
            label6.grid(row=18, column=2, sticky=W)
            label7 = Label(f1, text='Estimated calories burnt (kcal)') #Strength of your body
            label7.grid(row=19, column=0, columnspan=2, sticky=W)
            label8 = Label(f1, text=str(calcEnergy(calcTime(float(self.slide1.get()), float(self.slide4.get()))))[0:6]) #Strength of your body
            label8.grid(row=19, column=2, sticky=W)

        if self.wannaPolse.get():
            self.label9 = Label(f1, text='Calories in Pølse sausage servings')
            self.label9.grid(row=20, column=0, columnspan=2, sticky=W)
            self.label10 = Label(f1, text=str(calcPolse(calcEnergy(calcTime(float(self.slide1.get()), float(self.slide4.get())))))[0:6])
            self.label10.grid(row=20, column=2, sticky=W)

    def showRmessage(self):
        for i in range(8,100): #Deletes all content except the title and nav buttons
            for widget in f1.grid_slaves(row=i):
                widget.grid_remove()

        if str(self.slide2.get()): #Check if there is an entry, then change fromCSV entry
            fromCSV['temp_coef'] = float(self.slide2.get())
        else:
            pass
        if str(self.slide3.get()): #Same
            fromCSV['handstrength_coef'] = float(self.slide3.get())
        else:
            pass
        if str(self.slide4.get()): #Same
            fromCSV['bodystrength_coef'] = float(self.slide4.get())
        else:
            pass

        listLength = len(runSim(self.slide1.get(), self.boolMeltos)) #Find length of list outputted (half of that gives the number of rows needed to display)
        listItself = runSim(self.slide1.get(), self.boolMeltos)
        for x in range(0, int(listLength/2)): #Names
            iters = Label(f1, text=str(listItself[x]))
            iters.grid(row=(9+x), column=0, columnspan=2, sticky=W)
        for x in range(int(listLength/2), listLength): #Values
            iters = Label(f1, text=str(listItself[x])[0:6])
            iters.grid(row=(9+x-int(listLength/2)), column=2, sticky=W)

        if self.wannaRecord.get() == 1:
            with open('NameRun.csv', 'a') as csvfile: #Write to file: Distance pushed
                    toprint = str(listItself[9])[0:4]
                    csvfile.write(toprint+'\n')
        else:
            pass

    def showRmessageSmolSno(self):
        for i in range(8,15): #Deletes all content except the title and nav buttons
            for widget in f1.grid_slaves(row=i):
                widget.grid_remove()

        for i in range(17,100): #Deletes all content except the title and nav buttons
            for widget in f1.grid_slaves(row=i):
                widget.grid_remove()

        for i in range(8,100): #Deletes all content except the title and nav buttons
            for widget in f1.grid_slaves(row=i):
                widget.grid_remove()

        if str(self.slide2.get()): #Check if there is an entry, then change fromCSV entry
            fromCSV['temp_coef'] = float(self.slide2.get())
        else:
            pass
        if str(self.slide3.get()): #Same
            fromCSV['handstrength_coef'] = float(self.slide3.get())
        else:
            pass
        if str(self.slide4.get()): #Same
            fromCSV['bodystrength_coef'] = float(self.slide4.get())
        else:
            pass

        if str(self.slide2.get()): #Check if there is an entry, then change fromCSV entry
            fromCSV['temp_coef'] = float(self.slide2.get())
        else:
            pass
        if str(self.slide3.get()): #Same
            fromCSV['handstrength_coef'] = float(self.slide3.get())
        else:
            pass
        if str(self.slide4.get()): #Same
            fromCSV['bodystrength_coef'] = float(self.slide4.get())
        else:
            pass

        listLength = len(runSimSmolSno(self.slide1.get(), self.boolMeltos)) #Find length of list outputted (half of that gives the number of rows needed to display)
        listItself = runSimSmolSno(self.slide1.get(), self.boolMeltos)
        for x in range(0, int(listLength/2)): #Names
            iters = Label(f1, text=listItself[x])
            iters.grid(row=(9+x), column=0, columnspan=2, sticky=W)
        for x in range(int(listLength/2), listLength): #Values
            iters = Label(f1, text=str(listItself[x])[0:6])
            iters.grid(row=(9+x-int(listLength/2)), column=2, sticky=W)

        if self.wannaRecord.get() == 1:
            with open('NameRun.csv', 'a') as csvfile: #Write to file: Distance pushed
                    toprint = str(listItself[9])[0:4]
                    csvfile.write(toprint+'\n')
        else:
            pass

    def showRmessageBigSno(self):
        for i in range(8,100): #Deletes all content except the title and nav buttons
            for widget in f1.grid_slaves(row=i):
                widget.grid_remove()

        if str(self.slide2.get()): #Check if there is an entry, then change fromCSV entry
            fromCSV['temp_coef'] = float(self.slide2.get())
        else:
            pass
        if str(self.slide3.get()): #Same
            fromCSV['handstrength_coef'] = float(self.slide3.get())
        else:
            pass
        if str(self.slide4.get()): #Same
            fromCSV['bodystrength_coef'] = float(self.slide4.get())
        else:
            pass

        if str(self.slide2.get()): #Check if there is an entry, then change fromCSV entry
            fromCSV['temp_coef'] = float(self.slide2.get())
        else:
            pass
        if str(self.slide3.get()): #Same
            fromCSV['handstrength_coef'] = float(self.slide3.get())
        else:
            pass
        if str(self.slide4.get()): #Same
            fromCSV['bodystrength_coef'] = float(self.slide4.get())
        else:
            pass

        listLength = len(runSimBigSno(self.slide1.get(), self.boolMeltos)) #Find length of list outputted (half of that gives the number of rows needed to display)
        listItself = runSimBigSno(self.slide1.get(), self.boolMeltos)
        for x in range(0, int(listLength/2)): #Names
            iters = Label(f1, text=listItself[x])
            iters.grid(row=(9+x), column=0, columnspan=2, sticky=W)
        for x in range(int(listLength/2), listLength): #Values
            iters = Label(f1, text=str(listItself[x])[0:6])
            iters.grid(row=(9+x-int(listLength/2)), column=2, sticky=W)

        if self.wannaRecord.get() == 1:
            with open('NameRun.csv', 'a') as csvfile: #Write to file: Distance pushed
                    toprint = str(listItself[9])[0:4]
                    csvfile.write(toprint+'\n')
        else:
            pass

class entriesF2(object): #For the interactivity in Frame 2 (Logs)
    """For the interactivity for F2 (Logs)"""
    def __init__(self):
          execute1 = Button(f2, text='Create Histogram', command = self.matplotlibSHOW, width = 16) #Execute all
          execute1.grid(row=3, column=2)
          execute2 = Button(f2, text='Delete History', command = self.deleteLog, width = 16) #Execute all
          execute2.grid(row=3, column=0)

    def matplotlibSHOW(self): #Show histogram of distance rolled
        distance_rolled = []
        frequency = [0, 5, 10, 15, 20, 25, 30, 35, 40, 50, 60, 70, 80, 90, 100, 120, 140, 160]

        with open('NameRun.csv', 'r') as csvfile:
            for line in csvfile:
                distance_rolled.append(float(line))

        plt.hist(distance_rolled, frequency, histtype='bar', rwidth=0.8)

        plt.xlabel('Distance rolled (m)')
        plt.ylabel('Frequency')
        plt.title('Snowman statistics')

        plt.show()

    def deleteLog(self):
        open('NameRun.csv', 'w').close()

class entriesF3(object): #interactivity for F3 (Options)
    """For the interactivity in F3 (Options)"""
    def __init__(self):
        self.bla = 123

class entriesF4(object): #interactivity for F4 (Information)
    """For the interactivity in F4 (Information)"""
    def __init__(self):
        with open('infotext.txt', 'r') as itxt:
            infotext = itxt.read()
        text1 = Text(f4, wrap=WORD)
        text1.insert(INSERT, infotext)
        text1.grid(row=3, columnspan=3, column=0)


#Declaring Tkinter essentials
root = Tk()
root.geometry('600x500')
root.title('Snowman and -ball tool')

#Making fs part of the program
f1 = Frame(root)
f2 = Frame(root)
f3 = Frame(root)
f4 = Frame(root)

for frame in (f1, f2, f3, f4):
    frame.grid(row=0, column=0, sticky='news')

#Frame 1, Home
Button(f1, text='Logs', command=lambda:raise_frame(f2), width=15).grid(row=1,column=0)
Button(f1, text='Options', command=lambda:raise_frame(f3), width=15).grid(row=1,column=1)
Button(f1, text='Information', command=lambda:raise_frame(f4), width=15).grid(row=1,column=2)
Label(f1, text='Start', font=tkfont.Font(family='Helvetica', size=18, weight='bold')).grid(row=0, column=0, columnspan=3)

runtimeF1 = entriesF1() #Start OOP thingy to ACTUALLY FUCKING MAKE IT WORK EVEN THO IT IS BOTH FUNC AND OOP

#Frame 2, Logs
Button(f2, text='Start', command=lambda:raise_frame(f1), width=15).grid(row=1,column=0)
Button(f2, text='Options', command=lambda:raise_frame(f3), width=15).grid(row=1,column=1)
Button(f2, text='Information', command=lambda:raise_frame(f4), width=15).grid(row=1,column=2)
Label(f2, text='Logs', font=tkfont.Font(family='Helvetica', size=18, weight='bold')).grid(row=0, column=0, columnspan=3)

runtimeF2 = entriesF2()

#Frame 3, Options
Button(f3, text='Start', command=lambda:raise_frame(f1), width=15).grid(row=1,column=0)
Button(f3, text='Logs', command=lambda:raise_frame(f2), width=15).grid(row=1,column=1)
Button(f3, text='Information', command=lambda:raise_frame(f4), width=15).grid(row=1,column=2)
Label(f3, text='Options', font=tkfont.Font(family='Helvetica', size=18, weight='bold')).grid(row=0, column=0, columnspan=3)

runtimeF3 = entriesF3()

#Frame 4, Information
Button(f4, text='Start', command=lambda:raise_frame(f1), width=15).grid(row=1,column=0)
Button(f4, text='Logs', command=lambda:raise_frame(f2), width=15).grid(row=1,column=1)
Button(f4, text='Information', command=lambda:raise_frame(f3), width=15).grid(row=1,column=2)
Label(f4, text='Information', font=tkfont.Font(family='Helvetica', size=18, weight='bold')).grid(row=0, column=0, columnspan=3)

runtimeF4 = entriesF4()


#Starting the program
raise_frame(f1)
root.mainloop()
