/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.internal.ShaderGenerators;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/openrndr/internal/gl3/ShaderGeneratorsGL3;", "Lorg/openrndr/internal/ShaderGenerators;", "()V", "circleFragmentShader", "", "shadeStructure", "Lorg/openrndr/draw/ShadeStructure;", "circleVertexShader", "expansionFragmentShader", "expansionVertexShader", "fastLineFragmentShader", "fastLineVertexShader", "fontImageMapFragmentShader", "fontImageMapVertexShader", "imageFragmentShader", "imageVertexShader", "rectangleFragmentShader", "rectangleVertexShader", "vertexBufferFragmentShader", "vertexBufferVertexShader", "openrndr-gl3"})
public final class ShaderGeneratorsGL3
implements ShaderGenerators {
    @Override
    @NotNull
    public String vertexBufferFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nuniform sampler2D image;\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getOutputs();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\n\n\nout vec4 o_color;\n\n");
        String string4 = shadeStructure.getFragmentPreamble();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\nflat in int v_instance;\n\n\nvoid main(void) {\n    vec2 c_screenPosition = gl_FragCoord.xy;\n    float c_contourPosition = 0.0;\n    vec4 x_fill = u_fill;\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string5 = shadeStructure.getFragmentTransform();
        if (string5 == null) {
            string5 = "";
        }
        return StringsKt.trimMargin$default(stringBuilder5.append(string5).append("\n    }\n    o_color = x_fill;\n    o_color.rgb *= o_color.a;\n}\n    ").toString(), null, 1, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String vertexBufferVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\n\n\n");
        String string4 = shadeStructure.getVertexPreamble();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n\nflat out int v_instance;\nvoid main() {\n\n    int instance = gl_InstanceID;\n    ");
        String string5 = shadeStructure.getVaryingBridge();
        if (string5 == null) {
            string5 = "";
        }
        String string6 = shadeStructure.getAttributes();
        StringBuilder stringBuilder6 = stringBuilder5.append(string5).append("\n\n    vec3 x_normal = vec3(0.0, 0.0, 0.0);\n\n    ").append(string6 != null && StringsKt.contains$default((CharSequence)string6, "vec3 a_normal;", false, 2, null) ? "x_normal = a_normal;" : "").append("\n\n    vec3 x_position = a_position;\n\n\n    \nmat4 x_modelMatrix = u_modelMatrix;\nmat4 x_viewMatrix = u_viewMatrix;\nmat4 x_modelNormalMatrix = u_modelNormalMatrix;\nmat4 x_viewNormalMatrix = u_viewNormalMatrix;\nmat4 x_projectionMatrix = u_projectionMatrix;\n\n    {\n        ");
        String string7 = shadeStructure.getVertexTransform();
        if (string7 != null) {
            return StringsKt.trimMargin$default(stringBuilder6.append(string7).append("\n    }\n    \nv_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\nv_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\nv_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\nv_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\nv_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n\n\n    v_instance = instance;\n    gl_Position = v_clipPosition;\n}\n            ").toString(), null, 1, null);
        }
        string7 = "";
        return StringsKt.trimMargin$default(stringBuilder6.append(string7).append("\n    }\n    \nv_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\nv_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\nv_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\nv_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\nv_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n\n\n    v_instance = instance;\n    gl_Position = v_clipPosition;\n}\n            ").toString(), null, 1, null);
    }

    @Override
    @NotNull
    public String imageFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\n\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nuniform sampler2D image;\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\n\nout vec4 o_color;\n\nvec4 colorTransform(vec4 color, float[25] matrix) {\n    float r = color.r * matrix[0] + color.g * matrix[5] + color.b * matrix[10] + color.a * matrix[15] + matrix[20];\n    float g = color.r * matrix[1] + color.g * matrix[6] + color.b * matrix[11] + color.a * matrix[16] + matrix[21];\n    float b = color.r * matrix[2] + color.g * matrix[7] + color.b * matrix[12] + color.a * matrix[17] + matrix[22];\n    float a = color.r * matrix[3] + color.g * matrix[8] + color.b * matrix[13] + color.a * matrix[18] + matrix[23];\n    return vec4(r, g, b, a);\n}\n\nvoid main(void) {\n    vec2 c_screenPosition = gl_FragCoord.xy;\n    float c_contourPosition = 0.0;\n    vec4 x_fill = texture(image, va_texCoord0);\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string3 = shadeStructure.getFragmentTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append("\n    }\n    x_fill = colorTransform(x_fill, u_colorMatrix);\n\n    o_color = x_fill;\n}").toString();
    }

    @Override
    @NotNull
    public String imageVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("\n#version 330\n\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nvoid main() {\n\n    ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n\n\n    \nmat4 x_modelMatrix = u_modelMatrix;\nmat4 x_viewMatrix = u_viewMatrix;\nmat4 x_modelNormalMatrix = u_modelNormalMatrix;\nmat4 x_viewNormalMatrix = u_viewNormalMatrix;\nmat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = a_normal;\n    vec3 x_position = a_position;\n    {\n        ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    \nv_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\nv_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\nv_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\nv_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\nv_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n\n    gl_Position = v_clipPosition;\n}\n").toString();
    }

    @Override
    @NotNull
    public String circleFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\n\n\nout vec4 o_color;\n\nvoid main(void) {\n    vec2 c_screenPosition = gl_FragCoord.xy;\n    float c_contourPosition = 0.0;\n    vec4 x_fill = u_fill;\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string3 = shadeStructure.getFragmentTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append("\n    }\n    float wd = fwidth(length(va_texCoord0 - vec2(0.5)));\n    float d = length(va_texCoord0 - vec2(0.5)) * 2;\n\n    float or = smoothstep(0, wd * 4.5, 1.0 - d);\n    float b = u_strokeWeight / vi_radius;\n    float ir = smoothstep(0, wd * 4.5, 1.0 - b - d);\n\n    o_color.rgb =  x_stroke.rgb;\n    o_color.a = or * (1.0 - ir) * x_stroke.a;\n    o_color.rgb *= o_color.a;\n\n    o_color.rgb += x_fill.rgb * ir * x_fill.a;\n    o_color.a += ir * x_fill.a;\n}\n        ").toString();
    }

    @Override
    @NotNull
    public String circleVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\n\nvoid main() {\n\n    ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n\n    \nmat4 x_modelMatrix = u_modelMatrix;\nmat4 x_viewMatrix = u_viewMatrix;\nmat4 x_modelNormalMatrix = u_modelNormalMatrix;\nmat4 x_viewNormalMatrix = u_viewNormalMatrix;\nmat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = a_normal;\n    vec3 x_position = a_position * i_radius + i_offset;\n    {\n        ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    va_position = x_position;\n    \nv_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\nv_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\nv_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\nv_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\nv_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n\n    gl_Position = v_clipPosition;\n}\n    ").toString();
    }

    @Override
    @NotNull
    public String fontImageMapFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nuniform sampler2D image;\nflat in int v_instance;\n\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\n\n\nout vec4 o_color;\n\nvoid main(void) {\n    vec2 c_screenPosition = gl_FragCoord.xy;\n    float c_contourPosition = 0.0;\n    int instance = v_instance;\n    vec3 boundsPosition = vec3(va_bounds.xy, 0.0);\n    vec3 boundsSize = vec3(va_bounds.zw, 0.0);\n\n    float imageMap = texture(image, va_texCoord0).r;\n    vec4 x_fill = u_fill; // imageMap;\n    x_fill.a *= imageMap;\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string3 = shadeStructure.getFragmentTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append("\n    }\n    o_color = x_fill;\n    o_color.rgb *= o_color.a;\n}\n").toString();
    }

    @Override
    @NotNull
    public String fontImageMapVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out int v_instance;\n\nvoid main() {\n    vec3 decodedPosition = vec3(a_position.xy, 0.0);\n    v_instance = int(a_position.z);\n\n    ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n    \nmat4 x_modelMatrix = u_modelMatrix;\nmat4 x_viewMatrix = u_viewMatrix;\nmat4 x_modelNormalMatrix = u_modelNormalMatrix;\nmat4 x_viewNormalMatrix = u_viewNormalMatrix;\nmat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = vec3(0.0, 0.0, 1.0);\n    vec3 x_position = decodedPosition;\n    {\n        ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    \nv_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\nv_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\nv_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\nv_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\nv_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n\n    gl_Position = v_clipPosition;\n}\n            ").toString();
    }

    @Override
    @NotNull
    public String rectangleFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\n\n\nout vec4 o_color;\n\nvoid main(void) {\n    vec2 c_screenPosition = gl_FragCoord.xy;\n    float c_contourPosition = 0.0;\n    vec4 x_fill = u_fill;\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string3 = shadeStructure.getFragmentTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append("\n    }\n    vec2 wd = fwidth(va_texCoord0 - vec2(0.5));\n    vec2 d = abs((va_texCoord0 - vec2(0.5)) * 2);\n\n    float irx = smoothstep(0.0, wd.x * 2.5, 1.0-d.x - u_strokeWeight*2.0/vi_dimensions.x);\n    float iry = smoothstep(0.0, wd.x * 2.5, 1.0-d.y - u_strokeWeight*2.0/vi_dimensions.y);\n\n    float ir = irx*iry;\n\n\n    o_color.rgb = x_fill.rgb * x_fill.a;\n    o_color.a = x_fill.a;\n\n    float sa = (1.0-ir) * x_stroke.a;\n    o_color.rgb = o_color.rgb * (1.0-sa) + x_stroke.rgb * sa;\n    o_color.a = o_color.a * (1.0-sa) + sa;\n}\n        ").toString();
    }

    @Override
    @NotNull
    public String rectangleVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('\n');
        String string3 = shadeStructure.getVaryingOut();
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\n\nvoid main() {\n    ");
        String string4 = shadeStructure.getVaryingBridge();
        if (string4 == null) {
            string4 = "";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append("\n    \nmat4 x_modelMatrix = u_modelMatrix;\nmat4 x_viewMatrix = u_viewMatrix;\nmat4 x_modelNormalMatrix = u_modelNormalMatrix;\nmat4 x_viewNormalMatrix = u_viewNormalMatrix;\nmat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = vec3(0.0, 0.0, 1.0);\n    vec3 x_position = a_position * vec3(i_dimensions,1.0) + i_offset;\n    {\n        ");
        String string5 = shadeStructure.getVertexTransform();
        if (string5 == null) {
            string5 = "";
        }
        return stringBuilder5.append(string5).append("\n    }\n    \nv_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\nv_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\nv_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\nv_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\nv_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n\n    gl_Position = v_clipPosition;\n    }\n    ").toString();
    }

    @Override
    @NotNull
    public String expansionFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\n\n\nuniform float strokeMult;\nuniform float strokeThr;\nuniform float strokeFillFactor;\n\nuniform sampler2D tex;\nuniform vec4 bounds;\n\nin vec3 v_objectPosition;\n\nin vec2 v_ftcoord;\n\nout vec4 o_color;\n\nfloat strokeMask() {\n\treturn min(1.0, (1.0-abs(v_ftcoord.x*2.0-1.0))*strokeMult) * min(1.0, v_ftcoord.y);\n}\n\nvoid main(void) {\n    vec2 c_screenPosition = gl_FragCoord.xy;\n    vec3 c_boundsPosition = vec3(v_objectPosition.xy - bounds.xy, 0.0) / vec3(bounds.zw,1.0);\n    vec3 c_boundsSize = vec3(bounds.zw, 0.0);\n\n    float c_contourPosition = va_vertexOffset;\n\tfloat strokeAlpha = strokeMask();\n\n    vec4 x_stroke = u_stroke;\n    vec4 x_fill = u_fill;\n\n    { ");
        String string3 = shadeStructure.getFragmentTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append(" }\n\n    vec4 color = mix(x_stroke, x_fill, strokeFillFactor)  * vec4(1, 1, 1, strokeAlpha);\n    vec4 result = color;\n\n    if (strokeAlpha < strokeThr) {\n\t    discard;\n\t}\n\n\to_color = result;\n\to_color.rgb *= o_color.a;\n}\n        ").toString();
    }

    @Override
    @NotNull
    public String expansionVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n\n").append(shadeStructure.getAttributes()).append('\n');
        String string = shadeStructure.getVaryingOut();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\n\nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\n\nout vec2 v_ftcoord;\nout float v_offset;\n\nout vec3 v_objectPosition;\n\nvoid main() {\n    ");
        String string2 = shadeStructure.getVaryingBridge();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n    v_objectPosition = vec3(a_position, 0.0);\n    v_ftcoord = a_texCoord0;\n\n    vec3 x_position = vec3(a_position, 0.0);\n    vec3 x_normal = vec3(0.0, 0.0, 1.0);\n    \nmat4 x_modelMatrix = u_modelMatrix;\nmat4 x_viewMatrix = u_viewMatrix;\nmat4 x_modelNormalMatrix = u_modelNormalMatrix;\nmat4 x_viewNormalMatrix = u_viewNormalMatrix;\nmat4 x_projectionMatrix = u_projectionMatrix;\n\n    {\n        ");
        String string3 = shadeStructure.getVertexTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append("\n    }\n    \nv_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\nv_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\nv_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\nv_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\nv_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n\n\n    gl_Position = v_clipPosition;\n}\n").toString();
    }

    @Override
    @NotNull
    public String fastLineFragmentShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n");
        String string = shadeStructure.getUniforms();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("\nlayout(origin_upper_left) in vec4 gl_FragCoord;\n\nuniform sampler2D image;\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n");
        String string2 = shadeStructure.getVaryingIn();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\n\nout vec4 o_color;\n\nvoid main(void) {\n    vec2 c_screenPosition = gl_FragCoord.xy;\n    float c_contourPosition = 0.0;\n    vec4 x_fill = u_fill;\n    vec4 x_stroke = u_stroke;\n    {\n        ");
        String string3 = shadeStructure.getFragmentTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append("\n    }\n    o_color = x_fill;\n}\n        ").toString();
    }

    @Override
    @NotNull
    public String fastLineVertexShader(@NotNull ShadeStructure shadeStructure) {
        Intrinsics.checkParameterIsNotNull(shadeStructure, "shadeStructure");
        StringBuilder stringBuilder = new StringBuilder().append("#version 330\n\nuniform mat4 u_modelNormalMatrix;\nuniform mat4 u_modelMatrix;\nuniform mat4 u_normalMatrix; // will be deleted soon\nuniform mat4 u_viewNormalMatrix;\nuniform mat4 u_viewMatrix;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewProjectionMatrix; // will be deleted soon\nuniform vec4 u_fill;\nuniform vec4 u_stroke;\nuniform float u_strokeWeight;\nuniform float[25] u_colorMatrix;\n\n\n");
        String string = shadeStructure.getAttributes();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\n');
        String string2 = shadeStructure.getUniforms();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append("\n\nvoid main() {\n\n    \nmat4 x_modelMatrix = u_modelMatrix;\nmat4 x_viewMatrix = u_viewMatrix;\nmat4 x_modelNormalMatrix = u_modelNormalMatrix;\nmat4 x_viewNormalMatrix = u_viewNormalMatrix;\nmat4 x_projectionMatrix = u_projectionMatrix;\n\n    vec3 x_normal = vec3(0.0, 0.0, 1.0);\n    vec3 x_position = a_position;\n    {\n        ");
        String string3 = shadeStructure.getVertexTransform();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append("\n    }\n    \nv_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\nv_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\nv_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\nv_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\nv_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n\n    gl_Position = v_clipPosition;\n}\n        ").toString();
    }
}

