/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public abstract class CustomBuffer<SELF extends CustomBuffer<SELF>>
implements Pointer {
    protected long address;
    @Nullable
    protected ByteBuffer container;
    protected int mark;
    protected int position;
    protected int limit;
    protected int capacity;

    protected CustomBuffer(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
        if (Checks.CHECKS) {
            Checks.check(address);
        }
        this.address = address;
        this.container = container;
        this.mark = mark;
        this.position = position;
        this.limit = limit;
        this.capacity = capacity;
    }

    public abstract int sizeof();

    public long address0() {
        return this.address;
    }

    @Override
    public long address() {
        return this.address(this.position());
    }

    public long address(int position) {
        return this.address + (long)position * (long)this.sizeof();
    }

    public void free() {
        MemoryUtil.nmemFree(this.address0());
    }

    public int capacity() {
        return this.capacity;
    }

    public int position() {
        return this.position;
    }

    public SELF position(int newPosition) {
        if (newPosition > this.limit || newPosition < 0) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this.self();
    }

    public int limit() {
        return this.limit;
    }

    public SELF limit(int newLimit) {
        if (newLimit > this.capacity || newLimit < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this.self();
    }

    public SELF mark() {
        this.mark = this.position;
        return this.self();
    }

    public SELF reset() {
        int m = this.mark;
        if (m < 0) {
            throw new InvalidMarkException();
        }
        this.position = m;
        return this.self();
    }

    public SELF clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this.self();
    }

    public SELF flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this.self();
    }

    public SELF rewind() {
        this.position = 0;
        this.mark = -1;
        return this.self();
    }

    public int remaining() {
        return this.limit - this.position;
    }

    public boolean hasRemaining() {
        return this.position < this.limit;
    }

    public SELF slice() {
        return this.newBufferInstance(this.address(), this.container, -1, 0, this.remaining(), this.remaining());
    }

    public SELF slice(int offset, int capacity) {
        if (offset < 0 || this.limit < this.position + offset) {
            throw new IllegalArgumentException();
        }
        if (capacity < 0 || this.capacity < this.position + offset + capacity) {
            throw new IllegalArgumentException();
        }
        return this.newBufferInstance(this.address() + (long)offset * (long)this.sizeof(), this.container, -1, 0, capacity, capacity);
    }

    public SELF duplicate() {
        return this.newBufferInstance(this.address, this.container, this.mark, this.position, this.limit, this.capacity);
    }

    public SELF put(SELF src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        int n2 = ((CustomBuffer)src).remaining();
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        MemoryUtil.memCopy(((CustomBuffer)src).address(), this.address(), (long)n2 * (long)this.sizeof());
        this.position += n2;
        return this.self();
    }

    public SELF compact() {
        MemoryUtil.memCopy(this.address(), this.address, (long)this.remaining() * (long)this.sizeof());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.mark = -1;
        return this.self();
    }

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    protected abstract SELF self();

    protected abstract SELF newBufferInstance(long var1, @Nullable ByteBuffer var3, int var4, int var5, int var6, int var7);

    protected long nextGetIndex() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.position++;
    }

    protected long nextPutIndex() {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        return this.position++;
    }

    protected long checkIndex(int index) {
        if (index < 0 || this.limit < index) {
            throw new IndexOutOfBoundsException();
        }
        return index;
    }
}

