; confetti
; ========
; 
; a 512 byte intro for Nordlicht 2018
; by Gasman / Hooy-Program

	org 0x8000

	call 3435 ; cls

; unpack a list of 16 line lengths into a solid circle bitmap

	ld de,circledata
	ld hl,circlesprite + 64 ; 16-line margin above and below

	ld b,16
circlerowlp1
	call circleline
	inc de
	djnz circlerowlp1

	ld b,16
circlerowlp2
	dec de
	call circleline
	djnz circlerowlp2

; populate stripe data
	ld hl,stripes
genstripelp
	call set_colour_stripe
	inc l
	jr nz,genstripelp

; set up interrupts
	ld hl,0xbe00
	ld de,0xbe01
	ld (hl),0xbf
	ld bc,0x0101
	ldir
	ld a,0xc3 ; JP
	ld (0xbfbf),a
	ld hl,interrupt
	ld (0xbfc0),hl

	ld a,0xbe
	ld i,a
	im 2
stop
	halt
	jr stop

circleline
	ld a,(de)
	call circleleft
	call circleleft
	call circleright
	call circleright
	ret

circleleft
	ld (hl),1
byte1lp
	inc a
	cp 128
	rl (hl)
	jr nc,byte1lp
	inc l
	ret

circleright
	ld (hl),1
byte3lp
	cp 128
	rl (hl)
	dec a
	jr nc,byte3lp
	inc l
	ret

interrupt

curr_circle_pos
	ld de,0x400f
curr_circle_mask
	ld bc,0x0202
curr_circle_offset
	ld hl,circlesprite + 32

drawcircle
	exx
	ld b,48
drawcirclelp
	push bc
	exx

	ld a,d
	and b
	xor c
	jp pe,no_mask_circle

	ld a,l
	add a,4
	ld l,a
	jp resume_after_mask

no_mask_circle
	push bc
	ldi
	ldi
	ldi
	ldi
	pop bc

	dec e
	dec e
	dec e
	dec e

resume_after_mask
	call upde
	exx
	pop bc
	djnz drawcirclelp

	ld bc,213
top_delay
	dec bc
	ld a,b
	or c
	jr nz,top_delay

	nop

	ld (spback+1),sp

	ld hl,stripes+140
	exx

	ld de,0x5800
	ld bc,0x0008
stripelp
	ld h,d
	ld a,e
	and 0xe0
	ld l,a
	ld c,0x10
	add hl,bc
	ld (sp_addr_1+1),hl
	add hl,bc
	ld (sp_addr_2+1),hl

	exx
	ld a,(hl)
	ld e,a
	ld d,a
	rrca
	rrca
	rrca
	and 0x07
	inc l

sp_addr_1
	ld sp,0x5810
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	out (254),a
sp_addr_2
	ld sp,0x5820
	push de
	push de
	push de
	push de
	push de
	push de
	push de
	push de

	; delay 32T
	cpi
	cpd

	exx
	ex de,hl
	ld c,0x08
	add hl,bc
	ex de,hl
	ld a,d
	cp 0x5b
	jp nz,stripelp

spback ld sp,0

	ld b,16
zzz1 djnz zzz1

	xor a
	out (254),a

curr_circle_index
	ld a,0
	inc a
	cp 12
	jr nz,no_reset_circle_index

	ld hl,phase+1
	inc (hl)

	xor a

no_reset_circle_index
	ld (curr_circle_index+1),a

	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	ld de,circlepositions
	add hl,de
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (curr_circle_pos+1),de
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (curr_circle_mask+1),de

phase
	add a,0
	and 0x0f

	ld l,a
	ld h,0
	ld de,sine
	add hl,de
	ld a,(hl)
	ld (curr_circle_offset+1),a

; play hum-wah noise
	ld hl,aydata
	ld a,11
ay_init_lp
	ld e,(hl)
	inc hl
	ld bc,0xfffd
	dec a
	out (c),a
	ld b,0xbf
	out (c),e
	jr nz,ay_init_lp


	; wait 255 frames before adding white stripe
prewhitestripe
	ld a,0
	dec a
	jr z,dowhitestripe
	ld (prewhitestripe+1),a
	ei
	ret

; add white stripe
; (DAH, DAN DAN DAN DAN DAAAAAH DAAAAAH)
dowhitestripe
whitestripepos
	ld hl,0
	inc hl

	res 1,h
	ld (whitestripepos+1),hl
	bit 0,h
	ld h,high stripes

	jr nz,whitestripe_up
	call noisy_set_colour_stripe

	ld a,l
	add a,24
	ld l,a
	ld (hl),0x07

	ei
	ret

whitestripe_up
	ld a,l
	cpl
	ld l,a
	ld (hl),0x07
	add a,24
	ld l,a
	call noisy_set_colour_stripe

	ei
	ret

upde
	inc d
	ld a,d
	and 7
	ret nz
	ld a,e
	add a,32
	ld e,a
	jr c,hacking_too_much_time  ; need to make the crossing-the-third-boundary and non-crossing cases take equal time
	ld a,d
	sub 8
	ld d,a
	ret

hacking_too_much_time
	; ld a,d / sub 8 / ld d,a takes 15T
	; minus the 5T from the jump => 10T
	inc ix
	ret

noisy_set_colour_stripe
	bit 7,l
	jr z,no_noise
; modify hum-wah noise
	ld a,l
	rra
	ld (aydata+8),a
	rra
	rra
	rra
	and 0x0f
	ld (aydata),a
	ld (aydata+1),a
no_noise

set_colour_stripe
	ld a,l
	and 0x03
	add a,a
	add a,a
	add a,a
	add a,0x0f
	ld (hl),a
	ret

circledata
	db 242, 245, 247, 249, 250, 251, 252, 252, 253, 253, 254, 254, 254, 255, 255, 255

sine
	; [int(round(8 * (1 - math.sin(i * math.pi/8)))) * 4 for i in range(0, 16)]
	db 32, 20, 8, 4, 0, 4, 8, 20, 32, 44, 56, 60, 64, 60, 56, 44

aydata
	db 8, 8, 0, 0x38, 0, 4, 63, 4, 64

; mask bytes:
; 0200 = yellow
; 0602 = green
; 0202 = purple
; 0600 = red

circlepositions
	dw 0x400f, 0x0202, 0x40c1, 0x0202, 0x4c91, 0x0202
	dw 0x4027, 0x0600, 0x46eb, 0x0200, 0x48ec, 0x0602
	dw 0x4059, 0x0602, 0x485b, 0x0200, 0x5417, 0x0600
	dw 0x44b3, 0x0602, 0x4e65, 0x0600, 0x5043, 0x0200

	db "ZX"  ; space filler

circlesprite equ 0xb000
stripes equ 0xb100
