class Scene2 extends Scene {

  boolean bgDrawn = false;
  float fade;
  float dt;
  int nSets = 8;
  int setSize = 30;
  final int numOfPendulums = setSize * nSets;

  ArrayList<float[]> pendulums = new ArrayList<float[]>();
  float[] angularVelocities = new float[numOfPendulums];
  float[] phases = new float[numOfPendulums];

  //color bgColor = color(0, 0, 0);
  color bgColor = color(255, 255, 255);
  color firstColor = 250;

  Scene2() {
    randomSeed(0);
    resetPendulums();
  }

  void render() {
    fade = (float) moonlander.getValue("fade");
    dt = (float) moonlander.getValue("dt");

    PGraphics fb = frameBuffer1;
    fb.beginDraw();

    fb.noStroke();
    fb.noFill();

    translate(-width / 2, -height / 2);

    int selectSet = constrain((int) moonlander.getValue("scene2rodSet"), 0, nSets - 1);
    int reset = (int) moonlander.getValue("scene2ResetPendulums");
    if (reset ==1) {
      resetPendulums();
    }

    if (!bgDrawn) {
      bgDrawn = true;
      fb.background(bgColor);
    }

    fb.fill(bgColor, 255-fade);
    fb.rectMode(CORNER);
    fb.rect(-100, -100, width + 200, height + 200);

    fb.translate(width / 2, height / 2);

    // pulsating time
    //dt = 0.3 * (float) Math.sin(second()) + 0.4;
    //dt = 0.4;
    float t = (float) moonlander.getValue("scene2oscillation");
    float yOffset = (float) moonlander.getValue("scene2yOffset");

    for (int i = 0; i < numOfPendulums; i++) {
      fb.pushMatrix();
      float[] p = pendulums.get(i);
      pendulums.set(i, rk4(p[0], p[1], p[2], p[3], dt));

      if (((i + selectSet) % nSets) == 0) {

        float[] joint1 = firstJoint(p[0], p[1]);
        float[] joint2 = secondJoint(p[0], p[1]);

        float w = angularVelocities[i];
        float phi = phases[i];
        float xOffset = (width/2-L)*0.9*(float)Math.sin(2 * Math.PI * w * t + phi);

        fb.translate(xOffset, yOffset * height);

        //fb.stroke(255-i*(255/numOfPendulums)*0.8);
        fb.stroke(i*(255/numOfPendulums)*0.8);

        float k = (float) moonlander.getValue("kick");
        float s = (float) moonlander.getValue("kick scale factor");
        fb.strokeWeight(2 * (1 + k * s));
        fb.line(joint1[0], joint1[1], joint2[0], joint2[1]);

        //line(0,0,joint1[0], joint1[1]);
      }
      fb.popMatrix();
    }

    fb.endDraw();

    float p = (float) moonlander.getValue("lens parameter");
    int s = (int) moonlander.getValue("lens seed");
    int lensCount = max((int) moonlander.getValue("lens count"), 0);

    randomSeed(s);

    // bounce lens rendering between two framebuffers (might be very bad idea (inefficient))
    PGraphics fba = fb;
    PGraphics fbb = frameBuffer2;

    int i;
    for (i = 0; i < lensCount; i++) {
      float la = random(0, 1) + random(-1, 1) * p;
      float lb = random(0, 1);
      float lc = random(lensMinW, lensMaxW);
      float ld = random(lensMinH, lensMaxH);

      if (random(0, 1) < 0.5) {
        rectLens.set("lensCenterX", la);
        rectLens.set("lensCenterY", lb);
        rectLens.set("lensW", lc);
        rectLens.set("lensH", ld);
      } else {
        rectLens.set("lensCenterX", lb);
        rectLens.set("lensCenterY", la);
        rectLens.set("lensW", ld);
        rectLens.set("lensH", lc);
      }
      rectLens.set("zoomFactor", random(lensMinZoom, lensMaxZoom));

      fbb.beginDraw();
      fbb.shader(rectLens);
      fbb.image(fba, 0, 0);
      fbb.endDraw();


      if (i % 2 == 0) {
        fba = frameBuffer2;
        fbb = fb;
      } else {
        fba = fb;
        fbb = frameBuffer2;
      }
    }

    if (i % 2 == 1 || lensCount == 0) {
      fbb = fb;
    }

    image(fbb, 0, 0);
  }

  void resetPendulums() {
    pendulums.clear();
    for (int i = 0; i < numOfPendulums; i++) {
      float[] pendulum = {0, 0, random(10), random(10)}; // Starting point for pendulum
      pendulums.add(pendulum);
      float maxV = 0.01;
      angularVelocities[i] = random(maxV);
      phases[i] = random(-2, 2);
    }
  }
}
