class Scene1 extends Scene {
  float[] pendulum = {0, 1, 1, 1}; // Starting point for pendulum 1
  float[] pendulum2 = {0.3, -1, 1.5, 7}; // Starting point for pendulum 2
  float[] pendulum3 = {1, 0, -1, 1}; // Starting point for pendulum 2
  float dt = 0.5;
  boolean bgDrawn = false;
  float fade;
  int pendulumOn = 0;

  //color bgColor = color(24, 48, 89);
  color bgColor = color(255, 255, 255);
  color centerColor = color(219, 53, 65);
  color centerColor2 = color(100, 20, 25);
  //color firstColor = color(246, 244, 243);
  //color secondColor = color(39, 111, 191);
  //color thirdColor = color(175, 91, 91);
  //color firstColor = color(47, 175, 175);
  //color secondColor = color(94, 209, 77);
  //color thirdColor = color(255, 130, 169);

  color firstColor = color(75, 204, 204);
  color secondColor = color(45, 226, 4);
  color thirdColor = color(255, 30, 127);

  ParticleSystem ps1 = new ParticleSystem(new PVector(0, 0), firstColor,  15);
  ParticleSystem ps2 = new ParticleSystem(new PVector(0, 0), firstColor,  15);
  ParticleSystem ps3 = new ParticleSystem(new PVector(0, 0), secondColor, 15);
  ParticleSystem ps4 = new ParticleSystem(new PVector(0, 0), secondColor, 15);
  ParticleSystem ps5 = new ParticleSystem(new PVector(0, 0), thirdColor,  15);
  ParticleSystem ps6 = new ParticleSystem(new PVector(0, 0), thirdColor,  15);
  ParticleSystem psCenter = new ParticleSystem(new PVector(0, 0), centerColor, 35);
  ParticleSystem psCenter2 = new ParticleSystem(new PVector(0, 0), centerColor2, 15);

  ArrayList<ParticleSystem> pss = new ArrayList<ParticleSystem>();
  Scene1() {
    pss.add(ps1);
    pss.add(ps2);
    pss.add(ps3);
    pss.add(ps4);
    pss.add(ps5);
    pss.add(ps6);
    //pss.add(psCenter2 );
    //pss.add(psCenter);
  }

  void render() {
    //randomSeed(0);
    fade = (float) moonlander.getValue("fade");
    pendulumOn = (int) moonlander.getValue("scene1PendulumOn");
    dt = (float) moonlander.getValue("dt");
    float drawDots = (float) moonlander.getValue("scene1dots");

    PGraphics fb = frameBuffer1;

    fb.beginDraw();
    fb.noStroke();
    fb.noFill();

    translate(-width / 2, -height / 2);
    if (!bgDrawn) {
      bgDrawn = true;

      fb.background(bgColor);
    }


    // background
    fb.rectMode(CORNER);
    fb.fill(bgColor, 255 - fade);

    fb.rect(-100, -100, width + 200, height + 200);

    fb.translate(width / 2, height / 2);
    fb.pushMatrix();
    fb.rotate((float) (Math.PI * 2 * moonlander.getValue("scene1 rot"))); // rotation, units in revolutions

    for (ParticleSystem psi : pss) {
      psi.addParticle();
      psi.run();
      psi.display(fb);
    }

    // pulsating time
    //dt = 0.3 * (float) Math.sin(second()) + 0.4;
    //dt = 0.4;
    pendulum = rk4(pendulum[0], pendulum[1], pendulum[2], pendulum[3], dt);
    pendulum2 = rk4(pendulum2[0], pendulum2[1], pendulum2[2], pendulum2[3], dt);
    pendulum3 = rk4(pendulum3[0], pendulum3[1], pendulum3[2], pendulum3[3], dt);

    float[] joint1 = firstJoint(pendulum[0], pendulum[1]);
    float[] joint2 = secondJoint(pendulum[0], pendulum[1]);

    if (pendulumOn == 1) {
      fb.stroke(firstColor);
      fb.strokeWeight(2);
      //line(0, 0, 0 + joint1[0], 0 + joint1[1]);
      fb.stroke(firstColor);
      fb.line(0 + joint1[0], 0 + joint1[1], 0 + joint2[0], 0 + joint2[1]);
    }

    if (drawDots > 0) {
      //fb.ellipse(joint1[0], joint1[1], 4, 4);
      fb.strokeWeight(10);
      fb.fill(secondColor);
      fb.stroke(secondColor, drawDots);
      fb.ellipse( joint2[0],  joint2[1], 4, 4);
      fb.ellipse(-joint2[0], -joint2[1], 4, 4);
    }
    ps3.updateOrigin(new PVector((int) joint2[0], (int) joint2[1]));
    ps4.updateOrigin(new PVector((int) -joint2[0], (int) -joint2[1]));

    joint1 = firstJoint(pendulum2[0], pendulum2[1]);
    joint2 = secondJoint(pendulum2[0], pendulum2[1]);

    if (drawDots == 1) {
      //fb.ellipse(joint1[0], joint1[1], 4, 4);
      fb.strokeWeight(10);
      fb.fill(firstColor);
      fb.stroke(firstColor);

      float k = (float) moonlander.getValue("kick");
      float s = (float) moonlander.getValue("kick scale");

      //float r = 4 * (1 + s * k);
      float r = 4;

      fb.ellipse( joint2[0],  joint2[1], r, r);
      fb.ellipse(-joint2[0], -joint2[1], r, r);
    }

    ps1.updateOrigin(new PVector((int)  joint2[0], (int)  joint2[1]));
    ps2.updateOrigin(new PVector((int) -joint2[0], (int) -joint2[1]));

    joint1 = firstJoint(pendulum3[0], pendulum3[1]);
    joint2 = secondJoint(pendulum3[0], pendulum3[1]);
    ps5.updateOrigin(new PVector((int) joint2[0], (int) joint2[1]));
    ps6.updateOrigin(new PVector((int) -joint2[0], (int) -joint2[1]));
    //lights();
    //fb.noStroke();
    //fb.fill(centerColor);
    //fb.sphereDetail(50);
    //sphere(40);

    fb.popMatrix();

    fb.endDraw();

    float p = (float) moonlander.getValue("lens parameter");
    int s = (int) moonlander.getValue("lens seed");
    int lensCount = max((int) moonlander.getValue("lens count"), 0);

    randomSeed(s);

    // bounce lens rendering between two framebuffers (might be very bad idea (inefficient))
    PGraphics fba = fb;
    PGraphics fbb = frameBuffer2;

    int i;
    for(i = 0; i < lensCount; i++) {
      float la = random(0, 1) + random(-1, 1) * p;
      float lb = random(0, 1);
      float lc = random(lensMinW, lensMaxW);
      float ld = random(lensMinH, lensMaxH);

      if(random(0, 1) < 0.5) {
        rectLens.set("lensCenterX", la);
        rectLens.set("lensCenterY", lb);
        rectLens.set("lensW", lc);
        rectLens.set("lensH", ld);
      } else {
        rectLens.set("lensCenterX", lb);
        rectLens.set("lensCenterY", la);
        rectLens.set("lensW", ld);
        rectLens.set("lensH", lc);
      }
      rectLens.set("zoomFactor", random(lensMinZoom, lensMaxZoom));

      fbb.beginDraw();
      fbb.shader(rectLens);
      fbb.image(fba, 0, 0);
      fbb.endDraw();


      if(i % 2 == 0) {
        fba = frameBuffer2;
        fbb = fb;
      } else {
        fba = fb;
        fbb = frameBuffer2;
      }

    }

    if(i % 2 == 1 || lensCount == 0) {
      fbb = fb;
    }

    image(fbb, 0, 0);

  }
}
