int w; //width of the wave
int spacing = 1; //space between ellipses
float[] values; //array to store height values for the wave
float yoff = 0.0f; //2nd dimension of perlin noise

void setupNoiseWave() {
  frameRate(30);
  //colorMode(RGB, 255, 255, 255, 255);
  smooth();
  w = width + 16;
  values = new float[w / spacing];
}

void drawNoiseWave() {
  background(0);
  createWave(300.0f);
  createWave(150.0f);
  createWave(50.0f);
}

float amplitude;

void createWave(float amplitude) {
  float dx = 0.02f;
  float dy = 0.07f;
  //float amplitude = 300.00f;

  //Increment y
  yoff += dy;
  float xoff = yoff;

  for (int i = 0; i < values.length; i++) {
    // 2D noise function
    values[i] = (1 * noise(xoff, yoff) - 1) * amplitude;
    xoff += dx;
  }

  //Simple way to draw the wave with an ellipse at each location
  for (int x = 0; x < values.length; x++) {
    noStroke();
    fill(#42c6ff);
    ellipseMode(CENTER);
    ellipse (x * spacing, width / 2 + values[x], 2, 2);
  }
  PFont font;
  font = createFont("../data/METAG.TTF", 28);
  fill(#ff0081);
  textFont(font);
  text("m a h a p o y d a l _ A T K   p r o u d l y   p r e s e n t s", width/30, height/7.2);
  text("f i r s t   t i e m", width/2.4, height/2.8);
}
