/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;
import processing.data.JSONArray;
import processing.opengl.PGraphicsOpenGL;

public class Graffathon2018
extends PApplet {
    ArrayList<PShape> buildings;
    ParticleSystem ps;
    float speed = 0.5f;
    Moonlander moonlander;
    float camx = 0.0f;
    float camy = 0.0f;
    float camz = 0.0f;
    float treshold;
    JSONArray fftData;
    JSONArray times;
    int meshScale = 100;
    int textScale = 64;
    int maxh = 4;
    int yellowR = 235;
    int yellowG = 215;
    int yellowB = 40;

    public void setup() {
        this.frameRate(58.0f);
        this.fftInit();
        PImage part = this.createImage(5, 5, 1);
        part.loadPixels();
        int i = 0;
        while (i < part.pixels.length) {
            part.pixels[i] = this.color(128);
            ++i;
        }
        part.updatePixels();
        this.ps = new ParticleSystem(100, new PVector(0.0f, 0.0f, 0.0f), part);
        this.textureMode(2);
        ((PGraphicsOpenGL)this.g).textureSampling(2);
        this.noiseSeed(123561245L);
        this.strokeWeight(1.0f);
        this.stroke(100);
        this.buildings = this.createCity(10, 10);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"UNITY - Eternal Youth.mp3", (int)145, (int)4);
        this.moonlander.start();
    }

    public void draw() {
        float bg;
        this.moonlander.update();
        this.treshold = (float)this.moonlander.getValue("treshold");
        int roadCol = this.moonlander.getIntValue("roadCol");
        int FFT = this.moonlander.getIntValue("doFFT");
        this.camx = (float)this.moonlander.getValue("camX");
        this.camy = (float)this.moonlander.getValue("camY");
        this.camz = (float)this.moonlander.getValue("camZ");
        float lightx = (float)this.moonlander.getValue("lightX");
        float lighty = (float)this.moonlander.getValue("lightY");
        float lightz = (float)this.moonlander.getValue("lightZ");
        float lightSize = (float)this.moonlander.getValue("lightSize");
        boolean makeSun = this.moonlander.getIntValue("makeSun") == 1;
        float windowBrightness = (float)this.moonlander.getValue("windowBrightness");
        float buildingColor = bg = (float)this.moonlander.getValue("background");
        this.background(Graffathon2018.lerp((float)0.0f, (float)79.0f, (float)bg), Graffathon2018.lerp((float)0.0f, (float)108.0f, (float)bg), Graffathon2018.lerp((float)0.0f, (float)155.0f, (float)bg));
        this.ps.setOrigin(new PVector(lightx, lighty, lightz));
        int i = 0;
        while (i < this.moonlander.getIntValue("particles")) {
            this.ps.addParticle();
            ++i;
        }
        this.ps.run();
        if (FFT > 0 || this.frameCount % 6 == 1) {
            this.updateTextures(this.buildings, FFT, this.moonlander.getCurrentTime(), roadCol, windowBrightness, buildingColor);
        }
        this.camera(this.camx, this.camy, this.camz, lightx, lighty, lightz, 0.0f, 0.0f, -1.0f);
        this.perspective(1.0471976f, this.width / this.height, 1.0f, 8000.0f);
        this.lights();
        this.ambientLight(150.0f, 150.0f, 150.0f);
        this.specular(150);
        this.drawLight(lightx + 2.0f * this.noise((float)this.frameCount * 0.1f + 332.0f), lighty + 2.0f * this.noise((float)this.frameCount * 0.1f + 676.0f), lightz + 2.0f * this.noise((float)this.frameCount * 0.1f - 257.0f), lightSize);
        if (makeSun) {
            this.drawLight(-2000.0f, 2000.0f, 1000.0f, 40.0f);
        }
        this.pushMatrix();
        for (PShape b : this.buildings) {
            this.shape(b);
        }
        this.popMatrix();
    }

    public void fftInit() {
        this.fftData = this.loadJSONArray("fft");
        this.times = this.loadJSONArray("times");
    }

    public float[] fftGet(float t) {
        int idx = -1;
        int i = 0;
        while (i < 3366) {
            if (this.times.getFloat(i) > t) {
                idx = i;
                break;
            }
            ++i;
        }
        JSONArray arr = this.fftData.getJSONArray(idx);
        float[] res = new float[20];
        int i2 = 0;
        while (i2 < 20) {
            res[i2] = arr.getFloat(i2);
            ++i2;
        }
        return res;
    }

    public void drawLight(float x, float y, float z, float size) {
        this.pushMatrix();
        this.fill(255.0f, 235.0f, 100.0f);
        this.noStroke();
        this.translate(x, y, z);
        this.sphere(size);
        this.popMatrix();
    }

    public void updateTextures(ArrayList<PShape> arr, int FFT, double t, int roadColor, float windowBrightness, float buildingColor) {
        if (FFT > 0) {
            float[] fft = this.fftGet((float)t);
            PImage[] tex = new PImage[20];
            int i = 0;
            while (i < 20) {
                tex[i] = FFT == 1 ? this.makeTextureFFT((int)(fft[i] * 128.0f)) : this.makeTexture(windowBrightness, buildingColor, fft[i]);
                ++i;
            }
            i = 0;
            while (i < arr.size() - 1) {
                arr.get(i).setTexture(tex[i / 20]);
                ++i;
            }
        } else {
            PImage tex = this.makeTexture(windowBrightness, buildingColor, 1.0f);
            int i = 0;
            while (i < arr.size() - 1) {
                arr.get(i).setTexture(tex);
                ++i;
            }
        }
        arr.get(arr.size() - 1).setTexture(this.makeTextureRoad(roadColor));
    }

    public ArrayList<PShape> createCity(int ny, int nx) {
        ArrayList<PShape> objs = new ArrayList<PShape>();
        PImage tex = this.makeTexture(0.0f, 0.0f, 1.0f);
        PVector back = new PVector(0.0f, -1.0f, 0.0f);
        PVector front = new PVector(0.0f, 1.0f, 0.0f);
        PVector left = new PVector(1.0f, 0.0f, 0.0f);
        PVector right = new PVector(-1.0f, 0.0f, 0.0f);
        PVector up = new PVector(0.0f, 0.0f, 1.0f);
        new PVector(0.0f, 0.0f, -1.0f);
        float bsizeX = 0.5f;
        float bsizeY = 0.5f;
        int j = -nx;
        while (j < nx) {
            int i = -ny;
            while (i < ny) {
                PShape obj = this.createShape();
                obj.beginShape(17);
                obj.texture(tex);
                int buildingResolution = 128;
                float h = (int)((float)buildingResolution * this.noise((float)i + this.camx * 0.0f, (float)j + this.camy * 0.0f));
                h /= (float)buildingResolution;
                h *= (float)this.maxh;
                PVector p000 = new PVector((float)i, (float)j, 0.0f);
                PVector p100 = new PVector((float)i + bsizeX, (float)j, 0.0f);
                new PVector((float)(i + 1), (float)j, 0.0f);
                PVector p010 = new PVector((float)i, (float)j + bsizeY, 0.0f);
                PVector p110 = new PVector((float)i + bsizeX, (float)j + bsizeY, 0.0f);
                new PVector((float)(i + 1), (float)j + bsizeY, 0.0f);
                new PVector((float)i, (float)(j + 1), 0.0f);
                new PVector((float)i + bsizeX, (float)(j + 1), 0.0f);
                new PVector((float)(i + 1), (float)(j + 1), 0.0f);
                PVector p001 = new PVector((float)i, (float)j, h);
                PVector p101 = new PVector((float)i + bsizeX, (float)j, h);
                PVector p011 = new PVector((float)i, (float)j + bsizeY, h);
                PVector p111 = new PVector((float)i + bsizeX, (float)j + bsizeY, h);
                this.makeQuad(obj, p000, p001, p101, p100, back, h, true, true);
                this.makeQuad(obj, p010, p011, p001, p000, left, h, true, false);
                this.makeQuad(obj, p110, p111, p011, p010, front, h, true, true);
                this.makeQuad(obj, p100, p101, p111, p110, right, h, true, false);
                this.makeQuad(obj, p001, p011, p111, p101, up, h, false, false);
                obj.endShape();
                objs.add(obj);
                ++i;
            }
            ++j;
        }
        PShape roads = this.createShape();
        roads.beginShape(17);
        this.makeQuad(roads, new PVector((float)(-nx * this.meshScale), (float)(-ny * this.meshScale), 0.0f), new PVector((float)(-nx * this.meshScale), (float)(ny * this.meshScale), 0.0f), new PVector((float)(nx * this.meshScale), (float)(ny * this.meshScale), 0.0f), new PVector((float)(nx * this.meshScale), (float)(-ny * this.meshScale), 0.0f), up, 1.0f, false, false);
        roads.endShape();
        roads.setTexture(this.makeTextureRoad(0));
        objs.add(roads);
        return objs;
    }

    public void makeQuad(PShape obj, PVector vec0, PVector vec1, PVector vec2, PVector vec3, PVector normal, float h, boolean windows, boolean transpose) {
        int texTop;
        int texBottom;
        int texRight;
        int texLeft;
        if (windows) {
            texLeft = (int)(96.0f * this.noise(vec0.x, vec0.y));
            texRight = texLeft + 32;
            texBottom = 0;
            texTop = (int)((float)this.textScale * h / (float)this.maxh);
        } else {
            texLeft = 0;
            texRight = 1;
            texBottom = 127;
            texTop = 128;
        }
        this.setNormal(obj, normal);
        this.setVertex(obj, vec0, texLeft, texBottom, transpose);
        this.setNormal(obj, normal);
        this.setVertex(obj, vec1, texLeft, texTop, transpose);
        this.setNormal(obj, normal);
        this.setVertex(obj, vec2, texRight, texTop, transpose);
        this.setNormal(obj, normal);
        this.setVertex(obj, vec3, texRight, texBottom, transpose);
    }

    public void setVertex(PShape obj, PVector vec, float xtex, float ytex, boolean transpose) {
        if (transpose) {
            obj.vertex((float)this.meshScale * vec.x, (float)this.meshScale * vec.y, (float)this.meshScale * vec.z, ytex, xtex);
        } else {
            obj.vertex((float)this.meshScale * vec.x, (float)this.meshScale * vec.y, (float)this.meshScale * vec.z, xtex, ytex);
        }
    }

    public void setNormal(PShape obj, PVector vec) {
        obj.normal(vec.x, vec.y, vec.z);
    }

    public PImage makeTexture(float windowBrightness, float buildingColor, float fft) {
        int imgScale = 128;
        PImage img = this.createImage(imgScale, imgScale, 2);
        int i = 0;
        while (i < imgScale) {
            int j = 0;
            while (j < imgScale) {
                int r = (int)(Graffathon2018.map((float)j, (float)0.0f, (float)imgScale, (float)60.0f, (float)0.0f) * buildingColor);
                int g = (int)(Graffathon2018.map((float)j, (float)0.0f, (float)imgScale, (float)50.0f, (float)20.0f) * buildingColor);
                int b = (int)(Graffathon2018.map((float)j, (float)0.0f, (float)imgScale, (float)30.0f, (float)30.0f) * buildingColor);
                int a = 255;
                img.pixels[i + j * imgScale] = this.color(r, g, b, a);
                if (i % 2 == 1 && j % 2 == 1) {
                    float noise = this.noise((float)(i * 2) + this.camx * 0.002f, (float)(j * 2) + this.camy * 0.002f);
                    if ((noise = Graffathon2018.max((float)0.0f, (float)Graffathon2018.min((float)noise, (float)1.0f))) < this.treshold) {
                        noise = 0.0f;
                    }
                    noise += windowBrightness;
                    img.pixels[i + j * imgScale] = this.color(Graffathon2018.lerp((float)r, (float)this.yellowR, (float)(noise *= fft)), Graffathon2018.lerp((float)g, (float)this.yellowG, (float)noise), Graffathon2018.lerp((float)b, (float)this.yellowB, (float)noise));
                }
                ++j;
            }
            ++i;
        }
        return img;
    }

    public PImage makeTextureFFT(int h) {
        int imgScale = 128;
        PImage img = this.createImage(imgScale, imgScale, 2);
        int i = 0;
        while (i < imgScale) {
            int j = 0;
            while (j < imgScale) {
                img.pixels[i + j * imgScale] = j < h ? this.color(this.yellowR, this.yellowG, this.yellowB) : this.color(0, 0, 0);
                ++j;
            }
            ++i;
        }
        return img;
    }

    public PImage makeTextureRoad(int roadColor) {
        PImage img = this.createImage(1, 1, 2);
        img.pixels[0] = this.color(roadColor);
        return img;
    }

    public void settings() {
        this.size(1920, 1080, "processing.opengl.PGraphics3D");
        this.smooth(8);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--hide-stop", "Graffathon2018"};
        if (passedArgs != null) {
            PApplet.main((String[])Graffathon2018.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Particle {
        PVector loc;
        PVector vel;
        PVector acc = new PVector(0.0f, 0.0f, 0.0f);
        float lifespan;
        PImage img;

        Particle(PVector l, PImage img_) {
            float vx = Graffathon2018.this.randomGaussian() * 0.15f;
            float vz = Graffathon2018.this.randomGaussian() * 0.15f + 0.1f;
            float vy = Graffathon2018.this.randomGaussian() * 0.15f;
            this.vel = new PVector(vx, vy, vz);
            this.loc = l.copy();
            this.lifespan = 255.0f;
            this.img = img_;
        }

        public void run() {
            this.update();
            this.render();
        }

        public void applyForce(PVector f) {
            this.acc.add(f);
        }

        public void update() {
            this.vel.add(this.acc);
            this.loc.add(this.vel);
            this.lifespan -= 2.5f;
            this.acc.mult(0.0f);
        }

        public void render() {
            Graffathon2018.this.fill(255.0f, 255.0f, 200.0f, this.lifespan);
            Graffathon2018.this.translate(this.loc.x, this.loc.y, this.loc.z);
            Graffathon2018.this.sphere(1.0f);
            Graffathon2018.this.translate(-this.loc.x, -this.loc.y, -this.loc.z);
        }

        public boolean isDead() {
            return this.lifespan <= 0.0f;
        }
    }

    class ParticleSystem {
        ArrayList<Particle> particles = new ArrayList();
        PVector origin;
        PImage img;

        ParticleSystem(int num, PVector v, PImage img_) {
            this.origin = v.copy();
            this.img = img_;
            int i = 0;
            while (i < num) {
                this.particles.add(new Particle(this.origin, this.img));
                ++i;
            }
        }

        public void setOrigin(PVector v) {
            this.origin = v.copy();
        }

        public void run() {
            int i = this.particles.size() - 1;
            while (i >= 0) {
                Particle p = this.particles.get(i);
                p.run();
                if (p.isDead()) {
                    this.particles.remove(i);
                }
                --i;
            }
        }

        public void applyForce(PVector dir) {
            for (Particle p : this.particles) {
                p.applyForce(dir);
            }
        }

        public void addParticle() {
            this.particles.add(new Particle(this.origin, this.img));
        }
    }
}

