/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.Minim;
import ddf.minim.effects.IIRFilter;

public class ChebFilter
extends IIRFilter {
    public static final int LP = 1;
    public static final int HP = 2;
    private static final float PI = (float)Math.PI;
    private static final float TWO_PI = (float)Math.PI * 2;
    private int type;
    private int poles;
    private float ripple;
    float[] ca = new float[23];
    float[] cb = new float[23];
    float[] ta = new float[23];
    float[] tb = new float[23];
    float[] pa = new float[3];
    float[] pb = new float[2];

    public ChebFilter(float frequency, int type, float ripple, int poles, float sampleRate) {
        super(frequency, sampleRate);
        this.type = type;
        this.ripple = ripple;
        this.poles = poles;
    }

    public void setType(int t) {
        if (t != 1 && t != 2) {
            Minim.error("Invalid filter type, defaulting to low pass.");
            t = 1;
        }
        if (this.type != t) {
            this.type = t;
            this.calcCoeff();
        }
    }

    public int getType() {
        return this.type;
    }

    public void setRipple(float r) {
        if (this.ripple != r) {
            this.ripple = r;
            this.calcCoeff();
        }
    }

    public float getRipple() {
        return this.ripple;
    }

    public void setPoles(int p) {
        if (p < 2) {
            Minim.error("ChebFilter.setPoles: The number of poles must be at least 2.");
            return;
        }
        if (p % 2 != 0) {
            Minim.error("ChebFilter.setPoles: The number of poles must be even.");
            return;
        }
        if (p > 20) {
            Minim.error("ChebFilter.setPoles: The maximum number of poles is 20.");
        }
        this.poles = p;
        this.calcCoeff();
    }

    public int getPoles() {
        return this.poles;
    }

    @Override
    protected synchronized void calcCoeff() {
        int i;
        for (i = 0; i < 23; ++i) {
            this.tb[i] = 0.0f;
            this.ta[i] = 0.0f;
            this.cb[i] = 0.0f;
            this.ca[i] = 0.0f;
        }
        this.ca[2] = 1.0f;
        this.cb[2] = 1.0f;
        for (int p = 1; p <= this.poles / 2; ++p) {
            this.calcTwoPole(p, this.pa, this.pb);
            System.arraycopy(this.ca, 0, this.ta, 0, this.ta.length);
            System.arraycopy(this.cb, 0, this.tb, 0, this.tb.length);
            for (int i2 = 2; i2 < 23; ++i2) {
                this.ca[i2] = this.pa[0] * this.ta[i2] + this.pa[1] * this.ta[i2 - 1] + this.pa[2] * this.ta[i2 - 2];
                this.cb[i2] = this.tb[i2] - this.pb[0] * this.tb[i2 - 1] - this.pb[1] * this.tb[i2 - 2];
            }
        }
        this.cb[2] = 0.0f;
        for (i = 0; i < 21; ++i) {
            this.ca[i] = this.ca[i + 2];
            this.cb[i] = -this.cb[i + 2];
        }
        float sa = 0.0f;
        float sb = 0.0f;
        for (int i3 = 0; i3 < 21; ++i3) {
            if (this.type == 1) {
                sa += this.ca[i3];
                sb += this.cb[i3];
                continue;
            }
            sa += this.ca[i3] * (float)Math.pow(-1.0, i3);
            sb += this.cb[i3] * (float)Math.pow(-1.0, i3);
        }
        float gain = sa / (1.0f - sb);
        int i4 = 0;
        while (i4 < 21) {
            int n = i4++;
            this.ca[n] = this.ca[n] / gain;
        }
        if (this.a == null || this.a.length != this.poles + 1) {
            this.a = new float[this.poles + 1];
        }
        if (this.b == null || this.b.length != this.poles) {
            this.b = new float[this.poles];
        }
        System.arraycopy(this.ca, 0, this.a, 0, this.a.length);
        System.arraycopy(this.cb, 1, this.b, 0, this.b.length);
    }

    private void calcTwoPole(int p, float[] pa, float[] pb) {
        float np = this.poles;
        float angle = (float)Math.PI / (np * 2.0f) + (float)(p - 1) * (float)Math.PI / np;
        float rp = -((float)Math.cos(angle));
        float ip = (float)Math.sin(angle);
        if (this.ripple > 0.0f) {
            float ratio = 100.0f / (100.0f - this.ripple);
            float ratioSquared = ratio * ratio;
            float es = 1.0f / (float)Math.sqrt(ratioSquared - 1.0f);
            float oneOverNP = 1.0f / np;
            float esSquared = es * es;
            float vx = oneOverNP * (float)Math.log((double)es + Math.sqrt(esSquared + 1.0f));
            float kx = oneOverNP * (float)Math.log((double)es + Math.sqrt(esSquared - 1.0f));
            float expKX = (float)Math.exp(kx);
            float expNKX = (float)Math.exp(-kx);
            kx = (expKX + expNKX) * 0.5f;
            float expVX = (float)Math.exp(vx);
            float expNVX = (float)Math.exp(-vx);
            float oneOverKX = 1.0f / kx;
            rp *= (expVX - expNVX) * 0.5f * oneOverKX;
            ip *= (expVX + expNVX) * 0.5f * oneOverKX;
        }
        float t = 2.0f * (float)Math.tan(0.5);
        float w = (float)Math.PI * 2 * (this.frequency() / this.sampleRate());
        float m = rp * rp + ip * ip;
        float fourTimesRPTimesT = 4.0f * rp * t;
        float tSquared = t * t;
        float mTimesTsquared = m * tSquared;
        float tSquaredTimes2 = 2.0f * tSquared;
        float d = 4.0f - fourTimesRPTimesT + mTimesTsquared;
        float oneOverD = 1.0f / d;
        float x0 = tSquared * oneOverD;
        float x1 = tSquaredTimes2 * oneOverD;
        float x2 = x0;
        float y1 = (8.0f - tSquaredTimes2 * m) * oneOverD;
        float y2 = (-4.0f - fourTimesRPTimesT - mTimesTsquared) * oneOverD;
        float halfW = w * 0.5f;
        float k = this.type == 2 ? -((float)Math.cos(halfW + 0.5f)) / (float)Math.cos(halfW - 0.5f) : (float)Math.sin(0.5f - halfW) / (float)Math.sin(0.5f + halfW);
        float kSquared = k * k;
        float x1timesK = x1 * k;
        float kDoubled = 2.0f * k;
        float y1timesK = y1 * k;
        d = 1.0f + y1timesK - y2 * kSquared;
        oneOverD = 1.0f / d;
        pa[0] = (x0 - x1timesK + x2 * kSquared) * oneOverD;
        pa[1] = (-kDoubled * x0 + x1 + x1 * kSquared - kDoubled * x2) * oneOverD;
        pa[2] = (x0 * kSquared - x1timesK + x2) * oneOverD;
        pb[0] = (kDoubled + y1 + y1 * kSquared - y2 * kDoubled) * oneOverD;
        pb[1] = (-kSquared - y1timesK + y2) * oneOverD;
        if (this.type == 2) {
            pa[1] = -pa[1];
            pb[0] = -pb[0];
        }
    }
}

