/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.AudioMetaData;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.javasound.FloatSampleBuffer;
import ddf.minim.javasound.JSMinim;
import ddf.minim.spi.AudioRecordingStream;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Control;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioUtils;

abstract class JSBaseAudioRecordingStream
implements Runnable,
AudioRecordingStream {
    private Thread iothread;
    private AudioListener listener;
    private AudioEffect effect;
    private AudioMetaData meta;
    private boolean play;
    private boolean loop;
    private int numLoops;
    private int loopBegin;
    private int loopEnd;
    protected AudioInputStream ais;
    private byte[] rawBytes;
    private byte[] skipBytes;
    private boolean shouldRead;
    private int totalBytesRead;
    private int bytesWritten;
    protected AudioFormat format;
    private SourceDataLine line;
    private FloatSampleBuffer buffer;
    private int bufferSize;
    private boolean finished;
    private float[] silence;
    protected JSMinim system;

    JSBaseAudioRecordingStream(JSMinim sys, AudioMetaData metaData, AudioInputStream stream, SourceDataLine sdl, int inBufferSize, int msLen) {
        this.system = sys;
        this.meta = metaData;
        this.format = sdl.getFormat();
        this.bufferSize = inBufferSize;
        this.buffer = new FloatSampleBuffer(this.format.getChannels(), this.bufferSize, this.format.getSampleRate());
        this.system.debug("JSBaseAudioRecordingStream :: FloatSampleBuffer has " + this.buffer.getSampleCount() + " samples.");
        this.rawBytes = new byte[this.buffer.getByteArrayBufferSize(this.format)];
        this.system.debug("JSBaseAudioRecordingStream :: rawBytes has length " + this.rawBytes.length);
        this.skipBytes = new byte[(int)AudioUtils.millis2BytesFrameAligned((long)10000L, (AudioFormat)this.format)];
        this.system.debug("JSBaseAudioRecordingStream :: skipBytes has length " + this.skipBytes.length);
        this.finished = false;
        this.line = sdl;
        this.ais = stream;
        this.loop = false;
        this.play = false;
        this.numLoops = 0;
        this.loopBegin = 0;
        this.loopEnd = (int)AudioUtils.millis2BytesFrameAligned((long)msLen, (AudioFormat)this.format);
        this.silence = new float[this.bufferSize];
        this.iothread = null;
        this.totalBytesRead = 0;
        this.bytesWritten = 0;
        this.shouldRead = true;
    }

    public AudioMetaData getMetaData() {
        return this.meta;
    }

    public int getMillisecondLength() {
        return this.meta.length();
    }

    @Override
    public void run() {
        while (!this.finished) {
            if (this.play) {
                if (this.shouldRead) {
                    if (this.loop) {
                        this.readBytesLoop();
                    } else {
                        this.readBytes();
                    }
                    this.process();
                }
                this.writeBytes();
                this.broadcast();
                Thread.yield();
                continue;
            }
            this.system.debug("Gonna wait...");
            this.broadcast();
            this.sleep(30000);
            this.system.debug("Done waiting!");
        }
        this.line.flush();
        this.line.close();
        this.line = null;
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readBytes() {
        int bytesRead;
        int toRead = this.rawBytes.length;
        try {
            int actualRead;
            for (bytesRead = 0; bytesRead < toRead; bytesRead += actualRead) {
                actualRead = 0;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    actualRead = this.ais.read(this.rawBytes, bytesRead, toRead - bytesRead);
                }
                if (actualRead != -1) continue;
                this.system.debug("Actual read was -1, pausing...");
                this.pause();
                break;
            }
        }
        catch (IOException e) {
            this.system.error("Error reading from the file - " + e.getMessage());
        }
        this.totalBytesRead += bytesRead;
        return bytesRead;
    }

    private void readBytesLoop() {
        int toLoopEnd = this.loopEnd - this.totalBytesRead;
        if (toLoopEnd <= 0) {
            if (this.loop && this.numLoops != -1) {
                --this.numLoops;
            }
            if (this.numLoops != 0) {
                this.setMillisecondPosition(this.loopBegin);
                this.readBytesLoop();
            } else {
                Arrays.fill(this.rawBytes, (byte)0);
            }
            return;
        }
        if (toLoopEnd < this.rawBytes.length) {
            this.readBytesWrap(toLoopEnd, 0);
            if (this.loop && this.numLoops == 0) {
                this.loop = false;
                this.pause();
            } else if (this.loop) {
                if (this.numLoops != -1) {
                    --this.numLoops;
                }
                this.setMillisecondPosition(this.loopBegin);
                this.readBytesWrap(this.rawBytes.length - toLoopEnd, toLoopEnd);
            }
        } else {
            this.readBytesWrap(this.rawBytes.length, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBytesWrap(int toRead, int offset) {
        int bytesRead = 0;
        try {
            while (bytesRead < toRead) {
                int actualRead = 0;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    actualRead = this.ais.read(this.rawBytes, bytesRead + offset, toRead - bytesRead);
                }
                if (-1 == actualRead) {
                    this.setMillisecondPosition(0);
                    if (this.numLoops == -1) continue;
                    --this.numLoops;
                    continue;
                }
                if (actualRead != 0) {
                    bytesRead += actualRead;
                    this.totalBytesRead += actualRead;
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            this.system.error("Error reading from the file - " + ioe.getMessage());
        }
    }

    private void writeBytes() {
        int needToWrite = this.rawBytes.length - this.bytesWritten;
        int actualWrit = this.line.write(this.rawBytes, this.bytesWritten, needToWrite);
        if (actualWrit != needToWrite) {
            this.system.debug("writeBytes: wrote " + actualWrit + " of " + needToWrite);
            this.shouldRead = false;
            this.bytesWritten += actualWrit;
        } else {
            this.shouldRead = true;
            this.bytesWritten = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast() {
        FloatSampleBuffer floatSampleBuffer = this.buffer;
        synchronized (floatSampleBuffer) {
            if (this.buffer.getChannelCount() == 1) {
                if (this.play) {
                    this.listener.samples(this.buffer.getChannel(0));
                } else {
                    this.listener.samples(this.silence);
                }
            } else if (this.buffer.getChannelCount() == 2) {
                if (this.play) {
                    this.listener.samples(this.buffer.getChannel(0), this.buffer.getChannel(1));
                } else {
                    this.listener.samples(this.silence, this.silence);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void process() {
        FloatSampleBuffer floatSampleBuffer = this.buffer;
        synchronized (floatSampleBuffer) {
            int frameCount = this.rawBytes.length / this.format.getFrameSize();
            this.buffer.setSamplesFromBytes(this.rawBytes, 0, this.format, 0, frameCount);
            if (this.buffer.getChannelCount() == 1) {
                this.effect.process(this.buffer.getChannel(0));
            } else if (this.buffer.getChannelCount() == 2) {
                this.effect.process(this.buffer.getChannel(0), this.buffer.getChannel(1));
            }
            this.buffer.convertToByteArray(this.rawBytes, 0, this.format);
        }
    }

    public void play() {
        this.line.start();
        this.loop = false;
        this.numLoops = 0;
        this.play = true;
    }

    public boolean isPlaying() {
        return this.play;
    }

    public void pause() {
        this.line.stop();
        this.play = false;
    }

    public void loop(int n) {
        this.setMillisecondPosition(this.loopBegin);
        this.loop = true;
        this.numLoops = n;
        this.play = true;
        this.line.start();
    }

    public void open() {
        this.finished = false;
        this.iothread = new Thread(this);
        this.iothread.start();
    }

    public void close() {
        this.finished = true;
        this.iothread = null;
        try {
            this.ais.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.line.flush();
        this.line.close();
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getLoopCount() {
        return this.numLoops;
    }

    public void setLoopPoints(int start, int stop) {
        this.loopBegin = start <= 0 || start > stop ? 0 : start;
        this.loopEnd = stop <= this.getMillisecondLength() && stop > start ? (int)AudioUtils.millis2BytesFrameAligned((long)stop, (AudioFormat)this.format) : (int)AudioUtils.millis2BytesFrameAligned((long)this.getMillisecondLength(), (AudioFormat)this.format);
    }

    public int getMillisecondPosition() {
        int pos = (int)AudioUtils.bytes2Millis((long)this.totalBytesRead, (AudioFormat)this.format);
        return Math.min(pos, this.getMillisecondLength());
    }

    public void setMillisecondPosition(int millis) {
        boolean wasPlaying = this.play;
        this.play = false;
        if (millis < this.getMillisecondPosition()) {
            this.rewind();
            this.totalBytesRead = this.skip(millis);
        } else {
            this.totalBytesRead += this.skip(millis - this.getMillisecondPosition());
        }
        this.play = wasPlaying;
    }

    public long getSampleFrameLength() {
        return this.ais.getFrameLength();
    }

    public Control[] getControls() {
        return this.line.getControls();
    }

    public void setAudioEffect(AudioEffect effect) {
        this.effect = effect;
    }

    public void setAudioListener(AudioListener listener) {
        this.listener = listener;
    }

    protected synchronized void rewind() {
        try {
            this.ais.close();
        }
        catch (IOException e) {
            this.system.error("JSPCMAudioRecordingStream::rewind - Error closing the stream before reload: " + e.getMessage());
        }
        this.ais = this.system.getAudioInputStream(this.meta.fileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int skip(int millis) {
        long toSkip = AudioUtils.millis2BytesFrameAligned((long)millis, (AudioFormat)this.format);
        if (toSkip <= 0L) {
            if (toSkip < 0L) {
                this.system.error("JSBaseAudioRecordingStream.skip :: Tried to skip negative milleseconds!");
            }
            return 0;
        }
        this.system.debug("Skipping forward by " + millis + " milliseconds, which is " + toSkip + " bytes.");
        long totalSkipped = 0L;
        try {
            while (toSkip > 0L) {
                long read;
                AudioInputStream audioInputStream = this.ais;
                synchronized (audioInputStream) {
                    int myBytesToRead = this.skipBytes.length;
                    if (toSkip < (long)myBytesToRead) {
                        myBytesToRead = (int)toSkip;
                    }
                    read = this.ais.read(this.skipBytes, 0, myBytesToRead);
                }
                if (read == -1L) {
                    this.system.debug("JSBaseAudioRecordingStream.skip :: EOF reached!");
                    break;
                }
                toSkip -= read;
                totalSkipped += read;
            }
        }
        catch (IOException e) {
            this.system.error("Unable to skip due to read error: " + e.getMessage());
        }
        this.system.debug("Total actually skipped was " + totalSkipped + ", which is " + AudioUtils.bytes2Millis((long)totalSkipped, (AudioFormat)this.ais.getFormat()) + " milliseconds.");
        return (int)totalSkipped;
    }

    public float[] read() {
        if (this.buffer.getSampleCount() != 1) {
            this.buffer.changeSampleCount(1, true);
            this.rawBytes = new byte[this.buffer.getByteArrayBufferSize(this.format)];
        }
        float[] samples = new float[this.buffer.getChannelCount()];
        if (this.play) {
            this.mRead();
            for (int i = 0; i < this.buffer.getChannelCount(); ++i) {
                samples[i] = this.buffer.getChannel(i)[0];
            }
        }
        return samples;
    }

    public int read(MultiChannelBuffer outBuffer) {
        if (this.buffer.getSampleCount() != outBuffer.getBufferSize()) {
            this.buffer.changeSampleCount(outBuffer.getBufferSize(), true);
            this.rawBytes = new byte[this.buffer.getByteArrayBufferSize(this.format)];
        }
        int framesRead = 0;
        if (this.play) {
            framesRead = this.mRead();
        } else {
            this.buffer.makeSilence();
        }
        for (int i = 0; i < this.buffer.getChannelCount(); ++i) {
            outBuffer.setChannel(i, this.buffer.getChannel(i));
        }
        return framesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int mRead() {
        int bytesRead = this.rawBytes.length;
        if (this.loop) {
            this.readBytesLoop();
        } else {
            bytesRead = this.readBytes();
        }
        int frameCount = bytesRead / this.format.getFrameSize();
        FloatSampleBuffer floatSampleBuffer = this.buffer;
        synchronized (floatSampleBuffer) {
            this.buffer.setSamplesFromBytes(this.rawBytes, 0, this.format, 0, frameCount);
        }
        return frameCount;
    }
}

