class HandDrawnGraphics {

  PGraphics g;
  float noiseWeight, noiseSize;
  float noiseShiftX, noiseShiftY;
  float lastVertexX, lastVertexY;
  boolean isFirstVertex;
  float drawStepSize;
  float noiseAvg = 0.5;
  float noiseZ;
  
  HandDrawnGraphics (PGraphics graphics, float drawStepSize) {
    this.g = graphics;
    this.noiseShiftX = 0;
    this.noiseShiftY = 0;
    this.isFirstVertex = true;
    this.drawStepSize = drawStepSize;
    this.noiseWeight = 0.15;
    this.noiseSize = 0.07;
    this.noiseZ = 0;
  }
  
  void noiseWeight(float weight) {
    this.noiseWeight = weight;
  }
  
  void noiseSize(float len) {
    this.noiseSize = len;
  }
  
  void noiseShift(float x, float y) {
    this.noiseShiftX = x;
    this.noiseShiftY = y;
  }
  
  void rect(float x, float y, float w, float h) {
    this.beginShape();
    this.vertex(x, y);
    this.vertex(x+w, y);
    this.vertex(x+w, y+h);
    this.vertex(x, y+h);
    this.vertex(x, y);
    this.endShape(CLOSE);
  }
  
  void line(float x1, float y1, float x2, float y2) {
    this.beginShape();
    this.vertex(x1, y1);
    this.vertex(x2, y2);
    this.endShape();
  }

  void vertex(float x, float y) {
    float x1 = lastVertexX;
    float y1 = lastVertexY;
    float x2 = x;
    float y2 = y;
    lastVertexX = x;
    lastVertexY = y;

    if (isFirstVertex) {
      isFirstVertex = false;
      return;
    }
    
    float len = sqrt((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2));
    int steps = round(len / drawStepSize);
    float d = 1.0 / steps;

    for (int i = 0; i < steps; i++) {
      float t = i * d;
      float xp = x1 + t*(x2-x1);
      float yp = y1 + t*(y2-y1);
      this.singleNoiseVertex(xp, yp);
    }
  }
  
  void circle(float x, float y, float r) {
    this.g.beginShape();

    float len = r * TAU;
    int steps = round(len / drawStepSize);
    float d = TAU / steps;

    for (int i = 0; i < steps; i++) {
      float t = i * d;
      this.singleNoiseVertex(x + r*cos(t), y + r*sin(t));
    }
    
    this.g.endShape();
  }
  
  void singleNoiseVertex(float x, float y) {
    // if you change this function remember to update getNoiseShiftXAt and getNoiseShiftYAt
    float noiseX = x/noiseSize + noiseShiftX;
    float noiseY = y/noiseSize + noiseShiftY;
    noiseX += 0.0001*noiseY;
    noiseY += 0.0001*noiseX;

    float dx = noise(1000 + noiseX, 1000.5 + noiseY, this.noiseZ);
    float dy = noise(1000.5 + noiseX, 3000 + noiseY, this.noiseZ + 0.5);
    dx = noiseWeight * noiseSize * (dx - noiseAvg);
    dy = noiseWeight * noiseSize * (dy - noiseAvg);
    
    this.g.vertex(x + dx, y + dy);
  }
  
  float getNoiseShiftXAt(float x, float y) {
    float noiseX = x/noiseSize + noiseShiftX;
    float noiseY = y/noiseSize + noiseShiftY;
    noiseX += 0.0001*noiseY;
    noiseY += 0.0001*noiseX;
    float dx = noise(1000 + noiseX, 1000.5 + noiseY, this.noiseZ);
    return noiseWeight * noiseSize * (dx - noiseAvg);
  }
  
  float getNoiseShiftYAt(float x, float y) {
    float noiseX = x/noiseSize + noiseShiftX;
    float noiseY = y/noiseSize + noiseShiftY;
    noiseX += 0.0001*noiseY;
    noiseY += 0.0001*noiseX;
    float dy = noise(1000.5 + noiseX, 3000 + noiseY, this.noiseZ + 0.5);
    return  noiseWeight * noiseSize * (dy - noiseAvg);
  }
  
  void beginShape() {
    this.g.beginShape();
  }
  
  void endShape() {
    this.g.endShape();
    this.isFirstVertex = true;
  }
  
  void endShape(int how) {
    this.g.endShape(how);
    this.isFirstVertex = true;
  }
}
