function analyzeSpectrum(){

   push();

   var spectrum = fft.analyze();

   var bass_energy = fft.getEnergy("bass");
   var lowMid_energy = fft.getEnergy("lowMid");
   var mid_energy = fft.getEnergy("mid");
   var highMid_energy = fft.getEnergy("highMid");
   var treble_energy = fft.getEnergy("treble");

   var avg_energy = fft.getEnergy(20,14000);


   low_mid_signal.update(lowMid_energy);
   mid_signal.update(mid_energy);
   high_mid_signal.update(highMid_energy);
   treble_signal.update(treble_energy);
   avg_signal.update(avg_energy);
   

   if(render_fft){

     fill(255,150,150);
     rect(0,350,width,350);

      fill(50,0,50);

      beginShape();

      vertex(0,height);

      for (i = 0; i<spectrum.length; i++) {
       var x = map(i,0,spectrum.length,0,width);
       vertex(x, map(spectrum[i], 0, 255, height,350) );
      }

      vertex(width, height);

      endShape(); 

      strokeWeight(4);

      stroke(0,255,0);

      avg_energy = map(avg_energy,0,255,height,350);
      line(0,avg_energy,width,avg_energy);

      stroke(0,255,255);


      bass_energy = map(bass_energy,0,255,height,350);
      line(map(20,0,20000,0,width),bass_energy,map(140,0,20000,0,width),bass_energy);


      lowMid_energy = map(lowMid_energy,0,255,height,350);
      line(map(140,0,20000,0,width),lowMid_energy,map(400,0,20000,0,width),lowMid_energy);

      mid_energy = map(mid_energy,0,255,height,350);
      line(map(400,0,20000,0,width),mid_energy,map(2600,0,20000,0,width),mid_energy);

      highMid_energy = map(highMid_energy,0,255,height,350);
      line(map(2600,0,20000,0,width),highMid_energy,map(5200,0,20000,0,width),highMid_energy);

      treble_energy = map(treble_energy,0,255,height,350);
      line(map(5200,0,20000,0,width),treble_energy,map(14000,0,20000,0,width),treble_energy);

      push();
      translate(0,350);
      stroke(255);
      strokeWeight(1);
      for(var i = 0 ; i < 5 ; i++){

         line(0,i*(350/5),width,i*(350/5));

      }

      pop();
      low_mid_signal.display(20,400);

      mid_signal.display(80,400);

      high_mid_signal.display(300,400);

      treble_signal.display(500,400);
      pop();

   }
}

