
function Rain() {
  this.x = random(width+10, width+50);
  this.y = random(0,350);
  this.dir = radians((175));
  this.diameter = 2;
  this.vel = random(10,20);
  this.kill_flag = false;

  this.x_hist = [];
  this.y_hist = [];

  for(var i = 0 ; i < 10 ; i++){

    this.x_hist[i] = this.x;
    this.y_hist[i] = this.y;

  }

  this.move = function() {

    for(var i = this.x_hist.length-1 ; i > 0 ; i--){
      this.x_hist[i] = this.x_hist[i-1];
      this.y_hist[i] = this.y_hist[i-1];
    }

    this.x_hist[0] = this.x;
    this.y_hist[0] = this.y;
    
    this.x += this.vel*cos(this.dir);
    this.y += this.vel*sin(this.dir);

    this.dir-=radians(random(-.3,.3));

    if(this.x < 0 || this.y > 350){

      this.kill_flag = true;
    }

  };

  this.display = function() {
    push();
    fill(RAIN_COLOR);
    noStroke();
    ellipse(this.x, this.y, this.diameter, this.diameter);

   
    strokeWeight(1);

    for(var i = this.x_hist.length-1 ; i > -1 ; i--){
      var op = map(i,0,this.x_hist.length,128,0);
      var weight = map(i,0,this.x_hist.length,2,0.5);
      stroke(red(RAIN_COLOR), green(RAIN_COLOR), blue(RAIN_COLOR), op);
      strokeWeight(weight);
      line(this.x_hist[i],this.y_hist[i],this.x_hist[i-1],this.y_hist[i-1]);
    }

    pop();
  };
}