#include "common_fs.glsl"

#ifdef TOON_SHADING
#include "toon_functions_fs.glsl"
#endif






// ------------------------------------------------------------------------------------------------
//
//
float prueba(float intensity)
{
  //return intensity ;

  if (intensity > 0.9) return 1.0 ;
  if (intensity < 0.7) return 0.2 ;
  return 0.5 ;
}


// ------------------------------------------------------------------------------------------------
//
//
void main()
{
  lowp vec4 valor_textura ;

#ifdef ACTIVAR_TEXTURA

  // si tenemos segunda textura...
  if ( g_DatosMaterial.numTextures == 1 ) {

    // el color y la opacidad salen de la textura principal
    valor_textura = texture2D(shader_texture_ids[0], text_coord[0]) ;
  }
  else {

    // el color sale de la textura principal
    valor_textura.rgb = texture2D(shader_texture_ids[0], text_coord[0]).rgb ;

    // como es gris usaremos el rojo como canal alpha
    valor_textura.a = texture2D(shader_texture_ids[1], text_coord[1]).r ;
  }

#else

  valor_textura = vec4(0.6, 0.6, 0.6, 1.0) ;

#endif

  // se ve?
  if ( valor_textura.a >= 0.00025 ) {


    vec3 iluminacion = light_final_intensity ;

#ifdef TOON_SHADING
    iluminacion.r = prueba(iluminacion.r) ;
    iluminacion.g = prueba(iluminacion.g) ;
    iluminacion.b = prueba(iluminacion.b) ;

    //light_final_intensity.x = toonify2(light_final_intensity.y) ;
    //light_final_intensity.y = toonify2(light_final_intensity.y) ;
    //light_final_intensity.z = toonify2(light_final_intensity.z) ;

#endif

    //if ( valor_textura.a < 0.01 ) gl_FragColor.rgb = vec3(0.0,0.0,0.0);
    //else {
    //lowp vec3 color = valor_textura.rgb * (1.0-valor_textura.a);
    //gl_FragColor.rgb = (((valor_textura.rgb * light_final_intensity) + light_final_specular) * valor_textura.a) + color ;
    //lowp vec3 light = light_final_intensity * valor_textura.a;
    //lowp vec3 color = valor_textura.rgb * (1.0-valor_textura.a);
    //gl_FragColor.rgb = (valor_textura.rgb * light) + light_final_specular + color ;
    //}

    // valor del pixel iluminado
    gl_FragColor.rgb = ((valor_textura.rgb * iluminacion) + light_final_specular) /** valor_textura.a*/ ;


    //float dist = gl_FragCoord.z / gl_FragCoord.w ;
    //gl_FragColor.rgb *= dist ;

    //gl_FragColor.rgb = ((valor_textura.rgb ) + light_final_specular) * valor_textura.a ;    

    // al canal alpha no se le aplica la luz
    gl_FragColor.a = valor_textura.a /** g_DatosMaterial.transparency*/ ;
  }
  else {

    // si es transparente...
	  discard ;
  }
}
