/*
 * Decompiled with CFR 0.152.
 */
package com.hamoid;

import com.sun.jna.platform.win32.Kernel32;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import processing.core.PApplet;
import processing.core.PImage;
import processing.data.JSONObject;

public class VideoExport {
    public static final String VERSION = "0.2.0";
    protected static final String SETTINGS_FFMPEG_PATH = "ffmpeg_path";
    protected static final String SETTINGS_CMD_ENCODE_VIDEO = "encode_video";
    protected static final String SETTINGS_CMD_ENCODE_AUDIO = "encode_audio";
    protected static final String FFMPEG_PATH_UNSET = "ffmpeg_path_unset";
    protected static final String CMD_ENCODE_VIDEO_DEFAULT = "[ffmpeg] -y -f rawvideo -vcodec rawvideo -s [width]x[height] -pix_fmt rgb24 -r [fps] -i - -an -vcodec h264 -pix_fmt yuv420p -crf [crf] -metadata comment=[comment] [output]";
    protected static final String CMD_ENCODE_AUDIO_DEFAULT = "[ffmpeg] -y -i [inputvideo] -i [inputaudio] -filter_complex [1:0]apad -shortest -vcodec copy -acodec aac -b:a [bitrate]k -metadata comment=[comment] -strict -2 [output]";
    protected final String ffmpegMetadataComment = "Exported using https://github.com/hamoid/VideoExport-for-Processing";
    protected ProcessBuilder processBuilder;
    protected Process process;
    protected byte[] pixelsByte = null;
    protected int frameCount;
    protected boolean loadPixelsEnabled = true;
    protected boolean saveDebugInfo = true;
    protected String outputFilePath;
    protected String audioFilePath;
    protected PImage img;
    protected PApplet parent;
    protected int ffmpegCrfQuality;
    protected int ffmpegAudioBitRate;
    protected float ffmpegFrameRate;
    protected boolean ffmpegFound = false;
    protected File ffmpegOutputMsg;
    protected OutputStream ffmpeg;
    protected JSONObject settings;
    protected String settingsPath;

    public VideoExport(PApplet pApplet) {
        this(pApplet, "processing-movie.mp4", (PImage)pApplet.g);
    }

    public VideoExport(PApplet pApplet, String string) {
        this(pApplet, string, (PImage)pApplet.g);
    }

    public VideoExport(PApplet pApplet, String string, PImage pImage) {
        pApplet.registerMethod("dispose", (Object)this);
        this.parent = pApplet;
        this.img = pImage;
        try {
            File file = new File(VideoExport.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getParentFile();
            this.settingsPath = file.getAbsolutePath() + File.separator + "settings.json";
            File file2 = new File(this.settingsPath);
            if (file2.isFile()) {
                this.settings = pApplet.loadJSONObject(this.settingsPath);
            } else {
                this.settings = new JSONObject();
                this.settings.setString(SETTINGS_CMD_ENCODE_VIDEO, CMD_ENCODE_VIDEO_DEFAULT);
                this.settings.setString(SETTINGS_CMD_ENCODE_AUDIO, CMD_ENCODE_AUDIO_DEFAULT);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            System.err.println("Error loading settings.json");
        }
        this.outputFilePath = pApplet.sketchPath(string);
        this.ffmpegFrameRate = 30.0f;
        this.ffmpegCrfQuality = 15;
        this.ffmpegAudioBitRate = 128;
    }

    public static String version() {
        return VERSION;
    }

    public void setMovieFileName(String string) {
        this.outputFilePath = this.parent.sketchPath(string);
    }

    public void setAudioFileName(String string) {
        this.audioFilePath = this.parent.dataPath(string);
    }

    public void setGraphics(PImage pImage) {
        this.img = pImage;
    }

    public void setQuality(int n, int n2) {
        if (this.ffmpeg != null) {
            System.err.println("Can't setQuality() after saveFrame()!");
            return;
        }
        if (n > 100) {
            n = 100;
        } else if (n < 0) {
            n = 0;
        }
        this.ffmpegCrfQuality = (100 - n) / 2;
        this.ffmpegAudioBitRate = n2;
    }

    public void setFrameRate(float f) {
        if (this.ffmpeg != null) {
            System.err.println("Can't setFrameRate() after saveFrame()!");
            return;
        }
        this.ffmpegFrameRate = f;
    }

    public void setLoadPixels(boolean bl) {
        this.loadPixelsEnabled = bl;
    }

    public void setDebugging(boolean bl) {
        this.saveDebugInfo = bl;
    }

    public void saveFrame() {
        if (this.img != null && this.img.width > 0) {
            if (!this.ffmpegFound) {
                return;
            }
            if (this.pixelsByte == null) {
                this.pixelsByte = new byte[this.img.pixelWidth * this.img.pixelHeight * 3];
            }
            if (this.loadPixelsEnabled) {
                this.img.loadPixels();
            }
            int n = 0;
            for (int n2 : this.img.pixels) {
                this.pixelsByte[n++] = (byte)(n2 >> 16);
                this.pixelsByte[n++] = (byte)(n2 >> 8);
                this.pixelsByte[n++] = (byte)n2;
            }
            try {
                this.ffmpeg.write(this.pixelsByte);
                ++this.frameCount;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.err();
            }
        }
    }

    protected void initialize() {
        String string = this.getFfmpegPath();
        if (string.equals(FFMPEG_PATH_UNSET)) {
            String[] stringArray;
            for (String string2 : stringArray = new String[]{"/usr/local/bin/ffmpeg", "/usr/bin/ffmpeg"}) {
                if (!new File(string2).isFile()) continue;
                string = string2;
                this.settings.setString(SETTINGS_FFMPEG_PATH, string);
                this.parent.saveJSONObject(this.settings, this.settingsPath);
                break;
            }
        } else {
            File file = new File(string);
            if (!file.isFile()) {
                string = FFMPEG_PATH_UNSET;
            }
        }
        if (string.equals(FFMPEG_PATH_UNSET)) {
            JOptionPane.showMessageDialog(this.parent.frame, "The VideoExport library requires ffmpeg,\na free command line tool.\n\nIf you don't have ffmpeg yet:\n\n-- Windows / Mac --\n1. Download a static build from http://ffmpeg.org\n2. Unzip it\n\n-- Linux --\n1. Install ffmpeg using your package manager\n\n-- When you already have ffmpeg --\nClick OK and select the ffmpeg or ffmpeg.exe program");
            this.parent.selectInput("Please select the previously downloaded ffmpeg or ffmpeg.exe executable", "onFfmpegSelected", new File("/"), (Object)this);
        } else {
            this.startFfmpeg(string);
        }
    }

    public int getCurrentFrame() {
        return this.frameCount;
    }

    public float getCurrentTime() {
        return (float)this.frameCount / this.ffmpegFrameRate;
    }

    public String getFfmpegPath() {
        return this.settings.getString(SETTINGS_FFMPEG_PATH, FFMPEG_PATH_UNSET);
    }

    public void forgetFfmpegPath() {
        this.settings.setString(SETTINGS_FFMPEG_PATH, FFMPEG_PATH_UNSET);
        this.parent.saveJSONObject(this.settings, this.settingsPath);
    }

    public void onFfmpegSelected(File file) {
        if (file == null) {
            System.err.println("The VideoExport library requires ffmpeg but it was not found. Please try again or read the library documentation.");
        } else {
            String string = file.getAbsolutePath();
            System.out.println("ffmpeg selected at " + string);
            this.settings.setString(SETTINGS_FFMPEG_PATH, string);
            this.parent.saveJSONObject(this.settings, this.settingsPath);
            this.startFfmpeg(string);
        }
    }

    protected void startFfmpeg(String string) {
        if (this.img.pixelWidth == 0 || this.img.pixelHeight == 0) {
            this.err("The export image size is 0!");
        }
        if (this.img.pixelWidth % 2 == 1 || this.img.pixelHeight % 2 == 1) {
            this.err("Width and height can only be even numbers when using the h264 encoder\nbut the requested image size is " + this.img.pixelWidth + "x" + this.img.pixelHeight);
        }
        String string2 = this.settings.getString(SETTINGS_CMD_ENCODE_VIDEO, CMD_ENCODE_VIDEO_DEFAULT);
        String[] stringArray = string2.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace("[ffmpeg]", string);
            stringArray[i] = stringArray[i].replace("[width]", "" + this.img.pixelWidth);
            stringArray[i] = stringArray[i].replace("[height]", "" + this.img.pixelHeight);
            stringArray[i] = stringArray[i].replace("[fps]", "" + this.ffmpegFrameRate);
            stringArray[i] = stringArray[i].replace("[crf]", "" + this.ffmpegCrfQuality);
            stringArray[i] = stringArray[i].replace("[comment]", "Exported using https://github.com/hamoid/VideoExport-for-Processing");
            stringArray[i] = stringArray[i].replace("[output]", this.outputFilePath);
        }
        this.processBuilder = new ProcessBuilder(stringArray);
        this.processBuilder.redirectErrorStream(true);
        this.ffmpegOutputMsg = new File(this.parent.sketchPath("ffmpeg.txt"));
        this.processBuilder.redirectOutput(this.ffmpegOutputMsg);
        this.processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE);
        try {
            this.process = this.processBuilder.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.err();
        }
        this.ffmpeg = this.process.getOutputStream();
        this.ffmpegFound = true;
        this.frameCount = 0;
    }

    public void startMovie() {
        this.initialize();
    }

    public void endMovie() {
        if (this.ffmpeg != null) {
            try {
                this.ffmpeg.flush();
                this.ffmpeg.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.ffmpeg = null;
        }
        if (this.process != null) {
            try {
                if (PApplet.platform == 1) {
                    String string;
                    ProcessBuilder processBuilder = new ProcessBuilder("tasklist");
                    Process process = processBuilder.start();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    Pattern pattern = Pattern.compile("ffmpeg\\.exe.*?([0-9]+)");
                    while ((string = bufferedReader.readLine()) != null) {
                        Matcher matcher = pattern.matcher(string);
                        if (!matcher.find()) continue;
                        Kernel32 kernel32 = Kernel32.INSTANCE;
                        kernel32.GenerateConsoleCtrlEvent(0, Integer.parseInt(matcher.group(1)));
                        break;
                    }
                } else {
                    this.process.destroy();
                }
                this.process.waitFor();
                if (this.audioFilePath != null && !this.audioFilePath.isEmpty()) {
                    this.attachSound();
                    this.audioFilePath = null;
                }
                if (!this.saveDebugInfo && this.ffmpegOutputMsg.isFile()) {
                    this.ffmpegOutputMsg.delete();
                    this.ffmpegOutputMsg = null;
                }
                PApplet.println((Object[])new Object[]{this.outputFilePath, "saved."});
            }
            catch (InterruptedException interruptedException) {
                PApplet.println((String)"Waiting for ffmpeg timed out!");
                interruptedException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.processBuilder = null;
            this.process = null;
        }
    }

    protected void attachSound() {
        File file = new File(this.audioFilePath);
        if (!file.exists() || !file.isFile()) {
            System.err.println("The file " + this.audioFilePath + " was not found or is not a regular file.");
            return;
        }
        String string = this.settings.getString(SETTINGS_CMD_ENCODE_AUDIO, CMD_ENCODE_AUDIO_DEFAULT);
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace("[ffmpeg]", this.getFfmpegPath());
            stringArray[i] = stringArray[i].replace("[inputvideo]", this.outputFilePath);
            stringArray[i] = stringArray[i].replace("[inputaudio]", this.audioFilePath);
            stringArray[i] = stringArray[i].replace("[bitrate]", "" + this.ffmpegAudioBitRate);
            stringArray[i] = stringArray[i].replace("[comment]", "Exported using https://github.com/hamoid/VideoExport-for-Processing");
            stringArray[i] = stringArray[i].replace("[output]", this.parent.sketchFile("temp-with-audio.mp4").getAbsolutePath());
        }
        this.processBuilder = new ProcessBuilder(stringArray);
        this.processBuilder.redirectErrorStream(true);
        this.ffmpegOutputMsg = new File(this.parent.sketchPath("ffmpeg-audio.txt"));
        this.processBuilder.redirectOutput(this.ffmpegOutputMsg);
        try {
            this.process = this.processBuilder.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.err();
        }
        if (this.process != null) {
            try {
                this.process.waitFor();
                new File(this.outputFilePath).delete();
                this.parent.sketchFile("temp-with-audio.mp4").renameTo(new File(this.outputFilePath));
            }
            catch (InterruptedException interruptedException) {
                PApplet.println((String)"Waiting for ffmpeg while adding audio timed out!");
                interruptedException.printStackTrace();
            }
        }
        if (!this.saveDebugInfo && this.ffmpegOutputMsg.isFile()) {
            this.ffmpegOutputMsg.delete();
        }
        this.ffmpegOutputMsg = null;
        this.processBuilder = null;
        this.process = null;
    }

    public void dispose() {
        this.endMovie();
    }

    protected void err(String string) {
        System.err.println("\nVideoExport error: " + string + "\n");
        System.exit(1);
    }

    protected void err() {
        this.err("Ffmpeg failed. Study " + this.ffmpegOutputMsg + " for more details.");
    }
}

