

	org #8000

	;test code

begin

	ld hl,music_data
	call play
	ret
	


play

	di

	ld (drumList),hl
	
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	
	push iy
	exx
	push hl
	ld (spOld),sp

	ld hl,0				;HL'=acc3
	ld de,0				;DE'=add2
	ld bc,#8080			;C'=duty 1,B'=duty 2
	exx
	ld de,0				;DE=add1
	ld ix,0				;IX=acc2
	ld iy,0				;IY=acc1
	ld sp,0				;SP=add3
	
	;BC is sample/frame counter
	;HL is the song data ptr, to minimize row transition gaps
	
playRow

	ld a,(hl)			;drum and speed
	inc hl
	
	or a
	;jp nz,noLoop
    jp z,stopPlayer
	
	;ld a,(hl)			;go loop
	;inc hl
	;ld h,(hl)
	;ld l,a
	;jp playRow
	
noLoop

	cp #20
	jp nc,playDrum

	and #1f
	ld (frames),a
	
	ld a,(hl)			;ch1
	inc hl
	or a
	jr z,skipCh1
	dec a
	jp nz,noteCh1
	
	ld de,0				;mute ch1
	ld iy,0
	exx
	ld c,0
	exx
	
	jp skipCh1
	
noteCh1

	inc a
	ld c,a
	and #f0
	exx
	ld c,a
	exx
	
	ld a,c
	and #0f
	ld d,a				;msb
	
	ld e,(hl)			;lsb
	inc hl

skipCh1
	
	ld a,(hl)			;ch2
	inc hl
	or a
	jr z,skipCh2
	dec a
	jp nz,noteCh2
	
	exx					;mute ch2
	ld de,0
	ld b,0
	exx
	ld ix,0
	
	jp skipCh2
	
noteCh2

	inc a
	ld c,a
	and #f0
	exx
	ld b,a
	exx
	
	ld a,c
	and #0f
	exx
	ld d,a				;msb
	exx
	
	ld a,(hl)
	inc hl
	exx
	ld e,a				;lsb
	exx
	
skipCh2

	ld a,(hl)			;ch3
	inc hl
	or a
	jr z,skipCh3
	dec a
	jp nz,noteCh3
	
	ld sp,0				;mute ch3
	exx
	ld hl,0
	exx
	ld (duty3),a
	
	jp skipCh3
	
noteCh3

	inc a
	ld c,a
	and #f0
	ld (duty3),a
	
	ld a,c
	and #0f
	ld b,a				;msb
	
	ld c,(hl)			;lsb
	inc hl
	ld (ch3sp),bc
	
ch3sp equ $+1
	ld sp,0

skipCh3
			
duty3 equ $+1
	ld bc,0				;B equ sample counter,C equ duty3

frames equ $+1
	ld a,0
	
frameLoop

	ex af,af'					;4
	
sampleLoop

	add iy,de			;15
	ld a,iyh			;8
	exx					;4
	cp c				;4
	sbc a,a				;4
	add ix,de			;15
	out (#fe),a			;11
	
	ld a,ixh			;8
	cp b				;4
	sbc a,a				;4
	out (#fe),a			;11

	add hl,sp			;11
	ld a,h				;4
	exx					;4
	cp c				;4
	sbc a,a				;4
	out (#fe),a			;11

	nop					;4 for 8t alignment
	dec b				;4
	jp nz,sampleLoop	;10=144t

	ex af,af'					;4
	dec a				;4
	jr nz,frameLoop		;12=extra 24t, also aligned to 8t

	in a,(#fe)			;check keyboard
	cpl
	and #1f
	jp z,playRow

	
	
stopPlayer

spOld equ $+1

	ld sp,0
	pop hl
	exx
	pop iy
	ei
	ret



playDrum

	ld (hlOld),hl
	
	rra
	rra
	rra
	and #1c

	ld c,a
	ld b,0
	
drumList equ $+1
	ld hl,0
	add hl,bc

	ld b,(hl)			;length in frames
	inc hl
	inc hl

	ld a,(hl)
	inc hl
	ld h,(hl)			;sample data
	ld l,a

	ld a,1
	ld (drumMask),a

	ld c,0
	
drumLoop

	ld a,(hl)			;7
	
drumMask equ $+1
	and 0				;7
	sub 1				;7
	sbc a,a				;4
	and #18				;7
	out (#fe),a			;11
	
	ld a,(drumMask)		;13
	rlc a				;8
	ld (drumMask),a		;13
	
	jr nc,$+3			;7/12
	inc hl				;6

	jr $+2				;12
	jr $+2				;12
	nop					;4
	nop					;4
	ld a,0				;7

	dec c				;4
	jr nz,drumLoop		;7/12=144t
	
	djnz drumLoop

hlOld equ $+1
	ld hl,0
	
	jp playRow
	
;compiled music data

music_data
	dw .song,0
.drums
	dw 3,.drum0
	dw 1,.drum1
	dw 1,.drum2
	dw 4,.drum3
	dw 4,.drum4
	dw 4,.drum5
	dw 4,.drum6
.song
.loop
	db #07,#01,#e3,#ad,#01
	db #07,#00,#e1,#d6,#00
	db #05,#00,#90,#75,#00
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#e4,#5f,#00
	db #05,#00,#e2,#2f,#00
	db #07,#00,#90,#58,#00
	db #07,#00,#01,#00
	db #05,#00,#93,#ad,#00
	db #05,#00,#91,#d6,#00
	db #07,#00,#01,#00
	db #07,#00,#90,#68,#00
	db #05,#00,#93,#ad,#00
	db #05,#00,#01,#00
	db #07,#00,#b4,#e8,#00
	db #07,#00,#b2,#74,#00
	db #05,#00,#b4,#5f,#00
	db #05,#00,#b2,#2f,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#e3,#ad,#00
	db #05,#00,#e1,#d6,#00
	db #07,#00,#90,#9d,#00
	db #07,#00,#00,#00
	db #05,#00,#92,#c1,#00
	db #05,#00,#91,#60,#00
	db #07,#00,#93,#46,#00
	db #07,#00,#91,#a3,#00
	db #05,#00,#01,#00
	db #05,#00,#00,#00
	db #07,#00,#91,#d6,#00
	db #07,#00,#00,#00
	db #05,#00,#90,#75,#00
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#e2,#2f,#00
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#e1,#d6,#00
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#e3,#ad,#00
	db #05,#00,#01,#00
	db #07,#00,#e2,#74,#00
	db #07,#00,#00,#00
	db #05,#00,#e2,#2f,#00
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#e1,#d6,#00
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#00,#00
	db #05,#00,#00,#00
	db #07,#80,#b0,#00,#00
	db #07,#80,#a6,#00,#00
	db #05,#80,#9d,#00,#00
	db #05,#80,#8b,#00,#00
	db #07,#b5,#82,#e3,#ad,#00
	db #07,#00,#e1,#d6,#00
	db #05,#b4,#5f,#90,#75,#00
	db #05,#b3,#ad,#00,#00
	db #07,#80,#75,#01,#00
	db #07,#01,#00,#00
	db #05,#00,#e4,#5f,#00
	db #05,#00,#e2,#2f,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#e3,#ad,#00
	db #05,#00,#e1,#d6,#00
	db #07,#00,#00,#00
	db #07,#00,#01,#00
	db #05,#00,#e3,#ad,#00
	db #05,#00,#01,#00
	db #07,#00,#e4,#e8,#00
	db #07,#00,#e2,#74,#00
	db #05,#00,#e4,#5f,#00
	db #05,#00,#e2,#2f,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#d4,#e8,#e3,#ad,#00
	db #05,#00,#e1,#d6,#00
	db #07,#d4,#5f,#01,#00
	db #07,#d3,#ad,#00,#00
	db #05,#01,#e2,#c1,#00
	db #05,#00,#e1,#60,#00
	db #07,#95,#82,#e3,#46,#00
	db #07,#00,#e1,#a3,#00
	db #05,#94,#5f,#01,#00
	db #05,#93,#ad,#00,#00
	db #07,#01,#e1,#d6,#00
	db #07,#00,#00,#00
	db #05,#00,#90,#75,#00
	db #05,#00,#00,#00
	db #07,#90,#75,#01,#00
	db #07,#01,#00,#00
	db #05,#00,#e2,#2f,#00
	db #05,#00,#00,#00
	db #07,#00,#90,#58,#00
	db #07,#00,#00,#00
	db #05,#00,#e1,#d6,#00
	db #05,#00,#00,#00
	db #07,#00,#90,#68,#00
	db #07,#00,#00,#00
	db #05,#00,#e3,#ad,#00
	db #05,#00,#01,#00
	db #07,#00,#e2,#74,#00
	db #07,#00,#00,#00
	db #05,#00,#e2,#2f,#00
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#e1,#d6,#00
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#e1,#60,#00
	db #05,#00,#00,#00
	db #07,#90,#b0,#e1,#a3,#00
	db #07,#90,#a6,#00,#00
	db #05,#90,#9d,#00,#00
	db #05,#90,#8b,#e1,#bc,#00
	db #20
	db #04,#b5,#82,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#b4,#5f,#90,#75,#01
	db #05,#b3,#ad,#00,#00
	db #20
	db #04,#80,#75,#01,#00
	db #07,#01,#00,#00
	db #40
	db #04,#00,#e4,#5f,#90,#b0
	db #05,#00,#e2,#2f,#00
	db #07,#00,#90,#58,#01
	db #07,#00,#01,#00
	db #40
	db #04,#00,#93,#ad,#90,#d1
	db #05,#00,#91,#d6,#00
	db #20
	db #04,#00,#00,#90,#68
	db #07,#00,#90,#68,#01
	db #05,#00,#93,#ad,#00
	db #05,#00,#01,#00
	db #20
	db #04,#00,#b4,#e8,#90,#eb
	db #07,#00,#b2,#74,#00
	db #20
	db #02,#80,#75,#b4,#5f,#01
	db #05,#00,#b2,#2f,#00
	db #07,#01,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#d4,#e8,#e3,#ad,#91,#3a
	db #05,#01,#e1,#d6,#00
	db #20
	db #04,#d4,#5f,#01,#01
	db #07,#d3,#ad,#00,#00
	db #60
	db #04,#01,#e2,#c1,#91,#17
	db #05,#00,#e1,#60,#00
	db #20
	db #04,#95,#82,#e3,#46,#01
	db #07,#00,#e1,#a3,#00
	db #05,#94,#5f,#01,#00
	db #05,#93,#ad,#00,#00
	db #20
	db #04,#01,#e1,#d6,#90,#eb
	db #07,#00,#00,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#90,#75,#01,#00
	db #07,#01,#00,#00
	db #60
	db #04,#00,#e2,#2f,#90,#b0
	db #05,#00,#00,#00
	db #07,#00,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e1,#d6,#90,#d1
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#01
	db #07,#00,#00,#00
	db #05,#00,#e3,#ad,#00
	db #05,#00,#01,#00
	db #20
	db #04,#00,#e2,#74,#90,#eb
	db #07,#00,#00,#00
	db #20
	db #02,#00,#e2,#2f,#01
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e1,#d6,#91,#3a
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#01
	db #07,#00,#00,#00
	db #05,#00,#e1,#60,#91,#60
	db #05,#00,#00,#00
	db #60
	db #06,#90,#b0,#e1,#a3,#01
	db #07,#90,#a6,#00,#00
	db #05,#90,#9d,#00,#00
	db #05,#90,#8b,#e1,#bc,#00
	db #20
	db #04,#b5,#82,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#b4,#5f,#90,#75,#01
	db #05,#b3,#ad,#00,#00
	db #20
	db #04,#80,#75,#01,#00
	db #07,#01,#00,#00
	db #40
	db #04,#00,#e4,#5f,#90,#b0
	db #05,#00,#e2,#2f,#00
	db #07,#00,#90,#58,#01
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e3,#ad,#90,#d1
	db #05,#00,#e1,#d6,#00
	db #20
	db #04,#80,#68,#00,#01
	db #07,#00,#01,#00
	db #05,#01,#e3,#ad,#00
	db #05,#00,#01,#00
	db #20
	db #04,#00,#e4,#e8,#90,#eb
	db #07,#00,#e2,#74,#90,#75
	db #20
	db #02,#80,#75,#e4,#5f,#01
	db #05,#00,#e2,#2f,#00
	db #07,#01,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#d4,#e8,#e3,#ad,#91,#3a
	db #05,#00,#e1,#d6,#00
	db #07,#d4,#5f,#e0,#9d,#01
	db #07,#d3,#ad,#00,#00
	db #40
	db #04,#01,#e2,#c1,#91,#17
	db #05,#00,#e1,#60,#00
	db #20
	db #04,#95,#82,#e3,#46,#01
	db #07,#00,#e1,#a3,#00
	db #05,#94,#5f,#01,#00
	db #05,#93,#ad,#00,#00
	db #20
	db #04,#01,#e1,#d6,#90,#eb
	db #07,#00,#00,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#90,#75,#01,#00
	db #07,#01,#00,#00
	db #40
	db #04,#00,#e2,#2f,#90,#b0
	db #05,#00,#00,#00
	db #07,#00,#01,#01
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e1,#d6,#90,#d1
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#01
	db #07,#00,#00,#00
	db #05,#00,#e3,#ad,#00
	db #05,#00,#01,#00
	db #20
	db #04,#00,#e2,#74,#90,#eb
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e2,#c1,#01
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e2,#74,#91,#3a
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e1,#60,#91,#60
	db #05,#00,#00,#00
	db #40
	db #06,#90,#b0,#e1,#a3,#01
	db #07,#90,#a6,#00,#00
	db #05,#90,#9d,#00,#00
	db #05,#90,#8b,#e1,#bc,#00
	db #20
	db #04,#e4,#e8,#e2,#74,#91,#3a
	db #07,#00,#01,#01
	db #20
	db #02,#e4,#5f,#e2,#74,#91,#3a
	db #05,#e3,#ad,#00,#90,#9d
	db #07,#e2,#74,#01,#01
	db #07,#01,#00,#00
	db #60
	db #04,#00,#e2,#74,#91,#3a
	db #05,#00,#00,#00
	db #07,#00,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e2,#2f,#91,#17
	db #05,#00,#00,#00
	db #20
	db #04,#00,#e2,#74,#91,#3a
	db #07,#00,#00,#00
	db #05,#e3,#ad,#01,#01
	db #05,#e4,#5f,#00,#00
	db #20
	db #04,#e5,#d6,#00,#00
	db #07,#00,#00,#00
	db #05,#e4,#e8,#00,#00
	db #05,#e3,#ad,#00,#00
	db #20
	db #04,#e3,#17,#e1,#d6,#90,#eb
	db #07,#01,#01,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #07,#e0,#75,#01,#00
	db #07,#01,#00,#00
	db #40
	db #04,#00,#e2,#2f,#91,#17
	db #40
	db #04,#00,#01,#90,#8b
	db #20
	db #04,#00,#90,#8b,#01
	db #07,#00,#00,#00
	db #05,#00,#01,#00
	db #05,#e0,#8b,#00,#00
	db #20
	db #04,#e5,#d6,#e2,#74,#91,#3a
	db #07,#01,#01,#90,#9d
	db #05,#e5,#d6,#e2,#74,#00
	db #05,#00,#00,#01
	db #20
	db #04,#01,#90,#9d,#00
	db #07,#00,#00,#00
	db #40
	db #04,#e5,#d6,#e2,#74,#90,#75
	db #05,#00,#01,#00
	db #07,#01,#90,#75,#01
	db #07,#00,#00,#00
	db #40
	db #04,#e4,#e8,#e2,#2f,#91,#17
	db #05,#01,#01,#01
	db #20
	db #04,#e5,#d6,#e2,#74,#91,#3a
	db #07,#01,#00,#90,#9d
	db #20
	db #02,#e6,#8d,#e2,#c1,#91,#60
	db #05,#00,#00,#90,#b0
	db #07,#00,#01,#01
	db #07,#01,#00,#00
	db #60
	db #04,#e6,#8d,#00,#00
	db #05,#01,#00,#00
	db #20
	db #04,#e6,#8d,#e1,#d6,#90,#eb
	db #07,#01,#01,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #07,#e0,#75,#01,#00
	db #07,#01,#00,#00
	db #20
	db #02,#00,#e2,#2f,#91,#17
	db #05,#00,#01,#90,#8b
	db #07,#00,#90,#8b,#01
	db #07,#00,#00,#00
	db #05,#e0,#8b,#01,#00
	db #05,#01,#00,#00
	db #07,#f3,#ad,#f2,#eb,#f2,#74
	db #07,#01,#01,#01
	db #05,#e3,#ad,#f2,#eb,#f2,#74
	db #05,#00,#00,#00
	db #07,#01,#01,#01
	db #07,#00,#00,#00
	db #05,#d3,#ad,#f2,#eb,#f2,#74
	db #05,#00,#00,#00
	db #07,#01,#01,#01
	db #07,#00,#00,#00
	db #05,#c3,#46,#f2,#c1,#f2,#2f
	db #05,#00,#00,#00
	db #07,#b3,#ad,#f2,#eb,#f2,#74
	db #07,#00,#00,#00
	db #05,#e3,#ad,#01,#01
	db #05,#e2,#eb,#00,#00
	db #07,#e2,#74,#00,#00
	db #07,#01,#00,#00
	db #05,#e4,#e8,#00,#f0,#a6
	db #05,#e3,#ad,#00,#f0,#ba
	db #20
	db #04,#e3,#17,#e1,#d6,#90,#eb
	db #07,#01,#01,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #07,#e0,#75,#01,#00
	db #07,#01,#00,#00
	db #60
	db #04,#00,#e2,#2f,#91,#17
	db #05,#00,#01,#90,#8b
	db #20
	db #04,#00,#90,#8b,#01
	db #07,#00,#00,#00
	db #05,#00,#01,#00
	db #05,#e0,#8b,#00,#00
	db #20
	db #04,#e5,#d6,#e2,#74,#91,#3a
	db #07,#01,#01,#90,#9d
	db #05,#e5,#d6,#e2,#74,#00
	db #05,#00,#00,#01
	db #20
	db #04,#01,#90,#9d,#00
	db #07,#00,#00,#00
	db #40
	db #04,#e5,#d6,#e2,#74,#90,#75
	db #05,#00,#01,#00
	db #07,#01,#90,#75,#01
	db #07,#00,#00,#00
	db #40
	db #04,#e4,#e8,#e2,#2f,#91,#17
	db #05,#01,#01,#01
	db #20
	db #04,#e5,#d6,#e2,#74,#91,#3a
	db #07,#01,#00,#90,#9d
	db #05,#e6,#8d,#e2,#c1,#91,#60
	db #05,#e6,#85,#00,#90,#b0
	db #20
	db #04,#e6,#7d,#01,#01
	db #07,#01,#00,#00
	db #20
	db #02,#e5,#82,#00,#00
	db #05,#e4,#5f,#00,#00
	db #07,#e3,#ad,#e2,#2f,#91,#17
	db #07,#01,#01,#90,#8b
	db #05,#00,#90,#8b,#01
	db #05,#00,#00,#00
	db #07,#e0,#8b,#01,#00
	db #07,#01,#00,#00
	db #60
	db #04,#00,#e1,#a3,#90,#d1
	db #05,#00,#01,#90,#68
	db #20
	db #04,#00,#90,#68,#01
	db #07,#00,#00,#00
	db #05,#e0,#68,#01,#00
	db #05,#01,#00,#00
	db #20
	db #04,#00,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#90,#b0
	db #05,#00,#e2,#2f,#00
	db #07,#00,#90,#58,#01
	db #07,#00,#01,#00
	db #40
	db #04,#00,#93,#ad,#90,#d1
	db #05,#00,#91,#d6,#00
	db #20
	db #04,#00,#00,#90,#68
	db #07,#00,#90,#68,#01
	db #05,#00,#93,#ad,#00
	db #05,#00,#01,#00
	db #20
	db #04,#00,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#90,#b0
	db #05,#00,#e2,#2f,#00
	db #07,#00,#90,#58,#01
	db #07,#00,#01,#00
	db #40
	db #04,#00,#93,#ad,#90,#d1
	db #05,#00,#91,#d6,#00
	db #20
	db #04,#00,#00,#90,#68
	db #07,#00,#90,#68,#01
	db #05,#00,#93,#ad,#00
	db #05,#00,#01,#00
	db #20
	db #04,#00,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#90,#b0
	db #05,#00,#e2,#2f,#00
	db #20
	db #04,#00,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#90,#b0
	db #05,#00,#e2,#2f,#00
	db #20
	db #04,#00,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #20
	db #02,#00,#e3,#ad,#90,#eb
	db #05,#00,#e1,#d6,#90,#75
	db #20
	db #04,#00,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #20
	db #02,#00,#e3,#ad,#90,#eb
	db #05,#00,#e1,#d6,#90,#75
	db #20
	db #04,#b5,#82,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#b4,#5f,#90,#75,#01
	db #05,#b3,#ad,#00,#00
	db #20
	db #04,#b5,#82,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#b4,#5f,#e4,#5f,#90,#b0
	db #05,#b3,#ad,#e2,#2f,#00
	db #07,#b5,#82,#90,#58,#01
	db #07,#00,#01,#00
	db #40
	db #04,#b4,#5f,#93,#ad,#90,#d1
	db #05,#b3,#ad,#91,#d6,#00
	db #20
	db #04,#b4,#e8,#00,#90,#68
	db #07,#00,#90,#68,#01
	db #05,#b4,#5f,#93,#ad,#00
	db #05,#b3,#ad,#01,#00
	db #20
	db #04,#b9,#d1,#b4,#e8,#90,#eb
	db #07,#00,#b2,#74,#00
	db #20
	db #02,#b8,#bf,#b4,#5f,#01
	db #05,#00,#b2,#2f,#00
	db #07,#b7,#5b,#01,#00
	db #07,#01,#00,#00
	db #60
	db #04,#b5,#82,#e3,#ad,#91,#3a
	db #05,#01,#e1,#d6,#90,#9d
	db #20
	db #04,#b4,#5f,#90,#9d,#01
	db #07,#00,#00,#00
	db #60
	db #04,#b3,#ad,#92,#c1,#91,#17
	db #05,#b2,#c1,#91,#60,#90,#8b
	db #20
	db #04,#94,#5f,#93,#46,#00
	db #07,#00,#91,#a3,#01
	db #05,#97,#5b,#01,#00
	db #05,#95,#82,#00,#00
	db #20
	db #04,#01,#91,#d6,#90,#eb
	db #07,#00,#00,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#94,#5f,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#93,#ad,#e2,#2f,#90,#b0
	db #05,#92,#c1,#00,#00
	db #07,#95,#82,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#94,#5f,#e1,#d6,#90,#d1
	db #05,#93,#ad,#00,#00
	db #20
	db #04,#94,#e8,#01,#01
	db #07,#00,#00,#00
	db #05,#94,#5f,#e3,#ad,#00
	db #05,#93,#ad,#01,#00
	db #20
	db #04,#94,#e8,#e2,#74,#90,#eb
	db #07,#00,#00,#00
	db #60
	db #04,#94,#5f,#e2,#2f,#01
	db #05,#93,#ad,#00,#00
	db #07,#94,#5f,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#93,#46,#e1,#d6,#91,#3a
	db #05,#92,#c1,#00,#00
	db #20
	db #04,#00,#01,#01
	db #07,#00,#00,#00
	db #05,#00,#e1,#60,#91,#60
	db #05,#00,#00,#00
	db #20
	db #04,#90,#b0,#e1,#a3,#01
	db #07,#90,#a6,#00,#00
	db #05,#90,#9d,#00,#00
	db #05,#90,#8b,#e1,#bc,#00
	db #20
	db #04,#d4,#5f,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#d3,#ad,#90,#75,#01
	db #05,#d2,#c1,#00,#00
	db #20
	db #04,#d4,#5f,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#d3,#ad,#e4,#5f,#90,#b0
	db #05,#d2,#c1,#e2,#2f,#00
	db #07,#d4,#5f,#01,#01
	db #07,#00,#00,#00
	db #60
	db #04,#d3,#ad,#e3,#ad,#90,#d1
	db #05,#d2,#c1,#e1,#d6,#00
	db #20
	db #04,#d4,#e8,#00,#01
	db #07,#00,#01,#00
	db #05,#d3,#ad,#e3,#ad,#00
	db #05,#d2,#c1,#01,#00
	db #20
	db #04,#d4,#e8,#e4,#e8,#90,#eb
	db #07,#00,#e2,#74,#00
	db #20
	db #02,#d3,#ad,#e4,#5f,#01
	db #05,#d2,#c1,#e2,#2f,#00
	db #07,#d4,#5f,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#d3,#ad,#e3,#ad,#91,#3a
	db #05,#d2,#c1,#e1,#d6,#00
	db #07,#d5,#82,#01,#01
	db #07,#00,#00,#00
	db #60
	db #04,#e5,#82,#e2,#c1,#91,#17
	db #05,#00,#e1,#60,#00
	db #20
	db #04,#f5,#82,#e3,#46,#01
	db #07,#00,#e1,#a3,#00
	db #05,#f4,#5f,#01,#00
	db #05,#f3,#ad,#00,#00
	db #20
	db #04,#01,#e1,#d6,#90,#eb
	db #07,#00,#00,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#90,#75,#01,#00
	db #07,#01,#00,#00
	db #60
	db #04,#b4,#5f,#e2,#2f,#90,#b0
	db #05,#00,#00,#90,#58
	db #07,#01,#90,#58,#01
	db #07,#00,#00,#00
	db #60
	db #04,#b3,#ad,#e1,#d6,#90,#d1
	db #05,#00,#00,#90,#68
	db #20
	db #04,#01,#90,#68,#01
	db #07,#00,#00,#00
	db #05,#b5,#82,#e3,#ad,#00
	db #05,#01,#01,#00
	db #20
	db #04,#b6,#8d,#e2,#74,#90,#eb
	db #07,#00,#00,#00
	db #20
	db #02,#b7,#5b,#e2,#c1,#01
	db #05,#00,#00,#00
	db #07,#01,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#b6,#8d,#e2,#74,#91,#3a
	db #05,#00,#00,#00
	db #07,#01,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#b4,#e8,#e1,#60,#91,#60
	db #05,#00,#00,#00
	db #20
	db #04,#b0,#b0,#e1,#a3,#01
	db #07,#b0,#a6,#00,#00
	db #20
	db #02,#b0,#9d,#00,#00
	db #05,#b0,#8b,#e1,#bc,#00
	db #20
	db #04,#b7,#5b,#e4,#e8,#91,#3a
	db #07,#00,#e2,#74,#90,#9d
	db #05,#b5,#d6,#90,#9d,#01
	db #05,#b4,#e8,#00,#00
	db #20
	db #04,#b7,#5b,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#b5,#d6,#e5,#d6,#90,#eb
	db #05,#b4,#e8,#e2,#eb,#00
	db #07,#b7,#5b,#90,#75,#01
	db #07,#00,#01,#00
	db #60
	db #04,#b5,#d6,#94,#e8,#91,#17
	db #05,#b4,#e8,#92,#74,#00
	db #20
	db #04,#b6,#8d,#00,#90,#8b
	db #07,#00,#90,#8b,#01
	db #05,#b5,#d6,#94,#e8,#00
	db #05,#b4,#e8,#01,#00
	db #20
	db #04,#e6,#8d,#b6,#8d,#91,#3a
	db #07,#00,#b3,#46,#90,#9d
	db #20
	db #02,#e5,#d6,#b5,#d6,#00
	db #05,#00,#b2,#eb,#01
	db #07,#01,#90,#9d,#00
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e4,#e8,#91,#a3
	db #05,#00,#e2,#74,#90,#d1
	db #20
	db #04,#b5,#d6,#90,#d1,#01
	db #07,#00,#00,#00
	db #40
	db #04,#b4,#e8,#93,#ad,#91,#75
	db #05,#b3,#ad,#91,#d6,#90,#ba
	db #20
	db #04,#95,#d6,#94,#5f,#00
	db #07,#00,#92,#2f,#01
	db #05,#99,#d1,#01,#00
	db #05,#97,#5b,#00,#00
	db #20
	db #04,#01,#92,#74,#91,#3a
	db #07,#00,#00,#90,#9d
	db #05,#00,#90,#9d,#01
	db #05,#00,#00,#00
	db #20
	db #04,#95,#d6,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#94,#e8,#e2,#eb,#90,#eb
	db #05,#93,#ad,#00,#00
	db #07,#97,#5b,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#95,#d6,#e2,#74,#91,#17
	db #05,#94,#e8,#00,#00
	db #20
	db #04,#96,#8d,#01,#01
	db #07,#00,#00,#00
	db #05,#95,#d6,#e4,#e8,#00
	db #05,#94,#e8,#01,#00
	db #20
	db #04,#96,#8d,#e3,#46,#91,#3a
	db #07,#00,#00,#00
	db #20
	db #02,#95,#d6,#e2,#eb,#01
	db #05,#94,#e8,#00,#00
	db #07,#95,#d6,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#94,#5f,#e2,#74,#91,#a3
	db #05,#93,#ad,#00,#00
	db #20
	db #04,#00,#01,#01
	db #07,#00,#00,#00
	db #05,#00,#e1,#d6,#91,#d6
	db #05,#00,#00,#00
	db #60
	db #06,#90,#eb,#e2,#2f,#01
	db #07,#90,#de,#00,#00
	db #05,#90,#d1,#00,#00
	db #05,#90,#ba,#e2,#51,#00
	db #20
	db #04,#d5,#d6,#e4,#e8,#91,#3a
	db #07,#00,#e2,#74,#90,#9d
	db #05,#d4,#e8,#90,#9d,#01
	db #05,#d3,#ad,#00,#00
	db #20
	db #04,#d5,#d6,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#d4,#e8,#e5,#d6,#90,#eb
	db #05,#d3,#ad,#e2,#eb,#00
	db #07,#d5,#d6,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#d4,#e8,#e4,#e8,#91,#17
	db #05,#d3,#ad,#e2,#74,#00
	db #20
	db #04,#d6,#8d,#00,#01
	db #07,#00,#01,#00
	db #05,#d4,#e8,#e4,#e8,#00
	db #05,#d3,#ad,#01,#00
	db #20
	db #04,#d6,#8d,#e6,#8d,#91,#3a
	db #07,#00,#e3,#46,#00
	db #20
	db #02,#d4,#e8,#e5,#d6,#01
	db #05,#d3,#ad,#e2,#eb,#00
	db #07,#d5,#d6,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#d4,#e8,#e4,#e8,#91,#a3
	db #05,#d3,#ad,#e2,#74,#00
	db #07,#d9,#d1,#01,#01
	db #07,#00,#00,#00
	db #60
	db #04,#e9,#d1,#e3,#ad,#91,#75
	db #05,#00,#e1,#d6,#00
	db #20
	db #04,#f9,#d1,#e4,#5f,#01
	db #07,#00,#e2,#2f,#00
	db #05,#00,#01,#00
	db #05,#00,#00,#00
	db #20
	db #04,#00,#e2,#74,#91,#3a
	db #07,#00,#00,#90,#9d
	db #05,#00,#90,#9d,#01
	db #05,#00,#00,#00
	db #20
	db #04,#f7,#5b,#01,#00
	db #07,#f5,#d6,#00,#00
	db #40
	db #04,#00,#e2,#eb,#90,#eb
	db #05,#00,#00,#90,#75
	db #07,#01,#90,#75,#01
	db #07,#00,#00,#00
	db #40
	db #04,#b4,#e8,#e2,#74,#91,#17
	db #05,#00,#00,#90,#8b
	db #20
	db #04,#01,#90,#8b,#01
	db #07,#00,#00,#00
	db #05,#b7,#5b,#e4,#e8,#00
	db #05,#01,#01,#00
	db #20
	db #04,#b8,#bf,#e3,#46,#91,#3a
	db #07,#00,#00,#00
	db #20
	db #02,#b9,#d1,#e3,#ad,#01
	db #05,#00,#00,#00
	db #07,#01,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#b8,#bf,#e3,#46,#91,#a3
	db #05,#00,#00,#00
	db #07,#01,#01,#01
	db #07,#00,#00,#00
	db #60
	db #04,#b6,#8d,#e1,#d6,#91,#d6
	db #05,#00,#00,#00
	db #20
	db #04,#b0,#eb,#e2,#2f,#01
	db #07,#b0,#de,#00,#00
	db #20
	db #02,#b0,#d1,#00,#00
	db #05,#b0,#ba,#e2,#51,#00
	db #20
	db #04,#f1,#d6,#e5,#82,#00
	db #07,#00,#00,#00
	db #05,#00,#e4,#5f,#00
	db #05,#00,#e3,#ad,#00
	db #20
	db #04,#00,#e5,#82,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#00
	db #05,#00,#e3,#ad,#00
	db #07,#00,#e4,#e8,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#00
	db #05,#00,#e3,#ad,#00
	db #20
	db #04,#00,#e9,#d1,#00
	db #07,#00,#00,#00
	db #05,#00,#e8,#bf,#00
	db #05,#00,#00,#00
	db #20
	db #04,#00,#e7,#5b,#00
	db #07,#00,#01,#00
	db #20
	db #02,#00,#e5,#82,#00
	db #05,#00,#01,#00
	db #07,#00,#e4,#5f,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e3,#ad,#00
	db #05,#00,#e2,#c1,#00
	db #20
	db #04,#f3,#ad,#e4,#5f,#00
	db #07,#00,#00,#00
	db #60
	db #04,#f3,#46,#e7,#5b,#00
	db #05,#00,#e5,#82,#00
	db #20
	db #04,#f2,#74,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#00,#00
	db #05,#00,#00,#00
	db #20
	db #04,#f2,#2f,#e4,#5f,#00
	db #07,#00,#00,#00
	db #05,#00,#e3,#ad,#00
	db #05,#00,#e2,#c1,#00
	db #20
	db #04,#00,#e5,#82,#00
	db #07,#00,#00,#00
	db #05,#00,#e4,#5f,#00
	db #05,#00,#e3,#ad,#00
	db #40
	db #06,#00,#e4,#e8,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#00
	db #05,#00,#e3,#ad,#00
	db #20
	db #04,#00,#e4,#e8,#00
	db #07,#00,#00,#00
	db #05,#00,#e4,#5f,#00
	db #05,#00,#e3,#ad,#00
	db #20
	db #04,#00,#e4,#5f,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e3,#46,#00
	db #05,#00,#e2,#c1,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#00,#00
	db #05,#00,#00,#00
	db #20
	db #04,#f2,#10,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#00,#00
	db #05,#00,#00,#00
	db #20
	db #04,#f2,#2f,#e0,#b0,#00
	db #07,#00,#e0,#a6,#00
	db #05,#00,#e0,#9d,#00
	db #05,#00,#e0,#8b,#00
	db #20
	db #04,#f2,#74,#d4,#5f,#00
	db #07,#00,#00,#00
	db #05,#00,#d3,#ad,#00
	db #05,#00,#d2,#c1,#00
	db #40
	db #06,#00,#d4,#e8,#00
	db #07,#00,#00,#00
	db #20
	db #02,#00,#d3,#ad,#00
	db #05,#00,#d2,#c1,#00
	db #07,#00,#d4,#e8,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#d3,#ad,#00
	db #05,#00,#d2,#c1,#00
	db #20
	db #04,#00,#d4,#5f,#00
	db #07,#00,#00,#00
	db #05,#00,#d3,#ad,#00
	db #05,#00,#d2,#c1,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#00,#00
	db #05,#00,#00,#00
	db #40
	db #06,#00,#d5,#82,#00
	db #07,#00,#00,#00
	db #20
	db #02,#00,#e5,#82,#00
	db #05,#00,#00,#00
	db #07,#00,#f5,#82,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#f4,#5f,#00
	db #05,#00,#f3,#ad,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #05,#00,#00,#00
	db #05,#00,#00,#00
	db #20
	db #04,#f2,#2f,#90,#75,#00
	db #07,#00,#01,#00
	db #05,#00,#e4,#5f,#00
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e3,#ad,#00
	db #05,#00,#00,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e5,#82,#00
	db #05,#00,#01,#00
	db #20
	db #04,#00,#e6,#8d,#00
	db #07,#00,#00,#00
	db #05,#00,#e7,#5b,#00
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #20
	db #02,#00,#e6,#8d,#00
	db #05,#00,#00,#00
	db #07,#f2,#10,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#f2,#2f,#e4,#e8,#00
	db #05,#00,#00,#00
	db #07,#f2,#74,#f0,#b0,#00
	db #07,#00,#a0,#a6,#00
	db #40
	db #04,#f2,#2f,#a0,#9d,#00
	db #05,#00,#a0,#8b,#00
	db #20
	db #04,#f2,#10,#e5,#82,#00
	db #07,#00,#00,#00
	db #20
	db #02,#f2,#74,#e4,#5f,#00
	db #05,#00,#e3,#ad,#00
	db #20
	db #04,#f1,#d6,#e5,#82,#90,#eb
	db #07,#00,#00,#90,#75
	db #05,#00,#e4,#5f,#01
	db #05,#00,#e3,#ad,#00
	db #20
	db #04,#00,#e5,#82,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#90,#b0
	db #05,#00,#e3,#ad,#00
	db #07,#00,#e4,#e8,#01
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e4,#5f,#90,#d1
	db #05,#00,#e3,#ad,#00
	db #20
	db #04,#00,#e9,#d1,#90,#68
	db #07,#00,#00,#01
	db #05,#00,#e8,#bf,#00
	db #05,#00,#00,#00
	db #20
	db #04,#00,#e7,#5b,#90,#eb
	db #07,#00,#01,#00
	db #20
	db #02,#00,#e5,#82,#01
	db #05,#00,#01,#00
	db #07,#00,#e4,#5f,#00
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e3,#ad,#91,#3a
	db #05,#00,#e2,#c1,#90,#9d
	db #20
	db #04,#f3,#ad,#e4,#5f,#01
	db #07,#00,#00,#00
	db #40
	db #04,#f3,#46,#e7,#5b,#91,#17
	db #05,#00,#e5,#82,#90,#8b
	db #20
	db #04,#f2,#74,#01,#00
	db #07,#00,#00,#01
	db #05,#00,#00,#00
	db #05,#00,#00,#00
	db #20
	db #04,#f2,#2f,#e4,#5f,#91,#17
	db #07,#00,#00,#90,#8b
	db #05,#00,#e3,#ad,#01
	db #05,#00,#e2,#c1,#00
	db #20
	db #04,#00,#e5,#82,#00
	db #07,#00,#00,#00
	db #05,#00,#e4,#5f,#90,#d1
	db #05,#00,#e3,#ad,#00
	db #07,#00,#e4,#e8,#01
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#90,#f9
	db #05,#00,#e3,#ad,#00
	db #60
	db #06,#00,#e4,#e8,#01
	db #07,#00,#00,#00
	db #05,#00,#e4,#5f,#00
	db #05,#00,#e3,#ad,#00
	db #40
	db #06,#00,#e4,#5f,#91,#17
	db #07,#00,#00,#00
	db #20
	db #02,#00,#e3,#46,#01
	db #05,#00,#e2,#c1,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #40
	db #04,#00,#00,#91,#75
	db #05,#00,#00,#00
	db #20
	db #04,#f2,#10,#e0,#b0,#01
	db #07,#00,#e0,#a6,#00
	db #05,#00,#e0,#9d,#91,#a3
	db #05,#00,#e0,#8b,#00
	db #20
	db #04,#f2,#2f,#e4,#5f,#01
	db #07,#00,#00,#00
	db #05,#00,#e3,#ad,#00
	db #05,#00,#e2,#c1,#00
	db #20
	db #04,#f2,#74,#d4,#5f,#91,#3a
	db #07,#00,#00,#90,#9d
	db #05,#00,#d3,#ad,#01
	db #05,#00,#d2,#c1,#00
	db #20
	db #04,#00,#d4,#e8,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#d3,#ad,#90,#eb
	db #05,#00,#d2,#c1,#00
	db #07,#00,#d4,#e8,#01
	db #07,#00,#00,#00
	db #60
	db #04,#00,#d3,#ad,#91,#17
	db #05,#00,#d2,#c1,#00
	db #20
	db #04,#00,#d4,#5f,#01
	db #07,#00,#00,#00
	db #05,#00,#d3,#ad,#00
	db #05,#00,#d2,#c1,#00
	db #20
	db #04,#00,#d5,#82,#91,#3a
	db #07,#00,#00,#00
	db #20
	db #02,#00,#e5,#82,#01
	db #05,#00,#00,#00
	db #07,#00,#f5,#82,#00
	db #07,#00,#00,#00
	db #40
	db #04,#00,#f4,#5f,#91,#a3
	db #05,#00,#f3,#ad,#00
	db #07,#00,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#00,#00,#91,#75
	db #05,#00,#00,#00
	db #20
	db #04,#00,#00,#01
	db #07,#00,#00,#00
	db #05,#00,#00,#00
	db #05,#00,#00,#00
	db #20
	db #04,#f2,#2f,#90,#75,#91,#17
	db #07,#00,#01,#90,#8b
	db #05,#00,#e4,#5f,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e3,#ad,#90,#d1
	db #05,#00,#00,#90,#68
	db #07,#00,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e5,#82,#90,#f9
	db #05,#00,#01,#90,#7c
	db #20
	db #04,#00,#e6,#8d,#01
	db #07,#00,#00,#00
	db #05,#00,#e7,#5b,#00
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#91,#17
	db #07,#00,#00,#00
	db #20
	db #02,#00,#e6,#8d,#01
	db #05,#00,#00,#00
	db #07,#f2,#10,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#f2,#2f,#e4,#e8,#91,#75
	db #05,#00,#00,#00
	db #07,#f2,#74,#01,#01
	db #07,#00,#00,#00
	db #60
	db #04,#f2,#2f,#00,#91,#a3
	db #05,#00,#00,#00
	db #20
	db #04,#f2,#10,#b0,#b0,#01
	db #07,#00,#b0,#a6,#00
	db #20
	db #02,#f2,#74,#b0,#9d,#00
	db #05,#00,#b0,#8b,#00
	db #20
	db #04,#b7,#5b,#e4,#e8,#91,#3a
	db #07,#00,#e2,#74,#90,#9d
	db #05,#b5,#d6,#90,#9d,#01
	db #05,#b4,#e8,#00,#00
	db #20
	db #04,#b7,#5b,#f2,#74,#00
	db #07,#00,#00,#00
	db #60
	db #04,#b5,#d6,#e5,#d6,#90,#eb
	db #05,#b4,#e8,#e2,#eb,#00
	db #07,#b7,#5b,#90,#75,#01
	db #07,#00,#f2,#74,#00
	db #60
	db #04,#b5,#d6,#94,#e8,#91,#17
	db #05,#b4,#e8,#92,#74,#00
	db #20
	db #04,#b6,#8d,#00,#90,#8b
	db #07,#00,#90,#8b,#01
	db #05,#b5,#d6,#94,#e8,#00
	db #05,#b4,#e8,#f2,#74,#00
	db #20
	db #04,#e6,#8d,#b6,#8d,#91,#3a
	db #07,#00,#b3,#46,#00
	db #20
	db #02,#e5,#d6,#b5,#d6,#01
	db #05,#00,#b2,#eb,#00
	db #07,#f2,#74,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e4,#e8,#91,#a3
	db #05,#00,#e2,#74,#90,#d1
	db #20
	db #04,#b5,#d6,#90,#d1,#01
	db #07,#00,#00,#00
	db #40
	db #04,#b4,#e8,#93,#ad,#91,#75
	db #05,#b3,#ad,#91,#d6,#90,#ba
	db #20
	db #04,#95,#d6,#94,#5f,#00
	db #07,#00,#92,#2f,#01
	db #05,#99,#d1,#f2,#74,#00
	db #05,#97,#5b,#00,#00
	db #20
	db #04,#f2,#c1,#92,#74,#91,#3a
	db #07,#00,#00,#90,#9d
	db #05,#00,#90,#9d,#01
	db #05,#00,#00,#00
	db #20
	db #04,#95,#d6,#f2,#c1,#00
	db #07,#00,#00,#00
	db #60
	db #04,#94,#e8,#e2,#eb,#90,#eb
	db #05,#93,#ad,#00,#00
	db #07,#97,#5b,#f2,#c1,#01
	db #07,#00,#00,#00
	db #40
	db #04,#95,#d6,#e2,#74,#91,#17
	db #05,#94,#e8,#00,#00
	db #20
	db #04,#96,#8d,#f2,#c1,#01
	db #07,#00,#00,#00
	db #05,#95,#d6,#e4,#e8,#00
	db #05,#94,#e8,#f2,#c1,#00
	db #20
	db #04,#96,#8d,#e3,#46,#91,#3a
	db #07,#00,#00,#00
	db #20
	db #02,#95,#d6,#e2,#eb,#01
	db #05,#94,#e8,#00,#00
	db #07,#95,#d6,#f2,#c1,#00
	db #07,#00,#00,#00
	db #40
	db #04,#94,#5f,#e2,#74,#91,#a3
	db #05,#93,#ad,#00,#00
	db #20
	db #04,#00,#f2,#c1,#01
	db #07,#00,#00,#00
	db #05,#00,#e1,#d6,#91,#d6
	db #05,#00,#00,#00
	db #60
	db #06,#90,#eb,#e2,#2f,#01
	db #07,#90,#de,#00,#00
	db #05,#90,#d1,#00,#00
	db #05,#90,#ba,#e2,#51,#00
	db #20
	db #04,#d5,#d6,#e4,#e8,#91,#3a
	db #07,#00,#e2,#74,#90,#9d
	db #05,#d4,#e8,#90,#9d,#01
	db #05,#d3,#ad,#00,#00
	db #20
	db #04,#d5,#d6,#f2,#eb,#00
	db #07,#00,#00,#00
	db #40
	db #04,#d4,#e8,#e5,#d6,#90,#eb
	db #05,#d3,#ad,#e2,#eb,#00
	db #07,#d5,#d6,#f2,#eb,#01
	db #07,#00,#00,#00
	db #40
	db #04,#d4,#e8,#e4,#e8,#91,#17
	db #05,#d3,#ad,#e2,#74,#00
	db #20
	db #04,#d6,#8d,#00,#01
	db #07,#00,#f2,#eb,#00
	db #05,#d4,#e8,#e4,#e8,#00
	db #05,#d3,#ad,#f2,#eb,#00
	db #20
	db #04,#d6,#8d,#e6,#8d,#91,#3a
	db #07,#00,#e3,#46,#00
	db #20
	db #02,#d4,#e8,#e5,#d6,#01
	db #05,#d3,#ad,#e2,#eb,#00
	db #07,#d5,#d6,#f2,#eb,#00
	db #07,#00,#00,#00
	db #60
	db #04,#d4,#e8,#e4,#e8,#91,#a3
	db #05,#d3,#ad,#e2,#74,#00
	db #07,#d7,#5b,#f2,#eb,#01
	db #07,#00,#00,#00
	db #60
	db #04,#e7,#5b,#e3,#ad,#91,#75
	db #05,#00,#e1,#d6,#00
	db #20
	db #04,#f7,#5b,#e4,#5f,#01
	db #07,#00,#e2,#2f,#00
	db #05,#00,#f2,#eb,#00
	db #05,#00,#00,#00
	db #20
	db #04,#00,#e2,#74,#91,#3a
	db #07,#00,#00,#90,#9d
	db #05,#00,#90,#9d,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#f2,#c1,#00
	db #07,#f5,#d6,#00,#00
	db #40
	db #04,#00,#e2,#eb,#90,#eb
	db #05,#00,#00,#90,#75
	db #07,#f2,#c1,#90,#75,#01
	db #07,#00,#00,#00
	db #40
	db #04,#b4,#e8,#e2,#74,#91,#17
	db #05,#00,#00,#90,#8b
	db #20
	db #04,#f2,#c1,#90,#8b,#01
	db #07,#00,#00,#00
	db #05,#b7,#5b,#e4,#e8,#00
	db #05,#01,#f2,#c1,#00
	db #20
	db #04,#b6,#8d,#e3,#46,#91,#3a
	db #07,#00,#00,#00
	db #20
	db #02,#b7,#5b,#e3,#ad,#01
	db #05,#00,#00,#00
	db #07,#01,#f2,#c1,#00
	db #07,#00,#00,#00
	db #60
	db #04,#b6,#8d,#e3,#46,#91,#a3
	db #05,#00,#00,#00
	db #07,#01,#f2,#c1,#01
	db #07,#00,#00,#00
	db #60
	db #04,#b7,#5b,#e1,#d6,#91,#d6
	db #05,#00,#00,#00
	db #20
	db #04,#b0,#eb,#e2,#2f,#01
	db #07,#b0,#de,#00,#00
	db #40
	db #04,#b0,#d1,#00,#00
	db #40
	db #04,#b0,#ba,#e2,#74,#00
	db #20
	db #04,#b8,#41,#e5,#82,#91,#60
	db #07,#00,#e2,#c1,#90,#b0
	db #05,#b6,#8d,#90,#b0,#01
	db #05,#b5,#82,#00,#00
	db #20
	db #04,#b8,#41,#f2,#c1,#00
	db #07,#00,#00,#00
	db #60
	db #04,#b6,#8d,#e6,#8d,#91,#08
	db #05,#b5,#82,#e3,#46,#00
	db #07,#b8,#41,#90,#84,#01
	db #07,#00,#f2,#c1,#00
	db #60
	db #04,#b6,#8d,#95,#82,#91,#3a
	db #05,#b5,#82,#92,#c1,#00
	db #20
	db #04,#b7,#5b,#00,#90,#9d
	db #07,#00,#90,#9d,#01
	db #05,#b6,#8d,#95,#82,#00
	db #05,#b5,#82,#f2,#c1,#00
	db #20
	db #04,#e7,#5b,#b7,#5b,#91,#60
	db #07,#00,#b3,#ad,#00
	db #20
	db #02,#e6,#8d,#b6,#8d,#01
	db #05,#00,#b3,#46,#00
	db #07,#f2,#c1,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e5,#82,#91,#d6
	db #05,#00,#e2,#c1,#90,#eb
	db #20
	db #04,#b6,#8d,#90,#eb,#01
	db #07,#00,#00,#00
	db #40
	db #04,#b5,#82,#94,#20,#91,#a3
	db #05,#b4,#20,#92,#10,#90,#d1
	db #20
	db #04,#96,#8d,#94,#e8,#00
	db #07,#00,#92,#74,#01
	db #05,#9b,#05,#f2,#c1,#00
	db #05,#98,#41,#00,#00
	db #20
	db #04,#f3,#17,#92,#c1,#91,#60
	db #07,#00,#00,#90,#b0
	db #05,#00,#90,#b0,#01
	db #05,#00,#00,#00
	db #20
	db #04,#96,#8d,#f3,#17,#00
	db #07,#00,#00,#00
	db #60
	db #04,#95,#82,#e3,#46,#91,#08
	db #05,#94,#20,#00,#00
	db #07,#98,#41,#f3,#17,#01
	db #07,#00,#00,#00
	db #60
	db #04,#96,#8d,#e2,#c1,#91,#3a
	db #05,#95,#82,#00,#00
	db #20
	db #04,#97,#5b,#f3,#17,#01
	db #07,#00,#00,#00
	db #05,#96,#8d,#e5,#82,#00
	db #05,#95,#82,#f3,#17,#00
	db #20
	db #04,#97,#5b,#e3,#ad,#91,#60
	db #07,#00,#00,#00
	db #20
	db #02,#96,#8d,#e3,#46,#01
	db #05,#95,#82,#00,#00
	db #07,#96,#8d,#f3,#17,#00
	db #07,#00,#00,#00
	db #40
	db #04,#94,#e8,#e2,#c1,#91,#d6
	db #05,#94,#20,#00,#00
	db #20
	db #04,#00,#f3,#17,#01
	db #07,#00,#00,#00
	db #05,#00,#e2,#10,#92,#10
	db #05,#00,#00,#00
	db #60
	db #06,#91,#08,#e2,#74,#01
	db #07,#90,#f9,#00,#00
	db #05,#90,#eb,#00,#00
	db #05,#90,#d1,#e2,#99,#00
	db #20
	db #04,#d6,#8d,#e5,#82,#91,#60
	db #07,#00,#e2,#c1,#90,#b0
	db #05,#d5,#82,#90,#b0,#01
	db #05,#d4,#20,#00,#00
	db #20
	db #04,#d6,#8d,#f3,#46,#00
	db #07,#00,#00,#00
	db #40
	db #04,#d5,#82,#e6,#8d,#91,#08
	db #05,#d4,#20,#e3,#46,#00
	db #07,#d6,#8d,#f3,#46,#01
	db #07,#00,#00,#00
	db #60
	db #04,#d5,#82,#e5,#82,#91,#3a
	db #05,#d4,#20,#e2,#c1,#00
	db #20
	db #04,#d7,#5b,#00,#01
	db #07,#00,#f3,#46,#00
	db #05,#d5,#82,#e5,#82,#00
	db #05,#d4,#20,#f3,#46,#00
	db #20
	db #04,#d7,#5b,#e7,#5b,#91,#60
	db #07,#00,#e3,#ad,#00
	db #20
	db #02,#d5,#82,#e6,#8d,#01
	db #05,#d4,#20,#e3,#46,#00
	db #07,#d6,#8d,#f3,#46,#00
	db #07,#00,#00,#00
	db #60
	db #04,#d5,#82,#e5,#82,#91,#d6
	db #05,#d4,#20,#e2,#c1,#00
	db #07,#db,#05,#f3,#46,#01
	db #07,#00,#00,#00
	db #40
	db #04,#eb,#05,#e4,#20,#91,#a3
	db #05,#00,#e2,#10,#00
	db #20
	db #04,#fb,#05,#e4,#e8,#01
	db #07,#00,#e2,#74,#00
	db #05,#00,#f3,#46,#00
	db #05,#00,#00,#00
	db #20
	db #04,#00,#e2,#c1,#91,#60
	db #07,#00,#00,#90,#b0
	db #05,#00,#90,#b0,#01
	db #05,#00,#00,#00
	db #20
	db #04,#f8,#41,#f3,#17,#00
	db #07,#f6,#8d,#00,#00
	db #60
	db #04,#00,#e3,#46,#91,#08
	db #05,#00,#00,#90,#84
	db #07,#f3,#17,#90,#84,#01
	db #07,#00,#00,#00
	db #60
	db #04,#b5,#82,#e2,#c1,#91,#3a
	db #05,#00,#00,#90,#9d
	db #20
	db #04,#f3,#17,#90,#9d,#01
	db #07,#00,#00,#00
	db #05,#b8,#41,#e5,#82,#00
	db #05,#01,#f3,#17,#00
	db #20
	db #04,#b9,#d1,#e3,#ad,#91,#60
	db #07,#00,#00,#00
	db #20
	db #02,#bb,#05,#e4,#20,#01
	db #05,#00,#00,#00
	db #07,#01,#f3,#17,#00
	db #07,#00,#00,#00
	db #40
	db #04,#b9,#d1,#e3,#ad,#91,#d6
	db #05,#00,#00,#00
	db #07,#01,#f3,#17,#01
	db #07,#00,#00,#00
	db #40
	db #04,#bb,#05,#e2,#10,#92,#10
	db #05,#00,#00,#00
	db #20
	db #04,#b1,#08,#e2,#74,#01
	db #07,#b0,#f9,#00,#00
	db #20
	db #02,#b0,#eb,#00,#00
	db #05,#b0,#d1,#e2,#99,#00
	db #20
	db #04,#01,#e3,#ad,#90,#eb
	db #07,#00,#e1,#d6,#90,#75
	db #05,#00,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#00,#e4,#5f,#90,#b0
	db #05,#00,#e2,#2f,#00
	db #07,#00,#90,#58,#01
	db #07,#00,#01,#00
	db #60
	db #04,#00,#93,#ad,#90,#d1
	db #05,#00,#91,#d6,#00
	db #20
	db #04,#00,#00,#90,#68
	db #07,#00,#90,#68,#01
	db #05,#00,#93,#ad,#00
	db #05,#00,#01,#00
	db #20
	db #04,#00,#b4,#e8,#90,#eb
	db #07,#00,#b2,#74,#00
	db #20
	db #02,#00,#b4,#5f,#01
	db #05,#00,#b2,#2f,#00
	db #07,#00,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#00,#e3,#ad,#91,#3a
	db #05,#00,#e1,#d6,#90,#9d
	db #20
	db #04,#00,#90,#9d,#01
	db #07,#00,#00,#00
	db #40
	db #04,#00,#92,#c1,#91,#17
	db #05,#00,#91,#60,#90,#8b
	db #20
	db #04,#00,#93,#46,#00
	db #07,#00,#91,#a3,#01
	db #05,#00,#01,#00
	db #05,#00,#00,#00
	db #20
	db #04,#e3,#ad,#e7,#5b,#90,#eb
	db #07,#e1,#d6,#e3,#ad,#90,#75
	db #05,#90,#75,#01,#01
	db #05,#00,#00,#00
	db #20
	db #04,#01,#00,#00
	db #07,#00,#00,#00
	db #60
	db #04,#e4,#5f,#e8,#bf,#90,#b0
	db #05,#e2,#2f,#e4,#5f,#00
	db #07,#90,#58,#01,#01
	db #07,#01,#00,#00
	db #60
	db #04,#93,#ad,#97,#5b,#90,#d1
	db #05,#91,#d6,#93,#ad,#00
	db #20
	db #04,#00,#00,#90,#68
	db #07,#90,#68,#01,#01
	db #05,#93,#ad,#97,#5b,#00
	db #05,#01,#01,#00
	db #20
	db #04,#b4,#e8,#b9,#d1,#90,#eb
	db #07,#b2,#74,#b4,#e8,#00
	db #20
	db #02,#b4,#5f,#b8,#bf,#01
	db #05,#b2,#2f,#b4,#5f,#00
	db #07,#01,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#e3,#ad,#e7,#5b,#91,#3a
	db #05,#e1,#d6,#e3,#ad,#90,#9d
	db #20
	db #04,#90,#9d,#01,#01
	db #07,#00,#00,#00
	db #40
	db #04,#92,#c1,#95,#82,#91,#17
	db #05,#91,#60,#92,#c1,#90,#8b
	db #20
	db #04,#93,#46,#96,#8d,#00
	db #07,#91,#a3,#93,#46,#01
	db #05,#01,#01,#00
	db #05,#00,#00,#00
	db #20
	db #04,#eb,#05,#e3,#ad,#90,#eb
	db #07,#e5,#82,#e1,#d6,#90,#75
	db #05,#01,#90,#75,#01
	db #05,#00,#00,#00
	db #20
	db #04,#00,#01,#00
	db #07,#00,#00,#00
	db #60
	db #04,#ed,#1b,#e4,#5f,#90,#b0
	db #05,#e6,#8d,#e2,#2f,#00
	db #07,#01,#90,#58,#01
	db #07,#00,#01,#00
	db #60
	db #04,#eb,#05,#93,#ad,#90,#d1
	db #05,#e5,#82,#91,#d6,#00
	db #20
	db #04,#01,#00,#90,#68
	db #07,#00,#90,#68,#01
	db #05,#eb,#05,#93,#ad,#00
	db #05,#01,#01,#00
	db #20
	db #04,#ee,#b6,#b4,#e8,#90,#eb
	db #07,#e7,#5b,#b2,#74,#00
	db #20
	db #02,#ed,#1b,#b4,#5f,#01
	db #05,#e6,#8d,#b2,#2f,#00
	db #07,#01,#01,#00
	db #07,#00,#00,#00
	db #40
	db #04,#eb,#05,#e3,#ad,#91,#3a
	db #05,#e5,#82,#e1,#d6,#90,#9d
	db #20
	db #04,#01,#90,#9d,#01
	db #07,#00,#00,#00
	db #40
	db #04,#e8,#41,#92,#c1,#91,#17
	db #05,#e4,#20,#91,#60,#90,#8b
	db #20
	db #04,#e9,#d1,#93,#46,#00
	db #07,#e4,#e8,#91,#a3,#01
	db #05,#01,#01,#00
	db #05,#00,#00,#00
	db #20
	db #04,#eb,#05,#e3,#ad,#90,#eb
	db #07,#e5,#82,#e1,#d6,#90,#75
	db #05,#01,#90,#75,#01
	db #05,#00,#00,#00
	db #07,#e0,#75,#01,#00
	db #07,#00,#00,#00
	db #05,#e0,#58,#00,#00
	db #05,#e0,#4e,#00,#00
	db #07,#e0,#3a,#00,#00
	db #07,#01,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #07,#00,#00,#00
	db #00
	dw .loop
.drum0
	db 0,0,0,0,0,0,248,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,255,255,255,255,255,255,255,255,255,255
.drum1
	db 150,2,0,130,0,4,136,49,132,95,0,61,39,0,0,0,0,131,220,66,0,0,0,4,96,0,1,0,0,128,0,2
.drum2
	db 0,128,7,16,0,0,0,28,0,0,0,30,56,0,0,7,112,0,0,0,0,16,0,4,0,0,0,0,12,0,224,0
.drum3
.drum4
.drum5
.drum6
